import{s as Bs,n as Zs,o as Gs}from"../chunks/scheduler.0219f8bd.js";import{S as Cs,i as ks,g as p,s as t,r as o,A as Ws,h as i,f as a,c as n,j as fs,u as c,x as r,k as Is,y as $s,a as e,v as J,d as M,t as h,w as T}from"../chunks/index.f61edf3b.js";import{C as hs}from"../chunks/CodeBlock.38e566ae.js";import{H as v,E as Rs}from"../chunks/EditOnGithub.48fa589f.js";function Qs(Ts){let w,H,X,F,d,_,u,rs="Official utilities to use the Hugging Face Hub API.",A,j,S,y,x,m,z,U,L,b,q,g,ws='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',P,f,ds='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',D,I,K,B,O,Z,us='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',ss,G,js="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ls,C,as,k,ys='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',es,W,ts,$,ms="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",ns,R,Us="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",ps,Q,bs="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",is,E,os,N,gs="<li><code>hash-wasm</code> : Only used in the browser, when committing files over 10 MB. Browsers do not natively support streaming sha256 computations.</li> <li><code>@huggingface/tasks</code> : Typings only</li>",cs,V,Js,Y,Ms;return d=new v({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),j=new v({props:{title:"Install",local:"install",headingTag:"h2"}}),y=new hs({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),m=new v({props:{title:"Deno",local:"deno",headingTag:"h3"}}),U=new hs({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),b=new v({props:{title:"Usage",local:"usage",headingTag:"h2"}}),I=new hs({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, uploadFilesWithProgress, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };
<span class="hljs-keyword">const</span> <span class="hljs-attr">credentials</span>: <span class="hljs-title class_">Credentials</span> = { <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({credentials});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, credentials})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, credentials, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, credentials, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, credentials });`,wrap:!1}}),B=new v({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),C=new hs({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),W=new v({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),E=new v({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),V=new Rs({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){w=p("meta"),H=t(),X=p("p"),F=t(),o(d.$$.fragment),_=t(),u=p("p"),u.textContent=rs,A=t(),o(j.$$.fragment),S=t(),o(y.$$.fragment),x=t(),o(m.$$.fragment),z=t(),o(U.$$.fragment),L=t(),o(b.$$.fragment),q=t(),g=p("p"),g.innerHTML=ws,P=t(),f=p("p"),f.innerHTML=ds,D=t(),o(I.$$.fragment),K=t(),o(B.$$.fragment),O=t(),Z=p("p"),Z.innerHTML=us,ss=t(),G=p("p"),G.textContent=js,ls=t(),o(C.$$.fragment),as=t(),k=p("p"),k.innerHTML=ys,es=t(),o(W.$$.fragment),ts=t(),$=p("p"),$.innerHTML=ms,ns=t(),R=p("p"),R.innerHTML=Us,ps=t(),Q=p("p"),Q.innerHTML=bs,is=t(),o(E.$$.fragment),os=t(),N=p("ul"),N.innerHTML=gs,cs=t(),o(V.$$.fragment),Js=t(),Y=p("p"),this.h()},l(s){const l=Ws("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(a),H=n(s),X=i(s,"P",{}),fs(X).forEach(a),F=n(s),c(d.$$.fragment,s),_=n(s),u=i(s,"P",{"data-svelte-h":!0}),r(u)!=="svelte-a2asrt"&&(u.textContent=rs),A=n(s),c(j.$$.fragment,s),S=n(s),c(y.$$.fragment,s),x=n(s),c(m.$$.fragment,s),z=n(s),c(U.$$.fragment,s),L=n(s),c(b.$$.fragment,s),q=n(s),g=i(s,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1nqczoz"&&(g.innerHTML=ws),P=n(s),f=i(s,"P",{"data-svelte-h":!0}),r(f)!=="svelte-6ptpin"&&(f.innerHTML=ds),D=n(s),c(I.$$.fragment,s),K=n(s),c(B.$$.fragment,s),O=n(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-bfok93"&&(Z.innerHTML=us),ss=n(s),G=i(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1az135e"&&(G.textContent=js),ls=n(s),c(C.$$.fragment,s),as=n(s),k=i(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1qsa6tj"&&(k.innerHTML=ys),es=n(s),c(W.$$.fragment,s),ts=n(s),$=i(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1gspubq"&&($.innerHTML=ms),ns=n(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-em0etc"&&(R.innerHTML=Us),ps=n(s),Q=i(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-lja874"&&(Q.innerHTML=bs),is=n(s),c(E.$$.fragment,s),os=n(s),N=i(s,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-14y1lr2"&&(N.innerHTML=gs),cs=n(s),c(V.$$.fragment,s),Js=n(s),Y=i(s,"P",{}),fs(Y).forEach(a),this.h()},h(){Is(w,"name","hf:doc:metadata"),Is(w,"content",Es)},m(s,l){$s(document.head,w),e(s,H,l),e(s,X,l),e(s,F,l),J(d,s,l),e(s,_,l),e(s,u,l),e(s,A,l),J(j,s,l),e(s,S,l),J(y,s,l),e(s,x,l),J(m,s,l),e(s,z,l),J(U,s,l),e(s,L,l),J(b,s,l),e(s,q,l),e(s,g,l),e(s,P,l),e(s,f,l),e(s,D,l),J(I,s,l),e(s,K,l),J(B,s,l),e(s,O,l),e(s,Z,l),e(s,ss,l),e(s,G,l),e(s,ls,l),J(C,s,l),e(s,as,l),e(s,k,l),e(s,es,l),J(W,s,l),e(s,ts,l),e(s,$,l),e(s,ns,l),e(s,R,l),e(s,ps,l),e(s,Q,l),e(s,is,l),J(E,s,l),e(s,os,l),e(s,N,l),e(s,cs,l),J(V,s,l),e(s,Js,l),e(s,Y,l),Ms=!0},p:Zs,i(s){Ms||(M(d.$$.fragment,s),M(j.$$.fragment,s),M(y.$$.fragment,s),M(m.$$.fragment,s),M(U.$$.fragment,s),M(b.$$.fragment,s),M(I.$$.fragment,s),M(B.$$.fragment,s),M(C.$$.fragment,s),M(W.$$.fragment,s),M(E.$$.fragment,s),M(V.$$.fragment,s),Ms=!0)},o(s){h(d.$$.fragment,s),h(j.$$.fragment,s),h(y.$$.fragment,s),h(m.$$.fragment,s),h(U.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h(B.$$.fragment,s),h(C.$$.fragment,s),h(W.$$.fragment,s),h(E.$$.fragment,s),h(V.$$.fragment,s),Ms=!1},d(s){s&&(a(H),a(X),a(F),a(_),a(u),a(A),a(S),a(x),a(z),a(L),a(q),a(g),a(P),a(f),a(D),a(K),a(O),a(Z),a(ss),a(G),a(ls),a(as),a(k),a(es),a(ts),a($),a(ns),a(R),a(ps),a(Q),a(is),a(os),a(N),a(cs),a(Js),a(Y)),a(w),T(d,s),T(j,s),T(y,s),T(m,s),T(U,s),T(b,s),T(I,s),T(B,s),T(C,s),T(W,s),T(E,s),T(V,s)}}}const Es='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Ns(Ts){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Cs{constructor(w){super(),ks(this,w,Ns,Qs,Bs,{})}}export{Hs as component};
