import{s as Cs,n as Zs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Bs,g as p,s as a,r as m,A as Ns,h as i,f as l,c as n,j as fs,u as o,x as J,k as Is,y as xs,a as e,v as M,d as c,t as r,w as h}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as Y,E as Gs}from"../chunks/EditOnGithub.b65eee75.js";function Ws(hs){let y,X,V,S,j,_,w,Js='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifier</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',z,T,H,g,ys="To load a pretrained model:",F,d,L,u,js="To load and preprocess the image:",D,U,q,b,ws="To get the model predictions:",P,f,K,I,Ts="To get the top-5 predictions class names:",O,C,ss,Z,gs="Replace the model name with the variant you want to use, e.g. <code>inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",ts,$,ds='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,k,es,B,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,N,ns,x,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,G,is,W,bs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ms,v,os,E,Ms,A,cs,R,rs;return j=new Y({props:{title:"Inception v3",local:"inception-v3",headingTag:"h1"}}),T=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),d=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3YzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZTemVnZWR5VklTVzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpbmNlbnQlMjBWYW5ob3Vja2UlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZXJnZXklMjBJb2ZmZSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWmJpZ25pZXclMjBXb2puYSU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCUmV0aGlua2luZyUyMHRoZSUyMEluY2VwdGlvbiUyMEFyY2hpdGVjdHVyZSUyMGZvciUyMENvbXB1dGVyJTIwVmlzaW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxNTEyLjAwNTY3JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTUlN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTUxMi4wMDU2NyU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE1MTIuMDA1NjclN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAxMyUyMEF1ZyUyMDIwMTglMjAxNiUzQTQ5JTNBMDclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRlN6ZWdlZHlWSVNXMTUuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15,
  author    = {Christian Szegedy and
               Vincent Vanhoucke and
               Sergey Ioffe and
               Jonathon Shlens and
               Zbigniew Wojna},
  title     = {Rethinking the Inception Architecture <span class="hljs-keyword">for</span> Computer Vision},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.00567</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.00567</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.00567</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">49</span>:<span class="hljs-number">07</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),A=new Gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/inception-v3.mdx"}}),{c(){y=p("meta"),X=a(),V=p("p"),S=a(),m(j.$$.fragment),_=a(),w=p("p"),w.innerHTML=Js,z=a(),m(T.$$.fragment),H=a(),g=p("p"),g.textContent=ys,F=a(),m(d.$$.fragment),L=a(),u=p("p"),u.textContent=js,D=a(),m(U.$$.fragment),q=a(),b=p("p"),b.textContent=ws,P=a(),m(f.$$.fragment),K=a(),I=p("p"),I.textContent=Ts,O=a(),m(C.$$.fragment),ss=a(),Z=p("p"),Z.innerHTML=gs,ts=a(),$=p("p"),$.innerHTML=ds,ls=a(),m(k.$$.fragment),es=a(),B=p("p"),B.textContent=us,as=a(),m(N.$$.fragment),ns=a(),x=p("p"),x.innerHTML=Us,ps=a(),m(G.$$.fragment),is=a(),W=p("p"),W.innerHTML=bs,ms=a(),m(v.$$.fragment),os=a(),m(E.$$.fragment),Ms=a(),m(A.$$.fragment),cs=a(),R=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(l),X=n(s),V=i(s,"P",{}),fs(V).forEach(l),S=n(s),o(j.$$.fragment,s),_=n(s),w=i(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-1oyeygh"&&(w.innerHTML=Js),z=n(s),o(T.$$.fragment,s),H=n(s),g=i(s,"P",{"data-svelte-h":!0}),J(g)!=="svelte-18ywhxh"&&(g.textContent=ys),F=n(s),o(d.$$.fragment,s),L=n(s),u=i(s,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1c2ipa8"&&(u.textContent=js),D=n(s),o(U.$$.fragment,s),q=n(s),b=i(s,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1n9qsq1"&&(b.textContent=ws),P=n(s),o(f.$$.fragment,s),K=n(s),I=i(s,"P",{"data-svelte-h":!0}),J(I)!=="svelte-19cnvx1"&&(I.textContent=Ts),O=n(s),o(C.$$.fragment,s),ss=n(s),Z=i(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-fzq2q9"&&(Z.innerHTML=gs),ts=n(s),$=i(s,"P",{"data-svelte-h":!0}),J($)!=="svelte-1wmi3ea"&&($.innerHTML=ds),ls=n(s),o(k.$$.fragment,s),es=n(s),B=i(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-9sr7nh"&&(B.textContent=us),as=n(s),o(N.$$.fragment,s),ns=n(s),x=i(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1kguc51"&&(x.innerHTML=Us),ps=n(s),o(G.$$.fragment,s),is=n(s),W=i(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-xtxxu6"&&(W.innerHTML=bs),ms=n(s),o(v.$$.fragment,s),os=n(s),o(E.$$.fragment,s),Ms=n(s),o(A.$$.fragment,s),cs=n(s),R=i(s,"P",{}),fs(R).forEach(l),this.h()},h(){Is(y,"name","hf:doc:metadata"),Is(y,"content",vs)},m(s,t){xs(document.head,y),e(s,X,t),e(s,V,t),e(s,S,t),M(j,s,t),e(s,_,t),e(s,w,t),e(s,z,t),M(T,s,t),e(s,H,t),e(s,g,t),e(s,F,t),M(d,s,t),e(s,L,t),e(s,u,t),e(s,D,t),M(U,s,t),e(s,q,t),e(s,b,t),e(s,P,t),M(f,s,t),e(s,K,t),e(s,I,t),e(s,O,t),M(C,s,t),e(s,ss,t),e(s,Z,t),e(s,ts,t),e(s,$,t),e(s,ls,t),M(k,s,t),e(s,es,t),e(s,B,t),e(s,as,t),M(N,s,t),e(s,ns,t),e(s,x,t),e(s,ps,t),M(G,s,t),e(s,is,t),e(s,W,t),e(s,ms,t),M(v,s,t),e(s,os,t),M(E,s,t),e(s,Ms,t),M(A,s,t),e(s,cs,t),e(s,R,t),rs=!0},p:Zs,i(s){rs||(c(j.$$.fragment,s),c(T.$$.fragment,s),c(d.$$.fragment,s),c(U.$$.fragment,s),c(f.$$.fragment,s),c(C.$$.fragment,s),c(k.$$.fragment,s),c(N.$$.fragment,s),c(G.$$.fragment,s),c(v.$$.fragment,s),c(E.$$.fragment,s),c(A.$$.fragment,s),rs=!0)},o(s){r(j.$$.fragment,s),r(T.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r(f.$$.fragment,s),r(C.$$.fragment,s),r(k.$$.fragment,s),r(N.$$.fragment,s),r(G.$$.fragment,s),r(v.$$.fragment,s),r(E.$$.fragment,s),r(A.$$.fragment,s),rs=!1},d(s){s&&(l(X),l(V),l(S),l(_),l(w),l(z),l(H),l(g),l(F),l(L),l(u),l(D),l(q),l(b),l(P),l(K),l(I),l(O),l(ss),l(Z),l(ts),l($),l(ls),l(es),l(B),l(as),l(ns),l(x),l(ps),l(is),l(W),l(ms),l(os),l(Ms),l(cs),l(R)),l(y),h(j,s),h(T,s),h(d,s),h(U,s),h(f,s),h(C,s),h(k,s),h(N,s),h(G,s),h(v,s),h(E,s),h(A,s)}}}const vs='{"title":"Inception v3","local":"inception-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Es(hs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends ks{constructor(y){super(),Bs(this,y,Es,Ws,Cs,{})}}export{Ys as component};
