import{s as Zt,n as xt,o as It}from"../chunks/scheduler.85c25b89.js";import{S as Ct,i as Wt,g as p,s as a,r as i,A as kt,h as m,f as l,c as n,j as Ut,u as o,x as g,k as $t,y as Bt,a as e,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as Nt}from"../chunks/getInferenceSnippets.2d2e232c.js";function Gt(Mt){let j,_,Q,A,d,z,J,gt='<strong>Rank Expansion Networks</strong> (ReXNets) follow a set of new design principles for designing bottlenecks in image classification models. Authors refine each layer by 1) expanding the input channel size of the convolution layer and 2) replacing the <a href="https://www.paperswithcode.com/method/relu6" rel="nofollow">ReLU6s</a>.',H,w,S,u,jt="To load a pretrained model:",F,y,L,b,dt="To load and preprocess the image:",D,f,q,T,Jt="To get the model predictions:",P,U,K,$,wt="To get the top-5 predictions class names:",O,Z,tt,x,ut="Replace the model name with the variant you want to use, e.g. <code>rexnet_100</code>. You can find the IDs in the model summaries at the top of this page.",st,I,yt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,C,et,W,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,k,nt,B,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,N,mt,G,Tt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',it,v,ot,E,rt,X,ct,V,ht;return d=new Y({props:{title:"RexNet",local:"rexnet",headingTag:"h1"}}),w=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JleG5ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmV4bmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new R({props:{code:"JTQwbWlzYyU3QmhhbjIwMjByZXhuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlJlWE5ldCUzQSUyMERpbWluaXNoaW5nJTIwUmVwcmVzZW50YXRpb25hbCUyMEJvdHRsZW5lY2slMjBvbiUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRG9uZ3lvb24lMjBIYW4lMjBhbmQlMjBTYW5nZG9vJTIwWXVuJTIwYW5kJTIwQnllb25naG8lMjBIZW8lMjBhbmQlMjBZb3VuZ0pvb24lMjBZb28lN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIwMDcuMDA5OTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{han2020rexnet,
      title={ReXNet: Diminishing Representational Bottleneck on Convolutional Neural Network}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Dongyoon Han and Sangdoo Yun and Byeongho Heo and YoungJoon Yoo}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2007.00992}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),X=new Nt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/rexnet.mdx"}}),{c(){j=p("meta"),_=a(),Q=p("p"),A=a(),i(d.$$.fragment),z=a(),J=p("p"),J.innerHTML=gt,H=a(),i(w.$$.fragment),S=a(),u=p("p"),u.textContent=jt,F=a(),i(y.$$.fragment),L=a(),b=p("p"),b.textContent=dt,D=a(),i(f.$$.fragment),q=a(),T=p("p"),T.textContent=Jt,P=a(),i(U.$$.fragment),K=a(),$=p("p"),$.textContent=wt,O=a(),i(Z.$$.fragment),tt=a(),x=p("p"),x.innerHTML=ut,st=a(),I=p("p"),I.innerHTML=yt,lt=a(),i(C.$$.fragment),et=a(),W=p("p"),W.textContent=bt,at=a(),i(k.$$.fragment),nt=a(),B=p("p"),B.innerHTML=ft,pt=a(),i(N.$$.fragment),mt=a(),G=p("p"),G.innerHTML=Tt,it=a(),i(v.$$.fragment),ot=a(),i(E.$$.fragment),rt=a(),i(X.$$.fragment),ct=a(),V=p("p"),this.h()},l(t){const s=kt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),_=n(t),Q=m(t,"P",{}),Ut(Q).forEach(l),A=n(t),o(d.$$.fragment,t),z=n(t),J=m(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-1inhb52"&&(J.innerHTML=gt),H=n(t),o(w.$$.fragment,t),S=n(t),u=m(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-18ywhxh"&&(u.textContent=jt),F=n(t),o(y.$$.fragment,t),L=n(t),b=m(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=dt),D=n(t),o(f.$$.fragment,t),q=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1n9qsq1"&&(T.textContent=Jt),P=n(t),o(U.$$.fragment,t),K=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-19cnvx1"&&($.textContent=wt),O=n(t),o(Z.$$.fragment,t),tt=n(t),x=m(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-kmyudm"&&(x.innerHTML=ut),st=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1wmi3ea"&&(I.innerHTML=yt),lt=n(t),o(C.$$.fragment,t),et=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=bt),at=n(t),o(k.$$.fragment,t),nt=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=ft),pt=n(t),o(N.$$.fragment,t),mt=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-xtxxu6"&&(G.innerHTML=Tt),it=n(t),o(v.$$.fragment,t),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(X.$$.fragment,t),ct=n(t),V=m(t,"P",{}),Ut(V).forEach(l),this.h()},h(){$t(j,"name","hf:doc:metadata"),$t(j,"content",vt)},m(t,s){Bt(document.head,j),e(t,_,s),e(t,Q,s),e(t,A,s),r(d,t,s),e(t,z,s),e(t,J,s),e(t,H,s),r(w,t,s),e(t,S,s),e(t,u,s),e(t,F,s),r(y,t,s),e(t,L,s),e(t,b,s),e(t,D,s),r(f,t,s),e(t,q,s),e(t,T,s),e(t,P,s),r(U,t,s),e(t,K,s),e(t,$,s),e(t,O,s),r(Z,t,s),e(t,tt,s),e(t,x,s),e(t,st,s),e(t,I,s),e(t,lt,s),r(C,t,s),e(t,et,s),e(t,W,s),e(t,at,s),r(k,t,s),e(t,nt,s),e(t,B,s),e(t,pt,s),r(N,t,s),e(t,mt,s),e(t,G,s),e(t,it,s),r(v,t,s),e(t,ot,s),r(E,t,s),e(t,rt,s),r(X,t,s),e(t,ct,s),e(t,V,s),ht=!0},p:xt,i(t){ht||(c(d.$$.fragment,t),c(w.$$.fragment,t),c(y.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c(Z.$$.fragment,t),c(C.$$.fragment,t),c(k.$$.fragment,t),c(N.$$.fragment,t),c(v.$$.fragment,t),c(E.$$.fragment,t),c(X.$$.fragment,t),ht=!0)},o(t){h(d.$$.fragment,t),h(w.$$.fragment,t),h(y.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(C.$$.fragment,t),h(k.$$.fragment,t),h(N.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(X.$$.fragment,t),ht=!1},d(t){t&&(l(_),l(Q),l(A),l(z),l(J),l(H),l(S),l(u),l(F),l(L),l(b),l(D),l(q),l(T),l(P),l(K),l($),l(O),l(tt),l(x),l(st),l(I),l(lt),l(et),l(W),l(at),l(nt),l(B),l(pt),l(mt),l(G),l(it),l(ot),l(rt),l(ct),l(V)),l(j),M(d,t),M(w,t),M(y,t),M(f,t),M(U,t),M(Z,t),M(C,t),M(k,t),M(N,t),M(v,t),M(E,t),M(X,t)}}}const vt='{"title":"RexNet","local":"rexnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Mt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Ct{constructor(j){super(),Wt(this,j,Et,Gt,Zt,{})}}export{Yt as component};
