import{s as ms,o as cs,n as hs}from"../chunks/scheduler.c57aa7ef.js";import{S as us,i as fs,g as o,s as l,r as p,A as gs,h as i,f as s,c as n,j as ps,u as d,x as r,k as ds,y as ys,a,v as m,d as c,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Ms}from"../chunks/Tip.9268b0ca.js";import{C as g}from"../chunks/CodeBlock.34f0a53d.js";import{H as M,E as bs}from"../chunks/EditOnGithub.958a8a49.js";function ws($e){let f,w='Starting from PEFT verion v0.12.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.';return{c(){f=o("p"),f.innerHTML=w},l(y){f=i(y,"P",{"data-svelte-h":!0}),r(f)!=="svelte-y2m5zt"&&(f.innerHTML=w)},m(y,je){a(y,f,je)},p:hs,d(y){y&&s(f)}}}function Ts($e){let f,w,y,je,T,ve,_,Ut="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",Je,j,Ze,x,Ct="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",ke,$,Wt="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",Ue,v,Bt="In general, you can update the package version by running this command inside your Python environment:",Ce,J,We,Z,Gt="Installing PEFT from source is useful for keeping up with the latest developments:",Be,k,Ge,U,Ie,C,It='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',Re,W,Fe,B,Rt='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',Xe,G,He,b,Ve,I,Le,R,Ft='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',Ee,F,Xt="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Ye,X,Pe,H,Ht="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",ze,V,Vt='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',qe,L,Ne,E,Lt='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',Qe,Y,Se,P,Ae,z,Et="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",De,q,Yt="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",Ke,N,Pt="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",Oe,Q,zt="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",et,S,tt,A,qt="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",st,D,at,K,Nt="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and also storing the embedding layer in addition to the adapter weights when saving the adapter.",lt,O,Qt="Save the embedding layer by adding it to the <code>target_modules</code> of the config. The embedding layer name must follow the standard naming scheme from Transformers. For example, the Mistral config could look like this:",nt,ee,ot,te,St='Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_input_embeddings" rel="nofollow">get_input_embeddings</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_output_embeddings" rel="nofollow">get_output_embeddings</a>. This is generally the case for Transformers models.',it,se,At="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",rt,ae,pt,le,Dt="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",dt,ne,Kt='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',mt,oe,ct,ie,Ot='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',ht,re,es='The <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',ut,pe,ft,de,ts="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",gt,me,ss="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",yt,ce,as="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",Mt,he,bt,ue,ls='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',wt,fe,Tt,ge,_t,ye,jt,Me,ns="When loading a trained PEFT model where the base model uses batch norm (e.g. <code>torch.nn.BatchNorm1d</code> or <code>torch.nn.BatchNorm2d</code>), you may find that you cannot reproduce the exact same outputs. This is because the batch norm layers keep track of running stats during training, but these stats are not part of the PEFT checkpoint. Therefore, when you load the PEFT model, the running stats of the base model will be used (i.e. from before training with PEFT).",xt,be,os="Depending on your use case, this may not be a big deal. If, however, you need your outputs to be 100% reproducible, you can achieve this by adding the batch norm layers to <code>modules_to_save</code>. Below is an example of this using resnet and LoRA. Notice that we set <code>modules_to_save=[&quot;classifier&quot;, &quot;normalization&quot;]</code>. We need the <code>&quot;classifier&quot;</code> argument because our task is image classification, and we add the <code>&quot;normalization&quot;</code> argument to ensure that the batch norm layers are saved in the PEFT checkpoint.",$t,we,vt,Te,is="Depending on the type of model you use, the batch norm layers could have different names than <code>&quot;normalization&quot;</code>, so please ensure that the name matches your model architecture.",Jt,_e,Zt,xe,kt;return T=new M({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),j=new M({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),J=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),k=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),U=new M({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h2"}}),W=new g({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),G=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),b=new Ms({props:{$$slots:{default:[ws]},$$scope:{ctx:$e}}}),I=new M({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),X=new M({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),L=new M({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),Y=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),P=new M({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),S=new g({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),D=new M({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),ee=new g({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ae=new g({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),oe=new M({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),pe=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),he=new g({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),fe=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFwaXBlLnNldF9sb3JhX2RldmljZSglNUIlMjJhZGFwdGVyLTIlMjIlNUQlMkMlMjAlMjJjdWRhJTIyKSUwQWdldF9sYXllcl9zdGF0dXMocGlwZS50ZXh0X2VuY29kZXIpJTBBJTBBZ2V0X21vZGVsX3N0YXR1cyhwaXBlLnVuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.set_lora_device([<span class="hljs-string">&quot;adapter-2&quot;</span>], <span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]},
)`,wrap:!1}}),ge=new M({props:{title:"Reproducibility",local:"reproducibility",headingTag:"h2"}}),ye=new M({props:{title:"Models using batch norm",local:"models-using-batch-norm",headingTag:"h3"}}),we=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGcmVzbmV0LTE4JTIyJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNlbGYubW9kZWxfaWQpJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmNvbnZvbHV0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiUyQyUyMCUyMm5vcm1hbGl6YXRpb24lMjIlNUQlMkMlMEEpJTJD",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = <span class="hljs-string">&quot;microsoft/resnet-18&quot;</span>
base_model = AutoModelForImageClassification.from_pretrained(self.model_id)
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;convolution&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>, <span class="hljs-string">&quot;normalization&quot;</span>],
),`,wrap:!1}}),_e=new bs({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){f=o("meta"),w=l(),y=o("p"),je=l(),p(T.$$.fragment),ve=l(),_=o("p"),_.textContent=Ut,Je=l(),p(j.$$.fragment),Ze=l(),x=o("p"),x.textContent=Ct,ke=l(),$=o("ul"),$.innerHTML=Wt,Ue=l(),v=o("p"),v.textContent=Bt,Ce=l(),p(J.$$.fragment),We=l(),Z=o("p"),Z.textContent=Gt,Be=l(),p(k.$$.fragment),Ge=l(),p(U.$$.fragment),Ie=l(),C=o("p"),C.innerHTML=It,Re=l(),p(W.$$.fragment),Fe=l(),B=o("p"),B.innerHTML=Rt,Xe=l(),p(G.$$.fragment),He=l(),p(b.$$.fragment),Ve=l(),p(I.$$.fragment),Le=l(),R=o("p"),R.innerHTML=Ft,Ee=l(),F=o("p"),F.textContent=Xt,Ye=l(),p(X.$$.fragment),Pe=l(),H=o("p"),H.textContent=Ht,ze=l(),V=o("ol"),V.innerHTML=Vt,qe=l(),p(L.$$.fragment),Ne=l(),E=o("p"),E.innerHTML=Lt,Qe=l(),p(Y.$$.fragment),Se=l(),p(P.$$.fragment),Ae=l(),z=o("p"),z.innerHTML=Et,De=l(),q=o("p"),q.innerHTML=Yt,Ke=l(),N=o("p"),N.innerHTML=Pt,Oe=l(),Q=o("p"),Q.textContent=zt,et=l(),p(S.$$.fragment),tt=l(),A=o("p"),A.innerHTML=qt,st=l(),p(D.$$.fragment),at=l(),K=o("p"),K.textContent=Nt,lt=l(),O=o("p"),O.innerHTML=Qt,nt=l(),p(ee.$$.fragment),ot=l(),te=o("p"),te.innerHTML=St,it=l(),se=o("p"),se.innerHTML=At,rt=l(),p(ae.$$.fragment),pt=l(),le=o("p"),le.textContent=Dt,dt=l(),ne=o("p"),ne.innerHTML=Kt,mt=l(),p(oe.$$.fragment),ct=l(),ie=o("p"),ie.innerHTML=Ot,ht=l(),re=o("p"),re.innerHTML=es,ut=l(),p(pe.$$.fragment),ft=l(),de=o("p"),de.innerHTML=ts,gt=l(),me=o("p"),me.textContent=ss,yt=l(),ce=o("p"),ce.innerHTML=as,Mt=l(),p(he.$$.fragment),bt=l(),ue=o("p"),ue.innerHTML=ls,wt=l(),p(fe.$$.fragment),Tt=l(),p(ge.$$.fragment),_t=l(),p(ye.$$.fragment),jt=l(),Me=o("p"),Me.innerHTML=ns,xt=l(),be=o("p"),be.innerHTML=os,$t=l(),p(we.$$.fragment),vt=l(),Te=o("p"),Te.innerHTML=is,Jt=l(),p(_e.$$.fragment),Zt=l(),xe=o("p"),this.h()},l(e){const t=gs("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(s),w=n(e),y=i(e,"P",{}),ps(y).forEach(s),je=n(e),d(T.$$.fragment,e),ve=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-wwms7a"&&(_.textContent=Ut),Je=n(e),d(j.$$.fragment,e),Ze=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18nlz3r"&&(x.textContent=Ct),ke=n(e),$=i(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-ccv654"&&($.innerHTML=Wt),Ue=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1cuqjyb"&&(v.textContent=Bt),Ce=n(e),d(J.$$.fragment,e),We=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-h5ykrw"&&(Z.textContent=Gt),Be=n(e),d(k.$$.fragment,e),Ge=n(e),d(U.$$.fragment,e),Ie=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-oa0e54"&&(C.innerHTML=It),Re=n(e),d(W.$$.fragment,e),Fe=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-p7trz1"&&(B.innerHTML=Rt),Xe=n(e),d(G.$$.fragment,e),He=n(e),d(b.$$.fragment,e),Ve=n(e),d(I.$$.fragment,e),Le=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ns8zue"&&(R.innerHTML=Ft),Ee=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-lfc2ft"&&(F.textContent=Xt),Ye=n(e),d(X.$$.fragment,e),Pe=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16feh"&&(H.textContent=Ht),ze=n(e),V=i(e,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-1fvhlks"&&(V.innerHTML=Vt),qe=n(e),d(L.$$.fragment,e),Ne=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-q1qqrd"&&(E.innerHTML=Lt),Qe=n(e),d(Y.$$.fragment,e),Se=n(e),d(P.$$.fragment,e),Ae=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-5heszj"&&(z.innerHTML=Et),De=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-c4824l"&&(q.innerHTML=Yt),Ke=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ou3c35"&&(N.innerHTML=Pt),Oe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1g4txs2"&&(Q.textContent=zt),et=n(e),d(S.$$.fragment,e),tt=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1fbeum6"&&(A.innerHTML=qt),st=n(e),d(D.$$.fragment,e),at=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-15igmai"&&(K.textContent=Nt),lt=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1cgzlph"&&(O.innerHTML=Qt),nt=n(e),d(ee.$$.fragment,e),ot=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-kwgcwv"&&(te.innerHTML=St),it=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-ucua6z"&&(se.innerHTML=At),rt=n(e),d(ae.$$.fragment,e),pt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-nkv7o7"&&(le.textContent=Dt),dt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-a0ibfa"&&(ne.innerHTML=Kt),mt=n(e),d(oe.$$.fragment,e),ct=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1f0hxdh"&&(ie.innerHTML=Ot),ht=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ygf8mz"&&(re.innerHTML=es),ut=n(e),d(pe.$$.fragment,e),ft=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1gb1r7d"&&(de.innerHTML=ts),gt=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-19sfzdf"&&(me.textContent=ss),yt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-18r4lni"&&(ce.innerHTML=as),Mt=n(e),d(he.$$.fragment,e),bt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-17rnlhh"&&(ue.innerHTML=ls),wt=n(e),d(fe.$$.fragment,e),Tt=n(e),d(ge.$$.fragment,e),_t=n(e),d(ye.$$.fragment,e),jt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-yt67c7"&&(Me.innerHTML=ns),xt=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-wblxho"&&(be.innerHTML=os),$t=n(e),d(we.$$.fragment,e),vt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1e3stb1"&&(Te.innerHTML=is),Jt=n(e),d(_e.$$.fragment,e),Zt=n(e),xe=i(e,"P",{}),ps(xe).forEach(s),this.h()},h(){ds(f,"name","hf:doc:metadata"),ds(f,"content",_s)},m(e,t){ys(document.head,f),a(e,w,t),a(e,y,t),a(e,je,t),m(T,e,t),a(e,ve,t),a(e,_,t),a(e,Je,t),m(j,e,t),a(e,Ze,t),a(e,x,t),a(e,ke,t),a(e,$,t),a(e,Ue,t),a(e,v,t),a(e,Ce,t),m(J,e,t),a(e,We,t),a(e,Z,t),a(e,Be,t),m(k,e,t),a(e,Ge,t),m(U,e,t),a(e,Ie,t),a(e,C,t),a(e,Re,t),m(W,e,t),a(e,Fe,t),a(e,B,t),a(e,Xe,t),m(G,e,t),a(e,He,t),m(b,e,t),a(e,Ve,t),m(I,e,t),a(e,Le,t),a(e,R,t),a(e,Ee,t),a(e,F,t),a(e,Ye,t),m(X,e,t),a(e,Pe,t),a(e,H,t),a(e,ze,t),a(e,V,t),a(e,qe,t),m(L,e,t),a(e,Ne,t),a(e,E,t),a(e,Qe,t),m(Y,e,t),a(e,Se,t),m(P,e,t),a(e,Ae,t),a(e,z,t),a(e,De,t),a(e,q,t),a(e,Ke,t),a(e,N,t),a(e,Oe,t),a(e,Q,t),a(e,et,t),m(S,e,t),a(e,tt,t),a(e,A,t),a(e,st,t),m(D,e,t),a(e,at,t),a(e,K,t),a(e,lt,t),a(e,O,t),a(e,nt,t),m(ee,e,t),a(e,ot,t),a(e,te,t),a(e,it,t),a(e,se,t),a(e,rt,t),m(ae,e,t),a(e,pt,t),a(e,le,t),a(e,dt,t),a(e,ne,t),a(e,mt,t),m(oe,e,t),a(e,ct,t),a(e,ie,t),a(e,ht,t),a(e,re,t),a(e,ut,t),m(pe,e,t),a(e,ft,t),a(e,de,t),a(e,gt,t),a(e,me,t),a(e,yt,t),a(e,ce,t),a(e,Mt,t),m(he,e,t),a(e,bt,t),a(e,ue,t),a(e,wt,t),m(fe,e,t),a(e,Tt,t),m(ge,e,t),a(e,_t,t),m(ye,e,t),a(e,jt,t),a(e,Me,t),a(e,xt,t),a(e,be,t),a(e,$t,t),m(we,e,t),a(e,vt,t),a(e,Te,t),a(e,Jt,t),m(_e,e,t),a(e,Zt,t),a(e,xe,t),kt=!0},p(e,[t]){const rs={};t&2&&(rs.$$scope={dirty:t,ctx:e}),b.$set(rs)},i(e){kt||(c(T.$$.fragment,e),c(j.$$.fragment,e),c(J.$$.fragment,e),c(k.$$.fragment,e),c(U.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(b.$$.fragment,e),c(I.$$.fragment,e),c(X.$$.fragment,e),c(L.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(_e.$$.fragment,e),kt=!0)},o(e){h(T.$$.fragment,e),h(j.$$.fragment,e),h(J.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(G.$$.fragment,e),h(b.$$.fragment,e),h(I.$$.fragment,e),h(X.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(_e.$$.fragment,e),kt=!1},d(e){e&&(s(w),s(y),s(je),s(ve),s(_),s(Je),s(Ze),s(x),s(ke),s($),s(Ue),s(v),s(Ce),s(We),s(Z),s(Be),s(Ge),s(Ie),s(C),s(Re),s(Fe),s(B),s(Xe),s(He),s(Ve),s(Le),s(R),s(Ee),s(F),s(Ye),s(Pe),s(H),s(ze),s(V),s(qe),s(Ne),s(E),s(Qe),s(Se),s(Ae),s(z),s(De),s(q),s(Ke),s(N),s(Oe),s(Q),s(et),s(tt),s(A),s(st),s(at),s(K),s(lt),s(O),s(nt),s(ot),s(te),s(it),s(se),s(rt),s(pt),s(le),s(dt),s(ne),s(mt),s(ct),s(ie),s(ht),s(re),s(ut),s(ft),s(de),s(gt),s(me),s(yt),s(ce),s(Mt),s(bt),s(ue),s(wt),s(Tt),s(_t),s(jt),s(Me),s(xt),s(be),s($t),s(vt),s(Te),s(Jt),s(Zt),s(xe)),s(f),u(T,e),u(j,e),u(J,e),u(k,e),u(U,e),u(W,e),u(G,e),u(b,e),u(I,e),u(X,e),u(L,e),u(Y,e),u(P,e),u(S,e),u(D,e),u(ee,e),u(ae,e),u(oe,e),u(pe,e),u(he,e),u(fe,e),u(ge,e),u(ye,e),u(we,e),u(_e,e)}}}const _s='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2},{"title":"Reproducibility","local":"reproducibility","sections":[{"title":"Models using batch norm","local":"models-using-batch-norm","sections":[],"depth":3}],"depth":2}],"depth":1}';function js($e){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ks extends us{constructor(f){super(),fs(this,f,js,Ts,ms,{})}}export{ks as component};
