import{s as Qt,n as Nt,o as Dt}from"../chunks/scheduler.7bc62968.js";import{S as Gt,i as _t,g as i,s as n,r,A as Vt,h as o,f as s,c as a,j as Wt,u as M,x as h,k as Bt,y as zt,a as l,v as p,d as c,t as d,w as m}from"../chunks/index.2f8492b0.js";import{C as b}from"../chunks/CodeBlock.4e96d6f7.js";import{H as u}from"../chunks/Heading.14fb2476.js";function Yt(ct){let y,he,de,ue,f,be,j,ye,w,dt=`DETR is mainly used for object detection tasks, which is the process of detecting objects in an image. For example, the input of the model would be an image of a road, and the output of the model could be <code>[(&#39;car&#39;,X1,Y1,W1,H1),(&#39;pedestrian&#39;,X2,Y2,W2,H2)]</code>, in which X, Y, W, H represent the x, y coordinates denoting the location of the bounding box, as well as the width and height of the box.
A traditional object detection model like YOLO consists of hand-crafted features like anchor box priors, which requires initial guesses of object locations and shapes, affecting downstream training. Post-processing steps are then used to remove overlapping bounding boxes, which require careful selection of its filtering heuristics.
DEtection TRansformer, DETR for short, simplifies the detector by using an encoder-decoder transformer after the feature extraction backbone to directly predict bounding boxes in parallel, requiring minimal post-processing.`,fe,T,mt=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR.png" alt="Architecture Diagram of DETR"/>
The model architecture of DETR begins with a CNN backbone, similar to other image-based networks, the output of which is processed and fed into a transformer encoder, resulting in N embeddings. The encoder embeddings are added to learned positional embeddings (called object queries) and used in a transformer decoder, generating another N embeddings. As a final step, each of the N embeddings are put through individual feed forward layers to predict the width, height, coordinates of the bounding box, as well as the object class (or whether there is an object).`,je,J,we,U,Te,g,ht=`As with other transformers, the transformer encoder expects the output of the CNN backbone to be a sequence. Thus, the feature map of size <code>[dimension, height, width]</code> is downsized and then flattened to <code>[dimension, less than height x width]</code>.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_FeatureMaps.png" alt="Feature Maps of Encoder"/> <em><strong>Left</strong>: 12 out of 256 dimensions in the feature maps are visualized. Each dimension extracts some features of the original cat image while downsizing the original image. Some dimensions have a higher focus on the patterns on the cat; some have a higher focus on the bed sheets.</em> <em><strong>Right</strong>: Keeping the original feature dimension of size 256, the width and height are further downsized and flattened into size 850.</em><br/>
Since transformers are permutation invariant, positional embeddings are added to both the encoder and decoder to remind the model where on the image the embeddings come from. In the encoder, fixed positional encodings are used, while in the decoder, learned positional encodings (object queries) are used. Fixed encodings are similar to the ones used in the original Transformer paper, in which the encodings are defined by sinusoidal functions of varying frequencies at different feature dimensions. It gives the sense of position without having any learned parameters, indexed by the position on the image. Learned encodings are also indexed by the positions, but each position has a separate encoding that is learned throughout training to denote the positions in a way that the model understands.`,Je,C,Ue,I,ut="In YOLO, a popular object detection model, the loss function comprises the bounding box, objectness (ie. the probability of an object existing in a region of interest), and class loss. The loss is calculated over multiple bounding boxes per each grid cell, which is a fixed number. On the other hand, in DETR, the architecture is expected to generate unique bounding boxes in a permutation-invariant manner (i.e., the order of the detections does not matter in the output, and the bounding boxes must vary and cannot all be the same). Thus, matching is required to assess how good the predictions are.",ge,A,bt=`<strong>Bipartite Matching</strong><br/>
Bipartite matching is a way to compute one-on-one matching between the ground truth bounding boxes and the predicted boxes. It finds matches with the highest similarity between ground truth and predicted bounding boxes, as well as classes. This ensures the closest prediction would be matched with the corresponding ground truth in order to properly adjust the boxes and classes in the loss function. If matching is not done, predictions not aligned with the order of the ground truth would be marked as incorrect even if it were correct.`,Ce,$,Ie,Z,yt="To see an example of how you can perform inference with DETR using Hugging Face transformers, see <code>DETR.ipynb</code>.",Ae,k,$e,v,Ze,x,ft=`Two of the main problems of DETR are a long and slow process of convergence and suboptimal small object detection.
<strong>Deformable Attention</strong><br/>
The first problem is resolved by using deformable attention, which reduces the amount of sampling points to pay attention to. Traditional attention is inefficient due to global attention and heavily limit the resolution that the image can have. The model only attends to a fixed amount of sampling points around each reference point, and the reference points are learned by the model based on the input. For example, in an image of a dog, a reference point may be in the center of the dog, with sampling points near the ears, mouth, tail, etc.`,ke,R,jt=`<strong>Multi-scale Deformable Attention Module</strong><br/>
The second problem is resolved similarly to YOLOv3, in which multi-scale feature maps are introduced. In convolutional neural networks, earlier layers extract smaller details (ex. lines) while later layers extract larger details (ex. wheels, ears). In a similar manner, different layers of deformable attention result in different levels of resolution. By connecting the outputs of some of these layers from the encoder to the decoder, it allows for the model to detect objects of a multitude of sizes.`,ve,E,xe,W,wt=`Conditional DETR also sets out to resolve the problem of slow training convergence in the original DETR, resulting in convergence that is over 6.7 times faster. The authors found that the object queries are general and are not specific to the input image. Using <strong>Conditional Cross-Attention</strong> in the decoder, the queries can better localize the areas for bounding box regression.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_DecoderLayer.png" alt="A decoder layer for Deformable DETR"/> <em>Left: DETR Decoder Layer. Right: Deformable DETR Decoder Layer</em><br/>
The original DETR and Deformable DETR decoder layers are compared in the figure above, with the main difference being the query input of the cross-attention block. The authors make a distinction between content query c<sub>q</sub> (decoder self attention output) and spatial query p<sub>q</sub>. The original DETR simply adds them together. In Deformable DETR, they are concatenated, with c<sub>q</sub> focusing on the content of the object and p<sub>q</sub> focusing on the bounding box regions.<br/>
The spatial query p<sub>q</sub> is the result of both the decoder embeddings and object queries projecting to the same space (to become T and p<sub>s</sub> respectively) and multiplied together. The previous layers’ decoder embeddings contain information for the bounding box regions, and the object queries contains information of learned reference points for each bounding box. Thus, their projections combine into a representation that allows for cross-attention to measure their similarities with the encoder input and sinusoidal positional embedding. This is more effective than DETR which only uses object queries and fixed reference points.`,Re,B,Ee,Q,Tt="You can infer with existing DETR models on Hugging Face Hub like below:",We,N,Be,D,Jt="Outputs are below.",Qe,G,Ne,_,De,V,Ut="The implementation of DETR from the original paper is shown below:",Ge,z,_e,Y,Ve,X,gt=`<strong>Backbone</strong><br/>
The input image is first put through a ResNet backbone and then a convolution layer, which reduces the dimension to the <code>hidden_dim</code>`,ze,H,Ye,L,Ct="they are declared in the <code>__init__</code> function",Xe,S,He,q,It="<strong>Positional Embeddings</strong>",Le,F,At="While in the paper fixed and trained embeddings are used in the encoder and decoder respectively, the authors used trained embeddings for both in the implementation for simplicity.",Se,K,qe,P,$t="They are declared here as <code>nn.Parameter</code>. The row and column embeddings combined denote the locations in the image.",Fe,O,Ke,ee,Zt=`<strong>Resize</strong><br/>
Before going into the transformer, the features with size <code>(batch size, hidden_dim, H, W)</code> are reshaped to <code>(hidden_dim, batch size, H*W)</code>. This makes them a sequential input for the transformer`,Pe,te,Oe,se,kt=`<strong>Transformer</strong><br/>
The <code>nn.Transformer</code> function takes in the first parameter as the input to the encoder, and the second parameter as the input of the encoder. As you can see, the encoder takes in the resized features added to the positional embeddings, while the decoder takes in <code>query_pos</code>, which is the decoder positional embedding.`,et,le,tt,ne,vt=`<strong>Feed-Forward Network</strong><br/>
In the end, the outputs, which is a tensor of size <code>(query_pos_dim, batch size, hidden_dim)</code>, is fed through two linear layers.`,st,ae,lt,ie,xt="The first of which predicts the class. An additional class is added for the <code>No Object</code> class",nt,oe,at,re,Rt="The second linear layer predicts the bounding box with an output size 4 for the xy coordinates, height and width.",it,Me,ot,pe,rt,ce,Et='<li><a href="https://arxiv.org/abs/2005.12872" rel="nofollow">DETR</a></li> <li><a href="https://arxiv.org/abs/1506.02640" rel="nofollow">YOLO</a></li> <li><a href="https://arxiv.org/abs/1804.02767" rel="nofollow">YOLOv3</a></li> <li><a href="https://arxiv.org/abs/2108.06152" rel="nofollow">Conditional DETR</a></li> <li><a href="https://arxiv.org/abs/2010.04159" rel="nofollow">Deformable DETR</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-50" rel="nofollow"><code>facebook/detr-resnet-50</code></a></li>',Mt,me,pt;return f=new u({props:{title:"DEtection TRansformer (DETR)",local:"detection-transformer-detr",headingTag:"h1"}}),j=new u({props:{title:"Overview of architecture",local:"overview-of-architecture",headingTag:"h2"}}),J=new u({props:{title:"Key Features",local:"key-features",headingTag:"h2"}}),U=new u({props:{title:"Encoder-Decoder",local:"encoder-decoder",headingTag:"h3"}}),C=new u({props:{title:"Set-based Global Loss Function",local:"set-based-global-loss-function",headingTag:"h3"}}),$=new u({props:{title:"Using DETR to Detect Objects",local:"using-detr-to-detect-objects",headingTag:"h2"}}),k=new u({props:{title:"Evolution of DETR",local:"evolution-of-detr",headingTag:"h2"}}),v=new u({props:{title:"Deformable DETR",local:"deformable-detr",headingTag:"h3"}}),E=new u({props:{title:"Conditional DETR",local:"conditional-detr",headingTag:"h3"}}),B=new u({props:{title:"DETR Inference",local:"detr-inference",headingTag:"h2"}}),N=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrImageProcessor, DetrForObjectDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># initialize the model</span>
processor = DetrImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;facebook/detr-resnet-101&quot;</span>, revision=<span class="hljs-string">&quot;no_timm&quot;</span>
)
model = DetrForObjectDetection.from_pretrained(
    <span class="hljs-string">&quot;facebook/detr-resnet-101&quot;</span>, revision=<span class="hljs-string">&quot;no_timm&quot;</span>
)

<span class="hljs-comment"># preprocess the inputs and infer</span>
inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-comment"># non max supression above 0.9</span>
target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
results = processor.post_process_object_detection(
    outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.9</span>
)[<span class="hljs-number">0</span>]

<span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
    )`,wrap:!1}}),G=new b({props:{code:"RGV0ZWN0ZWQlMjBjYXQlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk4JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjM0NC4wNiUyQyUyMDI0Ljg1JTJDJTIwNjQwLjM0JTJDJTIwMzczLjc0JTVEJTBBRGV0ZWN0ZWQlMjByZW1vdGUlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk3JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjMyOC4xMyUyQyUyMDc1LjkzJTJDJTIwMzcyLjgxJTJDJTIwMTg3LjY2JTVEJTBBRGV0ZWN0ZWQlMjByZW1vdGUlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk3JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjM5LjM0JTJDJTIwNzAuMTMlMkMlMjAxNzUuNTYlMkMlMjAxMTguNzglNUQlMEFEZXRlY3RlZCUyMGNhdCUyMHdpdGglMjBjb25maWRlbmNlJTIwMC45OTglMjBhdCUyMGxvY2F0aW9uJTIwJTVCMTUuMzYlMkMlMjA1MS43NSUyQyUyMDMxNi44OSUyQyUyMDQ3MS4xNiU1RCUwQURldGVjdGVkJTIwY291Y2glMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk1JTIwYXQlMjBsb2NhdGlvbiUyMCU1Qi0wLjE5JTJDJTIwMC43MSUyQyUyMDYzOS43MyUyQyUyMDQ3NC4xNyU1RA==",highlighted:`Detected <span class="hljs-built_in">cat</span> with confidence 0.998 at location [344.06, 24.85, 640.34, 373.74]
Detected remote with confidence 0.997 at location [328.13, 75.93, 372.81, 187.66]
Detected remote with confidence 0.997 at location [39.34, 70.13, 175.56, 118.78]
Detected <span class="hljs-built_in">cat</span> with confidence 0.998 at location [15.36, 51.75, 316.89, 471.16]
Detected couch with confidence 0.995 at location [-0.19, 0.71, 639.73, 474.17]`,wrap:!1}}),_=new u({props:{title:"PyTorch Implementation of DETR",local:"pytorch-implementation-of-detr",headingTag:"h2"}}),z=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> torchvision.models <span class="hljs-keyword">import</span> resnet50


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DETR</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self, num_classes, hidden_dim, nheads, num_encoder_layers, num_decoder_layers
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
        self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)
        self.transformer = nn.Transformer(
            hidden_dim, nheads, num_encoder_layers, num_decoder_layers
        )
        self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)
        self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)
        self.query_pos = nn.Parameter(torch.rand(<span class="hljs-number">100</span>, hidden_dim))
        self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
        self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, inputs</span>):
        x = self.backbone(inputs)
        h = self.conv(x)
        H, W = h.shape[-<span class="hljs-number">2</span>:]
        pos = (
            torch.cat(
                [
                    self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
                    self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
                ],
                dim=-<span class="hljs-number">1</span>,
            )
            .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
            .unsqueeze(<span class="hljs-number">1</span>)
        )
        h = self.transformer(
            pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>)
        )
        <span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()`,wrap:!1}}),Y=new u({props:{title:"Going line by line in the forward function:",local:"going-line-by-line-in-the-forward-function",headingTag:"h3"}}),H=new b({props:{code:"eCUyMCUzRCUyMHNlbGYuYmFja2JvbmUoaW5wdXRzKSUwQWglMjAlM0QlMjBzZWxmLmNvbnYoeCk=",highlighted:`x = self.backbone(inputs)
h = self.conv(x)`,wrap:!1}}),S=new b({props:{code:"c2VsZi5iYWNrYm9uZSUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoKmxpc3QocmVzbmV0NTAocHJldHJhaW5lZCUzRFRydWUpLmNoaWxkcmVuKCkpJTVCJTNBLTIlNUQpJTBBc2VsZi5jb252JTIwJTNEJTIwbm4uQ29udjJkKDIwNDglMkMlMjBoaWRkZW5fZGltJTJDJTIwMSk=",highlighted:`self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)`,wrap:!1}}),K=new b({props:{code:"cG9zJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLmNhdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbF9lbWJlZCU1QiUzQVclNUQudW5zcXVlZXplKDApLnJlcGVhdChIJTJDJTIwMSUyQyUyMDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yb3dfZW1iZWQlNUIlM0FIJTVELnVuc3F1ZWV6ZSgxKS5yZXBlYXQoMSUyQyUyMFclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpbSUzRC0xJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMC5mbGF0dGVuKDAlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMC51bnNxdWVlemUoMSklMEEp",highlighted:`pos = (
    torch.cat(
        [
            self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
            self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
        ],
        dim=-<span class="hljs-number">1</span>,
    )
    .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    .unsqueeze(<span class="hljs-number">1</span>)
)`,wrap:!1}}),O=new b({props:{code:"c2VsZi5yb3dfZW1iZWQlMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCg1MCUyQyUyMGhpZGRlbl9kaW0lMjAlMkYlMkYlMjAyKSklMEFzZWxmLmNvbF9lbWJlZCUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKDUwJTJDJTIwaGlkZGVuX2RpbSUyMCUyRiUyRiUyMDIpKQ==",highlighted:`self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))`,wrap:!1}}),te=new b({props:{code:"aC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKQ==",highlighted:'h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)',wrap:!1}}),le=new b({props:{code:"aCUyMCUzRCUyMHNlbGYudHJhbnNmb3JtZXIocG9zJTIwJTJCJTIwaC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKSUyQyUyMHNlbGYucXVlcnlfcG9zLnVuc3F1ZWV6ZSgxKSk=",highlighted:'h = self.transformer(pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>))',wrap:!1}}),ae=new b({props:{code:"cmV0dXJuJTIwc2VsZi5saW5lYXJfY2xhc3MoaCklMkMlMjBzZWxmLmxpbmVhcl9iYm94KGgpLnNpZ21vaWQoKQ==",highlighted:'<span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()',wrap:!1}}),oe=new b({props:{code:"c2VsZi5saW5lYXJfY2xhc3MlMjAlM0QlMjBubi5MaW5lYXIoaGlkZGVuX2RpbSUyQyUyMG51bV9jbGFzc2VzJTIwJTJCJTIwMSk=",highlighted:'self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)',wrap:!1}}),Me=new b({props:{code:"c2VsZi5saW5lYXJfYmJveCUyMCUzRCUyMG5uLkxpbmVhcihoaWRkZW5fZGltJTJDJTIwNCk=",highlighted:'self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)',wrap:!1}}),pe=new u({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){y=i("meta"),he=n(),de=i("p"),ue=n(),r(f.$$.fragment),be=n(),r(j.$$.fragment),ye=n(),w=i("p"),w.innerHTML=dt,fe=n(),T=i("p"),T.innerHTML=mt,je=n(),r(J.$$.fragment),we=n(),r(U.$$.fragment),Te=n(),g=i("p"),g.innerHTML=ht,Je=n(),r(C.$$.fragment),Ue=n(),I=i("p"),I.textContent=ut,ge=n(),A=i("p"),A.innerHTML=bt,Ce=n(),r($.$$.fragment),Ie=n(),Z=i("p"),Z.innerHTML=yt,Ae=n(),r(k.$$.fragment),$e=n(),r(v.$$.fragment),Ze=n(),x=i("p"),x.innerHTML=ft,ke=n(),R=i("p"),R.innerHTML=jt,ve=n(),r(E.$$.fragment),xe=n(),W=i("p"),W.innerHTML=wt,Re=n(),r(B.$$.fragment),Ee=n(),Q=i("p"),Q.textContent=Tt,We=n(),r(N.$$.fragment),Be=n(),D=i("p"),D.textContent=Jt,Qe=n(),r(G.$$.fragment),Ne=n(),r(_.$$.fragment),De=n(),V=i("p"),V.textContent=Ut,Ge=n(),r(z.$$.fragment),_e=n(),r(Y.$$.fragment),Ve=n(),X=i("p"),X.innerHTML=gt,ze=n(),r(H.$$.fragment),Ye=n(),L=i("p"),L.innerHTML=Ct,Xe=n(),r(S.$$.fragment),He=n(),q=i("p"),q.innerHTML=It,Le=n(),F=i("p"),F.textContent=At,Se=n(),r(K.$$.fragment),qe=n(),P=i("p"),P.innerHTML=$t,Fe=n(),r(O.$$.fragment),Ke=n(),ee=i("p"),ee.innerHTML=Zt,Pe=n(),r(te.$$.fragment),Oe=n(),se=i("p"),se.innerHTML=kt,et=n(),r(le.$$.fragment),tt=n(),ne=i("p"),ne.innerHTML=vt,st=n(),r(ae.$$.fragment),lt=n(),ie=i("p"),ie.innerHTML=xt,nt=n(),r(oe.$$.fragment),at=n(),re=i("p"),re.textContent=Rt,it=n(),r(Me.$$.fragment),ot=n(),r(pe.$$.fragment),rt=n(),ce=i("ul"),ce.innerHTML=Et,Mt=n(),me=i("p"),this.h()},l(e){const t=Vt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),he=a(e),de=o(e,"P",{}),Wt(de).forEach(s),ue=a(e),M(f.$$.fragment,e),be=a(e),M(j.$$.fragment,e),ye=a(e),w=o(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1uea2cx"&&(w.innerHTML=dt),fe=a(e),T=o(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-1mj736s"&&(T.innerHTML=mt),je=a(e),M(J.$$.fragment,e),we=a(e),M(U.$$.fragment,e),Te=a(e),g=o(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-t8og7r"&&(g.innerHTML=ht),Je=a(e),M(C.$$.fragment,e),Ue=a(e),I=o(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-12feezj"&&(I.textContent=ut),ge=a(e),A=o(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1obgrh7"&&(A.innerHTML=bt),Ce=a(e),M($.$$.fragment,e),Ie=a(e),Z=o(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-f2wazx"&&(Z.innerHTML=yt),Ae=a(e),M(k.$$.fragment,e),$e=a(e),M(v.$$.fragment,e),Ze=a(e),x=o(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-w2zzks"&&(x.innerHTML=ft),ke=a(e),R=o(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-vzcbkx"&&(R.innerHTML=jt),ve=a(e),M(E.$$.fragment,e),xe=a(e),W=o(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1eux0rj"&&(W.innerHTML=wt),Re=a(e),M(B.$$.fragment,e),Ee=a(e),Q=o(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-fvf0lp"&&(Q.textContent=Tt),We=a(e),M(N.$$.fragment,e),Be=a(e),D=o(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-r4sesn"&&(D.textContent=Jt),Qe=a(e),M(G.$$.fragment,e),Ne=a(e),M(_.$$.fragment,e),De=a(e),V=o(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-d0cg5t"&&(V.textContent=Ut),Ge=a(e),M(z.$$.fragment,e),_e=a(e),M(Y.$$.fragment,e),Ve=a(e),X=o(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-49p96y"&&(X.innerHTML=gt),ze=a(e),M(H.$$.fragment,e),Ye=a(e),L=o(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1g4lk9n"&&(L.innerHTML=Ct),Xe=a(e),M(S.$$.fragment,e),He=a(e),q=o(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1afjwf9"&&(q.innerHTML=It),Le=a(e),F=o(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1e5n46h"&&(F.textContent=At),Se=a(e),M(K.$$.fragment,e),qe=a(e),P=o(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-xpw6n2"&&(P.innerHTML=$t),Fe=a(e),M(O.$$.fragment,e),Ke=a(e),ee=o(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-15swqve"&&(ee.innerHTML=Zt),Pe=a(e),M(te.$$.fragment,e),Oe=a(e),se=o(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-b0wrkd"&&(se.innerHTML=kt),et=a(e),M(le.$$.fragment,e),tt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-bczn5d"&&(ne.innerHTML=vt),st=a(e),M(ae.$$.fragment,e),lt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-14uu8gr"&&(ie.innerHTML=xt),nt=a(e),M(oe.$$.fragment,e),at=a(e),re=o(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-yoo56g"&&(re.textContent=Rt),it=a(e),M(Me.$$.fragment,e),ot=a(e),M(pe.$$.fragment,e),rt=a(e),ce=o(e,"UL",{"data-svelte-h":!0}),h(ce)!=="svelte-1ie7nnc"&&(ce.innerHTML=Et),Mt=a(e),me=o(e,"P",{}),Wt(me).forEach(s),this.h()},h(){Bt(y,"name","hf:doc:metadata"),Bt(y,"content",Xt)},m(e,t){zt(document.head,y),l(e,he,t),l(e,de,t),l(e,ue,t),p(f,e,t),l(e,be,t),p(j,e,t),l(e,ye,t),l(e,w,t),l(e,fe,t),l(e,T,t),l(e,je,t),p(J,e,t),l(e,we,t),p(U,e,t),l(e,Te,t),l(e,g,t),l(e,Je,t),p(C,e,t),l(e,Ue,t),l(e,I,t),l(e,ge,t),l(e,A,t),l(e,Ce,t),p($,e,t),l(e,Ie,t),l(e,Z,t),l(e,Ae,t),p(k,e,t),l(e,$e,t),p(v,e,t),l(e,Ze,t),l(e,x,t),l(e,ke,t),l(e,R,t),l(e,ve,t),p(E,e,t),l(e,xe,t),l(e,W,t),l(e,Re,t),p(B,e,t),l(e,Ee,t),l(e,Q,t),l(e,We,t),p(N,e,t),l(e,Be,t),l(e,D,t),l(e,Qe,t),p(G,e,t),l(e,Ne,t),p(_,e,t),l(e,De,t),l(e,V,t),l(e,Ge,t),p(z,e,t),l(e,_e,t),p(Y,e,t),l(e,Ve,t),l(e,X,t),l(e,ze,t),p(H,e,t),l(e,Ye,t),l(e,L,t),l(e,Xe,t),p(S,e,t),l(e,He,t),l(e,q,t),l(e,Le,t),l(e,F,t),l(e,Se,t),p(K,e,t),l(e,qe,t),l(e,P,t),l(e,Fe,t),p(O,e,t),l(e,Ke,t),l(e,ee,t),l(e,Pe,t),p(te,e,t),l(e,Oe,t),l(e,se,t),l(e,et,t),p(le,e,t),l(e,tt,t),l(e,ne,t),l(e,st,t),p(ae,e,t),l(e,lt,t),l(e,ie,t),l(e,nt,t),p(oe,e,t),l(e,at,t),l(e,re,t),l(e,it,t),p(Me,e,t),l(e,ot,t),p(pe,e,t),l(e,rt,t),l(e,ce,t),l(e,Mt,t),l(e,me,t),pt=!0},p:Nt,i(e){pt||(c(f.$$.fragment,e),c(j.$$.fragment,e),c(J.$$.fragment,e),c(U.$$.fragment,e),c(C.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(E.$$.fragment,e),c(B.$$.fragment,e),c(N.$$.fragment,e),c(G.$$.fragment,e),c(_.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),pt=!0)},o(e){d(f.$$.fragment,e),d(j.$$.fragment,e),d(J.$$.fragment,e),d(U.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(E.$$.fragment,e),d(B.$$.fragment,e),d(N.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(Me.$$.fragment,e),d(pe.$$.fragment,e),pt=!1},d(e){e&&(s(he),s(de),s(ue),s(be),s(ye),s(w),s(fe),s(T),s(je),s(we),s(Te),s(g),s(Je),s(Ue),s(I),s(ge),s(A),s(Ce),s(Ie),s(Z),s(Ae),s($e),s(Ze),s(x),s(ke),s(R),s(ve),s(xe),s(W),s(Re),s(Ee),s(Q),s(We),s(Be),s(D),s(Qe),s(Ne),s(De),s(V),s(Ge),s(_e),s(Ve),s(X),s(ze),s(Ye),s(L),s(Xe),s(He),s(q),s(Le),s(F),s(Se),s(qe),s(P),s(Fe),s(Ke),s(ee),s(Pe),s(Oe),s(se),s(et),s(tt),s(ne),s(st),s(lt),s(ie),s(nt),s(at),s(re),s(it),s(ot),s(rt),s(ce),s(Mt),s(me)),s(y),m(f,e),m(j,e),m(J,e),m(U,e),m(C,e),m($,e),m(k,e),m(v,e),m(E,e),m(B,e),m(N,e),m(G,e),m(_,e),m(z,e),m(Y,e),m(H,e),m(S,e),m(K,e),m(O,e),m(te,e),m(le,e),m(ae,e),m(oe,e),m(Me,e),m(pe,e)}}}const Xt='{"title":"DEtection TRansformer (DETR)","local":"detection-transformer-detr","sections":[{"title":"Overview of architecture","local":"overview-of-architecture","sections":[],"depth":2},{"title":"Key Features","local":"key-features","sections":[{"title":"Encoder-Decoder","local":"encoder-decoder","sections":[],"depth":3},{"title":"Set-based Global Loss Function","local":"set-based-global-loss-function","sections":[],"depth":3}],"depth":2},{"title":"Using DETR to Detect Objects","local":"using-detr-to-detect-objects","sections":[],"depth":2},{"title":"Evolution of DETR","local":"evolution-of-detr","sections":[{"title":"Deformable DETR","local":"deformable-detr","sections":[],"depth":3},{"title":"Conditional DETR","local":"conditional-detr","sections":[],"depth":3}],"depth":2},{"title":"DETR Inference","local":"detr-inference","sections":[],"depth":2},{"title":"PyTorch Implementation of DETR","local":"pytorch-implementation-of-detr","sections":[{"title":"Going line by line in the forward function:","local":"going-line-by-line-in-the-forward-function","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Ht(ct){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Gt{constructor(y){super(),_t(this,y,Ht,Yt,Qt,{})}}export{Kt as component};
