import{s as rt,f as pt,n as ct,o as mt}from"../chunks/scheduler.7bc62968.js";import{S as ht,i as dt,g as n,s as l,r as c,A as ft,h as o,f as s,c as i,j as xe,u as m,x as r,k as g,y as ut,a,v as h,d,t as f,w as u}from"../chunks/index.66556066.js";import{C as ee}from"../chunks/CodeBlock.a759539a.js";import{H as V}from"../chunks/Heading.3f0870db.js";function gt(Ne){let w,te,K,se,y,ae,T,Re='<strong>Streamlit</strong> gives users freedom to build a full-featured web app with Python in a <em>reactive</em> way. Your code is rerun each time the state of the app changes. Streamlit is also great for data visualization and supports several charting libraries such as Bokeh, Plotly, and Altair. Read this <a href="https://huggingface.co/blog/streamlit-spaces" rel="nofollow">blog post</a> about building and hosting Streamlit apps in Spaces.',le,b,Qe='Selecting <strong>Streamlit</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Space with the latest version of Streamlit by setting the <code>sdk</code> property to <code>streamlit</code> in your <code>README.md</code> file’s YAML block. If you’d like to change the Streamlit version, you can edit the <code>sdk_version</code> property.',ie,j,Ge='To use Streamlit in a Space, select <strong>Streamlit</strong> as the SDK when you create a Space through the <a href="https://huggingface.co/new-space" rel="nofollow"><strong>New Space</strong> form</a>. This will create a repository with a <code>README.md</code> that contains the following properties in the YAML configuration block:',ne,J,oe,S,Ye='You can edit the <code>sdk_version</code>, but note that issues may occur when you use an unsupported Streamlit version. Not all Streamlit versions are supported, so please refer to the <a href="./spaces-config-reference">reference section</a> to see which versions are available.',re,v,qe='For in-depth information about Streamlit, refer to the <a href="https://docs.streamlit.io/" rel="nofollow">Streamlit documentation</a>.',pe,$,ce,U,Ee='In the following sections, you’ll learn the basics of creating a Space, configuring it, and deploying your code to it. We’ll create a <strong>Hot Dog Classifier</strong> Space with Streamlit that’ll be used to demo the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which can detect whether a given picture contains a hot dog 🌭',me,I,Fe='You can find a completed version of this hosted at <a href="https://huggingface.co/spaces/NimaBoscarino/hotdog-streamlit" rel="nofollow">NimaBoscarino/hotdog-streamlit</a>.',he,Z,de,B,Ae='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Streamlit</strong> as our SDK. Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing.',fe,k,ue,W,Pe='For the <strong>Hot Dog Classifier</strong> we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model, so we need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',ge,H,we,L,Xe="The Spaces runtime will handle installing the dependencies!",Me,C,ye,z,De="To create the Streamlit app, make a new file in the repository called <strong>app.py</strong>, and add the following code:",Te,_,be,x,Ve='This Python script uses a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to load the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which is used by the Streamlit interface. The Streamlit app will expect you to upload an image, which it’ll then classify as <em>hot dog</em> or <em>not hot dog</em>. Once you’ve saved the code to the <strong>app.py</strong> file, visit the <strong>App</strong> tab to see your app in action!',je,M,Ke='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit-dark.png"/>',Je,N,Se,R,Oe="You can use the HTML <code>&lt;iframe&gt;</code> tag to embed a Streamlit Space as an inline frame on other webpages. Simply include the URL of your Space, ending with the <code>.hf.space</code> suffix. To find the URL of your Space, you can use the “Embed this Space” button from the Spaces options.",ve,Q,et="For example, the demo above can be embedded in these docs with the following tag:",$e,G,Ue,p,tt,Ie,Y,st="Please note that we have added <code>?embed=true</code> to the URL, which activates the embed mode of the Streamlit app, removing some spacers and the footer for slim embeds.",Ze,q,Be,E,at='Streamlit has supported automatic iframe resizing since <a href="https://docs.streamlit.io/library/changelog#version-1170" rel="nofollow">1.17.0</a> so that the size of the parent iframe is automatically adjusted to fit the content volume of the embedded Streamlit application.',ke,F,lt='It relies on the <a href="https://github.com/davidjbradshaw/iframe-resizer" rel="nofollow"><code>iFrame Resizer</code></a> library, for which you need to add a few lines of code, as in the following example where',We,A,it="<li><code>id</code> is set to <code>&lt;iframe /&gt;</code> that is used to specify the auto-resize target.</li> <li>The <code>iFrame Resizer</code> is loaded via the <code>script</code> tag.</li> <li>The <code>iFrameResize()</code> function is called with the ID of the target <code>iframe</code> element, so that its size changes automatically.</li>",He,P,nt='We can pass options to the first argument of <code>iFrameResize()</code>. See <a href="https://github.com/davidjbradshaw/iframe-resizer/blob/master/docs/parent_page/options.md" rel="nofollow">the document</a> for the details.',Le,X,Ce,D,ot='Additionally, you can checkout <a href="./spaces-embed">our documentation</a>.',ze,O,_e;return y=new V({props:{title:"Streamlit Spaces",local:"streamlit-spaces",headingTag:"h1"}}),J=new ee({props:{code:"c2RrJTNBJTIwc3RyZWFtbGl0JTBBc2RrX3ZlcnNpb24lM0ElMjAxLjI1LjAlMjAlMjMlMjBUaGUlMjBsYXRlc3QlMjBzdXBwb3J0ZWQlMjB2ZXJzaW9u",highlighted:`<span class="hljs-attr">sdk:</span> <span class="hljs-string">streamlit</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">1.25</span><span class="hljs-number">.0</span> <span class="hljs-comment"># The latest supported version</span>`,wrap:!1}}),$=new V({props:{title:"Your First Streamlit Space: Hot Dog Classifier",local:"your-first-streamlit-space-hot-dog-classifier",headingTag:"h2"}}),Z=new V({props:{title:"Create a new Streamlit Space",local:"create-a-new-streamlit-space",headingTag:"h2"}}),k=new V({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),H=new ee({props:{code:"dHJhbnNmb3JtZXJzJTBBdG9yY2g=",highlighted:`<span class="hljs-attribute">transformers
torch</span>`,wrap:!1}}),C=new V({props:{title:"Create the Streamlit app",local:"create-the-streamlit-app",headingTag:"h2"}}),_=new ee({props:{code:"aW1wb3J0JTIwc3RyZWFtbGl0JTIwYXMlMjBzdCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRmhvdGRvZy1ub3QtaG90ZG9nJTIyKSUwQSUwQXN0LnRpdGxlKCUyMkhvdCUyMERvZyUzRiUyME9yJTIwTm90JTNGJTIyKSUwQSUwQWZpbGVfbmFtZSUyMCUzRCUyMHN0LmZpbGVfdXBsb2FkZXIoJTIyVXBsb2FkJTIwYSUyMGhvdCUyMGRvZyUyMGNhbmRpZGF0ZSUyMGltYWdlJTIyKSUwQSUwQWlmJTIwZmlsZV9uYW1lJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwY29sMSUyQyUyMGNvbDIlMjAlM0QlMjBzdC5jb2x1bW5zKDIpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGZpbGVfbmFtZSklMEElMjAlMjAlMjAlMjBjb2wxLmltYWdlKGltYWdlJTJDJTIwdXNlX2NvbHVtbl93aWR0aCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBwaXBlbGluZShpbWFnZSklMEElMEElMjAlMjAlMjAlMjBjb2wyLmhlYWRlciglMjJQcm9iYWJpbGl0aWVzJTIyKSUwQSUyMCUyMCUyMCUyMGZvciUyMHAlMjBpbiUyMHByZWRpY3Rpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sMi5zdWJoZWFkZXIoZiUyMiU3QiUyMHAlNUInbGFiZWwnJTVEJTIwJTdEJTNBJTIwJTdCJTIwcm91bmQocCU1QidzY29yZSclNUQlMjAqJTIwMTAwJTJDJTIwMSklN0QlMjUlMjIp",highlighted:`<span class="hljs-keyword">import</span> streamlit <span class="hljs-keyword">as</span> st
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;julien-c/hotdog-not-hotdog&quot;</span>)

st.title(<span class="hljs-string">&quot;Hot Dog? Or Not?&quot;</span>)

file_name = st.file_uploader(<span class="hljs-string">&quot;Upload a hot dog candidate image&quot;</span>)

<span class="hljs-keyword">if</span> file_name <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    col1, col2 = st.columns(<span class="hljs-number">2</span>)

    image = Image.<span class="hljs-built_in">open</span>(file_name)
    col1.image(image, use_column_width=<span class="hljs-literal">True</span>)
    predictions = pipeline(image)

    col2.header(<span class="hljs-string">&quot;Probabilities&quot;</span>)
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> predictions:
        col2.subheader(<span class="hljs-string">f&quot;<span class="hljs-subst">{ p[<span class="hljs-string">&#x27;label&#x27;</span>] }</span>: <span class="hljs-subst">{ <span class="hljs-built_in">round</span>(p[<span class="hljs-string">&#x27;score&#x27;</span>] * <span class="hljs-number">100</span>, <span class="hljs-number">1</span>)}</span>%&quot;</span>)`,wrap:!1}}),N=new V({props:{title:"Embed Streamlit Spaces on other webpages",local:"embed-streamlit-spaces-on-other-webpages",headingTag:"h2"}}),G=new ee({props:{code:"JTNDaWZyYW1lJTBBJTIwJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZOaW1hQm9zY2FyaW5vLWhvdGRvZy1zdHJlYW1saXQuaGYuc3BhY2UlM0ZlbWJlZCUzRHRydWUlMjIlMEElMjAlMjB0aXRsZSUzRCUyMk15JTIwYXdlc29tZSUyMFN0cmVhbWxpdCUyMFNwYWNlJTIyJTBBJTNFJTNDJTJGaWZyYW1lJTNF",highlighted:`&lt;iframe
  src<span class="hljs-operator">=</span><span class="hljs-string">&quot;https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true&quot;</span>
  title<span class="hljs-operator">=</span><span class="hljs-string">&quot;My awesome Streamlit Space&quot;</span>
&gt;&lt;/iframe&gt;`,wrap:!1}}),q=new V({props:{title:"Embed Streamlit Spaces with auto-resizing IFrames",local:"embed-streamlit-spaces-with-auto-resizing-iframes",headingTag:"h2"}}),X=new ee({props:{code:"JTNDaWZyYW1lJTBBJTA5aWQlM0QlMjJ5b3VyLWlmcmFtZS1pZCUyMiUwQSUwOXNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGJTNDc3BhY2Utc3ViZG9tYWluJTNFLmhmLnNwYWNlJTIyJTBBJTA5ZnJhbWVib3JkZXIlM0QlMjIwJTIyJTBBJTA5d2lkdGglM0QlMjI4NTAlMjIlMEElMDloZWlnaHQlM0QlMjI0NTAlMjIlMEElM0UlM0MlMkZpZnJhbWUlM0UlMEElM0NzY3JpcHQlMjBzcmMlM0QlMjJodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkZpZnJhbWUtcmVzaXplciU0MDQuMy40JTJGanMlMkZpZnJhbWVSZXNpemVyLm1pbi5qcyUyMiUzRSUzQyUyRnNjcmlwdCUzRSUwQSUzQ3NjcmlwdCUzRSUwQSUyMCUyMGlGcmFtZVJlc2l6ZSglN0IlN0QlMkMlMjAlMjIlMjN5b3VyLWlmcmFtZS1pZCUyMiklMEElM0MlMkZzY3JpcHQlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">iframe</span>
	<span class="hljs-attr">id</span>=<span class="hljs-string">&quot;your-iframe-id&quot;</span>
	<span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://&lt;space-subdomain&gt;.hf.space&quot;</span>
	<span class="hljs-attr">frameborder</span>=<span class="hljs-string">&quot;0&quot;</span>
	<span class="hljs-attr">width</span>=<span class="hljs-string">&quot;850&quot;</span>
	<span class="hljs-attr">height</span>=<span class="hljs-string">&quot;450&quot;</span>
&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">iframe</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/iframe-resizer@4.3.4/js/iframeResizer.min.js&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span>&gt;</span><span class="language-javascript">
  <span class="hljs-title function_">iFrameResize</span>({}, <span class="hljs-string">&quot;#your-iframe-id&quot;</span>)
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),{c(){w=n("meta"),te=l(),K=n("p"),se=l(),c(y.$$.fragment),ae=l(),T=n("p"),T.innerHTML=Re,le=l(),b=n("p"),b.innerHTML=Qe,ie=l(),j=n("p"),j.innerHTML=Ge,ne=l(),c(J.$$.fragment),oe=l(),S=n("p"),S.innerHTML=Ye,re=l(),v=n("p"),v.innerHTML=qe,pe=l(),c($.$$.fragment),ce=l(),U=n("p"),U.innerHTML=Ee,me=l(),I=n("p"),I.innerHTML=Fe,he=l(),c(Z.$$.fragment),de=l(),B=n("p"),B.innerHTML=Ae,fe=l(),c(k.$$.fragment),ue=l(),W=n("p"),W.innerHTML=Pe,ge=l(),c(H.$$.fragment),we=l(),L=n("p"),L.textContent=Xe,Me=l(),c(C.$$.fragment),ye=l(),z=n("p"),z.innerHTML=De,Te=l(),c(_.$$.fragment),be=l(),x=n("p"),x.innerHTML=Ve,je=l(),M=n("div"),M.innerHTML=Ke,Je=l(),c(N.$$.fragment),Se=l(),R=n("p"),R.innerHTML=Oe,ve=l(),Q=n("p"),Q.textContent=et,$e=l(),c(G.$$.fragment),Ue=l(),p=n("iframe"),Ie=l(),Y=n("p"),Y.innerHTML=st,Ze=l(),c(q.$$.fragment),Be=l(),E=n("p"),E.innerHTML=at,ke=l(),F=n("p"),F.innerHTML=lt,We=l(),A=n("ul"),A.innerHTML=it,He=l(),P=n("p"),P.innerHTML=nt,Le=l(),c(X.$$.fragment),Ce=l(),D=n("p"),D.innerHTML=ot,ze=l(),O=n("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),te=i(e),K=o(e,"P",{}),xe(K).forEach(s),se=i(e),m(y.$$.fragment,e),ae=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-155nn9c"&&(T.innerHTML=Re),le=i(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-fhngw3"&&(b.innerHTML=Qe),ie=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1lndvi6"&&(j.innerHTML=Ge),ne=i(e),m(J.$$.fragment,e),oe=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-rlzh8f"&&(S.innerHTML=Ye),re=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1i51m04"&&(v.innerHTML=qe),pe=i(e),m($.$$.fragment,e),ce=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-w37as0"&&(U.innerHTML=Ee),me=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1yuvt6i"&&(I.innerHTML=Fe),he=i(e),m(Z.$$.fragment,e),de=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-7i2a6u"&&(B.innerHTML=Ae),fe=i(e),m(k.$$.fragment,e),ue=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-12qvnza"&&(W.innerHTML=Pe),ge=i(e),m(H.$$.fragment,e),we=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-pc1ide"&&(L.textContent=Xe),Me=i(e),m(C.$$.fragment,e),ye=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1s8aj3m"&&(z.innerHTML=De),Te=i(e),m(_.$$.fragment,e),be=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1lyf612"&&(x.innerHTML=Ve),je=i(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-10soa41"&&(M.innerHTML=Ke),Je=i(e),m(N.$$.fragment,e),Se=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-h9u7cp"&&(R.innerHTML=Oe),ve=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-m5fkq0"&&(Q.textContent=et),$e=i(e),m(G.$$.fragment,e),Ue=i(e),p=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),xe(p).forEach(s),Ie=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-190mgpd"&&(Y.innerHTML=st),Ze=i(e),m(q.$$.fragment,e),Be=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1pycgf5"&&(E.innerHTML=at),ke=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1na14o1"&&(F.innerHTML=lt),We=i(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-13i7z0x"&&(A.innerHTML=it),He=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1hn154n"&&(P.innerHTML=nt),Le=i(e),m(X.$$.fragment,e),Ce=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-18gaz5u"&&(D.innerHTML=ot),ze=i(e),O=o(e,"P",{}),xe(O).forEach(s),this.h()},h(){g(w,"name","hf:doc:metadata"),g(w,"content",wt),g(M,"class","flex justify-center"),pt(p.src,tt="https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true")||g(p,"src",tt),g(p,"frameborder","0"),g(p,"height","364"),g(p,"title","Streamlit app"),g(p,"class","container p-0 flex-grow space-iframe"),g(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),g(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){ut(document.head,w),a(e,te,t),a(e,K,t),a(e,se,t),h(y,e,t),a(e,ae,t),a(e,T,t),a(e,le,t),a(e,b,t),a(e,ie,t),a(e,j,t),a(e,ne,t),h(J,e,t),a(e,oe,t),a(e,S,t),a(e,re,t),a(e,v,t),a(e,pe,t),h($,e,t),a(e,ce,t),a(e,U,t),a(e,me,t),a(e,I,t),a(e,he,t),h(Z,e,t),a(e,de,t),a(e,B,t),a(e,fe,t),h(k,e,t),a(e,ue,t),a(e,W,t),a(e,ge,t),h(H,e,t),a(e,we,t),a(e,L,t),a(e,Me,t),h(C,e,t),a(e,ye,t),a(e,z,t),a(e,Te,t),h(_,e,t),a(e,be,t),a(e,x,t),a(e,je,t),a(e,M,t),a(e,Je,t),h(N,e,t),a(e,Se,t),a(e,R,t),a(e,ve,t),a(e,Q,t),a(e,$e,t),h(G,e,t),a(e,Ue,t),a(e,p,t),a(e,Ie,t),a(e,Y,t),a(e,Ze,t),h(q,e,t),a(e,Be,t),a(e,E,t),a(e,ke,t),a(e,F,t),a(e,We,t),a(e,A,t),a(e,He,t),a(e,P,t),a(e,Le,t),h(X,e,t),a(e,Ce,t),a(e,D,t),a(e,ze,t),a(e,O,t),_e=!0},p:ct,i(e){_e||(d(y.$$.fragment,e),d(J.$$.fragment,e),d($.$$.fragment,e),d(Z.$$.fragment,e),d(k.$$.fragment,e),d(H.$$.fragment,e),d(C.$$.fragment,e),d(_.$$.fragment,e),d(N.$$.fragment,e),d(G.$$.fragment,e),d(q.$$.fragment,e),d(X.$$.fragment,e),_e=!0)},o(e){f(y.$$.fragment,e),f(J.$$.fragment,e),f($.$$.fragment,e),f(Z.$$.fragment,e),f(k.$$.fragment,e),f(H.$$.fragment,e),f(C.$$.fragment,e),f(_.$$.fragment,e),f(N.$$.fragment,e),f(G.$$.fragment,e),f(q.$$.fragment,e),f(X.$$.fragment,e),_e=!1},d(e){e&&(s(te),s(K),s(se),s(ae),s(T),s(le),s(b),s(ie),s(j),s(ne),s(oe),s(S),s(re),s(v),s(pe),s(ce),s(U),s(me),s(I),s(he),s(de),s(B),s(fe),s(ue),s(W),s(ge),s(we),s(L),s(Me),s(ye),s(z),s(Te),s(be),s(x),s(je),s(M),s(Je),s(Se),s(R),s(ve),s(Q),s($e),s(Ue),s(p),s(Ie),s(Y),s(Ze),s(Be),s(E),s(ke),s(F),s(We),s(A),s(He),s(P),s(Le),s(Ce),s(D),s(ze),s(O)),s(w),u(y,e),u(J,e),u($,e),u(Z,e),u(k,e),u(H,e),u(C,e),u(_,e),u(N,e),u(G,e),u(q,e),u(X,e)}}}const wt='{"title":"Streamlit Spaces","local":"streamlit-spaces","sections":[{"title":"Your First Streamlit Space: Hot Dog Classifier","local":"your-first-streamlit-space-hot-dog-classifier","sections":[],"depth":2},{"title":"Create a new Streamlit Space","local":"create-a-new-streamlit-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the Streamlit app","local":"create-the-streamlit-app","sections":[],"depth":2},{"title":"Embed Streamlit Spaces on other webpages","local":"embed-streamlit-spaces-on-other-webpages","sections":[],"depth":2},{"title":"Embed Streamlit Spaces with auto-resizing IFrames","local":"embed-streamlit-spaces-with-auto-resizing-iframes","sections":[],"depth":2}],"depth":1}';function Mt(Ne){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends ht{constructor(w){super(),dt(this,w,Mt,gt,rt,{})}}export{Jt as component};
