import{s as pe,f as re,n as ye,o as ce}from"../chunks/scheduler.389d799c.js";import{S as de,i as me,g as i,s as a,r as p,A as ue,h as M,f as l,c as n,j as Ht,u as r,x as o,k as J,y as je,a as s,v as y,d as c,t as d,w as m}from"../chunks/index.8f81d18f.js";import{C as j}from"../chunks/CodeBlock.3845caa1.js";import{H as tt}from"../chunks/Heading.41733039.js";function he(vt){let h,st,et,at,w,nt,T,qt="The get started guide will show you how to quickly use Hugging Face on Amazon SageMaker. Learn how to fine-tune and deploy a pretrained 🤗 Transformers model on SageMaker for a binary text classification task.",it,U,St='💡 If you are new to Hugging Face, we recommend first reading the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/quicktour" rel="nofollow">quick tour</a>.',Mt,u,Qt,ot,f,xt='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">agemaker-notebook.ipynb file</a> to follow along!',pt,g,rt,b,Et='Get started by installing the necessary Hugging Face libraries and SageMaker. You will also need to install <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch</a> and <a href="https://www.tensorflow.org/install/pip#tensorflow-2-packages-are-available" rel="nofollow">TensorFlow</a> if you don’t already have it installed.',yt,I,ct,C,Lt='If you want to run this example in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio.html" rel="nofollow">SageMaker Studio</a>, upgrade <a href="https://ipywidgets.readthedocs.io/en/latest/" rel="nofollow">ipywidgets</a> for the 🤗 Datasets library and restart the kernel:',dt,k,mt,Z,Pt='Next, you should set up your environment: a SageMaker session and an S3 bucket. The S3 bucket will store data, models, and logs. You will need access to an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM execution role</a> with the required permissions.',ut,A,Dt='If you are planning on using SageMaker in a local environment, you need to provide the <code>role</code> yourself. Learn more about how to set this up <a href="https://huggingface.co/docs/sagemaker/train#installation-and-setup" rel="nofollow">here</a>.',jt,$,Kt="⚠️ The execution role is only available when you run a notebook within SageMaker. If you try to run <code>get_execution_role</code> in a notebook not on SageMaker, you will get a region error.",ht,X,Jt,W,wt,_,Ot='The 🤗 Datasets library makes it easy to download and preprocess a dataset for training. Download and tokenize the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb</a> dataset:',Tt,G,Ut,B,ft,z,te='Next, upload the preprocessed dataset to your S3 session bucket with 🤗 Datasets S3 <a href="https://huggingface.co/docs/datasets/filesystems.html" rel="nofollow">filesystem</a> implementation:',gt,Y,bt,V,It,N,ee="Create a Hugging Face Estimator to handle end-to-end SageMaker training and deployment. The most important parameters to pay attention to are:",Ct,R,le='<li><code>entry_point</code> refers to the fine-tuning script which you can find in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li> <li><code>instance_type</code> refers to the SageMaker instance that will be launched. Take a look <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> refers to the training hyperparameters the model will be fine-tuned with.</li>',kt,F,Zt,H,se="Begin training with one line of code:",At,v,$t,q,Xt,S,ae="Once the training job is complete, deploy your fine-tuned model by calling <code>deploy()</code> with the number of instances and instance type:",Wt,Q,_t,x,ne="Call <code>predict()</code> on your data:",Gt,E,Bt,L,ie="After running your request, delete the endpoint:",zt,P,Yt,D,Vt,K,Me="Congratulations, you’ve just fine-tuned and deployed a pretrained 🤗 Transformers model on SageMaker! 🎉",Nt,O,oe='For your next steps, keep reading our documentation for more details about training and deployment. There are many interesting features such as <a href="/docs/sagemaker/train#distributed-training">distributed training</a> and <a href="/docs/sagemaker/train#spot-instances">Spot instances</a>.',Rt,lt,Ft;return w=new tt({props:{title:"Train and deploy Hugging Face on Amazon SageMaker",local:"train-and-deploy-hugging-face-on-amazon-sagemaker",headingTag:"h1"}}),g=new tt({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),I=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNhZ2VtYWtlciUzRSUzRDIuMTQwLjAlMjIlMjAlMjJ0cmFuc2Zvcm1lcnMlM0QlM0Q0LjI2LjElMjIlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xMC4xJTIyJTIwLS11cGdyYWRl",highlighted:'pip install <span class="hljs-string">&quot;sagemaker&gt;=2.140.0&quot;</span> <span class="hljs-string">&quot;transformers==4.26.1&quot;</span> <span class="hljs-string">&quot;datasets[s3]==2.10.1&quot;</span> --upgrade',wrap:!1}}),k=new j({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMElQeXRob24lMEEhY29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGlweXdpZGdldHMlMjAteSUwQUlQeXRob24uQXBwbGljYXRpb24uaW5zdGFuY2UoKS5rZXJuZWwuZG9fc2h1dGRvd24oVHJ1ZSk=",highlighted:`%%capture
<span class="hljs-keyword">import</span> IPython
!conda install -c conda-forge ipywidgets -y
IPython.Application.instance().kernel.do_shutdown(<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjAlM0QlMjBOb25lJTBBaWYlMjBzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjBpcyUyME5vbmUlMjBhbmQlMjBzZXNzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb25fYnVja2V0JTIwJTNEJTIwc2Vzcy5kZWZhdWx0X2J1Y2tldCgpJTBBJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker

sess = sagemaker.Session()
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    sagemaker_session_bucket = sess.default_bucket()

role = sagemaker.get_execution_role()
sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)`,wrap:!1}}),W=new tt({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),G=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBsb2FkJTIwZGF0YXNldCUwQXRyYWluX2RhdGFzZXQlMkMlMjB0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTVCJTIydHJhaW4lMjIlMkMlMjAlMjJ0ZXN0JTIyJTVEKSUwQSUwQSUyMyUyMGxvYWQlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdG9rZW5pemF0aW9uJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMjMlMjB0b2tlbml6ZSUyMHRyYWluJTIwYW5kJTIwdGVzdCUyMGRhdGFzZXRzJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRyYWluX2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0Lm1hcCh0b2tlbml6ZSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQSUwQSUyMyUyMHNldCUyMGRhdGFzZXQlMjBmb3JtYXQlMjBmb3IlMjBQeVRvcmNoJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMCUyMHRyYWluX2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0cmFpbl9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIpJTBBdGVzdF9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># load dataset</span>
train_dataset, test_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=[<span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>])

<span class="hljs-comment"># load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>)

<span class="hljs-comment"># create tokenization function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># tokenize train and test datasets</span>
train_dataset = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)
test_dataset = test_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># set dataset format for PyTorch</span>
train_dataset =  train_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
train_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])
test_dataset = test_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
test_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),B=new tt({props:{title:"Upload dataset to S3 bucket",local:"upload-dataset-to-s3-bucket",headingTag:"h2"}}),Y=new j({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMHMzJTBBdHJhaW5pbmdfaW5wdXRfcGF0aCUyMCUzRCUyMGYnczMlM0ElMkYlMkYlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMkYlN0JzM19wcmVmaXglN0QlMkZ0cmFpbiclMEF0cmFpbl9kYXRhc2V0LnNhdmVfdG9fZGlzayh0cmFpbmluZ19pbnB1dF9wYXRoKSUwQSUwQSUyMyUyMHNhdmUlMjB0ZXN0X2RhdGFzZXQlMjB0byUyMHMzJTBBdGVzdF9pbnB1dF9wYXRoJTIwJTNEJTIwZidzMyUzQSUyRiUyRiU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyRiU3QnMzX3ByZWZpeCU3RCUyRnRlc3QnJTBBdGVzdF9kYXRhc2V0LnNhdmVfdG9fZGlzayh0ZXN0X2lucHV0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to s3</span>
training_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/train&#x27;</span>
train_dataset.save_to_disk(training_input_path)

<span class="hljs-comment"># save test_dataset to s3</span>
test_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/test&#x27;</span>
test_dataset.save_to_disk(test_input_path)`,wrap:!1}}),V=new tt({props:{title:"Start a training job",local:"start-a-training-job",headingTag:"h2"}}),F=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

hyperparameters={
    <span class="hljs-string">&quot;epochs&quot;</span>: <span class="hljs-number">1</span>,                                       <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-number">32</span>,                            <span class="hljs-comment"># training batch size</span>
    <span class="hljs-string">&quot;model_name&quot;</span>:<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>  <span class="hljs-comment"># name of pretrained model</span>
}

huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;train.py&quot;</span>,                 <span class="hljs-comment"># fine-tuning script to use in training job</span>
    source_dir=<span class="hljs-string">&quot;./scripts&quot;</span>,                 <span class="hljs-comment"># directory where fine-tuning script is stored</span>
    instance_type=<span class="hljs-string">&quot;ml.p3.2xlarge&quot;</span>,          <span class="hljs-comment"># instance type</span>
    instance_count=<span class="hljs-number">1</span>,                       <span class="hljs-comment"># number of instances</span>
    role=role,                              <span class="hljs-comment"># IAM role used in training job to acccess AWS resources (S3)</span>
    transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,             <span class="hljs-comment"># Transformers version</span>
    pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                  <span class="hljs-comment"># PyTorch version</span>
    py_version=<span class="hljs-string">&quot;py39&quot;</span>,                      <span class="hljs-comment"># Python version</span>
    hyperparameters=hyperparameters         <span class="hljs-comment"># hyperparameters to use in training job</span>
)`,wrap:!1}}),v=new j({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglN0IlMjJ0cmFpbiUyMiUzQSUyMHRyYWluaW5nX2lucHV0X3BhdGglMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwdGVzdF9pbnB1dF9wYXRoJTdEKQ==",highlighted:'huggingface_estimator.fit({<span class="hljs-string">&quot;train&quot;</span>: training_input_path, <span class="hljs-string">&quot;test&quot;</span>: test_input_path})',wrap:!1}}),q=new tt({props:{title:"Deploy model",local:"deploy-model",headingTag:"h2"}}),Q=new j({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMm1sLmc0ZG4ueGxhcmdlJTIyKQ==",highlighted:'predictor = huggingface_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>,<span class="hljs-string">&quot;ml.g4dn.xlarge&quot;</span>)',wrap:!1}}),E=new j({props:{code:"c2VudGltZW50X2lucHV0JTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySXQlMjBmZWVscyUyMGxpa2UlMjBhJTIwY3VydGFpbiUyMGNsb3NpbmcuLi50aGVyZSUyMHdhcyUyMGFuJTIwZWxlZ2FuY2UlMjBpbiUyMHRoZSUyMHdheSUyMHRoZXklMjBtb3ZlZCUyMHRvd2FyZCUyMGNvbmNsdXNpb24uJTIwTm8lMjBmYW4lMjBpcyUyMGdvaW5nJTIwdG8lMjB3YXRjaCUyMGFuZCUyMGZlZWwlMjBzaG9ydC1jaGFuZ2VkLiUyMiU3RCUwQSUwQXByZWRpY3Rvci5wcmVkaWN0KHNlbnRpbWVudF9pbnB1dCk=",highlighted:`sentiment_input = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;It feels like a curtain closing...there was an elegance in the way they moved toward conclusion. No fan is going to watch and feel short-changed.&quot;</span>}

predictor.predict(sentiment_input)`,wrap:!1}}),P=new j({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:"predictor.delete_endpoint()",wrap:!1}}),D=new tt({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),{c(){h=i("meta"),st=a(),et=i("p"),at=a(),p(w.$$.fragment),nt=a(),T=i("p"),T.textContent=qt,it=a(),U=i("p"),U.innerHTML=St,Mt=a(),u=i("iframe"),ot=a(),f=i("p"),f.innerHTML=xt,pt=a(),p(g.$$.fragment),rt=a(),b=i("p"),b.innerHTML=Et,yt=a(),p(I.$$.fragment),ct=a(),C=i("p"),C.innerHTML=Lt,dt=a(),p(k.$$.fragment),mt=a(),Z=i("p"),Z.innerHTML=Pt,ut=a(),A=i("p"),A.innerHTML=Dt,jt=a(),$=i("p"),$.innerHTML=Kt,ht=a(),p(X.$$.fragment),Jt=a(),p(W.$$.fragment),wt=a(),_=i("p"),_.innerHTML=Ot,Tt=a(),p(G.$$.fragment),Ut=a(),p(B.$$.fragment),ft=a(),z=i("p"),z.innerHTML=te,gt=a(),p(Y.$$.fragment),bt=a(),p(V.$$.fragment),It=a(),N=i("p"),N.textContent=ee,Ct=a(),R=i("ul"),R.innerHTML=le,kt=a(),p(F.$$.fragment),Zt=a(),H=i("p"),H.textContent=se,At=a(),p(v.$$.fragment),$t=a(),p(q.$$.fragment),Xt=a(),S=i("p"),S.innerHTML=ae,Wt=a(),p(Q.$$.fragment),_t=a(),x=i("p"),x.innerHTML=ne,Gt=a(),p(E.$$.fragment),Bt=a(),L=i("p"),L.textContent=ie,zt=a(),p(P.$$.fragment),Yt=a(),p(D.$$.fragment),Vt=a(),K=i("p"),K.textContent=Me,Nt=a(),O=i("p"),O.innerHTML=oe,Rt=a(),lt=i("p"),this.h()},l(t){const e=ue("svelte-u9bgzb",document.head);h=M(e,"META",{name:!0,content:!0}),e.forEach(l),st=n(t),et=M(t,"P",{}),Ht(et).forEach(l),at=n(t),r(w.$$.fragment,t),nt=n(t),T=M(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-n7q5fy"&&(T.textContent=qt),it=n(t),U=M(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-uamv5h"&&(U.innerHTML=St),Mt=n(t),u=M(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ht(u).forEach(l),ot=n(t),f=M(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-rt6seb"&&(f.innerHTML=xt),pt=n(t),r(g.$$.fragment,t),rt=n(t),b=M(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-10ldwp9"&&(b.innerHTML=Et),yt=n(t),r(I.$$.fragment,t),ct=n(t),C=M(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-yozy2b"&&(C.innerHTML=Lt),dt=n(t),r(k.$$.fragment,t),mt=n(t),Z=M(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1sllt2f"&&(Z.innerHTML=Pt),ut=n(t),A=M(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-tg9h77"&&(A.innerHTML=Dt),jt=n(t),$=M(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-y9vgbx"&&($.innerHTML=Kt),ht=n(t),r(X.$$.fragment,t),Jt=n(t),r(W.$$.fragment,t),wt=n(t),_=M(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-b8daui"&&(_.innerHTML=Ot),Tt=n(t),r(G.$$.fragment,t),Ut=n(t),r(B.$$.fragment,t),ft=n(t),z=M(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-nm384r"&&(z.innerHTML=te),gt=n(t),r(Y.$$.fragment,t),bt=n(t),r(V.$$.fragment,t),It=n(t),N=M(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-16p4w97"&&(N.textContent=ee),Ct=n(t),R=M(t,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1bnefx4"&&(R.innerHTML=le),kt=n(t),r(F.$$.fragment,t),Zt=n(t),H=M(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-b865q9"&&(H.textContent=se),At=n(t),r(v.$$.fragment,t),$t=n(t),r(q.$$.fragment,t),Xt=n(t),S=M(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-twh61n"&&(S.innerHTML=ae),Wt=n(t),r(Q.$$.fragment,t),_t=n(t),x=M(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19s4ndj"&&(x.innerHTML=ne),Gt=n(t),r(E.$$.fragment,t),Bt=n(t),L=M(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-l180zc"&&(L.textContent=ie),zt=n(t),r(P.$$.fragment,t),Yt=n(t),r(D.$$.fragment,t),Vt=n(t),K=M(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1rjk4za"&&(K.textContent=Me),Nt=n(t),O=M(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1qzgnqe"&&(O.innerHTML=oe),Rt=n(t),lt=M(t,"P",{}),Ht(lt).forEach(l),this.h()},h(){J(h,"name","hf:doc:metadata"),J(h,"content",Je),J(u,"width","560"),J(u,"height","315"),re(u.src,Qt="https://www.youtube.com/embed/pYqjCzoyWyo")||J(u,"src",Qt),J(u,"title","YouTube video player"),J(u,"frameborder","0"),J(u,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),u.allowFullscreen=""},m(t,e){je(document.head,h),s(t,st,e),s(t,et,e),s(t,at,e),y(w,t,e),s(t,nt,e),s(t,T,e),s(t,it,e),s(t,U,e),s(t,Mt,e),s(t,u,e),s(t,ot,e),s(t,f,e),s(t,pt,e),y(g,t,e),s(t,rt,e),s(t,b,e),s(t,yt,e),y(I,t,e),s(t,ct,e),s(t,C,e),s(t,dt,e),y(k,t,e),s(t,mt,e),s(t,Z,e),s(t,ut,e),s(t,A,e),s(t,jt,e),s(t,$,e),s(t,ht,e),y(X,t,e),s(t,Jt,e),y(W,t,e),s(t,wt,e),s(t,_,e),s(t,Tt,e),y(G,t,e),s(t,Ut,e),y(B,t,e),s(t,ft,e),s(t,z,e),s(t,gt,e),y(Y,t,e),s(t,bt,e),y(V,t,e),s(t,It,e),s(t,N,e),s(t,Ct,e),s(t,R,e),s(t,kt,e),y(F,t,e),s(t,Zt,e),s(t,H,e),s(t,At,e),y(v,t,e),s(t,$t,e),y(q,t,e),s(t,Xt,e),s(t,S,e),s(t,Wt,e),y(Q,t,e),s(t,_t,e),s(t,x,e),s(t,Gt,e),y(E,t,e),s(t,Bt,e),s(t,L,e),s(t,zt,e),y(P,t,e),s(t,Yt,e),y(D,t,e),s(t,Vt,e),s(t,K,e),s(t,Nt,e),s(t,O,e),s(t,Rt,e),s(t,lt,e),Ft=!0},p:ye,i(t){Ft||(c(w.$$.fragment,t),c(g.$$.fragment,t),c(I.$$.fragment,t),c(k.$$.fragment,t),c(X.$$.fragment,t),c(W.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(Y.$$.fragment,t),c(V.$$.fragment,t),c(F.$$.fragment,t),c(v.$$.fragment,t),c(q.$$.fragment,t),c(Q.$$.fragment,t),c(E.$$.fragment,t),c(P.$$.fragment,t),c(D.$$.fragment,t),Ft=!0)},o(t){d(w.$$.fragment,t),d(g.$$.fragment,t),d(I.$$.fragment,t),d(k.$$.fragment,t),d(X.$$.fragment,t),d(W.$$.fragment,t),d(G.$$.fragment,t),d(B.$$.fragment,t),d(Y.$$.fragment,t),d(V.$$.fragment,t),d(F.$$.fragment,t),d(v.$$.fragment,t),d(q.$$.fragment,t),d(Q.$$.fragment,t),d(E.$$.fragment,t),d(P.$$.fragment,t),d(D.$$.fragment,t),Ft=!1},d(t){t&&(l(st),l(et),l(at),l(nt),l(T),l(it),l(U),l(Mt),l(u),l(ot),l(f),l(pt),l(rt),l(b),l(yt),l(ct),l(C),l(dt),l(mt),l(Z),l(ut),l(A),l(jt),l($),l(ht),l(Jt),l(wt),l(_),l(Tt),l(Ut),l(ft),l(z),l(gt),l(bt),l(It),l(N),l(Ct),l(R),l(kt),l(Zt),l(H),l(At),l($t),l(Xt),l(S),l(Wt),l(_t),l(x),l(Gt),l(Bt),l(L),l(zt),l(Yt),l(Vt),l(K),l(Nt),l(O),l(Rt),l(lt)),l(h),m(w,t),m(g,t),m(I,t),m(k,t),m(X,t),m(W,t),m(G,t),m(B,t),m(Y,t),m(V,t),m(F,t),m(v,t),m(q,t),m(Q,t),m(E,t),m(P,t),m(D,t)}}}const Je='{"title":"Train and deploy Hugging Face on Amazon SageMaker","local":"train-and-deploy-hugging-face-on-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Upload dataset to S3 bucket","local":"upload-dataset-to-s3-bucket","sections":[],"depth":2},{"title":"Start a training job","local":"start-a-training-job","sections":[],"depth":2},{"title":"Deploy model","local":"deploy-model","sections":[],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function we(vt){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends de{constructor(h){super(),me(this,h,we,he,pe,{})}}export{be as component};
