import{s as ra,o as ua,n as Ys}from"../chunks/scheduler.37c15a92.js";import{S as oa,i as Ta,g as U,s as t,r as e,A as ha,h as r,f as n,c as p,j as ca,u as y,x as o,k as Ua,y as wa,a,v as j,d as J,t as i,w as c}from"../chunks/index.2bf4358c.js";import{T as Rs}from"../chunks/Tip.363c041f.js";import{Y as Ca}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{C as xa}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{H as In,E as ma}from"../chunks/getInferenceSnippets.a20d43a9.js";function ga(C){let M,h="💡 本節深入介紹了BPE，甚至展示了一個完整的實現。如果你只想大致瞭解標記化算法，可以跳到最後。";return{c(){M=U("p"),M.textContent=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1ujy58m"&&(M.textContent=h)},m(u,w){a(u,M,w)},p:Ys,d(u){u&&n(M)}}}function Ia(C){let M,h="TGPT-2 和 RoBERTa 標記器(非常相似)有一個聰明的方法來處理這個問題: 他們不把單詞看成是用 Unicode 字符寫的，而是用字節寫的。這樣，基本詞彙表的大小很小(256),但你能想到的每個字符仍將被包含在內,而不會最終轉換為未知標記。這個技巧被稱為 <em>字節級 BPE</em>。";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1164592"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Ys,d(u){u&&n(M)}}}function fa(C){let M,h="✏️ <strong>現在輪到你了!</strong>你認為下一個合併規則是什麼？";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-15gt3yg"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Ys,d(u){u&&n(M)}}}function $a(C){let M,h="✏️ <strong>現在輪到你了!</strong> 你認為這個詞 <code>&quot;unhug&quot;</code> 將如何被標記？";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1jbc3w4"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Ys,d(u){u&&n(M)}}}function da(C){let M,h="💡 在同一語料庫上使用 <code>train_new_from_iterator()</code> 不會產生完全相同的詞彙表。這是因為當有最頻繁對的選擇時,我們選擇遇到的第一個, 而 🤗 Tokenizers 庫根據內部ID選擇第一個。";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-ao5ez3"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Ys,d(u){u&&n(M)}}}function qa(C){let M,h="⚠️ 如果存在未知字符,我們的實現將拋出錯誤,因為我們沒有做任何處理它們。GPT-2 實際上沒有未知標記(使用字節級 BPE 時不可能得到未知字符),但這可能發生在這裡,因為我們沒有在初始詞彙表中包含所有可能的字節。 BPE 的這方面超出了本節的範圍,因此我們忽略了細節。";return{c(){M=U("p"),M.textContent=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1csxy0s"&&(M.textContent=h)},m(u,w){a(u,M,w)},p:Ys,d(u){u&&n(M)}}}function ba(C){let M,h,u,w,d,Ps,q,Fs,b,fn="字節對編碼(BPE)最初被開發為一種壓縮文本的算法,然後在預訓練 GPT 模型時被 OpenAI 用於標記化。許多 Transformer 模型都使用它,包括 GPT、GPT-2、RoBERTa、BART 和 DeBERTa。",Ls,Q,Os,x,sl,k,ll,A,$n="BPE 訓練首先計算語料庫中使用的唯一單詞集(在完成標準化和預標記化步驟之後)，然後通過獲取用於編寫這些單詞的所有符號來構建詞彙表。舉一個簡單的例子，假設我們的語料庫使用了這五個詞:",nl,B,al,V,dn="基礎詞彙將是 <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>。對於實際情況，基本詞彙表將包含所有 ASCII 字符，至少，可能還包含一些 Unicode 字符。如果您正在標記的示例使用不在訓練語料庫中的字符，則該字符將轉換為未知標記。這就是為什麼許多 NLP 模型在分析帶有表情符號的內容方面非常糟糕的原因之一。",tl,m,pl,E,qn="獲得這個基本詞彙後，我們添加新的標記，直到通過學習<em>合併</em>達到所需的詞彙量，這是將現有詞彙表的兩個元素合併為一個新元素的規則。因此在開始時，這些合併將創建具有兩個字符的標記，然後隨著訓練的進行，會創建更長的子詞。",Ml,Z,bn="在分詞器訓練期間的任何一步，BPE 算法都會搜索最常見的現有標記對 (“對”,這裡我們指的是單詞中的兩個連續標記)。最頻繁的一對將被合併，我們沖洗並重複下一步。",el,z,Qn="回到我們之前的例子，讓我們假設單詞具有以下頻率：",yl,G,jl,S,kn="意味著 <code>&quot;hug&quot;</code> 在語料庫中出現了10次, <code>&quot;pug&quot;</code> 5次, <code>&quot;pun&quot;</code> 12次, <code>&quot;bun&quot;</code> 4次, 以及 <code>&quot;hugs&quot;</code> 5次。我們通過將每個單詞拆分為字符(形成我們初始詞彙表的字符)來開始訓練,這樣我們就可以將每個單詞視為一個標記列表:",Jl,_,il,N,An="然後我們看成對。這對 <code>(&quot;h&quot;, &quot;u&quot;)</code> 出現在單詞 <code>&quot;hug&quot;</code> 和 <code>&quot;hugs&quot;</code>中,所以語料庫中總共有15次。不過,這並不是最頻繁的一對:這個榮譽屬於 <code>(&quot;u&quot;, &quot;g&quot;)</code>,它出現在 <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, 以及 <code>&quot;hugs&quot;</code>中,在詞彙表中總共 20 次。",cl,v,Bn="因此,標記器學習的第一個合併規則是 <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>,意思就是 <code>&quot;ug&quot;</code> 將被添加到詞彙表中,並且這對應該合併到語料庫的所有單詞中。在這個階段結束時,詞彙表和語料庫看起來像這樣:",Ul,H,rl,X,Vn="現在我們有一些導致標記長於兩個字符的對: 例如 <code>(&quot;h&quot;, &quot;ug&quot;)</code>, 在語料庫中出現15次。然而,這個階段最頻繁的對是 <code>(&quot;u&quot;, &quot;n&quot;)</code>,在語料庫中出現16次,所以學到的第二個合併規則是 <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>。將其添加到詞彙表併合並所有現有的這個對,將出現:",ul,D,ol,W,En="現在最頻繁的一對是 <code>(&quot;h&quot;, &quot;ug&quot;)</code>,所以我們學習了合併規則 <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>,這給了我們第一個三個字母的標記。合併後,語料庫如下所示:",Tl,R,hl,Y,Zn="我們繼續這樣合併,直到達到我們所需的詞彙量。",wl,g,Cl,K,xl,P,zn="標記化緊跟訓練過程,從某種意義上說,通過應用以下步驟對新輸入進行標記:",ml,F,Gn="<li>規範化</li> <li>預標記化</li> <li>將單詞拆分為單個字符</li> <li>將學習的合併規則按順序應用於這些拆分</li>",gl,L,Sn="讓我們以我們在訓練期間使用的示例為例,學習三個合併規則:",Il,O,fl,ss,_n="這個單詞 <code>&quot;bug&quot;</code> 將被標記為 <code>[&quot;b&quot;, &quot;ug&quot;]</code>。然而 <code>&quot;mug&quot;</code>,將被標記為 <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code>,因為字母 <code>&quot;m&quot;</code> 不再基本詞彙表中。同樣,單詞<code>&quot;thug&quot;</code> 會被標記為 <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: 字母 <code>&quot;t&quot;</code> 不在基本詞彙表中,應用合併規則首先導致 <code>&quot;u&quot;</code> 和 <code>&quot;g&quot;</code> 被合併,然後是 <code>&quot;hu&quot;</code> 和 <code>&quot;g&quot;</code> 被合併。",$l,I,dl,ls,ql,ns,Nn="現在讓我們看一下 BPE 算法的實現。這不會是你可以在大型語料庫上實際使用的優化版本;我們只是想向你展示代碼,以便你可以更好地理解算法",bl,as,vn="首先我們需要一個語料庫,所以讓我們用幾句話創建一個簡單的語料庫:",Ql,ts,kl,ps,Hn="接下來,我們需要將該語料庫預先標記為單詞。由於我們正在複製 BPE 標記器(如 GPT-2),我們將使用 <code>gpt2</code> 標記器作為預標記化的標記器:",Al,Ms,Bl,es,Xn="然後我們在進行預標記化時計算語料庫中每個單詞的頻率:",Vl,ys,El,js,Zl,Js,Dn="下一步是計算基本詞彙,由語料庫中使用的所有字符組成:",zl,is,Gl,cs,Sl,Us,Wn="我們還在該詞彙表的開頭添加了模型使用的特殊標記。對於GPT-2,唯一的特殊標記是 <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",_l,rs,Nl,us,Rn="我們現在需要將每個單詞拆分為單獨的字符,以便能夠開始訓練:",vl,os,Hl,Ts,Yn="現在我們已準備好進行訓練,讓我們編寫一個函數來計算每對的頻率。我們需要在訓練的每個步驟中使用它:",Xl,hs,Dl,ws,Kn="讓我們來看看這個字典在初始拆分後的一部分:",Wl,Cs,Rl,xs,Yl,ms,Pn="現在, 找到最頻繁的對只需要一個快速的循環:",Kl,gs,Pl,Is,Fl,fs,Fn="所以第一個要學習的合併是 <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, 我們添加 <code>&#39;Ġt&#39;</code> 到詞彙表:",Ll,$s,Ol,ds,Ln="要繼續接下來的步驟,我們需要在我們的<code>分詞</code>字典中應用該合併。讓我們為此編寫另一個函數:",sn,qs,ln,bs,On="我們可以看看第一次合併的結果:",nn,Qs,an,ks,tn,As,sa="現在我們有了循環所需的一切,直到我們學會了我們想要的所有合併。我們的目標是詞彙量達到50:",pn,Bs,Mn,Vs,la="結果,我們學習了 19 條合併規則(初始詞彙表的大小 31 — 30 字母字符,加上特殊標記):",en,Es,yn,Zs,jn,zs,na="詞彙表由特殊標記、初始字母和所有合併結果組成:",Jn,Gs,cn,Ss,Un,f,rn,_s,aa="為了對新文本進行分詞,我們對其進行預分詞、拆分，然後應用學到的所有合併規則:",un,Ns,on,vs,ta="我們可以在任何由字母表中的字符組成的文本上嘗試這個:",Tn,Hs,hn,Xs,wn,$,Cn,Ds,pa="這就是 BPE 算法！接下來,我們將看看 WordPiece。",xn,Ws,mn,Ks,gn;return d=new In({props:{title:"字節對編碼標記化",local:"字節對編碼標記化",headingTag:"h1"}}),q=new xa({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"}]}}),Q=new Ca({props:{id:"HEikzVL-lZU"}}),x=new Rs({props:{$$slots:{default:[ga]},$$scope:{ctx:C}}}),k=new In({props:{title:"訓練算法",local:"訓練算法",headingTag:"h2"}}),B=new T({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),m=new Rs({props:{$$slots:{default:[Ia]},$$scope:{ctx:C}}}),G=new T({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),_=new T({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),D=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),g=new Rs({props:{$$slots:{default:[fa]},$$scope:{ctx:C}}}),K=new In({props:{title:"標記化算法",local:"標記化算法",headingTag:"h2"}}),O=new T({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),I=new Rs({props:{$$slots:{default:[$a]},$$scope:{ctx:C}}}),ls=new In({props:{title:"實現 BPE",local:"實現-bpe",headingTag:"h2"}}),ts=new T({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Ms=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),ys=new T({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),js=new T({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),is=new T({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),cs=new T({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),rs=new T({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),os=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),hs=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),Cs=new T({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),xs=new T({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),gs=new T({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),Is=new T({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),$s=new T({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),qs=new T({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),Qs=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),ks=new T({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new T({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Es=new T({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Zs=new T({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Gs=new T({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new T({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Rs({props:{$$slots:{default:[da]},$$scope:{ctx:C}}}),Ns=new T({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new T({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Xs=new T({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$=new Rs({props:{warning:!0,$$slots:{default:[qa]},$$scope:{ctx:C}}}),Ws=new ma({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter6/5.mdx"}}),{c(){M=U("meta"),h=t(),u=U("p"),w=t(),e(d.$$.fragment),Ps=t(),e(q.$$.fragment),Fs=t(),b=U("p"),b.textContent=fn,Ls=t(),e(Q.$$.fragment),Os=t(),e(x.$$.fragment),sl=t(),e(k.$$.fragment),ll=t(),A=U("p"),A.textContent=$n,nl=t(),e(B.$$.fragment),al=t(),V=U("p"),V.innerHTML=dn,tl=t(),e(m.$$.fragment),pl=t(),E=U("p"),E.innerHTML=qn,Ml=t(),Z=U("p"),Z.textContent=bn,el=t(),z=U("p"),z.textContent=Qn,yl=t(),e(G.$$.fragment),jl=t(),S=U("p"),S.innerHTML=kn,Jl=t(),e(_.$$.fragment),il=t(),N=U("p"),N.innerHTML=An,cl=t(),v=U("p"),v.innerHTML=Bn,Ul=t(),e(H.$$.fragment),rl=t(),X=U("p"),X.innerHTML=Vn,ul=t(),e(D.$$.fragment),ol=t(),W=U("p"),W.innerHTML=En,Tl=t(),e(R.$$.fragment),hl=t(),Y=U("p"),Y.textContent=Zn,wl=t(),e(g.$$.fragment),Cl=t(),e(K.$$.fragment),xl=t(),P=U("p"),P.textContent=zn,ml=t(),F=U("ol"),F.innerHTML=Gn,gl=t(),L=U("p"),L.textContent=Sn,Il=t(),e(O.$$.fragment),fl=t(),ss=U("p"),ss.innerHTML=_n,$l=t(),e(I.$$.fragment),dl=t(),e(ls.$$.fragment),ql=t(),ns=U("p"),ns.textContent=Nn,bl=t(),as=U("p"),as.textContent=vn,Ql=t(),e(ts.$$.fragment),kl=t(),ps=U("p"),ps.innerHTML=Hn,Al=t(),e(Ms.$$.fragment),Bl=t(),es=U("p"),es.textContent=Xn,Vl=t(),e(ys.$$.fragment),El=t(),e(js.$$.fragment),Zl=t(),Js=U("p"),Js.textContent=Dn,zl=t(),e(is.$$.fragment),Gl=t(),e(cs.$$.fragment),Sl=t(),Us=U("p"),Us.innerHTML=Wn,_l=t(),e(rs.$$.fragment),Nl=t(),us=U("p"),us.textContent=Rn,vl=t(),e(os.$$.fragment),Hl=t(),Ts=U("p"),Ts.textContent=Yn,Xl=t(),e(hs.$$.fragment),Dl=t(),ws=U("p"),ws.textContent=Kn,Wl=t(),e(Cs.$$.fragment),Rl=t(),e(xs.$$.fragment),Yl=t(),ms=U("p"),ms.textContent=Pn,Kl=t(),e(gs.$$.fragment),Pl=t(),e(Is.$$.fragment),Fl=t(),fs=U("p"),fs.innerHTML=Fn,Ll=t(),e($s.$$.fragment),Ol=t(),ds=U("p"),ds.innerHTML=Ln,sn=t(),e(qs.$$.fragment),ln=t(),bs=U("p"),bs.textContent=On,nn=t(),e(Qs.$$.fragment),an=t(),e(ks.$$.fragment),tn=t(),As=U("p"),As.textContent=sa,pn=t(),e(Bs.$$.fragment),Mn=t(),Vs=U("p"),Vs.textContent=la,en=t(),e(Es.$$.fragment),yn=t(),e(Zs.$$.fragment),jn=t(),zs=U("p"),zs.textContent=na,Jn=t(),e(Gs.$$.fragment),cn=t(),e(Ss.$$.fragment),Un=t(),e(f.$$.fragment),rn=t(),_s=U("p"),_s.textContent=aa,un=t(),e(Ns.$$.fragment),on=t(),vs=U("p"),vs.textContent=ta,Tn=t(),e(Hs.$$.fragment),hn=t(),e(Xs.$$.fragment),wn=t(),e($.$$.fragment),Cn=t(),Ds=U("p"),Ds.textContent=pa,xn=t(),e(Ws.$$.fragment),mn=t(),Ks=U("p"),this.h()},l(s){const l=ha("svelte-u9bgzb",document.head);M=r(l,"META",{name:!0,content:!0}),l.forEach(n),h=p(s),u=r(s,"P",{}),ca(u).forEach(n),w=p(s),y(d.$$.fragment,s),Ps=p(s),y(q.$$.fragment,s),Fs=p(s),b=r(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-17pox8i"&&(b.textContent=fn),Ls=p(s),y(Q.$$.fragment,s),Os=p(s),y(x.$$.fragment,s),sl=p(s),y(k.$$.fragment,s),ll=p(s),A=r(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-2inrj6"&&(A.textContent=$n),nl=p(s),y(B.$$.fragment,s),al=p(s),V=r(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-ucxlp2"&&(V.innerHTML=dn),tl=p(s),y(m.$$.fragment,s),pl=p(s),E=r(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-khgm0p"&&(E.innerHTML=qn),Ml=p(s),Z=r(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16rhscq"&&(Z.textContent=bn),el=p(s),z=r(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1pymdi4"&&(z.textContent=Qn),yl=p(s),y(G.$$.fragment,s),jl=p(s),S=r(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-r48sl9"&&(S.innerHTML=kn),Jl=p(s),y(_.$$.fragment,s),il=p(s),N=r(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1swwp9p"&&(N.innerHTML=An),cl=p(s),v=r(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-zpne97"&&(v.innerHTML=Bn),Ul=p(s),y(H.$$.fragment,s),rl=p(s),X=r(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-5kte7b"&&(X.innerHTML=Vn),ul=p(s),y(D.$$.fragment,s),ol=p(s),W=r(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-giox8m"&&(W.innerHTML=En),Tl=p(s),y(R.$$.fragment,s),hl=p(s),Y=r(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-125t69x"&&(Y.textContent=Zn),wl=p(s),y(g.$$.fragment,s),Cl=p(s),y(K.$$.fragment,s),xl=p(s),P=r(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-s2d4c4"&&(P.textContent=zn),ml=p(s),F=r(s,"OL",{"data-svelte-h":!0}),o(F)!=="svelte-yp7zsq"&&(F.innerHTML=Gn),gl=p(s),L=r(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1mqz9bf"&&(L.textContent=Sn),Il=p(s),y(O.$$.fragment,s),fl=p(s),ss=r(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1c63kc0"&&(ss.innerHTML=_n),$l=p(s),y(I.$$.fragment,s),dl=p(s),y(ls.$$.fragment,s),ql=p(s),ns=r(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-wk57ec"&&(ns.textContent=Nn),bl=p(s),as=r(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1amsvnb"&&(as.textContent=vn),Ql=p(s),y(ts.$$.fragment,s),kl=p(s),ps=r(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-s31cgz"&&(ps.innerHTML=Hn),Al=p(s),y(Ms.$$.fragment,s),Bl=p(s),es=r(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-16ge37"&&(es.textContent=Xn),Vl=p(s),y(ys.$$.fragment,s),El=p(s),y(js.$$.fragment,s),Zl=p(s),Js=r(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1goryqc"&&(Js.textContent=Dn),zl=p(s),y(is.$$.fragment,s),Gl=p(s),y(cs.$$.fragment,s),Sl=p(s),Us=r(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-10w4a2b"&&(Us.innerHTML=Wn),_l=p(s),y(rs.$$.fragment,s),Nl=p(s),us=r(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-c21ci5"&&(us.textContent=Rn),vl=p(s),y(os.$$.fragment,s),Hl=p(s),Ts=r(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1bhf379"&&(Ts.textContent=Yn),Xl=p(s),y(hs.$$.fragment,s),Dl=p(s),ws=r(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1gv0rei"&&(ws.textContent=Kn),Wl=p(s),y(Cs.$$.fragment,s),Rl=p(s),y(xs.$$.fragment,s),Yl=p(s),ms=r(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-12sv1a5"&&(ms.textContent=Pn),Kl=p(s),y(gs.$$.fragment,s),Pl=p(s),y(Is.$$.fragment,s),Fl=p(s),fs=r(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-1lvsckd"&&(fs.innerHTML=Fn),Ll=p(s),y($s.$$.fragment,s),Ol=p(s),ds=r(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1phnwkv"&&(ds.innerHTML=Ln),sn=p(s),y(qs.$$.fragment,s),ln=p(s),bs=r(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-jw1a3u"&&(bs.textContent=On),nn=p(s),y(Qs.$$.fragment,s),an=p(s),y(ks.$$.fragment,s),tn=p(s),As=r(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-e3mcqu"&&(As.textContent=sa),pn=p(s),y(Bs.$$.fragment,s),Mn=p(s),Vs=r(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1h8gz36"&&(Vs.textContent=la),en=p(s),y(Es.$$.fragment,s),yn=p(s),y(Zs.$$.fragment,s),jn=p(s),zs=r(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-10ltvxx"&&(zs.textContent=na),Jn=p(s),y(Gs.$$.fragment,s),cn=p(s),y(Ss.$$.fragment,s),Un=p(s),y(f.$$.fragment,s),rn=p(s),_s=r(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-23pg7h"&&(_s.textContent=aa),un=p(s),y(Ns.$$.fragment,s),on=p(s),vs=r(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1r6mvob"&&(vs.textContent=ta),Tn=p(s),y(Hs.$$.fragment,s),hn=p(s),y(Xs.$$.fragment,s),wn=p(s),y($.$$.fragment,s),Cn=p(s),Ds=r(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-1avkgv4"&&(Ds.textContent=pa),xn=p(s),y(Ws.$$.fragment,s),mn=p(s),Ks=r(s,"P",{}),ca(Ks).forEach(n),this.h()},h(){Ua(M,"name","hf:doc:metadata"),Ua(M,"content",Qa)},m(s,l){wa(document.head,M),a(s,h,l),a(s,u,l),a(s,w,l),j(d,s,l),a(s,Ps,l),j(q,s,l),a(s,Fs,l),a(s,b,l),a(s,Ls,l),j(Q,s,l),a(s,Os,l),j(x,s,l),a(s,sl,l),j(k,s,l),a(s,ll,l),a(s,A,l),a(s,nl,l),j(B,s,l),a(s,al,l),a(s,V,l),a(s,tl,l),j(m,s,l),a(s,pl,l),a(s,E,l),a(s,Ml,l),a(s,Z,l),a(s,el,l),a(s,z,l),a(s,yl,l),j(G,s,l),a(s,jl,l),a(s,S,l),a(s,Jl,l),j(_,s,l),a(s,il,l),a(s,N,l),a(s,cl,l),a(s,v,l),a(s,Ul,l),j(H,s,l),a(s,rl,l),a(s,X,l),a(s,ul,l),j(D,s,l),a(s,ol,l),a(s,W,l),a(s,Tl,l),j(R,s,l),a(s,hl,l),a(s,Y,l),a(s,wl,l),j(g,s,l),a(s,Cl,l),j(K,s,l),a(s,xl,l),a(s,P,l),a(s,ml,l),a(s,F,l),a(s,gl,l),a(s,L,l),a(s,Il,l),j(O,s,l),a(s,fl,l),a(s,ss,l),a(s,$l,l),j(I,s,l),a(s,dl,l),j(ls,s,l),a(s,ql,l),a(s,ns,l),a(s,bl,l),a(s,as,l),a(s,Ql,l),j(ts,s,l),a(s,kl,l),a(s,ps,l),a(s,Al,l),j(Ms,s,l),a(s,Bl,l),a(s,es,l),a(s,Vl,l),j(ys,s,l),a(s,El,l),j(js,s,l),a(s,Zl,l),a(s,Js,l),a(s,zl,l),j(is,s,l),a(s,Gl,l),j(cs,s,l),a(s,Sl,l),a(s,Us,l),a(s,_l,l),j(rs,s,l),a(s,Nl,l),a(s,us,l),a(s,vl,l),j(os,s,l),a(s,Hl,l),a(s,Ts,l),a(s,Xl,l),j(hs,s,l),a(s,Dl,l),a(s,ws,l),a(s,Wl,l),j(Cs,s,l),a(s,Rl,l),j(xs,s,l),a(s,Yl,l),a(s,ms,l),a(s,Kl,l),j(gs,s,l),a(s,Pl,l),j(Is,s,l),a(s,Fl,l),a(s,fs,l),a(s,Ll,l),j($s,s,l),a(s,Ol,l),a(s,ds,l),a(s,sn,l),j(qs,s,l),a(s,ln,l),a(s,bs,l),a(s,nn,l),j(Qs,s,l),a(s,an,l),j(ks,s,l),a(s,tn,l),a(s,As,l),a(s,pn,l),j(Bs,s,l),a(s,Mn,l),a(s,Vs,l),a(s,en,l),j(Es,s,l),a(s,yn,l),j(Zs,s,l),a(s,jn,l),a(s,zs,l),a(s,Jn,l),j(Gs,s,l),a(s,cn,l),j(Ss,s,l),a(s,Un,l),j(f,s,l),a(s,rn,l),a(s,_s,l),a(s,un,l),j(Ns,s,l),a(s,on,l),a(s,vs,l),a(s,Tn,l),j(Hs,s,l),a(s,hn,l),j(Xs,s,l),a(s,wn,l),j($,s,l),a(s,Cn,l),a(s,Ds,l),a(s,xn,l),j(Ws,s,l),a(s,mn,l),a(s,Ks,l),gn=!0},p(s,[l]){const Ma={};l&2&&(Ma.$$scope={dirty:l,ctx:s}),x.$set(Ma);const ea={};l&2&&(ea.$$scope={dirty:l,ctx:s}),m.$set(ea);const ya={};l&2&&(ya.$$scope={dirty:l,ctx:s}),g.$set(ya);const ja={};l&2&&(ja.$$scope={dirty:l,ctx:s}),I.$set(ja);const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:s}),f.$set(Ja);const ia={};l&2&&(ia.$$scope={dirty:l,ctx:s}),$.$set(ia)},i(s){gn||(J(d.$$.fragment,s),J(q.$$.fragment,s),J(Q.$$.fragment,s),J(x.$$.fragment,s),J(k.$$.fragment,s),J(B.$$.fragment,s),J(m.$$.fragment,s),J(G.$$.fragment,s),J(_.$$.fragment,s),J(H.$$.fragment,s),J(D.$$.fragment,s),J(R.$$.fragment,s),J(g.$$.fragment,s),J(K.$$.fragment,s),J(O.$$.fragment,s),J(I.$$.fragment,s),J(ls.$$.fragment,s),J(ts.$$.fragment,s),J(Ms.$$.fragment,s),J(ys.$$.fragment,s),J(js.$$.fragment,s),J(is.$$.fragment,s),J(cs.$$.fragment,s),J(rs.$$.fragment,s),J(os.$$.fragment,s),J(hs.$$.fragment,s),J(Cs.$$.fragment,s),J(xs.$$.fragment,s),J(gs.$$.fragment,s),J(Is.$$.fragment,s),J($s.$$.fragment,s),J(qs.$$.fragment,s),J(Qs.$$.fragment,s),J(ks.$$.fragment,s),J(Bs.$$.fragment,s),J(Es.$$.fragment,s),J(Zs.$$.fragment,s),J(Gs.$$.fragment,s),J(Ss.$$.fragment,s),J(f.$$.fragment,s),J(Ns.$$.fragment,s),J(Hs.$$.fragment,s),J(Xs.$$.fragment,s),J($.$$.fragment,s),J(Ws.$$.fragment,s),gn=!0)},o(s){i(d.$$.fragment,s),i(q.$$.fragment,s),i(Q.$$.fragment,s),i(x.$$.fragment,s),i(k.$$.fragment,s),i(B.$$.fragment,s),i(m.$$.fragment,s),i(G.$$.fragment,s),i(_.$$.fragment,s),i(H.$$.fragment,s),i(D.$$.fragment,s),i(R.$$.fragment,s),i(g.$$.fragment,s),i(K.$$.fragment,s),i(O.$$.fragment,s),i(I.$$.fragment,s),i(ls.$$.fragment,s),i(ts.$$.fragment,s),i(Ms.$$.fragment,s),i(ys.$$.fragment,s),i(js.$$.fragment,s),i(is.$$.fragment,s),i(cs.$$.fragment,s),i(rs.$$.fragment,s),i(os.$$.fragment,s),i(hs.$$.fragment,s),i(Cs.$$.fragment,s),i(xs.$$.fragment,s),i(gs.$$.fragment,s),i(Is.$$.fragment,s),i($s.$$.fragment,s),i(qs.$$.fragment,s),i(Qs.$$.fragment,s),i(ks.$$.fragment,s),i(Bs.$$.fragment,s),i(Es.$$.fragment,s),i(Zs.$$.fragment,s),i(Gs.$$.fragment,s),i(Ss.$$.fragment,s),i(f.$$.fragment,s),i(Ns.$$.fragment,s),i(Hs.$$.fragment,s),i(Xs.$$.fragment,s),i($.$$.fragment,s),i(Ws.$$.fragment,s),gn=!1},d(s){s&&(n(h),n(u),n(w),n(Ps),n(Fs),n(b),n(Ls),n(Os),n(sl),n(ll),n(A),n(nl),n(al),n(V),n(tl),n(pl),n(E),n(Ml),n(Z),n(el),n(z),n(yl),n(jl),n(S),n(Jl),n(il),n(N),n(cl),n(v),n(Ul),n(rl),n(X),n(ul),n(ol),n(W),n(Tl),n(hl),n(Y),n(wl),n(Cl),n(xl),n(P),n(ml),n(F),n(gl),n(L),n(Il),n(fl),n(ss),n($l),n(dl),n(ql),n(ns),n(bl),n(as),n(Ql),n(kl),n(ps),n(Al),n(Bl),n(es),n(Vl),n(El),n(Zl),n(Js),n(zl),n(Gl),n(Sl),n(Us),n(_l),n(Nl),n(us),n(vl),n(Hl),n(Ts),n(Xl),n(Dl),n(ws),n(Wl),n(Rl),n(Yl),n(ms),n(Kl),n(Pl),n(Fl),n(fs),n(Ll),n(Ol),n(ds),n(sn),n(ln),n(bs),n(nn),n(an),n(tn),n(As),n(pn),n(Mn),n(Vs),n(en),n(yn),n(jn),n(zs),n(Jn),n(cn),n(Un),n(rn),n(_s),n(un),n(on),n(vs),n(Tn),n(hn),n(wn),n(Cn),n(Ds),n(xn),n(mn),n(Ks)),n(M),c(d,s),c(q,s),c(Q,s),c(x,s),c(k,s),c(B,s),c(m,s),c(G,s),c(_,s),c(H,s),c(D,s),c(R,s),c(g,s),c(K,s),c(O,s),c(I,s),c(ls,s),c(ts,s),c(Ms,s),c(ys,s),c(js,s),c(is,s),c(cs,s),c(rs,s),c(os,s),c(hs,s),c(Cs,s),c(xs,s),c(gs,s),c(Is,s),c($s,s),c(qs,s),c(Qs,s),c(ks,s),c(Bs,s),c(Es,s),c(Zs,s),c(Gs,s),c(Ss,s),c(f,s),c(Ns,s),c(Hs,s),c(Xs,s),c($,s),c(Ws,s)}}}const Qa='{"title":"字節對編碼標記化","local":"字節對編碼標記化","sections":[{"title":"訓練算法","local":"訓練算法","sections":[],"depth":2},{"title":"標記化算法","local":"標記化算法","sections":[],"depth":2},{"title":"實現 BPE","local":"實現-bpe","sections":[],"depth":2}],"depth":1}';function ka(C){return ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends oa{constructor(M){super(),Ta(this,M,ka,ba,ra,{})}}export{Sa as component};
