import{s as At,y as Ft,n as Nt,o as qt}from"../chunks/scheduler.d6170356.js";import{S as Xt,i as Rt,g as n,s as a,r as T,A as Dt,h as o,f as l,c as i,j as Yt,u as v,x as r,k as d,y as Kt,a as s,v as _,d as U,t as j,w as C}from"../chunks/index.fcd4cc08.js";import{C as Qt}from"../chunks/CodeBlock.db16bf50.js";import{H as ue,E as Ot}from"../chunks/index.3a2f7ce2.js";function el(it){let u,ce,re,he,H,me,k,nt='To upload models to the Hub, you’ll need to create an account at <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a>. Models on the Hub are <a href="./repositories">Git-based repositories</a>, which give you versioning, branches, discoverability and sharing features, integration with dozens of libraries, and more! You have control over what you want to upload to your repository, which could include checkpoints, configs, and any other files.',pe,J,ot='You can link repositories with an individual user, such as <a href="https://huggingface.co/osanseviero/fashion_brands_patterns" rel="nofollow">osanseviero/fashion_brands_patterns</a>, or with an organization, such as <a href="https://huggingface.co/facebook/bart-large-xsum" rel="nofollow">facebook/bart-large-xsum</a>. Organizations can collect models related to a company, community, or library! If you choose an organization, the model will be featured on the organization’s page, and every member of the organization will have the ability to contribute to the repository. You can create a new organization <a href="https://huggingface.co/organizations/new" rel="nofollow">here</a>.',fe,x,rt="<p><strong><em>NOTE:</em></strong> Models do NOT need to be compatible with the Transformers/Diffusers libraries to get download metrics. Any custom model is supported. Read more below!</p>",ge,L,dt='There are several ways to upload models for them to be nicely integrated into the Hub and get <a href="models-download-stats">download metrics</a>, described below.',ye,I,ut='<li>In case your model is designed for a library that has <a href="#upload-from-a-library-with-built-in-support">built-in support</a>, you can use the methods provided by the library. Custom models that use <code>trust_remote_code=True</code> can also leverage these methods.</li> <li>In case your model is a custom PyTorch model, one can leverage the <a href="#upload-a-pytorch-model-using-huggingfacehub"><code>PyTorchModelHubMixin</code> class</a> as it allows to add <code>from_pretrained</code>, <code>push_to_hub</code> to any <code>nn.Module</code> class, just like models in the Transformers, Diffusers and Timm libraries.</li> <li>In addition to programmatic uploads, you can always use the <a href="#using-the-web-interface">web interface</a> or <a href="#using-git">the git command line</a>.</li>',Me,W,ct='Once your model is uploaded, we suggest adding a <a href="./model-cards">Model Card</a> to your repo to document your model and make it more discoverable.',be,c,ht,we,B,mt="Example [repository](https://huggingface.co/LiheYoung/depth_anything_vitl14) that leverages [PyTorchModelHubMixin](#upload-a-pytorch-model-using-huggingfacehub). Downloads are shown on the right.",Te,Z,ve,$,pt='To create a brand new model repository, visit <a href="http://huggingface.co/new" rel="nofollow">huggingface.co/new</a>. Then follow these steps:',_e,G,ft="<li>In the “Files and versions” tab, select “Add File” and specify “Upload File”:</li>",Ue,h,gt='<img class="block dark:hidden" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file.png"/> <img class="hidden dark:block" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file-dark.png"/>',je,m,yt="<li>From there, select a file from your computer to upload and leave a helpful commit message to know what you are uploading:</li>",Ce,p,Mt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file-dark.png"/>',He,f,bt="<li><p>Afterwards, click <strong>Commit changes</strong> to upload your model to the Hub!</p></li> <li><p>Inspect files and history</p></li>",ke,z,wt="You can check your repository with all the recently added files!",Je,g,Tt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files-dark.png"/>',xe,V,vt="The UI allows you to explore the model files and commits and to see the diff introduced by each commit:",Le,y,_t='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history-dark.gif"/>',Ie,M,Ut="<li>Add metadata</li>",We,S,jt="You can add metadata to your model card. You can specify:",Be,E,Ct="<li>the type of task this model is for, enabling widgets and the Inference API.</li> <li>the used library (<code>transformers</code>, <code>spaCy</code>, etc.)</li> <li>the language</li> <li>the dataset</li> <li>metrics</li> <li>license</li> <li>a lot more!</li>",Ze,P,Ht='Read more about model tags <a href="./model-cards#model-card-metadata">here</a>.',$e,b,kt="<li>Add TensorBoard traces</li>",Ge,Y,Jt='Any repository that contains TensorBoard traces (filenames that contain <code>tfevents</code>) is categorized with the <a href="https://huggingface.co/models?filter=tensorboard" rel="nofollow"><code>TensorBoard</code> tag</a>. As a convention, we suggest that you save traces under the <code>runs/</code> subfolder. The “Training metrics” tab then makes it easy to review charts of the logged variables, like the loss or the accuracy.',ze,w,xt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard-dark.png"/>',Ve,Q,Lt='Models trained with 🤗 Transformers will generate <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow">TensorBoard traces</a> by default if <a href="https://pypi.org/project/tensorboard/" rel="nofollow"><code>tensorboard</code></a> is installed.',Se,A,Ee,F,It='First check if your model is from a library that has built-in support to push to/load from the Hub, like Transformers, Diffusers, Timm, Asteroid, etc.: <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">https://huggingface.co/docs/hub/models-libraries</a>. Below we’ll show how easy this is for a library like Transformers:',Pe,N,Ye,q,Wt='Some libraries, like Transformers, support loading <a href="https://huggingface.co/docs/transformers/custom_models" rel="nofollow">code from the Hub</a>. This is a way to make your model work with Transformers using the <code>trust_remote_code=True</code> flag. You may want to consider this option instead of a full-fledged library integration.',Qe,X,Ae,R,Bt='In case your model is a (custom) PyTorch model, you can leverage the <code>PyTorchModelHubMixin</code> <a href="https://huggingface.co/docs/huggingface_hub/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin" rel="nofollow">class</a> available in the <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> Python library. It is a minimal class which adds <code>from_pretrained</code> and <code>push_to_hub</code> capabilities to any <code>nn.Module</code>, along with download metrics.',Fe,D,Zt="Here is how to use it (assuming you have run <code>pip install huggingface_hub</code>):",Ne,K,qe,O,$t="As you can see, the only requirement is that your model inherits from <code>PyTorchModelHubMixin</code>. All instance attributes will be automatically serialized to a <code>config.json</code> file. Note that the <code>init</code> method can only take arguments which are JSON serializable. Python dataclasses are supported.",Xe,ee,Gt="This comes with automated download metrics, meaning that you’ll be able to see how many times the model is downloaded, the same way they are available for models integrated natively in the Transformers, Diffusers or Timm libraries. With this mixin class, each separate checkpoint is stored on the Hub in a single repository consisting of 2 files:",Re,te,zt='<li>a <code>pytorch_model.bin</code> or <code>model.safetensors</code> file containing the weights</li> <li>a <code>config.json</code> file which is a serialized version of the model configuration. This class is used for counting download metrics: everytime a user calls <code>from_pretrained</code> to load a <code>config.json</code>, the count goes up by one. See <a href="https://huggingface.co/docs/hub/models-download-stats" rel="nofollow">this guide</a> regarding automated download metrics.</li>',De,le,Vt="It’s recommended to add a model card to each checkpoint so that people can read what the model is about, have a link to the paper, etc.",Ke,se,St='Visit <a href="https://huggingface.co/docs/huggingface_hub/guides/integrations" rel="nofollow">the huggingface_hub’s documentation</a> to learn more.',Oe,ae,Et='Alternatively, one can also simply programmatically upload files or folders to the hub: <a href="https://huggingface.co/docs/huggingface_hub/guides/upload" rel="nofollow">https://huggingface.co/docs/huggingface_hub/guides/upload</a>.',et,ie,tt,ne,Pt='Finally, since model repos are just Git repositories, you can also use Git to push your model files to the Hub. Follow the guide on <a href="repositories-getting-started#terminal">Getting Started with Repositories</a> to learn about using the <code>git</code> CLI to commit and push your models.',lt,oe,st,de,at;return H=new ue({props:{title:"Uploading models",local:"uploading-models",headingTag:"h1"}}),Z=new ue({props:{title:"Using the web interface",local:"using-the-web-interface",headingTag:"h2"}}),A=new ue({props:{title:"Upload from a library with built-in support",local:"upload-from-a-library-with-built-in-support",headingTag:"h2"}}),N=new Qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRDb25maWclMkMlMjBCZXJ0TW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEJlcnRNb2RlbChjb25maWcpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybmllbHNyJTJGbXktYXdlc29tZS1iZXJ0LW1vZGVsJTIyKSUwQSUwQSUyMyUyMHJlbG9hZCUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuaWVsc3IlMkZteS1hd2Vzb21lLWJlcnQtbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

model.push_to_hub(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)`,wrap:!1}}),X=new ue({props:{title:"Upload a PyTorch model using huggingface_hub",local:"upload-a-pytorch-model-using-huggingfacehub",headingTag:"h2"}}),K=new Qt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEElMEFjbGFzcyUyME15TW9kZWwoJTBBJTIwJTIwJTIwJTIwbm4uTW9kdWxlJTJDJTBBJTIwJTIwJTIwJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMkMlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBvcHRpb25hbGx5JTJDJTIweW91JTIwY2FuJTIwYWRkJTIwbWV0YWRhdGElMjB3aGljaCUyMGdldHMlMjBwdXNoZWQlMjB0byUyMHRoZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMHJlcG9fdXJsJTNEJTIyeW91ci1yZXBvLXVybCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lX3RhZyUzRCUyMnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJTIybWl0JTIyJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBudW1fY2hhbm5lbHMlM0ElMjBpbnQlMkMlMjBoaWRkZW5fc2l6ZSUzQSUyMGludCUyQyUyMG51bV9jbGFzc2VzJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGFyYW0lMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZChudW1fY2hhbm5lbHMlMkMlMjBoaWRkZW5fc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIoaGlkZGVuX3NpemUlMkMlMjBudW1fY2xhc3NlcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubGluZWFyKHglMjAlMkIlMjBzZWxmLnBhcmFtKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMG1vZGVsJTBBY29uZmlnJTIwJTNEJTIwJTdCJTIybnVtX2NoYW5uZWxzJTIyJTNBJTIwMyUyQyUyMCUyMmhpZGRlbl9zaXplJTIyJTNBJTIwMzIlMkMlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDEwJTdEJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKCoqY29uZmlnKSUwQSUwQSUyMyUyMHNhdmUlMjBsb2NhbGx5JTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwcHVzaCUyMHRvJTIwdGhlJTIwaHViJTBBbW9kZWwucHVzaF90b19odWIoJTIyeW91ci1oZi11c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwcmVsb2FkJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ5b3VyLWhmLXVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
    nn.Module,
    PyTorchModelHubMixin, 
    <span class="hljs-comment"># optionally, you can add metadata which gets pushed to the model card</span>
    repo_url=<span class="hljs-string">&quot;your-repo-url&quot;</span>,
    pipeline_tag=<span class="hljs-string">&quot;text-to-image&quot;</span>,
    license=<span class="hljs-string">&quot;mit&quot;</span>,
):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_channels: <span class="hljs-built_in">int</span>, hidden_size: <span class="hljs-built_in">int</span>, num_classes: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.param = nn.Parameter(torch.rand(num_channels, hidden_size))
        self.linear = nn.Linear(hidden_size, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># create model</span>
config = {<span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&quot;num_classes&quot;</span>: <span class="hljs-number">10</span>}
model = MyModel(**config)

<span class="hljs-comment"># save locally</span>
model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># push to the hub</span>
model.push_to_hub(<span class="hljs-string">&quot;your-hf-username/my-awesome-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = MyModel.from_pretrained(<span class="hljs-string">&quot;your-hf-username/my-awesome-model&quot;</span>)`,wrap:!1}}),ie=new ue({props:{title:"Using Git",local:"using-git",headingTag:"h2"}}),oe=new Ot({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/models-uploading.md"}}),{c(){u=n("meta"),ce=a(),re=n("p"),he=a(),T(H.$$.fragment),me=a(),k=n("p"),k.innerHTML=nt,pe=a(),J=n("p"),J.innerHTML=ot,fe=a(),x=n("blockquote"),x.innerHTML=rt,ge=a(),L=n("p"),L.innerHTML=dt,ye=a(),I=n("ul"),I.innerHTML=ut,Me=a(),W=n("p"),W.innerHTML=ct,be=a(),c=n("img"),we=a(),B=n("small"),B.textContent=mt,Te=a(),T(Z.$$.fragment),ve=a(),$=n("p"),$.innerHTML=pt,_e=a(),G=n("ol"),G.innerHTML=ft,Ue=a(),h=n("div"),h.innerHTML=gt,je=a(),m=n("ol"),m.innerHTML=yt,Ce=a(),p=n("div"),p.innerHTML=Mt,He=a(),f=n("ol"),f.innerHTML=bt,ke=a(),z=n("p"),z.textContent=wt,Je=a(),g=n("div"),g.innerHTML=Tt,xe=a(),V=n("p"),V.textContent=vt,Le=a(),y=n("div"),y.innerHTML=_t,Ie=a(),M=n("ol"),M.innerHTML=Ut,We=a(),S=n("p"),S.textContent=jt,Be=a(),E=n("ul"),E.innerHTML=Ct,Ze=a(),P=n("p"),P.innerHTML=Ht,$e=a(),b=n("ol"),b.innerHTML=kt,Ge=a(),Y=n("p"),Y.innerHTML=Jt,ze=a(),w=n("div"),w.innerHTML=xt,Ve=a(),Q=n("p"),Q.innerHTML=Lt,Se=a(),T(A.$$.fragment),Ee=a(),F=n("p"),F.innerHTML=It,Pe=a(),T(N.$$.fragment),Ye=a(),q=n("p"),q.innerHTML=Wt,Qe=a(),T(X.$$.fragment),Ae=a(),R=n("p"),R.innerHTML=Bt,Fe=a(),D=n("p"),D.innerHTML=Zt,Ne=a(),T(K.$$.fragment),qe=a(),O=n("p"),O.innerHTML=$t,Xe=a(),ee=n("p"),ee.textContent=Gt,Re=a(),te=n("ul"),te.innerHTML=zt,De=a(),le=n("p"),le.textContent=Vt,Ke=a(),se=n("p"),se.innerHTML=St,Oe=a(),ae=n("p"),ae.innerHTML=Et,et=a(),T(ie.$$.fragment),tt=a(),ne=n("p"),ne.innerHTML=Pt,lt=a(),T(oe.$$.fragment),st=a(),de=n("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),ce=i(e),re=o(e,"P",{}),Yt(re).forEach(l),he=i(e),v(H.$$.fragment,e),me=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1k1s32s"&&(k.innerHTML=nt),pe=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1yho9nm"&&(J.innerHTML=ot),fe=i(e),x=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(x)!=="svelte-5gr2ts"&&(x.innerHTML=rt),ge=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-u47biw"&&(L.innerHTML=dt),ye=i(e),I=o(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1b166lh"&&(I.innerHTML=ut),Me=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vwc1dj"&&(W.innerHTML=ct),be=i(e),c=o(e,"IMG",{src:!0,alt:!0,width:!0}),we=i(e),B=o(e,"SMALL",{"data-svelte-h":!0}),r(B)!=="svelte-rw6688"&&(B.textContent=mt),Te=i(e),v(Z.$$.fragment,e),ve=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-x37mbe"&&($.innerHTML=pt),_e=i(e),G=o(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-m7dyke"&&(G.innerHTML=ft),Ue=i(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1kwaicp"&&(h.innerHTML=gt),je=i(e),m=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(m)!=="svelte-bnx7wi"&&(m.innerHTML=yt),Ce=i(e),p=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-1yhipjn"&&(p.innerHTML=Mt),He=i(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-1g8w05a"&&(f.innerHTML=bt),ke=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-197c7zs"&&(z.textContent=wt),Je=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1vobd2z"&&(g.innerHTML=Tt),xe=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-9fow57"&&(V.textContent=vt),Le=i(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-cdui6d"&&(y.innerHTML=_t),Ie=i(e),M=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(M)!=="svelte-j2g6d3"&&(M.innerHTML=Ut),We=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-gkc8cy"&&(S.textContent=jt),Be=i(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-tl31d8"&&(E.innerHTML=Ct),Ze=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-6zfhus"&&(P.innerHTML=Ht),$e=i(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-1r5hl08"&&(b.innerHTML=kt),Ge=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-duz775"&&(Y.innerHTML=Jt),ze=i(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-rlnnzb"&&(w.innerHTML=xt),Ve=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-hpisbu"&&(Q.innerHTML=Lt),Se=i(e),v(A.$$.fragment,e),Ee=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-mz82tu"&&(F.innerHTML=It),Pe=i(e),v(N.$$.fragment,e),Ye=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1mkmuk9"&&(q.innerHTML=Wt),Qe=i(e),v(X.$$.fragment,e),Ae=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1pq7dxk"&&(R.innerHTML=Bt),Fe=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-uwt68k"&&(D.innerHTML=Zt),Ne=i(e),v(K.$$.fragment,e),qe=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-pgbixj"&&(O.innerHTML=$t),Xe=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1f1zsla"&&(ee.textContent=Gt),Re=i(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-m0rjhi"&&(te.innerHTML=zt),De=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1j0lu4s"&&(le.textContent=Vt),Ke=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1e814df"&&(se.innerHTML=St),Oe=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1x88idh"&&(ae.innerHTML=Et),et=i(e),v(ie.$$.fragment,e),tt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-y1l1ro"&&(ne.innerHTML=Pt),lt=i(e),v(oe.$$.fragment,e),st=i(e),de=o(e,"P",{}),Yt(de).forEach(l),this.h()},h(){d(u,"name","hf:doc:metadata"),d(u,"content",tl),Ft(c.src,ht="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/example_repository.png")||d(c,"src",ht),d(c,"alt","drawing"),d(c,"width","600"),d(h,"class","flex justify-center"),d(m,"start","2"),d(p,"class","flex justify-center"),d(f,"start","3"),d(g,"class","flex justify-center"),d(y,"class","flex justify-center"),d(M,"start","5"),d(b,"start","6"),d(w,"class","flex justify-center")},m(e,t){Kt(document.head,u),s(e,ce,t),s(e,re,t),s(e,he,t),_(H,e,t),s(e,me,t),s(e,k,t),s(e,pe,t),s(e,J,t),s(e,fe,t),s(e,x,t),s(e,ge,t),s(e,L,t),s(e,ye,t),s(e,I,t),s(e,Me,t),s(e,W,t),s(e,be,t),s(e,c,t),s(e,we,t),s(e,B,t),s(e,Te,t),_(Z,e,t),s(e,ve,t),s(e,$,t),s(e,_e,t),s(e,G,t),s(e,Ue,t),s(e,h,t),s(e,je,t),s(e,m,t),s(e,Ce,t),s(e,p,t),s(e,He,t),s(e,f,t),s(e,ke,t),s(e,z,t),s(e,Je,t),s(e,g,t),s(e,xe,t),s(e,V,t),s(e,Le,t),s(e,y,t),s(e,Ie,t),s(e,M,t),s(e,We,t),s(e,S,t),s(e,Be,t),s(e,E,t),s(e,Ze,t),s(e,P,t),s(e,$e,t),s(e,b,t),s(e,Ge,t),s(e,Y,t),s(e,ze,t),s(e,w,t),s(e,Ve,t),s(e,Q,t),s(e,Se,t),_(A,e,t),s(e,Ee,t),s(e,F,t),s(e,Pe,t),_(N,e,t),s(e,Ye,t),s(e,q,t),s(e,Qe,t),_(X,e,t),s(e,Ae,t),s(e,R,t),s(e,Fe,t),s(e,D,t),s(e,Ne,t),_(K,e,t),s(e,qe,t),s(e,O,t),s(e,Xe,t),s(e,ee,t),s(e,Re,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Ke,t),s(e,se,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),_(ie,e,t),s(e,tt,t),s(e,ne,t),s(e,lt,t),_(oe,e,t),s(e,st,t),s(e,de,t),at=!0},p:Nt,i(e){at||(U(H.$$.fragment,e),U(Z.$$.fragment,e),U(A.$$.fragment,e),U(N.$$.fragment,e),U(X.$$.fragment,e),U(K.$$.fragment,e),U(ie.$$.fragment,e),U(oe.$$.fragment,e),at=!0)},o(e){j(H.$$.fragment,e),j(Z.$$.fragment,e),j(A.$$.fragment,e),j(N.$$.fragment,e),j(X.$$.fragment,e),j(K.$$.fragment,e),j(ie.$$.fragment,e),j(oe.$$.fragment,e),at=!1},d(e){e&&(l(ce),l(re),l(he),l(me),l(k),l(pe),l(J),l(fe),l(x),l(ge),l(L),l(ye),l(I),l(Me),l(W),l(be),l(c),l(we),l(B),l(Te),l(ve),l($),l(_e),l(G),l(Ue),l(h),l(je),l(m),l(Ce),l(p),l(He),l(f),l(ke),l(z),l(Je),l(g),l(xe),l(V),l(Le),l(y),l(Ie),l(M),l(We),l(S),l(Be),l(E),l(Ze),l(P),l($e),l(b),l(Ge),l(Y),l(ze),l(w),l(Ve),l(Q),l(Se),l(Ee),l(F),l(Pe),l(Ye),l(q),l(Qe),l(Ae),l(R),l(Fe),l(D),l(Ne),l(qe),l(O),l(Xe),l(ee),l(Re),l(te),l(De),l(le),l(Ke),l(se),l(Oe),l(ae),l(et),l(tt),l(ne),l(lt),l(st),l(de)),l(u),C(H,e),C(Z,e),C(A,e),C(N,e),C(X,e),C(K,e),C(ie,e),C(oe,e)}}}const tl='{"title":"Uploading models","local":"uploading-models","sections":[{"title":"Using the web interface","local":"using-the-web-interface","sections":[],"depth":2},{"title":"Upload from a library with built-in support","local":"upload-from-a-library-with-built-in-support","sections":[],"depth":2},{"title":"Upload a PyTorch model using huggingface_hub","local":"upload-a-pytorch-model-using-huggingfacehub","sections":[],"depth":2},{"title":"Using Git","local":"using-git","sections":[],"depth":2}],"depth":1}';function ll(it){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Xt{constructor(u){super(),Rt(this,u,ll,el,At,{})}}export{ol as component};
