import{s as Us,n as Zs,o as ks}from"../chunks/scheduler.85c25b89.js";import{S as $s,i as Bs,g as p,s as e,r as i,A as Cs,h as m,f as l,c as n,j as bs,u as o,x as j,k as fs,y as Ws,a,v as r,d as c,t as M,w as h}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.52fa569e.js";import{H as V}from"../chunks/Heading.3097d2ed.js";function Is(cs){let g,Y,A,S,d,R,y,Ms="<strong>Progressive Neural Architecture Search</strong>, or <strong>PNAS</strong>, is a method for learning the structure of convolutional neural networks (CNNs). It uses a sequential model-based optimization (SMBO) strategy, where we search the space of cell structures, starting with simple (shallow) models and progressing to complex ones, pruning out unpromising structures as we go.",_,w,H,J,hs="To load a pretrained model:",z,u,F,T,js="To load and preprocess the image:",L,b,P,f,gs="To get the model predictions:",q,U,D,Z,ds="To get the top-5 predictions class names:",K,k,O,$,ys="Replace the model name with the variant you want to use, e.g. <code>pnasnet5large</code>. You can find the IDs in the model summaries at the top of this page.",ss,B,ws='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,C,ls,W,Js="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,I,es,N,us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,x,ps,G,Ts='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,E,is,Q,os,v,rs;return d=new V({props:{title:"PNASNet",local:"pnasnet",headingTag:"h1"}}),w=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3BuYXNuZXQ1bGFyZ2UnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),I=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncG5hc25ldDVsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new X({props:{code:"JTQwbWlzYyU3QmxpdTIwMThwcm9ncmVzc2l2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCUHJvZ3Jlc3NpdmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JDaGVueGklMjBMaXUlMjBhbmQlMjBCYXJyZXQlMjBab3BoJTIwYW5kJTIwTWF4aW0lMjBOZXVtYW5uJTIwYW5kJTIwSm9uYXRob24lMjBTaGxlbnMlMjBhbmQlMjBXZWklMjBIdWElMjBhbmQlMjBMaS1KaWElMjBMaSUyMGFuZCUyMExpJTIwRmVpLUZlaSUyMGFuZCUyMEFsYW4lMjBZdWlsbGUlMjBhbmQlMjBKb25hdGhhbiUyMEh1YW5nJTIwYW5kJTIwS2V2aW4lMjBNdXJwaHklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MTIuMDA1NTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{liu2018progressive,
      title={Progressive Neural Architecture Search}, 
      author={Chenxi Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Maxim Neumann <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Wei Hua <span class="hljs-keyword">and </span>Li-<span class="hljs-keyword">Jia </span>Li <span class="hljs-keyword">and </span>Li Fei-Fei <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathan </span>Huang <span class="hljs-keyword">and </span>Kevin Murphy},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1712</span>.<span class="hljs-number">00559</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){g=p("meta"),Y=e(),A=p("p"),S=e(),i(d.$$.fragment),R=e(),y=p("p"),y.innerHTML=Ms,_=e(),i(w.$$.fragment),H=e(),J=p("p"),J.textContent=hs,z=e(),i(u.$$.fragment),F=e(),T=p("p"),T.textContent=js,L=e(),i(b.$$.fragment),P=e(),f=p("p"),f.textContent=gs,q=e(),i(U.$$.fragment),D=e(),Z=p("p"),Z.textContent=ds,K=e(),i(k.$$.fragment),O=e(),$=p("p"),$.innerHTML=ys,ss=e(),B=p("p"),B.innerHTML=ws,ts=e(),i(C.$$.fragment),ls=e(),W=p("p"),W.textContent=Js,as=e(),i(I.$$.fragment),es=e(),N=p("p"),N.innerHTML=us,ns=e(),i(x.$$.fragment),ps=e(),G=p("p"),G.innerHTML=Ts,ms=e(),i(E.$$.fragment),is=e(),i(Q.$$.fragment),os=e(),v=p("p"),this.h()},l(s){const t=Cs("svelte-u9bgzb",document.head);g=m(t,"META",{name:!0,content:!0}),t.forEach(l),Y=n(s),A=m(s,"P",{}),bs(A).forEach(l),S=n(s),o(d.$$.fragment,s),R=n(s),y=m(s,"P",{"data-svelte-h":!0}),j(y)!=="svelte-1wxq1ps"&&(y.innerHTML=Ms),_=n(s),o(w.$$.fragment,s),H=n(s),J=m(s,"P",{"data-svelte-h":!0}),j(J)!=="svelte-18ywhxh"&&(J.textContent=hs),z=n(s),o(u.$$.fragment,s),F=n(s),T=m(s,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1c2ipa8"&&(T.textContent=js),L=n(s),o(b.$$.fragment,s),P=n(s),f=m(s,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1n9qsq1"&&(f.textContent=gs),q=n(s),o(U.$$.fragment,s),D=n(s),Z=m(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-19cnvx1"&&(Z.textContent=ds),K=n(s),o(k.$$.fragment,s),O=n(s),$=m(s,"P",{"data-svelte-h":!0}),j($)!=="svelte-1ym24x9"&&($.innerHTML=ys),ss=n(s),B=m(s,"P",{"data-svelte-h":!0}),j(B)!=="svelte-1wmi3ea"&&(B.innerHTML=ws),ts=n(s),o(C.$$.fragment,s),ls=n(s),W=m(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-9sr7nh"&&(W.textContent=Js),as=n(s),o(I.$$.fragment,s),es=n(s),N=m(s,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1kguc51"&&(N.innerHTML=us),ns=n(s),o(x.$$.fragment,s),ps=n(s),G=m(s,"P",{"data-svelte-h":!0}),j(G)!=="svelte-1n0coha"&&(G.innerHTML=Ts),ms=n(s),o(E.$$.fragment,s),is=n(s),o(Q.$$.fragment,s),os=n(s),v=m(s,"P",{}),bs(v).forEach(l),this.h()},h(){fs(g,"name","hf:doc:metadata"),fs(g,"content",Ns)},m(s,t){Ws(document.head,g),a(s,Y,t),a(s,A,t),a(s,S,t),r(d,s,t),a(s,R,t),a(s,y,t),a(s,_,t),r(w,s,t),a(s,H,t),a(s,J,t),a(s,z,t),r(u,s,t),a(s,F,t),a(s,T,t),a(s,L,t),r(b,s,t),a(s,P,t),a(s,f,t),a(s,q,t),r(U,s,t),a(s,D,t),a(s,Z,t),a(s,K,t),r(k,s,t),a(s,O,t),a(s,$,t),a(s,ss,t),a(s,B,t),a(s,ts,t),r(C,s,t),a(s,ls,t),a(s,W,t),a(s,as,t),r(I,s,t),a(s,es,t),a(s,N,t),a(s,ns,t),r(x,s,t),a(s,ps,t),a(s,G,t),a(s,ms,t),r(E,s,t),a(s,is,t),r(Q,s,t),a(s,os,t),a(s,v,t),rs=!0},p:Zs,i(s){rs||(c(d.$$.fragment,s),c(w.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(U.$$.fragment,s),c(k.$$.fragment,s),c(C.$$.fragment,s),c(I.$$.fragment,s),c(x.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),rs=!0)},o(s){M(d.$$.fragment,s),M(w.$$.fragment,s),M(u.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(k.$$.fragment,s),M(C.$$.fragment,s),M(I.$$.fragment,s),M(x.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),rs=!1},d(s){s&&(l(Y),l(A),l(S),l(R),l(y),l(_),l(H),l(J),l(z),l(F),l(T),l(L),l(P),l(f),l(q),l(D),l(Z),l(K),l(O),l($),l(ss),l(B),l(ts),l(ls),l(W),l(as),l(es),l(N),l(ns),l(ps),l(G),l(ms),l(is),l(os),l(v)),l(g),h(d,s),h(w,s),h(u,s),h(b,s),h(U,s),h(k,s),h(C,s),h(I,s),h(x,s),h(E,s),h(Q,s)}}}const Ns='{"title":"PNASNet","local":"pnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(cs){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends $s{constructor(g){super(),Bs(this,g,xs,Is,Us,{})}}export{As as component};
