import{s as bt,n as wt,o as Ut}from"../chunks/scheduler.d627b047.js";import{S as Jt,i as It,g as i,s as o,r as l,A as $t,h as s,f as a,c as r,j as pe,u as m,x as u,k as de,y as _,a as n,v as p,d,t as c,w as g}from"../chunks/index.73c51727.js";import{D as De}from"../chunks/Docstring.0ad99a5d.js";import{C as ne}from"../chunks/CodeBlock.5f78c87f.js";import{H as y,E as Ct}from"../chunks/index.8df1db42.js";function Ft(rt){let T,_e,ce,ue,U,fe,J,it='<a href="https://huggingface.co/models?other=iterative-sft,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-Iterative_SFT-blue"/></a>',ve,I,lt="Iterative fine-tuning is a training method that enables to perform custom actions (generation and filtering for example) between optimization steps. In TRL we provide an easy-to-use API to fine-tune your models in an iterative way in just a few lines of code.",ye,$,Te,C,st="To get started quickly, you can either pass a model identifier or a pre-instantiated model to the trainer:",he,F,Me,N,be,j,mt='The <a href="/docs/trl/main/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a> supports two ways of providing input data to the <code>step</code> function:',we,x,Ue,S,Je,k,Ie,Z,$e,z,pt="For causal language models, labels will automatically be created from <code>input_ids</code> or from <code>texts</code>. When using sequence to sequence models you will have to provide your own labels or <code>text_labels</code>.",Ce,E,Fe,X,dt='The <a href="/docs/trl/main/en/iterative_sft_trainer#trl.IterativeSFTConfig">IterativeSFTConfig</a> class provides several parameters to customize the training:',Ne,R,je,O,xe,G,ct="You can control how the model is initialized by passing keyword arguments to <code>model_init_kwargs</code>:",Se,B,ke,q,Ze,A,gt="The trainer supports two truncation modes:",ze,V,_t="<li><code>keep_end</code>: Truncates from the start of the sequence</li> <li><code>keep_start</code>: Truncates from the end of the sequence</li>",Ee,Q,Xe,W,Re,H,ut="You can optimize CUDA cache usage for more memory-efficient training:",Oe,L,Ge,D,Be,f,P,Pe,oe,ft="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",Ye,h,Y,Ke,re,vt="Creates a draft of a model card using the information available to the <code>Trainer</code>.",et,M,K,tt,ie,yt="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",qe,ee,Ae,v,te,at,le,Tt='Configuration class for the <a href="/docs/trl/main/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a>.',nt,se,ht=`Only the parameters specific to iterative SFT training are listed here. For details on other parameters, refer to the
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> documentation.`,ot,me,Mt=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ve,ae,Qe,ge,We;return U=new y({props:{title:"Iterative Trainer",local:"iterative-trainer",headingTag:"h1"}}),$=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),F=new ne({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEl0ZXJhdGl2ZVNGVENvbmZpZyUyQyUyMEl0ZXJhdGl2ZVNGVFRyYWluZXIlMEElMEElMjMlMjBVc2luZyUyMGElMjBtb2RlbCUyMGlkZW50aWZpZXIlMEF0cmFpbmVyJTIwJTNEJTIwSXRlcmF0aXZlU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzREl0ZXJhdGl2ZVNGVENvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZvdXRwdXQlMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBKSUwQSUwQSUyMyUyME9yJTIwdXNpbmclMjBhJTIwcHJlLWluc3RhbnRpYXRlZCUyMG1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwSXRlcmF0aXZlU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RJdGVyYXRpdmVTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGb3V0cHV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> IterativeSFTConfig, IterativeSFTTrainer

<span class="hljs-comment"># Using a model identifier</span>
trainer = IterativeSFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=IterativeSFTConfig(
        max_length=<span class="hljs-number">512</span>,
        output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    ),
)

<span class="hljs-comment"># Or using a pre-instantiated model</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = IterativeSFTTrainer(
    model,
    args=IterativeSFTConfig(
        max_length=<span class="hljs-number">512</span>,
        output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    ),
    processing_class=tokenizer,
)`,wrap:!1}}),N=new y({props:{title:"Usage",local:"usage",headingTag:"h2"}}),x=new y({props:{title:"Using a list of tensors as input:",local:"using-a-list-of-tensors-as-input",headingTag:"h3"}}),S=new ne({props:{code:"aW5wdXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5wdXRfaWRzJTIyJTNBJTIwaW5wdXRfaWRzJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlM0ElMjBhdHRlbnRpb25fbWFzayUyQyUwQSU3RCUwQSUwQXRyYWluZXIuc3RlcCgqKmlucHV0cyk=",highlighted:`inputs = {
    <span class="hljs-string">&quot;input_ids&quot;</span>: input_ids,
    <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask,
}

trainer.step(**inputs)`,wrap:!1}}),k=new y({props:{title:"Using a list of strings as input:",local:"using-a-list-of-strings-as-input",headingTag:"h3"}}),Z=new ne({props:{code:"aW5wdXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dHMlMjIlM0ElMjB0ZXh0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHRzX2xhYmVscyUyMiUzQSUyMHRleHRzX2xhYmVscyUyQyUyMCUyMCUyMyUyME9wdGlvbmFsJTJDJTIwZGVmYXVsdHMlMjB0byUyMHRleHRzJTBBJTdEJTBBJTBBdHJhaW5lci5zdGVwKCoqaW5wdXRzKQ==",highlighted:`inputs = {
    <span class="hljs-string">&quot;texts&quot;</span>: texts,
    <span class="hljs-string">&quot;texts_labels&quot;</span>: texts_labels,  <span class="hljs-comment"># Optional, defaults to texts</span>
}

trainer.step(**inputs)`,wrap:!1}}),E=new y({props:{title:"Configuration",local:"configuration",headingTag:"h2"}}),R=new ne({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEl0ZXJhdGl2ZVNGVENvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEl0ZXJhdGl2ZVNGVENvbmZpZyglMEElMjAlMjAlMjAlMjAlMjMlMjBNb2RlbCUyMGluaXRpYWxpemF0aW9uJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXRfa3dhcmdzJTNEJTdCJTIydG9yY2hfZHR5cGUlMjIlM0ElMjAlMjJiZmxvYXQxNiUyMiU3RCUyQyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERhdGElMjBwcmVwcm9jZXNzaW5nJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX21vZGUlM0QlMjJrZWVwX2VuZCUyMiUyQyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRyYWluaW5nJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGb3V0cHV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDJlLTUlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW0lM0QlMjJhZGFtd190b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCUyMndhbmRiJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> IterativeSFTConfig

config = IterativeSFTConfig(
    <span class="hljs-comment"># Model initialization parameters</span>
    model_init_kwargs={<span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>},

    <span class="hljs-comment"># Data preprocessing parameters</span>
    max_length=<span class="hljs-number">512</span>,
    truncation_mode=<span class="hljs-string">&quot;keep_end&quot;</span>,

    <span class="hljs-comment"># Training parameters</span>
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    max_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">10</span>,
    save_steps=<span class="hljs-number">100</span>,
    optim=<span class="hljs-string">&quot;adamw_torch&quot;</span>,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
)`,wrap:!1}}),O=new y({props:{title:"Model Initialization",local:"model-initialization",headingTag:"h3"}}),B=new ne({props:{code:"Y29uZmlnJTIwJTNEJTIwSXRlcmF0aXZlU0ZUQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXRfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9yY2hfZHR5cGUlMjIlM0ElMjAlMjJiZmxvYXQxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZV9tYXAlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJ1c3RfcmVtb3RlX2NvZGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`config = IterativeSFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
        <span class="hljs-string">&quot;device_map&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;trust_remote_code&quot;</span>: <span class="hljs-literal">True</span>,
    }
)`,wrap:!1}}),q=new y({props:{title:"Data Preprocessing",local:"data-preprocessing",headingTag:"h3"}}),Q=new ne({props:{code:"Y29uZmlnJTIwJTNEJTIwSXRlcmF0aXZlU0ZUQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX21vZGUlM0QlMjJrZWVwX2VuZCUyMiUyQyUyMCUyMCUyMyUyMG9yJTIwJTIya2VlcF9zdGFydCUyMiUwQSk=",highlighted:`config = IterativeSFTConfig(
    max_length=<span class="hljs-number">512</span>,
    truncation_mode=<span class="hljs-string">&quot;keep_end&quot;</span>,  <span class="hljs-comment"># or &quot;keep_start&quot;</span>
)`,wrap:!1}}),W=new y({props:{title:"Training Optimization",local:"training-optimization",headingTag:"h3"}}),L=new ne({props:{code:"Y29uZmlnJTIwJTNEJTIwSXRlcmF0aXZlU0ZUQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplX2RldmljZV9jYWNoZSUzRFRydWUlMkMlMEEp",highlighted:`config = IterativeSFTConfig(
    optimize_device_cache=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),D=new y({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),P=new De({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": typing.Union[str, transformers.modeling_utils.PreTrainedModel]"},{name:"args",val:": typing.Union[trl.trainer.iterative_sft_config.IterativeSFTConfig, transformers.training_args.TrainingArguments, NoneType] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], dict]] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": typing.Optional[str] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Model to be trained. Can be either:</p>
<ul>
<li>A string, being the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co, or
a path to a <em>directory</em> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g., <code>&apos;./my_model_directory/&apos;</code>. The model is
loaded using <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> with the keywork arguments
in <code>args.model_init_kwargs</code>.</li>
<li>A <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a> object. Only causal language models are supported.</li>
</ul>`,name:"model"},{anchor:"trl.IterativeSFTTrainer.args",description:`<strong>args</strong> (<a href="/docs/trl/main/en/iterative_sft_trainer#trl.IterativeSFTConfig">IterativeSFTConfig</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Configuration for this trainer. If <code>None</code>, a default configuration is used.`,name:"args"},{anchor:"trl.IterativeSFTTrainer.data_collator",description:`<strong>data_collator</strong> (<code>DataCollator</code>, <em>optional</em>) &#x2014;
Function to use to form a batch from a list of elements of the processed <code>train_dataset</code> or <code>eval_dataset</code>.
Will default to <a href="https://huggingface.co/docs/transformers/main/en/main_classes/data_collator#transformers.default_data_collator" rel="nofollow">default_data_collator</a> if no <code>processing_class</code> is provided, an instance
of <a href="https://huggingface.co/docs/transformers/main/en/main_classes/data_collator#transformers.DataCollatorWithPadding" rel="nofollow">DataCollatorWithPadding</a> otherwise if the processing_class is a feature extractor or
tokenizer.`,name:"data_collator"},{anchor:"trl.IterativeSFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.IterativeSFTTrainer.processing_class",description:`<strong>processing_class</strong> (<a href="https://huggingface.co/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase" rel="nofollow">PreTrainedTokenizerBase</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Processing class used to process the data. If <code>None</code>, the processing class is loaded from the model&#x2019;s name
with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer.from_pretrained" rel="nofollow">from_pretrained</a>.`,name:"processing_class"},{anchor:"trl.IterativeSFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.IterativeSFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.IterativeSFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.IterativeSFTTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, deprecated) &#x2014;
Maximum length of the tokenized sequence. Use <code>args.max_length</code> instead.`,name:"max_length"},{anchor:"trl.IterativeSFTTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, deprecated) &#x2014;
The truncation mode to use. Use <code>args.truncation_mode</code> instead.`,name:"truncation_mode"},{anchor:"trl.IterativeSFTTrainer.optimize_device_cache",description:`<strong>optimize_device_cache</strong> (<code>bool</code>, <em>optional</em>, deprecated) &#x2014;
Whether to optimize CUDA cache. Use <code>args.optimize_device_cache</code> instead.`,name:"optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L53"}}),Y=new De({props:{name:"create_model_card",anchor:"trl.IterativeSFTTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the model.`,name:"model_name"},{anchor:"trl.IterativeSFTTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.IterativeSFTTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L455"}}),K=new De({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": typing.Optional[list[torch.LongTensor]] = None"},{name:"attention_mask",val:": typing.Optional[list[torch.LongTensor]] = None"},{name:"labels",val:": typing.Optional[list[torch.LongTensor]] = None"},{name:"texts",val:": typing.Optional[list[str]] = None"},{name:"texts_labels",val:": typing.Optional[list[str]] = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (list<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (list<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (list<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (list<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (list<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L313",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),ee=new y({props:{title:"IterativeSFTConfig",local:"trl.IterativeSFTConfig",headingTag:"h2"}}),te=new De({props:{name:"class trl.IterativeSFTConfig",anchor:"trl.IterativeSFTConfig",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, list[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[list[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[list[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": list = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"optimize_device_cache",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_config.py#L21",parameterGroups:[{title:"Parameters that control the model",parametersDescription:[{anchor:"trl.IterativeSFTConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments for <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a>, used when the <code>model</code>
argument of the <a href="/docs/trl/main/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a> is provided as a string.`,name:"model_init_kwargs"}]},{title:"Parameters that control the data preprocessing",parametersDescription:[{anchor:"trl.IterativeSFTConfig.max_length",description:`<strong>max_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the tokenized sequence. Sequences longer than <code>max_length</code> are truncated.`,name:"max_length"},{anchor:"trl.IterativeSFTConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
The truncation mode to use, either <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.`,name:"truncation_mode"},{anchor:"trl.IterativeSFTConfig.optimize_device_cache",description:`<strong>optimize_device_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to optimize CUDA cache for slightly more memory-efficient training.`,name:"optimize_device_cache"}]}]}}),ae=new Ct({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/iterative_sft_trainer.md"}}),{c(){T=i("meta"),_e=o(),ce=i("p"),ue=o(),l(U.$$.fragment),fe=o(),J=i("p"),J.innerHTML=it,ve=o(),I=i("p"),I.textContent=lt,ye=o(),l($.$$.fragment),Te=o(),C=i("p"),C.textContent=st,he=o(),l(F.$$.fragment),Me=o(),l(N.$$.fragment),be=o(),j=i("p"),j.innerHTML=mt,we=o(),l(x.$$.fragment),Ue=o(),l(S.$$.fragment),Je=o(),l(k.$$.fragment),Ie=o(),l(Z.$$.fragment),$e=o(),z=i("p"),z.innerHTML=pt,Ce=o(),l(E.$$.fragment),Fe=o(),X=i("p"),X.innerHTML=dt,Ne=o(),l(R.$$.fragment),je=o(),l(O.$$.fragment),xe=o(),G=i("p"),G.innerHTML=ct,Se=o(),l(B.$$.fragment),ke=o(),l(q.$$.fragment),Ze=o(),A=i("p"),A.textContent=gt,ze=o(),V=i("ul"),V.innerHTML=_t,Ee=o(),l(Q.$$.fragment),Xe=o(),l(W.$$.fragment),Re=o(),H=i("p"),H.textContent=ut,Oe=o(),l(L.$$.fragment),Ge=o(),l(D.$$.fragment),Be=o(),f=i("div"),l(P.$$.fragment),Pe=o(),oe=i("p"),oe.textContent=ft,Ye=o(),h=i("div"),l(Y.$$.fragment),Ke=o(),re=i("p"),re.innerHTML=vt,et=o(),M=i("div"),l(K.$$.fragment),tt=o(),ie=i("p"),ie.textContent=yt,qe=o(),l(ee.$$.fragment),Ae=o(),v=i("div"),l(te.$$.fragment),at=o(),le=i("p"),le.innerHTML=Tt,nt=o(),se=i("p"),se.innerHTML=ht,ot=o(),me=i("p"),me.innerHTML=Mt,Ve=o(),l(ae.$$.fragment),Qe=o(),ge=i("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);T=s(t,"META",{name:!0,content:!0}),t.forEach(a),_e=r(e),ce=s(e,"P",{}),pe(ce).forEach(a),ue=r(e),m(U.$$.fragment,e),fe=r(e),J=s(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-138vcoi"&&(J.innerHTML=it),ve=r(e),I=s(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-dhwcd2"&&(I.textContent=lt),ye=r(e),m($.$$.fragment,e),Te=r(e),C=s(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-rodhdk"&&(C.textContent=st),he=r(e),m(F.$$.fragment,e),Me=r(e),m(N.$$.fragment,e),be=r(e),j=s(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1ijqots"&&(j.innerHTML=mt),we=r(e),m(x.$$.fragment,e),Ue=r(e),m(S.$$.fragment,e),Je=r(e),m(k.$$.fragment,e),Ie=r(e),m(Z.$$.fragment,e),$e=r(e),z=s(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-4ogz9q"&&(z.innerHTML=pt),Ce=r(e),m(E.$$.fragment,e),Fe=r(e),X=s(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1sxa5vd"&&(X.innerHTML=dt),Ne=r(e),m(R.$$.fragment,e),je=r(e),m(O.$$.fragment,e),xe=r(e),G=s(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-15bmeqz"&&(G.innerHTML=ct),Se=r(e),m(B.$$.fragment,e),ke=r(e),m(q.$$.fragment,e),Ze=r(e),A=s(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-16tim8d"&&(A.textContent=gt),ze=r(e),V=s(e,"UL",{"data-svelte-h":!0}),u(V)!=="svelte-9rvnwe"&&(V.innerHTML=_t),Ee=r(e),m(Q.$$.fragment,e),Xe=r(e),m(W.$$.fragment,e),Re=r(e),H=s(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1ocxaaf"&&(H.textContent=ut),Oe=r(e),m(L.$$.fragment,e),Ge=r(e),m(D.$$.fragment,e),Be=r(e),f=s(e,"DIV",{class:!0});var b=pe(f);m(P.$$.fragment,b),Pe=r(b),oe=s(b,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-xqyw6w"&&(oe.textContent=ft),Ye=r(b),h=s(b,"DIV",{class:!0});var He=pe(h);m(Y.$$.fragment,He),Ke=r(He),re=s(He,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1mh859w"&&(re.innerHTML=vt),He.forEach(a),et=r(b),M=s(b,"DIV",{class:!0});var Le=pe(M);m(K.$$.fragment,Le),tt=r(Le),ie=s(Le,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-v7dhdf"&&(ie.textContent=yt),Le.forEach(a),b.forEach(a),qe=r(e),m(ee.$$.fragment,e),Ae=r(e),v=s(e,"DIV",{class:!0});var w=pe(v);m(te.$$.fragment,w),at=r(w),le=s(w,"P",{"data-svelte-h":!0}),u(le)!=="svelte-13ptz11"&&(le.innerHTML=Tt),nt=r(w),se=s(w,"P",{"data-svelte-h":!0}),u(se)!=="svelte-zhwgcq"&&(se.innerHTML=ht),ot=r(w),me=s(w,"P",{"data-svelte-h":!0}),u(me)!=="svelte-ekuf1t"&&(me.innerHTML=Mt),w.forEach(a),Ve=r(e),m(ae.$$.fragment,e),Qe=r(e),ge=s(e,"P",{}),pe(ge).forEach(a),this.h()},h(){de(T,"name","hf:doc:metadata"),de(T,"content",Nt),de(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),de(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),de(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),de(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){_(document.head,T),n(e,_e,t),n(e,ce,t),n(e,ue,t),p(U,e,t),n(e,fe,t),n(e,J,t),n(e,ve,t),n(e,I,t),n(e,ye,t),p($,e,t),n(e,Te,t),n(e,C,t),n(e,he,t),p(F,e,t),n(e,Me,t),p(N,e,t),n(e,be,t),n(e,j,t),n(e,we,t),p(x,e,t),n(e,Ue,t),p(S,e,t),n(e,Je,t),p(k,e,t),n(e,Ie,t),p(Z,e,t),n(e,$e,t),n(e,z,t),n(e,Ce,t),p(E,e,t),n(e,Fe,t),n(e,X,t),n(e,Ne,t),p(R,e,t),n(e,je,t),p(O,e,t),n(e,xe,t),n(e,G,t),n(e,Se,t),p(B,e,t),n(e,ke,t),p(q,e,t),n(e,Ze,t),n(e,A,t),n(e,ze,t),n(e,V,t),n(e,Ee,t),p(Q,e,t),n(e,Xe,t),p(W,e,t),n(e,Re,t),n(e,H,t),n(e,Oe,t),p(L,e,t),n(e,Ge,t),p(D,e,t),n(e,Be,t),n(e,f,t),p(P,f,null),_(f,Pe),_(f,oe),_(f,Ye),_(f,h),p(Y,h,null),_(h,Ke),_(h,re),_(f,et),_(f,M),p(K,M,null),_(M,tt),_(M,ie),n(e,qe,t),p(ee,e,t),n(e,Ae,t),n(e,v,t),p(te,v,null),_(v,at),_(v,le),_(v,nt),_(v,se),_(v,ot),_(v,me),n(e,Ve,t),p(ae,e,t),n(e,Qe,t),n(e,ge,t),We=!0},p:wt,i(e){We||(d(U.$$.fragment,e),d($.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(x.$$.fragment,e),d(S.$$.fragment,e),d(k.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d(O.$$.fragment,e),d(B.$$.fragment,e),d(q.$$.fragment,e),d(Q.$$.fragment,e),d(W.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(Y.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),We=!0)},o(e){c(U.$$.fragment,e),c($.$$.fragment,e),c(F.$$.fragment,e),c(N.$$.fragment,e),c(x.$$.fragment,e),c(S.$$.fragment,e),c(k.$$.fragment,e),c(Z.$$.fragment,e),c(E.$$.fragment,e),c(R.$$.fragment,e),c(O.$$.fragment,e),c(B.$$.fragment,e),c(q.$$.fragment,e),c(Q.$$.fragment,e),c(W.$$.fragment,e),c(L.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(Y.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),We=!1},d(e){e&&(a(_e),a(ce),a(ue),a(fe),a(J),a(ve),a(I),a(ye),a(Te),a(C),a(he),a(Me),a(be),a(j),a(we),a(Ue),a(Je),a(Ie),a($e),a(z),a(Ce),a(Fe),a(X),a(Ne),a(je),a(xe),a(G),a(Se),a(ke),a(Ze),a(A),a(ze),a(V),a(Ee),a(Xe),a(Re),a(H),a(Oe),a(Ge),a(Be),a(f),a(qe),a(Ae),a(v),a(Ve),a(Qe),a(ge)),a(T),g(U,e),g($,e),g(F,e),g(N,e),g(x,e),g(S,e),g(k,e),g(Z,e),g(E,e),g(R,e),g(O,e),g(B,e),g(q,e),g(Q,e),g(W,e),g(L,e),g(D,e),g(P),g(Y),g(K),g(ee,e),g(te),g(ae,e)}}}const Nt='{"title":"Iterative Trainer","local":"iterative-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Using a list of tensors as input:","local":"using-a-list-of-tensors-as-input","sections":[],"depth":3},{"title":"Using a list of strings as input:","local":"using-a-list-of-strings-as-input","sections":[],"depth":3}],"depth":2},{"title":"Configuration","local":"configuration","sections":[{"title":"Model Initialization","local":"model-initialization","sections":[],"depth":3},{"title":"Data Preprocessing","local":"data-preprocessing","sections":[],"depth":3},{"title":"Training Optimization","local":"training-optimization","sections":[],"depth":3}],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"IterativeSFTConfig","local":"trl.IterativeSFTConfig","sections":[],"depth":2}],"depth":1}';function jt(rt){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Jt{constructor(T){super(),It(this,T,jt,Ft,bt,{})}}export{Et as component};
