import{s as ne,f as ae,n as Me,o as ie}from"../chunks/scheduler.d627b047.js";import{S as pe,i as Je,g as M,s as a,r as J,A as ye,h as i,f as t,c as n,j as yt,u as y,x as p,k as c,y as Te,a as e,v as T,d as o,t as U,w}from"../chunks/index.73c51727.js";import{C as j}from"../chunks/CodeBlock.5f78c87f.js";import{H as r,E as oe}from"../chunks/index.8df1db42.js";function Ue(Tt){let u,xl,El,Fl,d,Yl,h,ot='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/training_vlm_sft_training_procedure.png" alt="VLM SFT training procedure"/>',ql,g,Sl,C,Ut="This guide walks you through the process of fine-tuning a multimodal language model (e.g., <strong>Gemma 3</strong>) using <strong>Supervised Fine-Tuning (SFT)</strong>. We cover two cases:",zl,b,wt="<li><strong>Single Image + Text</strong></li> <li><strong>Multi-Image + Text</strong></li>",Hl,f,rt='This guide serves as a <strong>detailed walkthrough</strong> and complements the existing <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm_gemma3.py" rel="nofollow">VLM SFT script</a>. If you’re already familiar with the concepts, you can use the script directly.',$l,Z,jt="We demonstrate the fine-tuning process using two datasets, but these principles extend to other <strong>Vision-Language Models (VLMs)</strong> and datasets.",Ll,A,Dl,B,mt="To address both <strong>Single Image + Text</strong> and <strong>Multi-Image + Text</strong> scenarios, we use two datasets that are well-suited for this task.",Pl,G,Kl,W,It='This dataset is a reformatted version of <a href="https://huggingface.co/datasets/theblackcat102/llava-instruct-mix" rel="nofollow">LLaVA Instruct Mix</a>. It consists of conversations where a user provides both <strong>text</strong> and a <strong>single image</strong> as input.',Ol,v,ct="The model (referred to as the <strong>“assistant”</strong>) responds based on both the <strong>visual and textual information</strong> shared by the user. This dataset is particularly useful for training multimodal models to <strong>understand and generate responses based on images and text</strong>.",ls,m,ut,ss,R,ts,X,dt="The <strong>FanqingM/MMIU-Benchmark</strong> dataset consists of:",es,_,ht="<li><strong>Context:</strong> Included in the system prompt.</li> <li><strong>Question:</strong> Provided as part of the user’s input.</li> <li><strong>Series of Images:</strong> Multiple images related to the question.</li> <li><strong>Answer:</strong> The model’s expected response.</li>",as,k,gt="This dataset is designed for tasks where the model must reason over multiple images to generate an informed response based on both visual and textual inputs.",ns,I,Ct,Ms,N,is,Q,bt="In this section, we build the script needed to fine-tune a multimodal model for both <strong>Single Image + Text</strong> and <strong>Multi-Image + Text</strong> use cases.",ps,E,Js,V,ft="Before fine-tuning, we need to install the required dependencies. Let’s start by setting up the environment:",ys,x,Ts,F,Zt="Once all dependencies are installed, we need to log in to the <strong>Hugging Face Hub</strong>. Since <strong>Gemma 3</strong> is a gated model, access permissions are required.",os,Y,At='If you haven’t requested access yet, visit the <a href="https://huggingface.co/google/gemma-3-4b-it" rel="nofollow">Model Card</a> and request it.',Us,q,Bt='To log in, you’ll need to generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a> from your Hugging Face account.',ws,S,rs,z,js,H,Gt="As mentioned earlier, we will cover two possible use cases. While the specific procedure may vary based on the dataset, the core principles remain consistent.",ms,$,Wt="This guide supports both use cases, so refer to the <strong>Single Image + Text</strong> or <strong>Multi-Image + Text</strong> sections depending on your specific scenario.",Is,L,cs,D,vt='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/training_vlm_sft_training_procedure_single_image.png" alt="Single Image + Text"/>',us,P,Rt="In this case, each sample in a batch consists of a <strong>single image paired with text</strong>. Since the dataset is already formatted for supervised fine-tuning (SFT), we can directly load it using <code>load_dataset</code>.",ds,K,hs,O,gs,ll,Xt='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/training_vlm_sft_training_procedure_multi_image.png" alt="Multi-Image + Text"/>',Cs,sl,_t="Gemma 3 also supports <strong>Multi-Image + Text</strong> scenarios, where:",bs,tl,kt="<li>The model receives a <strong>list of images</strong> alongside a user message.</li> <li>The model processes <strong>interleaved images and text</strong> within a conversation.</li>",fs,el,Nt="For this dataset, some preprocessing is required before training.",Zs,al,As,nl,Qt="After loading the dataset, we need to preprocess and format it into a conversational structure. Here’s an example of how the data might look:",Bs,Ml,Gs,il,Et="Here, <code>images_list</code> is a list of images:",Ws,pl,vs,Jl,Vt="This structure can be translated into code like this:",Rs,yl,Xs,Tl,xt="With this, your <strong>Multi-Image + Text</strong> dataset is now prepared for training.",_s,ol,ks,Ul,Ft="We start by loading the model and processor. In this example, we use <code>google/gemma-3-4b-it</code>, but the same process applies to its other variants and similar models.",Ns,wl,Yt="To optimize memory usage, we configure <code>BitsAndBytes</code> to load the quantized version of the model.",Qs,rl,Es,jl,qt='Next, we set up <a href="https://huggingface.co/papers/2305.14314" rel="nofollow">Quantized Low-Rank Adaptation (QLoRA)</a>, an efficient fine-tuning technique for Large Language Models (LLMs) and Vision-Language Models (VLMs).',Vs,ml,xs,Il,St='With QLoRA now set up, we need to define the training arguments for SFT. The <a href="/docs/trl/main/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class simplifies this process, providing an easy way to adjust parameters based on our specific needs.',Fs,cl,Ys,ul,zt="The <code>collate_fn</code> is responsible for processing and preparing individual examples to form a batch.",qs,dl,Ht="Each example in the batch undergoes the following steps:",Ss,hl,$t="<li>The <strong>chat template</strong> is applied to the text.</li> <li>The <strong>processor tokenizes</strong> both <code>texts</code> and <code>images</code>, encoding them into tensors.</li> <li>The <strong>labels</strong> for training are set as the <code>input_ids</code> of the example.</li> <li>Certain <strong>special tokens</strong> are <strong>masked (ignored)</strong> during loss computation:  <ul><li><code>pad_token_id</code></li> <li><code>&lt;image_token_id&gt;</code></li> <li><code>&lt;image_soft_token&gt;</code> (corresponding to ID <code>262144</code>)</li></ul></li>",zs,gl,Lt="This process is similar across different dataset types, with a minor variation in how images are handled:",Hs,Cl,Dt="<li><strong>Single Image + Text</strong> → A <strong>list of images</strong> is directly processed.</li> <li><strong>Multi-Image + Text</strong> → A <strong>list of lists of images</strong> is used, where each batch element contains multiple images.</li>",$s,bl,Ls,fl,Ds,Zl,Pt="With all the components set up, we now configure the <code>SFTTrainer</code> using the previously defined settings and start the training process.",Ps,Al,Ks,Bl,Kt="We save the fine-tuned model to the Hub, making it easily accessible for future use. Additionally, TRL automatically logs the training results to <strong>Weights &amp; Biases (Wandb)</strong> or <strong>TensorBoard</strong>, depending on the chosen configuration.",Os,Gl,lt,Wl,Ot="During and after trainig, we can inspect the results using <strong>Weights &amp; Biases (Wandb)</strong> or <strong>TensorBoard</strong>. For example:",st,vl,le='<li><p><a href="https://huggingface.co/sergiopaniego/gemma-3-4b-it-trl-sft-llava-instruct-mix-vsft" rel="nofollow"><strong>gemma-3-4b-it-trl-sft-llava-instruct-mix-vsft (Single Image+Text)</strong></a></p></li> <li><p><a href="https://huggingface.co/sergiopaniego/gemma-3-4b-it-trl-sft-MMIU-Benchmark" rel="nofollow"><strong>gemma-3-4b-it-trl-sft-MMIU-Benchmark (Multi-Images+Text or Interleaving)</strong></a></p></li>',tt,Rl,et,Xl,se='Currently, fine-tuning Gemma has some <a href="https://github.com/huggingface/trl/issues/3121" rel="nofollow">known limitations</a>. We recommend following the procedure outlined in this guide to ensure the best results.',at,_l,nt,kl,te="For further reading and complementary resources, check out the following:",Mt,Nl,ee='<li><a href="https://ai.google.dev/gemma/docs/core/huggingface_vision_finetune_qlora" rel="nofollow">Fine-Tuning Vision-Language Models with QLoRA</a></li> <li><a href="https://huggingface.co/learn/cookbook/fine_tuning_vlm_trl" rel="nofollow">Fine-Tuning a Vision Language Model (Qwen2-VL-7B) with the Hugging Face Ecosystem (TRL)</a></li>',it,Ql,pt,Vl,Jt;return d=new r({props:{title:"Fine-tuning a Multimodal Model Using SFT (Single or Multi-Image Dataset)",local:"fine-tuning-a-multimodal-model-using-sft-single-or-multi-image-dataset",headingTag:"h1"}}),g=new r({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new r({props:{title:"Understanding the Datasets",local:"understanding-the-datasets",headingTag:"h2"}}),G=new r({props:{title:"HuggingFaceH4/llava-instruct-mix-vsft Dataset (Image + Text)",local:"huggingfaceh4llava-instruct-mix-vsft-dataset-image--text",headingTag:"h3"}}),R=new r({props:{title:"FanqingM/MMIU-Benchmark Dataset (Multi-Image + Text)",local:"fanqingmmmiu-benchmark-dataset-multi-image--text",headingTag:"h3"}}),N=new r({props:{title:"Developing a Fine-Tuning Script for Multimodal SFT",local:"developing-a-fine-tuning-script-for-multimodal-sft",headingTag:"h2"}}),E=new r({props:{title:"Setting Up the Environment",local:"setting-up-the-environment",headingTag:"h3"}}),x=new j({props:{code:"JTIzJTIwSW5zdGFsbCUyMHRoZSUyMHJlcXVpcmVkJTIwbGlicmFyaWVzLiUyMEZ1dGhlciUyMGRldGFpbHMlM0ElMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZG9jcyUyRnRybCUyRmluc3RhbGxhdGlvbiUyMCUwQXBpcCUyMGluc3RhbGwlMjAtVSUyMC1xJTIwdHJsJTIwYml0c2FuZGJ5dGVzJTIwcGVmdCUyMGhmX3hldCUyMHRlbnNvcmJvYXJk",highlighted:`<span class="hljs-comment"># Install the required libraries. Futher details: https://huggingface.co/docs/trl/installation </span>
pip install -U -q trl bitsandbytes peft hf_xet tensorboard`,wrap:!1}}),S=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),z=new r({props:{title:"Loading the Data",local:"loading-the-data",headingTag:"h3"}}),L=new r({props:{title:"Single Image + Text",local:"single-image--text",headingTag:"h4"}}),K=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VINCUyRmxsYXZhLWluc3RydWN0LW1peC12c2Z0JTIyJTBBJTBBJTIzJTIwTG9hZCUyMERhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset_name = <span class="hljs-string">&quot;HuggingFaceH4/llava-instruct-mix-vsft&quot;</span>

<span class="hljs-comment"># Load Dataset</span>
dataset = load_dataset(dataset_name)`,wrap:!1}}),O=new r({props:{title:"Multi-Image + Text (or Interleaving)",local:"multi-image--text-or-interleaving",headingTag:"h4"}}),al=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyRmFucWluZ00lMkZNTUlVLUJlbmNobWFyayUyMiUwQSUwQSUyMyUyMExvYWQlMjBEYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChkYXRhc2V0X25hbWUp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset_name = <span class="hljs-string">&quot;FanqingM/MMIU-Benchmark&quot;</span>

<span class="hljs-comment"># Load Dataset</span>
dataset = load_dataset(dataset_name)`,wrap:!1}}),Ml=new j({props:{code:"JTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwanVkZ2UlMjBpbiUyMGElMjBwaG90b2dyYXBoeSUyMGNvbXBldGl0aW9uJTJDJTIwYW5kJTIwbm93JTIweW91JTIwYXJlJTIwZ2l2ZW4lMjB0aGUlMjBmb3VyJTIwaW1hZ2VzLiUyMFBsZWFzZSUyMGV4YW1pbmUlMjB0aGUlMjBkZXRhaWxzJTIwYW5kJTIwdGVsbCUyMHdoaWNoJTIwb25lJTIwb2YlMjB0aGVtJTIwaXMlMjBtb3N0JTIwbGlrZWx5JTIwdG8lMjBiZSUyMGElMjByZWFsJTIwcGhvdG9ncmFwaC4lNUNuU2VsZWN0JTIwZnJvbSUyMHRoZSUyMGZvbGxvd2luZyUyMGNob2ljZXMuJTVDbkElM0ElMjB0aGUlMjBmaXJzdCUyMGltYWdlJTVDbkIlM0ElMjB0aGUlMjBzZWNvbmQlMjBpbWFnZSU1Q25DJTNBJTIwdGhlJTIwdGhpcmQlMjBpbWFnZSU1Q25EJTNBJTIwdGhlJTIwZm91cnRoJTIwaW1hZ2UlMjIlN0QlNUQlN0QlMkMlMEElN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBpbWFnZXNfbGlzdCUyMCUyQiUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoaWNoJTIwaW1hZ2UlMjBpcyUyMG1vc3QlMjBsaWtlbHklMjB0byUyMGJlJTIwYSUyMHJlYWwlMjBwaG90b2dyYXBoJTNGJTIyJTdEJTVEJTdEJTJDJTBBJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJBJTNBJTIwdGhlJTIwZmlyc3QlMjBpbWFnZSU1Q25CJTNBJTIwdGhlJTIwc2Vjb25kJTIwaW1hZ2UlNUNuQyUzQSUyMHRoZSUyMHRoaXJkJTIwaW1hZ2UlNUNuRCUzQSUyMHRoZSUyMGZvdXJ0aCUyMGltYWdlJTIyJTdEJTVEJTdEJTJD",highlighted:`{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a judge in a photography competition, and now you are given the four images. Please examine the details and tell which one of them is most likely to be a real photograph.\\nSelect from the following choices.\\nA: the first image\\nB: the second image\\nC: the third image\\nD: the fourth image&quot;</span>}]},
{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: images_list + [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Which image is most likely to be a real photograph?&quot;</span>}]},
{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A: the first image\\nB: the second image\\nC: the third image\\nD: the fourth image&quot;</span>}]},`,wrap:!1}}),pl=new j({props:{code:"aW1hZ2VzX2xpc3QlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUzQ2NsYXNzJTIwJ1BJTC5JbWFnZS5JbWFnZSclM0UlN0QlMkMlMEElMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUzQ2NsYXNzJTIwJ1BJTC5JbWFnZS5JbWFnZSclM0UlN0QlMkMlMEElMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUzQ2NsYXNzJTIwJ1BJTC5JbWFnZS5JbWFnZSclM0UlN0QlMkMlMEElMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUzQ2NsYXNzJTIwJ1BJTC5JbWFnZS5JbWFnZSclM0UlN0QlMkMlMEElMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUzQ2NsYXNzJTIwJ1BJTC5JbWFnZS5JbWFnZSclM0UlN0QlMkMlMEElNUQ=",highlighted:`images_list = [
  {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;PIL.Image.Image&#x27;</span>&gt;},
  {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;PIL.Image.Image&#x27;</span>&gt;},
  {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;PIL.Image.Image&#x27;</span>&gt;},
  {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;PIL.Image.Image&#x27;</span>&gt;},
  {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;PIL.Image.Image&#x27;</span>&gt;},
]`,wrap:!1}}),yl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> zipfile
<span class="hljs-keyword">import</span> io
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, list_repo_files
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

dataset_train_split = <span class="hljs-string">&quot;test&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_data</span>(<span class="hljs-params">samples: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>]:
    formatted_samples = {<span class="hljs-string">&quot;messages&quot;</span>: []}
    <span class="hljs-keyword">for</span> cont <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(samples[<span class="hljs-string">&quot;question&quot;</span>])):
        images = []
        <span class="hljs-keyword">for</span> img_path <span class="hljs-keyword">in</span> samples[<span class="hljs-string">&quot;input_image_path&quot;</span>][cont]:
            <span class="hljs-keyword">try</span>:
                <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
                    img_bytes = f.read()
                image = Image.<span class="hljs-built_in">open</span>(io.BytesIO(img_bytes)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
                images.append({<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: image})
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error processing image <span class="hljs-subst">{img_path}</span>: <span class="hljs-subst">{e}</span>&quot;</span>)
                <span class="hljs-keyword">continue</span>

        formatted_samples[<span class="hljs-string">&quot;messages&quot;</span>].append(
            [
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: samples[<span class="hljs-string">&quot;context&quot;</span>][cont]}]},
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: images + [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: samples[<span class="hljs-string">&quot;question&quot;</span>][cont]}]},
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: samples[<span class="hljs-string">&quot;output&quot;</span>][cont]}]},
            ]
        )
    <span class="hljs-keyword">return</span> formatted_samples

<span class="hljs-comment"># For multi-image example</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">dataset: DatasetDict, dataset_name: <span class="hljs-built_in">str</span>, dataset_train_split: <span class="hljs-built_in">str</span></span>) -&gt; DatasetDict:
    all_files = list_repo_files(dataset_name, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
    zip_files = [f <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> all_files <span class="hljs-keyword">if</span> f.endswith(<span class="hljs-string">&quot;.zip&quot;</span>)]

    <span class="hljs-keyword">for</span> zip_filename <span class="hljs-keyword">in</span> zip_files:
        zip_path = hf_hub_download(repo_id=dataset_name, filename=zip_filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
        extract_folder = zip_filename.replace(<span class="hljs-string">&quot;.zip&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)
        os.makedirs(extract_folder, exist_ok=<span class="hljs-literal">True</span>)

        <span class="hljs-keyword">with</span> zipfile.ZipFile(zip_path, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> zip_ref:
            zip_ref.extractall(extract_folder)

    dataset = dataset.<span class="hljs-built_in">map</span>(format_data, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">4</span>, num_proc=<span class="hljs-number">16</span>)
    <span class="hljs-keyword">return</span> dataset

dataset = prepare_dataset(dataset, dataset_name, dataset_train_split)`,wrap:!1}}),ol=new r({props:{title:"Preparing for Training",local:"preparing-for-training",headingTag:"h3"}}),rl=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQXV0b1Byb2Nlc3NvciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMy00Yi1pdCUyMiUwQSUwQSUyMyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGludC00JTIwY29uZmlnJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfc3RvcmFnZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJlYWdlciUyMiUyQyUyMCUyMyUyMEltcG9ydGFudCUyMChSZWYlM0ElMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycyUyRmJsb2IlMkZjMTVhN2FkYjI4M2ZhOTg0YTQwNTU4YzdmZTdiZWQzMGFlOTc1Y2RkJTJGc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGZ2VtbWEzJTJGbW9kZWxpbmdfZ2VtbWEzLnB5JTIzTDkzNCklMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUwQSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwcm9jZXNzb3IudG9rZW5pemVyLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMnJpZ2h0JTIy",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, AutoProcessor, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;google/gemma-3-4b-it&quot;</span>

<span class="hljs-comment"># BitsAndBytesConfig int-4 config</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_quant_storage=torch.bfloat16,
)

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForImageTextToText.from_pretrained(
    model_id, 
    device_map=<span class="hljs-string">&quot;auto&quot;</span>, 
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;eager&quot;</span>, <span class="hljs-comment"># Important (Ref: https://github.com/huggingface/transformers/blob/c15a7adb283fa984a40558c7fe7bed30ae975cdd/src/transformers/models/gemma3/modeling_gemma3.py#L934)</span>
    quantization_config=bnb_config
)
processor = AutoProcessor.from_pretrained(model_id)
processor.tokenizer.padding_side = <span class="hljs-string">&quot;right&quot;</span>`,wrap:!1}}),ml=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEElMjMlMjBDb25maWd1cmUlMjBRTG9SQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsbV9oZWFkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1iZWRfdG9rZW5zJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

<span class="hljs-comment"># Configure QLoRA</span>
peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    r=<span class="hljs-number">16</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    modules_to_save=[
        <span class="hljs-string">&quot;lm_head&quot;</span>,
        <span class="hljs-string">&quot;embed_tokens&quot;</span>,
    ],
)`,wrap:!1}}),cl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig

training_args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;gemma-3-4b-it-trl-sft-llava-instruct-mix-vsft&quot;</span>,     <span class="hljs-comment"># Directory to save the model and push to the Hub. Use a specific repository id (e.g., gemma-3-4b-it-trl-sft-MMIU-Benchmark for multi-image datasets).</span>
    num_train_epochs=<span class="hljs-number">1</span>,                                             <span class="hljs-comment"># Set the number of epochs to train the model.</span>
    per_device_train_batch_size=<span class="hljs-number">8</span>,                                  <span class="hljs-comment"># Batch size for each device (e.g., GPU) during training. multi-image -&gt; per_device_train_batch_size=1</span>
    gradient_accumulation_steps=<span class="hljs-number">4</span>,                                  <span class="hljs-comment"># Number of steps before performing a backward/update pass to accumulate gradients. multi-image -&gt; gradient_accumulation_steps=1</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,                                    <span class="hljs-comment"># Enable gradient checkpointing to reduce memory usage during training.</span>
    optim=<span class="hljs-string">&quot;adamw_torch_fused&quot;</span>,                                      <span class="hljs-comment"># Use the fused AdamW optimizer for better performance.</span>
    logging_steps=<span class="hljs-number">10</span>,                                               <span class="hljs-comment"># Frequency of logging training progress (log every 10 steps).</span>
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,                                          <span class="hljs-comment"># Save checkpoints at the end of each epoch.</span>
    learning_rate=<span class="hljs-number">2e-05</span>,                                            <span class="hljs-comment"># Learning rate for training.</span>
    bf16=<span class="hljs-literal">True</span>,                                                      <span class="hljs-comment"># Enable bfloat16 precision for training to save memory and speed up computations.</span>
    push_to_hub=<span class="hljs-literal">True</span>,                                               <span class="hljs-comment"># Automatically push the fine-tuned model to Hugging Face Hub after training.</span>
    report_to=<span class="hljs-string">&quot;tensorboard&quot;</span>,                                        <span class="hljs-comment"># Automatically report metrics to tensorboard.</span>
    gradient_checkpointing_kwargs={<span class="hljs-string">&quot;use_reentrant&quot;</span>: <span class="hljs-literal">False</span>},         <span class="hljs-comment"># Set gradient checkpointing to non-reentrant to avoid issues.</span>
    dataset_kwargs={<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>},                  <span class="hljs-comment"># Skip dataset preparation to handle preprocessing manually.</span>
    remove_unused_columns=<span class="hljs-literal">False</span>,                                    <span class="hljs-comment"># Ensure unused columns are not removed in the collator (important for batch processing).</span>
)`,wrap:!1}}),bl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-comment"># For multi-image cases</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_vision_info</span>(<span class="hljs-params">messages: <span class="hljs-built_in">list</span>[<span class="hljs-built_in">dict</span>]</span>) -&gt; <span class="hljs-built_in">list</span>[Image.Image]:
    image_inputs = []
    <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> messages:
        content = msg.get(<span class="hljs-string">&quot;content&quot;</span>, [])
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">isinstance</span>(content, <span class="hljs-built_in">list</span>):
            content = [content]

        <span class="hljs-keyword">for</span> element <span class="hljs-keyword">in</span> content:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(element, <span class="hljs-built_in">dict</span>) <span class="hljs-keyword">and</span> (<span class="hljs-string">&quot;image&quot;</span> <span class="hljs-keyword">in</span> element <span class="hljs-keyword">or</span> element.get(<span class="hljs-string">&quot;type&quot;</span>) == <span class="hljs-string">&quot;image&quot;</span>):
                <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;image&quot;</span> <span class="hljs-keyword">in</span> element:
                    image = element[<span class="hljs-string">&quot;image&quot;</span>]
                <span class="hljs-keyword">else</span>:
                    image = element
                <span class="hljs-keyword">if</span> image <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                    image = Image.<span class="hljs-built_in">open</span>(io.BytesIO(image[<span class="hljs-string">&quot;bytes&quot;</span>]))
                    image_inputs.append(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))
    <span class="hljs-keyword">return</span> image_inputs

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    texts = [processor.apply_chat_template(example[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>).strip() <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;images&quot;</span> <span class="hljs-keyword">in</span> examples[<span class="hljs-number">0</span>]:  <span class="hljs-comment"># single-image</span>
        images = [
            [img.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> img <span class="hljs-keyword">in</span> example[<span class="hljs-string">&quot;images&quot;</span>]]
            <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples
        ]
    <span class="hljs-keyword">else</span>:  <span class="hljs-comment"># multi-image</span>
        images = [process_vision_info(example[<span class="hljs-string">&quot;messages&quot;</span>]) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    <span class="hljs-comment"># Tokenize the texts and process the images</span>
    batch = processor(
        text=texts, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
    )  <span class="hljs-comment"># Encode texts and images into tensors</span>

    <span class="hljs-comment"># The labels are the input_ids, and we mask the padding tokens in the loss computation</span>
    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()  <span class="hljs-comment"># Clone input IDs for labels</span>
    <span class="hljs-comment"># Mask image tokens</span>
    image_token_id = [
        processor.tokenizer.convert_tokens_to_ids(processor.tokenizer.special_tokens_map[<span class="hljs-string">&quot;boi_token&quot;</span>])
    ]
    <span class="hljs-comment"># Mask tokens for not being used in the loss computation</span>
    labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    labels[labels == image_token_id] = -<span class="hljs-number">100</span>
    labels[labels == <span class="hljs-number">262144</span>] = -<span class="hljs-number">100</span>

    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> batch  <span class="hljs-comment"># Return the prepared batch</span>`,wrap:!1}}),fl=new r({props:{title:"Training the Model",local:"training-the-model",headingTag:"h3"}}),Al=new j({props:{code:"JTIzJTIwVHJhaW5pbmclMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwU0ZUVHJhaW5lciUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMCUyMyUyMG11bHRpLWltYWdlJTIwLSUzRSUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0Rwcm9jZXNzb3IlMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTBBdHJhaW5lci5zYXZlX21vZGVsKCk=",highlighted:`<span class="hljs-comment"># Training</span>
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

trainer = SFTTrainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>], <span class="hljs-comment"># multi-image -&gt; train_dataset=dataset[&quot;test&quot;],</span>
    processing_class=processor,
    peft_config=peft_config,
)

trainer.train()

<span class="hljs-comment"># Save the final model</span>
trainer.save_model()`,wrap:!1}}),Gl=new r({props:{title:"Results",local:"results",headingTag:"h3"}}),Rl=new r({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),_l=new r({props:{title:"References",local:"references",headingTag:"h2"}}),Ql=new oe({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/training_vlm_sft.md"}}),{c(){u=M("meta"),xl=a(),El=M("p"),Fl=a(),J(d.$$.fragment),Yl=a(),h=M("p"),h.innerHTML=ot,ql=a(),J(g.$$.fragment),Sl=a(),C=M("p"),C.innerHTML=Ut,zl=a(),b=M("ul"),b.innerHTML=wt,Hl=a(),f=M("p"),f.innerHTML=rt,$l=a(),Z=M("p"),Z.innerHTML=jt,Ll=a(),J(A.$$.fragment),Dl=a(),B=M("p"),B.innerHTML=mt,Pl=a(),J(G.$$.fragment),Kl=a(),W=M("p"),W.innerHTML=It,Ol=a(),v=M("p"),v.innerHTML=ct,ls=a(),m=M("iframe"),ss=a(),J(R.$$.fragment),ts=a(),X=M("p"),X.innerHTML=dt,es=a(),_=M("ul"),_.innerHTML=ht,as=a(),k=M("p"),k.textContent=gt,ns=a(),I=M("iframe"),Ms=a(),J(N.$$.fragment),is=a(),Q=M("p"),Q.innerHTML=bt,ps=a(),J(E.$$.fragment),Js=a(),V=M("p"),V.textContent=ft,ys=a(),J(x.$$.fragment),Ts=a(),F=M("p"),F.innerHTML=Zt,os=a(),Y=M("p"),Y.innerHTML=At,Us=a(),q=M("p"),q.innerHTML=Bt,ws=a(),J(S.$$.fragment),rs=a(),J(z.$$.fragment),js=a(),H=M("p"),H.textContent=Gt,ms=a(),$=M("p"),$.innerHTML=Wt,Is=a(),J(L.$$.fragment),cs=a(),D=M("p"),D.innerHTML=vt,us=a(),P=M("p"),P.innerHTML=Rt,ds=a(),J(K.$$.fragment),hs=a(),J(O.$$.fragment),gs=a(),ll=M("p"),ll.innerHTML=Xt,Cs=a(),sl=M("p"),sl.innerHTML=_t,bs=a(),tl=M("ul"),tl.innerHTML=kt,fs=a(),el=M("p"),el.textContent=Nt,Zs=a(),J(al.$$.fragment),As=a(),nl=M("p"),nl.textContent=Qt,Bs=a(),J(Ml.$$.fragment),Gs=a(),il=M("p"),il.innerHTML=Et,Ws=a(),J(pl.$$.fragment),vs=a(),Jl=M("p"),Jl.textContent=Vt,Rs=a(),J(yl.$$.fragment),Xs=a(),Tl=M("p"),Tl.innerHTML=xt,_s=a(),J(ol.$$.fragment),ks=a(),Ul=M("p"),Ul.innerHTML=Ft,Ns=a(),wl=M("p"),wl.innerHTML=Yt,Qs=a(),J(rl.$$.fragment),Es=a(),jl=M("p"),jl.innerHTML=qt,Vs=a(),J(ml.$$.fragment),xs=a(),Il=M("p"),Il.innerHTML=St,Fs=a(),J(cl.$$.fragment),Ys=a(),ul=M("p"),ul.innerHTML=zt,qs=a(),dl=M("p"),dl.textContent=Ht,Ss=a(),hl=M("ol"),hl.innerHTML=$t,zs=a(),gl=M("p"),gl.textContent=Lt,Hs=a(),Cl=M("ul"),Cl.innerHTML=Dt,$s=a(),J(bl.$$.fragment),Ls=a(),J(fl.$$.fragment),Ds=a(),Zl=M("p"),Zl.innerHTML=Pt,Ps=a(),J(Al.$$.fragment),Ks=a(),Bl=M("p"),Bl.innerHTML=Kt,Os=a(),J(Gl.$$.fragment),lt=a(),Wl=M("p"),Wl.innerHTML=Ot,st=a(),vl=M("ul"),vl.innerHTML=le,tt=a(),J(Rl.$$.fragment),et=a(),Xl=M("p"),Xl.innerHTML=se,at=a(),J(_l.$$.fragment),nt=a(),kl=M("p"),kl.textContent=te,Mt=a(),Nl=M("ul"),Nl.innerHTML=ee,it=a(),J(Ql.$$.fragment),pt=a(),Vl=M("p"),this.h()},l(l){const s=ye("svelte-u9bgzb",document.head);u=i(s,"META",{name:!0,content:!0}),s.forEach(t),xl=n(l),El=i(l,"P",{}),yt(El).forEach(t),Fl=n(l),y(d.$$.fragment,l),Yl=n(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-assgj1"&&(h.innerHTML=ot),ql=n(l),y(g.$$.fragment,l),Sl=n(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-vv7ieu"&&(C.innerHTML=Ut),zl=n(l),b=i(l,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-jkkou4"&&(b.innerHTML=wt),Hl=n(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-16g17rh"&&(f.innerHTML=rt),$l=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-kb05rw"&&(Z.innerHTML=jt),Ll=n(l),y(A.$$.fragment,l),Dl=n(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1f1s4pm"&&(B.innerHTML=mt),Pl=n(l),y(G.$$.fragment,l),Kl=n(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nggb9q"&&(W.innerHTML=It),Ol=n(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-4sw3ba"&&(v.innerHTML=ct),ls=n(l),m=i(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),yt(m).forEach(t),ss=n(l),y(R.$$.fragment,l),ts=n(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1n6zmi5"&&(X.innerHTML=dt),es=n(l),_=i(l,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-1qd63xf"&&(_.innerHTML=ht),as=n(l),k=i(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-nk5by6"&&(k.textContent=gt),ns=n(l),I=i(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),yt(I).forEach(t),Ms=n(l),y(N.$$.fragment,l),is=n(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-3771ba"&&(Q.innerHTML=bt),ps=n(l),y(E.$$.fragment,l),Js=n(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ymwdfb"&&(V.textContent=ft),ys=n(l),y(x.$$.fragment,l),Ts=n(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-tw6nwu"&&(F.innerHTML=Zt),os=n(l),Y=i(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1gm0ufc"&&(Y.innerHTML=At),Us=n(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1msiqux"&&(q.innerHTML=Bt),ws=n(l),y(S.$$.fragment,l),rs=n(l),y(z.$$.fragment,l),js=n(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1bfak6n"&&(H.textContent=Gt),ms=n(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1ay01is"&&($.innerHTML=Wt),Is=n(l),y(L.$$.fragment,l),cs=n(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-kcgl68"&&(D.innerHTML=vt),us=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1q5u18t"&&(P.innerHTML=Rt),ds=n(l),y(K.$$.fragment,l),hs=n(l),y(O.$$.fragment,l),gs=n(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-38ynmb"&&(ll.innerHTML=Xt),Cs=n(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1ihvfdh"&&(sl.innerHTML=_t),bs=n(l),tl=i(l,"UL",{"data-svelte-h":!0}),p(tl)!=="svelte-16lodrc"&&(tl.innerHTML=kt),fs=n(l),el=i(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-1lnoo89"&&(el.textContent=Nt),Zs=n(l),y(al.$$.fragment,l),As=n(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-mtbndo"&&(nl.textContent=Qt),Bs=n(l),y(Ml.$$.fragment,l),Gs=n(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-io4ruq"&&(il.innerHTML=Et),Ws=n(l),y(pl.$$.fragment,l),vs=n(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1ncwmbi"&&(Jl.textContent=Vt),Rs=n(l),y(yl.$$.fragment,l),Xs=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-1seiemt"&&(Tl.innerHTML=xt),_s=n(l),y(ol.$$.fragment,l),ks=n(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-dt3w69"&&(Ul.innerHTML=Ft),Ns=n(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-admdnh"&&(wl.innerHTML=Yt),Qs=n(l),y(rl.$$.fragment,l),Es=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1xgbikp"&&(jl.innerHTML=qt),Vs=n(l),y(ml.$$.fragment,l),xs=n(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-1yao7go"&&(Il.innerHTML=St),Fs=n(l),y(cl.$$.fragment,l),Ys=n(l),ul=i(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1ln7rdi"&&(ul.innerHTML=zt),qs=n(l),dl=i(l,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-il65g0"&&(dl.textContent=Ht),Ss=n(l),hl=i(l,"OL",{"data-svelte-h":!0}),p(hl)!=="svelte-12xpkgt"&&(hl.innerHTML=$t),zs=n(l),gl=i(l,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1ju9ut5"&&(gl.textContent=Lt),Hs=n(l),Cl=i(l,"UL",{"data-svelte-h":!0}),p(Cl)!=="svelte-gqat7y"&&(Cl.innerHTML=Dt),$s=n(l),y(bl.$$.fragment,l),Ls=n(l),y(fl.$$.fragment,l),Ds=n(l),Zl=i(l,"P",{"data-svelte-h":!0}),p(Zl)!=="svelte-vfpq2f"&&(Zl.innerHTML=Pt),Ps=n(l),y(Al.$$.fragment,l),Ks=n(l),Bl=i(l,"P",{"data-svelte-h":!0}),p(Bl)!=="svelte-1ysmmiq"&&(Bl.innerHTML=Kt),Os=n(l),y(Gl.$$.fragment,l),lt=n(l),Wl=i(l,"P",{"data-svelte-h":!0}),p(Wl)!=="svelte-zh4ukv"&&(Wl.innerHTML=Ot),st=n(l),vl=i(l,"UL",{"data-svelte-h":!0}),p(vl)!=="svelte-7c7px2"&&(vl.innerHTML=le),tt=n(l),y(Rl.$$.fragment,l),et=n(l),Xl=i(l,"P",{"data-svelte-h":!0}),p(Xl)!=="svelte-njk5by"&&(Xl.innerHTML=se),at=n(l),y(_l.$$.fragment,l),nt=n(l),kl=i(l,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-gmrtfh"&&(kl.textContent=te),Mt=n(l),Nl=i(l,"UL",{"data-svelte-h":!0}),p(Nl)!=="svelte-86b5rz"&&(Nl.innerHTML=ee),it=n(l),y(Ql.$$.fragment,l),pt=n(l),Vl=i(l,"P",{}),yt(Vl).forEach(t),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",we),ae(m.src,ut="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft/embed/viewer/default/train")||c(m,"src",ut),c(m,"frameborder","0"),c(m,"width","100%"),c(m,"height","560px"),ae(I.src,Ct="https://huggingface.co/datasets/FanqingM/MMIU-Benchmark/embed/viewer/default/test")||c(I,"src",Ct),c(I,"frameborder","0"),c(I,"width","100%"),c(I,"height","560px")},m(l,s){Te(document.head,u),e(l,xl,s),e(l,El,s),e(l,Fl,s),T(d,l,s),e(l,Yl,s),e(l,h,s),e(l,ql,s),T(g,l,s),e(l,Sl,s),e(l,C,s),e(l,zl,s),e(l,b,s),e(l,Hl,s),e(l,f,s),e(l,$l,s),e(l,Z,s),e(l,Ll,s),T(A,l,s),e(l,Dl,s),e(l,B,s),e(l,Pl,s),T(G,l,s),e(l,Kl,s),e(l,W,s),e(l,Ol,s),e(l,v,s),e(l,ls,s),e(l,m,s),e(l,ss,s),T(R,l,s),e(l,ts,s),e(l,X,s),e(l,es,s),e(l,_,s),e(l,as,s),e(l,k,s),e(l,ns,s),e(l,I,s),e(l,Ms,s),T(N,l,s),e(l,is,s),e(l,Q,s),e(l,ps,s),T(E,l,s),e(l,Js,s),e(l,V,s),e(l,ys,s),T(x,l,s),e(l,Ts,s),e(l,F,s),e(l,os,s),e(l,Y,s),e(l,Us,s),e(l,q,s),e(l,ws,s),T(S,l,s),e(l,rs,s),T(z,l,s),e(l,js,s),e(l,H,s),e(l,ms,s),e(l,$,s),e(l,Is,s),T(L,l,s),e(l,cs,s),e(l,D,s),e(l,us,s),e(l,P,s),e(l,ds,s),T(K,l,s),e(l,hs,s),T(O,l,s),e(l,gs,s),e(l,ll,s),e(l,Cs,s),e(l,sl,s),e(l,bs,s),e(l,tl,s),e(l,fs,s),e(l,el,s),e(l,Zs,s),T(al,l,s),e(l,As,s),e(l,nl,s),e(l,Bs,s),T(Ml,l,s),e(l,Gs,s),e(l,il,s),e(l,Ws,s),T(pl,l,s),e(l,vs,s),e(l,Jl,s),e(l,Rs,s),T(yl,l,s),e(l,Xs,s),e(l,Tl,s),e(l,_s,s),T(ol,l,s),e(l,ks,s),e(l,Ul,s),e(l,Ns,s),e(l,wl,s),e(l,Qs,s),T(rl,l,s),e(l,Es,s),e(l,jl,s),e(l,Vs,s),T(ml,l,s),e(l,xs,s),e(l,Il,s),e(l,Fs,s),T(cl,l,s),e(l,Ys,s),e(l,ul,s),e(l,qs,s),e(l,dl,s),e(l,Ss,s),e(l,hl,s),e(l,zs,s),e(l,gl,s),e(l,Hs,s),e(l,Cl,s),e(l,$s,s),T(bl,l,s),e(l,Ls,s),T(fl,l,s),e(l,Ds,s),e(l,Zl,s),e(l,Ps,s),T(Al,l,s),e(l,Ks,s),e(l,Bl,s),e(l,Os,s),T(Gl,l,s),e(l,lt,s),e(l,Wl,s),e(l,st,s),e(l,vl,s),e(l,tt,s),T(Rl,l,s),e(l,et,s),e(l,Xl,s),e(l,at,s),T(_l,l,s),e(l,nt,s),e(l,kl,s),e(l,Mt,s),e(l,Nl,s),e(l,it,s),T(Ql,l,s),e(l,pt,s),e(l,Vl,s),Jt=!0},p:Me,i(l){Jt||(o(d.$$.fragment,l),o(g.$$.fragment,l),o(A.$$.fragment,l),o(G.$$.fragment,l),o(R.$$.fragment,l),o(N.$$.fragment,l),o(E.$$.fragment,l),o(x.$$.fragment,l),o(S.$$.fragment,l),o(z.$$.fragment,l),o(L.$$.fragment,l),o(K.$$.fragment,l),o(O.$$.fragment,l),o(al.$$.fragment,l),o(Ml.$$.fragment,l),o(pl.$$.fragment,l),o(yl.$$.fragment,l),o(ol.$$.fragment,l),o(rl.$$.fragment,l),o(ml.$$.fragment,l),o(cl.$$.fragment,l),o(bl.$$.fragment,l),o(fl.$$.fragment,l),o(Al.$$.fragment,l),o(Gl.$$.fragment,l),o(Rl.$$.fragment,l),o(_l.$$.fragment,l),o(Ql.$$.fragment,l),Jt=!0)},o(l){U(d.$$.fragment,l),U(g.$$.fragment,l),U(A.$$.fragment,l),U(G.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(E.$$.fragment,l),U(x.$$.fragment,l),U(S.$$.fragment,l),U(z.$$.fragment,l),U(L.$$.fragment,l),U(K.$$.fragment,l),U(O.$$.fragment,l),U(al.$$.fragment,l),U(Ml.$$.fragment,l),U(pl.$$.fragment,l),U(yl.$$.fragment,l),U(ol.$$.fragment,l),U(rl.$$.fragment,l),U(ml.$$.fragment,l),U(cl.$$.fragment,l),U(bl.$$.fragment,l),U(fl.$$.fragment,l),U(Al.$$.fragment,l),U(Gl.$$.fragment,l),U(Rl.$$.fragment,l),U(_l.$$.fragment,l),U(Ql.$$.fragment,l),Jt=!1},d(l){l&&(t(xl),t(El),t(Fl),t(Yl),t(h),t(ql),t(Sl),t(C),t(zl),t(b),t(Hl),t(f),t($l),t(Z),t(Ll),t(Dl),t(B),t(Pl),t(Kl),t(W),t(Ol),t(v),t(ls),t(m),t(ss),t(ts),t(X),t(es),t(_),t(as),t(k),t(ns),t(I),t(Ms),t(is),t(Q),t(ps),t(Js),t(V),t(ys),t(Ts),t(F),t(os),t(Y),t(Us),t(q),t(ws),t(rs),t(js),t(H),t(ms),t($),t(Is),t(cs),t(D),t(us),t(P),t(ds),t(hs),t(gs),t(ll),t(Cs),t(sl),t(bs),t(tl),t(fs),t(el),t(Zs),t(As),t(nl),t(Bs),t(Gs),t(il),t(Ws),t(vs),t(Jl),t(Rs),t(Xs),t(Tl),t(_s),t(ks),t(Ul),t(Ns),t(wl),t(Qs),t(Es),t(jl),t(Vs),t(xs),t(Il),t(Fs),t(Ys),t(ul),t(qs),t(dl),t(Ss),t(hl),t(zs),t(gl),t(Hs),t(Cl),t($s),t(Ls),t(Ds),t(Zl),t(Ps),t(Ks),t(Bl),t(Os),t(lt),t(Wl),t(st),t(vl),t(tt),t(et),t(Xl),t(at),t(nt),t(kl),t(Mt),t(Nl),t(it),t(pt),t(Vl)),t(u),w(d,l),w(g,l),w(A,l),w(G,l),w(R,l),w(N,l),w(E,l),w(x,l),w(S,l),w(z,l),w(L,l),w(K,l),w(O,l),w(al,l),w(Ml,l),w(pl,l),w(yl,l),w(ol,l),w(rl,l),w(ml,l),w(cl,l),w(bl,l),w(fl,l),w(Al,l),w(Gl,l),w(Rl,l),w(_l,l),w(Ql,l)}}}const we='{"title":"Fine-tuning a Multimodal Model Using SFT (Single or Multi-Image Dataset)","local":"fine-tuning-a-multimodal-model-using-sft-single-or-multi-image-dataset","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Understanding the Datasets","local":"understanding-the-datasets","sections":[{"title":"HuggingFaceH4/llava-instruct-mix-vsft Dataset (Image + Text)","local":"huggingfaceh4llava-instruct-mix-vsft-dataset-image--text","sections":[],"depth":3},{"title":"FanqingM/MMIU-Benchmark Dataset (Multi-Image + Text)","local":"fanqingmmmiu-benchmark-dataset-multi-image--text","sections":[],"depth":3}],"depth":2},{"title":"Developing a Fine-Tuning Script for Multimodal SFT","local":"developing-a-fine-tuning-script-for-multimodal-sft","sections":[{"title":"Setting Up the Environment","local":"setting-up-the-environment","sections":[],"depth":3},{"title":"Loading the Data","local":"loading-the-data","sections":[{"title":"Single Image + Text","local":"single-image--text","sections":[],"depth":4},{"title":"Multi-Image + Text (or Interleaving)","local":"multi-image--text-or-interleaving","sections":[],"depth":4}],"depth":3},{"title":"Preparing for Training","local":"preparing-for-training","sections":[],"depth":3},{"title":"Training the Model","local":"training-the-model","sections":[],"depth":3},{"title":"Results","local":"results","sections":[],"depth":3}],"depth":2},{"title":"Limitations","local":"limitations","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function re(Tt){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends pe{constructor(u){super(),Je(this,u,re,Ue,ne,{})}}export{ue as component};
