import{s as Vl,n as kl,o as Bl}from"../chunks/scheduler.d627b047.js";import{S as El,i as Sl,g as i,s as n,r,A as Al,h as o,f as t,c as a,j as Zl,u as y,x as M,k as Ll,y as Wl,a as s,v as p,d as w,t as h,w as d}from"../chunks/index.73c51727.js";import{C as m}from"../chunks/CodeBlock.5f78c87f.js";import{H as T,E as Rl}from"../chunks/index.8df1db42.js";function _l(sl){let U,ye,Me,pe,c,we,J,nl="This document will guide you through the process of using vLLM with TRL for faster generation in online methods like GRPO and Online DPO. We first summarize a tl;dr on how to use vLLM with TRL, and then we will go into the details of how it works under the hood. Let’s go! 🔥",he,u,de,I,al="💡 <strong>Note</strong>: Resources required for this specific example: a single node with 8 GPUs.",Ue,C,il="First, install vLLM using the following command:",me,j,Te,f,ol="Then run the server:",ce,b,Je,g,Ml="Once the server is running, you can use it to generate completions for training. In the example below, we are using the <code>GRPOTrainer</code> to train a model using the vLLM server for generation. The <code>--tensor-parallel-size</code> and <code>--data-parallel-size</code> arguments control how the model and data are sharded across GPUs.",ue,v,rl="In this example, we are sharding two copies of the model across 4 GPUs. Increasing data parallelism increases throughput, while increasing tensor parallelism allows for serving larger models. Then, run the training script by passing <code>use_vllm=True</code> in the training arguments as follows:",Ie,G,yl="Sample of a simple <code>train.py</code> script:",Ce,Z,je,L,pl="And the train command:",fe,V,be,k,ge,B,wl='Online methods like GRPO or Online DPO require the model to generate completions during training, which are then used to compute reward signals. However, generation can be extremely time-consuming, especially with large or reasoning models. In the default setup (without vLLM), completions are generated using the <a href="https://github.com/huggingface/trl/blob/f3e8c2304428ef16e9ae5de9e5741ed84d533b7b/trl/trainer/grpo_trainer.py#L965C39-L965C66" rel="nofollow">(unwrapped) model’s <code>generate</code> method</a>. This approach quickly becomes a major bottleneck — generation is slow and inefficient, particularly for large batches or models. As a result, training times increase significantly, and overall efficiency drops. To address this, we turn to vLLM, which enables much faster and more scalable generation, helping eliminate this bottleneck in online methods.',ve,E,Ge,S,hl='If you’ve ever done autoregressive decoder training, you know all the input tokens to the LLM produce their attention key and value tensors, and these tensors are kept in GPU memory to later generate subsequent tokens based on them. These cached key and value tensors are often referred to as the KV cache. However, storing the KV cache occupies a lot of memory, so vLLM uses a technique called <strong>PagedAttention</strong> to solve this problem. PagedAttention, which is inspired by the OS’s virtual memory concept, stores continuous keys and values in <strong>non-contiguous memory space</strong>, which is much more efficient. The details of this are beyond the scope of this document, but in short, it allows the model to store the keys and values in a more efficient way, reducing the memory footprint and speeding up the generation process. If you are interested, make sure to check out the <a href="https://blog.vllm.ai/2023/06/20/vllm.html" rel="nofollow">vLLM PagedAttention</a> for more details.',Ze,A,Le,W,dl="When you run for example",Ve,R,ke,_,Ul="the following happens:",Be,x,ml='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/vllm-doc.png" alt="vllm"/>',Ee,$,Tl=`<li><p>vLLM first spawns multiple workers to handle incoming requests in parallel. The number of workers is determined by multiplying the <code>--tensor-parallel-size</code> and <code>--data-parallel-size</code> values. In this example, it spawns 4 workers (1 × 4).
Each worker operates independently and processes a chunk of the incoming requests — which are basically the prompts sent to the server for generation. A key point to understand is that these 4 workers are running in parallel, and each one is responsible for handling a subset of the total incoming load.</p></li> <li><p>Once the incoming requests (prompts) are distributed across the workers, the model starts generating completions. Internally, the model’s weights are split across multiple GPUs based on the <code>--tensor-parallel-size</code> argument — this is how tensor parallelism is handled. Meanwhile, data parallelism (controlled by <code>--data-parallel-size</code>) ensures that different sets of requests are processed independently across the workers. In short: tensor parallelism splits the model across GPUs, and data parallelism splits the batch of requests across different model replicas.</p></li> <li><p>Although the GPUs process requests independently and in parallel, they still need to communicate with each other. Remember that each GPU handles only a slice of the incoming prompts (for example, with 4 GPUs and 8 prompts using <code>--data-parallel-size=4</code>, each GPU processes 2 prompts).
This GPU-to-GPU communication is managed efficiently by NVIDIA’s NCCL library. The communication mainly ensures that each GPU gets its correct portion of the incoming requests — it’s lightweight and doesn’t interfere with generation itself.
Separately, the number of completions to generate per prompt is controlled by the <code>num_generations</code> setting in the GRPO config. For instance, if you set <code>num_generations=2</code> (like in the picture above), each prompt will have 2 completions. So, with 8 prompts and <code>num_generations=2</code>, you would end up with 16 completions total — regardless of the number of GPUs or parallelism settings.</p></li>`,Se,F,Ae,X,cl='<li>The vLLM server starts by running the command: <code>trl vllm-serve --model Qwen/Qwen2.5-7B</code>.</li> <li>Once the server is running, it generates completions based on requests from the client (trainer) using <code>vllm_client.generate</code> <a href="https://github.com/huggingface/trl/blob/cc044e35b285be7dc062764b3364e1e684db4c7c/trl/trainer/grpo_trainer.py#L1025-L1035" rel="nofollow">here</a>.</li> <li>The client (trainer) then requests these completions from the server.</li> <li>These completions are used to compute the reward signal.</li> <li>Based on the reward signal and the model’s output, the loss is computed, and the backward pass is performed to update the model’s weights.</li> <li><strong>Note</strong>: The server only handles completion generation — it doesn’t train the model. Therefore, the model’s weights aren’t updated on the server. Once the backward pass is complete, the client sends the updated weights to the server using <code>vllm_client.update_named_param(name, param.data)</code>.</li>',We,H,Jl="When using vLLM, ensure the GPUs assigned for training and generation are separate to avoid resource conflicts. For instance, if you plan to use 4 GPUs for training and another 4 for vLLM generation, you can specify GPU allocation for training using <code>CUDA_VISIBLE_DEVICES</code>. See the example below:",Re,N,ul="<li><strong>Set GPUs <em>0–3</em> for vLLM generation:</strong> Assume <code>CUDA_VISIBLE_DEVICES=0,1,2,3</code> are allocated for vLLM generation.</li>",_e,Q,xe,Y,Il="<li><strong>And GPUs <em>4–7</em> for training:</strong> If you do not set the <code>CUDA_VISIBLE_DEVICES</code> environment variable, the training script will use all available GPUs by default, which may lead to resource conflicts. To avoid this, you can specify which GPUs to use for training. For example, if you want to use GPUs 4–7 for training, set the environment variable as follows:</li>",$e,z,Fe,P,Xe,O,Cl="You can customize the server configuration by passing additional arguments.",He,D,Ne,q,Qe,K,jl="Run the training script and pass <code>use_vllm=True</code> in the training arguments:",Ye,ee,ze,le,Pe,te,fl='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/tp_dp_throughput_8_gpus.png"/> <img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/tp_dp_throughput_4_gpus.png"/>',Oe,se,bl="First and foremost, always remember that the optimal setup depends on:",De,ne,gl="<li>The model size</li> <li>The number of GPUs you have</li> <li>The GPU memory size</li> <li>The batch size you are using</li> <li>The number of requests you are sending to the server (prompts)</li> <li>The <code>max_model_len</code> you are using (this is the max length of the input sequence that the model can process, a.k.a. the context window size)</li> <li>The number of completions you are generating for each request (<code>num_generations</code>)</li>",qe,ae,vl="Given these factors, our experiments on the Qwen model family (3B, 7B, 14B, 32B) using 8 H100 GPUs show that:",Ke,ie,Gl="<li>For reasonable-sized models (3B–14B) and a moderate context window (<code>max_len &lt; 8k</code>), using full capacity for data parallelism gives better throughput. The setup <code>(tp=1, dp=8)</code> yields the best results.</li> <li>For larger models (32B) and longer context windows (<code>max_len &gt; 8k</code>), a smaller DP size combined with some model-side parallelism performs better. For example, <code>(tp=2, dp=4)</code> is a good setup for 32B models with a larger context window.</li>",el,oe,ll,re,tl;return c=new T({props:{title:"vLLM Integration",local:"vllm-integration",headingTag:"h1"}}),u=new T({props:{title:"🚀 How can I use vLLM with TRL to speed up training?",local:"-how-can-i-use-vllm-with-trl-to-speed-up-training",headingTag:"h2"}}),j=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnRybCU1QnZsbG0lNUQlMjI=",highlighted:'pip install <span class="hljs-string">&quot;trl[vllm]&quot;</span>',wrap:!1}}),b=new m({props:{code:"dHJsJTIwdmxsbS1zZXJ2ZSUyMC0tbW9kZWwlMjBRd2VuJTJGUXdlbjIuNS03QiUyMC0tdGVuc29yLXBhcmFsbGVsLXNpemUlMjAyJTIwLS1kYXRhLXBhcmFsbGVsLXNpemUlMjAy",highlighted:"trl vllm-serve --model Qwen/Qwen2.5-7B --tensor-parallel-size 2 --data-parallel-size 2",wrap:!1}}),Z=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEdSUE9UcmFpbmVyJTJDJTIwR1JQT0NvbmZpZyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydHJsLWxpYiUyRnRsZHIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMER1bW15JTIwcmV3YXJkJTIwZnVuY3Rpb24lM0ElMjBjb3VudCUyMHRoZSUyMG51bWJlciUyMG9mJTIwdW5pcXVlJTIwY2hhcmFjdGVycyUyMGluJTIwdGhlJTIwY29tcGxldGlvbnMlMEFkZWYlMjByZXdhcmRfbnVtX3VuaXF1ZV9jaGFycyhjb21wbGV0aW9ucyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QmxlbihzZXQoYykpJTIwZm9yJTIwYyUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwR1JQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIybXlfdGVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV92bGxtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJmMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMEdSUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyUXdlbiUyRlF3ZW4yLjUtN0IlMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mdW5jcyUzRHJld2FyZF9udW1fdW5pcXVlX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOTrainer, GRPOConfig

dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/tldr&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Dummy reward function: count the number of unique characters in the completions</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_num_unique_chars</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(c)) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> completions]

training_args = GRPOConfig(
    output_dir=<span class="hljs-string">&quot;my_test&quot;</span>,
    use_vllm=<span class="hljs-literal">True</span>,
    bf16=<span class="hljs-literal">True</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    logging_steps=<span class="hljs-number">10</span>,
)

trainer = GRPOTrainer(
    model=<span class="hljs-string">&quot;Qwen/Qwen2.5-7B&quot;</span>,
    args=training_args,
    reward_funcs=reward_num_unique_chars,
    train_dataset=dataset,
)

trainer.train()`,wrap:!1}}),V=new m({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0Q0JTJDNSUyQzYlMkM3JTIwYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"CUDA_VISIBLE_DEVICES=4,5,6,7 accelerate launch train.py",wrap:!1}}),k=new T({props:{title:"🎬 Flashback: Why do we need to use vLLM in online methods?",local:"-flashback-why-do-we-need-to-use-vllm-in-online-methods",headingTag:"h2"}}),E=new T({props:{title:"🤔 How does vLLM solve the slow generation issue?",local:"-how-does-vllm-solve-the-slow-generation-issue",headingTag:"h2"}}),A=new T({props:{title:"🤔 What exactly happens when you run trl vllm-serve --model <model_name> ?",local:"-what-exactly-happens-when-you-run-trl-vllm-serve---model-ltmodelnamegt-",headingTag:"h2"}}),R=new m({props:{code:"dHJsJTIwdmxsbS1zZXJ2ZSUyMC0tbW9kZWwlMjBRd2VuJTJGUXdlbjIuNS03QiUyMC0tdGVuc29yLXBhcmFsbGVsLXNpemUlMjAxJTIwLS1kYXRhLXBhcmFsbGVsLXNpemUlMjA0",highlighted:"trl vllm-serve --model Qwen/Qwen2.5-7B --tensor-parallel-size 1 --data-parallel-size 4",wrap:!1}}),F=new T({props:{title:"🥸 More detail on what happens under the hood when running the server",local:"-more-detail-on-what-happens-under-the-hood-when-running-the-server",headingTag:"h2"}}),Q=new m({props:{code:"dHJsJTIwdmxsbS1zZXJ2ZSUyMC0tbW9kZWwlMjAlM0Ntb2RlbF9uYW1lJTNFJTIwLS10ZW5zb3ItcGFyYWxsZWwtc2l6ZSUyMDElMjAtLWRhdGEtcGFyYWxsZWwtc2l6ZSUyMDQ=",highlighted:"trl vllm-serve --model &lt;model_name&gt; --tensor-parallel-size 1 --data-parallel-size 4",wrap:!1}}),z=new m({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0Q0JTJDNSUyQzYlMkM3JTIwYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"CUDA_VISIBLE_DEVICES=4,5,6,7 accelerate launch train.py",wrap:!1}}),P=new T({props:{title:"🍷 More customization options with vLLM?",local:"-more-customization-options-with-vllm",headingTag:"h2"}}),D=new m({props:{code:"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",highlighted:`$ trl vllm-serve <span class="hljs-comment">--help</span>
usage: trl vllm-serve [-h] <span class="hljs-comment">--model MODEL [--revision REVISION] [--tensor_parallel_size TENSOR_PARALLEL_SIZE]</span>
                      [<span class="hljs-comment">--data_parallel_size DATA_PARALLEL_SIZE] [--host HOST] [--port PORT]</span>
                      [<span class="hljs-comment">--gpu_memory_utilization GPU_MEMORY_UTILIZATION] [--dtype DTYPE] [--max_model_len MAX_MODEL_LEN]</span>
                      [<span class="hljs-comment">--enable_prefix_caching ENABLE_PREFIX_CACHING] [--enforce_eager ENFORCE_EAGER] [--log_level LOG_LEVEL]</span>

options:
  -h, <span class="hljs-comment">--help            Show this help message and exit</span>
  <span class="hljs-comment">--model MODEL         Model name or path to load the model from. (default: None)</span>
  <span class="hljs-comment">--revision REVISION   Revision to use for the model. If not specified, the default branch will be used. (default: None)</span>
  <span class="hljs-comment">--tensor_parallel_size TENSOR_PARALLEL_SIZE, --tensor-parallel-size TENSOR_PARALLEL_SIZE</span>
                        Number <span class="hljs-keyword">of</span> tensor parallel workers <span class="hljs-keyword">to</span> <span class="hljs-keyword">use</span>. (<span class="hljs-keyword">default</span>: <span class="hljs-number">1</span>)
  <span class="hljs-comment">--data_parallel_size DATA_PARALLEL_SIZE, --data-parallel-size DATA_PARALLEL_SIZE</span>
                        Number <span class="hljs-keyword">of</span> data parallel workers <span class="hljs-keyword">to</span> <span class="hljs-keyword">use</span>. (<span class="hljs-keyword">default</span>: <span class="hljs-number">1</span>)
  <span class="hljs-comment">--host HOST           Host address to run the server on. (default: 0.0.0.0)</span>
  <span class="hljs-comment">--port PORT           Port to run the server on. (default: 8000)</span>
  <span class="hljs-comment">--gpu_memory_utilization GPU_MEMORY_UTILIZATION, --gpu-memory-utilization GPU_MEMORY_UTILIZATION</span>
                        Ratio (between <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> <span class="hljs-number">1</span>) <span class="hljs-keyword">of</span> GPU memory <span class="hljs-keyword">to</span> reserve <span class="hljs-keyword">for</span> the model weights, activations, <span class="hljs-keyword">and</span> KV cache <span class="hljs-keyword">on</span> the device
                        dedicated <span class="hljs-keyword">to</span> generation powered by vLLM. Higher values will increase the KV cache size <span class="hljs-keyword">and</span> thus improve the
                        model<span class="hljs-symbol">&#x27;s</span> throughput. However, <span class="hljs-keyword">if</span> the value <span class="hljs-keyword">is</span> too high, it may cause <span class="hljs-keyword">out</span>-<span class="hljs-keyword">of</span>-memory (OOM) errors during
                        initialization. (<span class="hljs-keyword">default</span>: <span class="hljs-number">0.9</span>)
  <span class="hljs-comment">--dtype DTYPE         Data type to use for vLLM generation. If set to &#x27;auto&#x27;, the data type will be automatically determined based on</span>
                        the model <span class="hljs-keyword">configuration</span>. Find the supported values <span class="hljs-keyword">in</span> the vLLM documentation. (<span class="hljs-keyword">default</span>: auto)
  <span class="hljs-comment">--max_model_len MAX_MODEL_LEN, --max-model-len MAX_MODEL_LEN</span>
                        <span class="hljs-keyword">If</span> set, the \`max_model_len\` <span class="hljs-keyword">to</span> <span class="hljs-keyword">use</span> <span class="hljs-keyword">for</span> vLLM. This can be useful <span class="hljs-keyword">when</span> running <span class="hljs-keyword">with</span> reduced
                        \`vllm_gpu_memory_utilization\`, leading <span class="hljs-keyword">to</span> a reduced KV cache size. <span class="hljs-keyword">If</span> <span class="hljs-keyword">not</span> set, vLLM will <span class="hljs-keyword">use</span> the model <span class="hljs-keyword">context</span>
                        size, which might be much larger than the KV cache, leading <span class="hljs-keyword">to</span> inefficiencies. (<span class="hljs-keyword">default</span>: None)
  <span class="hljs-comment">--enable_prefix_caching ENABLE_PREFIX_CACHING, --enable-prefix-caching ENABLE_PREFIX_CACHING</span>
                        Whether <span class="hljs-keyword">to</span> enable prefix caching <span class="hljs-keyword">in</span> vLLM. <span class="hljs-keyword">If</span> set <span class="hljs-keyword">to</span> \`<span class="hljs-literal">True</span>\`, ensure that the model <span class="hljs-keyword">and</span> the hardware support this
                        feature. (<span class="hljs-keyword">default</span>: None)
  <span class="hljs-comment">--enforce_eager ENFORCE_EAGER, --enforce-eager ENFORCE_EAGER</span>
                        Whether <span class="hljs-keyword">to</span> enforce eager execution. <span class="hljs-keyword">If</span> set <span class="hljs-keyword">to</span> \`<span class="hljs-literal">True</span>\`, we will disable CUDA graph <span class="hljs-keyword">and</span> always execute the model
                        <span class="hljs-keyword">in</span> eager mode. <span class="hljs-keyword">If</span> \`<span class="hljs-literal">False</span>\` (<span class="hljs-keyword">default</span> behavior), we will <span class="hljs-keyword">use</span> CUDA graph <span class="hljs-keyword">and</span> eager execution <span class="hljs-keyword">in</span> hybrid. (<span class="hljs-keyword">default</span>:
                        None)
  <span class="hljs-comment">--log_level LOG_LEVEL, --log-level LOG_LEVEL</span>
                        Log level <span class="hljs-keyword">for</span> uvicorn. Possible choices: <span class="hljs-symbol">&#x27;critical</span>&#x27;, <span class="hljs-symbol">&#x27;error</span>&#x27;, <span class="hljs-symbol">&#x27;warning</span>&#x27;, <span class="hljs-symbol">&#x27;info</span>&#x27;, <span class="hljs-symbol">&#x27;debug</span>&#x27;, <span class="hljs-symbol">&#x27;trace</span>&#x27;. (<span class="hljs-keyword">default</span>:
                        info)`,wrap:!1}}),q=new T({props:{title:"🥳 Okay, now that we have the server running, how can we use it to generate completions?",local:"-okay-now-that-we-have-the-server-running-how-can-we-use-it-to-generate-completions",headingTag:"h2"}}),ee=new m({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEdSUE9Db25maWclMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwR1JQT0NvbmZpZyguLi4lMkMlMjB1c2VfdmxsbSUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOConfig

training_args = GRPOConfig(..., use_vllm=<span class="hljs-literal">True</span>)`,wrap:!1}}),le=new T({props:{title:"💆🏻‍♀️ What’s the best distributed setup?",local:"-whats-the-best-distributed-setup",headingTag:"h2"}}),oe=new Rl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/vllm_integration.md"}}),{c(){U=i("meta"),ye=n(),Me=i("p"),pe=n(),r(c.$$.fragment),we=n(),J=i("p"),J.textContent=nl,he=n(),r(u.$$.fragment),de=n(),I=i("p"),I.innerHTML=al,Ue=n(),C=i("p"),C.textContent=il,me=n(),r(j.$$.fragment),Te=n(),f=i("p"),f.textContent=ol,ce=n(),r(b.$$.fragment),Je=n(),g=i("p"),g.innerHTML=Ml,ue=n(),v=i("p"),v.innerHTML=rl,Ie=n(),G=i("p"),G.innerHTML=yl,Ce=n(),r(Z.$$.fragment),je=n(),L=i("p"),L.textContent=pl,fe=n(),r(V.$$.fragment),be=n(),r(k.$$.fragment),ge=n(),B=i("p"),B.innerHTML=wl,ve=n(),r(E.$$.fragment),Ge=n(),S=i("p"),S.innerHTML=hl,Ze=n(),r(A.$$.fragment),Le=n(),W=i("p"),W.textContent=dl,Ve=n(),r(R.$$.fragment),ke=n(),_=i("p"),_.textContent=Ul,Be=n(),x=i("p"),x.innerHTML=ml,Ee=n(),$=i("ol"),$.innerHTML=Tl,Se=n(),r(F.$$.fragment),Ae=n(),X=i("ul"),X.innerHTML=cl,We=n(),H=i("p"),H.innerHTML=Jl,Re=n(),N=i("ul"),N.innerHTML=ul,_e=n(),r(Q.$$.fragment),xe=n(),Y=i("ul"),Y.innerHTML=Il,$e=n(),r(z.$$.fragment),Fe=n(),r(P.$$.fragment),Xe=n(),O=i("p"),O.textContent=Cl,He=n(),r(D.$$.fragment),Ne=n(),r(q.$$.fragment),Qe=n(),K=i("p"),K.innerHTML=jl,Ye=n(),r(ee.$$.fragment),ze=n(),r(le.$$.fragment),Pe=n(),te=i("p"),te.innerHTML=fl,Oe=n(),se=i("p"),se.textContent=bl,De=n(),ne=i("ul"),ne.innerHTML=gl,qe=n(),ae=i("p"),ae.textContent=vl,Ke=n(),ie=i("ul"),ie.innerHTML=Gl,el=n(),r(oe.$$.fragment),ll=n(),re=i("p"),this.h()},l(e){const l=Al("svelte-u9bgzb",document.head);U=o(l,"META",{name:!0,content:!0}),l.forEach(t),ye=a(e),Me=o(e,"P",{}),Zl(Me).forEach(t),pe=a(e),y(c.$$.fragment,e),we=a(e),J=o(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-8htx9o"&&(J.textContent=nl),he=a(e),y(u.$$.fragment,e),de=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-chqfxa"&&(I.innerHTML=al),Ue=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-dqsh1"&&(C.textContent=il),me=a(e),y(j.$$.fragment,e),Te=a(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-v8af46"&&(f.textContent=ol),ce=a(e),y(b.$$.fragment,e),Je=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1dcyr4s"&&(g.innerHTML=Ml),ue=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1bflh17"&&(v.innerHTML=rl),Ie=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1ui7abz"&&(G.innerHTML=yl),Ce=a(e),y(Z.$$.fragment,e),je=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-rr08fb"&&(L.textContent=pl),fe=a(e),y(V.$$.fragment,e),be=a(e),y(k.$$.fragment,e),ge=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1falafi"&&(B.innerHTML=wl),ve=a(e),y(E.$$.fragment,e),Ge=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1mphyvc"&&(S.innerHTML=hl),Ze=a(e),y(A.$$.fragment,e),Le=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1m36fdl"&&(W.textContent=dl),Ve=a(e),y(R.$$.fragment,e),ke=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1n09rjr"&&(_.textContent=Ul),Be=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1w0arxe"&&(x.innerHTML=ml),Ee=a(e),$=o(e,"OL",{"data-svelte-h":!0}),M($)!=="svelte-5de99j"&&($.innerHTML=Tl),Se=a(e),y(F.$$.fragment,e),Ae=a(e),X=o(e,"UL",{"data-svelte-h":!0}),M(X)!=="svelte-1crxfh2"&&(X.innerHTML=cl),We=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-10q4jgt"&&(H.innerHTML=Jl),Re=a(e),N=o(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-1uprqyn"&&(N.innerHTML=ul),_e=a(e),y(Q.$$.fragment,e),xe=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),M(Y)!=="svelte-1peesjh"&&(Y.innerHTML=Il),$e=a(e),y(z.$$.fragment,e),Fe=a(e),y(P.$$.fragment,e),Xe=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1vcl05h"&&(O.textContent=Cl),He=a(e),y(D.$$.fragment,e),Ne=a(e),y(q.$$.fragment,e),Qe=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-lqjls6"&&(K.innerHTML=jl),Ye=a(e),y(ee.$$.fragment,e),ze=a(e),y(le.$$.fragment,e),Pe=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-6ulixu"&&(te.innerHTML=fl),Oe=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-hlfj7p"&&(se.textContent=bl),De=a(e),ne=o(e,"UL",{"data-svelte-h":!0}),M(ne)!=="svelte-5t33fk"&&(ne.innerHTML=gl),qe=a(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-p7cqkp"&&(ae.textContent=vl),Ke=a(e),ie=o(e,"UL",{"data-svelte-h":!0}),M(ie)!=="svelte-1t8q0p1"&&(ie.innerHTML=Gl),el=a(e),y(oe.$$.fragment,e),ll=a(e),re=o(e,"P",{}),Zl(re).forEach(t),this.h()},h(){Ll(U,"name","hf:doc:metadata"),Ll(U,"content",xl)},m(e,l){Wl(document.head,U),s(e,ye,l),s(e,Me,l),s(e,pe,l),p(c,e,l),s(e,we,l),s(e,J,l),s(e,he,l),p(u,e,l),s(e,de,l),s(e,I,l),s(e,Ue,l),s(e,C,l),s(e,me,l),p(j,e,l),s(e,Te,l),s(e,f,l),s(e,ce,l),p(b,e,l),s(e,Je,l),s(e,g,l),s(e,ue,l),s(e,v,l),s(e,Ie,l),s(e,G,l),s(e,Ce,l),p(Z,e,l),s(e,je,l),s(e,L,l),s(e,fe,l),p(V,e,l),s(e,be,l),p(k,e,l),s(e,ge,l),s(e,B,l),s(e,ve,l),p(E,e,l),s(e,Ge,l),s(e,S,l),s(e,Ze,l),p(A,e,l),s(e,Le,l),s(e,W,l),s(e,Ve,l),p(R,e,l),s(e,ke,l),s(e,_,l),s(e,Be,l),s(e,x,l),s(e,Ee,l),s(e,$,l),s(e,Se,l),p(F,e,l),s(e,Ae,l),s(e,X,l),s(e,We,l),s(e,H,l),s(e,Re,l),s(e,N,l),s(e,_e,l),p(Q,e,l),s(e,xe,l),s(e,Y,l),s(e,$e,l),p(z,e,l),s(e,Fe,l),p(P,e,l),s(e,Xe,l),s(e,O,l),s(e,He,l),p(D,e,l),s(e,Ne,l),p(q,e,l),s(e,Qe,l),s(e,K,l),s(e,Ye,l),p(ee,e,l),s(e,ze,l),p(le,e,l),s(e,Pe,l),s(e,te,l),s(e,Oe,l),s(e,se,l),s(e,De,l),s(e,ne,l),s(e,qe,l),s(e,ae,l),s(e,Ke,l),s(e,ie,l),s(e,el,l),p(oe,e,l),s(e,ll,l),s(e,re,l),tl=!0},p:kl,i(e){tl||(w(c.$$.fragment,e),w(u.$$.fragment,e),w(j.$$.fragment,e),w(b.$$.fragment,e),w(Z.$$.fragment,e),w(V.$$.fragment,e),w(k.$$.fragment,e),w(E.$$.fragment,e),w(A.$$.fragment,e),w(R.$$.fragment,e),w(F.$$.fragment,e),w(Q.$$.fragment,e),w(z.$$.fragment,e),w(P.$$.fragment,e),w(D.$$.fragment,e),w(q.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(oe.$$.fragment,e),tl=!0)},o(e){h(c.$$.fragment,e),h(u.$$.fragment,e),h(j.$$.fragment,e),h(b.$$.fragment,e),h(Z.$$.fragment,e),h(V.$$.fragment,e),h(k.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(R.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(z.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(q.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),tl=!1},d(e){e&&(t(ye),t(Me),t(pe),t(we),t(J),t(he),t(de),t(I),t(Ue),t(C),t(me),t(Te),t(f),t(ce),t(Je),t(g),t(ue),t(v),t(Ie),t(G),t(Ce),t(je),t(L),t(fe),t(be),t(ge),t(B),t(ve),t(Ge),t(S),t(Ze),t(Le),t(W),t(Ve),t(ke),t(_),t(Be),t(x),t(Ee),t($),t(Se),t(Ae),t(X),t(We),t(H),t(Re),t(N),t(_e),t(xe),t(Y),t($e),t(Fe),t(Xe),t(O),t(He),t(Ne),t(Qe),t(K),t(Ye),t(ze),t(Pe),t(te),t(Oe),t(se),t(De),t(ne),t(qe),t(ae),t(Ke),t(ie),t(el),t(ll),t(re)),t(U),d(c,e),d(u,e),d(j,e),d(b,e),d(Z,e),d(V,e),d(k,e),d(E,e),d(A,e),d(R,e),d(F,e),d(Q,e),d(z,e),d(P,e),d(D,e),d(q,e),d(ee,e),d(le,e),d(oe,e)}}}const xl='{"title":"vLLM Integration","local":"vllm-integration","sections":[{"title":"🚀 How can I use vLLM with TRL to speed up training?","local":"-how-can-i-use-vllm-with-trl-to-speed-up-training","sections":[],"depth":2},{"title":"🎬 Flashback: Why do we need to use vLLM in online methods?","local":"-flashback-why-do-we-need-to-use-vllm-in-online-methods","sections":[],"depth":2},{"title":"🤔 How does vLLM solve the slow generation issue?","local":"-how-does-vllm-solve-the-slow-generation-issue","sections":[],"depth":2},{"title":"🤔 What exactly happens when you run trl vllm-serve --model &lt;model_name&gt; ?","local":"-what-exactly-happens-when-you-run-trl-vllm-serve---model-ltmodelnamegt-","sections":[],"depth":2},{"title":"🥸 More detail on what happens under the hood when running the server","local":"-more-detail-on-what-happens-under-the-hood-when-running-the-server","sections":[],"depth":2},{"title":"🍷 More customization options with vLLM?","local":"-more-customization-options-with-vllm","sections":[],"depth":2},{"title":"🥳 Okay, now that we have the server running, how can we use it to generate completions?","local":"-okay-now-that-we-have-the-server-running-how-can-we-use-it-to-generate-completions","sections":[],"depth":2},{"title":"💆🏻‍♀️ What’s the best distributed setup?","local":"-whats-the-best-distributed-setup","sections":[],"depth":2}],"depth":1}';function $l(sl){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ql extends El{constructor(U){super(),Sl(this,U,$l,_l,Vl,{})}}export{Ql as component};
