import{s as Pt,n as Kt,o as Ot}from"../chunks/scheduler.53228c21.js";import{S as es,i as ts,e as n,s as i,c as o,h as ss,a as p,d as s,b as a,f as At,g as c,j as r,k as f,l as ls,m as l,n as u,t as m,o as d,p as h}from"../chunks/index.100fac89.js";import{C as is}from"../chunks/CopyLLMTxtMenu.9360b11d.js";import{C as Z}from"../chunks/CodeBlock.d30a6509.js";import{D as as}from"../chunks/DocNotebookDropdown.1a28089c.js";import{H as T,E as ns}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c9001d7a.js";function ps(gt){let M,ge,Me,we,I,Je,B,ye,G,be,x,wt="A scheduler is an algorithm that provides instructions to the denoising process such as how much noise to remove at a certain step. It takes the model prediction from step <em>t</em> and applies an update for how to compute the next sample at step <em>t-1</em>. Different schedulers produce different results; some are faster while others are more accurate.",Ue,$,Jt="Diffusers supports many schedulers and allows you to modify their timestep schedules, timestep spacing, and more, to generate high-quality images in fewer steps.",je,W,yt="This guide will show you how to load and customize schedulers.",ve,E,Ze,C,bt="Schedulers don’t have any parameters and are defined in a configuration file. Access the <code>.scheduler</code> attribute of a pipeline to view the configuration.",Ie,V,Be,S,Ut='Load a different scheduler with <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> and specify the <code>subfolder</code> argument to load the configuration file into the correct subfolder of the pipeline repository. Pass the new scheduler to the existing pipeline.',Ge,k,xe,_,$e,H,jt="Timestep or noise schedule decides how noise is distributed over the denoising process. The schedule can be linear or more concentrated toward the beginning or end. It is a precomputed sequence of noise levels generated from the scheduler’s default configuration, but it can be customized to use other schedules.",We,g,vt="<p>The <code>timesteps</code> argument is only supported for a select list of schedulers and pipelines. Feel free to open a feature request if you want to extend these parameters to a scheduler and pipeline that does not currently support it!</p>",Ee,N,Zt='The example below uses the <a href="https://research.nvidia.com/labs/toronto-ai/AlignYourSteps/" rel="nofollow">Align Your Steps (AYS)</a> schedule which can generate a high-quality image in 10 steps, significantly speeding up generation and reducing computation time.',Ce,R,It="Import the schedule and pass it to the <code>timesteps</code> argument in the pipeline.",Ve,X,Se,w,Bt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ays.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">AYS timestep schedule 10 steps</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/10.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Linearly-spaced timestep schedule 10 steps</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/25.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Linearly-spaced timestep schedule 25 steps</figcaption></div>',ke,L,_e,Y,Gt="Denoising should begin with pure noise and the signal-to-noise (SNR) ration should be zero. However, some models don’t actually start from pure noise which makes it difficult to generate images at brightness extremes.",He,J,xt='<p>Train your own model with <code>v_prediction</code> by adding the <code>--prediction_type=&quot;v_prediction&quot;</code> flag to your training script. You can also <a href="https://huggingface.co/search/full-text?q=v_prediction&amp;type=model" rel="nofollow">search</a> for existing models trained with <code>v_prediction</code>.</p>',Ne,q,$t="To fix this, a model must be trained with <code>v_prediction</code>. If a model is trained with <code>v_prediction</code>, then enable the following arguments in the scheduler.",Re,z,Wt="<li>Set <code>rescale_betas_zero_snr=True</code> to rescale the noise schedule to the very last timestep with exactly zero SNR</li> <li>Set <code>timestep_spacing=&quot;trailing&quot;</code> to force sampling from the last timestep with pure noise</li>",Xe,D,Le,Q,Et="Set <code>guidance_rescale</code> in the pipeline to avoid overexposed images. A lower value increases brightness, but some details may appear washed out.",Ye,F,qe,y,Ct='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/no-zero-snr.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">default Stable Diffusion v2-1 image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/zero-snr.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image with zero SNR and trailing timestep spacing enabled</figcaption></div>',ze,A,De,P,Vt="Timestep spacing refers to the specific steps <em>t</em> to sample from from the schedule. Diffusers provides three spacing types as shown below.",Qe,K,St="<thead><tr><th>spacing strategy</th> <th>spacing calculation</th> <th>example timesteps</th></tr></thead> <tbody><tr><td><code>leading</code></td> <td>evenly spaced steps</td> <td><code>[900, 800, 700, ..., 100, 0]</code></td></tr> <tr><td><code>linspace</code></td> <td>include first and last steps and evenly divide remaining intermediate steps</td> <td><code>[1000, 888.89, 777.78, ..., 111.11, 0]</code></td></tr> <tr><td><code>trailing</code></td> <td>include last step and evenly divide remaining intermediate steps beginning from the end</td> <td><code>[999, 899, 799, 699, 599, 499, 399, 299, 199, 99]</code></td></tr></tbody>",Fe,O,kt="Pass the spacing strategy to the <code>timestep_spacing</code> argument in the scheduler.",Ae,b,_t="<p>The <code>trailing</code> strategy typically produces higher quality images with more details with fewer steps, but the difference in quality is not as obvious for more standard step values.</p>",Pe,ee,Ke,U,Ht='<div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/trailing_spacing.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">trailing spacing after 5 steps</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/leading_spacing.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">leading spacing after 5 steps</figcaption></div>',Oe,te,et,se,Nt="Sigmas is a measure of how noisy a sample is at a certain step as defined by the schedule. When using custom <code>sigmas</code>, the <code>timesteps</code> are calculated from these values instead of the default scheduler configuration.",tt,j,Rt="<p>The <code>sigmas</code> argument is only supported for a select list of schedulers and pipelines. Feel free to open a feature request if you want to extend these parameters to a scheduler and pipeline that does not currently support it!</p>",st,le,Xt='Pass the custom sigmas to the <code>sigmas</code> argument in the pipeline. The example below uses the <a href="https://github.com/huggingface/diffusers/blob/6529ee67ec02fcf58d2fd9242164ea002b351d75/src/diffusers/schedulers/scheduling_utils.py#L55" rel="nofollow">sigmas</a> from the 10-step AYS schedule.',lt,ie,it,ae,at,ne,Lt='<a href="https://huggingface.co/papers/2206.00364" rel="nofollow">Karras sigmas</a> resamples the noise schedule for more efficient sampling by clustering sigmas more densely in the middle of the sequence where structure reconstruction is critical, while using fewer sigmas at the beginning and end where noise changes have less impact. This can increase the level of details in a generated image.',nt,pe,Yt="Set <code>use_karras_sigmas=True</code> in the scheduler to enable it.",pt,re,rt,v,qt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/karras_sigmas_true.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Karras sigmas enabled</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/karras_sigmas_false.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Karras sigmas disabled</figcaption></div>',ot,oe,zt='Refer to the scheduler API <a href="../api/schedulers/overview">overview</a> for a list of schedulers that support Karras sigmas. It should only be used for models trained with Karras sigmas.',ct,ce,ut,ue,Dt="It’s important to try different schedulers to find the best one for your use case. Here are a few recommendations to help you get started.",mt,me,Qt='<li>DPM++ 2M SDE Karras is generally a good all-purpose option.</li> <li><a href="/docs/diffusers/main/en/api/schedulers/tcd#diffusers.TCDScheduler">TCDScheduler</a> works well for distilled models.</li> <li><a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a> and <a href="/docs/diffusers/main/en/api/schedulers/flow_match_heun_discrete#diffusers.FlowMatchHeunDiscreteScheduler">FlowMatchHeunDiscreteScheduler</a> for FlowMatch models.</li> <li><a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a> for generating anime style images.</li> <li>DPM++ 2M paired with <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> on SDXL for generating realistic images.</li>',dt,de,ht,he,Ft='<li>Read the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a> paper for more details about rescaling the noise schedule to enforce zero SNR.</li>',ft,fe,Mt,Te,Tt;return I=new as({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"}]}}),B=new is({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),G=new T({props:{title:"Schedulers",local:"schedulers",headingTag:"h1"}}),E=new T({props:{title:"Loading schedulers",local:"loading-schedulers",headingTag:"h2"}}),V=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXI=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler`,wrap:!1}}),k=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRGRwbSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKSUwQXBpcGVsaW5lLnNjaGVkdWxlcg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

dpm = DPMSolverMultistepScheduler.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    scheduler=dpm,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler`,wrap:!1}}),_=new T({props:{title:"Timestep schedules",local:"timestep-schedules",headingTag:"h2"}}),X=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMlMjBpbXBvcnQlMjBBeXNTY2hlZHVsZXMlMEElMEFzYW1wbGluZ19zY2hlZHVsZSUyMCUzRCUyMEF5c1NjaGVkdWxlcyU1QiUyMlN0YWJsZURpZmZ1c2lvblhMVGltZXN0ZXBzJTIyJTVEJTBBcHJpbnQoc2FtcGxpbmdfc2NoZWR1bGUpJTBBJTIyJTVCOTk5JTJDJTIwODQ1JTJDJTIwNzMwJTJDJTIwNTg3JTJDJTIwNDQzJTJDJTIwMzEwJTJDJTIwMTkzJTJDJTIwMTE2JTJDJTIwNTMlMkMlMjAxMyU1RCUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlNHMTYxMjIyJTJGUmVhbFZpc1hMX1Y0LjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcoJTBBJTIwJTIwcGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMGFsZ29yaXRobV90eXBlJTNEJTIyc2RlLWRwbXNvbHZlciUyQiUyQiUyMiUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2luZW1hdGljJTIwc2hvdCUyMG9mJTIwYSUyMGN1dGUlMjBsaXR0bGUlMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMGphY2tldCUyMGFuZCUyMGRvaW5nJTIwYSUyMHRodW1icyUyMHVwJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcHMlM0RzYW1wbGluZ19zY2hlZHVsZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.schedulers <span class="hljs-keyword">import</span> AysSchedules

sampling_schedule = AysSchedules[<span class="hljs-string">&quot;StableDiffusionXLTimesteps&quot;</span>]
<span class="hljs-built_in">print</span>(sampling_schedule)
<span class="hljs-string">&quot;[999, 845, 730, 587, 443, 310, 193, 116, 53, 13]&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config, algorithm_type=<span class="hljs-string">&quot;sde-dpmsolver++&quot;</span>
)

prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little rabbit wearing a jacket and doing a thumbs up&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    timesteps=sampling_schedule,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new T({props:{title:"Rescaling schedules",local:"rescaling-schedules",headingTag:"h3"}}),D=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnB0eDAlMkZwc2V1ZG8tam91cm5leS12MiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9jb25maWcoJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMHJlc2NhbGVfYmV0YXNfemVyb19zbnIlM0RUcnVlJTJDJTIwdGltZXN0ZXBfc3BhY2luZyUzRCUyMnRyYWlsaW5nJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DDIMScheduler

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;ptx0/pseudo-journey-v2&quot;</span>, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.scheduler = DDIMScheduler.from_config(
    pipeline.scheduler.config, rescale_betas_zero_snr=<span class="hljs-literal">True</span>, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>
)`,wrap:!1}}),F=new Z({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwcGhvdG8lMjBvZiUyMGElMjBzbm93eSUyMG1vdW50YWluJTIwYXQlMjBuaWdodCUyMHdpdGglMjB0aGUlMjBub3J0aGVybiUyMGxpZ2h0cyUyMGF1cm9yYSUyMGJvcmVhbGlzJTBBb3ZlcmhlYWQlMkMlMjAzNW1tJTIwcGhvdG9ncmFwaCUyQyUyMGZpbG0lMkMlMjBwcm9mZXNzaW9uYWwlMkMlMjA0ayUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTBBJTIyJTIyJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBndWlkYW5jZV9yZXNjYWxlJTNEMC43KS5pbWFnZXMlNUIwJTVE",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic photo of a snowy mountain at night with the northern lights aurora borealis
overhead, 35mm photograph, film, professional, 4k, highly detailed
&quot;&quot;&quot;</span>
image = pipeline(prompt, guidance_rescale=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new T({props:{title:"Timestep spacing",local:"timestep-spacing",headingTag:"h2"}}),ee=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxWaXNYTF9WNC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKCUwQSUyMCUyMHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIydHJhaWxpbmclMjIlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMHNob3QlMjBvZiUyMGElMjBjdXRlJTIwbGl0dGxlJTIwYmxhY2slMjBjYXQlMjBzaXR0aW5nJTIwb24lMjBhJTIwcHVtcGtpbiUyMGF0JTIwbmlnaHQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>
)

prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little black cat sitting on a pumpkin at night&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">5</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),te=new T({props:{title:"Sigmas",local:"sigmas",headingTag:"h2"}}),ie=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxWaXNYTF9WNC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKCUwQSUyMCUyMHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjBhbGdvcml0aG1fdHlwZSUzRCUyMnNkZS1kcG1zb2x2ZXIlMkIlMkIlMjIlMEEpJTBBJTBBc2lnbWFzJTIwJTNEJTIwJTVCMTQuNjE1JTJDJTIwNi4zMTUlMkMlMjAzLjc3MSUyQyUyMDIuMTgxJTJDJTIwMS4zNDIlMkMlMjAwLjg2MiUyQyUyMDAuNTU1JTJDJTIwMC4zODAlMkMlMjAwLjIzNCUyQyUyMDAuMTEzJTJDJTIwMC4wJTVEJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMHNob3QlMjBvZiUyMGElMjBjdXRlJTIwbGl0dGxlJTIwcmFiYml0JTIwd2VhcmluZyUyMGElMjBqYWNrZXQlMjBhbmQlMjBkb2luZyUyMGElMjB0aHVtYnMlMjB1cCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2lnbWFzJTNEc2lnbWFzJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config, algorithm_type=<span class="hljs-string">&quot;sde-dpmsolver++&quot;</span>
)

sigmas = [<span class="hljs-number">14.615</span>, <span class="hljs-number">6.315</span>, <span class="hljs-number">3.771</span>, <span class="hljs-number">2.181</span>, <span class="hljs-number">1.342</span>, <span class="hljs-number">0.862</span>, <span class="hljs-number">0.555</span>, <span class="hljs-number">0.380</span>, <span class="hljs-number">0.234</span>, <span class="hljs-number">0.113</span>, <span class="hljs-number">0.0</span>]
prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little rabbit wearing a jacket and doing a thumbs up&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    sigmas=sigmas,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ae=new T({props:{title:"Karras sigmas",local:"karras-sigmas",headingTag:"h3"}}),re=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxWaXNYTF9WNC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKCUwQSUyMCUyMHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMEElMjAlMjBhbGdvcml0aG1fdHlwZSUzRCUyMnNkZS1kcG1zb2x2ZXIlMkIlMkIlMjIlMkMlMEElMjAlMjB1c2Vfa2FycmFzX3NpZ21hcyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMHNob3QlMjBvZiUyMGElMjBjdXRlJTIwbGl0dGxlJTIwcmFiYml0JTIwd2VhcmluZyUyMGElMjBqYWNrZXQlMjBhbmQlMjBkb2luZyUyMGElMjB0aHVtYnMlMjB1cCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2lnbWFzJTNEc2lnbWFzJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config,
  algorithm_type=<span class="hljs-string">&quot;sde-dpmsolver++&quot;</span>,
  use_karras_sigmas=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little rabbit wearing a jacket and doing a thumbs up&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    sigmas=sigmas,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ce=new T({props:{title:"Choosing a scheduler",local:"choosing-a-scheduler",headingTag:"h2"}}),de=new T({props:{title:"Resources",local:"resources",headingTag:"h2"}}),fe=new ns({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/schedulers.md"}}),{c(){M=n("meta"),ge=i(),Me=n("p"),we=i(),o(I.$$.fragment),Je=i(),o(B.$$.fragment),ye=i(),o(G.$$.fragment),be=i(),x=n("p"),x.innerHTML=wt,Ue=i(),$=n("p"),$.textContent=Jt,je=i(),W=n("p"),W.textContent=yt,ve=i(),o(E.$$.fragment),Ze=i(),C=n("p"),C.innerHTML=bt,Ie=i(),o(V.$$.fragment),Be=i(),S=n("p"),S.innerHTML=Ut,Ge=i(),o(k.$$.fragment),xe=i(),o(_.$$.fragment),$e=i(),H=n("p"),H.textContent=jt,We=i(),g=n("blockquote"),g.innerHTML=vt,Ee=i(),N=n("p"),N.innerHTML=Zt,Ce=i(),R=n("p"),R.innerHTML=It,Ve=i(),o(X.$$.fragment),Se=i(),w=n("div"),w.innerHTML=Bt,ke=i(),o(L.$$.fragment),_e=i(),Y=n("p"),Y.textContent=Gt,He=i(),J=n("blockquote"),J.innerHTML=xt,Ne=i(),q=n("p"),q.innerHTML=$t,Re=i(),z=n("ul"),z.innerHTML=Wt,Xe=i(),o(D.$$.fragment),Le=i(),Q=n("p"),Q.innerHTML=Et,Ye=i(),o(F.$$.fragment),qe=i(),y=n("div"),y.innerHTML=Ct,ze=i(),o(A.$$.fragment),De=i(),P=n("p"),P.innerHTML=Vt,Qe=i(),K=n("table"),K.innerHTML=St,Fe=i(),O=n("p"),O.innerHTML=kt,Ae=i(),b=n("blockquote"),b.innerHTML=_t,Pe=i(),o(ee.$$.fragment),Ke=i(),U=n("div"),U.innerHTML=Ht,Oe=i(),o(te.$$.fragment),et=i(),se=n("p"),se.innerHTML=Nt,tt=i(),j=n("blockquote"),j.innerHTML=Rt,st=i(),le=n("p"),le.innerHTML=Xt,lt=i(),o(ie.$$.fragment),it=i(),o(ae.$$.fragment),at=i(),ne=n("p"),ne.innerHTML=Lt,nt=i(),pe=n("p"),pe.innerHTML=Yt,pt=i(),o(re.$$.fragment),rt=i(),v=n("div"),v.innerHTML=qt,ot=i(),oe=n("p"),oe.innerHTML=zt,ct=i(),o(ce.$$.fragment),ut=i(),ue=n("p"),ue.textContent=Dt,mt=i(),me=n("ul"),me.innerHTML=Qt,dt=i(),o(de.$$.fragment),ht=i(),he=n("ul"),he.innerHTML=Ft,ft=i(),o(fe.$$.fragment),Mt=i(),Te=n("p"),this.h()},l(e){const t=ss("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(s),ge=a(e),Me=p(e,"P",{}),At(Me).forEach(s),we=a(e),c(I.$$.fragment,e),Je=a(e),c(B.$$.fragment,e),ye=a(e),c(G.$$.fragment,e),be=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-102wtk8"&&(x.innerHTML=wt),Ue=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-7gdk9f"&&($.textContent=Jt),je=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-n44qmz"&&(W.textContent=yt),ve=a(e),c(E.$$.fragment,e),Ze=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-thfjbi"&&(C.innerHTML=bt),Ie=a(e),c(V.$$.fragment,e),Be=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-7upath"&&(S.innerHTML=Ut),Ge=a(e),c(k.$$.fragment,e),xe=a(e),c(_.$$.fragment,e),$e=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-41eu0f"&&(H.textContent=jt),We=a(e),g=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-fdqszo"&&(g.innerHTML=vt),Ee=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ohacqg"&&(N.innerHTML=Zt),Ce=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-rm6bho"&&(R.innerHTML=It),Ve=a(e),c(X.$$.fragment,e),Se=a(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wwk2vr"&&(w.innerHTML=Bt),ke=a(e),c(L.$$.fragment,e),_e=a(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qyan8p"&&(Y.textContent=Gt),He=a(e),J=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1ytgrjg"&&(J.innerHTML=xt),Ne=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-u69ydw"&&(q.innerHTML=$t),Re=a(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-4v39hu"&&(z.innerHTML=Wt),Xe=a(e),c(D.$$.fragment,e),Le=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-bj3sil"&&(Q.innerHTML=Et),Ye=a(e),c(F.$$.fragment,e),qe=a(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-2pxhst"&&(y.innerHTML=Ct),ze=a(e),c(A.$$.fragment,e),De=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-p812a3"&&(P.innerHTML=Vt),Qe=a(e),K=p(e,"TABLE",{"data-svelte-h":!0}),r(K)!=="svelte-1e67q19"&&(K.innerHTML=St),Fe=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-d1j5xm"&&(O.innerHTML=kt),Ae=a(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-15bsxi3"&&(b.innerHTML=_t),Pe=a(e),c(ee.$$.fragment,e),Ke=a(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-106qvjp"&&(U.innerHTML=Ht),Oe=a(e),c(te.$$.fragment,e),et=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-10a435k"&&(se.innerHTML=Nt),tt=a(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-118exvu"&&(j.innerHTML=Rt),st=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-x20l5u"&&(le.innerHTML=Xt),lt=a(e),c(ie.$$.fragment,e),it=a(e),c(ae.$$.fragment,e),at=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-3ub125"&&(ne.innerHTML=Lt),nt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-10otcr1"&&(pe.innerHTML=Yt),pt=a(e),c(re.$$.fragment,e),rt=a(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-gruv4r"&&(v.innerHTML=qt),ot=a(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1livq9e"&&(oe.innerHTML=zt),ct=a(e),c(ce.$$.fragment,e),ut=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1gtdusx"&&(ue.textContent=Dt),mt=a(e),me=p(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-r7qw4m"&&(me.innerHTML=Qt),dt=a(e),c(de.$$.fragment,e),ht=a(e),he=p(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-t1vvcd"&&(he.innerHTML=Ft),ft=a(e),c(fe.$$.fragment,e),Mt=a(e),Te=p(e,"P",{}),At(Te).forEach(s),this.h()},h(){f(M,"name","hf:doc:metadata"),f(M,"content",rs),f(g,"class","tip"),f(w,"class","flex gap-4"),f(J,"class","tip"),f(y,"class","flex gap-4"),f(b,"class","tip"),f(U,"class","flex gap-4"),f(j,"class","tip"),f(v,"class","flex gap-4")},m(e,t){ls(document.head,M),l(e,ge,t),l(e,Me,t),l(e,we,t),u(I,e,t),l(e,Je,t),u(B,e,t),l(e,ye,t),u(G,e,t),l(e,be,t),l(e,x,t),l(e,Ue,t),l(e,$,t),l(e,je,t),l(e,W,t),l(e,ve,t),u(E,e,t),l(e,Ze,t),l(e,C,t),l(e,Ie,t),u(V,e,t),l(e,Be,t),l(e,S,t),l(e,Ge,t),u(k,e,t),l(e,xe,t),u(_,e,t),l(e,$e,t),l(e,H,t),l(e,We,t),l(e,g,t),l(e,Ee,t),l(e,N,t),l(e,Ce,t),l(e,R,t),l(e,Ve,t),u(X,e,t),l(e,Se,t),l(e,w,t),l(e,ke,t),u(L,e,t),l(e,_e,t),l(e,Y,t),l(e,He,t),l(e,J,t),l(e,Ne,t),l(e,q,t),l(e,Re,t),l(e,z,t),l(e,Xe,t),u(D,e,t),l(e,Le,t),l(e,Q,t),l(e,Ye,t),u(F,e,t),l(e,qe,t),l(e,y,t),l(e,ze,t),u(A,e,t),l(e,De,t),l(e,P,t),l(e,Qe,t),l(e,K,t),l(e,Fe,t),l(e,O,t),l(e,Ae,t),l(e,b,t),l(e,Pe,t),u(ee,e,t),l(e,Ke,t),l(e,U,t),l(e,Oe,t),u(te,e,t),l(e,et,t),l(e,se,t),l(e,tt,t),l(e,j,t),l(e,st,t),l(e,le,t),l(e,lt,t),u(ie,e,t),l(e,it,t),u(ae,e,t),l(e,at,t),l(e,ne,t),l(e,nt,t),l(e,pe,t),l(e,pt,t),u(re,e,t),l(e,rt,t),l(e,v,t),l(e,ot,t),l(e,oe,t),l(e,ct,t),u(ce,e,t),l(e,ut,t),l(e,ue,t),l(e,mt,t),l(e,me,t),l(e,dt,t),u(de,e,t),l(e,ht,t),l(e,he,t),l(e,ft,t),u(fe,e,t),l(e,Mt,t),l(e,Te,t),Tt=!0},p:Kt,i(e){Tt||(m(I.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(E.$$.fragment,e),m(V.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(F.$$.fragment,e),m(A.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(fe.$$.fragment,e),Tt=!0)},o(e){d(I.$$.fragment,e),d(B.$$.fragment,e),d(G.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(fe.$$.fragment,e),Tt=!1},d(e){e&&(s(ge),s(Me),s(we),s(Je),s(ye),s(be),s(x),s(Ue),s($),s(je),s(W),s(ve),s(Ze),s(C),s(Ie),s(Be),s(S),s(Ge),s(xe),s($e),s(H),s(We),s(g),s(Ee),s(N),s(Ce),s(R),s(Ve),s(Se),s(w),s(ke),s(_e),s(Y),s(He),s(J),s(Ne),s(q),s(Re),s(z),s(Xe),s(Le),s(Q),s(Ye),s(qe),s(y),s(ze),s(De),s(P),s(Qe),s(K),s(Fe),s(O),s(Ae),s(b),s(Pe),s(Ke),s(U),s(Oe),s(et),s(se),s(tt),s(j),s(st),s(le),s(lt),s(it),s(at),s(ne),s(nt),s(pe),s(pt),s(rt),s(v),s(ot),s(oe),s(ct),s(ut),s(ue),s(mt),s(me),s(dt),s(ht),s(he),s(ft),s(Mt),s(Te)),s(M),h(I,e),h(B,e),h(G,e),h(E,e),h(V,e),h(k,e),h(_,e),h(X,e),h(L,e),h(D,e),h(F,e),h(A,e),h(ee,e),h(te,e),h(ie,e),h(ae,e),h(re,e),h(ce,e),h(de,e),h(fe,e)}}}const rs='{"title":"Schedulers","local":"schedulers","sections":[{"title":"Loading schedulers","local":"loading-schedulers","sections":[],"depth":2},{"title":"Timestep schedules","local":"timestep-schedules","sections":[{"title":"Rescaling schedules","local":"rescaling-schedules","sections":[],"depth":3}],"depth":2},{"title":"Timestep spacing","local":"timestep-spacing","sections":[],"depth":2},{"title":"Sigmas","local":"sigmas","sections":[{"title":"Karras sigmas","local":"karras-sigmas","sections":[],"depth":3}],"depth":2},{"title":"Choosing a scheduler","local":"choosing-a-scheduler","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function os(gt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends es{constructor(M){super(),ts(this,M,os,ps,Pt,{})}}export{Ms as component};
