import{s as Ie,n as Be,o as Ye}from"../chunks/scheduler.53228c21.js";import{S as Se,i as Ee,e as i,s as n,c as p,h as ze,a as o,d as l,b as a,f as Ce,g as r,j as m,k as Je,l as Fe,m as s,n as d,t as c,o as u,p as f}from"../chunks/index.100fac89.js";import{C as Ne}from"../chunks/CopyLLMTxtMenu.9360b11d.js";import{C as F}from"../chunks/CodeBlock.d30a6509.js";import{D as De}from"../chunks/DocNotebookDropdown.1a28089c.js";import{H as Te,E as Le}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c9001d7a.js";function He(we){let h,N,E,D,b,L,M,H,Z,O,T,ye='<a href="https://huggingface.co/papers/2311.15127" rel="nofollow">Stable Video Diffusion (SVD)</a> is a powerful image-to-video generation model that can generate 2-4 second high resolution (576x1024) videos conditioned on an input image.',q,J,Ue="This guide will show you how to use SVD to generate short videos from images.",P,w,ve="Before you begin, make sure you have the following libraries installed:",A,y,K,U,je='The are two variants of this model, <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a> and <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a>. The SVD checkpoint is trained to generate 14 frames and the SVD-XT checkpoint is further finetuned to generate 25 frames.',ee,v,ke="You’ll use the SVD-XT checkpoint for this guide.",te,j,le,g,We='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;source image of a rocket&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;generated video from source image&quot;</figcaption></div>',se,k,ne,W,_e='You can gain a 20-25% speedup at the expense of slightly increased memory by <a href="../optimization/fp16#torchcompile">compiling</a> the UNet.',ae,_,ie,$,oe,Q,$e="Video generation is very memory intensive because you’re essentially generating <code>num_frames</code> all at once, similar to text-to-image generation with a high batch size. To reduce the memory requirement, there are multiple options that trade-off inference speed for lower memory requirement:",me,V,Qe="<li>enable model offloading: each component of the pipeline is offloaded to the CPU once it’s not needed anymore.</li> <li>enable feed-forward chunking: the feed-forward layer runs in a loop instead of running a single feed-forward with a huge batch size.</li> <li>reduce <code>decode_chunk_size</code>: the VAE decodes frames in chunks instead of decoding them all together. Setting <code>decode_chunk_size=1</code> decodes one frame at a time and uses the least amount of memory (we recommend adjusting this value based on your GPU memory) but the video might have some flickering.</li>",pe,R,re,X,Ve="Using all these tricks together should lower the memory requirement to less than 8GB VRAM.",de,G,ce,x,Re="Stable Diffusion Video also accepts micro-conditioning, in addition to the conditioning image, which allows more control over the generated video:",ue,C,Xe="<li><code>fps</code>: the frames per second of the generated video.</li> <li><code>motion_bucket_id</code>: the motion bucket id to use for the generated video. This can be used to control the motion of the generated video. Increasing the motion bucket id increases the motion of the generated video.</li> <li><code>noise_aug_strength</code>: the amount of noise added to the conditioning image. The higher the values the less the video resembles the conditioning image. Increasing this value also increases the motion of the generated video.</li>",fe,I,Ge="For example, to generate a video with more motion, use the <code>motion_bucket_id</code> and <code>noise_aug_strength</code> micro-conditioning parameters:",he,B,ge,Y,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket_with_conditions.gif"/>',be,S,Me,z,Ze;return b=new Ne({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new Te({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),Z=new De({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"}]}}),y=new F({props:{code:"JTIzJTIwQ29sYWIlRUMlOTclOTAlRUMlODQlOUMlMjAlRUQlOTUlODQlRUMlOUElOTQlRUQlOTUlOUMlMjAlRUIlOUQlQkMlRUMlOUQlQjQlRUIlQjglOEMlRUIlOUYlQUMlRUIlQTYlQUMlRUIlQTUlQkMlMjAlRUMlODQlQTQlRUMlQjklOTglRUQlOTUlOTglRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlQjQlMjAlRUMlQTMlQkMlRUMlODQlOUQlRUMlOUQlODQlMjAlRUMlQTAlOUMlRUMlOTklQjglRUQlOTUlOTglRUMlODQlQjglRUMlOUElOTQlMEEhcGlwJTIwaW5zdGFsbCUyMC1xJTIwLVUlMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># Colab에서 필요한 라이브러리를 설치하기 위해 주석을 제외하세요</span>
!pip install -q -U diffusers transformers accelerate`,wrap:!1}}),j=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),k=new Te({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),_=new F({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),$=new Te({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h2"}}),R=new F({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQiUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQiUyMGZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">- frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+ pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+ frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),G=new Te({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),B=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),S=new Le({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/svd.md"}}),{c(){h=i("meta"),N=n(),E=i("p"),D=n(),p(b.$$.fragment),L=n(),p(M.$$.fragment),H=n(),p(Z.$$.fragment),O=n(),T=i("p"),T.innerHTML=ye,q=n(),J=i("p"),J.textContent=Ue,P=n(),w=i("p"),w.textContent=ve,A=n(),p(y.$$.fragment),K=n(),U=i("p"),U.innerHTML=je,ee=n(),v=i("p"),v.textContent=ke,te=n(),p(j.$$.fragment),le=n(),g=i("div"),g.innerHTML=We,se=n(),p(k.$$.fragment),ne=n(),W=i("p"),W.innerHTML=_e,ae=n(),p(_.$$.fragment),ie=n(),p($.$$.fragment),oe=n(),Q=i("p"),Q.innerHTML=$e,me=n(),V=i("ul"),V.innerHTML=Qe,pe=n(),p(R.$$.fragment),re=n(),X=i("p"),X.textContent=Ve,de=n(),p(G.$$.fragment),ce=n(),x=i("p"),x.textContent=Re,ue=n(),C=i("ul"),C.innerHTML=Xe,fe=n(),I=i("p"),I.innerHTML=Ge,he=n(),p(B.$$.fragment),ge=n(),Y=i("p"),Y.innerHTML=xe,be=n(),p(S.$$.fragment),Me=n(),z=i("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),N=a(e),E=o(e,"P",{}),Ce(E).forEach(l),D=a(e),r(b.$$.fragment,e),L=a(e),r(M.$$.fragment,e),H=a(e),r(Z.$$.fragment,e),O=a(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-6831zo"&&(T.innerHTML=ye),q=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-9hcj9z"&&(J.textContent=Ue),P=a(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-cwruts"&&(w.textContent=ve),A=a(e),r(y.$$.fragment,e),K=a(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-iibvlr"&&(U.innerHTML=je),ee=a(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-u5kxxd"&&(v.textContent=ke),te=a(e),r(j.$$.fragment,e),le=a(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-25rdw"&&(g.innerHTML=We),se=a(e),r(k.$$.fragment,e),ne=a(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1g0qdyz"&&(W.innerHTML=_e),ae=a(e),r(_.$$.fragment,e),ie=a(e),r($.$$.fragment,e),oe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1aihuum"&&(Q.innerHTML=$e),me=a(e),V=o(e,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-carvgs"&&(V.innerHTML=Qe),pe=a(e),r(R.$$.fragment,e),re=a(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1dz5kg5"&&(X.textContent=Ve),de=a(e),r(G.$$.fragment,e),ce=a(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-crombe"&&(x.textContent=Re),ue=a(e),C=o(e,"UL",{"data-svelte-h":!0}),m(C)!=="svelte-hs8jkz"&&(C.innerHTML=Xe),fe=a(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-3jffic"&&(I.innerHTML=Ge),he=a(e),r(B.$$.fragment,e),ge=a(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-19qaph4"&&(Y.innerHTML=xe),be=a(e),r(S.$$.fragment,e),Me=a(e),z=o(e,"P",{}),Ce(z).forEach(l),this.h()},h(){Je(h,"name","hf:doc:metadata"),Je(h,"content",Oe),Je(g,"class","flex gap-4")},m(e,t){Fe(document.head,h),s(e,N,t),s(e,E,t),s(e,D,t),d(b,e,t),s(e,L,t),d(M,e,t),s(e,H,t),d(Z,e,t),s(e,O,t),s(e,T,t),s(e,q,t),s(e,J,t),s(e,P,t),s(e,w,t),s(e,A,t),d(y,e,t),s(e,K,t),s(e,U,t),s(e,ee,t),s(e,v,t),s(e,te,t),d(j,e,t),s(e,le,t),s(e,g,t),s(e,se,t),d(k,e,t),s(e,ne,t),s(e,W,t),s(e,ae,t),d(_,e,t),s(e,ie,t),d($,e,t),s(e,oe,t),s(e,Q,t),s(e,me,t),s(e,V,t),s(e,pe,t),d(R,e,t),s(e,re,t),s(e,X,t),s(e,de,t),d(G,e,t),s(e,ce,t),s(e,x,t),s(e,ue,t),s(e,C,t),s(e,fe,t),s(e,I,t),s(e,he,t),d(B,e,t),s(e,ge,t),s(e,Y,t),s(e,be,t),d(S,e,t),s(e,Me,t),s(e,z,t),Ze=!0},p:Be,i(e){Ze||(c(b.$$.fragment,e),c(M.$$.fragment,e),c(Z.$$.fragment,e),c(y.$$.fragment,e),c(j.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(R.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(S.$$.fragment,e),Ze=!0)},o(e){u(b.$$.fragment,e),u(M.$$.fragment,e),u(Z.$$.fragment,e),u(y.$$.fragment,e),u(j.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u($.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(B.$$.fragment,e),u(S.$$.fragment,e),Ze=!1},d(e){e&&(l(N),l(E),l(D),l(L),l(H),l(O),l(T),l(q),l(J),l(P),l(w),l(A),l(K),l(U),l(ee),l(v),l(te),l(le),l(g),l(se),l(ne),l(W),l(ae),l(ie),l(oe),l(Q),l(me),l(V),l(pe),l(re),l(X),l(de),l(ce),l(x),l(ue),l(C),l(fe),l(I),l(he),l(ge),l(Y),l(be),l(Me),l(z)),l(h),f(b,e),f(M,e),f(Z,e),f(y,e),f(j,e),f(k,e),f(_,e),f($,e),f(R,e),f(G,e),f(B,e),f(S,e)}}}const Oe='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":2}],"depth":1}';function qe(we){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends Se{constructor(h){super(),Ee(this,h,qe,He,Ie,{})}}export{st as component};
