import{s as Dt,n as qt,o as Pt}from"../chunks/scheduler.53228c21.js";import{S as Kt,i as Ot,e as i,s as n,c as o,h as el,a as p,d as t,b as a,f as it,g as r,j as m,k as M,l as pt,m as l,n as d,t as c,o as h,p as u}from"../chunks/index.100fac89.js";import{C as sl}from"../chunks/CopyLLMTxtMenu.9360b11d.js";import{C as f}from"../chunks/CodeBlock.d30a6509.js";import{D as tl}from"../chunks/DocNotebookDropdown.1a28089c.js";import{H as Z,E as ll}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c9001d7a.js";function nl(mt){let b,Xe,Ne,He,k,Se,_,ze,x,Ee,V,ot='🧨 Diffusers is designed to be a user-friendly and flexible toolbox for building diffusion systems tailored to your use-case. At the core of the toolbox are models and schedulers. While the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> bundles these components together for convenience, you can also unbundle the pipeline and use the models and schedulers separately to create new diffusion systems.',Le,G,rt="In this tutorial, you’ll learn how to use models and schedulers to assemble a diffusion system for inference, starting with a basic pipeline and then progressing to the Stable Diffusion pipeline.",Fe,W,Qe,I,dt="A pipeline is a quick and easy way to run a model for inference, requiring no more than four lines of code to generate an image:",Ye,R,Ae,y,ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',De,N,ht="That was super easy, but how did the pipeline do that? Let’s breakdown the pipeline and take a look at what’s happening under the hood.",qe,B,ut='In the example above, the pipeline contains a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> model and a <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>. The pipeline denoises an image by taking random noise the size of the desired output and passing it through the model several times. At each timestep, the model predicts the <em>noise residual</em> and the scheduler uses it to predict a less noisy image. The pipeline repeats this process until it reaches the end of the specified number of inference steps.',Pe,X,ft="To recreate the pipeline with the model and scheduler separately, let’s write our own denoising process.",Ke,H,Mt="<li>Load the model and scheduler:</li>",Oe,S,es,j,bt="<li>Set the number of timesteps to run the denoising process for:</li>",ss,z,ts,w,gt="<li>Setting the scheduler timesteps creates a tensor with evenly spaced elements in it, 50 in this example. Each element corresponds to a timestep at which the model denoises an image. When you create the denoising loop later, you’ll iterate over this tensor to denoise an image:</li>",ls,E,ns,T,yt="<li>Create some random noise with the same shape as the desired output:</li>",as,L,is,U,jt='<li>Now write a loop to iterate over the timesteps. At each timestep, the model does a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel.forward">UNet2DModel.forward()</a> pass and returns the noisy residual. The scheduler’s <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method takes the noisy residual, timestep, and input and it predicts the image at the previous timestep. This output becomes the next input to the model in the denoising loop, and it’ll repeat until it reaches the end of the <code>timesteps</code> array.</li>',ps,F,ms,Q,wt="This is the entire denoising process, and you can use this same pattern to write any diffusion system.",os,J,Tt="<li>The last step is to convert the denoised output into an image:</li>",rs,Y,ds,A,Ut="In the next section, you’ll put your skills to the test and breakdown the more complex Stable Diffusion pipeline. The steps are more or less the same. You’ll initialize the necessary components, and set the number of timesteps to create a <code>timestep</code> array. The <code>timestep</code> array is used in the denoising loop, and for each element in this array, the model predicts a less noisy image. The denoising loop iterates over the <code>timestep</code>’s, and at each timestep, it outputs a noisy residual and the scheduler uses it to predict a less noisy image at the previous timestep. This process is repeated until you reach the end of the <code>timestep</code> array.",cs,D,Jt="Let’s try it out!",hs,q,us,P,$t="Stable Diffusion is a text-to-image <em>latent diffusion</em> model. It is called a latent diffusion model because it works with a lower-dimensional representation of the image instead of the actual pixel space, which makes it more memory efficient. The encoder compresses the image into a smaller representation, and a decoder converts the compressed representation back into an image. For text-to-image models, you’ll need a tokenizer and an encoder to generate text embeddings. From the previous example, you already know you need a UNet model and a scheduler.",fs,K,Ct="As you can see, this is already more complex than the DDPM pipeline which only contains a UNet model. The Stable Diffusion model has three separate pretrained models.",Ms,$,vt='<p>💡 Read the <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> blog for more details about how the VAE, UNet, and text encoder models work.</p>',bs,O,Zt='Now that you know what you need for the Stable Diffusion pipeline, load all these components with the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method. You can find them in the pretrained <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> checkpoint, and each component is stored in a separate subfolder:',gs,ee,ys,se,kt='Instead of the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>, exchange it for the <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> to see how easy it is to plug a different scheduler in:',js,te,ws,le,_t="To speed up inference, move the models to a GPU since, unlike the scheduler, they have trainable weights:",Ts,ne,Us,ae,Js,ie,xt="The next step is to tokenize the text to generate embeddings. The text is used to condition the UNet model and steer the diffusion process towards something that resembles the input prompt.",$s,C,Vt="<p>💡 The <code>guidance_scale</code> parameter determines how much weight should be given to the prompt when generating an image.</p>",Cs,pe,Gt="Feel free to choose any prompt you like if you want to generate something else!",vs,me,Zs,oe,Wt="Tokenize the text and generate the embeddings from the prompt:",ks,re,_s,de,It="You’ll also need to generate the <em>unconditional text embeddings</em> which are the embeddings for the padding token. These need to have the same shape (<code>batch_size</code> and <code>seq_length</code>) as the conditional <code>text_embeddings</code>:",xs,ce,Vs,he,Rt="Let’s concatenate the conditional and unconditional embeddings into a batch to avoid doing two forward passes:",Gs,ue,Ws,fe,Is,Me,Nt="Next, generate some initial random noise as a starting point for the diffusion process. This is the latent representation of the image, and it’ll be gradually denoised. At this point, the <code>latent</code> image is smaller than the final image size but that’s okay though because the model will transform it into the final 512x512 image dimensions later.",Rs,g,Re,Bt="💡 The height and width are divided by 8 because the <code>vae</code> model has 3 down-sampling layers. You can check by running the following:",at,be,Ns,ge,Bs,ye,Xs,je,Xt='Start by scaling the input with the initial noise distribution, <em>sigma</em>, the noise scale value, which is required for improved schedulers like <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>:',Hs,we,Ss,Te,Ht="The last step is to create the denoising loop that’ll progressively transform the pure noise in <code>latents</code> to an image described by your prompt. Remember, the denoising loop needs to do three things:",zs,Ue,St="<li>Set the scheduler’s timesteps to use during denoising.</li> <li>Iterate over the timesteps.</li> <li>At each timestep, call the UNet model to predict the noise residual and pass it to the scheduler to compute the previous noisy sample.</li>",Es,Je,Ls,$e,Fs,Ce,zt="The final step is to use the <code>vae</code> to decode the latent representation into an image and get the decoded output with <code>sample</code>:",Qs,ve,Ys,Ze,Et="Lastly, convert the image to a <code>PIL.Image</code> to see your generated image!",As,ke,Ds,v,Lt='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',qs,_e,Ps,xe,Ft="From basic to complex pipelines, you’ve seen that all you really need to write your own diffusion system is a denoising loop. The loop should set the scheduler’s timesteps, iterate over them, and alternate between calling the UNet model to predict the noise residual and passing it to the scheduler to compute the previous noisy sample.",Ks,Ve,Qt="This is really what 🧨 Diffusers is designed for: to make it intuitive and easy to write your own diffusion system using models and schedulers.",Os,Ge,Yt="For your next steps, feel free to:",et,We,At='<li>Learn how to <a href="../using-diffusers/contribute_pipeline">build and contribute a pipeline</a> to 🧨 Diffusers. We can’t wait and see what you’ll come up with!</li> <li>Explore <a href="../api/pipelines/overview">existing pipelines</a> in the library, and see if you can deconstruct and build a pipeline from scratch using the models and schedulers separately.</li>',st,Ie,tt,Be,lt;return k=new sl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new Z({props:{title:"Understanding pipelines, models and schedulers",local:"understanding-pipelines-models-and-schedulers",headingTag:"h1"}}),x=new tl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"}]}}),W=new Z({props:{title:"Deconstruct a basic pipeline",local:"deconstruct-a-basic-pipeline",headingTag:"h2"}}),R=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZHBtKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),S=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),z=new f({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)',wrap:!1}}),E=new f({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`,wrap:!1}}),L=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),F=new f({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkucm91bmQoKS50byh0b3JjaC51aW50OCkuY3B1KCkubnVtcHkoKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),q=new Z({props:{title:"Deconstruct the Stable Diffusion pipeline",local:"deconstruct-the-stable-diffusion-pipeline",headingTag:"h2"}}),ee=new f({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwQ0xJUFRleHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),te=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),ne=new f({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`,wrap:!1}}),ae=new Z({props:{title:"Create text embeddings",local:"create-text-embeddings",headingTag:"h3"}}),me=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwZGVmYXVsdCUyMGhlaWdodCUyMG9mJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBkZWZhdWx0JTIwd2lkdGglMjBvZiUyMFN0YWJsZSUyMERpZmZ1c2lvbiUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyNSUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwZGVub2lzaW5nJTIwc3RlcHMlMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMFNjYWxlJTIwZm9yJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMFNlZWQlMjBnZW5lcmF0b3IlMjB0byUyMGNyZWF0ZSUyMHRoZSUyMGluaXRpYWwlMjBsYXRlbnQlMjBub2lzZSUwQWJhdGNoX3NpemUlMjAlM0QlMjBsZW4ocHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># default height of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># default width of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># Number of denoising steps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># Scale for classifier-free guidance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Seed generator to create the initial latent noise</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`,wrap:!1}}),re=new f({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),ce=new f({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),ue=new f({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])',wrap:!1}}),fe=new Z({props:{title:"Create random noise",local:"create-random-noise",headingTag:"h3"}}),be=new f({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>',wrap:!1}}),ge=new f({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ye=new Z({props:{title:"Denoise the image",local:"denoise-the-image",headingTag:"h3"}}),we=new f({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma',wrap:!1}}),Je=new f({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBleHBhbmQlMjB0aGUlMjBsYXRlbnRzJTIwaWYlMjB3ZSUyMGFyZSUyMGRvaW5nJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMjB0byUyMGF2b2lkJTIwZG9pbmclMjB0d28lMjBmb3J3YXJkJTIwcGFzc2VzLiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwcmVkaWN0JTIwdGhlJTIwbm9pc2UlMjByZXNpZHVhbCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwdW5ldChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTNEdGV4dF9lbWJlZGRpbmdzKS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJmb3JtJTIwZ3VpZGFuY2UlMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkX3VuY29uZCUyQyUyMG5vaXNlX3ByZWRfdGV4dCUyMCUzRCUyMG5vaXNlX3ByZWQuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwbm9pc2VfcHJlZF91bmNvbmQlMjAlMkIlMjBndWlkYW5jZV9zY2FsZSUyMColMjAobm9pc2VfcHJlZF90ZXh0JTIwLSUyMG5vaXNlX3ByZWRfdW5jb25kKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjB0aGUlMjBwcmV2aW91cyUyMG5vaXN5JTIwc2FtcGxlJTIweF90JTIwLSUzRSUyMHhfdC0xJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIwbGF0ZW50cykucHJldl9zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># expand the latents if we are doing classifier-free guidance to avoid doing two forward passes.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`,wrap:!1}}),$e=new Z({props:{title:"Decode the image",local:"decode-the-image",headingTag:"h3"}}),ve=new f({props:{code:"JTIzJTIwc2NhbGUlMjBhbmQlMjBkZWNvZGUlMjB0aGUlMjBpbWFnZSUyMGxhdGVudHMlMjB3aXRoJTIwdmFlJTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># scale and decode the image latents with vae</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`,wrap:!1}}),ke=new f({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkudG8odG9yY2gudWludDgpLmNwdSgpLm51bXB5KCklMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),_e=new Z({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Ie=new ll({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/write_own_pipeline.md"}}),{c(){b=i("meta"),Xe=n(),Ne=i("p"),He=n(),o(k.$$.fragment),Se=n(),o(_.$$.fragment),ze=n(),o(x.$$.fragment),Ee=n(),V=i("p"),V.innerHTML=ot,Le=n(),G=i("p"),G.textContent=rt,Fe=n(),o(W.$$.fragment),Qe=n(),I=i("p"),I.textContent=dt,Ye=n(),o(R.$$.fragment),Ae=n(),y=i("div"),y.innerHTML=ct,De=n(),N=i("p"),N.textContent=ht,qe=n(),B=i("p"),B.innerHTML=ut,Pe=n(),X=i("p"),X.textContent=ft,Ke=n(),H=i("ol"),H.innerHTML=Mt,Oe=n(),o(S.$$.fragment),es=n(),j=i("ol"),j.innerHTML=bt,ss=n(),o(z.$$.fragment),ts=n(),w=i("ol"),w.innerHTML=gt,ls=n(),o(E.$$.fragment),ns=n(),T=i("ol"),T.innerHTML=yt,as=n(),o(L.$$.fragment),is=n(),U=i("ol"),U.innerHTML=jt,ps=n(),o(F.$$.fragment),ms=n(),Q=i("p"),Q.textContent=wt,os=n(),J=i("ol"),J.innerHTML=Tt,rs=n(),o(Y.$$.fragment),ds=n(),A=i("p"),A.innerHTML=Ut,cs=n(),D=i("p"),D.textContent=Jt,hs=n(),o(q.$$.fragment),us=n(),P=i("p"),P.innerHTML=$t,fs=n(),K=i("p"),K.textContent=Ct,Ms=n(),$=i("blockquote"),$.innerHTML=vt,bs=n(),O=i("p"),O.innerHTML=Zt,gs=n(),o(ee.$$.fragment),ys=n(),se=i("p"),se.innerHTML=kt,js=n(),o(te.$$.fragment),ws=n(),le=i("p"),le.textContent=_t,Ts=n(),o(ne.$$.fragment),Us=n(),o(ae.$$.fragment),Js=n(),ie=i("p"),ie.textContent=xt,$s=n(),C=i("blockquote"),C.innerHTML=Vt,Cs=n(),pe=i("p"),pe.textContent=Gt,vs=n(),o(me.$$.fragment),Zs=n(),oe=i("p"),oe.textContent=Wt,ks=n(),o(re.$$.fragment),_s=n(),de=i("p"),de.innerHTML=It,xs=n(),o(ce.$$.fragment),Vs=n(),he=i("p"),he.textContent=Rt,Gs=n(),o(ue.$$.fragment),Ws=n(),o(fe.$$.fragment),Is=n(),Me=i("p"),Me.innerHTML=Nt,Rs=n(),g=i("blockquote"),Re=i("p"),Re.innerHTML=Bt,at=n(),o(be.$$.fragment),Ns=n(),o(ge.$$.fragment),Bs=n(),o(ye.$$.fragment),Xs=n(),je=i("p"),je.innerHTML=Xt,Hs=n(),o(we.$$.fragment),Ss=n(),Te=i("p"),Te.innerHTML=Ht,zs=n(),Ue=i("ol"),Ue.innerHTML=St,Es=n(),o(Je.$$.fragment),Ls=n(),o($e.$$.fragment),Fs=n(),Ce=i("p"),Ce.innerHTML=zt,Qs=n(),o(ve.$$.fragment),Ys=n(),Ze=i("p"),Ze.innerHTML=Et,As=n(),o(ke.$$.fragment),Ds=n(),v=i("div"),v.innerHTML=Lt,qs=n(),o(_e.$$.fragment),Ps=n(),xe=i("p"),xe.textContent=Ft,Ks=n(),Ve=i("p"),Ve.textContent=Qt,Os=n(),Ge=i("p"),Ge.textContent=Yt,et=n(),We=i("ul"),We.innerHTML=At,st=n(),o(Ie.$$.fragment),tt=n(),Be=i("p"),this.h()},l(e){const s=el("svelte-u9bgzb",document.head);b=p(s,"META",{name:!0,content:!0}),s.forEach(t),Xe=a(e),Ne=p(e,"P",{}),it(Ne).forEach(t),He=a(e),r(k.$$.fragment,e),Se=a(e),r(_.$$.fragment,e),ze=a(e),r(x.$$.fragment,e),Ee=a(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-eguqi8"&&(V.innerHTML=ot),Le=a(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-5khcjg"&&(G.textContent=rt),Fe=a(e),r(W.$$.fragment,e),Qe=a(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1o4pmop"&&(I.textContent=dt),Ye=a(e),r(R.$$.fragment,e),Ae=a(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-ej6f4c"&&(y.innerHTML=ct),De=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-7b411q"&&(N.textContent=ht),qe=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-rmfggx"&&(B.innerHTML=ut),Pe=a(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-mwr50"&&(X.textContent=ft),Ke=a(e),H=p(e,"OL",{"data-svelte-h":!0}),m(H)!=="svelte-g7uo25"&&(H.innerHTML=Mt),Oe=a(e),r(S.$$.fragment,e),es=a(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(j)!=="svelte-o7kbas"&&(j.innerHTML=bt),ss=a(e),r(z.$$.fragment,e),ts=a(e),w=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(w)!=="svelte-1jnsvh9"&&(w.innerHTML=gt),ls=a(e),r(E.$$.fragment,e),ns=a(e),T=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(T)!=="svelte-1hrlquj"&&(T.innerHTML=yt),as=a(e),r(L.$$.fragment,e),is=a(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(U)!=="svelte-1hivual"&&(U.innerHTML=jt),ps=a(e),r(F.$$.fragment,e),ms=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-sdv3mq"&&(Q.textContent=wt),os=a(e),J=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(J)!=="svelte-1du7raq"&&(J.innerHTML=Tt),rs=a(e),r(Y.$$.fragment,e),ds=a(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-t8ln8h"&&(A.innerHTML=Ut),cs=a(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-tru974"&&(D.textContent=Jt),hs=a(e),r(q.$$.fragment,e),us=a(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1m5a7zj"&&(P.innerHTML=$t),fs=a(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1yb6q1d"&&(K.textContent=Ct),Ms=a(e),$=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m($)!=="svelte-1nt4zqc"&&($.innerHTML=vt),bs=a(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-c54k9v"&&(O.innerHTML=Zt),gs=a(e),r(ee.$$.fragment,e),ys=a(e),se=p(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1mwizy3"&&(se.innerHTML=kt),js=a(e),r(te.$$.fragment,e),ws=a(e),le=p(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1tr4efr"&&(le.textContent=_t),Ts=a(e),r(ne.$$.fragment,e),Us=a(e),r(ae.$$.fragment,e),Js=a(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-ltx5oa"&&(ie.textContent=xt),$s=a(e),C=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(C)!=="svelte-mu3bu1"&&(C.innerHTML=Vt),Cs=a(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-z6gwd8"&&(pe.textContent=Gt),vs=a(e),r(me.$$.fragment,e),Zs=a(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-q7skg3"&&(oe.textContent=Wt),ks=a(e),r(re.$$.fragment,e),_s=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-e64ab9"&&(de.innerHTML=It),xs=a(e),r(ce.$$.fragment,e),Vs=a(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-41mj23"&&(he.textContent=Rt),Gs=a(e),r(ue.$$.fragment,e),Ws=a(e),r(fe.$$.fragment,e),Is=a(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1gyrog2"&&(Me.innerHTML=Nt),Rs=a(e),g=p(e,"BLOCKQUOTE",{class:!0});var nt=it(g);Re=p(nt,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1c9k596"&&(Re.innerHTML=Bt),at=a(nt),r(be.$$.fragment,nt),nt.forEach(t),Ns=a(e),r(ge.$$.fragment,e),Bs=a(e),r(ye.$$.fragment,e),Xs=a(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1ltl3zx"&&(je.innerHTML=Xt),Hs=a(e),r(we.$$.fragment,e),Ss=a(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-ul1wgx"&&(Te.innerHTML=Ht),zs=a(e),Ue=p(e,"OL",{"data-svelte-h":!0}),m(Ue)!=="svelte-ceuo6w"&&(Ue.innerHTML=St),Es=a(e),r(Je.$$.fragment,e),Ls=a(e),r($e.$$.fragment,e),Fs=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-rzriwa"&&(Ce.innerHTML=zt),Qs=a(e),r(ve.$$.fragment,e),Ys=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-6reqqn"&&(Ze.innerHTML=Et),As=a(e),r(ke.$$.fragment,e),Ds=a(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-1b0w6va"&&(v.innerHTML=Lt),qs=a(e),r(_e.$$.fragment,e),Ps=a(e),xe=p(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-9a4wlz"&&(xe.textContent=Ft),Ks=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-u3h7jy"&&(Ve.textContent=Qt),Os=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-xe6tlx"&&(Ge.textContent=Yt),et=a(e),We=p(e,"UL",{"data-svelte-h":!0}),m(We)!=="svelte-wmho1r"&&(We.innerHTML=At),st=a(e),r(Ie.$$.fragment,e),tt=a(e),Be=p(e,"P",{}),it(Be).forEach(t),this.h()},h(){M(b,"name","hf:doc:metadata"),M(b,"content",al),M(y,"class","flex justify-center"),M(j,"start","2"),M(w,"start","3"),M(T,"start","4"),M(U,"start","5"),M(J,"start","6"),M($,"class","tip"),M(C,"class","tip"),M(g,"class","tip"),M(v,"class","flex justify-center")},m(e,s){pt(document.head,b),l(e,Xe,s),l(e,Ne,s),l(e,He,s),d(k,e,s),l(e,Se,s),d(_,e,s),l(e,ze,s),d(x,e,s),l(e,Ee,s),l(e,V,s),l(e,Le,s),l(e,G,s),l(e,Fe,s),d(W,e,s),l(e,Qe,s),l(e,I,s),l(e,Ye,s),d(R,e,s),l(e,Ae,s),l(e,y,s),l(e,De,s),l(e,N,s),l(e,qe,s),l(e,B,s),l(e,Pe,s),l(e,X,s),l(e,Ke,s),l(e,H,s),l(e,Oe,s),d(S,e,s),l(e,es,s),l(e,j,s),l(e,ss,s),d(z,e,s),l(e,ts,s),l(e,w,s),l(e,ls,s),d(E,e,s),l(e,ns,s),l(e,T,s),l(e,as,s),d(L,e,s),l(e,is,s),l(e,U,s),l(e,ps,s),d(F,e,s),l(e,ms,s),l(e,Q,s),l(e,os,s),l(e,J,s),l(e,rs,s),d(Y,e,s),l(e,ds,s),l(e,A,s),l(e,cs,s),l(e,D,s),l(e,hs,s),d(q,e,s),l(e,us,s),l(e,P,s),l(e,fs,s),l(e,K,s),l(e,Ms,s),l(e,$,s),l(e,bs,s),l(e,O,s),l(e,gs,s),d(ee,e,s),l(e,ys,s),l(e,se,s),l(e,js,s),d(te,e,s),l(e,ws,s),l(e,le,s),l(e,Ts,s),d(ne,e,s),l(e,Us,s),d(ae,e,s),l(e,Js,s),l(e,ie,s),l(e,$s,s),l(e,C,s),l(e,Cs,s),l(e,pe,s),l(e,vs,s),d(me,e,s),l(e,Zs,s),l(e,oe,s),l(e,ks,s),d(re,e,s),l(e,_s,s),l(e,de,s),l(e,xs,s),d(ce,e,s),l(e,Vs,s),l(e,he,s),l(e,Gs,s),d(ue,e,s),l(e,Ws,s),d(fe,e,s),l(e,Is,s),l(e,Me,s),l(e,Rs,s),l(e,g,s),pt(g,Re),pt(g,at),d(be,g,null),l(e,Ns,s),d(ge,e,s),l(e,Bs,s),d(ye,e,s),l(e,Xs,s),l(e,je,s),l(e,Hs,s),d(we,e,s),l(e,Ss,s),l(e,Te,s),l(e,zs,s),l(e,Ue,s),l(e,Es,s),d(Je,e,s),l(e,Ls,s),d($e,e,s),l(e,Fs,s),l(e,Ce,s),l(e,Qs,s),d(ve,e,s),l(e,Ys,s),l(e,Ze,s),l(e,As,s),d(ke,e,s),l(e,Ds,s),l(e,v,s),l(e,qs,s),d(_e,e,s),l(e,Ps,s),l(e,xe,s),l(e,Ks,s),l(e,Ve,s),l(e,Os,s),l(e,Ge,s),l(e,et,s),l(e,We,s),l(e,st,s),d(Ie,e,s),l(e,tt,s),l(e,Be,s),lt=!0},p:qt,i(e){lt||(c(k.$$.fragment,e),c(_.$$.fragment,e),c(x.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(Y.$$.fragment,e),c(q.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(me.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c($e.$$.fragment,e),c(ve.$$.fragment,e),c(ke.$$.fragment,e),c(_e.$$.fragment,e),c(Ie.$$.fragment,e),lt=!0)},o(e){h(k.$$.fragment,e),h(_.$$.fragment,e),h(x.$$.fragment,e),h(W.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(L.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(q.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(me.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(ge.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h($e.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(_e.$$.fragment,e),h(Ie.$$.fragment,e),lt=!1},d(e){e&&(t(Xe),t(Ne),t(He),t(Se),t(ze),t(Ee),t(V),t(Le),t(G),t(Fe),t(Qe),t(I),t(Ye),t(Ae),t(y),t(De),t(N),t(qe),t(B),t(Pe),t(X),t(Ke),t(H),t(Oe),t(es),t(j),t(ss),t(ts),t(w),t(ls),t(ns),t(T),t(as),t(is),t(U),t(ps),t(ms),t(Q),t(os),t(J),t(rs),t(ds),t(A),t(cs),t(D),t(hs),t(us),t(P),t(fs),t(K),t(Ms),t($),t(bs),t(O),t(gs),t(ys),t(se),t(js),t(ws),t(le),t(Ts),t(Us),t(Js),t(ie),t($s),t(C),t(Cs),t(pe),t(vs),t(Zs),t(oe),t(ks),t(_s),t(de),t(xs),t(Vs),t(he),t(Gs),t(Ws),t(Is),t(Me),t(Rs),t(g),t(Ns),t(Bs),t(Xs),t(je),t(Hs),t(Ss),t(Te),t(zs),t(Ue),t(Es),t(Ls),t(Fs),t(Ce),t(Qs),t(Ys),t(Ze),t(As),t(Ds),t(v),t(qs),t(Ps),t(xe),t(Ks),t(Ve),t(Os),t(Ge),t(et),t(We),t(st),t(tt),t(Be)),t(b),u(k,e),u(_,e),u(x,e),u(W,e),u(R,e),u(S,e),u(z,e),u(E,e),u(L,e),u(F,e),u(Y,e),u(q,e),u(ee,e),u(te,e),u(ne,e),u(ae,e),u(me,e),u(re,e),u(ce,e),u(ue,e),u(fe,e),u(be),u(ge,e),u(ye,e),u(we,e),u(Je,e),u($e,e),u(ve,e),u(ke,e),u(_e,e),u(Ie,e)}}}const al='{"title":"Understanding pipelines, models and schedulers","local":"understanding-pipelines-models-and-schedulers","sections":[{"title":"Deconstruct a basic pipeline","local":"deconstruct-a-basic-pipeline","sections":[],"depth":2},{"title":"Deconstruct the Stable Diffusion pipeline","local":"deconstruct-the-stable-diffusion-pipeline","sections":[{"title":"Create text embeddings","local":"create-text-embeddings","sections":[],"depth":3},{"title":"Create random noise","local":"create-random-noise","sections":[],"depth":3},{"title":"Denoise the image","local":"denoise-the-image","sections":[],"depth":3},{"title":"Decode the image","local":"decode-the-image","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function il(mt){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Kt{constructor(b){super(),Ot(this,b,il,nl,Dt,{})}}export{hl as component};
