# EasyAnimateTransformer3DModel

A Diffusion Transformer model for 3D data from [EasyAnimate](https://github.com/aigc-apps/EasyAnimate) was introduced by Alibaba PAI.

The model can be loaded with the following code snippet.

```python
from diffusers import EasyAnimateTransformer3DModel

transformer = EasyAnimateTransformer3DModel.from_pretrained("alibaba-pai/EasyAnimateV5.1-12b-zh", subfolder="transformer", torch_dtype=torch.float16).to("cuda")
```

## EasyAnimateTransformer3DModel[[diffusers.EasyAnimateTransformer3DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.EasyAnimateTransformer3DModel</name><anchor>diffusers.EasyAnimateTransformer3DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_easyanimate.py#L318</source><parameters>[{"name": "num_attention_heads", "val": ": int = 48"}, {"name": "attention_head_dim", "val": ": int = 64"}, {"name": "in_channels", "val": ": typing.Optional[int] = None"}, {"name": "out_channels", "val": ": typing.Optional[int] = None"}, {"name": "patch_size", "val": ": typing.Optional[int] = None"}, {"name": "sample_width", "val": ": int = 90"}, {"name": "sample_height", "val": ": int = 60"}, {"name": "activation_fn", "val": ": str = 'gelu-approximate'"}, {"name": "timestep_activation_fn", "val": ": str = 'silu'"}, {"name": "freq_shift", "val": ": int = 0"}, {"name": "num_layers", "val": ": int = 48"}, {"name": "mmdit_layers", "val": ": int = 48"}, {"name": "dropout", "val": ": float = 0.0"}, {"name": "time_embed_dim", "val": ": int = 512"}, {"name": "add_norm_text_encoder", "val": ": bool = False"}, {"name": "text_embed_dim", "val": ": int = 3584"}, {"name": "text_embed_dim_t5", "val": ": int = None"}, {"name": "norm_eps", "val": ": float = 1e-05"}, {"name": "norm_elementwise_affine", "val": ": bool = True"}, {"name": "flip_sin_to_cos", "val": ": bool = True"}, {"name": "time_position_encoding_type", "val": ": str = '3d_rope'"}, {"name": "after_norm", "val": " = False"}, {"name": "resize_inpaint_mask_directly", "val": ": bool = True"}, {"name": "enable_text_attention_mask", "val": ": bool = True"}, {"name": "add_noise_in_inpaint_model", "val": ": bool = True"}]</parameters><paramsdesc>- **num_attention_heads** (`int`, defaults to `48`) --
  The number of heads to use for multi-head attention.
- **attention_head_dim** (`int`, defaults to `64`) --
  The number of channels in each head.
- **in_channels** (`int`, defaults to `16`) --
  The number of channels in the input.
- **out_channels** (`int`, *optional*, defaults to `16`) --
  The number of channels in the output.
- **patch_size** (`int`, defaults to `2`) --
  The size of the patches to use in the patch embedding layer.
- **sample_width** (`int`, defaults to `90`) --
  The width of the input latents.
- **sample_height** (`int`, defaults to `60`) --
  The height of the input latents.
- **activation_fn** (`str`, defaults to `"gelu-approximate"`) --
  Activation function to use in feed-forward.
- **timestep_activation_fn** (`str`, defaults to `"silu"`) --
  Activation function to use when generating the timestep embeddings.
- **num_layers** (`int`, defaults to `30`) --
  The number of layers of Transformer blocks to use.
- **mmdit_layers** (`int`, defaults to `1000`) --
  The number of layers of Multi Modal Transformer blocks to use.
- **dropout** (`float`, defaults to `0.0`) --
  The dropout probability to use.
- **time_embed_dim** (`int`, defaults to `512`) --
  Output dimension of timestep embeddings.
- **text_embed_dim** (`int`, defaults to `4096`) --
  Input dimension of text embeddings from the text encoder.
- **norm_eps** (`float`, defaults to `1e-5`) --
  The epsilon value to use in normalization layers.
- **norm_elementwise_affine** (`bool`, defaults to `True`) --
  Whether to use elementwise affine in normalization layers.
- **flip_sin_to_cos** (`bool`, defaults to `True`) --
  Whether to flip the sin to cos in the time embedding.
- **time_position_encoding_type** (`str`, defaults to `3d_rope`) --
  Type of time position encoding.
- **after_norm** (`bool`, defaults to `False`) --
  Flag to apply normalization after.
- **resize_inpaint_mask_directly** (`bool`, defaults to `True`) --
  Flag to resize inpaint mask directly.
- **enable_text_attention_mask** (`bool`, defaults to `True`) --
  Flag to enable text attention mask.
- **add_noise_in_inpaint_model** (`bool`, defaults to `False`) --
  Flag to add noise in inpaint model.</paramsdesc><paramgroups>0</paramgroups></docstring>

A Transformer model for video-like data in [EasyAnimate](https://github.com/aigc-apps/EasyAnimate).




</div>

## Transformer2DModelOutput[[diffusers.models.modeling_outputs.Transformer2DModelOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.modeling_outputs.Transformer2DModelOutput</name><anchor>diffusers.models.modeling_outputs.Transformer2DModelOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L21</source><parameters>[{"name": "sample", "val": ": torch.Tensor"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` or `(batch size, num_vector_embeds - 1, num_latent_pixels)` if [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel) is discrete) --
  The hidden states output conditioned on the `encoder_hidden_states` input. If discrete, returns probability
  distributions for the unnoised latent pixels.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/easyanimate_transformer3d.md" />