# Pipeline blocks

## ModularPipelineBlocks[[diffusers.ModularPipelineBlocks]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ModularPipelineBlocks</name><anchor>diffusers.ModularPipelineBlocks</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L222</source><parameters>[]</parameters></docstring>

Base class for all Pipeline Blocks: PipelineBlock, AutoPipelineBlocks, SequentialPipelineBlocks,
LoopSequentialPipelineBlocks

[ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks) provides method to load and save the definition of pipeline blocks.

> [!WARNING] > This is an experimental feature and is likely to change in the future.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>combine_inputs</name><anchor>diffusers.ModularPipelineBlocks.combine_inputs</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L427</source><parameters>[{"name": "*named_input_lists", "val": ": typing.List[typing.Tuple[str, typing.List[diffusers.modular_pipelines.modular_pipeline_utils.InputParam]]]"}]</parameters><paramsdesc>- **named_input_lists** -- List of tuples containing (block_name, input_param_list) pairs</paramsdesc><paramgroups>0</paramgroups><rettype>List[InputParam]</rettype><retdesc>Combined list of unique InputParam objects</retdesc></docstring>

Combines multiple lists of InputParam objects from different blocks. For duplicate inputs, updates only if
current default value is None and new default value is not None. Warns if multiple non-None default values
exist for the same input.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>combine_outputs</name><anchor>diffusers.ModularPipelineBlocks.combine_outputs</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L470</source><parameters>[{"name": "*named_output_lists", "val": ": typing.List[typing.Tuple[str, typing.List[diffusers.modular_pipelines.modular_pipeline_utils.OutputParam]]]"}]</parameters><paramsdesc>- **named_output_lists** -- List of tuples containing (block_name, output_param_list) pairs</paramsdesc><paramgroups>0</paramgroups><rettype>List[OutputParam]</rettype><retdesc>Combined list of unique OutputParam objects</retdesc></docstring>

Combines multiple lists of OutputParam objects from different blocks. For duplicate outputs, keeps the first
occurrence of each output name.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_block_state</name><anchor>diffusers.ModularPipelineBlocks.get_block_state</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L370</source><parameters>[{"name": "state", "val": ": PipelineState"}]</parameters></docstring>
Get all inputs and intermediates in one dictionary

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>init_pipeline</name><anchor>diffusers.ModularPipelineBlocks.init_pipeline</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L349</source><parameters>[{"name": "pretrained_model_name_or_path", "val": ": typing.Union[str, os.PathLike, NoneType] = None"}, {"name": "components_manager", "val": ": typing.Optional[diffusers.modular_pipelines.components_manager.ComponentsManager] = None"}, {"name": "collection", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

create a ModularPipeline, optionally accept modular_repo to load from hub.


</div></div>

## SequentialPipelineBlocks[[diffusers.modular_pipelines.SequentialPipelineBlocks]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.SequentialPipelineBlocks</name><anchor>diffusers.modular_pipelines.SequentialPipelineBlocks</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L774</source><parameters>[]</parameters><paramsdesc>- **block_classes** -- List of block classes to be used
- **block_names** -- List of prefixes for each block</paramsdesc><paramgroups>0</paramgroups></docstring>

A Pipeline Blocks that combines multiple pipeline block classes into one. When called, it will call each block in
sequence.

This class inherits from [ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks). Check the superclass documentation for the generic methods the
library implements for all the pipeline blocks (such as loading or saving etc.)

> [!WARNING] > This is an experimental feature and is likely to change in the future.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_blocks_dict</name><anchor>diffusers.modular_pipelines.SequentialPipelineBlocks.from_blocks_dict</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L818</source><parameters>[{"name": "blocks_dict", "val": ": typing.Dict[str, typing.Any]"}, {"name": "description", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **blocks_dict** -- Dictionary mapping block names to block classes or instances</paramsdesc><paramgroups>0</paramgroups><retdesc>A new SequentialPipelineBlocks instance</retdesc></docstring>
Creates a SequentialPipelineBlocks instance from a dictionary of blocks.






</div></div>

## LoopSequentialPipelineBlocks[[diffusers.modular_pipelines.LoopSequentialPipelineBlocks]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.LoopSequentialPipelineBlocks</name><anchor>diffusers.modular_pipelines.LoopSequentialPipelineBlocks</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L1129</source><parameters>[]</parameters><paramsdesc>- **block_classes** -- List of block classes to be used
- **block_names** -- List of prefixes for each block</paramsdesc><paramgroups>0</paramgroups></docstring>

A Pipeline blocks that combines multiple pipeline block classes into a For Loop. When called, it will call each
block in sequence.

This class inherits from [ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks). Check the superclass documentation for the generic methods the
library implements for all the pipeline blocks (such as loading or saving etc.)

> [!WARNING] > This is an experimental feature and is likely to change in the future.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_blocks_dict</name><anchor>diffusers.modular_pipelines.LoopSequentialPipelineBlocks.from_blocks_dict</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L1281</source><parameters>[{"name": "blocks_dict", "val": ": typing.Dict[str, typing.Any]"}]</parameters><paramsdesc>- **blocks_dict** -- Dictionary mapping block names to block instances</paramsdesc><paramgroups>0</paramgroups><retdesc>A new LoopSequentialPipelineBlocks instance</retdesc></docstring>

Creates a LoopSequentialPipelineBlocks instance from a dictionary of blocks.






</div></div>

## AutoPipelineBlocks[[diffusers.modular_pipelines.AutoPipelineBlocks]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.AutoPipelineBlocks</name><anchor>diffusers.modular_pipelines.AutoPipelineBlocks</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L517</source><parameters>[]</parameters><paramsdesc>- **block_classes** -- List of block classes to be used
- **block_names** -- List of prefixes for each block
- **block_trigger_inputs** -- List of input names that trigger specific blocks, with None for default</paramsdesc><paramgroups>0</paramgroups></docstring>

A Pipeline Blocks that automatically selects a block to run based on the inputs.

This class inherits from [ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks). Check the superclass documentation for the generic methods the
library implements for all the pipeline blocks (such as loading or saving etc.)

> [!WARNING] > This is an experimental feature and is likely to change in the future.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/modular_diffusers/pipeline_blocks.md" />