# ConsistencyDecoderScheduler

This scheduler is a part of the `ConsistencyDecoderPipeline` and was introduced in [DALL-E 3](https://openai.com/dall-e-3).

The original codebase can be found at [openai/consistency_models](https://github.com/openai/consistency_models).


## ConsistencyDecoderScheduler[[diffusers.schedulers.ConsistencyDecoderScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.schedulers.ConsistencyDecoderScheduler</name><anchor>diffusers.schedulers.ConsistencyDecoderScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_decoder.py#L72</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1024"}, {"name": "sigma_data", "val": ": float = 0.5"}]</parameters></docstring>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.schedulers.ConsistencyDecoderScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_decoder.py#L116</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.schedulers.ConsistencyDecoderScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_decoder.py#L133</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.Tensor]"}, {"name": "sample", "val": ": Tensor"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **timestep** (`float`) --
  The current timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a
  `~schedulers.scheduling_consistency_models.ConsistencyDecoderSchedulerOutput` or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>`~schedulers.scheduling_consistency_models.ConsistencyDecoderSchedulerOutput` or `tuple`</rettype><retdesc>If return_dict is `True`,
`~schedulers.scheduling_consistency_models.ConsistencyDecoderSchedulerOutput` is returned, otherwise
a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/consistency_decoder.md" />