# DDPMScheduler

[Denoising Diffusion Probabilistic Models](https://huggingface.co/papers/2006.11239) (DDPM) by Jonathan Ho, Ajay Jain and Pieter Abbeel proposes a diffusion based model of the same name. In the context of the 🤗 Diffusers library, DDPM refers to the discrete denoising scheduler from the paper as well as the pipeline.

The abstract from the paper is:

*We present high quality image synthesis results using diffusion probabilistic models, a class of latent variable models inspired by considerations from nonequilibrium thermodynamics. Our best results are obtained by training on a weighted variational bound designed according to a novel connection between diffusion probabilistic models and denoising score matching with Langevin dynamics, and our models naturally admit a progressive lossy decompression scheme that can be interpreted as a generalization of autoregressive decoding. On the unconditional CIFAR10 dataset, we obtain an Inception score of 9.46 and a state-of-the-art FID score of 3.17. On 256x256 LSUN, we obtain sample quality similar to ProgressiveGAN. Our implementation is available at [this https URL](https://github.com/hojonathanho/diffusion).*

## DDPMScheduler[[diffusers.DDPMScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.DDPMScheduler</name><anchor>diffusers.DDPMScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddpm.py#L129</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "beta_start", "val": ": float = 0.0001"}, {"name": "beta_end", "val": ": float = 0.02"}, {"name": "beta_schedule", "val": ": str = 'linear'"}, {"name": "trained_betas", "val": ": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"}, {"name": "variance_type", "val": ": str = 'fixed_small'"}, {"name": "clip_sample", "val": ": bool = True"}, {"name": "prediction_type", "val": ": str = 'epsilon'"}, {"name": "thresholding", "val": ": bool = False"}, {"name": "dynamic_thresholding_ratio", "val": ": float = 0.995"}, {"name": "clip_sample_range", "val": ": float = 1.0"}, {"name": "sample_max_value", "val": ": float = 1.0"}, {"name": "timestep_spacing", "val": ": str = 'leading'"}, {"name": "steps_offset", "val": ": int = 0"}, {"name": "rescale_betas_zero_snr", "val": ": bool = False"}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **beta_start** (`float`, defaults to 0.0001) --
  The starting `beta` value of inference.
- **beta_end** (`float`, defaults to 0.02) --
  The final `beta` value.
- **beta_schedule** (`str`, defaults to `"linear"`) --
  The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
  `linear`, `scaled_linear`, `squaredcos_cap_v2`, or `sigmoid`.
- **trained_betas** (`np.ndarray`, *optional*) --
  An array of betas to pass directly to the constructor without using `beta_start` and `beta_end`.
- **variance_type** (`str`, defaults to `"fixed_small"`) --
  Clip the variance when adding noise to the denoised sample. Choose from `fixed_small`, `fixed_small_log`,
  `fixed_large`, `fixed_large_log`, `learned` or `learned_range`.
- **clip_sample** (`bool`, defaults to `True`) --
  Clip the predicted sample for numerical stability.
- **clip_sample_range** (`float`, defaults to 1.0) --
  The maximum magnitude for sample clipping. Valid only when `clip_sample=True`.
- **prediction_type** (`str`, defaults to `epsilon`, *optional*) --
  Prediction type of the scheduler function; can be `epsilon` (predicts the noise of the diffusion process),
  `sample` (directly predicts the noisy sample`) or `v_prediction` (see section 2.4 of [Imagen
  Video](https://imagen.research.google/video/paper.pdf) paper).
- **thresholding** (`bool`, defaults to `False`) --
  Whether to use the "dynamic thresholding" method. This is unsuitable for latent-space diffusion models such
  as Stable Diffusion.
- **dynamic_thresholding_ratio** (`float`, defaults to 0.995) --
  The ratio for the dynamic thresholding method. Valid only when `thresholding=True`.
- **sample_max_value** (`float`, defaults to 1.0) --
  The threshold value for dynamic thresholding. Valid only when `thresholding=True`.
- **timestep_spacing** (`str`, defaults to `"leading"`) --
  The way the timesteps should be scaled. Refer to Table 2 of the [Common Diffusion Noise Schedules and
  Sample Steps are Flawed](https://huggingface.co/papers/2305.08891) for more information.
- **steps_offset** (`int`, defaults to 0) --
  An offset added to the inference steps, as required by some model families.
- **rescale_betas_zero_snr** (`bool`, defaults to `False`) --
  Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
  dark samples instead of limiting it to samples with medium brightness. Loosely related to
  [`--offset_noise`](https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506).</paramsdesc><paramgroups>0</paramgroups></docstring>

`DDPMScheduler` explores the connections between denoising score matching and Langevin dynamics sampling.

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.DDPMScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddpm.py#L234</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.DDPMScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddpm.py#L251</source><parameters>[{"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}, {"name": "timesteps", "val": ": typing.Optional[typing.List[int]] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model. If used,
  `timesteps` must be `None`.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.
- **timesteps** (`List[int]`, *optional*) --
  Custom timesteps used to support arbitrary spacing between timesteps. If `None`, then the default
  timestep spacing strategy of equal spacing between timesteps is used. If `timesteps` is passed,
  `num_inference_steps` must be `None`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.DDPMScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddpm.py#L398</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": int"}, {"name": "sample", "val": ": Tensor"}, {"name": "generator", "val": " = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **timestep** (`float`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a [DDPMSchedulerOutput](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput) or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>[DDPMSchedulerOutput](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput) or `tuple`</rettype><retdesc>If return_dict is `True`, [DDPMSchedulerOutput](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput) is returned, otherwise a
tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div></div>

## DDPMSchedulerOutput[[diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput</name><anchor>diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddpm.py#L31</source><parameters>[{"name": "prev_sample", "val": ": Tensor"}, {"name": "pred_original_sample", "val": ": typing.Optional[torch.Tensor] = None"}]</parameters><paramsdesc>- **prev_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  Computed sample `(x_{t-1})` of previous timestep. `prev_sample` should be used as next model input in the
  denoising loop.
- **pred_original_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  The predicted denoised sample `(x_{0})` based on the model output from the current timestep.
  `pred_original_sample` can be used to preview progress or for guidance.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for the scheduler's `step` function output.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/ddpm.md" />