import{s as $t,n as Yt,o as vt}from"../chunks/scheduler.e4ff9b64.js";import{S as Nt,i as Qt,e as a,s as n,c as o,h as Et,a as p,d as t,b as i,f as Ft,g as d,j as M,k as gt,l as Lt,m as s,n as c,t as J,o as U,p as y}from"../chunks/index.09f1bca0.js";import{C as Dt,H as m,E as At}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.a5156008.js";import{C as T}from"../chunks/CodeBlock.b05639b3.js";function Ht(Oe){let f,Sl,Bl,Fl,u,gl,r,$l,Z,lt="模块化Diffusers是一个快速构建灵活和可定制管道的框架。模块化Diffusers的核心是<code>ModularPipelineBlocks</code>，可以与其他块组合以适应新的工作流程。这些块被转换为<code>ModularPipeline</code>，一个开发者可以使用的友好用户界面。",Yl,w,et='本文档将向您展示如何使用模块化框架实现<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a>管道。',vl,b,Nl,I,tt="<code>ModularPipelineBlocks</code>是<em>定义</em>，指定管道中单个步骤的组件、输入、输出和计算逻辑。有四种类型的块。",Ql,j,st="<li><code>ModularPipelineBlocks</code>是最基本的单一步骤块。</li> <li><code>SequentialPipelineBlocks</code>是一个多块，线性组合其他块。一个块的输出是下一个块的输入。</li> <li><code>LoopSequentialPipelineBlocks</code>是一个多块，迭代运行，专为迭代工作流程设计。</li> <li><code>AutoPipelineBlocks</code>是一个针对不同工作流程的块集合，它根据输入选择运行哪个块。它旨在方便地将多个工作流程打包到单个管道中。</li>",El,C,nt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a>是一个图像到图像的工作流程。从<code>IMAGE2IMAGE_BLOCKS</code>预设开始，这是一个用于图像到图像生成的<code>ModularPipelineBlocks</code>集合。',Ll,G,Dl,R,Al,_,it="模块化Diffusers使用<em>状态</em>在块之间通信数据。有两种类型的状态。",Hl,W,at="<li><code>PipelineState</code>是一个全局状态，可用于跟踪所有块的所有输入和输出。</li> <li><code>BlockState</code>是<code>PipelineState</code>中相关变量的局部视图，用于单个块。</li>",zl,X,xl,h,pt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> 与标准的图像到图像转换在其 <code>prepare_latents</code> 和 <code>denoise</code> 块上有所不同。所有其他块都可以重用，但你需要修改这两个。',ql,k,Mt="通过复制和修改现有的块，为 <code>prepare_latents</code> 和 <code>denoise</code> 创建占位符 <code>ModularPipelineBlocks</code>。",Pl,B,ot="打印 <code>denoise</code> 块，可以看到它由 <code>LoopSequentialPipelineBlocks</code> 组成，包含三个子块，<code>before_denoiser</code>、<code>denoiser</code> 和 <code>after_denoiser</code>。只需要修改 <code>before_denoiser</code> 子块，根据变化图为去噪器准备潜在输入。",Kl,V,Ol,S,dt="用新的 <code>SDXLDiffDiffLoopBeforeDenoiser</code> 块替换 <code>StableDiffusionXLLoopBeforeDenoiser</code> 子块。",le,F,ee,g,te,$,ct="<code>prepare_latents</code> 块需要进行以下更改。",se,Y,Jt="<li>一个处理器来处理变化图</li> <li>一个新的 <code>inputs</code> 来接受用户提供的变化图，<code>timestep</code> 用于预计算所有潜在变量和 <code>num_inference_steps</code> 来创建更新图像区域的掩码</li> <li>更新 <code>__call__</code> 方法中的计算，用于处理变化图和创建掩码，并将其存储在 <code>BlockState</code> 中</li>",ne,v,ie,N,ae,Q,Ut="<code>before_denoiser</code> 子块需要进行以下更改。",pe,E,yt="<li>新的 <code>inputs</code> 以接受 <code>denoising_start</code> 参数，<code>original_latents</code> 和 <code>diffdiff_masks</code> 来自 <code>prepare_latents</code> 块</li> <li>更新 <code>__call__</code> 方法中的计算以应用 Differential Diffusion</li>",Me,L,oe,D,de,A,Tt="此时，您应该拥有创建 <code>ModularPipeline</code> 所需的所有块。",ce,H,mt="复制现有的 <code>IMAGE2IMAGE_BLOCKS</code> 预设，对于 <code>set_timesteps</code> 块，使用 <code>TEXT2IMAGE_BLOCKS</code> 中的 <code>set_timesteps</code>，因为 Differential Diffusion 不需要 <code>strength</code> 参数。",Je,z,ft="将 <code>prepare_latents</code> 和 <code>denoise</code> 块设置为您刚刚修改的 <code>SDXLDiffDiffPrepareLatentsStep</code> 和 <code>SDXLDiffDiffDenoiseStep</code> 块。",Ue,x,ut="调用 <code>SequentialPipelineBlocks.from_blocks_dict</code> 在块上创建一个 <code>SequentialPipelineBlocks</code>。",ye,q,Te,P,me,K,rt="将 <code>SequentialPipelineBlocks</code> 转换为 <code>ModularPipeline</code>，使用 <code>ModularPipeline.init_pipeline</code> 方法。这会初始化从 <code>modular_model_index.json</code> 文件加载的预期组件。通过调用 <code>ModularPipeline.load_defau lt_components</code>。",fe,O,Zt="初始化<code>ComponentManager</code>时传入pipeline是一个好主意，以帮助管理不同的组件。一旦调用<code>load_components()</code>，组件就会被注册到<code>ComponentManager</code>中，并且可以在工作流之间共享。下面的例子使用<code>collection</code>参数为组件分配了一个<code>&quot;diffdiff&quot;</code>标签，以便更好地组织。",ue,ll,re,el,Ze,tl,wt="可以向<code>ModularPipeline</code>添加其他工作流以支持更多功能，而无需从头重写整个pipeline。",we,sl,bt="本节演示如何添加IP-Adapter或ControlNet。",be,nl,Ie,il,It="Stable Diffusion XL已经有一个预设的IP-Adapter块，你可以使用，并且不需要对现有的Differential Diffusion pipeline进行任何更改。",je,al,Ce,pl,jt="使用<code>sub_blocks.insert</code>方法将其插入到<code>ModularPipeline</code>中。下面的例子在位置<code>0</code>插入了<code>ip_adapter_block</code>。打印pipeline可以看到<code>ip_adapter_block</code>被添加了，并且它需要一个<code>ip_adapter_image</code>。这也向pipeline添加了两个组件，<code>image_encoder</code>和<code>feature_extractor</code>。",Ge,Ml,Re,ol,Ct="调用<code>~ModularPipeline.init_pipeline</code>来初始化一个<code>ModularPipeline</code>，并使用<code>load_components()</code>加载模型组件。加载并设置IP-Adapter以运行pipeline。",_e,dl,We,cl,Xe,Jl,Gt="Stable Diffusion XL 已经预设了一个可以立即使用的 ControlNet 块。",he,Ul,ke,yl,Rt="然而，它需要修改 <code>denoise</code> 块，因为那是 ControlNet 将控制信息注入到 UNet 的地方。",Be,Tl,_t="通过将 <code>StableDiffusionXLLoopDenoiser</code> 子块替换为 <code>StableDiffusionXLControlNetLoopDenoiser</code> 来修改 <code>denoise</code> 块。",Ve,ml,Se,fl,Wt="插入 <code>controlnet_input</code> 块并用新的 <code>controlnet_denoise_block</code> 替换 <code>denoise</code> 块。初始化一个 <code>ModularPipeline</code> 并将 <code>load_components()</code> 加载到其中。",Fe,ul,ge,rl,$e,Zl,Xt="差分扩散、IP-Adapter 和 ControlNet 工作流可以通过使用 <code>AutoPipelineBlocks</code> 捆绑到一个单一的 <code>ModularPipeline</code> 中。这允许根据输入如 <code>control_image</code> 或 <code>ip_adapter_image</code> 自动选择要运行的子块。如果没有传递这些输入，则默认为差分扩散。",Ye,wl,ht="使用 <code>block_trigger_inputs</code> 仅在提供 <code>control_image</code> 输入时运行 <code>SDXLDiffDiffControlNetDenoiseStep</code> 块。否则，使用 <code>SDXLDiffDiffDenoiseStep</code>。",ve,bl,Ne,Il,kt="添加 <code>ip_adapter</code> 和 <code>controlnet_input</code> 块。",Qe,jl,Ee,Cl,Bt="调用 <code>SequentialPipelineBlocks.from_blocks_dict</code> 来创建一个 <code>SequentialPipelineBlocks</code> 并创建一个 <code>ModularPipeline</code> 并加载模型组件以运行。",Le,Gl,De,Rl,Ae,_l,Vt="使用 <code>save_pretrained()</code> 将您的 <code>ModularPipeline</code> 添加到 Hub，并将 <code>push_to_hub</code> 参数设置为 <code>True</code>。",He,Wl,ze,Xl,St="其他用户可以使用 <code>from_pretrained()</code> 加载 <code>ModularPipeline</code>。",xe,hl,qe,kl,Pe,Vl,Ke;return u=new Dt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),r=new m({props:{title:"快速入门",local:"快速入门",headingTag:"h1"}}),b=new m({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h2"}}),G=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBSU1BR0UySU1BR0VfQkxPQ0tTJTIwJTNEJTIwSW5zZXJ0YWJsZURpY3QoJTVCJTBBJTIwJTIwJTIwJTIwKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMVGV4dEVuY29kZXJTdGVwKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJpbWFnZV9lbmNvZGVyJTIyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExWYWVFbmNvZGVyU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyaW5wdXQlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTElucHV0U3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyc2V0X3RpbWVzdGVwcyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1NldFRpbWVzdGVwc1N0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMnByZXBhcmVfbGF0ZW50cyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIycHJlcGFyZV9hZGRfY29uZCUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVBZGRpdGlvbmFsQ29uZGl0aW9uaW5nU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyZGVub2lzZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZVN0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMmRlY29kZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVjb2RlU3RlcCklMEElNUQp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS
IMAGE2IMAGE_BLOCKS = InsertableDict([
    (<span class="hljs-string">&quot;text_encoder&quot;</span>, StableDiffusionXLTextEncoderStep),
    (<span class="hljs-string">&quot;image_encoder&quot;</span>, StableDiffusionXLVaeEncoderStep),
    (<span class="hljs-string">&quot;input&quot;</span>, StableDiffusionXLInputStep),
    (<span class="hljs-string">&quot;set_timesteps&quot;</span>, StableDiffusionXLImg2ImgSetTimestepsStep),
    (<span class="hljs-string">&quot;prepare_latents&quot;</span>, StableDiffusionXLImg2ImgPrepareLatentsStep),
    (<span class="hljs-string">&quot;prepare_add_cond&quot;</span>, StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep),
    (<span class="hljs-string">&quot;denoise&quot;</span>, StableDiffusionXLDenoiseStep),
    (<span class="hljs-string">&quot;decode&quot;</span>, StableDiffusionXLDecodeStep)
])`,wrap:!1}}),R=new m({props:{title:"管道和块状态",local:"管道和块状态",headingTag:"h2"}}),X=new m({props:{title:"自定义块",local:"自定义块",headingTag:"h2"}}),V=new T({props:{code:"ZGVub2lzZV9ibG9ja3MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEKCklMEFwcmludChkZW5vaXNlX2Jsb2Nrcyk=",highlighted:`denoise_blocks = IMAGE2IMAGE_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-built_in">print</span>(denoise_blocks)`,wrap:!1}}),F=new T({props:{code:"JTIzJTIwJUU1JUE0JThEJUU1JTg4JUI2JUU3JThFJUIwJUU2JTlDJTg5JUU1JTlEJTk3JUU0JUJEJTlDJUU0JUI4JUJBJUU1JThEJUEwJUU0JUJEJThEJUU3JUFDJUE2JTBBY2xhc3MlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAoTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvcGllZCUyMGZyb20lMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQcmVwYXJlTGF0ZW50c1N0ZXAlMjAtJTIwd2lsbCUyMG1vZGlmeSUyMGxhdGVyJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwJUU0JUI4JThFJTIwU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUHJlcGFyZUxhdGVudHNTdGVwJTIwJUU3JTlCJUI4JUU1JTkwJThDJUU3JTlBJTg0JUU1JUFFJTlFJUU3JThFJUIwJTBBJTBBY2xhc3MlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcChTdGFibGVEaWZmdXNpb25YTERlbm9pc2VMb29wV3JhcHBlciklM0ElMEElMjAlMjAlMjAlMjBibG9ja19jbGFzc2VzJTIwJTNEJTIwJTVCU0RYTERpZmZEaWZmTG9vcEJlZm9yZURlbm9pc2VyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExMb29wRGVub2lzZXIlMkMlMjBTdGFibGVEaWZmdXNpb25YTExvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVE",highlighted:`<span class="hljs-comment"># 复制现有块作为占位符</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffPrepareLatentsStep</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLImg2ImgPrepareLatentsStep - will modify later&quot;&quot;&quot;</span>
    <span class="hljs-comment"># ... 与 StableDiffusionXLImg2ImgPrepareLatentsStep 相同的实现</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLLoopDenoiser, StableDiffusionXLLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]`,wrap:!1}}),g=new m({props:{title:"prepare_latents",local:"preparelatents",headingTag:"h3"}}),v=new T({props:{code:"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",highlighted:`class SDXLDiffDiffPrepareLatentsStep(ModularPipelineBlocks):
    @property
    def expected_components(self) -&gt; List[ComponentSpec]:
        return [
            ComponentSpec(&quot;vae&quot;, AutoencoderKL),
            ComponentSpec(&quot;scheduler&quot;, EulerDiscreteScheduler),
<span class="hljs-addition">+           ComponentSpec(&quot;mask_processor&quot;, VaeImageProcessor, config=FrozenDict({&quot;do_normalize&quot;: False, &quot;do_convert_grayscale&quot;: True}))</span>
        ]
    @property
    def inputs(self) -&gt; List[Tuple[str, Any]]:
        return [
            InputParam(&quot;generator&quot;),
<span class="hljs-addition">+           InputParam(&quot;diffdiff_map&quot;, required=True),</span>
<span class="hljs-deletion">-           InputParam(&quot;latent_timestep&quot;, required=True, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;timesteps&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;num_inference_steps&quot;, type_hint=int),</span>
        ]

    @property
    def intermediate_outputs(self) -&gt; List[OutputParam]:
        return [
<span class="hljs-addition">+           OutputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           OutputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]
    def __call__(self, components, state: PipelineState):
        # ... existing logic ...
<span class="hljs-addition">+       # Process change map and create masks</span>
<span class="hljs-addition">+       diffdiff_map = components.mask_processor.preprocess(block_state.diffdiff_map, height=latent_height, width=latent_width)</span>
<span class="hljs-addition">+       thresholds = torch.arange(block_state.num_inference_steps, dtype=diffdiff_map.dtype) / block_state.num_inference_steps</span>
<span class="hljs-addition">+       block_state.diffdiff_masks = diffdiff_map &gt; (thresholds + (block_state.denoising_start or 0))</span>
<span class="hljs-addition">+       block_state.original_latents = block_state.latents</span>`,wrap:!1}}),N=new m({props:{title:"去噪",local:"去噪",headingTag:"h3"}}),L=new T({props:{code:"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",highlighted:`class SDXLDiffDiffLoopBeforeDenoiser(ModularPipelineBlocks):
    @property
    def description(self) -&gt; str:
        return (
            &quot;Step within the denoising loop for differential diffusion that prepare the latent input for the denoiser&quot;
        )

    @property
    def inputs(self) -&gt; List[str]:
        return [
            InputParam(&quot;latents&quot;, required=True, type_hint=torch.Tensor),
<span class="hljs-addition">+           InputParam(&quot;denoising_start&quot;),</span>
<span class="hljs-addition">+           InputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, block_state, i, t):
<span class="hljs-addition">+       # Apply differential diffusion logic</span>
<span class="hljs-addition">+       if i == 0 and block_state.denoising_start is None:</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[:1]</span>
<span class="hljs-addition">+       else:</span>
<span class="hljs-addition">+           block_state.mask = block_state.diffdiff_masks[i].unsqueeze(0).unsqueeze(1)</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[i] * block_state.mask + block_state.latents * (1 - block_state.mask)</span>

        # ... rest of existing logic ...`,wrap:!1}}),D=new m({props:{title:"组装块",local:"组装块",headingTag:"h2"}}),q=new T({props:{code:"RElGRkRJRkZfQkxPQ0tTJTIwJTNEJTIwSU1BR0UySU1BR0VfQkxPQ0tTLmNvcHkoKSUwQURJRkZESUZGX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAlMEElMEFkZF9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9CTE9DS1MpJTBBcHJpbnQoZGRfYmxvY2tzKQ==",highlighted:`DIFFDIFF_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffDenoiseStep

dd_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_BLOCKS)
<span class="hljs-built_in">print</span>(dd_blocks)`,wrap:!1}}),P=new m({props:{title:"ModularPipeline",local:"modularpipeline",headingTag:"h2"}}),ll=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudE1hbmFnZXIoKSUwQSUwQWRkX3BpcGVsaW5lJTIwJTNEJTIwZGRfYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbmV0cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ComponentsManager

components = ComponentManager()

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_componenets(torch_dtype=torch.float16)
dd_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),el=new m({props:{title:"添加工作流",local:"添加工作流",headingTag:"h2"}}),nl=new m({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h3"}}),al=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmVuY29kZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQSUwQWlwX2FkYXB0ZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.encoders <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep

ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()`,wrap:!1}}),Ml=new T({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrJTJDJTIwMCk=",highlighted:'dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)',wrap:!1}}),dl=new T({props:{code:"ZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9ibG9ja3MuaW5pdF9waXBlbGluZSglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkZF9waXBlbGluZS5sb2FkX2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRkX3BpcGVsaW5lLmxvYWRlci5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRlci5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX29yYW5nZS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9hZGFwdGVyX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZGlmZmRpZmZfbWFwJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMEFvdXRwdXQlM0QlMjJpbWFnZXMlMjIlMEEpJTVCMCU1RA==",highlighted:`dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline.loader.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
dd_pipeline.loader.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
dd_pipeline = dd_pipeline.to(device)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_orange.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    ip_adapter_image=ip_adapter_image,
    diffdiff_map=mask,
    image=image,

output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),cl=new m({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Ul=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLm1vZHVsYXJfYmxvY2tzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvQ29udHJvbE5ldElucHV0U3RlcCUwQSUwQWNvbnRyb2xfaW5wdXRfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sTmV0SW5wdXRTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks <span class="hljs-keyword">import</span> StableDiffusionXLAutoControlNetInputStep

control_input_block = StableDiffusionXLAutoControlNetInputStep()`,wrap:!1}}),ml=new T({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldExvb3BEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVEJTBBJTBBY29udHJvbG5ldF9kZW5vaXNlX2Jsb2NrJTIwJTNEJTIwU0RYTERpZmZEaWZmQ29udHJvbE5ldERlbm9pc2VTdGVwKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffControlNetDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLControlNetLoopDenoiser, StableDiffusionXLDenoiseLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]

controlnet_denoise_block = SDXLDiffDiffControlNetDenoiseStep()`,wrap:!1}}),ul=new T({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmNvbnRyb2xuZXRfaW5wdXQlMjIlMkMlMjBjb250cm9sX2lucHV0X2Jsb2NrJTJDJTIwNyklMEFkZF9ibG9ja3Muc3ViX2Jsb2NrcyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBjb250cm9sbmV0X2Rlbm9pc2VfYmxvY2slMEElMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX3RvbWF0b19jYW5ueS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBkaWZmZGlmZl9tYXAlM0RtYXNrJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiUwQSklNUIwJTVE",highlighted:`dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>, control_input_block, <span class="hljs-number">7</span>)
dd_blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_denoise_block

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline = dd_pipeline.to(device)

control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_tomato_canny.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    control_image=control_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),rl=new m({props:{title:"AutoPipelineBlocks",local:"autopipelineblocks",headingTag:"h3"}}),bl=new T({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAlMkMlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcCU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyY29udHIlMEFvbG5ldF9kZW5vaXNlJTIyJTJDJTIwJTIyZGVub2lzZSUyMiU1RCUwQWJsb2NrX3RyaWdnZXJfaW5wdXRzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9jb25kJTIyJTJDJTIwTm9uZSU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffAutoDenoiseStep</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    block_classes = [SDXLDiffDiffControlNetDenoiseStep, SDXLDiffDiffDenoiseStep]
    block_names = [<span class="hljs-string">&quot;contr
olnet_denoise&quot;</span>, <span class="hljs-string">&quot;denoise&quot;</span>]
block_trigger_inputs = [<span class="hljs-string">&quot;controlnet_cond&quot;</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),jl=new T({props:{code:"RElGRkRJRkZfQVVUT19CTE9DS1MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MuY29weSgpJTBBRElGRkRJRkZfQVVUT19CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUy5pbnNlcnQoJTIyaXBfYWRhcHRlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQXV0b0lQQWRhcHRlclN0ZXAlMkMlMjAwKSUwQURJRkZESUZGX0FVVE9fQkxPQ0tTLmluc2VydCglMjJjb250cm9sbmV0X2lucHV0JTIyJTJDU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0QXV0b0lucHV0JTJDJTIwNyk=",highlighted:`DIFFDIFF_AUTO_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffAutoDenoiseStep
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>,StableDiffusionXLControlNetAutoInput, <span class="hljs-number">7</span>)`,wrap:!1}}),Gl=new T({props:{code:"ZGRfYXV0b19ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9BVVRPX0JMT0NLUyklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2F1dG9fYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb2xsZWN0aW9uJTNEJTIyZGlmZmRpZmYlMjIpJTBBZGRfcGlwZWxpbmUubG9hZF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`dd_auto_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_AUTO_BLOCKS)
dd_pipeline = dd_auto_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),Rl=new m({props:{title:"分享",local:"分享",headingTag:"h2"}}),Wl=new T({props:{code:"ZGRfcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRnRlc3RfbW9kdWxhcl9kb2MlMjIlMkMlMjBwdXNoX3RvX2h1YiUzRFRydWUp",highlighted:'dd_pipeline.save_pretrained(<span class="hljs-string">&quot;YiYiXu/test_modular_doc&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)',wrap:!1}}),hl=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTW9kdWxhclBpcGVsaW5lJTJDJTIwQ29tcG9uZW50c01hbmFnZXIlMEElMEFjb21wb25lbnRzJTIwJTNEJTIwQ29tcG9uZW50c01hbmFnZXIoKSUwQSUwQWRpZmZkaWZmX3BpcGVsaW5lJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRpZmZkaWZmX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager

components = ComponentsManager()

diffdiff_pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
diffdiff_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),kl=new At({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/modular_diffusers/quickstart.md"}}),{c(){f=a("meta"),Sl=n(),Bl=a("p"),Fl=n(),o(u.$$.fragment),gl=n(),o(r.$$.fragment),$l=n(),Z=a("p"),Z.innerHTML=lt,Yl=n(),w=a("p"),w.innerHTML=et,vl=n(),o(b.$$.fragment),Nl=n(),I=a("p"),I.innerHTML=tt,Ql=n(),j=a("ul"),j.innerHTML=st,El=n(),C=a("p"),C.innerHTML=nt,Ll=n(),o(G.$$.fragment),Dl=n(),o(R.$$.fragment),Al=n(),_=a("p"),_.innerHTML=it,Hl=n(),W=a("ul"),W.innerHTML=at,zl=n(),o(X.$$.fragment),xl=n(),h=a("p"),h.innerHTML=pt,ql=n(),k=a("p"),k.innerHTML=Mt,Pl=n(),B=a("p"),B.innerHTML=ot,Kl=n(),o(V.$$.fragment),Ol=n(),S=a("p"),S.innerHTML=dt,le=n(),o(F.$$.fragment),ee=n(),o(g.$$.fragment),te=n(),$=a("p"),$.innerHTML=ct,se=n(),Y=a("ul"),Y.innerHTML=Jt,ne=n(),o(v.$$.fragment),ie=n(),o(N.$$.fragment),ae=n(),Q=a("p"),Q.innerHTML=Ut,pe=n(),E=a("ul"),E.innerHTML=yt,Me=n(),o(L.$$.fragment),oe=n(),o(D.$$.fragment),de=n(),A=a("p"),A.innerHTML=Tt,ce=n(),H=a("p"),H.innerHTML=mt,Je=n(),z=a("p"),z.innerHTML=ft,Ue=n(),x=a("p"),x.innerHTML=ut,ye=n(),o(q.$$.fragment),Te=n(),o(P.$$.fragment),me=n(),K=a("p"),K.innerHTML=rt,fe=n(),O=a("p"),O.innerHTML=Zt,ue=n(),o(ll.$$.fragment),re=n(),o(el.$$.fragment),Ze=n(),tl=a("p"),tl.innerHTML=wt,we=n(),sl=a("p"),sl.textContent=bt,be=n(),o(nl.$$.fragment),Ie=n(),il=a("p"),il.textContent=It,je=n(),o(al.$$.fragment),Ce=n(),pl=a("p"),pl.innerHTML=jt,Ge=n(),o(Ml.$$.fragment),Re=n(),ol=a("p"),ol.innerHTML=Ct,_e=n(),o(dl.$$.fragment),We=n(),o(cl.$$.fragment),Xe=n(),Jl=a("p"),Jl.textContent=Gt,he=n(),o(Ul.$$.fragment),ke=n(),yl=a("p"),yl.innerHTML=Rt,Be=n(),Tl=a("p"),Tl.innerHTML=_t,Ve=n(),o(ml.$$.fragment),Se=n(),fl=a("p"),fl.innerHTML=Wt,Fe=n(),o(ul.$$.fragment),ge=n(),o(rl.$$.fragment),$e=n(),Zl=a("p"),Zl.innerHTML=Xt,Ye=n(),wl=a("p"),wl.innerHTML=ht,ve=n(),o(bl.$$.fragment),Ne=n(),Il=a("p"),Il.innerHTML=kt,Qe=n(),o(jl.$$.fragment),Ee=n(),Cl=a("p"),Cl.innerHTML=Bt,Le=n(),o(Gl.$$.fragment),De=n(),o(Rl.$$.fragment),Ae=n(),_l=a("p"),_l.innerHTML=Vt,He=n(),o(Wl.$$.fragment),ze=n(),Xl=a("p"),Xl.innerHTML=St,xe=n(),o(hl.$$.fragment),qe=n(),o(kl.$$.fragment),Pe=n(),Vl=a("p"),this.h()},l(l){const e=Et("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(t),Sl=i(l),Bl=p(l,"P",{}),Ft(Bl).forEach(t),Fl=i(l),d(u.$$.fragment,l),gl=i(l),d(r.$$.fragment,l),$l=i(l),Z=p(l,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-ucrd7f"&&(Z.innerHTML=lt),Yl=i(l),w=p(l,"P",{"data-svelte-h":!0}),M(w)!=="svelte-19clyan"&&(w.innerHTML=et),vl=i(l),d(b.$$.fragment,l),Nl=i(l),I=p(l,"P",{"data-svelte-h":!0}),M(I)!=="svelte-y1aqdp"&&(I.innerHTML=tt),Ql=i(l),j=p(l,"UL",{"data-svelte-h":!0}),M(j)!=="svelte-18g1w9a"&&(j.innerHTML=st),El=i(l),C=p(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-iezqb2"&&(C.innerHTML=nt),Ll=i(l),d(G.$$.fragment,l),Dl=i(l),d(R.$$.fragment,l),Al=i(l),_=p(l,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1otv6ps"&&(_.innerHTML=it),Hl=i(l),W=p(l,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-si6ftt"&&(W.innerHTML=at),zl=i(l),d(X.$$.fragment,l),xl=i(l),h=p(l,"P",{"data-svelte-h":!0}),M(h)!=="svelte-16qzi9k"&&(h.innerHTML=pt),ql=i(l),k=p(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1k439co"&&(k.innerHTML=Mt),Pl=i(l),B=p(l,"P",{"data-svelte-h":!0}),M(B)!=="svelte-166t11t"&&(B.innerHTML=ot),Kl=i(l),d(V.$$.fragment,l),Ol=i(l),S=p(l,"P",{"data-svelte-h":!0}),M(S)!=="svelte-incjm4"&&(S.innerHTML=dt),le=i(l),d(F.$$.fragment,l),ee=i(l),d(g.$$.fragment,l),te=i(l),$=p(l,"P",{"data-svelte-h":!0}),M($)!=="svelte-hb8wge"&&($.innerHTML=ct),se=i(l),Y=p(l,"UL",{"data-svelte-h":!0}),M(Y)!=="svelte-1bfho3z"&&(Y.innerHTML=Jt),ne=i(l),d(v.$$.fragment,l),ie=i(l),d(N.$$.fragment,l),ae=i(l),Q=p(l,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1ynz8xa"&&(Q.innerHTML=Ut),pe=i(l),E=p(l,"UL",{"data-svelte-h":!0}),M(E)!=="svelte-1htu88p"&&(E.innerHTML=yt),Me=i(l),d(L.$$.fragment,l),oe=i(l),d(D.$$.fragment,l),de=i(l),A=p(l,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1km1h3v"&&(A.innerHTML=Tt),ce=i(l),H=p(l,"P",{"data-svelte-h":!0}),M(H)!=="svelte-y5ubni"&&(H.innerHTML=mt),Je=i(l),z=p(l,"P",{"data-svelte-h":!0}),M(z)!=="svelte-19jyxik"&&(z.innerHTML=ft),Ue=i(l),x=p(l,"P",{"data-svelte-h":!0}),M(x)!=="svelte-waxhub"&&(x.innerHTML=ut),ye=i(l),d(q.$$.fragment,l),Te=i(l),d(P.$$.fragment,l),me=i(l),K=p(l,"P",{"data-svelte-h":!0}),M(K)!=="svelte-16lygjc"&&(K.innerHTML=rt),fe=i(l),O=p(l,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1pzhpdm"&&(O.innerHTML=Zt),ue=i(l),d(ll.$$.fragment,l),re=i(l),d(el.$$.fragment,l),Ze=i(l),tl=p(l,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-c6u23w"&&(tl.innerHTML=wt),we=i(l),sl=p(l,"P",{"data-svelte-h":!0}),M(sl)!=="svelte-142sjmv"&&(sl.textContent=bt),be=i(l),d(nl.$$.fragment,l),Ie=i(l),il=p(l,"P",{"data-svelte-h":!0}),M(il)!=="svelte-5vsg4f"&&(il.textContent=It),je=i(l),d(al.$$.fragment,l),Ce=i(l),pl=p(l,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-y5o3kn"&&(pl.innerHTML=jt),Ge=i(l),d(Ml.$$.fragment,l),Re=i(l),ol=p(l,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-g5lfhr"&&(ol.innerHTML=Ct),_e=i(l),d(dl.$$.fragment,l),We=i(l),d(cl.$$.fragment,l),Xe=i(l),Jl=p(l,"P",{"data-svelte-h":!0}),M(Jl)!=="svelte-1rwsayd"&&(Jl.textContent=Gt),he=i(l),d(Ul.$$.fragment,l),ke=i(l),yl=p(l,"P",{"data-svelte-h":!0}),M(yl)!=="svelte-3tgsuz"&&(yl.innerHTML=Rt),Be=i(l),Tl=p(l,"P",{"data-svelte-h":!0}),M(Tl)!=="svelte-hilcpg"&&(Tl.innerHTML=_t),Ve=i(l),d(ml.$$.fragment,l),Se=i(l),fl=p(l,"P",{"data-svelte-h":!0}),M(fl)!=="svelte-h6ms15"&&(fl.innerHTML=Wt),Fe=i(l),d(ul.$$.fragment,l),ge=i(l),d(rl.$$.fragment,l),$e=i(l),Zl=p(l,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-leu4qu"&&(Zl.innerHTML=Xt),Ye=i(l),wl=p(l,"P",{"data-svelte-h":!0}),M(wl)!=="svelte-fep99f"&&(wl.innerHTML=ht),ve=i(l),d(bl.$$.fragment,l),Ne=i(l),Il=p(l,"P",{"data-svelte-h":!0}),M(Il)!=="svelte-12g6sja"&&(Il.innerHTML=kt),Qe=i(l),d(jl.$$.fragment,l),Ee=i(l),Cl=p(l,"P",{"data-svelte-h":!0}),M(Cl)!=="svelte-ccq5o3"&&(Cl.innerHTML=Bt),Le=i(l),d(Gl.$$.fragment,l),De=i(l),d(Rl.$$.fragment,l),Ae=i(l),_l=p(l,"P",{"data-svelte-h":!0}),M(_l)!=="svelte-133sy88"&&(_l.innerHTML=Vt),He=i(l),d(Wl.$$.fragment,l),ze=i(l),Xl=p(l,"P",{"data-svelte-h":!0}),M(Xl)!=="svelte-1nf3567"&&(Xl.innerHTML=St),xe=i(l),d(hl.$$.fragment,l),qe=i(l),d(kl.$$.fragment,l),Pe=i(l),Vl=p(l,"P",{}),Ft(Vl).forEach(t),this.h()},h(){gt(f,"name","hf:doc:metadata"),gt(f,"content",zt)},m(l,e){Lt(document.head,f),s(l,Sl,e),s(l,Bl,e),s(l,Fl,e),c(u,l,e),s(l,gl,e),c(r,l,e),s(l,$l,e),s(l,Z,e),s(l,Yl,e),s(l,w,e),s(l,vl,e),c(b,l,e),s(l,Nl,e),s(l,I,e),s(l,Ql,e),s(l,j,e),s(l,El,e),s(l,C,e),s(l,Ll,e),c(G,l,e),s(l,Dl,e),c(R,l,e),s(l,Al,e),s(l,_,e),s(l,Hl,e),s(l,W,e),s(l,zl,e),c(X,l,e),s(l,xl,e),s(l,h,e),s(l,ql,e),s(l,k,e),s(l,Pl,e),s(l,B,e),s(l,Kl,e),c(V,l,e),s(l,Ol,e),s(l,S,e),s(l,le,e),c(F,l,e),s(l,ee,e),c(g,l,e),s(l,te,e),s(l,$,e),s(l,se,e),s(l,Y,e),s(l,ne,e),c(v,l,e),s(l,ie,e),c(N,l,e),s(l,ae,e),s(l,Q,e),s(l,pe,e),s(l,E,e),s(l,Me,e),c(L,l,e),s(l,oe,e),c(D,l,e),s(l,de,e),s(l,A,e),s(l,ce,e),s(l,H,e),s(l,Je,e),s(l,z,e),s(l,Ue,e),s(l,x,e),s(l,ye,e),c(q,l,e),s(l,Te,e),c(P,l,e),s(l,me,e),s(l,K,e),s(l,fe,e),s(l,O,e),s(l,ue,e),c(ll,l,e),s(l,re,e),c(el,l,e),s(l,Ze,e),s(l,tl,e),s(l,we,e),s(l,sl,e),s(l,be,e),c(nl,l,e),s(l,Ie,e),s(l,il,e),s(l,je,e),c(al,l,e),s(l,Ce,e),s(l,pl,e),s(l,Ge,e),c(Ml,l,e),s(l,Re,e),s(l,ol,e),s(l,_e,e),c(dl,l,e),s(l,We,e),c(cl,l,e),s(l,Xe,e),s(l,Jl,e),s(l,he,e),c(Ul,l,e),s(l,ke,e),s(l,yl,e),s(l,Be,e),s(l,Tl,e),s(l,Ve,e),c(ml,l,e),s(l,Se,e),s(l,fl,e),s(l,Fe,e),c(ul,l,e),s(l,ge,e),c(rl,l,e),s(l,$e,e),s(l,Zl,e),s(l,Ye,e),s(l,wl,e),s(l,ve,e),c(bl,l,e),s(l,Ne,e),s(l,Il,e),s(l,Qe,e),c(jl,l,e),s(l,Ee,e),s(l,Cl,e),s(l,Le,e),c(Gl,l,e),s(l,De,e),c(Rl,l,e),s(l,Ae,e),s(l,_l,e),s(l,He,e),c(Wl,l,e),s(l,ze,e),s(l,Xl,e),s(l,xe,e),c(hl,l,e),s(l,qe,e),c(kl,l,e),s(l,Pe,e),s(l,Vl,e),Ke=!0},p:Yt,i(l){Ke||(J(u.$$.fragment,l),J(r.$$.fragment,l),J(b.$$.fragment,l),J(G.$$.fragment,l),J(R.$$.fragment,l),J(X.$$.fragment,l),J(V.$$.fragment,l),J(F.$$.fragment,l),J(g.$$.fragment,l),J(v.$$.fragment,l),J(N.$$.fragment,l),J(L.$$.fragment,l),J(D.$$.fragment,l),J(q.$$.fragment,l),J(P.$$.fragment,l),J(ll.$$.fragment,l),J(el.$$.fragment,l),J(nl.$$.fragment,l),J(al.$$.fragment,l),J(Ml.$$.fragment,l),J(dl.$$.fragment,l),J(cl.$$.fragment,l),J(Ul.$$.fragment,l),J(ml.$$.fragment,l),J(ul.$$.fragment,l),J(rl.$$.fragment,l),J(bl.$$.fragment,l),J(jl.$$.fragment,l),J(Gl.$$.fragment,l),J(Rl.$$.fragment,l),J(Wl.$$.fragment,l),J(hl.$$.fragment,l),J(kl.$$.fragment,l),Ke=!0)},o(l){U(u.$$.fragment,l),U(r.$$.fragment,l),U(b.$$.fragment,l),U(G.$$.fragment,l),U(R.$$.fragment,l),U(X.$$.fragment,l),U(V.$$.fragment,l),U(F.$$.fragment,l),U(g.$$.fragment,l),U(v.$$.fragment,l),U(N.$$.fragment,l),U(L.$$.fragment,l),U(D.$$.fragment,l),U(q.$$.fragment,l),U(P.$$.fragment,l),U(ll.$$.fragment,l),U(el.$$.fragment,l),U(nl.$$.fragment,l),U(al.$$.fragment,l),U(Ml.$$.fragment,l),U(dl.$$.fragment,l),U(cl.$$.fragment,l),U(Ul.$$.fragment,l),U(ml.$$.fragment,l),U(ul.$$.fragment,l),U(rl.$$.fragment,l),U(bl.$$.fragment,l),U(jl.$$.fragment,l),U(Gl.$$.fragment,l),U(Rl.$$.fragment,l),U(Wl.$$.fragment,l),U(hl.$$.fragment,l),U(kl.$$.fragment,l),Ke=!1},d(l){l&&(t(Sl),t(Bl),t(Fl),t(gl),t($l),t(Z),t(Yl),t(w),t(vl),t(Nl),t(I),t(Ql),t(j),t(El),t(C),t(Ll),t(Dl),t(Al),t(_),t(Hl),t(W),t(zl),t(xl),t(h),t(ql),t(k),t(Pl),t(B),t(Kl),t(Ol),t(S),t(le),t(ee),t(te),t($),t(se),t(Y),t(ne),t(ie),t(ae),t(Q),t(pe),t(E),t(Me),t(oe),t(de),t(A),t(ce),t(H),t(Je),t(z),t(Ue),t(x),t(ye),t(Te),t(me),t(K),t(fe),t(O),t(ue),t(re),t(Ze),t(tl),t(we),t(sl),t(be),t(Ie),t(il),t(je),t(Ce),t(pl),t(Ge),t(Re),t(ol),t(_e),t(We),t(Xe),t(Jl),t(he),t(ke),t(yl),t(Be),t(Tl),t(Ve),t(Se),t(fl),t(Fe),t(ge),t($e),t(Zl),t(Ye),t(wl),t(ve),t(Ne),t(Il),t(Qe),t(Ee),t(Cl),t(Le),t(De),t(Ae),t(_l),t(He),t(ze),t(Xl),t(xe),t(qe),t(Pe),t(Vl)),t(f),y(u,l),y(r,l),y(b,l),y(G,l),y(R,l),y(X,l),y(V,l),y(F,l),y(g,l),y(v,l),y(N,l),y(L,l),y(D,l),y(q,l),y(P,l),y(ll,l),y(el,l),y(nl,l),y(al,l),y(Ml,l),y(dl,l),y(cl,l),y(Ul,l),y(ml,l),y(ul,l),y(rl,l),y(bl,l),y(jl,l),y(Gl,l),y(Rl,l),y(Wl,l),y(hl,l),y(kl,l)}}}const zt='{"title":"快速入门","local":"快速入门","sections":[{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[],"depth":2},{"title":"管道和块状态","local":"管道和块状态","sections":[],"depth":2},{"title":"自定义块","local":"自定义块","sections":[{"title":"prepare_latents","local":"preparelatents","sections":[],"depth":3},{"title":"去噪","local":"去噪","sections":[],"depth":3}],"depth":2},{"title":"组装块","local":"组装块","sections":[],"depth":2},{"title":"ModularPipeline","local":"modularpipeline","sections":[],"depth":2},{"title":"添加工作流","local":"添加工作流","sections":[{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"AutoPipelineBlocks","local":"autopipelineblocks","sections":[],"depth":3}],"depth":2},{"title":"分享","local":"分享","sections":[],"depth":2}],"depth":1}';function xt(Oe){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Nt{constructor(f){super(),Qt(this,f,xt,Ht,$t,{})}}export{ls as component};
