import{s as qs,f as Ss,n as Fs,o as Ys}from"../chunks/scheduler.f6319a2a.js";import{S as zs,i as Ps,g as a,s as o,r as M,A as Ls,h as i,f as l,c as n,j as As,u as p,x as r,k as U,y as Ds,a as s,v as u,d as c,t as d,w as y}from"../chunks/index.85aa684c.js";import{C as m}from"../chunks/CodeBlock.3400fc53.js";import{D as Ks}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as h,E as Os}from"../chunks/getInferenceSnippets.0233181f.js";function eo(Nl){let b,lt,et,st,f,ot,g,nt,C,El="Here, we’re going to see advanced tool usage.",at,w,Xl='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',it,v,rt,I,Sl="A tool is mostly a function that an LLM can use in an agentic system.",Mt,Z,Al="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",pt,B,ql="So it cannot be only a function. It should be a class.",ut,W,Fl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",ct,G,Yl="Here’s how it looks:",dt,k,yt,Q,zl='The custom tool subclasses <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',mt,H,Pl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',ht,R,Ll="And that’s all it needs to be used in an agent!",bt,_,Dl='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',wt,V,Kl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Tt,$,Jt,x,Ol='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',jt,N,Ut,E,es="For the push to Hub to work, your tool will need to respect some rules:",ft,X,ts='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',gt,S,ls='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',Ct,A,ss='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',vt,q,os=`Then you can load the tool with <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,It,F,Zt,Y,Bt,z,ns="Our <code>MCPClient</code> allows you to load tools from an MCP server, and gives you full control over the connection and tool management:",Wt,P,as="For stdio-based MCP servers:",Gt,L,kt,D,is="For Streamable HTTP-based MCP servers:",Qt,K,Ht,O,rs="You can also manually manage the connection lifecycle with the try…finally pattern:",Rt,ee,_t,te,Ms="You can also connect to multiple MCP servers at once by passing a list of server parameters:",Vt,le,$t,T,ps=`<p><strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:</p> <ul><li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li></ul>`,xt,se,Nt,oe,us='The latest <a href="https://modelcontextprotocol.io/specification/2025-06-18/server/tools#structured-content" rel="nofollow">MCP specifications (2025-06-18+)</a> include support for <code>outputSchema</code>, which enables tools to return structured data with defined schemas. <code>smolagents</code> takes advantage of these structured output capabilities, allowing agents to work with tools that return complex data structures, JSON objects, and other structured formats. With this feature, the agent’s LLMs can “see” the structure of the tool output before calling a tool, enabling more intelligent and context-aware interactions.',Et,ne,cs="To enable structured output support, pass <code>structured_output=True</code> when initializing the <code>MCPClient</code>:",Xt,ae,St,ie,ds="When <code>structured_output=True</code>, the following features are enabled:",At,re,ys="<li><strong>Output Schema Support</strong>: Tools can define JSON schemas for their outputs</li> <li><strong>Structured Content Handling</strong>: Support for <code>structuredContent</code> in MCP responses</li> <li><strong>JSON Parsing</strong>: Automatic parsing of structured data from tool responses</li>",qt,Me,ms="Here’s an example using a weather MCP server with structured output:",Ft,pe,Yt,ue,hs="Agent using output schema and structured output:",zt,ce,Pt,de,bs="When structured output is enabled, the <code>CodeAgent</code> system prompt is enhanced to include JSON schema information for tools, helping the agent understand the expected structure of tool outputs and access the data appropriately.",Lt,ye,ws="<strong>Backwards Compatibility</strong>: The <code>structured_output</code> parameter currently defaults to <code>False</code> to maintain backwards compatibility. Existing code will continue to work without changes, receiving simple text outputs as before.",Dt,me,Ts="<strong>Future Change</strong>: In a future release, the default value of <code>structured_output</code> will change from <code>False</code> to <code>True</code>. It is recommended to explicitly set <code>structured_output=True</code> to opt into the enhanced functionality, which provides better tool output handling and improved agent performance. Use <code>structured_output=False</code> only if you specifically need to maintain the current text-only behavior.",Kt,he,Ot,be,Js='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',el,we,js='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',tl,Te,Us='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',ll,Je,sl,je,fs="And voilà, here’s your image! 🏖️",ol,Ke,gs,nl,Ue,Cs="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",al,fe,il,ge,rl,Oe,vs,Ml,Ce,Is="How cool is this? 🤩",pl,ve,ul,Ie,Zs=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,cl,Ze,Bs=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,dl,Be,yl,We,ml,Ge,Ws="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",hl,ke,Gs="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",bl,Qe,wl,He,ks="Now we can leverage the new tool:",Tl,Re,Jl,J,Qs="<p>Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.</p>",jl,_e,Ul,Ve,Hs='You can leverage tool collections by using <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',fl,$e,gl,xe,Rs='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Cl,Ne,_s='The MCP servers tools can be loaded with <a href="/docs/smolagents/v1.22.0/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',vl,j,Vs=`<p><strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:</p> <ul><li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li></ul>`,Il,Ee,$s="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Zl,Xe,Bl,Se,xs="To enable structured output support with ToolCollection, add the <code>structured_output=True</code> parameter:",Wl,Ae,Gl,qe,Ns="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",kl,Fe,Ql,Ye,Hl,ze,Es=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,Rl,Pe,_l,Le,Xs="To speed up the start, tools are loaded only if called by the agent.",Vl,De,$l,tt,xl;return f=new h({props:{title:"Tools",local:"tools",headingTag:"h1"}}),g=new Ks({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),v=new h({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),k=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),$=new h({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),N=new m({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),F=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new h({props:{title:"Use tools from an MCP server",local:"use-tools-from-an-mcp-server",headingTag:"h3"}}),L=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),K=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ee=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),le=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),se=new h({props:{title:"Structured Output and Output Schema Support",local:"structured-output-and-output-schema-support",headingTag:"h4"}}),ae=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBFbmFibGUlMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTIwc3VwcG9ydCUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBQYXJpcyUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Enable structured output support</span>
<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Get weather information for Paris&quot;</span>)`,wrap:!1}}),pe=new m({props:{code:"JTIzJTIwZGVtbyUyRndlYXRoZXIucHklMjAtJTIwRXhhbXBsZSUyME1DUCUyMHNlcnZlciUyMHdpdGglMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTBBZnJvbSUyMHB5ZGFudGljJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTJDJTIwRmllbGQlMEFmcm9tJTIwbWNwLnNlcnZlci5mYXN0bWNwJTIwaW1wb3J0JTIwRmFzdE1DUCUwQSUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyV2VhdGhlciUyMFNlcnZpY2UlMjIpJTBBJTBBY2xhc3MlMjBXZWF0aGVySW5mbyhCYXNlTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0ElMjBzdHIlMjAlM0QlMjBGaWVsZChkZXNjcmlwdGlvbiUzRCUyMlRoZSUyMGxvY2F0aW9uJTIwbmFtZSUyMiklMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMGZsb2F0JTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJUZW1wZXJhdHVyZSUyMGluJTIwQ2Vsc2l1cyUyMiklMEElMjAlMjAlMjAlMjBjb25kaXRpb25zJTNBJTIwc3RyJTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJXZWF0aGVyJTIwY29uZGl0aW9ucyUyMiklMEElMjAlMjAlMjAlMjBodW1pZGl0eSUzQSUyMGludCUyMCUzRCUyMEZpZWxkKGRlc2NyaXB0aW9uJTNEJTIySHVtaWRpdHklMjBwZXJjZW50YWdlJTIyJTJDJTIwZ2UlM0QwJTJDJTIwbGUlM0QxMDApJTBBJTBBJTQwbWNwLnRvb2woJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmdldF93ZWF0aGVyX2luZm8lMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdldCUyMHdlYXRoZXIlMjBpbmZvcm1hdGlvbiUyMGZvciUyMGElMjBsb2NhdGlvbiUyMGFzJTIwc3RydWN0dXJlZCUyMGRhdGEuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlJTIwaXMlMjBlbmFibGVkJTIwYnklMjBkZWZhdWx0JTIwaW4lMjBGYXN0TUNQJTBBKSUwQWRlZiUyMGdldF93ZWF0aGVyX2luZm8oY2l0eSUzQSUyMHN0ciklMjAtJTNFJTIwV2VhdGhlckluZm8lM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBhJTIwY2l0eS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBXZWF0aGVySW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzRGNpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDIyLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25kaXRpb25zJTNEJTIycGFydGx5JTIwY2xvdWR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHVtaWRpdHklM0Q2NSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-comment"># demo/weather.py - Example MCP server with structured output</span>
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, Field
<span class="hljs-keyword">from</span> mcp.server.fastmcp <span class="hljs-keyword">import</span> FastMCP

mcp = FastMCP(<span class="hljs-string">&quot;Weather Service&quot;</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WeatherInfo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;The location name&quot;</span>)
    temperature: <span class="hljs-built_in">float</span> = Field(description=<span class="hljs-string">&quot;Temperature in Celsius&quot;</span>)
    conditions: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;Weather conditions&quot;</span>)
    humidity: <span class="hljs-built_in">int</span> = Field(description=<span class="hljs-string">&quot;Humidity percentage&quot;</span>, ge=<span class="hljs-number">0</span>, le=<span class="hljs-number">100</span>)

<span class="hljs-meta">@mcp.tool(<span class="hljs-params">
    name=<span class="hljs-string">&quot;get_weather_info&quot;</span>,
    description=<span class="hljs-string">&quot;Get weather information for a location as structured data.&quot;</span>,
    <span class="hljs-comment"># structured_output=True is enabled by default in FastMCP</span>
</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_info</span>(<span class="hljs-params">city: <span class="hljs-built_in">str</span></span>) -&gt; WeatherInfo:
    <span class="hljs-string">&quot;&quot;&quot;Get weather information for a city.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> WeatherInfo(
        location=city,
        temperature=<span class="hljs-number">22.5</span>,
        conditions=<span class="hljs-string">&quot;partly cloudy&quot;</span>,
        humidity=<span class="hljs-number">65</span>
    )`,wrap:!1}}),ce=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBVc2luZyUyMHRoZSUyMHdlYXRoZXIlMjBzZXJ2ZXIlMjB3aXRoJTIwc3RydWN0dXJlZCUyMG91dHB1dCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMmRlbW8lMkZ3ZWF0aGVyLnB5JTIyJTVEJTBBKSUwQSUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjB0ZW1wZXJhdHVyZSUyMGluJTIwVG9reW8lMjBpbiUyMEZhaHJlbmhlaXQlM0YlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Using the weather server with structured output</span>
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;python&quot;</span>,
    args=[<span class="hljs-string">&quot;demo/weather.py&quot;</span>]
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model)
    result = agent.run(<span class="hljs-string">&quot;What is the temperature in Tokyo in Fahrenheit?&quot;</span>)
    <span class="hljs-built_in">print</span>(result)`,wrap:!1}}),he=new h({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),Je=new m({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),fe=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),ge=new m({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),ve=new h({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),Be=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),We=new h({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),Qe=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),Re=new m({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),_e=new h({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),$e=new h({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),Xe=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ae=new m({props:{code:"d2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Fe=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ye=new h({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Pe=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),De=new Os({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){b=a("meta"),lt=o(),et=a("p"),st=o(),M(f.$$.fragment),ot=o(),M(g.$$.fragment),nt=o(),C=a("p"),C.textContent=El,at=o(),w=a("blockquote"),w.innerHTML=Xl,it=o(),M(v.$$.fragment),rt=o(),I=a("p"),I.textContent=Sl,Mt=o(),Z=a("p"),Z.textContent=Al,pt=o(),B=a("p"),B.textContent=ql,ut=o(),W=a("p"),W.textContent=Fl,ct=o(),G=a("p"),G.textContent=Yl,dt=o(),M(k.$$.fragment),yt=o(),Q=a("p"),Q.innerHTML=zl,mt=o(),H=a("ul"),H.innerHTML=Pl,ht=o(),R=a("p"),R.textContent=Ll,bt=o(),_=a("p"),_.innerHTML=Dl,wt=o(),V=a("p"),V.innerHTML=Kl,Tt=o(),M($.$$.fragment),Jt=o(),x=a("p"),x.innerHTML=Ol,jt=o(),M(N.$$.fragment),Ut=o(),E=a("p"),E.textContent=es,ft=o(),X=a("ul"),X.innerHTML=ts,gt=o(),S=a("p"),S.innerHTML=ls,Ct=o(),A=a("p"),A.innerHTML=ss,vt=o(),q=a("p"),q.innerHTML=os,It=o(),M(F.$$.fragment),Zt=o(),M(Y.$$.fragment),Bt=o(),z=a("p"),z.innerHTML=ns,Wt=o(),P=a("p"),P.textContent=as,Gt=o(),M(L.$$.fragment),kt=o(),D=a("p"),D.textContent=is,Qt=o(),M(K.$$.fragment),Ht=o(),O=a("p"),O.textContent=rs,Rt=o(),M(ee.$$.fragment),_t=o(),te=a("p"),te.textContent=Ms,Vt=o(),M(le.$$.fragment),$t=o(),T=a("blockquote"),T.innerHTML=ps,xt=o(),M(se.$$.fragment),Nt=o(),oe=a("p"),oe.innerHTML=us,Et=o(),ne=a("p"),ne.innerHTML=cs,Xt=o(),M(ae.$$.fragment),St=o(),ie=a("p"),ie.innerHTML=ds,At=o(),re=a("ul"),re.innerHTML=ys,qt=o(),Me=a("p"),Me.textContent=ms,Ft=o(),M(pe.$$.fragment),Yt=o(),ue=a("p"),ue.textContent=hs,zt=o(),M(ce.$$.fragment),Pt=o(),de=a("p"),de.innerHTML=bs,Lt=o(),ye=a("p"),ye.innerHTML=ws,Dt=o(),me=a("p"),me.innerHTML=Ts,Kt=o(),M(he.$$.fragment),Ot=o(),be=a("p"),be.innerHTML=Js,el=o(),we=a("p"),we.innerHTML=js,tl=o(),Te=a("p"),Te.innerHTML=Us,ll=o(),M(Je.$$.fragment),sl=o(),je=a("p"),je.textContent=fs,ol=o(),Ke=a("img"),nl=o(),Ue=a("p"),Ue.innerHTML=Cs,al=o(),M(fe.$$.fragment),il=o(),M(ge.$$.fragment),rl=o(),Oe=a("img"),Ml=o(),Ce=a("p"),Ce.textContent=Is,pl=o(),M(ve.$$.fragment),ul=o(),Ie=a("p"),Ie.innerHTML=Zs,cl=o(),Ze=a("p"),Ze.innerHTML=Bs,dl=o(),M(Be.$$.fragment),yl=o(),M(We.$$.fragment),ml=o(),Ge=a("p"),Ge.innerHTML=Ws,hl=o(),ke=a("p"),ke.innerHTML=Gs,bl=o(),M(Qe.$$.fragment),wl=o(),He=a("p"),He.textContent=ks,Tl=o(),M(Re.$$.fragment),Jl=o(),J=a("blockquote"),J.innerHTML=Qs,jl=o(),M(_e.$$.fragment),Ul=o(),Ve=a("p"),Ve.innerHTML=Hs,fl=o(),M($e.$$.fragment),gl=o(),xe=a("p"),xe.innerHTML=Rs,Cl=o(),Ne=a("p"),Ne.innerHTML=_s,vl=o(),j=a("blockquote"),j.innerHTML=Vs,Il=o(),Ee=a("p"),Ee.innerHTML=$s,Zl=o(),M(Xe.$$.fragment),Bl=o(),Se=a("p"),Se.innerHTML=xs,Wl=o(),M(Ae.$$.fragment),Gl=o(),qe=a("p"),qe.innerHTML=Ns,kl=o(),M(Fe.$$.fragment),Ql=o(),M(Ye.$$.fragment),Hl=o(),ze=a("p"),ze.textContent=Es,Rl=o(),M(Pe.$$.fragment),_l=o(),Le=a("p"),Le.textContent=Xs,Vl=o(),M(De.$$.fragment),$l=o(),tt=a("p"),this.h()},l(e){const t=Ls("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),lt=n(e),et=i(e,"P",{}),As(et).forEach(l),st=n(e),p(f.$$.fragment,e),ot=n(e),p(g.$$.fragment,e),nt=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-8951oz"&&(C.textContent=El),at=n(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1eo9frz"&&(w.innerHTML=Xl),it=n(e),p(v.$$.fragment,e),rt=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-50z9h0"&&(I.textContent=Sl),Mt=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1llqfcr"&&(Z.textContent=Al),pt=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-eilpgu"&&(B.textContent=ql),ut=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-suz7fy"&&(W.textContent=Fl),ct=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x18ywb"&&(G.textContent=Yl),dt=n(e),p(k.$$.fragment,e),yt=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qzmj9v"&&(Q.innerHTML=zl),mt=n(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-xqgwuf"&&(H.innerHTML=Pl),ht=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-220ayw"&&(R.textContent=Ll),bt=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1iflk3d"&&(_.innerHTML=Dl),wt=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1krqh9d"&&(V.innerHTML=Kl),Tt=n(e),p($.$$.fragment,e),Jt=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-rj3uls"&&(x.innerHTML=Ol),jt=n(e),p(N.$$.fragment,e),Ut=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hoocvd"&&(E.textContent=es),ft=n(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1rsn1dx"&&(X.innerHTML=ts),gt=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4n5s3c"&&(S.innerHTML=ls),Ct=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1knl8v8"&&(A.innerHTML=ss),vt=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1gkfpsw"&&(q.innerHTML=os),It=n(e),p(F.$$.fragment,e),Zt=n(e),p(Y.$$.fragment,e),Bt=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-eofyyc"&&(z.innerHTML=ns),Wt=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1en3ihe"&&(P.textContent=as),Gt=n(e),p(L.$$.fragment,e),kt=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ro6hjz"&&(D.textContent=is),Qt=n(e),p(K.$$.fragment,e),Ht=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1and4a8"&&(O.textContent=rs),Rt=n(e),p(ee.$$.fragment,e),_t=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-7q6kbi"&&(te.textContent=Ms),Vt=n(e),p(le.$$.fragment,e),$t=n(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-kwg2aw"&&(T.innerHTML=ps),xt=n(e),p(se.$$.fragment,e),Nt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ku5522"&&(oe.innerHTML=us),Et=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10wjig9"&&(ne.innerHTML=cs),Xt=n(e),p(ae.$$.fragment,e),St=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-rntkgd"&&(ie.innerHTML=ds),At=n(e),re=i(e,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-745dbc"&&(re.innerHTML=ys),qt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1e0rvyj"&&(Me.textContent=ms),Ft=n(e),p(pe.$$.fragment,e),Yt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-xhsky2"&&(ue.textContent=hs),zt=n(e),p(ce.$$.fragment,e),Pt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1dbhry6"&&(de.innerHTML=bs),Lt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-shyg20"&&(ye.innerHTML=ws),Dt=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-g6qlg5"&&(me.innerHTML=Ts),Kt=n(e),p(he.$$.fragment,e),Ot=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-i3yow1"&&(be.innerHTML=Js),el=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-17wa58l"&&(we.innerHTML=js),tl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1gucs20"&&(Te.innerHTML=Us),ll=n(e),p(Je.$$.fragment,e),sl=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-sgspwr"&&(je.textContent=fs),ol=n(e),Ke=i(e,"IMG",{src:!0}),nl=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1y8rl57"&&(Ue.innerHTML=Cs),al=n(e),p(fe.$$.fragment,e),il=n(e),p(ge.$$.fragment,e),rl=n(e),Oe=i(e,"IMG",{src:!0}),Ml=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-i5dtbz"&&(Ce.textContent=Is),pl=n(e),p(ve.$$.fragment,e),ul=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1rq40pf"&&(Ie.innerHTML=Zs),cl=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1g7jkvd"&&(Ze.innerHTML=Bs),dl=n(e),p(Be.$$.fragment,e),yl=n(e),p(We.$$.fragment,e),ml=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-69p3x"&&(Ge.innerHTML=Ws),hl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-ocb8u2"&&(ke.innerHTML=Gs),bl=n(e),p(Qe.$$.fragment,e),wl=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-o3ledg"&&(He.textContent=ks),Tl=n(e),p(Re.$$.fragment,e),Jl=n(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1xyjnip"&&(J.innerHTML=Qs),jl=n(e),p(_e.$$.fragment,e),Ul=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1s8kusu"&&(Ve.innerHTML=Hs),fl=n(e),p($e.$$.fragment,e),gl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1q39vf"&&(xe.innerHTML=Rs),Cl=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1a46mo"&&(Ne.innerHTML=_s),vl=n(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-kwg2aw"&&(j.innerHTML=Vs),Il=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-s0gh2b"&&(Ee.innerHTML=$s),Zl=n(e),p(Xe.$$.fragment,e),Bl=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-17z5hjh"&&(Se.innerHTML=xs),Wl=n(e),p(Ae.$$.fragment,e),Gl=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-j0i0xh"&&(qe.innerHTML=Ns),kl=n(e),p(Fe.$$.fragment,e),Ql=n(e),p(Ye.$$.fragment,e),Hl=n(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-qubpc6"&&(ze.textContent=Es),Rl=n(e),p(Pe.$$.fragment,e),_l=n(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-6r1jgt"&&(Le.textContent=Xs),Vl=n(e),p(De.$$.fragment,e),$l=n(e),tt=i(e,"P",{}),As(tt).forEach(l),this.h()},h(){U(b,"name","hf:doc:metadata"),U(b,"content",to),U(w,"class","tip"),U(T,"class","warning"),Ss(Ke.src,gs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||U(Ke,"src",gs),Ss(Oe.src,vs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||U(Oe,"src",vs),U(J,"class","tip"),U(j,"class","warning")},m(e,t){Ds(document.head,b),s(e,lt,t),s(e,et,t),s(e,st,t),u(f,e,t),s(e,ot,t),u(g,e,t),s(e,nt,t),s(e,C,t),s(e,at,t),s(e,w,t),s(e,it,t),u(v,e,t),s(e,rt,t),s(e,I,t),s(e,Mt,t),s(e,Z,t),s(e,pt,t),s(e,B,t),s(e,ut,t),s(e,W,t),s(e,ct,t),s(e,G,t),s(e,dt,t),u(k,e,t),s(e,yt,t),s(e,Q,t),s(e,mt,t),s(e,H,t),s(e,ht,t),s(e,R,t),s(e,bt,t),s(e,_,t),s(e,wt,t),s(e,V,t),s(e,Tt,t),u($,e,t),s(e,Jt,t),s(e,x,t),s(e,jt,t),u(N,e,t),s(e,Ut,t),s(e,E,t),s(e,ft,t),s(e,X,t),s(e,gt,t),s(e,S,t),s(e,Ct,t),s(e,A,t),s(e,vt,t),s(e,q,t),s(e,It,t),u(F,e,t),s(e,Zt,t),u(Y,e,t),s(e,Bt,t),s(e,z,t),s(e,Wt,t),s(e,P,t),s(e,Gt,t),u(L,e,t),s(e,kt,t),s(e,D,t),s(e,Qt,t),u(K,e,t),s(e,Ht,t),s(e,O,t),s(e,Rt,t),u(ee,e,t),s(e,_t,t),s(e,te,t),s(e,Vt,t),u(le,e,t),s(e,$t,t),s(e,T,t),s(e,xt,t),u(se,e,t),s(e,Nt,t),s(e,oe,t),s(e,Et,t),s(e,ne,t),s(e,Xt,t),u(ae,e,t),s(e,St,t),s(e,ie,t),s(e,At,t),s(e,re,t),s(e,qt,t),s(e,Me,t),s(e,Ft,t),u(pe,e,t),s(e,Yt,t),s(e,ue,t),s(e,zt,t),u(ce,e,t),s(e,Pt,t),s(e,de,t),s(e,Lt,t),s(e,ye,t),s(e,Dt,t),s(e,me,t),s(e,Kt,t),u(he,e,t),s(e,Ot,t),s(e,be,t),s(e,el,t),s(e,we,t),s(e,tl,t),s(e,Te,t),s(e,ll,t),u(Je,e,t),s(e,sl,t),s(e,je,t),s(e,ol,t),s(e,Ke,t),s(e,nl,t),s(e,Ue,t),s(e,al,t),u(fe,e,t),s(e,il,t),u(ge,e,t),s(e,rl,t),s(e,Oe,t),s(e,Ml,t),s(e,Ce,t),s(e,pl,t),u(ve,e,t),s(e,ul,t),s(e,Ie,t),s(e,cl,t),s(e,Ze,t),s(e,dl,t),u(Be,e,t),s(e,yl,t),u(We,e,t),s(e,ml,t),s(e,Ge,t),s(e,hl,t),s(e,ke,t),s(e,bl,t),u(Qe,e,t),s(e,wl,t),s(e,He,t),s(e,Tl,t),u(Re,e,t),s(e,Jl,t),s(e,J,t),s(e,jl,t),u(_e,e,t),s(e,Ul,t),s(e,Ve,t),s(e,fl,t),u($e,e,t),s(e,gl,t),s(e,xe,t),s(e,Cl,t),s(e,Ne,t),s(e,vl,t),s(e,j,t),s(e,Il,t),s(e,Ee,t),s(e,Zl,t),u(Xe,e,t),s(e,Bl,t),s(e,Se,t),s(e,Wl,t),u(Ae,e,t),s(e,Gl,t),s(e,qe,t),s(e,kl,t),u(Fe,e,t),s(e,Ql,t),u(Ye,e,t),s(e,Hl,t),s(e,ze,t),s(e,Rl,t),u(Pe,e,t),s(e,_l,t),s(e,Le,t),s(e,Vl,t),u(De,e,t),s(e,$l,t),s(e,tt,t),xl=!0},p:Fs,i(e){xl||(c(f.$$.fragment,e),c(g.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(F.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(Je.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(ve.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Qe.$$.fragment,e),c(Re.$$.fragment,e),c(_e.$$.fragment,e),c($e.$$.fragment,e),c(Xe.$$.fragment,e),c(Ae.$$.fragment,e),c(Fe.$$.fragment,e),c(Ye.$$.fragment,e),c(Pe.$$.fragment,e),c(De.$$.fragment,e),xl=!0)},o(e){d(f.$$.fragment,e),d(g.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d($.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(ve.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(Qe.$$.fragment,e),d(Re.$$.fragment,e),d(_e.$$.fragment,e),d($e.$$.fragment,e),d(Xe.$$.fragment,e),d(Ae.$$.fragment,e),d(Fe.$$.fragment,e),d(Ye.$$.fragment,e),d(Pe.$$.fragment,e),d(De.$$.fragment,e),xl=!1},d(e){e&&(l(lt),l(et),l(st),l(ot),l(nt),l(C),l(at),l(w),l(it),l(rt),l(I),l(Mt),l(Z),l(pt),l(B),l(ut),l(W),l(ct),l(G),l(dt),l(yt),l(Q),l(mt),l(H),l(ht),l(R),l(bt),l(_),l(wt),l(V),l(Tt),l(Jt),l(x),l(jt),l(Ut),l(E),l(ft),l(X),l(gt),l(S),l(Ct),l(A),l(vt),l(q),l(It),l(Zt),l(Bt),l(z),l(Wt),l(P),l(Gt),l(kt),l(D),l(Qt),l(Ht),l(O),l(Rt),l(_t),l(te),l(Vt),l($t),l(T),l(xt),l(Nt),l(oe),l(Et),l(ne),l(Xt),l(St),l(ie),l(At),l(re),l(qt),l(Me),l(Ft),l(Yt),l(ue),l(zt),l(Pt),l(de),l(Lt),l(ye),l(Dt),l(me),l(Kt),l(Ot),l(be),l(el),l(we),l(tl),l(Te),l(ll),l(sl),l(je),l(ol),l(Ke),l(nl),l(Ue),l(al),l(il),l(rl),l(Oe),l(Ml),l(Ce),l(pl),l(ul),l(Ie),l(cl),l(Ze),l(dl),l(yl),l(ml),l(Ge),l(hl),l(ke),l(bl),l(wl),l(He),l(Tl),l(Jl),l(J),l(jl),l(Ul),l(Ve),l(fl),l(gl),l(xe),l(Cl),l(Ne),l(vl),l(j),l(Il),l(Ee),l(Zl),l(Bl),l(Se),l(Wl),l(Gl),l(qe),l(kl),l(Ql),l(Hl),l(ze),l(Rl),l(_l),l(Le),l(Vl),l($l),l(tt)),l(b),y(f,e),y(g,e),y(v,e),y(k,e),y($,e),y(N,e),y(F,e),y(Y,e),y(L,e),y(K,e),y(ee,e),y(le,e),y(se,e),y(ae,e),y(pe,e),y(ce,e),y(he,e),y(Je,e),y(fe,e),y(ge,e),y(ve,e),y(Be,e),y(We,e),y(Qe,e),y(Re,e),y(_e,e),y($e,e),y(Xe,e),y(Ae,e),y(Fe,e),y(Ye,e),y(Pe,e),y(De,e)}}}const to='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Use tools from an MCP server","local":"use-tools-from-an-mcp-server","sections":[{"title":"Structured Output and Output Schema Support","local":"structured-output-and-output-schema-support","sections":[],"depth":4}],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4},{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4}],"depth":3}],"depth":1}';function lo(Nl){return Ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ro extends zs{constructor(b){super(),Ps(this,b,lo,eo,qs,{})}}export{ro as component};
