import{s as qt,n as Ht,o as Qt}from"../chunks/scheduler.f6319a2a.js";import{S as _t,i as St,g as i,s as n,r as p,A as zt,h as o,f as l,c as a,j as Nt,u as M,x as r,k as ct,y as Et,a as s,v as c,d as m,t as u,w as y}from"../chunks/index.85aa684c.js";import{C as ce}from"../chunks/CodeBlock.3400fc53.js";import{D as Yt}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as d,E as Ft}from"../chunks/getInferenceSnippets.0233181f.js";function Lt(mt){let w,ye,me,de,h,we,T,je,g,Je,b,ut="Retrieval-Augmented Generation (RAG) combines the power of large language models with external knowledge retrieval to produce more accurate, factual, and contextually relevant responses. At its core, RAG is about “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base.”",he,f,Te,U,yt="RAG offers several significant advantages over using vanilla or fine-tuned LLMs:",ge,I,dt="<li><strong>Factual Grounding</strong>: Reduces hallucinations by anchoring responses in retrieved facts</li> <li><strong>Domain Specialization</strong>: Provides domain-specific knowledge without model retraining</li> <li><strong>Knowledge Recency</strong>: Allows access to information beyond the model’s training cutoff</li> <li><strong>Transparency</strong>: Enables citation of sources for generated content</li> <li><strong>Control</strong>: Offers fine-grained control over what information the model can access</li>",be,v,fe,C,wt="Despite its benefits, traditional RAG approaches face several challenges:",Ue,B,jt="<li><strong>Single Retrieval Step</strong>: If the initial retrieval results are poor, the final generation will suffer</li> <li><strong>Query-Document Mismatch</strong>: User queries (often questions) may not match well with documents containing answers (often statements)</li> <li><strong>Limited Reasoning</strong>: Simple RAG pipelines don’t allow for multi-step reasoning or query refinement</li> <li><strong>Context Window Constraints</strong>: Retrieved documents must fit within the model’s context window</li>",Ie,A,ve,Z,Jt="We can overcome these limitations by implementing an <strong>Agentic RAG</strong> system - essentially an agent equipped with retrieval capabilities. This approach transforms RAG from a rigid pipeline into an interactive, reasoning-driven process.",Ce,G,Be,R,ht="An agent with retrieval tools can:",Ae,$,Tt="<li>✅ <strong>Formulate optimized queries</strong>: The agent can transform user questions into retrieval-friendly queries</li> <li>✅ <strong>Perform multiple retrievals</strong>: The agent can retrieve information iteratively as needed</li> <li>✅ <strong>Reason over retrieved content</strong>: The agent can analyze, synthesize, and draw conclusions from multiple sources</li> <li>✅ <strong>Self-critique and refine</strong>: The agent can evaluate retrieval results and adjust its approach</li>",Ze,W,gt="This approach naturally implements advanced RAG techniques:",Ge,k,bt='<li><strong>Hypothetical Document Embedding (HyDE)</strong>: Instead of using the user query directly, the agent formulates retrieval-optimized queries (<a href="https://huggingface.co/papers/2212.10496" rel="nofollow">paper reference</a>)</li> <li><strong>Self-Query Refinement</strong>: The agent can analyze initial results and perform follow-up retrievals with refined queries (<a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">technique reference</a>)</li>',Re,V,$e,x,ft="Let’s build a complete Agentic RAG system step by step. We’ll create an agent that can answer questions about the Hugging Face Transformers library by retrieving information from its documentation.",We,X,Ut='You can follow along with the code snippets below, or check out the full example in the smolagents GitHub repository: <a href="https://github.com/huggingface/smolagents/blob/main/examples/rag.py" rel="nofollow">examples/rag.py</a>.',ke,N,Ve,q,It="First, we need to install the necessary packages:",xe,H,Xe,Q,vt="If you plan to use Hugging Face’s Inference API, you’ll need to set up your API token:",Ne,_,qe,S,He,z,Ct="We’ll use a dataset containing Hugging Face documentation and prepare it for retrieval:",Qe,E,_e,Y,Se,F,Bt="Now we’ll create a custom tool that our agent can use to retrieve information from the knowledge base:",ze,L,Ee,j,At='<p>We’re using BM25, a lexical retrieval method, for simplicity and speed. For production systems, you might want to use semantic search with embeddings for better retrieval quality. Check the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> for high-quality embedding models.</p>',Ye,P,Fe,D,Zt="Now we’ll create an agent that can use our retriever tool to answer questions:",Le,K,Pe,J,Gt='<p>Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.</p>',De,O,Ke,ee,Rt="Let’s use our agent to answer a question about Transformers:",Oe,te,et,le,tt,se,$t="Agentic RAG systems can be applied to various use cases:",lt,ne,Wt="<li><strong>Technical Documentation Assistance</strong>: Help users navigate complex technical documentation</li> <li><strong>Research Paper Analysis</strong>: Extract and synthesize information from scientific papers</li> <li><strong>Legal Document Review</strong>: Find relevant precedents and clauses in legal documents</li> <li><strong>Customer Support</strong>: Answer questions based on product documentation and knowledge bases</li> <li><strong>Educational Tutoring</strong>: Provide explanations based on textbooks and learning materials</li>",st,ae,nt,ie,kt="Agentic RAG represents a significant advancement over traditional RAG pipelines. By combining the reasoning capabilities of LLM agents with the factual grounding of retrieval systems, we can build more powerful, flexible, and accurate information systems.",at,oe,Vt="The approach we’ve demonstrated:",it,re,xt="<li>Overcomes the limitations of single-step retrieval</li> <li>Enables more natural interactions with knowledge bases</li> <li>Provides a framework for continuous improvement through self-critique and query refinement</li>",ot,pe,Xt="As you build your own Agentic RAG systems, consider experimenting with different retrieval methods, agent architectures, and knowledge sources to find the optimal configuration for your specific use case.",rt,Me,pt,ue,Mt;return h=new d({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),T=new Yt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),g=new d({props:{title:"Introduction to Retrieval-Augmented Generation (RAG)",local:"introduction-to-retrieval-augmented-generation-rag",headingTag:"h2"}}),f=new d({props:{title:"Why Use RAG?",local:"why-use-rag",headingTag:"h3"}}),v=new d({props:{title:"Limitations of Traditional RAG",local:"limitations-of-traditional-rag",headingTag:"h3"}}),A=new d({props:{title:"Agentic RAG: A More Powerful Approach",local:"agentic-rag-a-more-powerful-approach",headingTag:"h2"}}),G=new d({props:{title:"Key Benefits of Agentic RAG",local:"key-benefits-of-agentic-rag",headingTag:"h3"}}),V=new d({props:{title:"Building an Agentic RAG System",local:"building-an-agentic-rag-system",headingTag:"h2"}}),N=new d({props:{title:"Step 1: Install Required Dependencies",local:"step-1-install-required-dependencies",headingTag:"h3"}}),H=new ce({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZGF0YXNldHMlMjBweXRob24tZG90ZW52JTIwcmFua19ibTI1JTIwLS11cGdyYWRl",highlighted:"pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade",wrap:!1}}),_=new ce({props:{code:"JTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwKGluY2x1ZGluZyUyMEhGX1RPS0VOKSUwQWZyb20lMjBkb3RlbnYlMjBpbXBvcnQlMjBsb2FkX2RvdGVudiUwQWxvYWRfZG90ZW52KCk=",highlighted:`<span class="hljs-comment"># Load environment variables (including HF_TOKEN)</span>
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),S=new d({props:{title:"Step 2: Prepare the Knowledge Base",local:"step-2-prepare-the-knowledge-base",headingTag:"h3"}}),E=new ce({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-comment"># Load the Hugging Face documentation dataset</span>
knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Filter to include only Transformers documentation</span>
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

<span class="hljs-comment"># Convert dataset entries to Document objects with metadata</span>
source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

<span class="hljs-comment"># Split documents into smaller chunks for better retrieval</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,  <span class="hljs-comment"># Characters per chunk</span>
    chunk_overlap=<span class="hljs-number">50</span>,  <span class="hljs-comment"># Overlap between chunks to maintain context</span>
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],  <span class="hljs-comment"># Priority order for splitting</span>
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Knowledge base prepared with <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs_processed)}</span> document chunks&quot;</span>)`,wrap:!1}}),Y=new d({props:{title:"Step 3: Create a Retriever Tool",local:"step-3-create-a-retriever-tool",headingTag:"h3"}}),L=new ce({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        <span class="hljs-comment"># Initialize the retriever with our processed documents</span>
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>  <span class="hljs-comment"># Return top 10 most relevant documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Execute the retrieval based on the provided query.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        <span class="hljs-comment"># Retrieve relevant documents</span>
        docs = self.retriever.invoke(query)

        <span class="hljs-comment"># Format the retrieved documents for readability</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Initialize our retriever tool with the processed documents</span>
retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),P=new d({props:{title:"Step 4: Create an Advanced Retrieval Agent",local:"step-4-create-an-advanced-retrieval-agent",headingTag:"h3"}}),K=new ce({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBvdXIlMjByZXRyaWV2ZXIlMjB0b29sJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMCUyMCUyMyUyMExpc3QlMjBvZiUyMHRvb2xzJTIwYXZhaWxhYmxlJTIwdG8lMjB0aGUlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMCUyMCUyMyUyMERlZmF1bHQlMjBtb2RlbCUyMCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDQlMkMlMjAlMjAlMjMlMjBMaW1pdCUyMHRoZSUyMG51bWJlciUyMG9mJTIwcmVhc29uaW5nJTIwc3RlcHMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTJDJTIwJTIwJTIzJTIwU2hvdyUyMGRldGFpbGVkJTIwYWdlbnQlMjByZWFzb25pbmclMEEpJTBBJTBBJTIzJTIwVG8lMjB1c2UlMjBhJTIwc3BlY2lmaWMlMjBtb2RlbCUyQyUyMHlvdSUyMGNhbiUyMHNwZWNpZnklMjBpdCUyMGxpa2UlMjB0aGlzJTNBJTBBJTIzJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjMtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Initialize the agent with our retriever tool</span>
agent = CodeAgent(
    tools=[retriever_tool],  <span class="hljs-comment"># List of tools available to the agent</span>
    model=InferenceClientModel(),  <span class="hljs-comment"># Default model &quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>
    max_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Limit the number of reasoning steps</span>
    verbosity_level=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Show detailed agent reasoning</span>
)

<span class="hljs-comment"># To use a specific model, you can specify it like this:</span>
<span class="hljs-comment"># model=InferenceClientModel(model_id=&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</span>`,wrap:!1}}),O=new d({props:{title:"Step 5: Run the Agent to Answer Questions",local:"step-5-run-the-agent-to-answer-questions",headingTag:"h3"}}),te=new ce({props:{code:"JTIzJTIwQXNrJTIwYSUyMHF1ZXN0aW9uJTIwdGhhdCUyMHJlcXVpcmVzJTIwcmV0cmlldmluZyUyMGluZm9ybWF0aW9uJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJGb3IlMjBhJTIwdHJhbnNmb3JtZXJzJTIwbW9kZWwlMjB0cmFpbmluZyUyQyUyMHdoaWNoJTIwaXMlMjBzbG93ZXIlMkMlMjB0aGUlMjBmb3J3YXJkJTIwb3IlMjB0aGUlMjBiYWNrd2FyZCUyMHBhc3MlM0YlMjIlMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHRvJTIwZ2V0JTIwYW4lMjBhbnN3ZXIlMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIzJTIwRGlzcGxheSUyMHRoZSUyMGZpbmFsJTIwYW5zd2VyJTBBcHJpbnQoJTIyJTVDbkZpbmFsJTIwYW5zd2VyJTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-comment"># Ask a question that requires retrieving information</span>
question = <span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>

<span class="hljs-comment"># Run the agent to get an answer</span>
agent_output = agent.run(question)

<span class="hljs-comment"># Display the final answer</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFinal answer:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),le=new d({props:{title:"Practical Applications of Agentic RAG",local:"practical-applications-of-agentic-rag",headingTag:"h2"}}),ae=new d({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Me=new Ft({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.md"}}),{c(){w=i("meta"),ye=n(),me=i("p"),de=n(),p(h.$$.fragment),we=n(),p(T.$$.fragment),je=n(),p(g.$$.fragment),Je=n(),b=i("p"),b.textContent=ut,he=n(),p(f.$$.fragment),Te=n(),U=i("p"),U.textContent=yt,ge=n(),I=i("ol"),I.innerHTML=dt,be=n(),p(v.$$.fragment),fe=n(),C=i("p"),C.textContent=wt,Ue=n(),B=i("ul"),B.innerHTML=jt,Ie=n(),p(A.$$.fragment),ve=n(),Z=i("p"),Z.innerHTML=Jt,Ce=n(),p(G.$$.fragment),Be=n(),R=i("p"),R.textContent=ht,Ae=n(),$=i("ol"),$.innerHTML=Tt,Ze=n(),W=i("p"),W.textContent=gt,Ge=n(),k=i("ul"),k.innerHTML=bt,Re=n(),p(V.$$.fragment),$e=n(),x=i("p"),x.textContent=ft,We=n(),X=i("p"),X.innerHTML=Ut,ke=n(),p(N.$$.fragment),Ve=n(),q=i("p"),q.textContent=It,xe=n(),p(H.$$.fragment),Xe=n(),Q=i("p"),Q.textContent=vt,Ne=n(),p(_.$$.fragment),qe=n(),p(S.$$.fragment),He=n(),z=i("p"),z.textContent=Ct,Qe=n(),p(E.$$.fragment),_e=n(),p(Y.$$.fragment),Se=n(),F=i("p"),F.textContent=Bt,ze=n(),p(L.$$.fragment),Ee=n(),j=i("blockquote"),j.innerHTML=At,Ye=n(),p(P.$$.fragment),Fe=n(),D=i("p"),D.textContent=Zt,Le=n(),p(K.$$.fragment),Pe=n(),J=i("blockquote"),J.innerHTML=Gt,De=n(),p(O.$$.fragment),Ke=n(),ee=i("p"),ee.textContent=Rt,Oe=n(),p(te.$$.fragment),et=n(),p(le.$$.fragment),tt=n(),se=i("p"),se.textContent=$t,lt=n(),ne=i("ol"),ne.innerHTML=Wt,st=n(),p(ae.$$.fragment),nt=n(),ie=i("p"),ie.textContent=kt,at=n(),oe=i("p"),oe.textContent=Vt,it=n(),re=i("ul"),re.innerHTML=xt,ot=n(),pe=i("p"),pe.textContent=Xt,rt=n(),p(Me.$$.fragment),pt=n(),ue=i("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ye=a(e),me=o(e,"P",{}),Nt(me).forEach(l),de=a(e),M(h.$$.fragment,e),we=a(e),M(T.$$.fragment,e),je=a(e),M(g.$$.fragment,e),Je=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-ahsalp"&&(b.textContent=ut),he=a(e),M(f.$$.fragment,e),Te=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-3b2p9t"&&(U.textContent=yt),ge=a(e),I=o(e,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-s9vwtj"&&(I.innerHTML=dt),be=a(e),M(v.$$.fragment,e),fe=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-5ohm8g"&&(C.textContent=wt),Ue=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1b6u5vg"&&(B.innerHTML=jt),Ie=a(e),M(A.$$.fragment,e),ve=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-nkypap"&&(Z.innerHTML=Jt),Ce=a(e),M(G.$$.fragment,e),Be=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-106qzhl"&&(R.textContent=ht),Ae=a(e),$=o(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-17ov5nb"&&($.innerHTML=Tt),Ze=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vth8dz"&&(W.textContent=gt),Ge=a(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1kmp0ag"&&(k.innerHTML=bt),Re=a(e),M(V.$$.fragment,e),$e=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-ebtqsa"&&(x.textContent=ft),We=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-a2onz5"&&(X.innerHTML=Ut),ke=a(e),M(N.$$.fragment,e),Ve=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1yz8wyl"&&(q.textContent=It),xe=a(e),M(H.$$.fragment,e),Xe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-io6cbu"&&(Q.textContent=vt),Ne=a(e),M(_.$$.fragment,e),qe=a(e),M(S.$$.fragment,e),He=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1r0dacz"&&(z.textContent=Ct),Qe=a(e),M(E.$$.fragment,e),_e=a(e),M(Y.$$.fragment,e),Se=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-16ovxir"&&(F.textContent=Bt),ze=a(e),M(L.$$.fragment,e),Ee=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1j7z97m"&&(j.innerHTML=At),Ye=a(e),M(P.$$.fragment,e),Fe=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-uyg5h9"&&(D.textContent=Zt),Le=a(e),M(K.$$.fragment,e),Pe=a(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1lti5bi"&&(J.innerHTML=Gt),De=a(e),M(O.$$.fragment,e),Ke=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1cnhgyu"&&(ee.textContent=Rt),Oe=a(e),M(te.$$.fragment,e),et=a(e),M(le.$$.fragment,e),tt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1vnmlwn"&&(se.textContent=$t),lt=a(e),ne=o(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-u8fd9x"&&(ne.innerHTML=Wt),st=a(e),M(ae.$$.fragment,e),nt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1nscnr8"&&(ie.textContent=kt),at=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-18cofwx"&&(oe.textContent=Vt),it=a(e),re=o(e,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-12ngelm"&&(re.innerHTML=xt),ot=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-izrxrg"&&(pe.textContent=Xt),rt=a(e),M(Me.$$.fragment,e),pt=a(e),ue=o(e,"P",{}),Nt(ue).forEach(l),this.h()},h(){ct(w,"name","hf:doc:metadata"),ct(w,"content",Pt),ct(j,"class","tip"),ct(J,"class","tip")},m(e,t){Et(document.head,w),s(e,ye,t),s(e,me,t),s(e,de,t),c(h,e,t),s(e,we,t),c(T,e,t),s(e,je,t),c(g,e,t),s(e,Je,t),s(e,b,t),s(e,he,t),c(f,e,t),s(e,Te,t),s(e,U,t),s(e,ge,t),s(e,I,t),s(e,be,t),c(v,e,t),s(e,fe,t),s(e,C,t),s(e,Ue,t),s(e,B,t),s(e,Ie,t),c(A,e,t),s(e,ve,t),s(e,Z,t),s(e,Ce,t),c(G,e,t),s(e,Be,t),s(e,R,t),s(e,Ae,t),s(e,$,t),s(e,Ze,t),s(e,W,t),s(e,Ge,t),s(e,k,t),s(e,Re,t),c(V,e,t),s(e,$e,t),s(e,x,t),s(e,We,t),s(e,X,t),s(e,ke,t),c(N,e,t),s(e,Ve,t),s(e,q,t),s(e,xe,t),c(H,e,t),s(e,Xe,t),s(e,Q,t),s(e,Ne,t),c(_,e,t),s(e,qe,t),c(S,e,t),s(e,He,t),s(e,z,t),s(e,Qe,t),c(E,e,t),s(e,_e,t),c(Y,e,t),s(e,Se,t),s(e,F,t),s(e,ze,t),c(L,e,t),s(e,Ee,t),s(e,j,t),s(e,Ye,t),c(P,e,t),s(e,Fe,t),s(e,D,t),s(e,Le,t),c(K,e,t),s(e,Pe,t),s(e,J,t),s(e,De,t),c(O,e,t),s(e,Ke,t),s(e,ee,t),s(e,Oe,t),c(te,e,t),s(e,et,t),c(le,e,t),s(e,tt,t),s(e,se,t),s(e,lt,t),s(e,ne,t),s(e,st,t),c(ae,e,t),s(e,nt,t),s(e,ie,t),s(e,at,t),s(e,oe,t),s(e,it,t),s(e,re,t),s(e,ot,t),s(e,pe,t),s(e,rt,t),c(Me,e,t),s(e,pt,t),s(e,ue,t),Mt=!0},p:Ht,i(e){Mt||(m(h.$$.fragment,e),m(T.$$.fragment,e),m(g.$$.fragment,e),m(f.$$.fragment,e),m(v.$$.fragment,e),m(A.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(H.$$.fragment,e),m(_.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(Me.$$.fragment,e),Mt=!0)},o(e){u(h.$$.fragment,e),u(T.$$.fragment,e),u(g.$$.fragment,e),u(f.$$.fragment,e),u(v.$$.fragment,e),u(A.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(H.$$.fragment,e),u(_.$$.fragment,e),u(S.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(Me.$$.fragment,e),Mt=!1},d(e){e&&(l(ye),l(me),l(de),l(we),l(je),l(Je),l(b),l(he),l(Te),l(U),l(ge),l(I),l(be),l(fe),l(C),l(Ue),l(B),l(Ie),l(ve),l(Z),l(Ce),l(Be),l(R),l(Ae),l($),l(Ze),l(W),l(Ge),l(k),l(Re),l($e),l(x),l(We),l(X),l(ke),l(Ve),l(q),l(xe),l(Xe),l(Q),l(Ne),l(qe),l(He),l(z),l(Qe),l(_e),l(Se),l(F),l(ze),l(Ee),l(j),l(Ye),l(Fe),l(D),l(Le),l(Pe),l(J),l(De),l(Ke),l(ee),l(Oe),l(et),l(tt),l(se),l(lt),l(ne),l(st),l(nt),l(ie),l(at),l(oe),l(it),l(re),l(ot),l(pe),l(rt),l(pt),l(ue)),l(w),y(h,e),y(T,e),y(g,e),y(f,e),y(v,e),y(A,e),y(G,e),y(V,e),y(N,e),y(H,e),y(_,e),y(S,e),y(E,e),y(Y,e),y(L,e),y(P,e),y(K,e),y(O,e),y(te,e),y(le,e),y(ae,e),y(Me,e)}}}const Pt='{"title":"Agentic RAG","local":"agentic-rag","sections":[{"title":"Introduction to Retrieval-Augmented Generation (RAG)","local":"introduction-to-retrieval-augmented-generation-rag","sections":[{"title":"Why Use RAG?","local":"why-use-rag","sections":[],"depth":3},{"title":"Limitations of Traditional RAG","local":"limitations-of-traditional-rag","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG: A More Powerful Approach","local":"agentic-rag-a-more-powerful-approach","sections":[{"title":"Key Benefits of Agentic RAG","local":"key-benefits-of-agentic-rag","sections":[],"depth":3}],"depth":2},{"title":"Building an Agentic RAG System","local":"building-an-agentic-rag-system","sections":[{"title":"Step 1: Install Required Dependencies","local":"step-1-install-required-dependencies","sections":[],"depth":3},{"title":"Step 2: Prepare the Knowledge Base","local":"step-2-prepare-the-knowledge-base","sections":[],"depth":3},{"title":"Step 3: Create a Retriever Tool","local":"step-3-create-a-retriever-tool","sections":[],"depth":3},{"title":"Step 4: Create an Advanced Retrieval Agent","local":"step-4-create-an-advanced-retrieval-agent","sections":[],"depth":3},{"title":"Step 5: Run the Agent to Answer Questions","local":"step-5-run-the-agent-to-answer-questions","sections":[],"depth":3}],"depth":2},{"title":"Practical Applications of Agentic RAG","local":"practical-applications-of-agentic-rag","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Dt(mt){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends _t{constructor(w){super(),St(this,w,Dt,Lt,qt,{})}}export{sl as component};
