import{s as ue,n as we,o as ge}from"../chunks/scheduler.85c25b89.js";import{S as Je,i as je,g as l,s as o,u as c,A as fe,h as n,f as e,c as p,j as h,v as d,y as m,k as i,o as r,a,w as M,d as y,t as u,x as w}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Yt){let g,ht,st,mt,J,U,at,x,Qt,q,Ht="SE-ResNet",ct,$,zt='<strong>SE ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',dt,j,v,lt,N,Vt,D,Ft="How do I use this model on an image?",Mt,Z,Pt="To load a pretrained model:",yt,E,ut,W,Lt="To load and preprocess the image:",wt,B,gt,_,qt="To get the model predictions:",Jt,G,jt,S,Dt="To get the top-5 predictions class names:",ft,Q,Tt,V,Kt="Replace the model name with the variant you want to use, e.g. <code>seresnet152d</code>. You can find the IDs in the model summaries at the top of this page.",bt,R,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ut,f,C,nt,X,Rt,K,te="How do I finetune this model?",vt,A,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,Y,kt,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,It,T,k,ot,z,Xt,O,ae="How do I train this model?",xt,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,I,pt,P,At,tt,ne="Citation",Nt,L,Zt,it,Et;return x=new rt({}),N=new rt({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NlcmVzbmV0MTUyZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;seresnet152d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),X=new rt({}),Y=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2VyZXNuZXQxNTJkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;seresnet152d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){g=l("meta"),ht=o(),st=l("p"),mt=o(),J=l("h1"),U=l("a"),at=l("span"),c(x.$$.fragment),Qt=o(),q=l("span"),q.textContent=Ht,ct=o(),$=l("p"),$.innerHTML=zt,dt=o(),j=l("h2"),v=l("a"),lt=l("span"),c(N.$$.fragment),Vt=o(),D=l("span"),D.textContent=Ft,Mt=o(),Z=l("p"),Z.textContent=Pt,yt=o(),c(E.$$.fragment),ut=o(),W=l("p"),W.textContent=Lt,wt=o(),c(B.$$.fragment),gt=o(),_=l("p"),_.textContent=qt,Jt=o(),c(G.$$.fragment),jt=o(),S=l("p"),S.textContent=Dt,ft=o(),c(Q.$$.fragment),Tt=o(),V=l("p"),V.innerHTML=Kt,bt=o(),R=l("p"),R.innerHTML=Ot,Ut=o(),f=l("h2"),C=l("a"),nt=l("span"),c(X.$$.fragment),Rt=o(),K=l("span"),K.textContent=te,vt=o(),A=l("p"),A.textContent=ee,Ct=o(),c(Y.$$.fragment),kt=o(),H=l("p"),H.innerHTML=se,It=o(),T=l("h2"),k=l("a"),ot=l("span"),c(z.$$.fragment),Xt=o(),O=l("span"),O.textContent=ae,xt=o(),F=l("p"),F.innerHTML=le,$t=o(),b=l("h2"),I=l("a"),pt=l("span"),c(P.$$.fragment),At=o(),tt=l("span"),tt.textContent=ne,Nt=o(),c(L.$$.fragment),Zt=o(),it=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),J=n(t,"H1",{class:!0});var Wt=h(J);U=n(Wt,"A",{id:!0,class:!0,href:!0});var oe=h(U);at=n(oe,"SPAN",{});var pe=h(at);d(x.$$.fragment,pe),pe.forEach(e),oe.forEach(e),Qt=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-cwn9t9"&&(q.textContent=Ht),Wt.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1b8qp0g"&&($.innerHTML=zt),dt=p(t),j=n(t,"H2",{class:!0});var Bt=h(j);v=n(Bt,"A",{id:!0,class:!0,href:!0});var ie=h(v);lt=n(ie,"SPAN",{});var re=h(lt);d(N.$$.fragment,re),re.forEach(e),ie.forEach(e),Vt=p(Bt),D=n(Bt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=Ft),Bt.forEach(e),Mt=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Pt),yt=p(t),d(E.$$.fragment,t),ut=p(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Lt),wt=p(t),d(B.$$.fragment,t),gt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=qt),Jt=p(t),d(G.$$.fragment,t),jt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-19cnvx1"&&(S.textContent=Dt),ft=p(t),d(Q.$$.fragment,t),Tt=p(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1m8ksnz"&&(V.innerHTML=Kt),bt=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1wmi3ea"&&(R.innerHTML=Ot),Ut=p(t),f=n(t,"H2",{class:!0});var _t=h(f);C=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(X.$$.fragment,me),me.forEach(e),he.forEach(e),Rt=p(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),vt=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-9sr7nh"&&(A.textContent=ee),Ct=p(t),d(Y.$$.fragment,t),kt=p(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),It=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);k=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(k);ot=n(ce,"SPAN",{});var de=h(ot);d(z.$$.fragment,de),de.forEach(e),ce.forEach(e),Xt=p(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),xt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),$t=p(t),b=n(t,"H2",{class:!0});var St=h(b);I=n(St,"A",{id:!0,class:!0,href:!0});var Me=h(I);pt=n(Me,"SPAN",{});var ye=h(pt);d(P.$$.fragment,ye),ye.forEach(e),Me.forEach(e),At=p(St),tt=n(St,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),St.forEach(e),Nt=p(t),d(L.$$.fragment,t),Zt=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(g,"name","hf:doc:metadata"),i(g,"content",JSON.stringify(be)),i(U,"id","seresnet"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#seresnet"),i(J,"class","relative group"),i(v,"id","how-do-i-use-this-model-on-an-image"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#how-do-i-use-this-model-on-an-image"),i(j,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(f,"class","relative group"),i(k,"id","how-do-i-train-this-model"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#how-do-i-train-this-model"),i(T,"class","relative group"),i(I,"id","citation"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,g),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,J,s),r(J,U),r(U,at),M(x,at,null),r(J,Qt),r(J,q),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,v),r(v,lt),M(N,lt,null),r(j,Vt),r(j,D),a(t,Mt,s),a(t,Z,s),a(t,yt,s),M(E,t,s),a(t,ut,s),a(t,W,s),a(t,wt,s),M(B,t,s),a(t,gt,s),a(t,_,s),a(t,Jt,s),M(G,t,s),a(t,jt,s),a(t,S,s),a(t,ft,s),M(Q,t,s),a(t,Tt,s),a(t,V,s),a(t,bt,s),a(t,R,s),a(t,Ut,s),a(t,f,s),r(f,C),r(C,nt),M(X,nt,null),r(f,Rt),r(f,K),a(t,vt,s),a(t,A,s),a(t,Ct,s),M(Y,t,s),a(t,kt,s),a(t,H,s),a(t,It,s),a(t,T,s),r(T,k),r(k,ot),M(z,ot,null),r(T,Xt),r(T,O),a(t,xt,s),a(t,F,s),a(t,$t,s),a(t,b,s),r(b,I),r(I,pt),M(P,pt,null),r(b,At),r(b,tt),a(t,Nt,s),M(L,t,s),a(t,Zt,s),a(t,it,s),Et=!0},p:we,i(t){Et||(y(x.$$.fragment,t),y(N.$$.fragment,t),y(E.$$.fragment,t),y(B.$$.fragment,t),y(G.$$.fragment,t),y(Q.$$.fragment,t),y(X.$$.fragment,t),y(Y.$$.fragment,t),y(z.$$.fragment,t),y(P.$$.fragment,t),y(L.$$.fragment,t),Et=!0)},o(t){u(x.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),u(B.$$.fragment,t),u(G.$$.fragment,t),u(Q.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(st),e(mt),e(J),e(ct),e($),e(dt),e(j),e(Mt),e(Z),e(yt),e(ut),e(W),e(wt),e(gt),e(_),e(Jt),e(jt),e(S),e(ft),e(Tt),e(V),e(bt),e(R),e(Ut),e(f),e(vt),e(A),e(Ct),e(kt),e(H),e(It),e(T),e(xt),e(F),e($t),e(b),e(Nt),e(Zt),e(it)),e(g),w(x),w(N),w(E,t),w(B,t),w(G,t),w(Q,t),w(X),w(Y,t),w(z),w(P),w(L,t)}}}const be={local:"seresnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"SE-ResNet"};function Ue(Yt){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xe extends Je{constructor(g){super(),je(this,g,Ue,Te,ue,{})}}export{xe as component};
