import{s as $t,n as Ct,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as vt,g as p,s as l,r as m,A as Gt,h as i,f as e,c as n,j as Ut,u as o,x as g,k as It,y as Bt,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as R,E as Nt}from"../chunks/getInferenceSnippets.b020ba4f.js";function xt(Mt){let y,Y,X,S,d,z,J,gt='<strong>Inception-ResNet-v2</strong> is a convolutional neural architecture that builds on the Inception family of architectures but incorporates <a href="https://paperswithcode.com/method/residual-connection" rel="nofollow">residual connections</a> (replacing the filter concatenation stage of the Inception architecture).',H,u,F,j,yt="To load a pretrained model:",A,w,L,T,dt="To load and preprocess the image:",D,f,q,b,Jt="To get the model predictions:",P,U,K,I,ut="To get the top-5 predictions class names:",O,$,tt,C,jt="Replace the model name with the variant you want to use, e.g. <code>inception_resnet_v2</code>. You can find the IDs in the model summaries at the top of this page.",st,Z,wt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,at,v,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,G,nt,B,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,N,it,x,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',mt,k,ot,Q,ct,E,rt,_,ht;return d=new R({props:{title:"Inception ResNet v2",local:"inception-resnet-v2",headingTag:"h1"}}),u=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),w=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl9yZXNuZXRfdjInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3Jlc25ldF92MiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),k=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwbWlzYyU3QnN6ZWdlZHkyMDE2aW5jZXB0aW9udjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkluY2VwdGlvbi12NCUyQyUyMEluY2VwdGlvbi1SZXNOZXQlMjBhbmQlMjB0aGUlMjBJbXBhY3QlMjBvZiUyMFJlc2lkdWFsJTIwQ29ubmVjdGlvbnMlMjBvbiUyMExlYXJuaW5nJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUyMFNlcmdleSUyMElvZmZlJTIwYW5kJTIwVmluY2VudCUyMFZhbmhvdWNrZSUyMGFuZCUyMEFsZXglMjBBbGVtaSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTYwMi4wNzI2MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{szegedy2016inceptionv4,
      title={Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Christian Szegedy and Sergey Ioffe and Vincent Vanhoucke and Alex Alemi}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1602.07261}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),E=new Nt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/inception-resnet-v2.mdx"}}),{c(){y=p("meta"),Y=l(),X=p("p"),S=l(),m(d.$$.fragment),z=l(),J=p("p"),J.innerHTML=gt,H=l(),m(u.$$.fragment),F=l(),j=p("p"),j.textContent=yt,A=l(),m(w.$$.fragment),L=l(),T=p("p"),T.textContent=dt,D=l(),m(f.$$.fragment),q=l(),b=p("p"),b.textContent=Jt,P=l(),m(U.$$.fragment),K=l(),I=p("p"),I.textContent=ut,O=l(),m($.$$.fragment),tt=l(),C=p("p"),C.innerHTML=jt,st=l(),Z=p("p"),Z.innerHTML=wt,et=l(),m(W.$$.fragment),at=l(),v=p("p"),v.textContent=Tt,lt=l(),m(G.$$.fragment),nt=l(),B=p("p"),B.innerHTML=ft,pt=l(),m(N.$$.fragment),it=l(),x=p("p"),x.innerHTML=bt,mt=l(),m(k.$$.fragment),ot=l(),m(Q.$$.fragment),ct=l(),m(E.$$.fragment),rt=l(),_=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(e),Y=n(t),X=i(t,"P",{}),Ut(X).forEach(e),S=n(t),o(d.$$.fragment,t),z=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-gd1at0"&&(J.innerHTML=gt),H=n(t),o(u.$$.fragment,t),F=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=yt),A=n(t),o(w.$$.fragment,t),L=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=dt),D=n(t),o(f.$$.fragment,t),q=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),P=n(t),o(U.$$.fragment,t),K=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=ut),O=n(t),o($.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-17lzl0w"&&(C.innerHTML=jt),st=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=wt),et=n(t),o(W.$$.fragment,t),at=n(t),v=i(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-9sr7nh"&&(v.textContent=Tt),lt=n(t),o(G.$$.fragment,t),nt=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=ft),pt=n(t),o(N.$$.fragment,t),it=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-xtxxu6"&&(x.innerHTML=bt),mt=n(t),o(k.$$.fragment,t),ot=n(t),o(Q.$$.fragment,t),ct=n(t),o(E.$$.fragment,t),rt=n(t),_=i(t,"P",{}),Ut(_).forEach(e),this.h()},h(){It(y,"name","hf:doc:metadata"),It(y,"content",kt)},m(t,s){Bt(document.head,y),a(t,Y,s),a(t,X,s),a(t,S,s),c(d,t,s),a(t,z,s),a(t,J,s),a(t,H,s),c(u,t,s),a(t,F,s),a(t,j,s),a(t,A,s),c(w,t,s),a(t,L,s),a(t,T,s),a(t,D,s),c(f,t,s),a(t,q,s),a(t,b,s),a(t,P,s),c(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),c($,t,s),a(t,tt,s),a(t,C,s),a(t,st,s),a(t,Z,s),a(t,et,s),c(W,t,s),a(t,at,s),a(t,v,s),a(t,lt,s),c(G,t,s),a(t,nt,s),a(t,B,s),a(t,pt,s),c(N,t,s),a(t,it,s),a(t,x,s),a(t,mt,s),c(k,t,s),a(t,ot,s),c(Q,t,s),a(t,ct,s),c(E,t,s),a(t,rt,s),a(t,_,s),ht=!0},p:Ct,i(t){ht||(r(d.$$.fragment,t),r(u.$$.fragment,t),r(w.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r($.$$.fragment,t),r(W.$$.fragment,t),r(G.$$.fragment,t),r(N.$$.fragment,t),r(k.$$.fragment,t),r(Q.$$.fragment,t),r(E.$$.fragment,t),ht=!0)},o(t){h(d.$$.fragment,t),h(u.$$.fragment,t),h(w.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(G.$$.fragment,t),h(N.$$.fragment,t),h(k.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),ht=!1},d(t){t&&(e(Y),e(X),e(S),e(z),e(J),e(H),e(F),e(j),e(A),e(L),e(T),e(D),e(q),e(b),e(P),e(K),e(I),e(O),e(tt),e(C),e(st),e(Z),e(et),e(at),e(v),e(lt),e(nt),e(B),e(pt),e(it),e(x),e(mt),e(ot),e(ct),e(rt),e(_)),e(y),M(d,t),M(u,t),M(w,t),M(f,t),M(U,t),M($,t),M(W,t),M(G,t),M(N,t),M(k,t),M(Q,t),M(E,t)}}}const kt='{"title":"Inception ResNet v2","local":"inception-resnet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Wt{constructor(y){super(),vt(this,y,Qt,xt,$t,{})}}export{Rt as component};
