import{s as $t,n as xt,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as kt,g as p,s as a,r as m,A as Ct,h as i,f as e,c as n,j as Ut,u as o,x as M,k as It,y as Nt,a as l,v as r,d as c,t as h,w as g}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as R,E as Gt}from"../chunks/getInferenceSnippets.96f6e3ee.js";function vt(gt){let d,Y,X,S,J,z,w,Mt='<strong>SK ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> that employs a <a href="https://paperswithcode.com/method/selective-kernel" rel="nofollow">Selective Kernel</a> unit. In general, all the large kernel convolutions in the original bottleneck blocks in ResNext are replaced by the proposed <a href="https://paperswithcode.com/method/selective-kernel-convolution" rel="nofollow">SK convolutions</a>, enabling the network to choose appropriate receptive field sizes in an adaptive manner.',A,y,H,j,dt="To load a pretrained model:",F,u,K,T,Jt="To load and preprocess the image:",L,f,D,b,wt="To get the model predictions:",q,U,P,I,yt="To get the top-5 predictions class names:",O,$,tt,x,jt="Replace the model name with the variant you want to use, e.g. <code>skresnext50_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",st,Z,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,lt,k,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,C,nt,N,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,G,it,v,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',mt,B,ot,E,rt,Q,ct,_,ht;return J=new R({props:{title:"SK-ResNeXt",local:"sk-resnext",headingTag:"h1"}}),y=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NrcmVzbmV4dDUwXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),C=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2tyZXNuZXh0NTBfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),B=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwbWlzYyU3QmxpMjAxOXNlbGVjdGl2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCU2VsZWN0aXZlJTIwS2VybmVsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JYaWFuZyUyMExpJTIwYW5kJTIwV2VuaGFpJTIwV2FuZyUyMGFuZCUyMFhpYW9saW4lMjBIdSUyMGFuZCUyMEppYW4lMjBZYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTAzLjA2NTg2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{li2019selective,
      title={Selective Kernel Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Xiang Li and Wenhai Wang and Xiaolin Hu and Jian Yang}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1903.06586}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),Q=new Gt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/skresnext.mdx"}}),{c(){d=p("meta"),Y=a(),X=p("p"),S=a(),m(J.$$.fragment),z=a(),w=p("p"),w.innerHTML=Mt,A=a(),m(y.$$.fragment),H=a(),j=p("p"),j.textContent=dt,F=a(),m(u.$$.fragment),K=a(),T=p("p"),T.textContent=Jt,L=a(),m(f.$$.fragment),D=a(),b=p("p"),b.textContent=wt,q=a(),m(U.$$.fragment),P=a(),I=p("p"),I.textContent=yt,O=a(),m($.$$.fragment),tt=a(),x=p("p"),x.innerHTML=jt,st=a(),Z=p("p"),Z.innerHTML=ut,et=a(),m(W.$$.fragment),lt=a(),k=p("p"),k.textContent=Tt,at=a(),m(C.$$.fragment),nt=a(),N=p("p"),N.innerHTML=ft,pt=a(),m(G.$$.fragment),it=a(),v=p("p"),v.innerHTML=bt,mt=a(),m(B.$$.fragment),ot=a(),m(E.$$.fragment),rt=a(),m(Q.$$.fragment),ct=a(),_=p("p"),this.h()},l(t){const s=Ct("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(e),Y=n(t),X=i(t,"P",{}),Ut(X).forEach(e),S=n(t),o(J.$$.fragment,t),z=n(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1kqotlt"&&(w.innerHTML=Mt),A=n(t),o(y.$$.fragment,t),H=n(t),j=i(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-18ywhxh"&&(j.textContent=dt),F=n(t),o(u.$$.fragment,t),K=n(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),L=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1n9qsq1"&&(b.textContent=wt),q=n(t),o(U.$$.fragment,t),P=n(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=yt),O=n(t),o($.$$.fragment,t),tt=n(t),x=i(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-44hawi"&&(x.innerHTML=jt),st=n(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=ut),et=n(t),o(W.$$.fragment,t),lt=n(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-9sr7nh"&&(k.textContent=Tt),at=n(t),o(C.$$.fragment,t),nt=n(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1kguc51"&&(N.innerHTML=ft),pt=n(t),o(G.$$.fragment,t),it=n(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-xtxxu6"&&(v.innerHTML=bt),mt=n(t),o(B.$$.fragment,t),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ct=n(t),_=i(t,"P",{}),Ut(_).forEach(e),this.h()},h(){It(d,"name","hf:doc:metadata"),It(d,"content",Bt)},m(t,s){Nt(document.head,d),l(t,Y,s),l(t,X,s),l(t,S,s),r(J,t,s),l(t,z,s),l(t,w,s),l(t,A,s),r(y,t,s),l(t,H,s),l(t,j,s),l(t,F,s),r(u,t,s),l(t,K,s),l(t,T,s),l(t,L,s),r(f,t,s),l(t,D,s),l(t,b,s),l(t,q,s),r(U,t,s),l(t,P,s),l(t,I,s),l(t,O,s),r($,t,s),l(t,tt,s),l(t,x,s),l(t,st,s),l(t,Z,s),l(t,et,s),r(W,t,s),l(t,lt,s),l(t,k,s),l(t,at,s),r(C,t,s),l(t,nt,s),l(t,N,s),l(t,pt,s),r(G,t,s),l(t,it,s),l(t,v,s),l(t,mt,s),r(B,t,s),l(t,ot,s),r(E,t,s),l(t,rt,s),r(Q,t,s),l(t,ct,s),l(t,_,s),ht=!0},p:xt,i(t){ht||(c(J.$$.fragment,t),c(y.$$.fragment,t),c(u.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(W.$$.fragment,t),c(C.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),ht=!0)},o(t){h(J.$$.fragment,t),h(y.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(C.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ht=!1},d(t){t&&(e(Y),e(X),e(S),e(z),e(w),e(A),e(H),e(j),e(F),e(K),e(T),e(L),e(D),e(b),e(q),e(P),e(I),e(O),e(tt),e(x),e(st),e(Z),e(et),e(lt),e(k),e(at),e(nt),e(N),e(pt),e(it),e(v),e(mt),e(ot),e(rt),e(ct),e(_)),e(d),g(J,t),g(y,t),g(u,t),g(f,t),g(U,t),g($,t),g(W,t),g(C,t),g(G,t),g(B,t),g(E,t),g(Q,t)}}}const Bt='{"title":"SK-ResNeXt","local":"sk-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(gt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Wt{constructor(d){super(),kt(this,d,Et,vt,$t,{})}}export{Rt as component};
