import{s as Se,o as Ye,n as ze}from"../chunks/scheduler.69131cc3.js";import{S as xe,i as Qe,g as y,s as i,r as c,A as Ne,h as f,f as l,c as r,j as We,u as o,x as M,k as Ve,y as Le,a,v as p,d,t as m,w as h}from"../chunks/index.e1f30d73.js";import{T as Xe}from"../chunks/Tip.22e79575.js";import{C as F}from"../chunks/CodeBlock.30cef355.js";import{H as T}from"../chunks/Heading.0aab6758.js";function Ee(E){let n,u="We are under the presumption that <code>training_dataloader</code>, <code>model</code>, <code>optimizer</code>, <code>scheduler</code>, and <code>loss_function</code> have been defined beforehand.";return{c(){n=y("p"),n.innerHTML=u},l(s){n=f(s,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1f10lie"&&(n.innerHTML=u)},m(s,w){a(s,n,w)},p:ze,d(s){s&&l(n)}}}function Fe(E){let n,u="Accelerate will only prepare objects that inherit from their respective PyTorch classes (such as <code>torch.optim.Optimizer</code>).";return{c(){n=y("p"),n.innerHTML=u},l(s){n=f(s,"P",{"data-svelte-h":!0}),M(n)!=="svelte-msxy5w"&&(n.innerHTML=u)},m(s,w){a(s,n,w)},p:ze,d(s){s&&l(n)}}}function Pe(E){let n,u,s,w,b,K,U,Je=`This tutorial will detail how to easily convert existing PyTorch code to use 🤗 Accelerate!
You’ll see that by just changing a few lines of code, 🤗 Accelerate can perform its magic and get you on
your way toward running your code on distributed systems with ease!`,D,J,q,v,ve="To begin, write out a very basic PyTorch training loop.",O,$,ee,j,te,C,le,G,je='To start using 🤗 Accelerate, first import and create an <a href="/docs/accelerate/v0.27.2/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance:',ae,k,ie,I,Ce='<a href="/docs/accelerate/v0.27.2/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main force behind utilizing all the possible options for distributed training!',re,Z,ne,B,Ge=`The <a href="/docs/accelerate/v0.27.2/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class knows the right device to move any PyTorch object to at any time, so you should
change the definition of <code>device</code> to come from <a href="/docs/accelerate/v0.27.2/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>:`,se,_,ce,A,oe,R,ke=`Next, you need to pass all of the important objects related to training into <a href="/docs/accelerate/v0.27.2/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>. 🤗 Accelerate will
make sure everything is setup in the current environment for you to start training:`,pe,H,de,W,Ie=`These objects are returned in the same order they were sent in. By default when using <code>device_placement=True</code>, all of the objects that can be sent to the right device will be.
If you need to work with data that isn’t passed to [~Accelerator.prepare] but should be on the active device, you should pass in the <code>device</code> you made earlier.`,me,g,he,V,ye,X,Ze=`Finally, three lines of code need to be changed in the training loop. 🤗 Accelerate’s DataLoader classes will automatically handle the device placement by default,
and <a href="/docs/accelerate/v0.27.2/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> should be used for performing the backward pass:`,fe,z,Me,S,Be="With that, your training loop is now ready to use 🤗 Accelerate!",ue,Y,we,x,_e="Below is the final version of the converted code:",$e,Q,ge,N,Te,L,Ae='To check out more ways on how to migrate to 🤗 Accelerate, check out our <a href="https://huggingface.co/docs/accelerate/usage_guides/explore" rel="nofollow">interactive migration tutorial</a> which showcases other items that need to be watched for when using Accelerate and how to do so quickly.',be,P,Ue;return b=new T({props:{title:"Migrating your code to 🤗 Accelerate",local:"migrating-your-code-to--accelerate",headingTag:"h1"}}),J=new T({props:{title:"The base training loop",local:"the-base-training-loop",headingTag:"h2"}}),$=new Xe({props:{$$slots:{default:[Ee]},$$scope:{ctx:E}}}),j=new F({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),C=new T({props:{title:"Add in 🤗 Accelerate",local:"add-in--accelerate",headingTag:"h2"}}),k=new F({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),Z=new T({props:{title:"Setting the right device",local:"setting-the-right-device",headingTag:"h3"}}),_=new F({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCdjdWRhJyUwQSUyQiUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyMCUyMG1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-deletion">- device = &#x27;cuda&#x27;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),A=new T({props:{title:"Preparing your objects",local:"preparing-your-objects",headingTag:"h3"}}),H=new F({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`<span class="hljs-built_in">model,</span> optimizer, training_dataloader, scheduler = accelerator.prepare(
<span class="hljs-built_in">    model,</span> optimizer, training_dataloader, scheduler
)`,wrap:!1}}),g=new Xe({props:{warning:!0,$$slots:{default:[Fe]},$$scope:{ctx:E}}}),V=new T({props:{title:"Modifying the training loop",local:"modifying-the-training-loop",headingTag:"h3"}}),z=new F({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),Y=new T({props:{title:"The finished code",local:"the-finished-code",headingTag:"h2"}}),Q=new F({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()

model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),N=new T({props:{title:"More Resources",local:"more-resources",headingTag:"h2"}}),{c(){n=y("meta"),u=i(),s=y("p"),w=i(),c(b.$$.fragment),K=i(),U=y("p"),U.textContent=Je,D=i(),c(J.$$.fragment),q=i(),v=y("p"),v.textContent=ve,O=i(),c($.$$.fragment),ee=i(),c(j.$$.fragment),te=i(),c(C.$$.fragment),le=i(),G=y("p"),G.innerHTML=je,ae=i(),c(k.$$.fragment),ie=i(),I=y("p"),I.innerHTML=Ce,re=i(),c(Z.$$.fragment),ne=i(),B=y("p"),B.innerHTML=Ge,se=i(),c(_.$$.fragment),ce=i(),c(A.$$.fragment),oe=i(),R=y("p"),R.innerHTML=ke,pe=i(),c(H.$$.fragment),de=i(),W=y("p"),W.innerHTML=Ie,me=i(),c(g.$$.fragment),he=i(),c(V.$$.fragment),ye=i(),X=y("p"),X.innerHTML=Ze,fe=i(),c(z.$$.fragment),Me=i(),S=y("p"),S.textContent=Be,ue=i(),c(Y.$$.fragment),we=i(),x=y("p"),x.textContent=_e,$e=i(),c(Q.$$.fragment),ge=i(),c(N.$$.fragment),Te=i(),L=y("p"),L.innerHTML=Ae,be=i(),P=y("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);n=f(t,"META",{name:!0,content:!0}),t.forEach(l),u=r(e),s=f(e,"P",{}),We(s).forEach(l),w=r(e),o(b.$$.fragment,e),K=r(e),U=f(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-18ve0vq"&&(U.textContent=Je),D=r(e),o(J.$$.fragment,e),q=r(e),v=f(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-t74kbp"&&(v.textContent=ve),O=r(e),o($.$$.fragment,e),ee=r(e),o(j.$$.fragment,e),te=r(e),o(C.$$.fragment,e),le=r(e),G=f(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1fcdb9x"&&(G.innerHTML=je),ae=r(e),o(k.$$.fragment,e),ie=r(e),I=f(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1tjnbbq"&&(I.innerHTML=Ce),re=r(e),o(Z.$$.fragment,e),ne=r(e),B=f(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1ac60vi"&&(B.innerHTML=Ge),se=r(e),o(_.$$.fragment,e),ce=r(e),o(A.$$.fragment,e),oe=r(e),R=f(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-c3rve1"&&(R.innerHTML=ke),pe=r(e),o(H.$$.fragment,e),de=r(e),W=f(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-n2b8yk"&&(W.innerHTML=Ie),me=r(e),o(g.$$.fragment,e),he=r(e),o(V.$$.fragment,e),ye=r(e),X=f(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-ghljy3"&&(X.innerHTML=Ze),fe=r(e),o(z.$$.fragment,e),Me=r(e),S=f(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-5ozud8"&&(S.textContent=Be),ue=r(e),o(Y.$$.fragment,e),we=r(e),x=f(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-18yri0t"&&(x.textContent=_e),$e=r(e),o(Q.$$.fragment,e),ge=r(e),o(N.$$.fragment,e),Te=r(e),L=f(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-keape9"&&(L.innerHTML=Ae),be=r(e),P=f(e,"P",{}),We(P).forEach(l),this.h()},h(){Ve(n,"name","hf:doc:metadata"),Ve(n,"content",Ke)},m(e,t){Le(document.head,n),a(e,u,t),a(e,s,t),a(e,w,t),p(b,e,t),a(e,K,t),a(e,U,t),a(e,D,t),p(J,e,t),a(e,q,t),a(e,v,t),a(e,O,t),p($,e,t),a(e,ee,t),p(j,e,t),a(e,te,t),p(C,e,t),a(e,le,t),a(e,G,t),a(e,ae,t),p(k,e,t),a(e,ie,t),a(e,I,t),a(e,re,t),p(Z,e,t),a(e,ne,t),a(e,B,t),a(e,se,t),p(_,e,t),a(e,ce,t),p(A,e,t),a(e,oe,t),a(e,R,t),a(e,pe,t),p(H,e,t),a(e,de,t),a(e,W,t),a(e,me,t),p(g,e,t),a(e,he,t),p(V,e,t),a(e,ye,t),a(e,X,t),a(e,fe,t),p(z,e,t),a(e,Me,t),a(e,S,t),a(e,ue,t),p(Y,e,t),a(e,we,t),a(e,x,t),a(e,$e,t),p(Q,e,t),a(e,ge,t),p(N,e,t),a(e,Te,t),a(e,L,t),a(e,be,t),a(e,P,t),Ue=!0},p(e,[t]){const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),$.$set(Re);const He={};t&2&&(He.$$scope={dirty:t,ctx:e}),g.$set(He)},i(e){Ue||(d(b.$$.fragment,e),d(J.$$.fragment,e),d($.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(g.$$.fragment,e),d(V.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),Ue=!0)},o(e){m(b.$$.fragment,e),m(J.$$.fragment,e),m($.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(H.$$.fragment,e),m(g.$$.fragment,e),m(V.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),Ue=!1},d(e){e&&(l(u),l(s),l(w),l(K),l(U),l(D),l(q),l(v),l(O),l(ee),l(te),l(le),l(G),l(ae),l(ie),l(I),l(re),l(ne),l(B),l(se),l(ce),l(oe),l(R),l(pe),l(de),l(W),l(me),l(he),l(ye),l(X),l(fe),l(Me),l(S),l(ue),l(we),l(x),l($e),l(ge),l(Te),l(L),l(be),l(P)),l(n),h(b,e),h(J,e),h($,e),h(j,e),h(C,e),h(k,e),h(Z,e),h(_,e),h(A,e),h(H,e),h(g,e),h(V,e),h(z,e),h(Y,e),h(Q,e),h(N,e)}}}const Ke='{"title":"Migrating your code to 🤗 Accelerate","local":"migrating-your-code-to--accelerate","sections":[{"title":"The base training loop","local":"the-base-training-loop","sections":[],"depth":2},{"title":"Add in 🤗 Accelerate","local":"add-in--accelerate","sections":[{"title":"Setting the right device","local":"setting-the-right-device","sections":[],"depth":3},{"title":"Preparing your objects","local":"preparing-your-objects","sections":[],"depth":3},{"title":"Modifying the training loop","local":"modifying-the-training-loop","sections":[],"depth":3}],"depth":2},{"title":"The finished code","local":"the-finished-code","sections":[],"depth":2},{"title":"More Resources","local":"more-resources","sections":[],"depth":2}],"depth":1}';function De(E){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends xe{constructor(n){super(),Qe(this,n,De,Pe,Se,{})}}export{at as component};
