import{s as Ji,n as Qi,o as Zi}from"../chunks/scheduler.6062bdaf.js";import{S as el,i as tl,g as o,s as n,r as f,A as il,h as s,f as i,c as a,j as Xi,u,x as r,k as Vi,y as ll,a as l,v as d,d as h,t as c,w as p}from"../chunks/index.4bca734e.js";import{H as m}from"../chunks/Heading.723dceba.js";function nl(ii){let g,qe,Se,Oe,_,Ne,H,li="<code>huggingface_hub</code> can be configured using environment variables.",ke,$,ni=`If you are unfamiliar with environment variable, here are generic articles about them
<a href="https://linuxize.com/post/how-to-set-and-list-environment-variables-in-linux/" rel="nofollow">on macOS and Linux</a>
and on <a href="https://phoenixnap.com/kb/windows-set-environment-variable" rel="nofollow">Windows</a>.`,Ue,b,ai=`This page will guide you through all environment variables specific to <code>huggingface_hub</code>
and their meaning.`,Re,v,De,T,Ge,w,oi=`To configure the inference api base url. You might want to set this variable if your organization
is pointing at an API Gateway rather than directly at the inference api.`,Ye,L,si="Defaults to <code>&quot;https://api-inference.huggingface.com&quot;</code>.",Ke,E,ze,M,ri=`To configure where <code>huggingface_hub</code> will locally store data. In particular, your token
and the cache will be stored in this folder.`,We,y,fi='Defaults to <code>&quot;~/.cache/huggingface&quot;</code> unless <a href="#xdgcachehome">XDG_CACHE_HOME</a> is set.',je,x,Xe,C,ui=`To configure where repositories from the Hub will be cached locally (models, datasets and
spaces).`,Ve,F,di="Defaults to <code>&quot;$HF_HOME/hub&quot;</code> (e.g. <code>&quot;~/.cache/huggingface/hub&quot;</code> by default).",Je,A,Qe,I,hi=`To configure where <a href="../guides/manage-cache#caching-assets">assets</a> created by downstream libraries
will be cached locally. Those assets can be preprocessed data, files downloaded from GitHub,
logs,…`,Ze,P,ci="Defaults to <code>&quot;$HF_HOME/assets&quot;</code> (e.g. <code>&quot;~/.cache/huggingface/assets&quot;</code> by default).",et,S,tt,B,pi=`To configure the User Access Token to authenticate to the Hub. If set, this value will
overwrite the token stored on the machine (in either <code>$HF_TOKEN_PATH</code> or <code>&quot;$HF_HOME/token&quot;</code> if the former is not set).`,it,q,mi='For more details about authentication, check out <a href="../quick-start#authentication">this section</a>.',lt,O,nt,N,gi="To configure where <code>huggingface_hub</code> should store the User Access Token. Defaults to <code>&quot;$HF_HOME/token&quot;</code> (e.g. <code>~/.cache/huggingface/token</code> by default).",at,k,ot,U,_i=`Set the verbosity level of the <code>huggingface_hub</code>’s logger. Must be one of
<code>{&quot;debug&quot;, &quot;info&quot;, &quot;warning&quot;, &quot;error&quot;, &quot;critical&quot;}</code>.`,st,R,Hi="Defaults to <code>&quot;warning&quot;</code>.",rt,D,$i='For more details, see <a href="../package_reference/utilities#huggingface_hub.utils.logging.get_verbosity">logging reference</a>.',ft,G,ut,Y,bi=`Integer value to define under which size a file is considered as “small”. When downloading files to a local directory,
small files will be duplicated to ease user experience while bigger files are symlinked to save disk usage.`,dt,K,vi='For more details, see the <a href="../guides/download#download-files-to-local-folder">download guide</a>.',ht,z,ct,W,Ti="Integer value to define the number of seconds to wait for server response when fetching the latest metadata from a repo before downloading a file. If the request times out, <code>huggingface_hub</code> will default to the locally cached files. Setting a lower value speeds up the workflow for machines with a slow connection that have already cached files. A higher value guarantees the metadata call to succeed in more cases. Default to 10s.",pt,j,mt,X,wi="Integer value to define the number of seconds to wait for server response when downloading a file. If the request times out, a TimeoutError is raised. Setting a higher value is beneficial on machine with a slow connection. A smaller value makes the process fail quicker in case of complete network outage. Default to 10s.",gt,V,_t,J,Li=`The following environment variables expect a boolean value. The variable will be considered
as <code>True</code> if its value is one of <code>{&quot;1&quot;, &quot;ON&quot;, &quot;YES&quot;, &quot;TRUE&quot;}</code> (case-insensitive). Any other value
(or undefined) will be considered as <code>False</code>.`,Ht,Q,$t,Z,Ei="If set, no HTTP calls will me made to the Hugging Face Hub. If you try to download files, only the cached files will be accessed. If no cache file is detected, an error is raised This is useful in case your network is slow and you don’t care about having the latest version of a file.",bt,ee,Mi='If <code>HF_HUB_OFFLINE=1</code> is set as environment variable and you call any method of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, an <a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.OfflineModeIsEnabled">OfflineModeIsEnabled</a> exception will be raised.',vt,te,yi="<strong>Note:</strong> even if the latest version of a file is cached, calling <code>hf_hub_download</code> still triggers a HTTP request to check that a new version is not available. Setting <code>HF_HUB_OFFLINE=1</code> will skip this call which speeds up your loading time.",Tt,ie,wt,le,xi=`Authentication is not mandatory for every requests to the Hub. For instance, requesting
details about <code>&quot;gpt2&quot;</code> model does not require to be authenticated. However, if a user is
<a href="../package_reference/login">logged in</a>, the default behavior will be to always send the token
in order to ease user experience (never get a HTTP 401 Unauthorized) when accessing private or gated repositories. For privacy, you can
disable this behavior by setting <code>HF_HUB_DISABLE_IMPLICIT_TOKEN=1</code>. In this case,
the token will be sent only for “write-access” calls (example: create a commit).`,Lt,ne,Ci=`<strong>Note:</strong> disabling implicit sending of token can have weird side effects. For example,
if you want to list all models on the Hub, your private models will not be listed. You
would need to explicitly pass <code>token=True</code> argument in your script.`,Et,ae,Mt,oe,Fi=`For time consuming tasks, <code>huggingface_hub</code> displays a progress bar by default (using tqdm).
You can disable all the progress bars at once by setting <code>HF_HUB_DISABLE_PROGRESS_BARS=1</code>.`,yt,se,xt,re,Ai=`If you are on a Windows machine, it is recommended to enable the developer mode or to run
<code>huggingface_hub</code> in admin mode. If not, <code>huggingface_hub</code> will not be able to create
symlinks in your cache system. You will be able to execute any script but your user experience
will be degraded as some huge files might end-up duplicated on your hard-drive. A warning
message is triggered to warn you about this behavior. Set <code>HF_HUB_DISABLE_SYMLINKS_WARNING=1</code>,
to disable this warning.`,Ct,fe,Ii='For more details, see <a href="../guides/manage-cache#limitations">cache limitations</a>.',Ft,ue,At,de,Pi=`Some features of <code>huggingface_hub</code> are experimental. This means you can use them but we do not guarantee they will be
maintained in the future. In particular, we might update the API or behavior of such features without any deprecation
cycle. A warning message is triggered when using an experimental feature to warn you about it. If you’re comfortable debugging any potential issues using an experimental feature, you can set <code>HF_HUB_DISABLE_EXPERIMENTAL_WARNING=1</code> to disable the warning.`,It,he,Si="If you are using an experimental feature, please let us know! Your feedback can help us design and improve it.",Pt,ce,St,pe,Bi=`By default, some data is collected by HF libraries (<code>transformers</code>, <code>datasets</code>, <code>gradio</code>,..) to monitor usage, debug issues and help prioritize features.
Each library defines its own policy (i.e. which usage to monitor) but the core implementation happens in <code>huggingface_hub</code> (see <code>send_telemetry</code>).`,Bt,me,qi="You can set <code>HF_HUB_DISABLE_TELEMETRY=1</code> as environment variable to globally disable telemetry.",qt,ge,Ot,_e,Oi="Set to <code>True</code> for faster uploads and downloads from the Hub using <code>hf_transfer</code>.",Nt,He,Ni=`By default, <code>huggingface_hub</code> uses the Python-based <code>requests.get</code> and <code>requests.post</code> functions.
Although these are reliable and versatile,
they may not be the most efficient choice for machines with high bandwidth.
<a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a> is a Rust-based package developed to
maximize the bandwidth used by dividing large files into smaller parts
and transferring them simultaneously using multiple threads.
This approach can potentially double the transfer speed.
To use <code>hf_transfer</code>:`,kt,$e,ki=`<li>Specify the <code>hf_transfer</code> extra when installing <code>huggingface_hub</code>
(e.g. <code>pip install huggingface_hub[hf_transfer]</code>).</li> <li>Set <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable.</li>`,Ut,be,Ui="Please note that using <code>hf_transfer</code> comes with certain limitations. Since it is not purely Python-based, debugging errors may be challenging. Additionally, <code>hf_transfer</code> lacks several user-friendly features such as resumable downloads and proxies. These omissions are intentional to maintain the simplicity and speed of the Rust logic. Consequently, <code>hf_transfer</code> is not enabled by default in <code>huggingface_hub</code>.",Rt,ve,Dt,Te,Ri="In order to standardize all environment variables within the Hugging Face ecosystem, some variables have been marked as deprecated. Although they remain functional, they no longer take precedence over their replacements. The following table outlines the deprecated variables and their corresponding alternatives:",Gt,we,Di="<thead><tr><th>Deprecated Variable</th> <th>Replacement</th></tr></thead> <tbody><tr><td><code>HUGGINGFACE_HUB_CACHE</code></td> <td><code>HF_HUB_CACHE</code></td></tr> <tr><td><code>HUGGINGFACE_ASSETS_CACHE</code></td> <td><code>HF_ASSETS_CACHE</code></td></tr> <tr><td><code>HUGGING_FACE_HUB_TOKEN</code></td> <td><code>HF_TOKEN</code></td></tr> <tr><td><code>HUGGINGFACE_HUB_VERBOSITY</code></td> <td><code>HF_HUB_VERBOSITY</code></td></tr></tbody>",Yt,Le,Kt,Ee,Gi="Some environment variables are not specific to <code>huggingface_hub</code> but are still taken into account when they are set.",zt,Me,Wt,ye,Yi='Boolean value. Equivalent to <code>HF_HUB_DISABLE_TELEMETRY</code>. When set to true, telemetry is globally disabled in the Hugging Face Python ecosystem (<code>transformers</code>, <code>diffusers</code>, <code>gradio</code>, etc.). See <a href="https://consoledonottrack.com/" rel="nofollow">https://consoledonottrack.com/</a> for more details.',jt,xe,Xt,Ce,Ki=`Boolean value. When set, <code>huggingface-cli</code> tool will not print any ANSI color.
See <a href="https://no-color.org/" rel="nofollow">no-color.org</a>.`,Vt,Fe,Jt,Ae,zi="Used only when <code>HF_HOME</code> is not set!",Qt,Ie,Wi=`This is the default way to configure where <a href="https://wiki.archlinux.org/title/XDG_Base_Directory" rel="nofollow">user-specific non-essential (cached) data should be written</a>
on linux machines.`,Zt,Pe,ji=`If <code>HF_HOME</code> is not set, the default home will be <code>&quot;$XDG_CACHE_HOME/huggingface&quot;</code> instead
of <code>&quot;~/.cache/huggingface&quot;</code>.`,ei,Be,ti;return _=new m({props:{title:"Environment variables",local:"environment-variables",headingTag:"h1"}}),v=new m({props:{title:"Generic",local:"generic",headingTag:"h2"}}),T=new m({props:{title:"HF_INFERENCE_ENDPOINT",local:"hfinferenceendpoint",headingTag:"h3"}}),E=new m({props:{title:"HF_HOME",local:"hfhome",headingTag:"h3"}}),x=new m({props:{title:"HF_HUB_CACHE",local:"hfhubcache",headingTag:"h3"}}),A=new m({props:{title:"HF_ASSETS_CACHE",local:"hfassetscache",headingTag:"h3"}}),S=new m({props:{title:"HF_TOKEN",local:"hftoken",headingTag:"h3"}}),O=new m({props:{title:"HF_TOKEN_PATH",local:"hftokenpath",headingTag:"h3"}}),k=new m({props:{title:"HF_HUB_VERBOSITY",local:"hfhubverbosity",headingTag:"h3"}}),G=new m({props:{title:"HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD",local:"hfhublocaldirautosymlinkthreshold",headingTag:"h3"}}),z=new m({props:{title:"HF_HUB_ETAG_TIMEOUT",local:"hfhubetagtimeout",headingTag:"h3"}}),j=new m({props:{title:"HF_HUB_DOWNLOAD_TIMEOUT",local:"hfhubdownloadtimeout",headingTag:"h3"}}),V=new m({props:{title:"Boolean values",local:"boolean-values",headingTag:"h2"}}),Q=new m({props:{title:"HF_HUB_OFFLINE",local:"hfhuboffline",headingTag:"h3"}}),ie=new m({props:{title:"HF_HUB_DISABLE_IMPLICIT_TOKEN",local:"hfhubdisableimplicittoken",headingTag:"h3"}}),ae=new m({props:{title:"HF_HUB_DISABLE_PROGRESS_BARS",local:"hfhubdisableprogressbars",headingTag:"h3"}}),se=new m({props:{title:"HF_HUB_DISABLE_SYMLINKS_WARNING",local:"hfhubdisablesymlinkswarning",headingTag:"h3"}}),ue=new m({props:{title:"HF_HUB_DISABLE_EXPERIMENTAL_WARNING",local:"hfhubdisableexperimentalwarning",headingTag:"h3"}}),ce=new m({props:{title:"HF_HUB_DISABLE_TELEMETRY",local:"hfhubdisabletelemetry",headingTag:"h3"}}),ge=new m({props:{title:"HF_HUB_ENABLE_HF_TRANSFER",local:"hfhubenablehftransfer",headingTag:"h3"}}),ve=new m({props:{title:"Deprecated environment variables",local:"deprecated-environment-variables",headingTag:"h2"}}),Le=new m({props:{title:"From external tools",local:"from-external-tools",headingTag:"h2"}}),Me=new m({props:{title:"DO_NOT_TRACK",local:"donottrack",headingTag:"h3"}}),xe=new m({props:{title:"NO_COLOR",local:"nocolor",headingTag:"h3"}}),Fe=new m({props:{title:"XDG_CACHE_HOME",local:"xdgcachehome",headingTag:"h3"}}),{c(){g=o("meta"),qe=n(),Se=o("p"),Oe=n(),f(_.$$.fragment),Ne=n(),H=o("p"),H.innerHTML=li,ke=n(),$=o("p"),$.innerHTML=ni,Ue=n(),b=o("p"),b.innerHTML=ai,Re=n(),f(v.$$.fragment),De=n(),f(T.$$.fragment),Ge=n(),w=o("p"),w.textContent=oi,Ye=n(),L=o("p"),L.innerHTML=si,Ke=n(),f(E.$$.fragment),ze=n(),M=o("p"),M.innerHTML=ri,We=n(),y=o("p"),y.innerHTML=fi,je=n(),f(x.$$.fragment),Xe=n(),C=o("p"),C.textContent=ui,Ve=n(),F=o("p"),F.innerHTML=di,Je=n(),f(A.$$.fragment),Qe=n(),I=o("p"),I.innerHTML=hi,Ze=n(),P=o("p"),P.innerHTML=ci,et=n(),f(S.$$.fragment),tt=n(),B=o("p"),B.innerHTML=pi,it=n(),q=o("p"),q.innerHTML=mi,lt=n(),f(O.$$.fragment),nt=n(),N=o("p"),N.innerHTML=gi,at=n(),f(k.$$.fragment),ot=n(),U=o("p"),U.innerHTML=_i,st=n(),R=o("p"),R.innerHTML=Hi,rt=n(),D=o("p"),D.innerHTML=$i,ft=n(),f(G.$$.fragment),ut=n(),Y=o("p"),Y.textContent=bi,dt=n(),K=o("p"),K.innerHTML=vi,ht=n(),f(z.$$.fragment),ct=n(),W=o("p"),W.innerHTML=Ti,pt=n(),f(j.$$.fragment),mt=n(),X=o("p"),X.textContent=wi,gt=n(),f(V.$$.fragment),_t=n(),J=o("p"),J.innerHTML=Li,Ht=n(),f(Q.$$.fragment),$t=n(),Z=o("p"),Z.textContent=Ei,bt=n(),ee=o("p"),ee.innerHTML=Mi,vt=n(),te=o("p"),te.innerHTML=yi,Tt=n(),f(ie.$$.fragment),wt=n(),le=o("p"),le.innerHTML=xi,Lt=n(),ne=o("p"),ne.innerHTML=Ci,Et=n(),f(ae.$$.fragment),Mt=n(),oe=o("p"),oe.innerHTML=Fi,yt=n(),f(se.$$.fragment),xt=n(),re=o("p"),re.innerHTML=Ai,Ct=n(),fe=o("p"),fe.innerHTML=Ii,Ft=n(),f(ue.$$.fragment),At=n(),de=o("p"),de.innerHTML=Pi,It=n(),he=o("p"),he.textContent=Si,Pt=n(),f(ce.$$.fragment),St=n(),pe=o("p"),pe.innerHTML=Bi,Bt=n(),me=o("p"),me.innerHTML=qi,qt=n(),f(ge.$$.fragment),Ot=n(),_e=o("p"),_e.innerHTML=Oi,Nt=n(),He=o("p"),He.innerHTML=Ni,kt=n(),$e=o("ol"),$e.innerHTML=ki,Ut=n(),be=o("p"),be.innerHTML=Ui,Rt=n(),f(ve.$$.fragment),Dt=n(),Te=o("p"),Te.textContent=Ri,Gt=n(),we=o("table"),we.innerHTML=Di,Yt=n(),f(Le.$$.fragment),Kt=n(),Ee=o("p"),Ee.innerHTML=Gi,zt=n(),f(Me.$$.fragment),Wt=n(),ye=o("p"),ye.innerHTML=Yi,jt=n(),f(xe.$$.fragment),Xt=n(),Ce=o("p"),Ce.innerHTML=Ki,Vt=n(),f(Fe.$$.fragment),Jt=n(),Ae=o("p"),Ae.innerHTML=zi,Qt=n(),Ie=o("p"),Ie.innerHTML=Wi,Zt=n(),Pe=o("p"),Pe.innerHTML=ji,ei=n(),Be=o("p"),this.h()},l(e){const t=il("svelte-u9bgzb",document.head);g=s(t,"META",{name:!0,content:!0}),t.forEach(i),qe=a(e),Se=s(e,"P",{}),Xi(Se).forEach(i),Oe=a(e),u(_.$$.fragment,e),Ne=a(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1xuew16"&&(H.innerHTML=li),ke=a(e),$=s(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1by1ave"&&($.innerHTML=ni),Ue=a(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-5z5k2g"&&(b.innerHTML=ai),Re=a(e),u(v.$$.fragment,e),De=a(e),u(T.$$.fragment,e),Ge=a(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-178hqev"&&(w.textContent=oi),Ye=a(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1jcmi14"&&(L.innerHTML=si),Ke=a(e),u(E.$$.fragment,e),ze=a(e),M=s(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-uz9mxv"&&(M.innerHTML=ri),We=a(e),y=s(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1x0d3ca"&&(y.innerHTML=fi),je=a(e),u(x.$$.fragment,e),Xe=a(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-lfw4ab"&&(C.textContent=ui),Ve=a(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-a5p60a"&&(F.innerHTML=di),Je=a(e),u(A.$$.fragment,e),Qe=a(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ksjawo"&&(I.innerHTML=hi),Ze=a(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3wzlwo"&&(P.innerHTML=ci),et=a(e),u(S.$$.fragment,e),tt=a(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-81jzle"&&(B.innerHTML=pi),it=a(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-pa4dpn"&&(q.innerHTML=mi),lt=a(e),u(O.$$.fragment,e),nt=a(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ks6kva"&&(N.innerHTML=gi),at=a(e),u(k.$$.fragment,e),ot=a(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-t9rwl1"&&(U.innerHTML=_i),st=a(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4zt9wc"&&(R.innerHTML=Hi),rt=a(e),D=s(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-5rzz4d"&&(D.innerHTML=$i),ft=a(e),u(G.$$.fragment,e),ut=a(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-gmny4d"&&(Y.textContent=bi),dt=a(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-18kg6sw"&&(K.innerHTML=vi),ht=a(e),u(z.$$.fragment,e),ct=a(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14q9j1n"&&(W.innerHTML=Ti),pt=a(e),u(j.$$.fragment,e),mt=a(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-8qjsc"&&(X.textContent=wi),gt=a(e),u(V.$$.fragment,e),_t=a(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1enkv8e"&&(J.innerHTML=Li),Ht=a(e),u(Q.$$.fragment,e),$t=a(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-l2giw3"&&(Z.textContent=Ei),bt=a(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-12xdqcw"&&(ee.innerHTML=Mi),vt=a(e),te=s(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-p6ydxq"&&(te.innerHTML=yi),Tt=a(e),u(ie.$$.fragment,e),wt=a(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1gxpflx"&&(le.innerHTML=xi),Lt=a(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-d0rh1g"&&(ne.innerHTML=Ci),Et=a(e),u(ae.$$.fragment,e),Mt=a(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-192tmol"&&(oe.innerHTML=Fi),yt=a(e),u(se.$$.fragment,e),xt=a(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1a5ggf9"&&(re.innerHTML=Ai),Ct=a(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1wsb5xe"&&(fe.innerHTML=Ii),Ft=a(e),u(ue.$$.fragment,e),At=a(e),de=s(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-16gkjc3"&&(de.innerHTML=Pi),It=a(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-140g1ix"&&(he.textContent=Si),Pt=a(e),u(ce.$$.fragment,e),St=a(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-yphpce"&&(pe.innerHTML=Bi),Bt=a(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-h3tzls"&&(me.innerHTML=qi),qt=a(e),u(ge.$$.fragment,e),Ot=a(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1nmal47"&&(_e.innerHTML=Oi),Nt=a(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1qiqswm"&&(He.innerHTML=Ni),kt=a(e),$e=s(e,"OL",{"data-svelte-h":!0}),r($e)!=="svelte-qiartd"&&($e.innerHTML=ki),Ut=a(e),be=s(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-a4nd83"&&(be.innerHTML=Ui),Rt=a(e),u(ve.$$.fragment,e),Dt=a(e),Te=s(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1xlsmjd"&&(Te.textContent=Ri),Gt=a(e),we=s(e,"TABLE",{"data-svelte-h":!0}),r(we)!=="svelte-19wux3d"&&(we.innerHTML=Di),Yt=a(e),u(Le.$$.fragment,e),Kt=a(e),Ee=s(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-6ntlb2"&&(Ee.innerHTML=Gi),zt=a(e),u(Me.$$.fragment,e),Wt=a(e),ye=s(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-yngnil"&&(ye.innerHTML=Yi),jt=a(e),u(xe.$$.fragment,e),Xt=a(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-16nqegp"&&(Ce.innerHTML=Ki),Vt=a(e),u(Fe.$$.fragment,e),Jt=a(e),Ae=s(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-38e7oi"&&(Ae.innerHTML=zi),Qt=a(e),Ie=s(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-khdsxn"&&(Ie.innerHTML=Wi),Zt=a(e),Pe=s(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-hhj9xt"&&(Pe.innerHTML=ji),ei=a(e),Be=s(e,"P",{}),Xi(Be).forEach(i),this.h()},h(){Vi(g,"name","hf:doc:metadata"),Vi(g,"content",al)},m(e,t){ll(document.head,g),l(e,qe,t),l(e,Se,t),l(e,Oe,t),d(_,e,t),l(e,Ne,t),l(e,H,t),l(e,ke,t),l(e,$,t),l(e,Ue,t),l(e,b,t),l(e,Re,t),d(v,e,t),l(e,De,t),d(T,e,t),l(e,Ge,t),l(e,w,t),l(e,Ye,t),l(e,L,t),l(e,Ke,t),d(E,e,t),l(e,ze,t),l(e,M,t),l(e,We,t),l(e,y,t),l(e,je,t),d(x,e,t),l(e,Xe,t),l(e,C,t),l(e,Ve,t),l(e,F,t),l(e,Je,t),d(A,e,t),l(e,Qe,t),l(e,I,t),l(e,Ze,t),l(e,P,t),l(e,et,t),d(S,e,t),l(e,tt,t),l(e,B,t),l(e,it,t),l(e,q,t),l(e,lt,t),d(O,e,t),l(e,nt,t),l(e,N,t),l(e,at,t),d(k,e,t),l(e,ot,t),l(e,U,t),l(e,st,t),l(e,R,t),l(e,rt,t),l(e,D,t),l(e,ft,t),d(G,e,t),l(e,ut,t),l(e,Y,t),l(e,dt,t),l(e,K,t),l(e,ht,t),d(z,e,t),l(e,ct,t),l(e,W,t),l(e,pt,t),d(j,e,t),l(e,mt,t),l(e,X,t),l(e,gt,t),d(V,e,t),l(e,_t,t),l(e,J,t),l(e,Ht,t),d(Q,e,t),l(e,$t,t),l(e,Z,t),l(e,bt,t),l(e,ee,t),l(e,vt,t),l(e,te,t),l(e,Tt,t),d(ie,e,t),l(e,wt,t),l(e,le,t),l(e,Lt,t),l(e,ne,t),l(e,Et,t),d(ae,e,t),l(e,Mt,t),l(e,oe,t),l(e,yt,t),d(se,e,t),l(e,xt,t),l(e,re,t),l(e,Ct,t),l(e,fe,t),l(e,Ft,t),d(ue,e,t),l(e,At,t),l(e,de,t),l(e,It,t),l(e,he,t),l(e,Pt,t),d(ce,e,t),l(e,St,t),l(e,pe,t),l(e,Bt,t),l(e,me,t),l(e,qt,t),d(ge,e,t),l(e,Ot,t),l(e,_e,t),l(e,Nt,t),l(e,He,t),l(e,kt,t),l(e,$e,t),l(e,Ut,t),l(e,be,t),l(e,Rt,t),d(ve,e,t),l(e,Dt,t),l(e,Te,t),l(e,Gt,t),l(e,we,t),l(e,Yt,t),d(Le,e,t),l(e,Kt,t),l(e,Ee,t),l(e,zt,t),d(Me,e,t),l(e,Wt,t),l(e,ye,t),l(e,jt,t),d(xe,e,t),l(e,Xt,t),l(e,Ce,t),l(e,Vt,t),d(Fe,e,t),l(e,Jt,t),l(e,Ae,t),l(e,Qt,t),l(e,Ie,t),l(e,Zt,t),l(e,Pe,t),l(e,ei,t),l(e,Be,t),ti=!0},p:Qi,i(e){ti||(h(_.$$.fragment,e),h(v.$$.fragment,e),h(T.$$.fragment,e),h(E.$$.fragment,e),h(x.$$.fragment,e),h(A.$$.fragment,e),h(S.$$.fragment,e),h(O.$$.fragment,e),h(k.$$.fragment,e),h(G.$$.fragment,e),h(z.$$.fragment,e),h(j.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ue.$$.fragment,e),h(ce.$$.fragment,e),h(ge.$$.fragment,e),h(ve.$$.fragment,e),h(Le.$$.fragment,e),h(Me.$$.fragment,e),h(xe.$$.fragment,e),h(Fe.$$.fragment,e),ti=!0)},o(e){c(_.$$.fragment,e),c(v.$$.fragment,e),c(T.$$.fragment,e),c(E.$$.fragment,e),c(x.$$.fragment,e),c(A.$$.fragment,e),c(S.$$.fragment,e),c(O.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(z.$$.fragment,e),c(j.$$.fragment,e),c(V.$$.fragment,e),c(Q.$$.fragment,e),c(ie.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(ge.$$.fragment,e),c(ve.$$.fragment,e),c(Le.$$.fragment,e),c(Me.$$.fragment,e),c(xe.$$.fragment,e),c(Fe.$$.fragment,e),ti=!1},d(e){e&&(i(qe),i(Se),i(Oe),i(Ne),i(H),i(ke),i($),i(Ue),i(b),i(Re),i(De),i(Ge),i(w),i(Ye),i(L),i(Ke),i(ze),i(M),i(We),i(y),i(je),i(Xe),i(C),i(Ve),i(F),i(Je),i(Qe),i(I),i(Ze),i(P),i(et),i(tt),i(B),i(it),i(q),i(lt),i(nt),i(N),i(at),i(ot),i(U),i(st),i(R),i(rt),i(D),i(ft),i(ut),i(Y),i(dt),i(K),i(ht),i(ct),i(W),i(pt),i(mt),i(X),i(gt),i(_t),i(J),i(Ht),i($t),i(Z),i(bt),i(ee),i(vt),i(te),i(Tt),i(wt),i(le),i(Lt),i(ne),i(Et),i(Mt),i(oe),i(yt),i(xt),i(re),i(Ct),i(fe),i(Ft),i(At),i(de),i(It),i(he),i(Pt),i(St),i(pe),i(Bt),i(me),i(qt),i(Ot),i(_e),i(Nt),i(He),i(kt),i($e),i(Ut),i(be),i(Rt),i(Dt),i(Te),i(Gt),i(we),i(Yt),i(Kt),i(Ee),i(zt),i(Wt),i(ye),i(jt),i(Xt),i(Ce),i(Vt),i(Jt),i(Ae),i(Qt),i(Ie),i(Zt),i(Pe),i(ei),i(Be)),i(g),p(_,e),p(v,e),p(T,e),p(E,e),p(x,e),p(A,e),p(S,e),p(O,e),p(k,e),p(G,e),p(z,e),p(j,e),p(V,e),p(Q,e),p(ie,e),p(ae,e),p(se,e),p(ue,e),p(ce,e),p(ge,e),p(ve,e),p(Le,e),p(Me,e),p(xe,e),p(Fe,e)}}}const al='{"title":"Environment variables","local":"environment-variables","sections":[{"title":"Generic","local":"generic","sections":[{"title":"HF_INFERENCE_ENDPOINT","local":"hfinferenceendpoint","sections":[],"depth":3},{"title":"HF_HOME","local":"hfhome","sections":[],"depth":3},{"title":"HF_HUB_CACHE","local":"hfhubcache","sections":[],"depth":3},{"title":"HF_ASSETS_CACHE","local":"hfassetscache","sections":[],"depth":3},{"title":"HF_TOKEN","local":"hftoken","sections":[],"depth":3},{"title":"HF_TOKEN_PATH","local":"hftokenpath","sections":[],"depth":3},{"title":"HF_HUB_VERBOSITY","local":"hfhubverbosity","sections":[],"depth":3},{"title":"HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD","local":"hfhublocaldirautosymlinkthreshold","sections":[],"depth":3},{"title":"HF_HUB_ETAG_TIMEOUT","local":"hfhubetagtimeout","sections":[],"depth":3},{"title":"HF_HUB_DOWNLOAD_TIMEOUT","local":"hfhubdownloadtimeout","sections":[],"depth":3}],"depth":2},{"title":"Boolean values","local":"boolean-values","sections":[{"title":"HF_HUB_OFFLINE","local":"hfhuboffline","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_IMPLICIT_TOKEN","local":"hfhubdisableimplicittoken","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_PROGRESS_BARS","local":"hfhubdisableprogressbars","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_SYMLINKS_WARNING","local":"hfhubdisablesymlinkswarning","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_EXPERIMENTAL_WARNING","local":"hfhubdisableexperimentalwarning","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_TELEMETRY","local":"hfhubdisabletelemetry","sections":[],"depth":3},{"title":"HF_HUB_ENABLE_HF_TRANSFER","local":"hfhubenablehftransfer","sections":[],"depth":3}],"depth":2},{"title":"Deprecated environment variables","local":"deprecated-environment-variables","sections":[],"depth":2},{"title":"From external tools","local":"from-external-tools","sections":[{"title":"DO_NOT_TRACK","local":"donottrack","sections":[],"depth":3},{"title":"NO_COLOR","local":"nocolor","sections":[],"depth":3},{"title":"XDG_CACHE_HOME","local":"xdgcachehome","sections":[],"depth":3}],"depth":2}],"depth":1}';function ol(ii){return Zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends el{constructor(g){super(),tl(this,g,ol,nl,Ji,{})}}export{ul as component};
