import{s as Cs,o as xs,n as Xs}from"../chunks/scheduler.7da89386.js";import{S as Rs,i as Ys,g as c,s as a,r as p,A as Ls,h as f,f as s,c as n,j as Zs,u as i,x as h,k as ks,y as qs,a as l,v as r,d as g,t as m,w as o}from"../chunks/index.20910acc.js";import{T as Hs}from"../chunks/Tip.53e22153.js";import{C as y}from"../chunks/CodeBlock.cde23137.js";import{H as u}from"../chunks/Heading.4cf72777.js";function Fs(xe){let $,M='GitLab/GitHub/Bitbucket과 같은 플랫폼을 사용해 본 경험이 있다면, 모델 리포지토리를 관리하기 위해 <code>git</code> CLI를 사용해 git 리포지토리를 클론(<code>git clone</code>)하고 변경 사항을 커밋(<code>git add, git commit</code>)하고 커밋한 내용을 푸시(<code>git push</code>) 하는것이 가장 먼저 떠오를 것입니다. 이 명령어들은 Hugging Face Hub에서도 사용할 수 있습니다. 하지만 소프트웨어 엔지니어링과 머신러닝은 동일한 요구 사항과 워크플로우를 공유하지 않습니다. 모델 리포지토리는 다양한 프레임워크와 도구를 위한 대규모 모델 가중치 파일을 유지관리 할 수 있으므로, 리포지토리를 복제하면 대규모 로컬 폴더를 유지관리하고 막대한 크기의 파일을 다루게 될 수 있습니다. 결과적으로 Hugging Face의 커스텀 HTTP 방법을 사용하는 것이 더욱 효율적일 수 있습니다. 더 자세한 내용은 <a href="../concepts/git_vs_http">Git vs HTTP paradigm</a> 문서를 참조하세요.';return{c(){$=c("p"),$.innerHTML=M},l(d){$=f(d,"P",{"data-svelte-h":!0}),h($)!=="svelte-cpbzvt"&&($.innerHTML=M)},m(d,b){l(d,$,b)},p:Xs,d(d){d&&s($)}}}function Is(xe){let $,M='<a href="/docs/huggingface_hub/main/ko/package_reference/repository#huggingface_hub.Repository">Repository</a>는 <code>HfApi</code>에 구현된 HTTP 기반 대안을 선호하여 중단되었습니다. 아직 많은 레거시 코드에서 사용되고 있기 때문에 <a href="/docs/huggingface_hub/main/ko/package_reference/repository#huggingface_hub.Repository">Repository</a>가 완전히 제거되는 건 <code>v1.0</code> 릴리스에서만 이루어집니다. 자세한 내용은 <a href="./concepts/git_vs_http">해당 설명 페이지</a>를 참조하세요.';return{c(){$=c("p"),$.innerHTML=M},l(d){$=f(d,"P",{"data-svelte-h":!0}),h($)!=="svelte-k6u26s"&&($.innerHTML=M)},m(d,b){l(d,$,b)},p:Xs,d(d){d&&s($)}}}function Ns(xe){let $,M,d,b,j,Ye,v,Dt='Hugging Face Hub는 Git 리포지토리 모음입니다. <a href="https://git-scm.com/" rel="nofollow">Git</a>은 협업을 할 때 여러 프로젝트 버전을 쉽게 관리하기 위해 널리 사용되는 소프트웨어 개발 도구입니다. 이 가이드에서는 Hub의 리포지토리 사용법인 다음 내용을 다룹니다:',Le,J,Kt="<li>리포지토리 생성과 삭제.</li> <li>태그 및 브랜치 관리.</li> <li>리포지토리 이름 변경.</li> <li>리포지토리 공개 여부.</li> <li>리포지토리 복사본 관리.</li>",qe,T,Fe,w,At='Hub에 리포지토리를 생성하고 관리하려면, 로그인이 되어 있어야 합니다. 로그인이 안 되어있다면 <a href="../quick-start#authentication">이 문서</a>를 참고해 주세요. 이 가이드에서는 로그인이 되어있다는 가정하에 진행됩니다.',Ie,G,Ne,U,Ot="첫 번째 단계는 어떻게 리포지토리를 생성하고 삭제하는지를 알아야 합니다. 사용자 이름 네임스페이스 아래에 소유한 리포지토리 또는 쓰기 권한이 있는 조직의 리포지토리만 관리할 수 있습니다.",We,Z,Be,k,es="<code>create_repo()</code> 함수로 함께 빈 리포지토리를 만들고 <code>repo_id</code> 매개변수를 사용하여 이름을 정하세요. <code>repo_id</code>는 사용자 이름 또는 조직 이름 뒤에 리포지토리 이름이 따라옵니다: <code>username_or_org/repo_name</code>.",Ve,H,Se,X,ts="기본적으로 <code>create_repo()</code>는 모델 리포지토리를 만듭니다. 하지만 <code>repo_type</code> 매개변수를 사용하여 다른 유형의 리포지토리를 지정할 수 있습니다. 예를 들어 데이터셋 리포지토리를 만들고 싶다면:",ze,C,Pe,x,ss="리포지토리를 만들 때, <code>private</code> 매개변수를 사용하여 가시성을 설정할 수 있습니다.",Qe,R,Ee,Y,ls="추후 리포지토리 가시성을 변경하고 싶다면, <code>update_repo_visibility()</code> 함수를 이용해 바꿀 수 있습니다.",De,L,Ke,q,as="<code>delete_repo()</code>를 사용하여 리포지토리를 삭제할 수 있습니다. 리포지토리를 삭제하기 전에 신중히 결정하세요. 왜냐하면, 삭제하고 나서 다시 되돌릴 수 없는 프로세스이기 때문입니다!",Ae,F,ns="삭제하려는 리포지토리의 <code>repo_id</code>를 지정하세요:",Oe,I,et,N,tt,W,ps='가끔 다른 누군가의 리포지토리를 복사하여, 상황에 맞게 수정하고 싶을 때가 있습니다. 이는 <code>duplicate_space()</code>를 사용하여 Space에 복사할 수 있습니다. 이 함수를 사용하면 리포지토리 전체를 복제할 수 있습니다. 그러나 여전히 하드웨어, 절전 시간, 리포지토리, 변수 및 비밀번호와 같은 자체 설정을 구성해야 합니다. 자세한 내용은 <a href="./manage-spaces">Manage your Space</a> 문서를 참조하십시오.',st,B,lt,V,at,S,is="이제 리포지토리를 생성했으므로, 변경 사항을 푸시하고 파일을 다운로드하는 것에 관심이 있을 것입니다.",nt,z,rs='이 두 가지 주제는 각각 자체 가이드가 필요합니다. 리포지토리 사용하는 방법에 대해 알아보려면 <a href="./upload">업로드</a> 및 <a href="./download">다운로드</a> 문서를 참조하세요.',pt,P,it,Q,gs=`Git 리포지토리는 동일한 리포지토리의 다른 버전을 저장하기 위해 브랜치들을 사용합니다. 태그는 버전을 출시할 때와 같이 리포지토리의 특정 상태를 표시하는 데 사용될 수도 있습니다. 일반적으로 브랜치와 태그는 <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References" rel="nofollow">git 참조</a>
로 참조됩니다.`,rt,E,gt,D,ms="<code>create_branch()</code>와 <code>create_tag()</code>를 이용하여 새로운 브랜치와 태그를 생성할 수 있습니다.",mt,K,ot,A,os="같은 방식으로 <code>delete_branch()</code>와 <code>delete_tag()</code> 함수를 사용하여 브랜치 또는 태그를 삭제할 수 있습니다.",ct,O,ft,ee,cs="<code>list_repo_refs()</code>를 사용하여 리포지토리로부터 현재 존재하는 git 참조를 나열할 수 있습니다:",ht,te,$t,se,dt,le,fs="리포지토리는 구성할 수 있는 몇 가지 설정이 있습니다. 대부분의 경우 브라우저의 리포지토리 설정 페이지에서 직접 설정할 것입니다. 설정을 바꾸려면 리포지토리에 대한 쓰기 액세스 권한이 있어야 합니다(사용자 리포지토리거나, 조직의 구성원이어야 함). 이 주제에서는 <code>huggingface_hub</code>를 사용하여 프로그래밍 방식으로 구성할 수 있는 설정을 알아보겠습니다.",yt,ae,hs='Spaces를 위한 특정 설정들(하드웨어, 환경변수 등)을 구성하기 위해서는 <a href="../guides/manage-spaces">Manage your Spaces</a> 문서를 참조하세요.',ut,ne,Mt,pe,$s="리포지토리는 공개 또는 비공개로 설정할 수 있습니다. 비공개 리포지토리는 해당 저장소의 사용자 혹은 소속된 조직의 구성원만 볼 수 있습니다. 다음과 같이 리포지토리를 비공개로 변경할 수 있습니다.",bt,ie,Tt,re,_t,ge,ds='<code>move_repo()</code>를 사용하여 Hub에 있는 리포지토리 이름을 변경할 수 있습니다. 이 함수를 사용하여 개인에서 조직 리포지토리로 이동할 수도 있습니다. 이렇게 하면 <a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">일부 제한 사항</a>이 있으므로 주의해야 합니다. 예를 들어, 다른 사용자에게 리포지토리를 이전할 수는 없습니다.',jt,me,vt,oe,Jt,ce,ys="위에 설명한 모든 작업은 HTTP 요청을 사용하여 작업할 수 있습니다. 그러나 경우에 따라 로컬 복사본을 가지고 익숙한 Git 명령어를 사용하여 상호 작용하는 것이 편리할 수 있습니다.",wt,fe,us='<a href="/docs/huggingface_hub/main/ko/package_reference/repository#huggingface_hub.Repository">Repository</a> 클래스는 Git 명령어와 유사한 기능을 제공하는 함수를 사용하여 Hub의 파일 및 리포지토리와 상호 작용할 수 있습니다. 이는 이미 알고 있고 좋아하는 Git 및 Git-LFS 방법을 사용하는 래퍼(wrapper)입니다. 시작하기 전에 Git-LFS가 설치되어 있는지 확인하세요(<a href="https://git-lfs.github.com/" rel="nofollow">여기서</a> 설치 지침을 확인할 수 있습니다).',Gt,_,Ut,he,Zt,$e,Ms='로컬 리포지토리 경로를 사용하여 <a href="/docs/huggingface_hub/main/ko/package_reference/repository#huggingface_hub.Repository">Repository</a> 객체를 생성하세요:',kt,de,Ht,ye,Xt,ue,bs="<code>clone_from</code> 매개변수는 Hugging Face 리포지토리 ID에서 로컬 디렉터리로 리포지토리를 복제합니다. 이때 <code>local_dir</code> 매개변수를 사용하여 로컬 디렉터리에 저장합니다:",Ct,Me,xt,be,Ts="<code>clone_from</code>은 URL을 사용해 리포지토리를 복제할 수 있습니다.",Rt,Te,Yt,_e,_s="<code>clone_from</code> 매개변수를 <code>create_repo()</code>와 결합하여 리포지토리를 만들고 복제할 수 있습니다.",Lt,je,qt,ve,js="리포지토리를 복제할 때 <code>git_user</code> 및 <code>git_email</code> 매개변수를 지정함으로써 복제한 리포지토리에 Git 사용자 이름과 이메일을 설정할 수 있습니다. 사용자가 해당 리포지토리에 커밋하면 Git은 커밋 작성자를 인식합니다.",Ft,Je,It,we,Nt,Ge,vs='브랜치는 현재 코드와 파일에 영향을 미치지 않으면서 협업과 실험에 중요합니다.<a href="/docs/huggingface_hub/main/ko/package_reference/repository#huggingface_hub.Repository.git_checkout">git_checkout()</a>을 사용하여 브랜치 간에 전환할 수 있습니다. 예를 들어, <code>branch1</code>에서 <code>branch2</code>로 전환하려면:',Wt,Ue,Bt,Ze,Vt,ke,Js='<a href="/docs/huggingface_hub/main/ko/package_reference/repository#huggingface_hub.Repository.git_pull">git_pull()</a>은 원격 리포지토리로부터의 변경사항을 현재 로컬 브랜치에 업데이트하게 합니다.',St,He,zt,Xe,ws="브랜치가 원격에서의 새 커밋으로 업데이트 된 후에 로컬 커밋을 수행하고자 한다면 <code>rebase=True</code>를 설정하세요:",Pt,Ce,Qt,Re,Et;return j=new u({props:{title:"리포지토리 생성과 관리",local:"create-and-manage-a-repository",headingTag:"h1"}}),T=new Hs({props:{warning:!0,$$slots:{default:[Fs]},$$scope:{ctx:xe}}}),G=new u({props:{title:"리포지토리 생성 및 삭제",local:"repo-creation-and-deletion",headingTag:"h2"}}),Z=new u({props:{title:"리포지토리 생성",local:"create-a-repository",headingTag:"h3"}}),H=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),C=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/datasets/lysandre/test-dataset&#x27;</span>`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-private&quot;</span>, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new u({props:{title:"리포지토리 삭제",local:"delete-a-repository",headingTag:"h3"}}),I=new y({props:{code:"ZGVsZXRlX3JlcG8ocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGbXktY29ycnVwdGVkLWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>delete_repo(repo_id=<span class="hljs-string">&quot;lysandre/my-corrupted-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)',wrap:!1}}),N=new u({props:{title:"리포지토리 복제(Spaces 전용)",local:"duplicate-a-repository-only-for-spaces",headingTag:"h3"}}),B=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, private=<span class="hljs-literal">False</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)`,wrap:!1}}),V=new u({props:{title:"파일 다운로드와 업로드",local:"upload-and-download-files",headingTag:"h2"}}),P=new u({props:{title:"브랜치와 태그",local:"branches-and-tags",headingTag:"h2"}}),E=new u({props:{title:"브랜치 생성과 태그",local:"create-branches-and-tags",headingTag:"h3"}}),K=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9icmFuY2glMkMlMjBjcmVhdGVfdGFnJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJNYXR0aGlqcyUyRnNwZWVjaHQ1LXR0cy1kZW1vJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjBicmFuY2glM0QlMjJoYW5kbGUtZG9nLXNwZWFrZXIlMjIpJTBBJTBBY3JlYXRlX3RhZyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjAuMS1yZWxlYXNlJTIyJTJDJTIwdGFnJTNEJTIydjAuMS4xJTIyJTJDJTIwdGFnX21lc3NhZ2UlM0QlMjJCdW1wJTIwcmVsZWFzZSUyMHZlcnNpb24uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_branch, create_tag

<span class="hljs-comment"># \`main\` 브랜치를 기반으로 Space 저장소에 새 브랜치를 생성합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;Matthijs/speecht5-tts-demo&quot;</span>, repo_type=<span class="hljs-string">&quot;space&quot;</span>, branch=<span class="hljs-string">&quot;handle-dog-speaker&quot;</span>)

<span class="hljs-comment"># \`v0.1-release\` 브랜치를 기반으로 Dataset 저장소에 태그를 생성합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_tag(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, revision=<span class="hljs-string">&quot;v0.1-release&quot;</span>, tag=<span class="hljs-string">&quot;v0.1.1&quot;</span>, tag_message=<span class="hljs-string">&quot;Bump release version.&quot;</span>)`,wrap:!1}}),O=new u({props:{title:"모든 브랜치와 태그 나열",local:"list-all-branches-and-tags",headingTag:"h3"}}),te=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19yZWZzJTBBbGlzdF9yZXBvX3JlZnMoJTIyYmlnY29kZSUyRnRoZS1zdGFjayUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_refs
<span class="hljs-meta">&gt;&gt;&gt; </span>list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
GitRefs(
   branches=[
         GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
   ],
   converts=[],
   tags=[
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
   ]
)`,wrap:!1}}),se=new u({props:{title:"리포지토리 설정 변경",local:"change-repository-settings",headingTag:"h2"}}),ne=new u({props:{title:"가시성 업데이트",local:"update-visibility",headingTag:"h3"}}),ie=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9yZXBvX3Zpc2liaWxpdHklMEF1cGRhdGVfcmVwb192aXNpYmlsaXR5KHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwcHJpdmF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_repo_visibility
<span class="hljs-meta">&gt;&gt;&gt; </span>update_repo_visibility(repo_id=repo_id, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),re=new u({props:{title:"리포지토리 이름 변경",local:"rename-your-repository",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1vdmVfcmVwbyUwQW1vdmVfcmVwbyhmcm9tX2lkJTNEJTIyV2F1cGxpbiUyRmNvb2wtbW9kZWwlMjIlMkMlMjB0b19pZCUzRCUyMmh1Z2dpbmdmYWNlJTJGY29vbC1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> move_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>move_repo(from_id=<span class="hljs-string">&quot;Wauplin/cool-model&quot;</span>, to_id=<span class="hljs-string">&quot;huggingface/cool-model&quot;</span>)`,wrap:!1}}),oe=new u({props:{title:"리포지토리의 로컬 복사본 관리",local:"manage-a-local-copy-of-your-repository",headingTag:"h2"}}),_=new Hs({props:{warning:!0,$$slots:{default:[Is]},$$scope:{ctx:xe}}}),he=new u({props:{title:"로컬 리포지토리 사용",local:"use-a-local-repository",headingTag:"h3"}}),de=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjIlM0NwYXRoJTNFJTJGJTNDdG8lM0UlMkYlM0Nmb2xkZXIlM0UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;&lt;path&gt;/&lt;to&gt;/&lt;folder&gt;&quot;</span>)`,wrap:!1}}),ye=new u({props:{title:"복제",local:"clone",headingTag:"h3"}}),Me=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ3MnYyJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;w2v2&quot;</span>, clone_from=<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)`,wrap:!1}}),Te=new y({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkobG9jYWxfZGlyJTNEJTIyaHVnZ2luZ2ZhY2UtaHViJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;https://huggingface.co/facebook/wav2vec2-large-960h-lv60&quot;</span>)',wrap:!1}}),je=new y({props:{code:"cmVwb191cmwlMjAlM0QlMjBjcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIycmVwb19uYW1lJTIyKSUwQXJlcG8lMjAlM0QlMjBSZXBvc2l0b3J5KGxvY2FsX2RpciUzRCUyMnJlcG9fbG9jYWxfcGF0aCUyMiUyQyUyMGNsb25lX2Zyb20lM0RyZXBvX3VybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo_url = create_repo(repo_id=<span class="hljs-string">&quot;repo_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;repo_local_path&quot;</span>, clone_from=repo_url)`,wrap:!1}}),Je=new y({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIybXktZGF0YXNldCUyMiUyQyUwQSUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGJTNDZGF0YXNldF9pZCUzRSUyMiUyQyUwQSUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjBnaXRfdXNlciUzRCUyMk15TmFtZSUyMiUyQyUwQSUyMCUyMGdpdF9lbWFpbCUzRCUyMm1lJTQwY29vbC5tYWlsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;my-dataset&quot;</span>,
<span class="hljs-meta">... </span>  clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>,
<span class="hljs-meta">... </span>  token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>  git_user=<span class="hljs-string">&quot;MyName&quot;</span>,
<span class="hljs-meta">... </span>  git_email=<span class="hljs-string">&quot;me@cool.mail&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),we=new u({props:{title:"브랜치",local:"branch",headingTag:"h3"}}),Ue=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJodWdnaW5nZmFjZS1odWIlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRiUzQ2RhdGFzZXRfaWQlM0UlMjIlMkMlMjByZXZpc2lvbiUzRCdicmFuY2gxJyklMEFyZXBvLmdpdF9jaGVja291dCglMjJicmFuY2gyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>, revision=<span class="hljs-string">&#x27;branch1&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_checkout(<span class="hljs-string">&quot;branch2&quot;</span>)`,wrap:!1}}),Ze=new u({props:{title:"끌어오기",local:"pull",headingTag:"h3"}}),He=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvLmdpdF9wdWxsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()`,wrap:!1}}),Ce=new y({props:{code:"cmVwby5naXRfcHVsbChyZWJhc2UlM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull(rebase=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){$=c("meta"),M=a(),d=c("p"),b=a(),p(j.$$.fragment),Ye=a(),v=c("p"),v.innerHTML=Dt,Le=a(),J=c("ul"),J.innerHTML=Kt,qe=a(),p(T.$$.fragment),Fe=a(),w=c("p"),w.innerHTML=At,Ie=a(),p(G.$$.fragment),Ne=a(),U=c("p"),U.textContent=Ot,We=a(),p(Z.$$.fragment),Be=a(),k=c("p"),k.innerHTML=es,Ve=a(),p(H.$$.fragment),Se=a(),X=c("p"),X.innerHTML=ts,ze=a(),p(C.$$.fragment),Pe=a(),x=c("p"),x.innerHTML=ss,Qe=a(),p(R.$$.fragment),Ee=a(),Y=c("p"),Y.innerHTML=ls,De=a(),p(L.$$.fragment),Ke=a(),q=c("p"),q.innerHTML=as,Ae=a(),F=c("p"),F.innerHTML=ns,Oe=a(),p(I.$$.fragment),et=a(),p(N.$$.fragment),tt=a(),W=c("p"),W.innerHTML=ps,st=a(),p(B.$$.fragment),lt=a(),p(V.$$.fragment),at=a(),S=c("p"),S.textContent=is,nt=a(),z=c("p"),z.innerHTML=rs,pt=a(),p(P.$$.fragment),it=a(),Q=c("p"),Q.innerHTML=gs,rt=a(),p(E.$$.fragment),gt=a(),D=c("p"),D.innerHTML=ms,mt=a(),p(K.$$.fragment),ot=a(),A=c("p"),A.innerHTML=os,ct=a(),p(O.$$.fragment),ft=a(),ee=c("p"),ee.innerHTML=cs,ht=a(),p(te.$$.fragment),$t=a(),p(se.$$.fragment),dt=a(),le=c("p"),le.innerHTML=fs,yt=a(),ae=c("p"),ae.innerHTML=hs,ut=a(),p(ne.$$.fragment),Mt=a(),pe=c("p"),pe.textContent=$s,bt=a(),p(ie.$$.fragment),Tt=a(),p(re.$$.fragment),_t=a(),ge=c("p"),ge.innerHTML=ds,jt=a(),p(me.$$.fragment),vt=a(),p(oe.$$.fragment),Jt=a(),ce=c("p"),ce.textContent=ys,wt=a(),fe=c("p"),fe.innerHTML=us,Gt=a(),p(_.$$.fragment),Ut=a(),p(he.$$.fragment),Zt=a(),$e=c("p"),$e.innerHTML=Ms,kt=a(),p(de.$$.fragment),Ht=a(),p(ye.$$.fragment),Xt=a(),ue=c("p"),ue.innerHTML=bs,Ct=a(),p(Me.$$.fragment),xt=a(),be=c("p"),be.innerHTML=Ts,Rt=a(),p(Te.$$.fragment),Yt=a(),_e=c("p"),_e.innerHTML=_s,Lt=a(),p(je.$$.fragment),qt=a(),ve=c("p"),ve.innerHTML=js,Ft=a(),p(Je.$$.fragment),It=a(),p(we.$$.fragment),Nt=a(),Ge=c("p"),Ge.innerHTML=vs,Wt=a(),p(Ue.$$.fragment),Bt=a(),p(Ze.$$.fragment),Vt=a(),ke=c("p"),ke.innerHTML=Js,St=a(),p(He.$$.fragment),zt=a(),Xe=c("p"),Xe.innerHTML=ws,Pt=a(),p(Ce.$$.fragment),Qt=a(),Re=c("p"),this.h()},l(e){const t=Ls("svelte-u9bgzb",document.head);$=f(t,"META",{name:!0,content:!0}),t.forEach(s),M=n(e),d=f(e,"P",{}),Zs(d).forEach(s),b=n(e),i(j.$$.fragment,e),Ye=n(e),v=f(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-140fqed"&&(v.innerHTML=Dt),Le=n(e),J=f(e,"UL",{"data-svelte-h":!0}),h(J)!=="svelte-9ogiqs"&&(J.innerHTML=Kt),qe=n(e),i(T.$$.fragment,e),Fe=n(e),w=f(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-2zcem8"&&(w.innerHTML=At),Ie=n(e),i(G.$$.fragment,e),Ne=n(e),U=f(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1hdpso5"&&(U.textContent=Ot),We=n(e),i(Z.$$.fragment,e),Be=n(e),k=f(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-gjvfsh"&&(k.innerHTML=es),Ve=n(e),i(H.$$.fragment,e),Se=n(e),X=f(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-va3ek6"&&(X.innerHTML=ts),ze=n(e),i(C.$$.fragment,e),Pe=n(e),x=f(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1k3mpe8"&&(x.innerHTML=ss),Qe=n(e),i(R.$$.fragment,e),Ee=n(e),Y=f(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-jrrhkz"&&(Y.innerHTML=ls),De=n(e),i(L.$$.fragment,e),Ke=n(e),q=f(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-m8gop3"&&(q.innerHTML=as),Ae=n(e),F=f(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1i9rh6d"&&(F.innerHTML=ns),Oe=n(e),i(I.$$.fragment,e),et=n(e),i(N.$$.fragment,e),tt=n(e),W=f(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-15ze3p"&&(W.innerHTML=ps),st=n(e),i(B.$$.fragment,e),lt=n(e),i(V.$$.fragment,e),at=n(e),S=f(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-skmn11"&&(S.textContent=is),nt=n(e),z=f(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1uv3sh9"&&(z.innerHTML=rs),pt=n(e),i(P.$$.fragment,e),it=n(e),Q=f(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-yupu16"&&(Q.innerHTML=gs),rt=n(e),i(E.$$.fragment,e),gt=n(e),D=f(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-p80uda"&&(D.innerHTML=ms),mt=n(e),i(K.$$.fragment,e),ot=n(e),A=f(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-33gfem"&&(A.innerHTML=os),ct=n(e),i(O.$$.fragment,e),ft=n(e),ee=f(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1ez983y"&&(ee.innerHTML=cs),ht=n(e),i(te.$$.fragment,e),$t=n(e),i(se.$$.fragment,e),dt=n(e),le=f(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-4u6jje"&&(le.innerHTML=fs),yt=n(e),ae=f(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-146gzsy"&&(ae.innerHTML=hs),ut=n(e),i(ne.$$.fragment,e),Mt=n(e),pe=f(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-1dpxwah"&&(pe.textContent=$s),bt=n(e),i(ie.$$.fragment,e),Tt=n(e),i(re.$$.fragment,e),_t=n(e),ge=f(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-vallst"&&(ge.innerHTML=ds),jt=n(e),i(me.$$.fragment,e),vt=n(e),i(oe.$$.fragment,e),Jt=n(e),ce=f(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-pptsc6"&&(ce.textContent=ys),wt=n(e),fe=f(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-8nwdv1"&&(fe.innerHTML=us),Gt=n(e),i(_.$$.fragment,e),Ut=n(e),i(he.$$.fragment,e),Zt=n(e),$e=f(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-h8p3z5"&&($e.innerHTML=Ms),kt=n(e),i(de.$$.fragment,e),Ht=n(e),i(ye.$$.fragment,e),Xt=n(e),ue=f(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-551d89"&&(ue.innerHTML=bs),Ct=n(e),i(Me.$$.fragment,e),xt=n(e),be=f(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-1ip5au5"&&(be.innerHTML=Ts),Rt=n(e),i(Te.$$.fragment,e),Yt=n(e),_e=f(e,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-2wn4tp"&&(_e.innerHTML=_s),Lt=n(e),i(je.$$.fragment,e),qt=n(e),ve=f(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-182x5z6"&&(ve.innerHTML=js),Ft=n(e),i(Je.$$.fragment,e),It=n(e),i(we.$$.fragment,e),Nt=n(e),Ge=f(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-x20ybo"&&(Ge.innerHTML=vs),Wt=n(e),i(Ue.$$.fragment,e),Bt=n(e),i(Ze.$$.fragment,e),Vt=n(e),ke=f(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-i718b2"&&(ke.innerHTML=Js),St=n(e),i(He.$$.fragment,e),zt=n(e),Xe=f(e,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-teptw"&&(Xe.innerHTML=ws),Pt=n(e),i(Ce.$$.fragment,e),Qt=n(e),Re=f(e,"P",{}),Zs(Re).forEach(s),this.h()},h(){ks($,"name","hf:doc:metadata"),ks($,"content",Ws)},m(e,t){qs(document.head,$),l(e,M,t),l(e,d,t),l(e,b,t),r(j,e,t),l(e,Ye,t),l(e,v,t),l(e,Le,t),l(e,J,t),l(e,qe,t),r(T,e,t),l(e,Fe,t),l(e,w,t),l(e,Ie,t),r(G,e,t),l(e,Ne,t),l(e,U,t),l(e,We,t),r(Z,e,t),l(e,Be,t),l(e,k,t),l(e,Ve,t),r(H,e,t),l(e,Se,t),l(e,X,t),l(e,ze,t),r(C,e,t),l(e,Pe,t),l(e,x,t),l(e,Qe,t),r(R,e,t),l(e,Ee,t),l(e,Y,t),l(e,De,t),r(L,e,t),l(e,Ke,t),l(e,q,t),l(e,Ae,t),l(e,F,t),l(e,Oe,t),r(I,e,t),l(e,et,t),r(N,e,t),l(e,tt,t),l(e,W,t),l(e,st,t),r(B,e,t),l(e,lt,t),r(V,e,t),l(e,at,t),l(e,S,t),l(e,nt,t),l(e,z,t),l(e,pt,t),r(P,e,t),l(e,it,t),l(e,Q,t),l(e,rt,t),r(E,e,t),l(e,gt,t),l(e,D,t),l(e,mt,t),r(K,e,t),l(e,ot,t),l(e,A,t),l(e,ct,t),r(O,e,t),l(e,ft,t),l(e,ee,t),l(e,ht,t),r(te,e,t),l(e,$t,t),r(se,e,t),l(e,dt,t),l(e,le,t),l(e,yt,t),l(e,ae,t),l(e,ut,t),r(ne,e,t),l(e,Mt,t),l(e,pe,t),l(e,bt,t),r(ie,e,t),l(e,Tt,t),r(re,e,t),l(e,_t,t),l(e,ge,t),l(e,jt,t),r(me,e,t),l(e,vt,t),r(oe,e,t),l(e,Jt,t),l(e,ce,t),l(e,wt,t),l(e,fe,t),l(e,Gt,t),r(_,e,t),l(e,Ut,t),r(he,e,t),l(e,Zt,t),l(e,$e,t),l(e,kt,t),r(de,e,t),l(e,Ht,t),r(ye,e,t),l(e,Xt,t),l(e,ue,t),l(e,Ct,t),r(Me,e,t),l(e,xt,t),l(e,be,t),l(e,Rt,t),r(Te,e,t),l(e,Yt,t),l(e,_e,t),l(e,Lt,t),r(je,e,t),l(e,qt,t),l(e,ve,t),l(e,Ft,t),r(Je,e,t),l(e,It,t),r(we,e,t),l(e,Nt,t),l(e,Ge,t),l(e,Wt,t),r(Ue,e,t),l(e,Bt,t),r(Ze,e,t),l(e,Vt,t),l(e,ke,t),l(e,St,t),r(He,e,t),l(e,zt,t),l(e,Xe,t),l(e,Pt,t),r(Ce,e,t),l(e,Qt,t),l(e,Re,t),Et=!0},p(e,[t]){const Gs={};t&2&&(Gs.$$scope={dirty:t,ctx:e}),T.$set(Gs);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),_.$set(Us)},i(e){Et||(g(j.$$.fragment,e),g(T.$$.fragment,e),g(G.$$.fragment,e),g(Z.$$.fragment,e),g(H.$$.fragment,e),g(C.$$.fragment,e),g(R.$$.fragment,e),g(L.$$.fragment,e),g(I.$$.fragment,e),g(N.$$.fragment,e),g(B.$$.fragment,e),g(V.$$.fragment,e),g(P.$$.fragment,e),g(E.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(ne.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(me.$$.fragment,e),g(oe.$$.fragment,e),g(_.$$.fragment,e),g(he.$$.fragment,e),g(de.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(Te.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(we.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(He.$$.fragment,e),g(Ce.$$.fragment,e),Et=!0)},o(e){m(j.$$.fragment,e),m(T.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(H.$$.fragment,e),m(C.$$.fragment,e),m(R.$$.fragment,e),m(L.$$.fragment,e),m(I.$$.fragment,e),m(N.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(P.$$.fragment,e),m(E.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(oe.$$.fragment,e),m(_.$$.fragment,e),m(he.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(we.$$.fragment,e),m(Ue.$$.fragment,e),m(Ze.$$.fragment,e),m(He.$$.fragment,e),m(Ce.$$.fragment,e),Et=!1},d(e){e&&(s(M),s(d),s(b),s(Ye),s(v),s(Le),s(J),s(qe),s(Fe),s(w),s(Ie),s(Ne),s(U),s(We),s(Be),s(k),s(Ve),s(Se),s(X),s(ze),s(Pe),s(x),s(Qe),s(Ee),s(Y),s(De),s(Ke),s(q),s(Ae),s(F),s(Oe),s(et),s(tt),s(W),s(st),s(lt),s(at),s(S),s(nt),s(z),s(pt),s(it),s(Q),s(rt),s(gt),s(D),s(mt),s(ot),s(A),s(ct),s(ft),s(ee),s(ht),s($t),s(dt),s(le),s(yt),s(ae),s(ut),s(Mt),s(pe),s(bt),s(Tt),s(_t),s(ge),s(jt),s(vt),s(Jt),s(ce),s(wt),s(fe),s(Gt),s(Ut),s(Zt),s($e),s(kt),s(Ht),s(Xt),s(ue),s(Ct),s(xt),s(be),s(Rt),s(Yt),s(_e),s(Lt),s(qt),s(ve),s(Ft),s(It),s(Nt),s(Ge),s(Wt),s(Bt),s(Vt),s(ke),s(St),s(zt),s(Xe),s(Pt),s(Qt),s(Re)),s($),o(j,e),o(T,e),o(G,e),o(Z,e),o(H,e),o(C,e),o(R,e),o(L,e),o(I,e),o(N,e),o(B,e),o(V,e),o(P,e),o(E,e),o(K,e),o(O,e),o(te,e),o(se,e),o(ne,e),o(ie,e),o(re,e),o(me,e),o(oe,e),o(_,e),o(he,e),o(de,e),o(ye,e),o(Me,e),o(Te,e),o(je,e),o(Je,e),o(we,e),o(Ue,e),o(Ze,e),o(He,e),o(Ce,e)}}}const Ws='{"title":"리포지토리 생성과 관리","local":"create-and-manage-a-repository","sections":[{"title":"리포지토리 생성 및 삭제","local":"repo-creation-and-deletion","sections":[{"title":"리포지토리 생성","local":"create-a-repository","sections":[],"depth":3},{"title":"리포지토리 삭제","local":"delete-a-repository","sections":[],"depth":3},{"title":"리포지토리 복제(Spaces 전용)","local":"duplicate-a-repository-only-for-spaces","sections":[],"depth":3}],"depth":2},{"title":"파일 다운로드와 업로드","local":"upload-and-download-files","sections":[],"depth":2},{"title":"브랜치와 태그","local":"branches-and-tags","sections":[{"title":"브랜치 생성과 태그","local":"create-branches-and-tags","sections":[],"depth":3},{"title":"모든 브랜치와 태그 나열","local":"list-all-branches-and-tags","sections":[],"depth":3}],"depth":2},{"title":"리포지토리 설정 변경","local":"change-repository-settings","sections":[{"title":"가시성 업데이트","local":"update-visibility","sections":[],"depth":3},{"title":"리포지토리 이름 변경","local":"rename-your-repository","sections":[],"depth":3}],"depth":2},{"title":"리포지토리의 로컬 복사본 관리","local":"manage-a-local-copy-of-your-repository","sections":[{"title":"로컬 리포지토리 사용","local":"use-a-local-repository","sections":[],"depth":3},{"title":"복제","local":"clone","sections":[],"depth":3},{"title":"브랜치","local":"branch","sections":[],"depth":3},{"title":"끌어오기","local":"pull","sections":[],"depth":3}],"depth":2}],"depth":1}';function Bs(xe){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends Rs{constructor($){super(),Ys(this,$,Bs,Ns,Cs,{})}}export{Es as component};
