import{s as Ea,o as La,n as x}from"../chunks/scheduler.182ea377.js";import{S as Pa,i as Da,g as m,s as n,r as y,A as Ka,h as d,f as t,c as p,j as qa,u as g,x as c,k as R,y as Oa,a as l,v as h,d as U,t as J,w as Z}from"../chunks/index.abf12888.js";import{T as Ae}from"../chunks/Tip.230e2334.js";import{C}from"../chunks/CodeBlock.57fe6e13.js";import{H as K}from"../chunks/Heading.16916d63.js";import{H as el,a as sa}from"../chunks/HfOption.fc88c804.js";function tl(v){let i,b='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1lc7m22"&&(i.innerHTML=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function al(v){let i,b="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",o,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,f,I,r,T="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",k,W,X,j,$='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return f=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),W=new C({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=b,o=n(),M=m("p"),M.innerHTML=G,_=n(),y(f.$$.fragment),I=n(),r=m("p"),r.textContent=T,k=n(),y(W.$$.fragment),X=n(),j=m("div"),j.innerHTML=$,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1kuilfu"&&(i.textContent=b),o=p(s),M=d(s,"P",{"data-svelte-h":!0}),c(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=p(s),g(f.$$.fragment,s),I=p(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-yvbljp"&&(r.textContent=T),k=p(s),g(W.$$.fragment,s),X=p(s),j=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(j)!=="svelte-4jgjc0"&&(j.innerHTML=$),this.h()},h(){R(j,"class","flex flex-row gap-4")},m(s,w){l(s,i,w),l(s,o,w),l(s,M,w),l(s,_,w),h(f,s,w),l(s,I,w),l(s,r,w),l(s,k,w),h(W,s,w),l(s,X,w),l(s,j,w),u=!0},p:x,i(s){u||(U(f.$$.fragment,s),U(W.$$.fragment,s),u=!0)},o(s){J(f.$$.fragment,s),J(W.$$.fragment,s),u=!1},d(s){s&&(t(i),t(o),t(M),t(_),t(I),t(r),t(k),t(X),t(j)),Z(f,s),Z(W,s)}}}function ll(v){let i,b="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",o,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,f,I,r,T="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",k,W,X,j,$='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return f=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),W=new C({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=b,o=n(),M=m("p"),M.innerHTML=G,_=n(),y(f.$$.fragment),I=n(),r=m("p"),r.textContent=T,k=n(),y(W.$$.fragment),X=n(),j=m("div"),j.innerHTML=$,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),c(i)!=="svelte-avn1rr"&&(i.textContent=b),o=p(s),M=d(s,"P",{"data-svelte-h":!0}),c(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=p(s),g(f.$$.fragment,s),I=p(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-10sbd9g"&&(r.textContent=T),k=p(s),g(W.$$.fragment,s),X=p(s),j=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(j)!=="svelte-8bse9r"&&(j.innerHTML=$),this.h()},h(){R(j,"class","flex gap-4")},m(s,w){l(s,i,w),l(s,o,w),l(s,M,w),l(s,_,w),h(f,s,w),l(s,I,w),l(s,r,w),l(s,k,w),h(W,s,w),l(s,X,w),l(s,j,w),u=!0},p:x,i(s){u||(U(f.$$.fragment,s),U(W.$$.fragment,s),u=!0)},o(s){J(f.$$.fragment,s),J(W.$$.fragment,s),u=!1},d(s){s&&(t(i),t(o),t(M),t(_),t(I),t(r),t(k),t(X),t(j)),Z(f,s),Z(W,s)}}}function sl(v){let i,b="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",o,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,f,I,r,T="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",k,W,X,j,$='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return f=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),W=new C({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=b,o=n(),M=m("p"),M.innerHTML=G,_=n(),y(f.$$.fragment),I=n(),r=m("p"),r.textContent=T,k=n(),y(W.$$.fragment),X=n(),j=m("div"),j.innerHTML=$,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11wjoqr"&&(i.textContent=b),o=p(s),M=d(s,"P",{"data-svelte-h":!0}),c(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=p(s),g(f.$$.fragment,s),I=p(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1wfeic0"&&(r.textContent=T),k=p(s),g(W.$$.fragment,s),X=p(s),j=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(j)!=="svelte-5iola2"&&(j.innerHTML=$),this.h()},h(){R(j,"class","flex gap-4")},m(s,w){l(s,i,w),l(s,o,w),l(s,M,w),l(s,_,w),h(f,s,w),l(s,I,w),l(s,r,w),l(s,k,w),h(W,s,w),l(s,X,w),l(s,j,w),u=!0},p:x,i(s){u||(U(f.$$.fragment,s),U(W.$$.fragment,s),u=!0)},o(s){J(f.$$.fragment,s),J(W.$$.fragment,s),u=!1},d(s){s&&(t(i),t(o),t(M),t(_),t(I),t(r),t(k),t(X),t(j)),Z(f,s),Z(W,s)}}}function il(v){let i,b='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-pqh7g3"&&(i.innerHTML=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function nl(v){let i,b='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',o,M,G,_,f,I,r="Pass a prompt and an image prompt to the pipeline to generate a short video.",T,k,W,X,j='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',$;return M=new Ae({props:{warning:!0,$$slots:{default:[il]},$$scope:{ctx:v}}}),_=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),k=new C({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=b,o=n(),y(M.$$.fragment),G=n(),y(_.$$.fragment),f=n(),I=m("p"),I.textContent=r,T=n(),y(k.$$.fragment),W=n(),X=m("div"),X.innerHTML=j,this.h()},l(u){i=d(u,"P",{"data-svelte-h":!0}),c(i)!=="svelte-10zqvoq"&&(i.innerHTML=b),o=p(u),g(M.$$.fragment,u),G=p(u),g(_.$$.fragment,u),f=p(u),I=d(u,"P",{"data-svelte-h":!0}),c(I)!=="svelte-a6opnh"&&(I.textContent=r),T=p(u),g(k.$$.fragment,u),W=p(u),X=d(u,"DIV",{class:!0,"data-svelte-h":!0}),c(X)!=="svelte-ihoum9"&&(X.innerHTML=j),this.h()},h(){R(X,"class","flex flex-row gap-4")},m(u,s){l(u,i,s),l(u,o,s),h(M,u,s),l(u,G,s),h(_,u,s),l(u,f,s),l(u,I,s),l(u,T,s),h(k,u,s),l(u,W,s),l(u,X,s),$=!0},p(u,s){const w={};s&2&&(w.$$scope={dirty:s,ctx:u}),M.$set(w)},i(u){$||(U(M.$$.fragment,u),U(_.$$.fragment,u),U(k.$$.fragment,u),$=!0)},o(u){J(M.$$.fragment,u),J(_.$$.fragment,u),J(k.$$.fragment,u),$=!1},d(u){u&&(t(i),t(o),t(G),t(f),t(I),t(T),t(W),t(X)),Z(M,u),Z(_,u),Z(k,u)}}}function pl(v){let i,b,o,M,G,_,f,I;return i=new sa({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[al]},$$scope:{ctx:v}}}),o=new sa({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[ll]},$$scope:{ctx:v}}}),G=new sa({props:{id:"tasks",option:"Inpainting",$$slots:{default:[sl]},$$scope:{ctx:v}}}),f=new sa({props:{id:"tasks",option:"Video",$$slots:{default:[nl]},$$scope:{ctx:v}}}),{c(){y(i.$$.fragment),b=n(),y(o.$$.fragment),M=n(),y(G.$$.fragment),_=n(),y(f.$$.fragment)},l(r){g(i.$$.fragment,r),b=p(r),g(o.$$.fragment,r),M=p(r),g(G.$$.fragment,r),_=p(r),g(f.$$.fragment,r)},m(r,T){h(i,r,T),l(r,b,T),h(o,r,T),l(r,M,T),h(G,r,T),l(r,_,T),h(f,r,T),I=!0},p(r,T){const k={};T&2&&(k.$$scope={dirty:T,ctx:r}),i.$set(k);const W={};T&2&&(W.$$scope={dirty:T,ctx:r}),o.$set(W);const X={};T&2&&(X.$$scope={dirty:T,ctx:r}),G.$set(X);const j={};T&2&&(j.$$scope={dirty:T,ctx:r}),f.$set(j)},i(r){I||(U(i.$$.fragment,r),U(o.$$.fragment,r),U(G.$$.fragment,r),U(f.$$.fragment,r),I=!0)},o(r){J(i.$$.fragment,r),J(o.$$.fragment,r),J(G.$$.fragment,r),J(f.$$.fragment,r),I=!1},d(r){r&&(t(b),t(M),t(_)),Z(i,r),Z(o,r),Z(G,r),Z(f,r)}}}function ol(v){let i,b="While calling <code>load_ip_adapter()</code>, pass <code>low_cpu_mem_usage=True</code> to speed up the loading time.";return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-8g51iy"&&(i.innerHTML=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function rl(v){let i,b="ComfyUI image embeddings for IP-Adapters are fully compatible in Diffusers and should work out-of-box.";return{c(){i=m("p"),i.textContent=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fpzl1p"&&(i.textContent=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function ml(v){let i,b="If you use IP-Adapter with <code>ip_adapter_image_embedding</code> instead of <code>ip_adapter_image</code>, you can choose not to load an image encoder by passing <code>image_encoder_folder=None</code> to <code>load_ip_adapter()</code>.";return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1hyztdr"&&(i.innerHTML=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function dl(v){let i,b='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-apa7ha"&&(i.innerHTML=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function cl(v){let i,b="For optimal results, provide the output height and width to <code>IPAdapterMaskProcessor.preprocess()</code>. This ensures that masks with differing aspect ratios are appropriately stretched. If the input masks already match the aspect ratio of the generated image, specifying height and width can be omitted.";return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-tm9bbs"&&(i.innerHTML=b)},m(o,M){l(o,i,M)},p:x,d(o){o&&t(i)}}}function ul(v){let i,b,o,M,G,_,f,I='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',r,T,k,W,X="This guide will walk you through using IP-Adapter for various tasks and use cases.",j,$,u,s,w='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',Ee,O,ia='In all the following examples, you’ll see the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',Le,V,Pe,Y,De,ee,na="All the pipelines supporting IP-Adapter accept a <code>ip_adapter_image_embeds</code> argument. If you need to run the IP-Adapter multiple times with the same image, you can encode the image once and save the embedding to the disk.",Ke,te,Oe,ae,pa="Load the image embedding and pass it to the pipeline as <code>ip_adapter_image_embeds</code>",et,B,tt,le,at,F,lt,se,st,ie,oa="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",it,ne,nt,pe,ra="Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces:",pt,oe,ma='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',ot,re,da='<p>[!TIP][IP-Adapter-FaceID](<a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">https://huggingface.co/h94/IP-Adapter-FaceID</a>) is a face-specific IP-Adapter trained with face ID embeddings instead of CLIP image embeddings, allowing you to generate more consistent faces in different contexts and styles. Try out this popular <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#ip-adapter-face-id" rel="nofollow">community pipeline</a> and see how it compares to the other face IP-Adapters.</p>',rt,me,ca='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',mt,de,dt,H,ua='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',ct,ce,ut,ue,Ma="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",Mt,Q,ft,Me,fa='Load the image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',yt,fe,gt,ye,ya="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",ht,ge,ga='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',Ut,he,Jt,Ue,ha="Load an image prompt and a folder containing images of a certain style you want to use.",Zt,Je,bt,N,Ua='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',wt,Ze,Ja="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",Tt,be,Wt,z,Za='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',jt,we,_t,Te,ba='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',Gt,We,wa='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',It,je,kt,_e,Ta='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',Xt,Ge,vt,S,Wa='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',Ct,Ie,$t,ke,ja='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',Rt,Xe,_a='Load a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',xt,ve,Vt,Ce,Ga="Now load the IP-Adapter image and depth map.",Yt,$e,Bt,A,Ia='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',Ft,Re,ka="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",Ht,xe,Qt,q,Xa='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',Nt,Ve,zt,Ye,va=`Binary masks can be used to specify which portion of the output image should be assigned to an IP-Adapter.
For each input IP-Adapter image, a binary mask and an IP-Adapter must be provided.`,St,Be,Ca="Before passing the masks to the pipeline, it’s essential to preprocess them using <code>IPAdapterMaskProcessor.preprocess()</code>.",At,E,qt,Fe,$a="Here an example with two masks:",Et,He,Lt,L,Ra='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask two</figcaption></div>',Pt,Qe,xa="If you have more than one IP-Adapter image, load them into a list, ensuring each image is assigned to a different IP-Adapter.",Dt,Ne,Kt,P,Va='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ip adapter image one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ip adapter image two</figcaption></div>',Ot,ze,Ya="Pass preprocessed masks to the pipeline using <code>cross_attention_kwargs</code> as shown below:",ea,Se,ta,D,Ba='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">output image</figcaption>',aa,qe,la;return G=new K({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),T=new Ae({props:{warning:!1,$$slots:{default:[tl]},$$scope:{ctx:v}}}),$=new K({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),V=new el({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[pl]},$$scope:{ctx:v}}}),Y=new Ae({props:{warning:!1,$$slots:{default:[ol]},$$scope:{ctx:v}}}),te=new C({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyglMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGRvX2NsYXNzaWZpZXJfZnJlZV9ndWlkYW5jZSUzRFRydWUlMkMlMEEpJTBBJTBBdG9yY2guc2F2ZShpbWFnZV9lbWJlZHMlMkMlMjAlMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKQ==",highlighted:`image_embeds = pipeline.prepare_ip_adapter_image_embeds(
    ip_adapter_image=image,
    ip_adapter_image_embeds=<span class="hljs-literal">None</span>,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
)

torch.save(image_embeds, <span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)`,wrap:!1}}),B=new Ae({props:{warning:!1,$$slots:{default:[rl]},$$scope:{ctx:v}}}),le=new C({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwdG9yY2gubG9hZCglMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRGltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2Vz",highlighted:`image_embeds = torch.load(<span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image_embeds=image_embeds,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images`,wrap:!1}}),F=new Ae({props:{warning:!1,$$slots:{default:[ml]},$$scope:{ctx:v}}}),se=new K({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),ne=new K({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),de=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZnVsbC1mYWNlX3NkMTUuYmluJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9laW5zdGVpbl9iYXNlLnBuZyUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBwaG90byUyMG9mJTIwRWluc3RlaW4lMjBhcyUyMGElMjBjaGVmJTJDJTIwd2VhcmluZyUyMGFuJTIwYXByb24lMkMlMjBjb29raW5nJTIwaW4lMjBhJTIwRnJlbmNoJTIwcmVzdGF1cmFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ce=new K({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),Q=new Ae({props:{warning:!1,$$slots:{default:[dl]},$$scope:{ctx:v}}}),fe=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),he=new C({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Je=new C({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),be=new C({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),we=new K({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),je=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Ge=new C({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ie=new K({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),ve=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),$e=new C({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),xe=new C({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ve=new K({props:{title:"IP-Adapter masking",local:"ip-adapter-masking",headingTag:"h3"}}),E=new Ae({props:{warning:!1,$$slots:{default:[cl]},$$scope:{ctx:v}}}),He=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5pbWFnZV9wcm9jZXNzb3IlMjBpbXBvcnQlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yJTBBJTBBbWFzazElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpcF9tYXNrX21hc2sxLnBuZyUyMiklMEFtYXNrMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmlwX21hc2tfbWFzazIucG5nJTIyKSUwQSUwQW91dHB1dF9oZWlnaHQlMjAlM0QlMjAxMDI0JTBBb3V0cHV0X3dpZHRoJTIwJTNEJTIwMTAyNCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMElQQWRhcHRlck1hc2tQcm9jZXNzb3IoKSUwQW1hc2tzJTIwJTNEJTIwcHJvY2Vzc29yLnByZXByb2Nlc3MoJTVCbWFzazElMkMlMjBtYXNrMiU1RCUyQyUyMGhlaWdodCUzRG91dHB1dF9oZWlnaHQlMkMlMjB3aWR0aCUzRG91dHB1dF93aWR0aCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png&quot;</span>)

output_height = <span class="hljs-number">1024</span>
output_width = <span class="hljs-number">1024</span>

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=output_height, width=output_width)`,wrap:!1}}),Ne=new C({props:{code:"ZmFjZV9pbWFnZTElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpcF9tYXNrX2dpcmwxLnBuZyUyMiklMEFmYWNlX2ltYWdlMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmlwX21hc2tfZ2lybDIucG5nJTIyKSUwQSUwQWlwX2ltYWdlcyUyMCUzRCUyMCU1QiU1QmZhY2VfaW1hZ2UxJTVEJTJDJTIwJTVCZmFjZV9pbWFnZTIlNUQlNUQ=",highlighted:`face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png&quot;</span>)

ip_images = [[face_image1], [face_image2]]`,wrap:!1}}),Se=new C({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzLWZhY2Vfc2R4bF92aXQtaC5zYWZldGVuc29ycyUyMiU1RCUyMColMjAyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyU1RCUyMColMjAyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBbnVtX2ltYWdlcyUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMjIlMjBnaXJscyUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9pbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMmlwX2FkYXB0ZXJfbWFza3MlMjIlM0ElMjBtYXNrcyU3RCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>] * <span class="hljs-number">2</span>)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>] * <span class="hljs-number">2</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
num_images = <span class="hljs-number">1</span>

image = pipeline(
    prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
    ip_adapter_image=ip_images,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>, num_images_per_prompt=num_images,
    generator=generator, cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){i=m("meta"),b=n(),o=m("p"),M=n(),y(G.$$.fragment),_=n(),f=m("p"),f.innerHTML=I,r=n(),y(T.$$.fragment),k=n(),W=m("p"),W.textContent=X,j=n(),y($.$$.fragment),u=n(),s=m("p"),s.innerHTML=w,Ee=n(),O=m("p"),O.innerHTML=ia,Le=n(),y(V.$$.fragment),Pe=n(),y(Y.$$.fragment),De=n(),ee=m("p"),ee.innerHTML=na,Ke=n(),y(te.$$.fragment),Oe=n(),ae=m("p"),ae.innerHTML=pa,et=n(),y(B.$$.fragment),tt=n(),y(le.$$.fragment),at=n(),y(F.$$.fragment),lt=n(),y(se.$$.fragment),st=n(),ie=m("p"),ie.textContent=oa,it=n(),y(ne.$$.fragment),nt=n(),pe=m("p"),pe.textContent=ra,pt=n(),oe=m("ul"),oe.innerHTML=ma,ot=n(),re=m("blockquote"),re.innerHTML=da,rt=n(),me=m("p"),me.innerHTML=ca,mt=n(),y(de.$$.fragment),dt=n(),H=m("div"),H.innerHTML=ua,ct=n(),y(ce.$$.fragment),ut=n(),ue=m("p"),ue.textContent=Ma,Mt=n(),y(Q.$$.fragment),ft=n(),Me=m("p"),Me.innerHTML=fa,yt=n(),y(fe.$$.fragment),gt=n(),ye=m("p"),ye.innerHTML=ya,ht=n(),ge=m("ul"),ge.innerHTML=ga,Ut=n(),y(he.$$.fragment),Jt=n(),Ue=m("p"),Ue.textContent=ha,Zt=n(),y(Je.$$.fragment),bt=n(),N=m("div"),N.innerHTML=Ua,wt=n(),Ze=m("p"),Ze.innerHTML=Ja,Tt=n(),y(be.$$.fragment),Wt=n(),z=m("div"),z.innerHTML=Za,jt=n(),y(we.$$.fragment),_t=n(),Te=m("p"),Te.innerHTML=ba,Gt=n(),We=m("p"),We.innerHTML=wa,It=n(),y(je.$$.fragment),kt=n(),_e=m("p"),_e.innerHTML=Ta,Xt=n(),y(Ge.$$.fragment),vt=n(),S=m("div"),S.innerHTML=Wa,Ct=n(),y(Ie.$$.fragment),$t=n(),ke=m("p"),ke.innerHTML=ja,Rt=n(),Xe=m("p"),Xe.innerHTML=_a,xt=n(),y(ve.$$.fragment),Vt=n(),Ce=m("p"),Ce.textContent=Ga,Yt=n(),y($e.$$.fragment),Bt=n(),A=m("div"),A.innerHTML=Ia,Ft=n(),Re=m("p"),Re.textContent=ka,Ht=n(),y(xe.$$.fragment),Qt=n(),q=m("div"),q.innerHTML=Xa,Nt=n(),y(Ve.$$.fragment),zt=n(),Ye=m("p"),Ye.textContent=va,St=n(),Be=m("p"),Be.innerHTML=Ca,At=n(),y(E.$$.fragment),qt=n(),Fe=m("p"),Fe.textContent=$a,Et=n(),y(He.$$.fragment),Lt=n(),L=m("div"),L.innerHTML=Ra,Pt=n(),Qe=m("p"),Qe.textContent=xa,Dt=n(),y(Ne.$$.fragment),Kt=n(),P=m("div"),P.innerHTML=Va,Ot=n(),ze=m("p"),ze.innerHTML=Ya,ea=n(),y(Se.$$.fragment),ta=n(),D=m("div"),D.innerHTML=Ba,aa=n(),qe=m("p"),this.h()},l(e){const a=Ka("svelte-u9bgzb",document.head);i=d(a,"META",{name:!0,content:!0}),a.forEach(t),b=p(e),o=d(e,"P",{}),qa(o).forEach(t),M=p(e),g(G.$$.fragment,e),_=p(e),f=d(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-rd9njz"&&(f.innerHTML=I),r=p(e),g(T.$$.fragment,e),k=p(e),W=d(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1211s0v"&&(W.textContent=X),j=p(e),g($.$$.fragment,e),u=p(e),s=d(e,"P",{"data-svelte-h":!0}),c(s)!=="svelte-49swfq"&&(s.innerHTML=w),Ee=p(e),O=d(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1pmqs0j"&&(O.innerHTML=ia),Le=p(e),g(V.$$.fragment,e),Pe=p(e),g(Y.$$.fragment,e),De=p(e),ee=d(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1meo4bp"&&(ee.innerHTML=na),Ke=p(e),g(te.$$.fragment,e),Oe=p(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-mstjq7"&&(ae.innerHTML=pa),et=p(e),g(B.$$.fragment,e),tt=p(e),g(le.$$.fragment,e),at=p(e),g(F.$$.fragment,e),lt=p(e),g(se.$$.fragment,e),st=p(e),ie=d(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-3uurtn"&&(ie.textContent=oa),it=p(e),g(ne.$$.fragment,e),nt=p(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1md71yv"&&(pe.textContent=ra),pt=p(e),oe=d(e,"UL",{"data-svelte-h":!0}),c(oe)!=="svelte-1a56pqx"&&(oe.innerHTML=ma),ot=p(e),re=d(e,"BLOCKQUOTE",{"data-svelte-h":!0}),c(re)!=="svelte-1ibagyj"&&(re.innerHTML=da),rt=p(e),me=d(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-1dtaqqk"&&(me.innerHTML=ca),mt=p(e),g(de.$$.fragment,e),dt=p(e),H=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(H)!=="svelte-lbwedl"&&(H.innerHTML=ua),ct=p(e),g(ce.$$.fragment,e),ut=p(e),ue=d(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1tk2m7v"&&(ue.textContent=Ma),Mt=p(e),g(Q.$$.fragment,e),ft=p(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-qgg0iy"&&(Me.innerHTML=fa),yt=p(e),g(fe.$$.fragment,e),gt=p(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1vw2kqb"&&(ye.innerHTML=ya),ht=p(e),ge=d(e,"UL",{"data-svelte-h":!0}),c(ge)!=="svelte-tpz2u9"&&(ge.innerHTML=ga),Ut=p(e),g(he.$$.fragment,e),Jt=p(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1p6lwr0"&&(Ue.textContent=ha),Zt=p(e),g(Je.$$.fragment,e),bt=p(e),N=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(N)!=="svelte-im3du6"&&(N.innerHTML=Ua),wt=p(e),Ze=d(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1kkzavx"&&(Ze.innerHTML=Ja),Tt=p(e),g(be.$$.fragment,e),Wt=p(e),z=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(z)!=="svelte-1t1eqqe"&&(z.innerHTML=Za),jt=p(e),g(we.$$.fragment,e),_t=p(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1am74qu"&&(Te.innerHTML=ba),Gt=p(e),We=d(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-ntp5s3"&&(We.innerHTML=wa),It=p(e),g(je.$$.fragment,e),kt=p(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-13u2z8i"&&(_e.innerHTML=Ta),Xt=p(e),g(Ge.$$.fragment,e),vt=p(e),S=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(S)!=="svelte-1cw2b12"&&(S.innerHTML=Wa),Ct=p(e),g(Ie.$$.fragment,e),$t=p(e),ke=d(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-sz8jif"&&(ke.innerHTML=ja),Rt=p(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-837b2y"&&(Xe.innerHTML=_a),xt=p(e),g(ve.$$.fragment,e),Vt=p(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-77tfin"&&(Ce.textContent=Ga),Yt=p(e),g($e.$$.fragment,e),Bt=p(e),A=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(A)!=="svelte-mjuwpp"&&(A.innerHTML=Ia),Ft=p(e),Re=d(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-12fzw16"&&(Re.textContent=ka),Ht=p(e),g(xe.$$.fragment,e),Qt=p(e),q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(q)!=="svelte-kc4794"&&(q.innerHTML=Xa),Nt=p(e),g(Ve.$$.fragment,e),zt=p(e),Ye=d(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-1p0lqmp"&&(Ye.textContent=va),St=p(e),Be=d(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-5d5ag4"&&(Be.innerHTML=Ca),At=p(e),g(E.$$.fragment,e),qt=p(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-1e0vtsw"&&(Fe.textContent=$a),Et=p(e),g(He.$$.fragment,e),Lt=p(e),L=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(L)!=="svelte-eifaa"&&(L.innerHTML=Ra),Pt=p(e),Qe=d(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-ks78co"&&(Qe.textContent=xa),Dt=p(e),g(Ne.$$.fragment,e),Kt=p(e),P=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(P)!=="svelte-32e9xk"&&(P.innerHTML=Va),Ot=p(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1lxdo5h"&&(ze.innerHTML=Ya),ea=p(e),g(Se.$$.fragment,e),ta=p(e),D=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(D)!=="svelte-1125s53"&&(D.innerHTML=Ba),aa=p(e),qe=d(e,"P",{}),qa(qe).forEach(t),this.h()},h(){R(i,"name","hf:doc:metadata"),R(i,"content",Ml),R(H,"class","flex flex-row gap-4"),R(N,"class","flex flex-row gap-4"),R(z,"class","flex justify-center"),R(S,"class","flex justify-center"),R(A,"class","flex flex-row gap-4"),R(q,"class","flex justify-center"),R(L,"class","flex flex-row gap-4"),R(P,"class","flex flex-row gap-4"),R(D,"class","flex justify-center")},m(e,a){Oa(document.head,i),l(e,b,a),l(e,o,a),l(e,M,a),h(G,e,a),l(e,_,a),l(e,f,a),l(e,r,a),h(T,e,a),l(e,k,a),l(e,W,a),l(e,j,a),h($,e,a),l(e,u,a),l(e,s,a),l(e,Ee,a),l(e,O,a),l(e,Le,a),h(V,e,a),l(e,Pe,a),h(Y,e,a),l(e,De,a),l(e,ee,a),l(e,Ke,a),h(te,e,a),l(e,Oe,a),l(e,ae,a),l(e,et,a),h(B,e,a),l(e,tt,a),h(le,e,a),l(e,at,a),h(F,e,a),l(e,lt,a),h(se,e,a),l(e,st,a),l(e,ie,a),l(e,it,a),h(ne,e,a),l(e,nt,a),l(e,pe,a),l(e,pt,a),l(e,oe,a),l(e,ot,a),l(e,re,a),l(e,rt,a),l(e,me,a),l(e,mt,a),h(de,e,a),l(e,dt,a),l(e,H,a),l(e,ct,a),h(ce,e,a),l(e,ut,a),l(e,ue,a),l(e,Mt,a),h(Q,e,a),l(e,ft,a),l(e,Me,a),l(e,yt,a),h(fe,e,a),l(e,gt,a),l(e,ye,a),l(e,ht,a),l(e,ge,a),l(e,Ut,a),h(he,e,a),l(e,Jt,a),l(e,Ue,a),l(e,Zt,a),h(Je,e,a),l(e,bt,a),l(e,N,a),l(e,wt,a),l(e,Ze,a),l(e,Tt,a),h(be,e,a),l(e,Wt,a),l(e,z,a),l(e,jt,a),h(we,e,a),l(e,_t,a),l(e,Te,a),l(e,Gt,a),l(e,We,a),l(e,It,a),h(je,e,a),l(e,kt,a),l(e,_e,a),l(e,Xt,a),h(Ge,e,a),l(e,vt,a),l(e,S,a),l(e,Ct,a),h(Ie,e,a),l(e,$t,a),l(e,ke,a),l(e,Rt,a),l(e,Xe,a),l(e,xt,a),h(ve,e,a),l(e,Vt,a),l(e,Ce,a),l(e,Yt,a),h($e,e,a),l(e,Bt,a),l(e,A,a),l(e,Ft,a),l(e,Re,a),l(e,Ht,a),h(xe,e,a),l(e,Qt,a),l(e,q,a),l(e,Nt,a),h(Ve,e,a),l(e,zt,a),l(e,Ye,a),l(e,St,a),l(e,Be,a),l(e,At,a),h(E,e,a),l(e,qt,a),l(e,Fe,a),l(e,Et,a),h(He,e,a),l(e,Lt,a),l(e,L,a),l(e,Pt,a),l(e,Qe,a),l(e,Dt,a),h(Ne,e,a),l(e,Kt,a),l(e,P,a),l(e,Ot,a),l(e,ze,a),l(e,ea,a),h(Se,e,a),l(e,ta,a),l(e,D,a),l(e,aa,a),l(e,qe,a),la=!0},p(e,[a]){const Fa={};a&2&&(Fa.$$scope={dirty:a,ctx:e}),T.$set(Fa);const Ha={};a&2&&(Ha.$$scope={dirty:a,ctx:e}),V.$set(Ha);const Qa={};a&2&&(Qa.$$scope={dirty:a,ctx:e}),Y.$set(Qa);const Na={};a&2&&(Na.$$scope={dirty:a,ctx:e}),B.$set(Na);const za={};a&2&&(za.$$scope={dirty:a,ctx:e}),F.$set(za);const Sa={};a&2&&(Sa.$$scope={dirty:a,ctx:e}),Q.$set(Sa);const Aa={};a&2&&(Aa.$$scope={dirty:a,ctx:e}),E.$set(Aa)},i(e){la||(U(G.$$.fragment,e),U(T.$$.fragment,e),U($.$$.fragment,e),U(V.$$.fragment,e),U(Y.$$.fragment,e),U(te.$$.fragment,e),U(B.$$.fragment,e),U(le.$$.fragment,e),U(F.$$.fragment,e),U(se.$$.fragment,e),U(ne.$$.fragment,e),U(de.$$.fragment,e),U(ce.$$.fragment,e),U(Q.$$.fragment,e),U(fe.$$.fragment,e),U(he.$$.fragment,e),U(Je.$$.fragment,e),U(be.$$.fragment,e),U(we.$$.fragment,e),U(je.$$.fragment,e),U(Ge.$$.fragment,e),U(Ie.$$.fragment,e),U(ve.$$.fragment,e),U($e.$$.fragment,e),U(xe.$$.fragment,e),U(Ve.$$.fragment,e),U(E.$$.fragment,e),U(He.$$.fragment,e),U(Ne.$$.fragment,e),U(Se.$$.fragment,e),la=!0)},o(e){J(G.$$.fragment,e),J(T.$$.fragment,e),J($.$$.fragment,e),J(V.$$.fragment,e),J(Y.$$.fragment,e),J(te.$$.fragment,e),J(B.$$.fragment,e),J(le.$$.fragment,e),J(F.$$.fragment,e),J(se.$$.fragment,e),J(ne.$$.fragment,e),J(de.$$.fragment,e),J(ce.$$.fragment,e),J(Q.$$.fragment,e),J(fe.$$.fragment,e),J(he.$$.fragment,e),J(Je.$$.fragment,e),J(be.$$.fragment,e),J(we.$$.fragment,e),J(je.$$.fragment,e),J(Ge.$$.fragment,e),J(Ie.$$.fragment,e),J(ve.$$.fragment,e),J($e.$$.fragment,e),J(xe.$$.fragment,e),J(Ve.$$.fragment,e),J(E.$$.fragment,e),J(He.$$.fragment,e),J(Ne.$$.fragment,e),J(Se.$$.fragment,e),la=!1},d(e){e&&(t(b),t(o),t(M),t(_),t(f),t(r),t(k),t(W),t(j),t(u),t(s),t(Ee),t(O),t(Le),t(Pe),t(De),t(ee),t(Ke),t(Oe),t(ae),t(et),t(tt),t(at),t(lt),t(st),t(ie),t(it),t(nt),t(pe),t(pt),t(oe),t(ot),t(re),t(rt),t(me),t(mt),t(dt),t(H),t(ct),t(ut),t(ue),t(Mt),t(ft),t(Me),t(yt),t(gt),t(ye),t(ht),t(ge),t(Ut),t(Jt),t(Ue),t(Zt),t(bt),t(N),t(wt),t(Ze),t(Tt),t(Wt),t(z),t(jt),t(_t),t(Te),t(Gt),t(We),t(It),t(kt),t(_e),t(Xt),t(vt),t(S),t(Ct),t($t),t(ke),t(Rt),t(Xe),t(xt),t(Vt),t(Ce),t(Yt),t(Bt),t(A),t(Ft),t(Re),t(Ht),t(Qt),t(q),t(Nt),t(zt),t(Ye),t(St),t(Be),t(At),t(qt),t(Fe),t(Et),t(Lt),t(L),t(Pt),t(Qe),t(Dt),t(Kt),t(P),t(Ot),t(ze),t(ea),t(ta),t(D),t(aa),t(qe)),t(i),Z(G,e),Z(T,e),Z($,e),Z(V,e),Z(Y,e),Z(te,e),Z(B,e),Z(le,e),Z(F,e),Z(se,e),Z(ne,e),Z(de,e),Z(ce,e),Z(Q,e),Z(fe,e),Z(he,e),Z(Je,e),Z(be,e),Z(we,e),Z(je,e),Z(Ge,e),Z(Ie,e),Z(ve,e),Z($e,e),Z(xe,e),Z(Ve,e),Z(E,e),Z(He,e),Z(Ne,e),Z(Se,e)}}}const Ml='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3},{"title":"IP-Adapter masking","local":"ip-adapter-masking","sections":[],"depth":3}],"depth":2}],"depth":1}';function fl(v){return La(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends Pa{constructor(i){super(),Da(this,i,fl,ul,Ea,{})}}export{bl as component};
