import{s as sl,o as ll,n as tl}from"../chunks/scheduler.c59d9fbb.js";import{S as al,i as nl,g as y,s as a,r as i,A as il,h as d,f as s,c as n,j as Ks,u as p,x as h,k as Os,y as pl,a as l,v as m,d as r,t as o,w as M}from"../chunks/index.a47918e3.js";import{T as el}from"../chunks/Tip.3fcf4aa4.js";import{C as c}from"../chunks/CodeBlock.936db8cd.js";import{D as ml}from"../chunks/DocNotebookDropdown.efd8a791.js";import{H as Ee}from"../chunks/Heading.604bc707.js";function rl(Ye){let f,b="Some datasets on the Hugging Face Hub don’t have a <code>ClassLabel</code> feature for the label column. In these cases, you should compute the candidate labels manually by first computing the id2label mapping as follows:";return{c(){f=y("p"),f.innerHTML=b},l(w){f=d(w,"P",{"data-svelte-h":!0}),h(f)!=="svelte-127biyz"&&(f.innerHTML=b)},m(w,J){l(w,f,J)},p:tl,d(w){w&&s(f)}}}function ol(Ye){let f,b="You might find you can get better performance by tweaking the <code>template</code> argument from the default of <code>&quot;The sentence is {}&quot;</code> to variants like <code>&quot;This sentence is {}&quot;</code> or <code>&quot;This example is {}&quot;</code>.";return{c(){f=y("p"),f.innerHTML=b},l(w){f=d(w,"P",{"data-svelte-h":!0}),h(f)!=="svelte-mk86f2"&&(f.innerHTML=b)},m(w,J){l(w,f,J)},p:tl,d(w){w&&s(f)}}}function Ml(Ye){let f,b,w,J,T,He,j,Ae,$,fs="Although SetFit was designed for few-shot learning, the method can also be applied in scenarios where no labeled data is available. The main trick is to create <em>synthetic examples</em> that resemble the classification task, and then train a SetFit model on them.",qe,C,ws="Remarkably, this simple technique typically outperforms the zero-shot pipeline in 🤗 Transformers, and can generate predictions by a factor of 5x (or more) faster!",De,g,bs="In this tutorial, we’ll explore how:",Le,Z,Js="<li>SetFit can be applied for zero-shot classification</li> <li>Adding synthetic examples can also provide a performance boost to few-shot classification.</li>",Pe,x,Ke,I,us="If you’re running this Notebook on Colab or some other cloud platform, you will need to install the <code>setfit</code> library. Uncomment the following cell and run it:",Oe,W,et,k,Us="To benchmark the performance of the “zero-shot” method, we’ll use the following dataset and pretrained model:",tt,R,st,G,Ts="Next, we’ll download the reference dataset from the Hugging Face Hub:",lt,X,at,N,nt,Q,js="Now that we’re set up, let’s create some synthetic data to train on!",it,B,pt,_,$s="The first thing we need to do is create a dataset of synthetic examples. In <code>setfit</code>, we can do this by applying the <code>get_templated_dataset()</code> function to a dummy dataset. This function expects a few main things:",mt,F,Cs="<li>A list of candidate labels to classify with. We’ll use the labels from the reference dataset here, but this could be anything that’s relevant to the task and dataset at hand.</li> <li>A template to generate examples with. By default, it is <code>&quot;This sentence is {}&quot;</code>, where the <code>{}</code> will be filled by one of the candidate labels</li> <li>A sample size $N$, which will create $N$ synthetic examples per class. We find $N=8$ usually works best.</li>",rt,z,gs="Armed with this information, let’s first extract some candidate labels from the dataset:",ot,V,Mt,v,yt,u,dt,Y,ht,E,Zs="Now that we have the labels, it’s a simple matter to create synthetic examples:",ct,S,ft,H,wt,U,bt,A,xs="Since our dataset has 6 classes and we chose a sample size of 8, our synthetic dataset contains $6\\times 8=48$ examples. If we take a look at a few of the examples:",Jt,q,ut,D,Ut,L,Is="We can see that each input takes the form of the template and has a corresponding label associated with it.",Tt,P,Ws="Let’s not train a SetFit model on these examples!",jt,K,$t,O,ks="To train a SetFit model, the first thing to do is download a pretrained checkpoint from the Hub. We can do so by using the <code>SetFitModel.from_pretrained()</code> method:",Ct,ee,gt,te,Rs='Here, we’ve downloaded a pretrained Sentence Transformer from the Hub and added a logistic classification head to the create the SetFit model. As indicated in the message, we need to train this model on some labeled examples. We can do so by using the <a href="/docs/setfit/v1.0.1/en/reference/trainer#setfit.Trainer">Trainer</a> class as follows:',Zt,se,xt,le,Gs="Now that we’ve created a trainer, we can train it! While we’re at it, let’s time how long it takes to train and evaluate the model:",It,ae,Wt,ne,kt,ie,Rt,pe,Xs="Great, now that we have a reference score let’s compare against the zero-shot pipeline from 🤗 Transformers.",Gt,me,Xt,re,Ns="🤗 Transformers provides a zero-shot pipeline that frames text classification as a natural language inference task. Let’s load the pipeline and place it on the GPU for fast inference:",Nt,oe,Qt,Me,Qs="Now that we have the model, let’s generate some predictions. We’ll use the same candidate labels as we did with SetFit and increase the batch size for to speed things up:",Bt,ye,_t,de,Ft,he,Bs="Note that this took almost 5x longer to generate predictions than SetFit! OK, so how well does it perform? Since each prediction is a dictionary of label names ranked by score:",zt,ce,Vt,fe,vt,we,_s="We can use the <code>str2int()</code> function from the <code>label</code> column to convert them to integers.",Yt,be,Et,Je,Fs="<strong>Note:</strong> As noted earlier, if you’re using a dataset that doesn’t have a <code>ClassLabel</code> feature for the label column, you’ll need to compute the label mapping manually with something like:",St,ue,Ht,Ue,zs="The last step is to compute accuracy using 🤗 Evaluate:",At,Te,qt,je,Dt,$e,Vs="Compared to SetFit, this approach performs significantly worse. Let’s wrap up our analysis by combining synthetic examples with a few labeled ones.",Lt,Ce,Pt,ge,vs="If you have a few labeled examples, adding synthetic data can often boost performance. To simulate this, let’s first sample 8 labeled examples from our reference dataset:",Kt,Ze,Ot,xe,es,Ie,Ys="To warm up, we’ll train a SetFit model on these true labels:",ts,We,ss,ke,ls,Re,Es="Note that for this particular dataset, the performance with true labels is <em>worse</em> than training on synthetic examples! In our experiments, we found that the difference depends strongly on the dataset in question. Since SetFit models are fast to train, you can always try both approaches and pick the best one.",as,Ge,Ss="In any case, let’s now add some synthetic examples to our training set:",ns,Xe,is,Ne,ps,Qe,Hs="As before, we can train and evaluate SetFit with the augmented dataset:",ms,Be,rs,_e,os,Fe,As="Great, this has given us a significant boost in performance and given us a few percentage points over the purely synthetic example.",Ms,ze,qs="Let’s plot the final results for comparison:",ys,Ve,ds,ve,Ds='<img src="https://github.com/huggingface/setfit/assets/37621491/b02d3e62-d51c-4506-91f6-2fe9b7ef554d" alt="setfit_zero_shot_results"/>',hs,Se,cs;return T=new Ee({props:{title:"Zero-shot Text Classification",local:"zero-shot-text-classification",headingTag:"h1"}}),j=new ml({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"}]}}),x=new Ee({props:{title:"Setup",local:"setup",headingTag:"h2"}}),W=new c({props:{code:"JTIzJTIwJTI1cGlwJTIwaW5zdGFsbCUyMHNldGZpdCUyMG1hdHBsb3RsaWI=",highlighted:'<span class="hljs-comment"># %pip install setfit matplotlib</span>',wrap:!1}}),R=new c({props:{code:"ZGF0YXNldF9pZCUyMCUzRCUyMCUyMmVtb3Rpb24lMjIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRnBhcmFwaHJhc2UtbXBuZXQtYmFzZS12MiUyMg==",highlighted:`dataset_id = <span class="hljs-string">&quot;emotion&quot;</span>
model_id = <span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>`,wrap:!1}}),X=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVmZXJlbmNlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9pZCklMEFyZWZlcmVuY2VfZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

reference_dataset = load_dataset(dataset_id)
reference_dataset`,wrap:!1}}),N=new c({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTYwMDAlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwdmFsaWRhdGlvbiUzQSUyMERhdGFzZXQoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0ElMjAlNUIndGV4dCclMkMlMjAnbGFiZWwnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjAyMDAwJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSUyMCUyMCUyMCUyMHRlc3QlM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMjAwMCUwQSUyMCUyMCUyMCUyMCU3RCklMEElN0Qp",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">16000</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">2000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">2000</span>
    })
})`,wrap:!1}}),B=new Ee({props:{title:"Creating a synthetic dataset",local:"creating-a-synthetic-dataset",headingTag:"h2"}}),V=new c({props:{code:"JTIzJTIwRXh0cmFjdCUyMENsYXNzTGFiZWwlMjBmZWF0dXJlJTIwZnJvbSUyMCUyMmxhYmVsJTIyJTIwY29sdW1uJTBBbGFiZWxfZmVhdHVyZXMlMjAlM0QlMjByZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQlMEElMjMlMjBMYWJlbCUyMG5hbWVzJTIwdG8lMjBjbGFzc2lmeSUyMHdpdGglMEFjYW5kaWRhdGVfbGFiZWxzJTIwJTNEJTIwbGFiZWxfZmVhdHVyZXMubmFtZXMlMEFjYW5kaWRhdGVfbGFiZWxz",highlighted:`<span class="hljs-comment"># Extract ClassLabel feature from &quot;label&quot; column</span>
label_features = reference_dataset[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-comment"># Label names to classify with</span>
candidate_labels = label_features.names
candidate_labels`,wrap:!1}}),v=new c({props:{code:"JTVCJ3NhZG5lc3MnJTJDJTIwJ2pveSclMkMlMjAnbG92ZSclMkMlMjAnYW5nZXInJTJDJTIwJ2ZlYXInJTJDJTIwJ3N1cnByaXNlJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;sadness</span>&#x27;, <span class="hljs-symbol">&#x27;joy</span>&#x27;, <span class="hljs-symbol">&#x27;love</span>&#x27;, <span class="hljs-symbol">&#x27;anger</span>&#x27;, <span class="hljs-symbol">&#x27;fear</span>&#x27;, <span class="hljs-symbol">&#x27;surprise</span>&#x27;]',wrap:!1}}),u=new el({props:{$$slots:{default:[rl]},$$scope:{ctx:Ye}}}),Y=new c({props:{code:"ZGVmJTIwZ2V0X2lkMmxhYmVsKGRhdGFzZXQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwY29sdW1uJTIwd2l0aCUyMHRoZSUyMGxhYmVsJTIwbmFtZXMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUyMCUzRCUyMGRhdGFzZXQudW5pcXVlKCUyMmxhYmVsX3RleHQlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwY29sdW1uJTIwd2l0aCUyMHRoZSUyMGxhYmVsJTIwSURzJTBBJTIwJTIwJTIwJTIwbGFiZWxfaWRzJTIwJTNEJTIwZGF0YXNldC51bmlxdWUoJTIybGFiZWwlMjIpJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlMjAlM0QlMjBkaWN0KHppcChsYWJlbF9pZHMlMkMlMjBsYWJlbF9uYW1lcykpJTBBJTIwJTIwJTIwJTIwJTIzJTIwU29ydCUyMGJ5JTIwbGFiZWwlMjBJRCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QmtleSUzQSUyMHZhbCUyMGZvciUyMGtleSUyQyUyMHZhbCUyMGluJTIwc29ydGVkKGlkMmxhYmVsLml0ZW1zKCklMkMlMjBrZXklMjAlM0QlMjBsYW1iZGElMjB4JTNBJTIweCU1QjAlNUQpJTdEJTBBJTBBaWQybGFiZWwlMjAlM0QlMjBnZXRfaWQybGFiZWwocmVmZXJlbmNlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCklMEFjYW5kaWRhdGVfbGFiZWxzJTIwJTNEJTIwbGlzdChpZDJsYWJlbC52YWx1ZXMoKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_id2label</span>(<span class="hljs-params">dataset</span>):
    <span class="hljs-comment"># The column with the label names</span>
    label_names = dataset.unique(<span class="hljs-string">&quot;label_text&quot;</span>)
    <span class="hljs-comment"># The column with the label IDs</span>
    label_ids = dataset.unique(<span class="hljs-string">&quot;label&quot;</span>)
    id2label = <span class="hljs-built_in">dict</span>(<span class="hljs-built_in">zip</span>(label_ids, label_names))
    <span class="hljs-comment"># Sort by label ID</span>
    <span class="hljs-keyword">return</span> {key: val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(id2label.items(), key = <span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">0</span>])}

id2label = get_id2label(reference_dataset[<span class="hljs-string">&quot;train&quot;</span>])
candidate_labels = <span class="hljs-built_in">list</span>(id2label.values())`,wrap:!1}}),S=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjBzZXRmaXQlMjBpbXBvcnQlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQlMEElMEElMjMlMjBBJTIwZHVtbXklMjBkYXRhc2V0JTIwdG8lMjBmaWxsJTIwd2l0aCUyMHN5bnRoZXRpYyUyMGV4YW1wbGVzJTBBZHVtbXlfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiU3RCklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0KGR1bW15X2RhdGFzZXQlMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTNEY2FuZGlkYXRlX2xhYmVscyUyQyUyMHNhbXBsZV9zaXplJTNEOCklMEF0cmFpbl9kYXRhc2V0",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> get_templated_dataset

<span class="hljs-comment"># A dummy dataset to fill with synthetic examples</span>
dummy_dataset = Dataset.from_dict({})
train_dataset = get_templated_dataset(dummy_dataset, candidate_labels=candidate_labels, sample_size=<span class="hljs-number">8</span>)
train_dataset`,wrap:!1}}),H=new c({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQ4JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">48</span>
})`,wrap:!1}}),U=new el({props:{$$slots:{default:[ol]},$$scope:{ctx:Ye}}}),q=new c({props:{code:"dHJhaW5fZGF0YXNldC5zaHVmZmxlKCklNUIlM0EzJTVE",highlighted:'train_dataset.shuffle()[:<span class="hljs-number">3</span>]',wrap:!1}}),D=new c({props:{code:"JTdCJ3RleHQnJTNBJTIwJTVCJ1RoaXMlMjBzZW50ZW5jZSUyMGlzJTIwbG92ZSclMkMlMEElMjAlMjAnVGhpcyUyMHNlbnRlbmNlJTIwaXMlMjBmZWFyJyUyQyUwQSUyMCUyMCdUaGlzJTIwc2VudGVuY2UlMjBpcyUyMGpveSclNUQlMkMlMEElMjAnbGFiZWwnJTNBJTIwJTVCMiUyQyUyMDQlMkMlMjAxJTVEJTdE",highlighted:`{<span class="hljs-symbol">&#x27;text</span>&#x27;: [<span class="hljs-symbol">&#x27;This</span> sentence <span class="hljs-keyword">is</span> love&#x27;,
  <span class="hljs-symbol">&#x27;This</span> sentence <span class="hljs-keyword">is</span> fear&#x27;,
  <span class="hljs-symbol">&#x27;This</span> sentence <span class="hljs-keyword">is</span> joy&#x27;],
 <span class="hljs-symbol">&#x27;label</span>&#x27;: [<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),K=new Ee({props:{title:"Fine-tuning the model",local:"fine-tuning-the-model",headingTag:"h2"}}),ee=new c({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

model = SetFitModel.from_pretrained(model_id)`,wrap:!1}}),se=new c({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RyZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>]
)`,wrap:!1}}),ae=new c({props:{code:"JTI1JTI1dGltZSUwQXRyYWluZXIudHJhaW4oKSUwQXplcm9zaG90X21ldHJpY3MlMjAlM0QlMjB0cmFpbmVyLmV2YWx1YXRlKCklMEF6ZXJvc2hvdF9tZXRyaWNz",highlighted:`%%time
trainer.train()
zeroshot_metrics = trainer.evaluate()
zeroshot_metrics`,wrap:!1}}),ne=new c({props:{code:"KioqKiolMjBSdW5uaW5nJTIwdHJhaW5pbmclMjAqKioqKiUwQSUyMCUyME51bSUyMGV4YW1wbGVzJTIwJTNEJTIwMTkyMCUwQSUyMCUyME51bSUyMGVwb2NocyUyMCUzRCUyMDElMEElMjAlMjBUb3RhbCUyMG9wdGltaXphdGlvbiUyMHN0ZXBzJTIwJTNEJTIwMTIwJTBBJTIwJTIwVG90YWwlMjB0cmFpbiUyMGJhdGNoJTIwc2l6ZSUyMCUzRCUyMDE2JTBBKioqKiolMjBSdW5uaW5nJTIwZXZhbHVhdGlvbiUyMCoqKioqJTBBJTdCJ2FjY3VyYWN5JyUzQSUyMDAuNTM0NSU3RA==",highlighted:`***** Running training *****
  Num examples = <span class="hljs-number">1920</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">120</span>
  Total train batch size = <span class="hljs-number">16</span>
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.5345</span>}`,wrap:!1}}),ie=new c({props:{code:"Q1BVJTIwdGltZXMlM0ElMjB1c2VyJTIwMTIuOSUyMHMlMkMlMjBzeXMlM0ElMjAyLjM3JTIwcyUyQyUyMHRvdGFsJTNBJTIwMTUuMiUyMHMlMEFXYWxsJTIwdGltZSUzQSUyMDExJTIwcw==",highlighted:`<span class="hljs-attribute">CPU</span> times: user <span class="hljs-number">12</span>.<span class="hljs-number">9</span> s, sys: <span class="hljs-number">2</span>.<span class="hljs-number">37</span> s, total: <span class="hljs-number">15</span>.<span class="hljs-number">2</span> s
<span class="hljs-attribute">Wall</span> time: <span class="hljs-number">11</span> s`,wrap:!1}}),me=new Ee({props:{title:"Comparing against the zero-shot pipeline from 🤗 Transformers",local:"comparing-against-the-zero-shot-pipeline-from--transformers",headingTag:"h2"}}),oe=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnplcm8tc2hvdC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMGRldmljZSUzRDAp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, device=<span class="hljs-number">0</span>)`,wrap:!1}}),ye=new c({props:{code:"JTI1JTI1dGltZSUwQXplcm9zaG90X3ByZWRzJTIwJTNEJTIwcGlwZShyZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDE2JTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`%%time
zeroshot_preds = pipe(reference_dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;text&quot;</span>], batch_size=<span class="hljs-number">16</span>, candidate_labels=candidate_labels)`,wrap:!1}}),de=new c({props:{code:"Q1BVJTIwdGltZXMlM0ElMjB1c2VyJTIwMW1pbiUyMDEwcyUyQyUyMHN5cyUzQSUyMDE2NiUyMG1zJTJDJTIwdG90YWwlM0ElMjAxbWluJTIwMTFzJTBBV2FsbCUyMHRpbWUlM0ElMjA1My4xJTIwcw==",highlighted:`<span class="hljs-attribute">CPU</span> times: user <span class="hljs-number">1</span>min <span class="hljs-number">10</span>s, sys: <span class="hljs-number">166</span> ms, total: <span class="hljs-number">1</span>min <span class="hljs-number">11</span>s
<span class="hljs-attribute">Wall</span> time: <span class="hljs-number">53</span>.<span class="hljs-number">1</span> s`,wrap:!1}}),ce=new c({props:{code:"emVyb3Nob3RfcHJlZHMlNUIwJTVE",highlighted:'zeroshot_preds[<span class="hljs-number">0</span>]',wrap:!1}}),fe=new c({props:{code:"JTdCJ3NlcXVlbmNlJyUzQSUyMCdpbSUyMGZlZWxpbmclMjByYXRoZXIlMjByb3R0ZW4lMjBzbyUyMGltJTIwbm90JTIwdmVyeSUyMGFtYml0aW91cyUyMHJpZ2h0JTIwbm93JyUyQyUwQSUyMCdsYWJlbHMnJTNBJTIwJTVCJ3NhZG5lc3MnJTJDJTIwJ2FuZ2VyJyUyQyUyMCdzdXJwcmlzZSclMkMlMjAnZmVhciclMkMlMjAnam95JyUyQyUyMCdsb3ZlJyU1RCUyQyUwQSUyMCdzY29yZXMnJTNBJTIwJTVCMC43MzY3OTg1ODQ0NjEyMTIyJTJDJTBBJTIwJTIwMC4xMDA0MTY3NDIyNjUyMjQ0NiUyQyUwQSUyMCUyMDAuMDk3NzAxNTY0NDMxMTkwNDklMkMlMEElMjAlMjAwLjA1ODgwMTEwNzEwODU5Mjk5JTJDJTBBJTIwJTIwMC4wMDQyNjYzNTU2NTIzNjIxMDglMkMlMEElMjAlMjAwLjAwMjAxNTY3NjgxNTA2Mjc2MTMlNUQlN0Q=",highlighted:`{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;im feeling rather rotten so im not very ambitious right now&#x27;</span>,
 <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;sadness&#x27;</span>, <span class="hljs-string">&#x27;anger&#x27;</span>, <span class="hljs-string">&#x27;surprise&#x27;</span>, <span class="hljs-string">&#x27;fear&#x27;</span>, <span class="hljs-string">&#x27;joy&#x27;</span>, <span class="hljs-string">&#x27;love&#x27;</span>],
 <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.7367985844612122</span>,
  <span class="hljs-number">0.10041674226522446</span>,
  <span class="hljs-number">0.09770156443119049</span>,
  <span class="hljs-number">0.05880110710859299</span>,
  <span class="hljs-number">0.004266355652362108</span>,
  <span class="hljs-number">0.0020156768150627613</span>]}`,wrap:!1}}),be=new c({props:{code:"cHJlZHMlMjAlM0QlMjAlNUJsYWJlbF9mZWF0dXJlcy5zdHIyaW50KHByZWQlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEKSUyMGZvciUyMHByZWQlMjBpbiUyMHplcm9zaG90X3ByZWRzJTVE",highlighted:'preds = [label_features.str2int(pred[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> zeroshot_preds]',wrap:!1}}),ue=new c({props:{code:"aWQybGFiZWwlMjAlM0QlMjBnZXRfaWQybGFiZWwocmVmZXJlbmNlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCklMEFsYWJlbDJpZCUyMCUzRCUyMCU3QnYlM0FrJTIwZm9yJTIwayUyQ3YlMjBpbiUyMGlkMmxhYmVsLml0ZW1zKCklN0QlMEFwcmVkcyUyMCUzRCUyMCU1QmxhYmVsMmlkJTVCcHJlZCU1QiUyMmxhYmVscyUyMiU1RCU1QjAlNUQlNUQlMjBmb3IlMjBwcmVkJTIwaW4lMjB6ZXJvc2hvdF9wcmVkcyU1RA==",highlighted:`id2label = get_id2label(reference_dataset[<span class="hljs-string">&quot;train&quot;</span>])
label2id = {v:k <span class="hljs-keyword">for</span> k,v <span class="hljs-keyword">in</span> id2label.items()}
preds = [label2id[pred[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]] <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> zeroshot_preds]`,wrap:!1}}),Te=new c({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQXRyYW5zZm9ybWVyc19tZXRyaWNzJTIwJTNEJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkcyUyQyUyMHJlZmVyZW5jZXMlM0RyZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJsYWJlbCUyMiU1RCklMEF0cmFuc2Zvcm1lcnNfbWV0cmljcw==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)
transformers_metrics = metric.compute(predictions=preds, references=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;label&quot;</span>])
transformers_metrics`,wrap:!1}}),je=new c({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuMzc2NSU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.3765</span>}',wrap:!1}}),Ce=new Ee({props:{title:"Augmenting labeled data with synthetic examples",local:"augmenting-labeled-data-with-synthetic-examples",headingTag:"h2"}}),Ze=new c({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNhbXBsZV9kYXRhc2V0KHJlZmVyZW5jZV9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBdHJhaW5fZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

train_dataset = sample_dataset(reference_dataset[<span class="hljs-string">&quot;train&quot;</span>])
train_dataset`,wrap:!1}}),xe=new c({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQ4JTBBJTdEKQ==",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">48</span>
})`,wrap:!1}}),We=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEcmVmZXJlbmNlX2RhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTBBKSUwQXRyYWluZXIudHJhaW4oKSUwQWZld3Nob3RfbWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQWZld3Nob3RfbWV0cmljcw==",highlighted:`model = SetFitModel.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>]
)
trainer.train()
fewshot_metrics = trainer.evaluate()
fewshot_metrics`,wrap:!1}}),ke=new c({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNDcwNSU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.4705</span>}',wrap:!1}}),Xe=new c({props:{code:"YXVnbWVudGVkX2RhdGFzZXQlMjAlM0QlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQodHJhaW5fZGF0YXNldCUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RjYW5kaWRhdGVfbGFiZWxzJTJDJTIwc2FtcGxlX3NpemUlM0Q4KSUwQWF1Z21lbnRlZF9kYXRhc2V0",highlighted:`augmented_dataset = get_templated_dataset(train_dataset, candidate_labels=candidate_labels, sample_size=<span class="hljs-number">8</span>)
augmented_dataset`,wrap:!1}}),Ne=new c({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDk2JTBBJTdEKQ==",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">96</span>
})`,wrap:!1}}),Be=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RhdWdtZW50ZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHJlZmVyZW5jZV9kYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUwQSklMEF0cmFpbmVyLnRyYWluKCklMEFhdWdtZW50ZWRfbWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQWF1Z21lbnRlZF9tZXRyaWNz",highlighted:`model = SetFitModel.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    train_dataset=augmented_dataset,
    eval_dataset=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>]
)
trainer.train()
augmented_metrics = trainer.evaluate()
augmented_metrics`,wrap:!1}}),_e=new c({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjEzJTdE",highlighted:'{&#x27;accuracy&#x27;: <span class="hljs-number">0.613</span>}',wrap:!1}}),Ve=new c({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdCglN0IlMjJNZXRob2QlMjIlM0ElNUIlMjJUcmFuc2Zvcm1lcnMlMjAoemVyby1zaG90KSUyMiUyQyUyMCUyMlNldEZpdCUyMCh6ZXJvLXNob3QpJTIyJTJDJTIwJTIyU2V0Rml0JTIwKGF1Z21lbnRlZCklMjIlNUQlMkMlMjAlMjJBY2N1cmFjeSUyMiUzQSUyMCU1QnRyYW5zZm9ybWVyc19tZXRyaWNzJTVCJTIyYWNjdXJhY3klMjIlNUQlMkMlMjB6ZXJvc2hvdF9tZXRyaWNzJTVCJTIyYWNjdXJhY3klMjIlNUQlMkMlMjBhdWdtZW50ZWRfbWV0cmljcyU1QiUyMmFjY3VyYWN5JTIyJTVEJTVEJTdEKSUwQWRmLnBsb3Qoa2luZCUzRCUyMmJhcmglMjIlMkMlMjB4JTNEJTIyTWV0aG9kJTIyKSUzQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMA==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame.from_dict({<span class="hljs-string">&quot;Method&quot;</span>:[<span class="hljs-string">&quot;Transformers (zero-shot)&quot;</span>, <span class="hljs-string">&quot;SetFit (zero-shot)&quot;</span>, <span class="hljs-string">&quot;SetFit (augmented)&quot;</span>], <span class="hljs-string">&quot;Accuracy&quot;</span>: [transformers_metrics[<span class="hljs-string">&quot;accuracy&quot;</span>], zeroshot_metrics[<span class="hljs-string">&quot;accuracy&quot;</span>], augmented_metrics[<span class="hljs-string">&quot;accuracy&quot;</span>]]})
df.plot(kind=<span class="hljs-string">&quot;barh&quot;</span>, x=<span class="hljs-string">&quot;Method&quot;</span>);                                       `,wrap:!1}}),{c(){f=y("meta"),b=a(),w=y("p"),J=a(),i(T.$$.fragment),He=a(),i(j.$$.fragment),Ae=a(),$=y("p"),$.innerHTML=fs,qe=a(),C=y("p"),C.textContent=ws,De=a(),g=y("p"),g.textContent=bs,Le=a(),Z=y("ul"),Z.innerHTML=Js,Pe=a(),i(x.$$.fragment),Ke=a(),I=y("p"),I.innerHTML=us,Oe=a(),i(W.$$.fragment),et=a(),k=y("p"),k.textContent=Us,tt=a(),i(R.$$.fragment),st=a(),G=y("p"),G.textContent=Ts,lt=a(),i(X.$$.fragment),at=a(),i(N.$$.fragment),nt=a(),Q=y("p"),Q.textContent=js,it=a(),i(B.$$.fragment),pt=a(),_=y("p"),_.innerHTML=$s,mt=a(),F=y("ul"),F.innerHTML=Cs,rt=a(),z=y("p"),z.textContent=gs,ot=a(),i(V.$$.fragment),Mt=a(),i(v.$$.fragment),yt=a(),i(u.$$.fragment),dt=a(),i(Y.$$.fragment),ht=a(),E=y("p"),E.textContent=Zs,ct=a(),i(S.$$.fragment),ft=a(),i(H.$$.fragment),wt=a(),i(U.$$.fragment),bt=a(),A=y("p"),A.textContent=xs,Jt=a(),i(q.$$.fragment),ut=a(),i(D.$$.fragment),Ut=a(),L=y("p"),L.textContent=Is,Tt=a(),P=y("p"),P.textContent=Ws,jt=a(),i(K.$$.fragment),$t=a(),O=y("p"),O.innerHTML=ks,Ct=a(),i(ee.$$.fragment),gt=a(),te=y("p"),te.innerHTML=Rs,Zt=a(),i(se.$$.fragment),xt=a(),le=y("p"),le.textContent=Gs,It=a(),i(ae.$$.fragment),Wt=a(),i(ne.$$.fragment),kt=a(),i(ie.$$.fragment),Rt=a(),pe=y("p"),pe.textContent=Xs,Gt=a(),i(me.$$.fragment),Xt=a(),re=y("p"),re.textContent=Ns,Nt=a(),i(oe.$$.fragment),Qt=a(),Me=y("p"),Me.textContent=Qs,Bt=a(),i(ye.$$.fragment),_t=a(),i(de.$$.fragment),Ft=a(),he=y("p"),he.textContent=Bs,zt=a(),i(ce.$$.fragment),Vt=a(),i(fe.$$.fragment),vt=a(),we=y("p"),we.innerHTML=_s,Yt=a(),i(be.$$.fragment),Et=a(),Je=y("p"),Je.innerHTML=Fs,St=a(),i(ue.$$.fragment),Ht=a(),Ue=y("p"),Ue.textContent=zs,At=a(),i(Te.$$.fragment),qt=a(),i(je.$$.fragment),Dt=a(),$e=y("p"),$e.textContent=Vs,Lt=a(),i(Ce.$$.fragment),Pt=a(),ge=y("p"),ge.textContent=vs,Kt=a(),i(Ze.$$.fragment),Ot=a(),i(xe.$$.fragment),es=a(),Ie=y("p"),Ie.textContent=Ys,ts=a(),i(We.$$.fragment),ss=a(),i(ke.$$.fragment),ls=a(),Re=y("p"),Re.innerHTML=Es,as=a(),Ge=y("p"),Ge.textContent=Ss,ns=a(),i(Xe.$$.fragment),is=a(),i(Ne.$$.fragment),ps=a(),Qe=y("p"),Qe.textContent=Hs,ms=a(),i(Be.$$.fragment),rs=a(),i(_e.$$.fragment),os=a(),Fe=y("p"),Fe.textContent=As,Ms=a(),ze=y("p"),ze.textContent=qs,ys=a(),i(Ve.$$.fragment),ds=a(),ve=y("p"),ve.innerHTML=Ds,hs=a(),Se=y("p"),this.h()},l(e){const t=il("svelte-u9bgzb",document.head);f=d(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(e),w=d(e,"P",{}),Ks(w).forEach(s),J=n(e),p(T.$$.fragment,e),He=n(e),p(j.$$.fragment,e),Ae=n(e),$=d(e,"P",{"data-svelte-h":!0}),h($)!=="svelte-49m0ob"&&($.innerHTML=fs),qe=n(e),C=d(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1pgs32t"&&(C.textContent=ws),De=n(e),g=d(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-lmbomz"&&(g.textContent=bs),Le=n(e),Z=d(e,"UL",{"data-svelte-h":!0}),h(Z)!=="svelte-1dtrqj6"&&(Z.innerHTML=Js),Pe=n(e),p(x.$$.fragment,e),Ke=n(e),I=d(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-12h4adn"&&(I.innerHTML=us),Oe=n(e),p(W.$$.fragment,e),et=n(e),k=d(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-15vly9o"&&(k.textContent=Us),tt=n(e),p(R.$$.fragment,e),st=n(e),G=d(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-3ogv3u"&&(G.textContent=Ts),lt=n(e),p(X.$$.fragment,e),at=n(e),p(N.$$.fragment,e),nt=n(e),Q=d(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1w6rynr"&&(Q.textContent=js),it=n(e),p(B.$$.fragment,e),pt=n(e),_=d(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-adojsi"&&(_.innerHTML=$s),mt=n(e),F=d(e,"UL",{"data-svelte-h":!0}),h(F)!=="svelte-by6xjw"&&(F.innerHTML=Cs),rt=n(e),z=d(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1i04wu6"&&(z.textContent=gs),ot=n(e),p(V.$$.fragment,e),Mt=n(e),p(v.$$.fragment,e),yt=n(e),p(u.$$.fragment,e),dt=n(e),p(Y.$$.fragment,e),ht=n(e),E=d(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-cdjdl1"&&(E.textContent=Zs),ct=n(e),p(S.$$.fragment,e),ft=n(e),p(H.$$.fragment,e),wt=n(e),p(U.$$.fragment,e),bt=n(e),A=d(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-15vjhv3"&&(A.textContent=xs),Jt=n(e),p(q.$$.fragment,e),ut=n(e),p(D.$$.fragment,e),Ut=n(e),L=d(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1nsze7a"&&(L.textContent=Is),Tt=n(e),P=d(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1f237sj"&&(P.textContent=Ws),jt=n(e),p(K.$$.fragment,e),$t=n(e),O=d(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1wsggxt"&&(O.innerHTML=ks),Ct=n(e),p(ee.$$.fragment,e),gt=n(e),te=d(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-11y4fl9"&&(te.innerHTML=Rs),Zt=n(e),p(se.$$.fragment,e),xt=n(e),le=d(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1j39k4m"&&(le.textContent=Gs),It=n(e),p(ae.$$.fragment,e),Wt=n(e),p(ne.$$.fragment,e),kt=n(e),p(ie.$$.fragment,e),Rt=n(e),pe=d(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-qy8724"&&(pe.textContent=Xs),Gt=n(e),p(me.$$.fragment,e),Xt=n(e),re=d(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1f0jnhg"&&(re.textContent=Ns),Nt=n(e),p(oe.$$.fragment,e),Qt=n(e),Me=d(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-1cgr0vy"&&(Me.textContent=Qs),Bt=n(e),p(ye.$$.fragment,e),_t=n(e),p(de.$$.fragment,e),Ft=n(e),he=d(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-86x017"&&(he.textContent=Bs),zt=n(e),p(ce.$$.fragment,e),Vt=n(e),p(fe.$$.fragment,e),vt=n(e),we=d(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1n8twc4"&&(we.innerHTML=_s),Yt=n(e),p(be.$$.fragment,e),Et=n(e),Je=d(e,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-1ftqzjk"&&(Je.innerHTML=Fs),St=n(e),p(ue.$$.fragment,e),Ht=n(e),Ue=d(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-12zr7cu"&&(Ue.textContent=zs),At=n(e),p(Te.$$.fragment,e),qt=n(e),p(je.$$.fragment,e),Dt=n(e),$e=d(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-17sxasd"&&($e.textContent=Vs),Lt=n(e),p(Ce.$$.fragment,e),Pt=n(e),ge=d(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-1flrffh"&&(ge.textContent=vs),Kt=n(e),p(Ze.$$.fragment,e),Ot=n(e),p(xe.$$.fragment,e),es=n(e),Ie=d(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1bycgqm"&&(Ie.textContent=Ys),ts=n(e),p(We.$$.fragment,e),ss=n(e),p(ke.$$.fragment,e),ls=n(e),Re=d(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-wg4hvq"&&(Re.innerHTML=Es),as=n(e),Ge=d(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-m7nb3g"&&(Ge.textContent=Ss),ns=n(e),p(Xe.$$.fragment,e),is=n(e),p(Ne.$$.fragment,e),ps=n(e),Qe=d(e,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1109ka9"&&(Qe.textContent=Hs),ms=n(e),p(Be.$$.fragment,e),rs=n(e),p(_e.$$.fragment,e),os=n(e),Fe=d(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-1356otx"&&(Fe.textContent=As),Ms=n(e),ze=d(e,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-nj653h"&&(ze.textContent=qs),ys=n(e),p(Ve.$$.fragment,e),ds=n(e),ve=d(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-14ep6rh"&&(ve.innerHTML=Ds),hs=n(e),Se=d(e,"P",{}),Ks(Se).forEach(s),this.h()},h(){Os(f,"name","hf:doc:metadata"),Os(f,"content",yl)},m(e,t){pl(document.head,f),l(e,b,t),l(e,w,t),l(e,J,t),m(T,e,t),l(e,He,t),m(j,e,t),l(e,Ae,t),l(e,$,t),l(e,qe,t),l(e,C,t),l(e,De,t),l(e,g,t),l(e,Le,t),l(e,Z,t),l(e,Pe,t),m(x,e,t),l(e,Ke,t),l(e,I,t),l(e,Oe,t),m(W,e,t),l(e,et,t),l(e,k,t),l(e,tt,t),m(R,e,t),l(e,st,t),l(e,G,t),l(e,lt,t),m(X,e,t),l(e,at,t),m(N,e,t),l(e,nt,t),l(e,Q,t),l(e,it,t),m(B,e,t),l(e,pt,t),l(e,_,t),l(e,mt,t),l(e,F,t),l(e,rt,t),l(e,z,t),l(e,ot,t),m(V,e,t),l(e,Mt,t),m(v,e,t),l(e,yt,t),m(u,e,t),l(e,dt,t),m(Y,e,t),l(e,ht,t),l(e,E,t),l(e,ct,t),m(S,e,t),l(e,ft,t),m(H,e,t),l(e,wt,t),m(U,e,t),l(e,bt,t),l(e,A,t),l(e,Jt,t),m(q,e,t),l(e,ut,t),m(D,e,t),l(e,Ut,t),l(e,L,t),l(e,Tt,t),l(e,P,t),l(e,jt,t),m(K,e,t),l(e,$t,t),l(e,O,t),l(e,Ct,t),m(ee,e,t),l(e,gt,t),l(e,te,t),l(e,Zt,t),m(se,e,t),l(e,xt,t),l(e,le,t),l(e,It,t),m(ae,e,t),l(e,Wt,t),m(ne,e,t),l(e,kt,t),m(ie,e,t),l(e,Rt,t),l(e,pe,t),l(e,Gt,t),m(me,e,t),l(e,Xt,t),l(e,re,t),l(e,Nt,t),m(oe,e,t),l(e,Qt,t),l(e,Me,t),l(e,Bt,t),m(ye,e,t),l(e,_t,t),m(de,e,t),l(e,Ft,t),l(e,he,t),l(e,zt,t),m(ce,e,t),l(e,Vt,t),m(fe,e,t),l(e,vt,t),l(e,we,t),l(e,Yt,t),m(be,e,t),l(e,Et,t),l(e,Je,t),l(e,St,t),m(ue,e,t),l(e,Ht,t),l(e,Ue,t),l(e,At,t),m(Te,e,t),l(e,qt,t),m(je,e,t),l(e,Dt,t),l(e,$e,t),l(e,Lt,t),m(Ce,e,t),l(e,Pt,t),l(e,ge,t),l(e,Kt,t),m(Ze,e,t),l(e,Ot,t),m(xe,e,t),l(e,es,t),l(e,Ie,t),l(e,ts,t),m(We,e,t),l(e,ss,t),m(ke,e,t),l(e,ls,t),l(e,Re,t),l(e,as,t),l(e,Ge,t),l(e,ns,t),m(Xe,e,t),l(e,is,t),m(Ne,e,t),l(e,ps,t),l(e,Qe,t),l(e,ms,t),m(Be,e,t),l(e,rs,t),m(_e,e,t),l(e,os,t),l(e,Fe,t),l(e,Ms,t),l(e,ze,t),l(e,ys,t),m(Ve,e,t),l(e,ds,t),l(e,ve,t),l(e,hs,t),l(e,Se,t),cs=!0},p(e,[t]){const Ls={};t&2&&(Ls.$$scope={dirty:t,ctx:e}),u.$set(Ls);const Ps={};t&2&&(Ps.$$scope={dirty:t,ctx:e}),U.$set(Ps)},i(e){cs||(r(T.$$.fragment,e),r(j.$$.fragment,e),r(x.$$.fragment,e),r(W.$$.fragment,e),r(R.$$.fragment,e),r(X.$$.fragment,e),r(N.$$.fragment,e),r(B.$$.fragment,e),r(V.$$.fragment,e),r(v.$$.fragment,e),r(u.$$.fragment,e),r(Y.$$.fragment,e),r(S.$$.fragment,e),r(H.$$.fragment,e),r(U.$$.fragment,e),r(q.$$.fragment,e),r(D.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(ne.$$.fragment,e),r(ie.$$.fragment,e),r(me.$$.fragment,e),r(oe.$$.fragment,e),r(ye.$$.fragment,e),r(de.$$.fragment,e),r(ce.$$.fragment,e),r(fe.$$.fragment,e),r(be.$$.fragment,e),r(ue.$$.fragment,e),r(Te.$$.fragment,e),r(je.$$.fragment,e),r(Ce.$$.fragment,e),r(Ze.$$.fragment,e),r(xe.$$.fragment,e),r(We.$$.fragment,e),r(ke.$$.fragment,e),r(Xe.$$.fragment,e),r(Ne.$$.fragment,e),r(Be.$$.fragment,e),r(_e.$$.fragment,e),r(Ve.$$.fragment,e),cs=!0)},o(e){o(T.$$.fragment,e),o(j.$$.fragment,e),o(x.$$.fragment,e),o(W.$$.fragment,e),o(R.$$.fragment,e),o(X.$$.fragment,e),o(N.$$.fragment,e),o(B.$$.fragment,e),o(V.$$.fragment,e),o(v.$$.fragment,e),o(u.$$.fragment,e),o(Y.$$.fragment,e),o(S.$$.fragment,e),o(H.$$.fragment,e),o(U.$$.fragment,e),o(q.$$.fragment,e),o(D.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(ne.$$.fragment,e),o(ie.$$.fragment,e),o(me.$$.fragment,e),o(oe.$$.fragment,e),o(ye.$$.fragment,e),o(de.$$.fragment,e),o(ce.$$.fragment,e),o(fe.$$.fragment,e),o(be.$$.fragment,e),o(ue.$$.fragment,e),o(Te.$$.fragment,e),o(je.$$.fragment,e),o(Ce.$$.fragment,e),o(Ze.$$.fragment,e),o(xe.$$.fragment,e),o(We.$$.fragment,e),o(ke.$$.fragment,e),o(Xe.$$.fragment,e),o(Ne.$$.fragment,e),o(Be.$$.fragment,e),o(_e.$$.fragment,e),o(Ve.$$.fragment,e),cs=!1},d(e){e&&(s(b),s(w),s(J),s(He),s(Ae),s($),s(qe),s(C),s(De),s(g),s(Le),s(Z),s(Pe),s(Ke),s(I),s(Oe),s(et),s(k),s(tt),s(st),s(G),s(lt),s(at),s(nt),s(Q),s(it),s(pt),s(_),s(mt),s(F),s(rt),s(z),s(ot),s(Mt),s(yt),s(dt),s(ht),s(E),s(ct),s(ft),s(wt),s(bt),s(A),s(Jt),s(ut),s(Ut),s(L),s(Tt),s(P),s(jt),s($t),s(O),s(Ct),s(gt),s(te),s(Zt),s(xt),s(le),s(It),s(Wt),s(kt),s(Rt),s(pe),s(Gt),s(Xt),s(re),s(Nt),s(Qt),s(Me),s(Bt),s(_t),s(Ft),s(he),s(zt),s(Vt),s(vt),s(we),s(Yt),s(Et),s(Je),s(St),s(Ht),s(Ue),s(At),s(qt),s(Dt),s($e),s(Lt),s(Pt),s(ge),s(Kt),s(Ot),s(es),s(Ie),s(ts),s(ss),s(ls),s(Re),s(as),s(Ge),s(ns),s(is),s(ps),s(Qe),s(ms),s(rs),s(os),s(Fe),s(Ms),s(ze),s(ys),s(ds),s(ve),s(hs),s(Se)),s(f),M(T,e),M(j,e),M(x,e),M(W,e),M(R,e),M(X,e),M(N,e),M(B,e),M(V,e),M(v,e),M(u,e),M(Y,e),M(S,e),M(H,e),M(U,e),M(q,e),M(D,e),M(K,e),M(ee,e),M(se,e),M(ae,e),M(ne,e),M(ie,e),M(me,e),M(oe,e),M(ye,e),M(de,e),M(ce,e),M(fe,e),M(be,e),M(ue,e),M(Te,e),M(je,e),M(Ce,e),M(Ze,e),M(xe,e),M(We,e),M(ke,e),M(Xe,e),M(Ne,e),M(Be,e),M(_e,e),M(Ve,e)}}}const yl='{"title":"Zero-shot Text Classification","local":"zero-shot-text-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Creating a synthetic dataset","local":"creating-a-synthetic-dataset","sections":[],"depth":2},{"title":"Fine-tuning the model","local":"fine-tuning-the-model","sections":[],"depth":2},{"title":"Comparing against the zero-shot pipeline from 🤗 Transformers","local":"comparing-against-the-zero-shot-pipeline-from--transformers","sections":[],"depth":2},{"title":"Augmenting labeled data with synthetic examples","local":"augmenting-labeled-data-with-synthetic-examples","sections":[],"depth":2}],"depth":1}';function dl(Ye){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends al{constructor(f){super(),nl(this,f,dl,Ml,sl,{})}}export{ul as component};
