import{s as ke,n as Ye,o as _e}from"../chunks/scheduler.36a0863c.js";import{S as ze,i as Ne,g as M,s as n,r as s,A as Ve,h as d,f as t,c as i,j as Xe,u as o,x as w,k as Ge,y as Re,a,v as r,d as c,t as p,w as m}from"../chunks/index.9c13489a.js";import{C as y}from"../chunks/CodeBlock.05d8ec32.js";import{H as x}from"../chunks/Heading.7a254a62.js";function Qe(Ue){let u,H,E,S,J,P,j,be='La parallelizzazione è emersa come strategia per allenare modelli sempre più grandi su hardware limitato e accelerarne la velocità di allenamento di diversi ordini di magnitudine. In Hugging Face, abbiamo creato la libreria <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a> per aiutarti ad allenare in modo semplice un modello 🤗 Transformers su qualsiasi tipo di configurazione distribuita, sia che si tratti di più GPU su una sola macchina o di più GPU su più macchine. In questo tutorial, imparerai come personalizzare il training loop nativo di PyTorch per consentire l’addestramento in un ambiente distribuito.',L,T,K,f,he="Inizia installando 🤗 Accelerate:",q,U,D,b,ge='Poi importa e crea un oggetto <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>. <code>Accelerator</code> rileverà automaticamente il tuo setup distribuito e inizializzerà tutte le componenti necessarie per l’allenamento. Non dovrai allocare esplicitamente il tuo modello su un device.',O,h,ee,g,le,I,Ie='Il prossimo passo è quello di passare tutti gli oggetti rilevanti per l’allenamento al metodo <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>. Questo include i tuoi DataLoaders per l’allenamento e per la valutazione, un modello e un ottimizzatore:',te,$,ae,C,ne,B,$e='Infine, sostituisci il tipico metodo <code>loss.backward()</code> nel tuo loop di allenamento con il metodo <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.backward" rel="nofollow"><code>backward</code></a> di 🤗 Accelerate:',ie,A,se,Z,Ce="Come puoi vedere nel seguente codice, hai solo bisogno di aggiungere quattro righe in più di codice al tuo training loop per abilitare l’allenamento distribuito!",oe,v,re,W,ce,X,Be="Una volta che hai aggiunto le righe di codice rilevanti, lancia il tuo allenamento in uno script o in un notebook come Colaboratory.",pe,G,me,k,Ae="Se stai eseguendo il tuo allenamento da uno script, esegui il comando seguente per creare e salvare un file di configurazione:",Me,Y,de,_,Ze="Poi lancia il tuo allenamento con:",we,z,ue,N,ye,V,ve="La libreria 🤗 Accelerate può anche essere utilizzata in un notebook se stai pianificando di utilizzare le TPU di Colaboratory. Inserisci tutto il codice legato all’allenamento in una funzione, e passala al <code>notebook_launcher</code>:",Je,R,je,Q,We='Per maggiori informazioni relative a 🤗 Accelerate e le sue numerose funzionalità, fai riferimento alla <a href="https://huggingface.co/docs/accelerate" rel="nofollow">documentazione</a>.',Te,F,fe;return J=new x({props:{title:"Allenamento distribuito con 🤗 Accelerate",local:"allenamento-distribuito-con--accelerate",headingTag:"h1"}}),T=new x({props:{title:"Configurazione",local:"configurazione",headingTag:"h2"}}),U=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),h=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`,wrap:!1}}),g=new x({props:{title:"Preparati ad accelerare",local:"preparati-ad-accelerare",headingTag:"h2"}}),$=new y({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new x({props:{title:"Backward",local:"backward",headingTag:"h2"}}),A=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),v=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),W=new x({props:{title:"Allenamento",local:"allenamento",headingTag:"h2"}}),G=new x({props:{title:"Allenamento con uno script",local:"allenamento-con-uno-script",headingTag:"h3"}}),Y=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),z=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py",wrap:!1}}),N=new x({props:{title:"Allenamento con un notebook",local:"allenamento-con-un-notebook",headingTag:"h3"}}),R=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`,wrap:!1}}),{c(){u=M("meta"),H=n(),E=M("p"),S=n(),s(J.$$.fragment),P=n(),j=M("p"),j.innerHTML=be,L=n(),s(T.$$.fragment),K=n(),f=M("p"),f.textContent=he,q=n(),s(U.$$.fragment),D=n(),b=M("p"),b.innerHTML=ge,O=n(),s(h.$$.fragment),ee=n(),s(g.$$.fragment),le=n(),I=M("p"),I.innerHTML=Ie,te=n(),s($.$$.fragment),ae=n(),s(C.$$.fragment),ne=n(),B=M("p"),B.innerHTML=$e,ie=n(),s(A.$$.fragment),se=n(),Z=M("p"),Z.textContent=Ce,oe=n(),s(v.$$.fragment),re=n(),s(W.$$.fragment),ce=n(),X=M("p"),X.textContent=Be,pe=n(),s(G.$$.fragment),me=n(),k=M("p"),k.textContent=Ae,Me=n(),s(Y.$$.fragment),de=n(),_=M("p"),_.textContent=Ze,we=n(),s(z.$$.fragment),ue=n(),s(N.$$.fragment),ye=n(),V=M("p"),V.innerHTML=ve,Je=n(),s(R.$$.fragment),je=n(),Q=M("p"),Q.innerHTML=We,Te=n(),F=M("p"),this.h()},l(e){const l=Ve("svelte-u9bgzb",document.head);u=d(l,"META",{name:!0,content:!0}),l.forEach(t),H=i(e),E=d(e,"P",{}),Xe(E).forEach(t),S=i(e),o(J.$$.fragment,e),P=i(e),j=d(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-17ajov5"&&(j.innerHTML=be),L=i(e),o(T.$$.fragment,e),K=i(e),f=d(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-dexkcz"&&(f.textContent=he),q=i(e),o(U.$$.fragment,e),D=i(e),b=d(e,"P",{"data-svelte-h":!0}),w(b)!=="svelte-72811u"&&(b.innerHTML=ge),O=i(e),o(h.$$.fragment,e),ee=i(e),o(g.$$.fragment,e),le=i(e),I=d(e,"P",{"data-svelte-h":!0}),w(I)!=="svelte-1uhe1gm"&&(I.innerHTML=Ie),te=i(e),o($.$$.fragment,e),ae=i(e),o(C.$$.fragment,e),ne=i(e),B=d(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1i670zk"&&(B.innerHTML=$e),ie=i(e),o(A.$$.fragment,e),se=i(e),Z=d(e,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-op71ru"&&(Z.textContent=Ce),oe=i(e),o(v.$$.fragment,e),re=i(e),o(W.$$.fragment,e),ce=i(e),X=d(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-12qrazq"&&(X.textContent=Be),pe=i(e),o(G.$$.fragment,e),me=i(e),k=d(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-11jl52e"&&(k.textContent=Ae),Me=i(e),o(Y.$$.fragment,e),de=i(e),_=d(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-1hc8rs1"&&(_.textContent=Ze),we=i(e),o(z.$$.fragment,e),ue=i(e),o(N.$$.fragment,e),ye=i(e),V=d(e,"P",{"data-svelte-h":!0}),w(V)!=="svelte-zv3zg4"&&(V.innerHTML=ve),Je=i(e),o(R.$$.fragment,e),je=i(e),Q=d(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-1inqsdp"&&(Q.innerHTML=We),Te=i(e),F=d(e,"P",{}),Xe(F).forEach(t),this.h()},h(){Ge(u,"name","hf:doc:metadata"),Ge(u,"content",xe)},m(e,l){Re(document.head,u),a(e,H,l),a(e,E,l),a(e,S,l),r(J,e,l),a(e,P,l),a(e,j,l),a(e,L,l),r(T,e,l),a(e,K,l),a(e,f,l),a(e,q,l),r(U,e,l),a(e,D,l),a(e,b,l),a(e,O,l),r(h,e,l),a(e,ee,l),r(g,e,l),a(e,le,l),a(e,I,l),a(e,te,l),r($,e,l),a(e,ae,l),r(C,e,l),a(e,ne,l),a(e,B,l),a(e,ie,l),r(A,e,l),a(e,se,l),a(e,Z,l),a(e,oe,l),r(v,e,l),a(e,re,l),r(W,e,l),a(e,ce,l),a(e,X,l),a(e,pe,l),r(G,e,l),a(e,me,l),a(e,k,l),a(e,Me,l),r(Y,e,l),a(e,de,l),a(e,_,l),a(e,we,l),r(z,e,l),a(e,ue,l),r(N,e,l),a(e,ye,l),a(e,V,l),a(e,Je,l),r(R,e,l),a(e,je,l),a(e,Q,l),a(e,Te,l),a(e,F,l),fe=!0},p:Ye,i(e){fe||(c(J.$$.fragment,e),c(T.$$.fragment,e),c(U.$$.fragment,e),c(h.$$.fragment,e),c(g.$$.fragment,e),c($.$$.fragment,e),c(C.$$.fragment,e),c(A.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(Y.$$.fragment,e),c(z.$$.fragment,e),c(N.$$.fragment,e),c(R.$$.fragment,e),fe=!0)},o(e){p(J.$$.fragment,e),p(T.$$.fragment,e),p(U.$$.fragment,e),p(h.$$.fragment,e),p(g.$$.fragment,e),p($.$$.fragment,e),p(C.$$.fragment,e),p(A.$$.fragment,e),p(v.$$.fragment,e),p(W.$$.fragment,e),p(G.$$.fragment,e),p(Y.$$.fragment,e),p(z.$$.fragment,e),p(N.$$.fragment,e),p(R.$$.fragment,e),fe=!1},d(e){e&&(t(H),t(E),t(S),t(P),t(j),t(L),t(K),t(f),t(q),t(D),t(b),t(O),t(ee),t(le),t(I),t(te),t(ae),t(ne),t(B),t(ie),t(se),t(Z),t(oe),t(re),t(ce),t(X),t(pe),t(me),t(k),t(Me),t(de),t(_),t(we),t(ue),t(ye),t(V),t(Je),t(je),t(Q),t(Te),t(F)),t(u),m(J,e),m(T,e),m(U,e),m(h,e),m(g,e),m($,e),m(C,e),m(A,e),m(v,e),m(W,e),m(G,e),m(Y,e),m(z,e),m(N,e),m(R,e)}}}const xe='{"title":"Allenamento distribuito con 🤗 Accelerate","local":"allenamento-distribuito-con--accelerate","sections":[{"title":"Configurazione","local":"configurazione","sections":[],"depth":2},{"title":"Preparati ad accelerare","local":"preparati-ad-accelerare","sections":[],"depth":2},{"title":"Backward","local":"backward","sections":[],"depth":2},{"title":"Allenamento","local":"allenamento","sections":[{"title":"Allenamento con uno script","local":"allenamento-con-uno-script","sections":[],"depth":3},{"title":"Allenamento con un notebook","local":"allenamento-con-un-notebook","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ee(Ue){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends ze{constructor(u){super(),Ne(this,u,Ee,Qe,ke,{})}}export{Le as component};
