import{s as pa,o as ca,n as se}from"../chunks/scheduler.8c3d61f6.js";import{S as da,i as ma,g as p,s as o,r as u,A as fa,h as c,f as n,c as a,j as k,x as f,u as g,k as j,l as ua,y as s,a as d,v as h,d as _,t as y,w as M}from"../chunks/index.da70eac4.js";import{T as ga}from"../chunks/Tip.1d9b8c37.js";import{D as V}from"../chunks/Docstring.a42c214b.js";import{C as oe}from"../chunks/CodeBlock.a9c4becf.js";import{E as ct}from"../chunks/ExampleCodeBlock.da85d3e6.js";import{H as E,E as ha}from"../chunks/getInferenceSnippets.a8672208.js";import{H as ao,a as io}from"../chunks/HfOption.6ab18950.js";function _a(v){let i,b="Click on the SkyReels-V2 models in the right sidebar for more examples of video generation.";return{c(){i=p("p"),i.textContent=b},l(r){i=c(r,"P",{"data-svelte-h":!0}),f(i)!=="svelte-ywvfqg"&&(i.textContent=b)},m(r,m){d(r,i,m)},p:se,d(r){r&&n(i)}}}function ya(v){let i,b='Refer to the <a href="../../optimization/memory">Reduce memory usage</a> guide for more details about the various memory saving techniques.',r,m,T="From the original repo:",l,w,X="<p>You can use —ar_step 5 to enable asynchronous inference. When asynchronous inference, —causal_block_size 5 is recommended while it is not supposed to be set for synchronous generation… Asynchronous inference will take more steps to diffuse the whole sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous inference may improve the instruction following and visual consistent performance.</p>",K,B,Me;return B=new oe({props:{code:"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",highlighted:`<span class="hljs-comment"># pip install ftfy</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, SkyReelsV2DiffusionForcingPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

vae = AutoModel.from_pretrained(<span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-540P-Diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-540P-Diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16)

pipeline = SkyReelsV2DiffusionForcingPipeline.from_pretrained(
    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-540P-Diffusers&quot;</span>,
    vae=vae,
    transformer=transformer,
    torch_dtype=torch.bfloat16
)
flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
pipeline.scheduler = UniPCMultistepScheduler.from_config(pipeline.scheduler.config, flow_shift=flow_shift)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

output = pipeline(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">30</span>,
    height=<span class="hljs-number">544</span>,  <span class="hljs-comment"># 720 for 720P</span>
    width=<span class="hljs-number">960</span>,   <span class="hljs-comment"># 1280 for 720P</span>
    num_frames=<span class="hljs-number">97</span>,
    base_num_frames=<span class="hljs-number">97</span>,  <span class="hljs-comment"># 121 for 720P</span>
    ar_step=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
    causal_block_size=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Number of frames in each block for asynchronous processing</span>
    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos; 17 for long video generations</span>
    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;T2V.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){i=p("p"),i.innerHTML=b,r=o(),m=p("p"),m.textContent=T,l=o(),w=p("blockquote"),w.innerHTML=X,K=o(),u(B.$$.fragment)},l(J){i=c(J,"P",{"data-svelte-h":!0}),f(i)!=="svelte-iowzkr"&&(i.innerHTML=b),r=a(J),m=c(J,"P",{"data-svelte-h":!0}),f(m)!=="svelte-zf2nuc"&&(m.textContent=T),l=a(J),w=c(J,"BLOCKQUOTE",{"data-svelte-h":!0}),f(w)!=="svelte-1ml0aiz"&&(w.innerHTML=X),K=a(J),g(B.$$.fragment,J)},m(J,G){d(J,i,G),d(J,r,G),d(J,m,G),d(J,l,G),d(J,w,G),d(J,K,G),h(B,J,G),Me=!0},p:se,i(J){Me||(_(B.$$.fragment,J),Me=!0)},o(J){y(B.$$.fragment,J),Me=!1},d(J){J&&(n(i),n(r),n(m),n(l),n(w),n(K)),M(B,J)}}}function Ma(v){let i,b;return i=new io({props:{id:"T2V usage",option:"T2V memory",$$slots:{default:[ya]},$$scope:{ctx:v}}}),{c(){u(i.$$.fragment)},l(r){g(i.$$.fragment,r)},m(r,m){h(i,r,m),b=!0},p(r,m){const T={};m&2&&(T.$$scope={dirty:m,ctx:r}),i.$set(T)},i(r){b||(_(i.$$.fragment,r),b=!0)},o(r){y(i.$$.fragment,r),b=!1},d(r){M(i,r)}}}function Ta(v){let i,b;return i=new oe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torchvision.transforms.functional <span class="hljs-keyword">as</span> TF
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, SkyReelsV2DiffusionForcingImageToVideoPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image


model_id = <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>
vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
pipeline = SkyReelsV2DiffusionForcingImageToVideoPipeline.from_pretrained(
    model_id, vae=vae, torch_dtype=torch.bfloat16
)
flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
pipeline.scheduler = UniPCMultistepScheduler.from_config(pipeline.scheduler.config, flow_shift=flow_shift)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

first_frame = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flf2v_input_first_frame.png&quot;</span>)
last_frame = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flf2v_input_last_frame.png&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">aspect_ratio_resize</span>(<span class="hljs-params">image, pipeline, max_area=<span class="hljs-number">720</span> * <span class="hljs-number">1280</span></span>):
    aspect_ratio = image.height / image.width
    mod_value = pipeline.vae_scale_factor_spatial * pipeline.transformer.config.patch_size[<span class="hljs-number">1</span>]
    height = <span class="hljs-built_in">round</span>(np.sqrt(max_area * aspect_ratio)) // mod_value * mod_value
    width = <span class="hljs-built_in">round</span>(np.sqrt(max_area / aspect_ratio)) // mod_value * mod_value
    image = image.resize((width, height))
    <span class="hljs-keyword">return</span> image, height, width

<span class="hljs-keyword">def</span> <span class="hljs-title function_">center_crop_resize</span>(<span class="hljs-params">image, height, width</span>):
    <span class="hljs-comment"># Calculate resize ratio to match first frame dimensions</span>
    resize_ratio = <span class="hljs-built_in">max</span>(width / image.width, height / image.height)

    <span class="hljs-comment"># Resize the image</span>
    width = <span class="hljs-built_in">round</span>(image.width * resize_ratio)
    height = <span class="hljs-built_in">round</span>(image.height * resize_ratio)
    size = [width, height]
    image = TF.center_crop(image, size)

    <span class="hljs-keyword">return</span> image, height, width

first_frame, height, width = aspect_ratio_resize(first_frame, pipeline)
<span class="hljs-keyword">if</span> last_frame.size != first_frame.size:
    last_frame, _, _ = center_crop_resize(last_frame, height, width)

prompt = <span class="hljs-string">&quot;CG animation style, a small blue bird takes off from the ground, flapping its wings. The bird&#x27;s feathers are delicate, with a unique pattern on its chest. The background shows a blue sky with white clouds under bright sunshine. The camera follows the bird upward, capturing its flight and the vastness of the sky from a close-up, low-angle perspective.&quot;</span>

output = pipeline(
    image=first_frame, last_image=last_frame, prompt=prompt, height=height, width=width, guidance_scale=<span class="hljs-number">5.0</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){u(i.$$.fragment)},l(r){g(i.$$.fragment,r)},m(r,m){h(i,r,m),b=!0},p:se,i(r){b||(_(i.$$.fragment,r),b=!0)},o(r){y(i.$$.fragment,r),b=!1},d(r){M(i,r)}}}function ba(v){let i,b;return i=new io({props:{id:"FLF2V usage",option:"usage",$$slots:{default:[Ta]},$$scope:{ctx:v}}}),{c(){u(i.$$.fragment)},l(r){g(i.$$.fragment,r)},m(r,m){h(i,r,m),b=!0},p(r,m){const T={};m&2&&(T.$$scope={dirty:m,ctx:r}),i.$set(T)},i(r){b||(_(i.$$.fragment,r),b=!0)},o(r){y(i.$$.fragment,r),b=!1},d(r){M(i,r)}}}function wa(v){let i,b="<code>SkyReelsV2DiffusionForcingVideoToVideoPipeline</code> extends a given video.",r,m,T;return m=new oe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torchvision.transforms.functional <span class="hljs-keyword">as</span> TF
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, SkyReelsV2DiffusionForcingVideoToVideoPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video


model_id = <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-540P-Diffusers&quot;</span>
vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
pipeline = SkyReelsV2DiffusionForcingVideoToVideoPipeline.from_pretrained(
    model_id, vae=vae, torch_dtype=torch.bfloat16
)
flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
pipeline.scheduler = UniPCMultistepScheduler.from_config(pipeline.scheduler.config, flow_shift=flow_shift)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

video = load_video(<span class="hljs-string">&quot;input_video.mp4&quot;</span>)

prompt = <span class="hljs-string">&quot;CG animation style, a small blue bird takes off from the ground, flapping its wings. The bird&#x27;s feathers are delicate, with a unique pattern on its chest. The background shows a blue sky with white clouds under bright sunshine. The camera follows the bird upward, capturing its flight and the vastness of the sky from a close-up, low-angle perspective.&quot;</span>

output = pipeline(
    video=video, prompt=prompt, height=<span class="hljs-number">544</span>, width=<span class="hljs-number">960</span>, guidance_scale=<span class="hljs-number">5.0</span>,
    num_inference_steps=<span class="hljs-number">30</span>, num_frames=<span class="hljs-number">257</span>, base_num_frames=<span class="hljs-number">97</span><span class="hljs-comment">#, ar_step=5, causal_block_size=5,</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)
<span class="hljs-comment"># Total frames will be the number of frames of given video + 257</span>`,wrap:!1}}),{c(){i=p("p"),i.innerHTML=b,r=o(),u(m.$$.fragment)},l(l){i=c(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-hejicb"&&(i.innerHTML=b),r=a(l),g(m.$$.fragment,l)},m(l,w){d(l,i,w),d(l,r,w),h(m,l,w),T=!0},p:se,i(l){T||(_(m.$$.fragment,l),T=!0)},o(l){y(m.$$.fragment,l),T=!1},d(l){l&&(n(i),n(r)),M(m,l)}}}function Ja(v){let i,b;return i=new io({props:{id:"V2V usage",option:"usage",$$slots:{default:[wa]},$$scope:{ctx:v}}}),{c(){u(i.$$.fragment)},l(r){g(i.$$.fragment,r)},m(r,m){h(i,r,m),b=!0},p(r,m){const T={};m&2&&(T.$$scope={dirty:m,ctx:r}),i.$set(T)},i(r){b||(_(i.$$.fragment,r),b=!0)},o(r){y(i.$$.fragment,r),b=!1},d(r){M(i,r)}}}function va(v){let i,b="Examples:",r,m,T;return m=new oe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2DiffusionForcingPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2DiffusionForcingPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>    ar_step=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
<span class="hljs-meta">... </span>    causal_block_size=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Number of frames processed together in a causal block</span>
<span class="hljs-meta">... </span>    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos</span>
<span class="hljs-meta">... </span>    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){i=p("p"),i.textContent=b,r=o(),u(m.$$.fragment)},l(l){i=c(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-kvfsh7"&&(i.textContent=b),r=a(l),g(m.$$.fragment,l)},m(l,w){d(l,i,w),d(l,r,w),h(m,l,w),T=!0},p:se,i(l){T||(_(m.$$.fragment,l),T=!0)},o(l){y(m.$$.fragment,l),T=!1},d(l){l&&(n(i),n(r)),M(m,l)}}}function ka(v){let i,b="Examples:",r,m,T;return m=new oe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2DiffusionForcingImageToVideoPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2DiffusionForcingImageToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;path/to/image.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>    ar_step=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
<span class="hljs-meta">... </span>    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos</span>
<span class="hljs-meta">... </span>    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){i=p("p"),i.textContent=b,r=o(),u(m.$$.fragment)},l(l){i=c(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-kvfsh7"&&(i.textContent=b),r=a(l),g(m.$$.fragment,l)},m(l,w){d(l,i,w),d(l,r,w),h(m,l,w),T=!0},p:se,i(l){T||(_(m.$$.fragment,l),T=!0)},o(l){y(m.$$.fragment,l),T=!1},d(l){l&&(n(i),n(r)),M(m,l)}}}function ja(v){let i,b="Examples:",r,m,T;return m=new oe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2DiffusionForcingVideoToVideoPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2DiffusionForcingVideoToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>    ar_step=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
<span class="hljs-meta">... </span>    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos</span>
<span class="hljs-meta">... </span>    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){i=p("p"),i.textContent=b,r=o(),u(m.$$.fragment)},l(l){i=c(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-kvfsh7"&&(i.textContent=b),r=a(l),g(m.$$.fragment,l)},m(l,w){d(l,i,w),d(l,r,w),h(m,l,w),T=!0},p:se,i(l){T||(_(m.$$.fragment,l),T=!0)},o(l){y(m.$$.fragment,l),T=!1},d(l){l&&(n(i),n(r)),M(m,l)}}}function Va(v){let i,b="Examples:",r,m,T;return m=new oe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2Pipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-T2V-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-T2V-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-T2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-T2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){i=p("p"),i.textContent=b,r=o(),u(m.$$.fragment)},l(l){i=c(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-kvfsh7"&&(i.textContent=b),r=a(l),g(m.$$.fragment,l)},m(l,w){d(l,i,w),d(l,r,w),h(m,l,w),T=!0},p:se,i(l){T||(_(m.$$.fragment,l),T=!0)},o(l){y(m.$$.fragment,l),T=!1},d(l){l&&(n(i),n(r)),M(m,l)}}}function Ua(v){let i,b="Examples:",r,m,T;return m=new oe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2ImageToVideoPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-I2V-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-I2V-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-I2V-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-I2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2ImageToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-I2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;path/to/image.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){i=p("p"),i.textContent=b,r=o(),u(m.$$.fragment)},l(l){i=c(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-kvfsh7"&&(i.textContent=b),r=a(l),g(m.$$.fragment,l)},m(l,w){d(l,i,w),d(l,r,w),h(m,l,w),T=!0},p:se,i(l){T||(_(m.$$.fragment,l),T=!0)},o(l){y(m.$$.fragment,l),T=!1},d(l){l&&(n(i),n(r)),M(m,l)}}}function Ia(v){let i,b,r,m,T,l='<div class="flex flex-wrap space-x-1"><a href="https://huggingface.co/docs/diffusers/main/en/tutorials/using_peft_for_inference" target="_blank" rel="noopener"><img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/></a></div>',w,X,K,B,Me='<a href="https://huggingface.co/papers/2504.13074" rel="nofollow">SkyReels-V2</a> by the SkyReels Team.',J,G,lo='<em>Recent advances in video generation have been driven by diffusion models and autoregressive frameworks, yet critical challenges persist in harmonizing prompt adherence, visual quality, motion dynamics, and duration: compromises in motion dynamics to enhance temporal visual quality, constrained video duration (5-10 seconds) to prioritize resolution, and inadequate shot-aware generation stemming from general-purpose MLLMs’ inability to interpret cinematic grammar, such as shot composition, actor expressions, and camera motions. These intertwined limitations hinder realistic long-form synthesis and professional film-style generation. To address these limitations, we propose SkyReels-V2, an Infinite-length Film Generative Model, that synergizes Multi-modal Large Language Model (MLLM), Multi-stage Pretraining, Reinforcement Learning, and Diffusion Forcing Framework. Firstly, we design a comprehensive structural representation of video that combines the general descriptions by the Multi-modal LLM and the detailed shot language by sub-expert models. Aided with human annotation, we then train a unified Video Captioner, named SkyCaptioner-V1, to efficiently label the video data. Secondly, we establish progressive-resolution pretraining for the fundamental video generation, followed by a four-stage post-training enhancement: Initial concept-balanced Supervised Fine-Tuning (SFT) improves baseline quality; Motion-specific Reinforcement Learning (RL) training with human-annotated and synthetic distortion data addresses dynamic artifacts; Our diffusion forcing framework with non-decreasing noise schedules enables long-video synthesis in an efficient search space; Final high-quality SFT refines visual fidelity. All the code and models are available at <a href="https://github.com/SkyworkAI/SkyReels-V2" rel="nofollow">this https URL</a>.</em>',dt,Te,ro='You can find all the original SkyReels-V2 checkpoints under the <a href="https://huggingface.co/collections/Skywork/skyreels-v2-6801b1b93df627d441d0d0d9" rel="nofollow">Skywork</a> organization.',mt,be,po="The following SkyReels-V2 models are supported in Diffusers:",ft,we,co='<li><a href="https://huggingface.co/Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers" rel="nofollow">SkyReels-V2 DF 1.3B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-DF-14B-540P-Diffusers" rel="nofollow">SkyReels-V2 DF 14B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-DF-14B-720P-Diffusers" rel="nofollow">SkyReels-V2 DF 14B - 720P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-T2V-14B-540P-Diffusers" rel="nofollow">SkyReels-V2 T2V 14B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-T2V-14B-720P-Diffusers" rel="nofollow">SkyReels-V2 T2V 14B - 720P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-I2V-1.3B-540P-Diffusers" rel="nofollow">SkyReels-V2 I2V 1.3B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-I2V-14B-540P-Diffusers" rel="nofollow">SkyReels-V2 I2V 14B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-I2V-14B-720P-Diffusers" rel="nofollow">SkyReels-V2 I2V 14B - 720P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-FLF2V-1.3B-540P-Diffusers" rel="nofollow">SkyReels-V2 FLF2V 1.3B - 540P</a></li>',ut,ae,gt,Je,ht,ve,mo=`An example with these parameters:
base_num_frames=97, num_frames=97, num_inference_steps=30, ar_step=5, causal_block_size=5`,_t,ke,fo=`vae_scale_factor_temporal -> 4
num_latent_frames: (97-1)//vae_scale_factor_temporal+1 = 25 frames -> 5 blocks of 5 frames each`,yt,je,uo=`base_num_latent_frames = (97-1)//vae_scale_factor_temporal+1 = 25 → blocks = 25//5 = 5 blocks
This 5 blocks means the maximum context length of the model is 25 frames in the latent space.`,Mt,Ve,go=`Asynchronous Processing Timeline:
┌─────────────────────────────────────────────────────────────────┐
│ Steps:    1    6   11   16   21   26   31   36   41   46   50   │
│ Block 1: [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]                       │
│ Block 2:      [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]                  │
│ Block 3:           [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]             │
│ Block 4:                [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]        │
│ Block 5:                     [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]   │
└─────────────────────────────────────────────────────────────────┘`,Tt,Ue,ho=`For Long Videos (num_frames > base_num_frames):
base_num_frames acts as the “sliding window size” for processing long videos.`,bt,Ie,_o=`Example: 257-frame video with base_num_frames=97, overlap_history=17
┌──── Iteration 1 (frames 1-97) ────┐
│ Processing window: 97 frames      │ → 5 blocks, async processing
│ Generates: frames 1-97            │
└───────────────────────────────────┘
┌────── Iteration 2 (frames 81-177) ──────┐
│ Processing window: 97 frames            │
│ Overlap: 17 frames (81-97) from prev    │ → 5 blocks, async processing
│ Generates: frames 98-177                │
└─────────────────────────────────────────┘
┌────── Iteration 3 (frames 161-257) ──────┐
│ Processing window: 97 frames             │
│ Overlap: 17 frames (161-177) from prev   │ → 5 blocks, async processing
│ Generates: frames 178-257                │
└──────────────────────────────────────────┘`,wt,Ze,yo=`Each iteration independently runs the asynchronous processing with its own 5 blocks.
base_num_frames controls:`,Jt,xe,Mo=`<li><p>Memory usage (larger window = more VRAM)</p></li> <li><p>Model context length (must match training constraints)</p></li> <li><p>Number of blocks per iteration (base_num_latent_frames // causal_block_size)</p> <p>Each block takes 30 steps to complete denoising.
Block N starts at step: 1 + (N-1) x ar_step
Total steps: 30 + (5-1) x 5 = 50 steps</p></li>`,vt,Re,To=`Synchronous mode (ar_step=0) would process all blocks/frames simultaneously:
┌──────────────────────────────────────────────┐
│ Steps:       1            …            30  │
│ All blocks: [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■] │
└──────────────────────────────────────────────┘
Total steps: 30 steps`,kt,Se,bo=`An example on how the step matrix is constructed for asynchronous processing:
Given the parameters: (num_inference_steps=30, flow_shift=8, num_frames=97, ar_step=5, causal_block_size=5)`,jt,Be,wo=`<li><p>num_latent_frames = (97 frames - 1) // (4 temporal downsampling) + 1 = 25</p></li> <li><p>step_template = [999, 995, 991, 986, 980, 975, 969, 963, 956, 948,
941, 932, 922, 912, 901, 888, 874, 859, 841, 822,
799, 773, 743, 708, 666, 615, 551, 470, 363, 216]</p> <p>The algorithm creates a 50x25 step_matrix where:</p></li> <li><p>Row 1:  [999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999]</p></li> <li><p>Row 2:  [995, 995, 995, 995, 995, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999]</p></li> <li><p>Row 3:  [991, 991, 991, 991, 991, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999]</p></li> <li><p>…</p></li> <li><p>Row 7:  [969, 969, 969, 969, 969, 995, 995, 995, 995, 995, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999]</p></li> <li><p>…</p></li> <li><p>Row 21: [799, 799, 799, 799, 799, 888, 888, 888, 888, 888, 941, 941, 941, 941, 941, 975, 975, 975, 975, 975, 999, 999, 999, 999, 999]</p></li> <li><p>…</p></li> <li><p>Row 35: [  0,   0,   0,   0,   0, 216, 216, 216, 216, 216, 666, 666, 666, 666, 666, 822, 822, 822, 822, 822, 901, 901, 901, 901, 901]</p></li> <li><p>…</p></li> <li><p>Row 42: [  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 551, 551, 551, 551, 551, 773, 773, 773, 773, 773]</p></li> <li><p>…</p></li> <li><p>Row 50: [  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 216, 216, 216, 216, 216]</p> <p>Detailed Row 6 Analysis:</p></li> <li><p>step_matrix[5]:       [ 975, 975, 975, 975, 975, 999, 999, 999, 999, 999, 999,  …,  999]</p></li> <li><p>step_index[5]:        [   6,   6,   6,   6,   6,   1,   1,   1,   1,   1,   0,  …,    0]</p></li> <li><p>step_update_mask[5]:  [True,True,True,True,True,True,True,True,True,True,False, …,False]</p></li> <li><p>valid_interval[5]:    (0, 25)</p> <p>Key Pattern: Block i lags behind Block i-1 by exactly ar_step=5 timesteps, creating the
staggered “diffusion forcing” effect where later blocks condition on cleaner earlier blocks.</p></li>`,Vt,Ge,Ut,Ce,Jo="The example below demonstrates how to generate a video from text.",It,ie,Zt,We,xt,Pe,vo="The example below demonstrates how to use the image-to-video pipeline to generate a video using a text description, a starting frame, and an ending frame.",Rt,le,St,Fe,Bt,re,Gt,De,Ct,Tn,Ne,bn,ko='SkyReels-V2 supports LoRAs with <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.SkyReelsV2LoraLoaderMixin.load_lora_weights">load_lora_weights()</a>.',ss,$e,wn,jo="Show example code",os,ze,Wt,Ee,Pt,U,Xe,as,Jn,Vo="Pipeline for Text-to-Video (t2v) generation using SkyReels-V2 with diffusion forcing.",is,vn,Uo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a specific device, etc.).`,ls,A,Ae,rs,kn,Io="The call function to the pipeline for generation.",ps,pe,cs,ce,Qe,ds,jn,Zo="Encodes the prompt into text encoder hidden states.",ms,x,Ye,fs,Vn,xo=`This function implements the core diffusion forcing algorithm that creates a coordinated denoising schedule
across temporal frames. It supports both synchronous and asynchronous generation modes:`,us,Un,Ro="<strong>Synchronous Mode</strong> (ar_step=0, causal_block_size=1):",gs,In,So="<li>All frames are denoised simultaneously at each timestep</li> <li>Each frame follows the same denoising trajectory: [1000, 800, 600, …, 0]</li> <li>Simpler but may have less temporal consistency for long videos</li>",hs,Zn,Bo="<strong>Asynchronous Mode</strong> (ar_step&gt;0, causal_block_size&gt;1):",_s,xn,Go="<li>Frames are grouped into causal blocks and processed block/chunk-wise</li> <li>Each block is denoised in a staggered pattern creating a “denoising wave”</li> <li>Earlier blocks are more denoised, later blocks lag behind by ar_step timesteps</li> <li>Creates stronger temporal dependencies and better consistency</li>",Ft,Le,Dt,I,He,ys,Rn,Co="Pipeline for Image-to-Video (i2v) generation using SkyReels-V2 with diffusion forcing.",Ms,Sn,Wo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a specific device, etc.).`,Ts,Q,qe,bs,Bn,Po="The call function to the pipeline for generation.",ws,de,Js,me,Oe,vs,Gn,Fo="Encodes the prompt into text encoder hidden states.",ks,R,Ke,js,Cn,Do=`This function implements the core diffusion forcing algorithm that creates a coordinated denoising schedule
across temporal frames. It supports both synchronous and asynchronous generation modes:`,Vs,Wn,No="<strong>Synchronous Mode</strong> (ar_step=0, causal_block_size=1):",Us,Pn,$o="<li>All frames are denoised simultaneously at each timestep</li> <li>Each frame follows the same denoising trajectory: [1000, 800, 600, …, 0]</li> <li>Simpler but may have less temporal consistency for long videos</li>",Is,Fn,zo="<strong>Asynchronous Mode</strong> (ar_step&gt;0, causal_block_size&gt;1):",Zs,Dn,Eo="<li>Frames are grouped into causal blocks and processed block/chunk-wise</li> <li>Each block is denoised in a staggered pattern creating a “denoising wave”</li> <li>Earlier blocks are more denoised, later blocks lag behind by ar_step timesteps</li> <li>Creates stronger temporal dependencies and better consistency</li>",Nt,en,$t,Z,nn,xs,Nn,Xo="Pipeline for Video-to-Video (v2v) generation using SkyReels-V2 with diffusion forcing.",Rs,$n,Ao=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a specific device, etc.).`,Ss,Y,tn,Bs,zn,Qo="The call function to the pipeline for generation.",Gs,fe,Cs,ue,sn,Ws,En,Yo="Encodes the prompt into text encoder hidden states.",Ps,S,on,Fs,Xn,Lo=`This function implements the core diffusion forcing algorithm that creates a coordinated denoising schedule
across temporal frames. It supports both synchronous and asynchronous generation modes:`,Ds,An,Ho="<strong>Synchronous Mode</strong> (ar_step=0, causal_block_size=1):",Ns,Qn,qo="<li>All frames are denoised simultaneously at each timestep</li> <li>Each frame follows the same denoising trajectory: [1000, 800, 600, …, 0]</li> <li>Simpler but may have less temporal consistency for long videos</li>",$s,Yn,Oo="<strong>Asynchronous Mode</strong> (ar_step&gt;0, causal_block_size&gt;1):",zs,Ln,Ko="<li>Frames are grouped into causal blocks and processed block/chunk-wise</li> <li>Each block is denoised in a staggered pattern creating a “denoising wave”</li> <li>Earlier blocks are more denoised, later blocks lag behind by ar_step timesteps</li> <li>Creates stronger temporal dependencies and better consistency</li>",zt,an,Et,C,ln,Es,Hn,ea="Pipeline for Text-to-Video (t2v) generation using SkyReels-V2.",Xs,qn,na=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,As,L,rn,Qs,On,ta="The call function to the pipeline for generation.",Ys,ge,Ls,he,pn,Hs,Kn,sa="Encodes the prompt into text encoder hidden states.",Xt,cn,At,W,dn,qs,et,oa="Pipeline for Image-to-Video (i2v) generation using SkyReels-V2.",Os,nt,aa=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ks,H,mn,eo,tt,ia="The call function to the pipeline for generation.",no,_e,to,ye,fn,so,st,la="Encodes the prompt into text encoder hidden states.",Qt,un,Yt,ee,gn,oo,ot,ra="Output class for SkyReelsV2 pipelines.",Lt,hn,Ht,rt,qt;return X=new E({props:{title:"SkyReels-V2: Infinite-length Film Generative model",local:"skyreels-v2-infinite-length-film-generative-model",headingTag:"h1"}}),ae=new ga({props:{warning:!1,$$slots:{default:[_a]},$$scope:{ctx:v}}}),Je=new E({props:{title:"A Visual Demonstration",local:"a-visual-demonstration",headingTag:"h3"}}),Ge=new E({props:{title:"Text-to-Video Generation",local:"text-to-video-generation",headingTag:"h3"}}),ie=new ao({props:{id:"T2V usage",options:["T2V memory"],$$slots:{default:[Ma]},$$scope:{ctx:v}}}),We=new E({props:{title:"First-Last-Frame-to-Video Generation",local:"first-last-frame-to-video-generation",headingTag:"h3"}}),le=new ao({props:{id:"FLF2V usage",options:["usage"],$$slots:{default:[ba]},$$scope:{ctx:v}}}),Fe=new E({props:{title:"Video-to-Video Generation",local:"video-to-video-generation",headingTag:"h3"}}),re=new ao({props:{id:"V2V usage",options:["usage"],$$slots:{default:[Ja]},$$scope:{ctx:v}}}),De=new E({props:{title:"Notes",local:"notes",headingTag:"h2"}}),ze=new oe({props:{code:"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",highlighted:`<span class="hljs-comment"># pip install ftfy</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, SkyReelsV2DiffusionForcingPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

vae = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32
)
pipeline = SkyReelsV2DiffusionForcingPipeline.from_pretrained(
    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers&quot;</span>, vae=vae, torch_dtype=torch.bfloat16
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_lora_weights(<span class="hljs-string">&quot;benjamin-paine/steamboat-willie-1.3b&quot;</span>, adapter_name=<span class="hljs-string">&quot;steamboat-willie&quot;</span>)
pipeline.set_adapters(<span class="hljs-string">&quot;steamboat-willie&quot;</span>)

pipeline.enable_model_cpu_offload()

<span class="hljs-comment"># use &quot;steamboat willie style&quot; to trigger the LoRA</span>
prompt = <span class="hljs-string">&quot;&quot;&quot;
steamboat willie style, golden era animation, The camera rushes from far to near in a low-angle shot,
revealing a white ferret on a log. It plays, leaps into the water, and emerges, as the camera zooms in
for a close-up. Water splashes berry bushes nearby, while moss, snow, and leaves blanket the ground.
Birch trees and a light blue sky frame the scene, with ferns in the foreground. Side lighting casts dynamic
shadows and warm highlights. Medium composition, front view, low angle, with depth of field.
&quot;&quot;&quot;</span>

output = pipeline(
    prompt=prompt,
    num_frames=<span class="hljs-number">97</span>,
    guidance_scale=<span class="hljs-number">6.0</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),Ee=new E({props:{title:"SkyReelsV2DiffusionForcingPipeline",local:"diffusers.SkyReelsV2DiffusionForcingPipeline",headingTag:"h2"}}),Xe=new V({props:{name:"class diffusers.SkyReelsV2DiffusionForcingPipeline",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>UMT5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L129"}}),Ae=new V({props:{name:"__call__",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"overlap_history",val:": typing.Optional[int] = None"},{name:"addnoise_condition",val:": float = 0"},{name:"base_num_frames",val:": int = 97"},{name:"ar_step",val:": int = 0"},{name:"causal_block_size",val:": typing.Optional[int] = None"},{name:"fps",val:": int = 24"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. (<strong>6.0 for T2V</strong>, <strong>5.0 for I2V</strong>)`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.overlap_history",description:`<strong>overlap_history</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of frames to overlap for smooth transitions in long videos. If <code>None</code>, the pipeline assumes
short video generation mode, and no overlap is applied. 17 and 37 are recommended to set.`,name:"overlap_history"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.addnoise_condition",description:`<strong>addnoise_condition</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
This is used to help smooth the long video generation by adding some noise to the clean condition. Too
large noise can cause the inconsistency as well. 20 is a recommended value, and you may try larger
ones, but it is recommended to not exceed 50.`,name:"addnoise_condition"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.base_num_frames",description:`<strong>base_num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>97</code>) &#x2014;
97 or 121 | Base frame count (<strong>97 for 540P</strong>, <strong>121 for 720P</strong>)`,name:"base_num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.ar_step",description:`<strong>ar_step</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Controls asynchronous inference (0 for synchronous mode) You can set <code>ar_step=5</code> to enable asynchronous
inference. When asynchronous inference, <code>causal_block_size=5</code> is recommended while it is not supposed
to be set for synchronous generation. Asynchronous inference will take more steps to diffuse the whole
sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous
inference may improve the instruction following and visual consistent performance.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.causal_block_size",description:`<strong>causal_block_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of frames in each block/chunk. Recommended when using asynchronous inference (when ar_step &gt;
0)`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>24</code>) &#x2014;
Frame rate of the generated video`,name:"fps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),pe=new ct({props:{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.example",$$slots:{default:[va]},$$scope:{ctx:v}}}),Qe=new V({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L219"}}),Ye=new V({props:{name:"generate_timestep_matrix",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix",parameters:[{name:"num_latent_frames",val:": int"},{name:"step_template",val:": Tensor"},{name:"base_num_latent_frames",val:": int"},{name:"ar_step",val:": int = 5"},{name:"num_pre_ready",val:": int = 0"},{name:"causal_block_size",val:": int = 1"},{name:"shrink_interval_with_mask",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.num_latent_frames",description:"<strong>num_latent_frames</strong> (int) &#x2014; Total number of latent frames to generate",name:"num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.step_template",description:"<strong>step_template</strong> (torch.Tensor) &#x2014; Base timestep schedule (e.g., [1000, 800, 600, &#x2026;, 0])",name:"step_template"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.base_num_latent_frames",description:"<strong>base_num_latent_frames</strong> (int) &#x2014; Maximum frames the model can process in one forward pass",name:"base_num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.ar_step",description:`<strong>ar_step</strong> (int, optional) &#x2014; Autoregressive step size for temporal lag.
0 = synchronous, &gt;0 = asynchronous. Defaults to 5.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.num_pre_ready",description:`<strong>num_pre_ready</strong> (int, optional) &#x2014;
Number of frames already denoised (e.g., from prefix in a video2video task).
Defaults to 0.`,name:"num_pre_ready"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.causal_block_size",description:`<strong>causal_block_size</strong> (int, optional) &#x2014; Number of frames processed as a causal block.
Defaults to 1.`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.shrink_interval_with_mask",description:`<strong>shrink_interval_with_mask</strong> (bool, optional) &#x2014; Whether to optimize processing intervals.
Defaults to False.`,name:"shrink_interval_with_mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>step_matrix (torch.Tensor): Matrix of timesteps for each frame at each iteration Shape:
[num_iterations, num_latent_frames]</li>
<li>step_index (torch.Tensor): Index matrix for timestep lookup Shape: [num_iterations,
num_latent_frames]</li>
<li>step_update_mask (torch.Tensor): Boolean mask indicating which frames to update Shape:
[num_iterations, num_latent_frames]</li>
<li>valid_interval (list[tuple]): List of (start, end) intervals for each iteration</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple containing</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If ar_step is too small for the given configuration</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Le=new E({props:{title:"SkyReelsV2DiffusionForcingImageToVideoPipeline",local:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline",headingTag:"h2"}}),He=new V({props:{name:"class diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>UMT5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L134"}}),qe=new V({props:{name:"__call__",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"last_image",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"overlap_history",val:": typing.Optional[int] = None"},{name:"addnoise_condition",val:": float = 0"},{name:"base_num_frames",val:": int = 97"},{name:"ar_step",val:": int = 0"},{name:"causal_block_size",val:": typing.Optional[int] = None"},{name:"fps",val:": int = 24"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. (<strong>6.0 for T2V</strong>, <strong>5.0 for I2V</strong>)`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs (weighting). If not provided,
image embeddings are generated from the <code>image</code> input argument.`,name:"image_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.last_image",description:`<strong>last_image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs (weighting). If not provided,
image embeddings are generated from the <code>image</code> input argument.`,name:"last_image"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.overlap_history",description:`<strong>overlap_history</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of frames to overlap for smooth transitions in long videos. If <code>None</code>, the pipeline assumes
short video generation mode, and no overlap is applied. 17 and 37 are recommended to set.`,name:"overlap_history"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.addnoise_condition",description:`<strong>addnoise_condition</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
This is used to help smooth the long video generation by adding some noise to the clean condition. Too
large noise can cause the inconsistency as well. 20 is a recommended value, and you may try larger
ones, but it is recommended to not exceed 50.`,name:"addnoise_condition"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.base_num_frames",description:`<strong>base_num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>97</code>) &#x2014;
97 or 121 | Base frame count (<strong>97 for 540P</strong>, <strong>121 for 720P</strong>)`,name:"base_num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.ar_step",description:`<strong>ar_step</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Controls asynchronous inference (0 for synchronous mode) You can set <code>ar_step=5</code> to enable asynchronous
inference. When asynchronous inference, <code>causal_block_size=5</code> is recommended while it is not supposed
to be set for synchronous generation. Asynchronous inference will take more steps to diffuse the whole
sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous
inference may improve the instruction following and visual consistent performance.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.causal_block_size",description:`<strong>causal_block_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of frames in each block/chunk. Recommended when using asynchronous inference (when ar_step &gt;
0)`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>24</code>) &#x2014;
Frame rate of the generated video`,name:"fps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),de=new ct({props:{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.example",$$slots:{default:[ka]},$$scope:{ctx:v}}}),Oe=new V({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L224"}}),Ke=new V({props:{name:"generate_timestep_matrix",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix",parameters:[{name:"num_latent_frames",val:": int"},{name:"step_template",val:": Tensor"},{name:"base_num_latent_frames",val:": int"},{name:"ar_step",val:": int = 5"},{name:"num_pre_ready",val:": int = 0"},{name:"causal_block_size",val:": int = 1"},{name:"shrink_interval_with_mask",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.num_latent_frames",description:"<strong>num_latent_frames</strong> (int) &#x2014; Total number of latent frames to generate",name:"num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.step_template",description:"<strong>step_template</strong> (torch.Tensor) &#x2014; Base timestep schedule (e.g., [1000, 800, 600, &#x2026;, 0])",name:"step_template"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.base_num_latent_frames",description:"<strong>base_num_latent_frames</strong> (int) &#x2014; Maximum frames the model can process in one forward pass",name:"base_num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.ar_step",description:`<strong>ar_step</strong> (int, optional) &#x2014; Autoregressive step size for temporal lag.
0 = synchronous, &gt;0 = asynchronous. Defaults to 5.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.num_pre_ready",description:`<strong>num_pre_ready</strong> (int, optional) &#x2014;
Number of frames already denoised (e.g., from prefix in a video2video task).
Defaults to 0.`,name:"num_pre_ready"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.causal_block_size",description:`<strong>causal_block_size</strong> (int, optional) &#x2014; Number of frames processed as a causal block.
Defaults to 1.`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.shrink_interval_with_mask",description:`<strong>shrink_interval_with_mask</strong> (bool, optional) &#x2014; Whether to optimize processing intervals.
Defaults to False.`,name:"shrink_interval_with_mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>step_matrix (torch.Tensor): Matrix of timesteps for each frame at each iteration Shape:
[num_iterations, num_latent_frames]</li>
<li>step_index (torch.Tensor): Index matrix for timestep lookup Shape: [num_iterations,
num_latent_frames]</li>
<li>step_update_mask (torch.Tensor): Boolean mask indicating which frames to update Shape:
[num_iterations, num_latent_frames]</li>
<li>valid_interval (list[tuple]): List of (start, end) intervals for each iteration</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple containing</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If ar_step is too small for the given configuration</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),en=new E({props:{title:"SkyReelsV2DiffusionForcingVideoToVideoPipeline",local:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline",headingTag:"h2"}}),nn=new V({props:{name:"class diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>UMT5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L190"}}),tn=new V({props:{name:"__call__",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": typing.List[PIL.Image.Image]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 120"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"overlap_history",val:": typing.Optional[int] = None"},{name:"addnoise_condition",val:": float = 0"},{name:"base_num_frames",val:": int = 97"},{name:"ar_step",val:": int = 0"},{name:"causal_block_size",val:": typing.Optional[int] = None"},{name:"fps",val:": int = 24"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[Image.Image]</code>) &#x2014;
The video to guide the video generation.`,name:"video"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the video generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the video generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>120</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. (<strong>6.0 for T2V</strong>, <strong>5.0 for I2V</strong>)`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.overlap_history",description:`<strong>overlap_history</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of frames to overlap for smooth transitions in long videos. If <code>None</code>, the pipeline assumes
short video generation mode, and no overlap is applied. 17 and 37 are recommended to set.`,name:"overlap_history"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.addnoise_condition",description:`<strong>addnoise_condition</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
This is used to help smooth the long video generation by adding some noise to the clean condition. Too
large noise can cause the inconsistency as well. 20 is a recommended value, and you may try larger
ones, but it is recommended to not exceed 50.`,name:"addnoise_condition"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.base_num_frames",description:`<strong>base_num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>97</code>) &#x2014;
97 or 121 | Base frame count (<strong>97 for 540P</strong>, <strong>121 for 720P</strong>)`,name:"base_num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.ar_step",description:`<strong>ar_step</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Controls asynchronous inference (0 for synchronous mode) You can set <code>ar_step=5</code> to enable asynchronous
inference. When asynchronous inference, <code>causal_block_size=5</code> is recommended while it is not supposed
to be set for synchronous generation. Asynchronous inference will take more steps to diffuse the whole
sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous
inference may improve the instruction following and visual consistent performance.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.causal_block_size",description:`<strong>causal_block_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of frames in each block/chunk. Recommended when using asynchronous inference (when ar_step &gt;
0)`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>24</code>) &#x2014;
Frame rate of the generated video`,name:"fps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),fe=new ct({props:{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.example",$$slots:{default:[ja]},$$scope:{ctx:v}}}),sn=new V({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L280"}}),on=new V({props:{name:"generate_timestep_matrix",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix",parameters:[{name:"num_latent_frames",val:": int"},{name:"step_template",val:": Tensor"},{name:"base_num_latent_frames",val:": int"},{name:"ar_step",val:": int = 5"},{name:"num_pre_ready",val:": int = 0"},{name:"causal_block_size",val:": int = 1"},{name:"shrink_interval_with_mask",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.num_latent_frames",description:"<strong>num_latent_frames</strong> (int) &#x2014; Total number of latent frames to generate",name:"num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.step_template",description:"<strong>step_template</strong> (torch.Tensor) &#x2014; Base timestep schedule (e.g., [1000, 800, 600, &#x2026;, 0])",name:"step_template"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.base_num_latent_frames",description:"<strong>base_num_latent_frames</strong> (int) &#x2014; Maximum frames the model can process in one forward pass",name:"base_num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.ar_step",description:`<strong>ar_step</strong> (int, optional) &#x2014; Autoregressive step size for temporal lag.
0 = synchronous, &gt;0 = asynchronous. Defaults to 5.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.num_pre_ready",description:`<strong>num_pre_ready</strong> (int, optional) &#x2014;
Number of frames already denoised (e.g., from prefix in a video2video task).
Defaults to 0.`,name:"num_pre_ready"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.causal_block_size",description:`<strong>causal_block_size</strong> (int, optional) &#x2014; Number of frames processed as a causal block.
Defaults to 1.`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.shrink_interval_with_mask",description:`<strong>shrink_interval_with_mask</strong> (bool, optional) &#x2014; Whether to optimize processing intervals.
Defaults to False.`,name:"shrink_interval_with_mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>step_matrix (torch.Tensor): Matrix of timesteps for each frame at each iteration Shape:
[num_iterations, num_latent_frames]</li>
<li>step_index (torch.Tensor): Index matrix for timestep lookup Shape: [num_iterations,
num_latent_frames]</li>
<li>step_update_mask (torch.Tensor): Boolean mask indicating which frames to update Shape:
[num_iterations, num_latent_frames]</li>
<li>valid_interval (list[tuple]): List of (start, end) intervals for each iteration</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple containing</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If ar_step is too small for the given configuration</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),an=new E({props:{title:"SkyReelsV2Pipeline",local:"diffusers.SkyReelsV2Pipeline",headingTag:"h2"}}),ln=new V({props:{name:"class diffusers.SkyReelsV2Pipeline",anchor:"diffusers.SkyReelsV2Pipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2.py#L107"}}),rn=new V({props:{name:"__call__",anchor:"diffusers.SkyReelsV2Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length for the text encoder.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2.py#L377",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),ge=new ct({props:{anchor:"diffusers.SkyReelsV2Pipeline.__call__.example",$$slots:{default:[Va]},$$scope:{ctx:v}}}),pn=new V({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2.py#L197"}}),cn=new E({props:{title:"SkyReelsV2ImageToVideoPipeline",local:"diffusers.SkyReelsV2ImageToVideoPipeline",headingTag:"h2"}}),dn=new V({props:{name:"class diffusers.SkyReelsV2ImageToVideoPipeline",anchor:"diffusers.SkyReelsV2ImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_processor",val:": CLIPProcessor"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://github.com/mlfoundations/open_clip/blob/main/docs/PRETRAINED.md#vit-h14-xlm-roberta-large" rel="nofollow">clip-vit-huge-patch14</a>
variant.`,name:"image_encoder"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_i2v.py#L127"}}),mn=new V({props:{name:"__call__",anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"last_image",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs (weighting). If not provided,
image embeddings are generated from the <code>image</code> input argument.`,name:"image_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_i2v.py#L478",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new ct({props:{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.example",$$slots:{default:[Ua]},$$scope:{ctx:v}}}),fn=new V({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_i2v.py#L238"}}),un=new E({props:{title:"SkyReelsV2PipelineOutput",local:"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput",headingTag:"h2"}}),gn=new V({props:{name:"class diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput",anchor:"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_output.py#L8"}}),hn=new ha({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/skyreels_v2.md"}}),{c(){i=p("meta"),b=o(),r=p("p"),m=o(),T=p("div"),T.innerHTML=l,w=o(),u(X.$$.fragment),K=o(),B=p("p"),B.innerHTML=Me,J=o(),G=p("p"),G.innerHTML=lo,dt=o(),Te=p("p"),Te.innerHTML=ro,mt=o(),be=p("p"),be.textContent=po,ft=o(),we=p("ul"),we.innerHTML=co,ut=o(),u(ae.$$.fragment),gt=o(),u(Je.$$.fragment),ht=o(),ve=p("p"),ve.textContent=mo,_t=o(),ke=p("p"),ke.textContent=fo,yt=o(),je=p("p"),je.textContent=uo,Mt=o(),Ve=p("p"),Ve.textContent=go,Tt=o(),Ue=p("p"),Ue.textContent=ho,bt=o(),Ie=p("p"),Ie.textContent=_o,wt=o(),Ze=p("p"),Ze.textContent=yo,Jt=o(),xe=p("ol"),xe.innerHTML=Mo,vt=o(),Re=p("p"),Re.textContent=To,kt=o(),Se=p("p"),Se.textContent=bo,jt=o(),Be=p("ul"),Be.innerHTML=wo,Vt=o(),u(Ge.$$.fragment),Ut=o(),Ce=p("p"),Ce.textContent=Jo,It=o(),u(ie.$$.fragment),Zt=o(),u(We.$$.fragment),xt=o(),Pe=p("p"),Pe.textContent=vo,Rt=o(),u(le.$$.fragment),St=o(),u(Fe.$$.fragment),Bt=o(),u(re.$$.fragment),Gt=o(),u(De.$$.fragment),Ct=o(),Tn=p("ul"),Ne=p("li"),bn=p("p"),bn.innerHTML=ko,ss=o(),$e=p("details"),wn=p("summary"),wn.textContent=jo,os=o(),u(ze.$$.fragment),Wt=o(),u(Ee.$$.fragment),Pt=o(),U=p("div"),u(Xe.$$.fragment),as=o(),Jn=p("p"),Jn.textContent=Vo,is=o(),vn=p("p"),vn.innerHTML=Uo,ls=o(),A=p("div"),u(Ae.$$.fragment),rs=o(),kn=p("p"),kn.textContent=Io,ps=o(),u(pe.$$.fragment),cs=o(),ce=p("div"),u(Qe.$$.fragment),ds=o(),jn=p("p"),jn.textContent=Zo,ms=o(),x=p("div"),u(Ye.$$.fragment),fs=o(),Vn=p("p"),Vn.textContent=xo,us=o(),Un=p("p"),Un.innerHTML=Ro,gs=o(),In=p("ul"),In.innerHTML=So,hs=o(),Zn=p("p"),Zn.innerHTML=Bo,_s=o(),xn=p("ul"),xn.innerHTML=Go,Ft=o(),u(Le.$$.fragment),Dt=o(),I=p("div"),u(He.$$.fragment),ys=o(),Rn=p("p"),Rn.textContent=Co,Ms=o(),Sn=p("p"),Sn.innerHTML=Wo,Ts=o(),Q=p("div"),u(qe.$$.fragment),bs=o(),Bn=p("p"),Bn.textContent=Po,ws=o(),u(de.$$.fragment),Js=o(),me=p("div"),u(Oe.$$.fragment),vs=o(),Gn=p("p"),Gn.textContent=Fo,ks=o(),R=p("div"),u(Ke.$$.fragment),js=o(),Cn=p("p"),Cn.textContent=Do,Vs=o(),Wn=p("p"),Wn.innerHTML=No,Us=o(),Pn=p("ul"),Pn.innerHTML=$o,Is=o(),Fn=p("p"),Fn.innerHTML=zo,Zs=o(),Dn=p("ul"),Dn.innerHTML=Eo,Nt=o(),u(en.$$.fragment),$t=o(),Z=p("div"),u(nn.$$.fragment),xs=o(),Nn=p("p"),Nn.textContent=Xo,Rs=o(),$n=p("p"),$n.innerHTML=Ao,Ss=o(),Y=p("div"),u(tn.$$.fragment),Bs=o(),zn=p("p"),zn.textContent=Qo,Gs=o(),u(fe.$$.fragment),Cs=o(),ue=p("div"),u(sn.$$.fragment),Ws=o(),En=p("p"),En.textContent=Yo,Ps=o(),S=p("div"),u(on.$$.fragment),Fs=o(),Xn=p("p"),Xn.textContent=Lo,Ds=o(),An=p("p"),An.innerHTML=Ho,Ns=o(),Qn=p("ul"),Qn.innerHTML=qo,$s=o(),Yn=p("p"),Yn.innerHTML=Oo,zs=o(),Ln=p("ul"),Ln.innerHTML=Ko,zt=o(),u(an.$$.fragment),Et=o(),C=p("div"),u(ln.$$.fragment),Es=o(),Hn=p("p"),Hn.textContent=ea,Xs=o(),qn=p("p"),qn.innerHTML=na,As=o(),L=p("div"),u(rn.$$.fragment),Qs=o(),On=p("p"),On.textContent=ta,Ys=o(),u(ge.$$.fragment),Ls=o(),he=p("div"),u(pn.$$.fragment),Hs=o(),Kn=p("p"),Kn.textContent=sa,Xt=o(),u(cn.$$.fragment),At=o(),W=p("div"),u(dn.$$.fragment),qs=o(),et=p("p"),et.textContent=oa,Os=o(),nt=p("p"),nt.innerHTML=aa,Ks=o(),H=p("div"),u(mn.$$.fragment),eo=o(),tt=p("p"),tt.textContent=ia,no=o(),u(_e.$$.fragment),to=o(),ye=p("div"),u(fn.$$.fragment),so=o(),st=p("p"),st.textContent=la,Qt=o(),u(un.$$.fragment),Yt=o(),ee=p("div"),u(gn.$$.fragment),oo=o(),ot=p("p"),ot.textContent=ra,Lt=o(),u(hn.$$.fragment),Ht=o(),rt=p("p"),this.h()},l(e){const t=fa("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(n),b=a(e),r=c(e,"P",{}),k(r).forEach(n),m=a(e),T=c(e,"DIV",{style:!0,"data-svelte-h":!0}),f(T)!=="svelte-p206qu"&&(T.innerHTML=l),w=a(e),g(X.$$.fragment,e),K=a(e),B=c(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-15955kf"&&(B.innerHTML=Me),J=a(e),G=c(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1c5qzxt"&&(G.innerHTML=lo),dt=a(e),Te=c(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-13rq768"&&(Te.innerHTML=ro),mt=a(e),be=c(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-1sx0tsf"&&(be.textContent=po),ft=a(e),we=c(e,"UL",{"data-svelte-h":!0}),f(we)!=="svelte-1pl0ztn"&&(we.innerHTML=co),ut=a(e),g(ae.$$.fragment,e),gt=a(e),g(Je.$$.fragment,e),ht=a(e),ve=c(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-jpsgp5"&&(ve.textContent=mo),_t=a(e),ke=c(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-uzi6i5"&&(ke.textContent=fo),yt=a(e),je=c(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-fws8u4"&&(je.textContent=uo),Mt=a(e),Ve=c(e,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1ub9gy1"&&(Ve.textContent=go),Tt=a(e),Ue=c(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-16la5bx"&&(Ue.textContent=ho),bt=a(e),Ie=c(e,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1iuzegn"&&(Ie.textContent=_o),wt=a(e),Ze=c(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-1mystxl"&&(Ze.textContent=yo),Jt=a(e),xe=c(e,"OL",{"data-svelte-h":!0}),f(xe)!=="svelte-c2stox"&&(xe.innerHTML=Mo),vt=a(e),Re=c(e,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-dg4xd7"&&(Re.textContent=To),kt=a(e),Se=c(e,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-1izfn1u"&&(Se.textContent=bo),jt=a(e),Be=c(e,"UL",{"data-svelte-h":!0}),f(Be)!=="svelte-edhik3"&&(Be.innerHTML=wo),Vt=a(e),g(Ge.$$.fragment,e),Ut=a(e),Ce=c(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-1r97o0s"&&(Ce.textContent=Jo),It=a(e),g(ie.$$.fragment,e),Zt=a(e),g(We.$$.fragment,e),xt=a(e),Pe=c(e,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1jq7n9p"&&(Pe.textContent=vo),Rt=a(e),g(le.$$.fragment,e),St=a(e),g(Fe.$$.fragment,e),Bt=a(e),g(re.$$.fragment,e),Gt=a(e),g(De.$$.fragment,e),Ct=a(e),Tn=c(e,"UL",{});var pt=k(Tn);Ne=c(pt,"LI",{});var _n=k(Ne);bn=c(_n,"P",{"data-svelte-h":!0}),f(bn)!=="svelte-15nvgf3"&&(bn.innerHTML=ko),ss=a(_n),$e=c(_n,"DETAILS",{});var yn=k($e);wn=c(yn,"SUMMARY",{"data-svelte-h":!0}),f(wn)!=="svelte-1m0l1gk"&&(wn.textContent=jo),os=a(yn),g(ze.$$.fragment,yn),yn.forEach(n),_n.forEach(n),pt.forEach(n),Wt=a(e),g(Ee.$$.fragment,e),Pt=a(e),U=c(e,"DIV",{class:!0});var P=k(U);g(Xe.$$.fragment,P),as=a(P),Jn=c(P,"P",{"data-svelte-h":!0}),f(Jn)!=="svelte-12nzcfd"&&(Jn.textContent=Vo),is=a(P),vn=c(P,"P",{"data-svelte-h":!0}),f(vn)!=="svelte-6i98ox"&&(vn.innerHTML=Uo),ls=a(P),A=c(P,"DIV",{class:!0});var ne=k(A);g(Ae.$$.fragment,ne),rs=a(ne),kn=c(ne,"P",{"data-svelte-h":!0}),f(kn)!=="svelte-50j04k"&&(kn.textContent=Io),ps=a(ne),g(pe.$$.fragment,ne),ne.forEach(n),cs=a(P),ce=c(P,"DIV",{class:!0});var Mn=k(ce);g(Qe.$$.fragment,Mn),ds=a(Mn),jn=c(Mn,"P",{"data-svelte-h":!0}),f(jn)!=="svelte-16q0ax1"&&(jn.textContent=Zo),Mn.forEach(n),ms=a(P),x=c(P,"DIV",{class:!0});var F=k(x);g(Ye.$$.fragment,F),fs=a(F),Vn=c(F,"P",{"data-svelte-h":!0}),f(Vn)!=="svelte-z0hkxd"&&(Vn.textContent=xo),us=a(F),Un=c(F,"P",{"data-svelte-h":!0}),f(Un)!=="svelte-786r5s"&&(Un.innerHTML=Ro),gs=a(F),In=c(F,"UL",{"data-svelte-h":!0}),f(In)!=="svelte-1vavexb"&&(In.innerHTML=So),hs=a(F),Zn=c(F,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-1is40lv"&&(Zn.innerHTML=Bo),_s=a(F),xn=c(F,"UL",{"data-svelte-h":!0}),f(xn)!=="svelte-12cwzsb"&&(xn.innerHTML=Go),F.forEach(n),P.forEach(n),Ft=a(e),g(Le.$$.fragment,e),Dt=a(e),I=c(e,"DIV",{class:!0});var D=k(I);g(He.$$.fragment,D),ys=a(D),Rn=c(D,"P",{"data-svelte-h":!0}),f(Rn)!=="svelte-1db0cne"&&(Rn.textContent=Co),Ms=a(D),Sn=c(D,"P",{"data-svelte-h":!0}),f(Sn)!=="svelte-6i98ox"&&(Sn.innerHTML=Wo),Ts=a(D),Q=c(D,"DIV",{class:!0});var te=k(Q);g(qe.$$.fragment,te),bs=a(te),Bn=c(te,"P",{"data-svelte-h":!0}),f(Bn)!=="svelte-50j04k"&&(Bn.textContent=Po),ws=a(te),g(de.$$.fragment,te),te.forEach(n),Js=a(D),me=c(D,"DIV",{class:!0});var Ot=k(me);g(Oe.$$.fragment,Ot),vs=a(Ot),Gn=c(Ot,"P",{"data-svelte-h":!0}),f(Gn)!=="svelte-16q0ax1"&&(Gn.textContent=Fo),Ot.forEach(n),ks=a(D),R=c(D,"DIV",{class:!0});var N=k(R);g(Ke.$$.fragment,N),js=a(N),Cn=c(N,"P",{"data-svelte-h":!0}),f(Cn)!=="svelte-z0hkxd"&&(Cn.textContent=Do),Vs=a(N),Wn=c(N,"P",{"data-svelte-h":!0}),f(Wn)!=="svelte-786r5s"&&(Wn.innerHTML=No),Us=a(N),Pn=c(N,"UL",{"data-svelte-h":!0}),f(Pn)!=="svelte-1vavexb"&&(Pn.innerHTML=$o),Is=a(N),Fn=c(N,"P",{"data-svelte-h":!0}),f(Fn)!=="svelte-1is40lv"&&(Fn.innerHTML=zo),Zs=a(N),Dn=c(N,"UL",{"data-svelte-h":!0}),f(Dn)!=="svelte-12cwzsb"&&(Dn.innerHTML=Eo),N.forEach(n),D.forEach(n),Nt=a(e),g(en.$$.fragment,e),$t=a(e),Z=c(e,"DIV",{class:!0});var $=k(Z);g(nn.$$.fragment,$),xs=a($),Nn=c($,"P",{"data-svelte-h":!0}),f(Nn)!=="svelte-dtd97b"&&(Nn.textContent=Xo),Rs=a($),$n=c($,"P",{"data-svelte-h":!0}),f($n)!=="svelte-6i98ox"&&($n.innerHTML=Ao),Ss=a($),Y=c($,"DIV",{class:!0});var at=k(Y);g(tn.$$.fragment,at),Bs=a(at),zn=c(at,"P",{"data-svelte-h":!0}),f(zn)!=="svelte-50j04k"&&(zn.textContent=Qo),Gs=a(at),g(fe.$$.fragment,at),at.forEach(n),Cs=a($),ue=c($,"DIV",{class:!0});var Kt=k(ue);g(sn.$$.fragment,Kt),Ws=a(Kt),En=c(Kt,"P",{"data-svelte-h":!0}),f(En)!=="svelte-16q0ax1"&&(En.textContent=Yo),Kt.forEach(n),Ps=a($),S=c($,"DIV",{class:!0});var z=k(S);g(on.$$.fragment,z),Fs=a(z),Xn=c(z,"P",{"data-svelte-h":!0}),f(Xn)!=="svelte-z0hkxd"&&(Xn.textContent=Lo),Ds=a(z),An=c(z,"P",{"data-svelte-h":!0}),f(An)!=="svelte-786r5s"&&(An.innerHTML=Ho),Ns=a(z),Qn=c(z,"UL",{"data-svelte-h":!0}),f(Qn)!=="svelte-1vavexb"&&(Qn.innerHTML=qo),$s=a(z),Yn=c(z,"P",{"data-svelte-h":!0}),f(Yn)!=="svelte-1is40lv"&&(Yn.innerHTML=Oo),zs=a(z),Ln=c(z,"UL",{"data-svelte-h":!0}),f(Ln)!=="svelte-12cwzsb"&&(Ln.innerHTML=Ko),z.forEach(n),$.forEach(n),zt=a(e),g(an.$$.fragment,e),Et=a(e),C=c(e,"DIV",{class:!0});var q=k(C);g(ln.$$.fragment,q),Es=a(q),Hn=c(q,"P",{"data-svelte-h":!0}),f(Hn)!=="svelte-ucmptk"&&(Hn.textContent=ea),Xs=a(q),qn=c(q,"P",{"data-svelte-h":!0}),f(qn)!=="svelte-496sm0"&&(qn.innerHTML=na),As=a(q),L=c(q,"DIV",{class:!0});var it=k(L);g(rn.$$.fragment,it),Qs=a(it),On=c(it,"P",{"data-svelte-h":!0}),f(On)!=="svelte-50j04k"&&(On.textContent=ta),Ys=a(it),g(ge.$$.fragment,it),it.forEach(n),Ls=a(q),he=c(q,"DIV",{class:!0});var es=k(he);g(pn.$$.fragment,es),Hs=a(es),Kn=c(es,"P",{"data-svelte-h":!0}),f(Kn)!=="svelte-16q0ax1"&&(Kn.textContent=sa),es.forEach(n),q.forEach(n),Xt=a(e),g(cn.$$.fragment,e),At=a(e),W=c(e,"DIV",{class:!0});var O=k(W);g(dn.$$.fragment,O),qs=a(O),et=c(O,"P",{"data-svelte-h":!0}),f(et)!=="svelte-1kjb4l1"&&(et.textContent=oa),Os=a(O),nt=c(O,"P",{"data-svelte-h":!0}),f(nt)!=="svelte-496sm0"&&(nt.innerHTML=aa),Ks=a(O),H=c(O,"DIV",{class:!0});var lt=k(H);g(mn.$$.fragment,lt),eo=a(lt),tt=c(lt,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-50j04k"&&(tt.textContent=ia),no=a(lt),g(_e.$$.fragment,lt),lt.forEach(n),to=a(O),ye=c(O,"DIV",{class:!0});var ns=k(ye);g(fn.$$.fragment,ns),so=a(ns),st=c(ns,"P",{"data-svelte-h":!0}),f(st)!=="svelte-16q0ax1"&&(st.textContent=la),ns.forEach(n),O.forEach(n),Qt=a(e),g(un.$$.fragment,e),Yt=a(e),ee=c(e,"DIV",{class:!0});var ts=k(ee);g(gn.$$.fragment,ts),oo=a(ts),ot=c(ts,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1gu515t"&&(ot.textContent=ra),ts.forEach(n),Lt=a(e),g(hn.$$.fragment,e),Ht=a(e),rt=c(e,"P",{}),k(rt).forEach(n),this.h()},h(){j(i,"name","hf:doc:metadata"),j(i,"content",Za),ua(T,"float","right"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,i),d(e,b,t),d(e,r,t),d(e,m,t),d(e,T,t),d(e,w,t),h(X,e,t),d(e,K,t),d(e,B,t),d(e,J,t),d(e,G,t),d(e,dt,t),d(e,Te,t),d(e,mt,t),d(e,be,t),d(e,ft,t),d(e,we,t),d(e,ut,t),h(ae,e,t),d(e,gt,t),h(Je,e,t),d(e,ht,t),d(e,ve,t),d(e,_t,t),d(e,ke,t),d(e,yt,t),d(e,je,t),d(e,Mt,t),d(e,Ve,t),d(e,Tt,t),d(e,Ue,t),d(e,bt,t),d(e,Ie,t),d(e,wt,t),d(e,Ze,t),d(e,Jt,t),d(e,xe,t),d(e,vt,t),d(e,Re,t),d(e,kt,t),d(e,Se,t),d(e,jt,t),d(e,Be,t),d(e,Vt,t),h(Ge,e,t),d(e,Ut,t),d(e,Ce,t),d(e,It,t),h(ie,e,t),d(e,Zt,t),h(We,e,t),d(e,xt,t),d(e,Pe,t),d(e,Rt,t),h(le,e,t),d(e,St,t),h(Fe,e,t),d(e,Bt,t),h(re,e,t),d(e,Gt,t),h(De,e,t),d(e,Ct,t),d(e,Tn,t),s(Tn,Ne),s(Ne,bn),s(Ne,ss),s(Ne,$e),s($e,wn),s($e,os),h(ze,$e,null),d(e,Wt,t),h(Ee,e,t),d(e,Pt,t),d(e,U,t),h(Xe,U,null),s(U,as),s(U,Jn),s(U,is),s(U,vn),s(U,ls),s(U,A),h(Ae,A,null),s(A,rs),s(A,kn),s(A,ps),h(pe,A,null),s(U,cs),s(U,ce),h(Qe,ce,null),s(ce,ds),s(ce,jn),s(U,ms),s(U,x),h(Ye,x,null),s(x,fs),s(x,Vn),s(x,us),s(x,Un),s(x,gs),s(x,In),s(x,hs),s(x,Zn),s(x,_s),s(x,xn),d(e,Ft,t),h(Le,e,t),d(e,Dt,t),d(e,I,t),h(He,I,null),s(I,ys),s(I,Rn),s(I,Ms),s(I,Sn),s(I,Ts),s(I,Q),h(qe,Q,null),s(Q,bs),s(Q,Bn),s(Q,ws),h(de,Q,null),s(I,Js),s(I,me),h(Oe,me,null),s(me,vs),s(me,Gn),s(I,ks),s(I,R),h(Ke,R,null),s(R,js),s(R,Cn),s(R,Vs),s(R,Wn),s(R,Us),s(R,Pn),s(R,Is),s(R,Fn),s(R,Zs),s(R,Dn),d(e,Nt,t),h(en,e,t),d(e,$t,t),d(e,Z,t),h(nn,Z,null),s(Z,xs),s(Z,Nn),s(Z,Rs),s(Z,$n),s(Z,Ss),s(Z,Y),h(tn,Y,null),s(Y,Bs),s(Y,zn),s(Y,Gs),h(fe,Y,null),s(Z,Cs),s(Z,ue),h(sn,ue,null),s(ue,Ws),s(ue,En),s(Z,Ps),s(Z,S),h(on,S,null),s(S,Fs),s(S,Xn),s(S,Ds),s(S,An),s(S,Ns),s(S,Qn),s(S,$s),s(S,Yn),s(S,zs),s(S,Ln),d(e,zt,t),h(an,e,t),d(e,Et,t),d(e,C,t),h(ln,C,null),s(C,Es),s(C,Hn),s(C,Xs),s(C,qn),s(C,As),s(C,L),h(rn,L,null),s(L,Qs),s(L,On),s(L,Ys),h(ge,L,null),s(C,Ls),s(C,he),h(pn,he,null),s(he,Hs),s(he,Kn),d(e,Xt,t),h(cn,e,t),d(e,At,t),d(e,W,t),h(dn,W,null),s(W,qs),s(W,et),s(W,Os),s(W,nt),s(W,Ks),s(W,H),h(mn,H,null),s(H,eo),s(H,tt),s(H,no),h(_e,H,null),s(W,to),s(W,ye),h(fn,ye,null),s(ye,so),s(ye,st),d(e,Qt,t),h(un,e,t),d(e,Yt,t),d(e,ee,t),h(gn,ee,null),s(ee,oo),s(ee,ot),d(e,Lt,t),h(hn,e,t),d(e,Ht,t),d(e,rt,t),qt=!0},p(e,[t]){const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),ae.$set(pt);const _n={};t&2&&(_n.$$scope={dirty:t,ctx:e}),ie.$set(_n);const yn={};t&2&&(yn.$$scope={dirty:t,ctx:e}),le.$set(yn);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),re.$set(P);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:e}),pe.$set(ne);const Mn={};t&2&&(Mn.$$scope={dirty:t,ctx:e}),de.$set(Mn);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),fe.$set(F);const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),ge.$set(D);const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),_e.$set(te)},i(e){qt||(_(X.$$.fragment,e),_(ae.$$.fragment,e),_(Je.$$.fragment,e),_(Ge.$$.fragment,e),_(ie.$$.fragment,e),_(We.$$.fragment,e),_(le.$$.fragment,e),_(Fe.$$.fragment,e),_(re.$$.fragment,e),_(De.$$.fragment,e),_(ze.$$.fragment,e),_(Ee.$$.fragment,e),_(Xe.$$.fragment,e),_(Ae.$$.fragment,e),_(pe.$$.fragment,e),_(Qe.$$.fragment,e),_(Ye.$$.fragment,e),_(Le.$$.fragment,e),_(He.$$.fragment,e),_(qe.$$.fragment,e),_(de.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(en.$$.fragment,e),_(nn.$$.fragment,e),_(tn.$$.fragment,e),_(fe.$$.fragment,e),_(sn.$$.fragment,e),_(on.$$.fragment,e),_(an.$$.fragment,e),_(ln.$$.fragment,e),_(rn.$$.fragment,e),_(ge.$$.fragment,e),_(pn.$$.fragment,e),_(cn.$$.fragment,e),_(dn.$$.fragment,e),_(mn.$$.fragment,e),_(_e.$$.fragment,e),_(fn.$$.fragment,e),_(un.$$.fragment,e),_(gn.$$.fragment,e),_(hn.$$.fragment,e),qt=!0)},o(e){y(X.$$.fragment,e),y(ae.$$.fragment,e),y(Je.$$.fragment,e),y(Ge.$$.fragment,e),y(ie.$$.fragment,e),y(We.$$.fragment,e),y(le.$$.fragment,e),y(Fe.$$.fragment,e),y(re.$$.fragment,e),y(De.$$.fragment,e),y(ze.$$.fragment,e),y(Ee.$$.fragment,e),y(Xe.$$.fragment,e),y(Ae.$$.fragment,e),y(pe.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(Le.$$.fragment,e),y(He.$$.fragment,e),y(qe.$$.fragment,e),y(de.$$.fragment,e),y(Oe.$$.fragment,e),y(Ke.$$.fragment,e),y(en.$$.fragment,e),y(nn.$$.fragment,e),y(tn.$$.fragment,e),y(fe.$$.fragment,e),y(sn.$$.fragment,e),y(on.$$.fragment,e),y(an.$$.fragment,e),y(ln.$$.fragment,e),y(rn.$$.fragment,e),y(ge.$$.fragment,e),y(pn.$$.fragment,e),y(cn.$$.fragment,e),y(dn.$$.fragment,e),y(mn.$$.fragment,e),y(_e.$$.fragment,e),y(fn.$$.fragment,e),y(un.$$.fragment,e),y(gn.$$.fragment,e),y(hn.$$.fragment,e),qt=!1},d(e){e&&(n(b),n(r),n(m),n(T),n(w),n(K),n(B),n(J),n(G),n(dt),n(Te),n(mt),n(be),n(ft),n(we),n(ut),n(gt),n(ht),n(ve),n(_t),n(ke),n(yt),n(je),n(Mt),n(Ve),n(Tt),n(Ue),n(bt),n(Ie),n(wt),n(Ze),n(Jt),n(xe),n(vt),n(Re),n(kt),n(Se),n(jt),n(Be),n(Vt),n(Ut),n(Ce),n(It),n(Zt),n(xt),n(Pe),n(Rt),n(St),n(Bt),n(Gt),n(Ct),n(Tn),n(Wt),n(Pt),n(U),n(Ft),n(Dt),n(I),n(Nt),n($t),n(Z),n(zt),n(Et),n(C),n(Xt),n(At),n(W),n(Qt),n(Yt),n(ee),n(Lt),n(Ht),n(rt)),n(i),M(X,e),M(ae,e),M(Je,e),M(Ge,e),M(ie,e),M(We,e),M(le,e),M(Fe,e),M(re,e),M(De,e),M(ze),M(Ee,e),M(Xe),M(Ae),M(pe),M(Qe),M(Ye),M(Le,e),M(He),M(qe),M(de),M(Oe),M(Ke),M(en,e),M(nn),M(tn),M(fe),M(sn),M(on),M(an,e),M(ln),M(rn),M(ge),M(pn),M(cn,e),M(dn),M(mn),M(_e),M(fn),M(un,e),M(gn),M(hn,e)}}}const Za='{"title":"SkyReels-V2: Infinite-length Film Generative model","local":"skyreels-v2-infinite-length-film-generative-model","sections":[{"title":"A Visual Demonstration","local":"a-visual-demonstration","sections":[],"depth":3},{"title":"Text-to-Video Generation","local":"text-to-video-generation","sections":[],"depth":3},{"title":"First-Last-Frame-to-Video Generation","local":"first-last-frame-to-video-generation","sections":[],"depth":3},{"title":"Video-to-Video Generation","local":"video-to-video-generation","sections":[],"depth":3},{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"SkyReelsV2DiffusionForcingPipeline","local":"diffusers.SkyReelsV2DiffusionForcingPipeline","sections":[],"depth":2},{"title":"SkyReelsV2DiffusionForcingImageToVideoPipeline","local":"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline","sections":[],"depth":2},{"title":"SkyReelsV2DiffusionForcingVideoToVideoPipeline","local":"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline","sections":[],"depth":2},{"title":"SkyReelsV2Pipeline","local":"diffusers.SkyReelsV2Pipeline","sections":[],"depth":2},{"title":"SkyReelsV2ImageToVideoPipeline","local":"diffusers.SkyReelsV2ImageToVideoPipeline","sections":[],"depth":2},{"title":"SkyReelsV2PipelineOutput","local":"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput","sections":[],"depth":2}],"depth":1}';function xa(v){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Da extends da{constructor(i){super(),ma(this,i,xa,Ia,pa,{})}}export{Da as component};
