import{s as Ee,o as Qe,n as re}from"../chunks/scheduler.8c3d61f6.js";import{S as Ne,i as Se,g as U,s as o,r as f,A as He,h as T,f as t,c as r,j as Fe,u as g,x as $,k as pe,y as ze,a,v as b,d as h,t as J,w}from"../chunks/index.da70eac4.js";import{T as $e}from"../chunks/Tip.1d9b8c37.js";import{C as k}from"../chunks/CodeBlock.a9c4becf.js";import{H as ie,E as Pe}from"../chunks/getInferenceSnippets.a8672208.js";import{H as Le,a as _e}from"../chunks/HfOption.6ab18950.js";function qe(x){let s,u='🤗 Diffusers currently only supports using PAG with selected SDXL pipelines and <a href="/docs/diffusers/main/en/api/pipelines/pag#diffusers.PixArtSigmaPAGPipeline">PixArtSigmaPAGPipeline</a>. But feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you want to add PAG support to a new pipeline!';return{c(){s=U("p"),s.innerHTML=u},l(p){s=T(p,"P",{"data-svelte-h":!0}),$(s)!=="svelte-1umrgn6"&&(s.innerHTML=u)},m(p,y){a(p,s,y)},p:re,d(p){p&&t(s)}}}function De(x){let s,u='The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. Additionally, you can use <code>set_pag_applied_layers</code> method to update these layers after the pipeline has been created. Check out the <a href="#pag_applied_layers">pag_applied_layers</a> section to learn more about applying PAG to other layers.';return{c(){s=U("p"),s.innerHTML=u},l(p){s=T(p,"P",{"data-svelte-h":!0}),$(s)!=="svelte-h3gpzi"&&(s.innerHTML=u)},m(p,y){a(p,s,y)},p:re,d(p){p&&t(s)}}}function Ke(x){let s,u,p,y,d,Z='If you already have a pipeline created and loaded, you can enable PAG on it using the <code>from_pipe</code> API with the <code>enable_pag</code> flag. Internally, a PAG pipeline is created based on the pipeline and task you specified. In the example below, since we used <code>AutoPipelineForText2Image</code> and passed a <code>StableDiffusionXLPipeline</code>, a <code>StableDiffusionXLPAGPipeline</code> is created accordingly. Note that this does not require additional memory, and you will have both <code>StableDiffusionXLPipeline</code> and  <code>StableDiffusionXLPAGPipeline</code> loaded and ready to use. You can read more about the <code>from_pipe</code> API and how to reuse pipelines in diffuser <a href="https://huggingface.co/docs/diffusers/using-diffusers/loading#reuse-a-pipeline" rel="nofollow">here</a>.',c,M,C,j,I="To generate an image, you will also need to pass a <code>pag_scale</code>. When <code>pag_scale</code> increases, images gain more semantically coherent structures and exhibit fewer artifacts. However overly large guidance scale can lead to smoother textures and slight saturation in the images, similarly to CFG. <code>pag_scale=3.0</code> is used in the official demo and works well in most of the use cases, but feel free to experiment and select the appropriate value according to your needs! PAG is disabled when <code>pag_scale=0</code>.",v,G,X,_,B='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',V;return s=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBhZ19hcHBsaWVkX2xheWVycyUzRCU1QiUyMm1pZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),p=new $e({props:{warning:!1,$$slots:{default:[De]},$$scope:{ctx:x}}}),M=new k({props:{code:"cGlwZWxpbmVfc2R4bCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3NkeGwlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForText2Image.from_pipe(pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),G=new k({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQSUwQWZvciUyMHBhZ19zY2FsZSUyMGluJTIwJTVCMC4wJTJDJTIwMy4wJTVEJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2Vz",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
    images = pipeline(
        prompt=prompt,
        num_inference_steps=<span class="hljs-number">25</span>,
        guidance_scale=<span class="hljs-number">7.0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images`,wrap:!1}}),{c(){f(s.$$.fragment),u=o(),f(p.$$.fragment),y=o(),d=U("p"),d.innerHTML=Z,c=o(),f(M.$$.fragment),C=o(),j=U("p"),j.innerHTML=I,v=o(),f(G.$$.fragment),X=o(),_=U("div"),_.innerHTML=B,this.h()},l(l){g(s.$$.fragment,l),u=r(l),g(p.$$.fragment,l),y=r(l),d=T(l,"P",{"data-svelte-h":!0}),$(d)!=="svelte-ggenwh"&&(d.innerHTML=Z),c=r(l),g(M.$$.fragment,l),C=r(l),j=T(l,"P",{"data-svelte-h":!0}),$(j)!=="svelte-43v4ib"&&(j.innerHTML=I),v=r(l),g(G.$$.fragment,l),X=r(l),_=T(l,"DIV",{class:!0,"data-svelte-h":!0}),$(_)!=="svelte-1ebso2i"&&(_.innerHTML=B),this.h()},h(){pe(_,"class","flex flex-row gap-4")},m(l,m){b(s,l,m),a(l,u,m),b(p,l,m),a(l,y,m),a(l,d,m),a(l,c,m),b(M,l,m),a(l,C,m),a(l,j,m),a(l,v,m),b(G,l,m),a(l,X,m),a(l,_,m),V=!0},p(l,m){const Y={};m&2&&(Y.$$scope={dirty:m,ctx:l}),p.$set(Y)},i(l){V||(h(s.$$.fragment,l),h(p.$$.fragment,l),h(M.$$.fragment,l),h(G.$$.fragment,l),V=!0)},o(l){J(s.$$.fragment,l),J(p.$$.fragment,l),J(M.$$.fragment,l),J(G.$$.fragment,l),V=!1},d(l){l&&(t(u),t(y),t(d),t(c),t(C),t(j),t(v),t(X),t(_)),w(s,l),w(p,l),w(M,l),w(G,l)}}}function Oe(x){let s,u="You can use PAG with image-to-image pipelines.",p,y,d,Z,c="If you already have a image-to-image pipeline and would like enable PAG on it, you can run this",M,C,j,I,v="It is also very easy to directly switch from a text-to-image pipeline to PAG enabled image-to-image pipeline",G,X,_,B,V="If you have a PAG enabled text-to-image pipeline, you can directly switch to a image-to-image pipeline with PAG still enabled",l,m,Y,A,F="Now let’s generate an image!",E,R,z;return y=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTVCJTIybWlkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),C=new k({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new k({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3QyaSUyQyUyMGVuYWJsZV9wYWclM0RUcnVlKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),m=new k({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdDJpKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, enable_pag=<span class="hljs-literal">True</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i)`,wrap:!1}}),R=new k({props:{code:"cGFnX3NjYWxlcyUyMCUzRCUyMCUyMDQuMCUwQWd1aWRhbmNlX3NjYWxlcyUyMCUzRCUyMDcuMCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBjYXRjaGluZyUyMGElMjBmcmlzYmVlJTIwaW4lMjB0aGUlMjBqdW5nbGUlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjglMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGd1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX3NjYWxlJTNEcGFnX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`pag_scales =  <span class="hljs-number">4.0</span>
guidance_scales = <span class="hljs-number">7.0</span>

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(
    prompt,
    image=init_image,
    strength=<span class="hljs-number">0.8</span>,
    guidance_scale=guidance_scale,
    pag_scale=pag_scale,
    generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=U("p"),s.textContent=u,p=o(),f(y.$$.fragment),d=o(),Z=U("p"),Z.textContent=c,M=o(),f(C.$$.fragment),j=o(),I=U("p"),I.textContent=v,G=o(),f(X.$$.fragment),_=o(),B=U("p"),B.textContent=V,l=o(),f(m.$$.fragment),Y=o(),A=U("p"),A.textContent=F,E=o(),f(R.$$.fragment)},l(i){s=T(i,"P",{"data-svelte-h":!0}),$(s)!=="svelte-1xi6cwa"&&(s.textContent=u),p=r(i),g(y.$$.fragment,i),d=r(i),Z=T(i,"P",{"data-svelte-h":!0}),$(Z)!=="svelte-d1pkk8"&&(Z.textContent=c),M=r(i),g(C.$$.fragment,i),j=r(i),I=T(i,"P",{"data-svelte-h":!0}),$(I)!=="svelte-11p19k6"&&(I.textContent=v),G=r(i),g(X.$$.fragment,i),_=r(i),B=T(i,"P",{"data-svelte-h":!0}),$(B)!=="svelte-nytx5w"&&(B.textContent=V),l=r(i),g(m.$$.fragment,i),Y=r(i),A=T(i,"P",{"data-svelte-h":!0}),$(A)!=="svelte-3irrs3"&&(A.textContent=F),E=r(i),g(R.$$.fragment,i)},m(i,W){a(i,s,W),a(i,p,W),b(y,i,W),a(i,d,W),a(i,Z,W),a(i,M,W),b(C,i,W),a(i,j,W),a(i,I,W),a(i,G,W),b(X,i,W),a(i,_,W),a(i,B,W),a(i,l,W),b(m,i,W),a(i,Y,W),a(i,A,W),a(i,E,W),b(R,i,W),z=!0},p:re,i(i){z||(h(y.$$.fragment,i),h(C.$$.fragment,i),h(X.$$.fragment,i),h(m.$$.fragment,i),h(R.$$.fragment,i),z=!0)},o(i){J(y.$$.fragment,i),J(C.$$.fragment,i),J(X.$$.fragment,i),J(m.$$.fragment,i),J(R.$$.fragment,i),z=!1},d(i){i&&(t(s),t(p),t(d),t(Z),t(M),t(j),t(I),t(G),t(_),t(B),t(l),t(Y),t(A),t(E)),w(y,i),w(C,i),w(X,i),w(m,i),w(R,i)}}}function el(x){let s,u,p,y="You can enable PAG on an existing inpainting pipeline like this",d,Z,c,M,C="This still works when your pipeline has a different task:",j,I,v,G,X="Let’s generate an image!",_,B,V;return s=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Z=new k({props:{code:"cGlwZWxpbmVfaW5wYWludCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9waXBlKHBpcGVsaW5lX2lucGFpbnQlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_inpaint = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpainting.from_pipe(pipeline_inpaint, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),I=new k({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWl0aW5nLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpaiting.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new k({props:{code:"aW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwdGlnZXIlMjBzaXR0aW5nJTIwb24lMjBhJTIwYmVuY2glMjIlMEElMEFwYWdfc2NhbGVzJTIwJTNEJTIwJTIwMy4wJTBBZ3VpZGFuY2Vfc2NhbGVzJTIwJTNEJTIwNy41JTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMSklMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>

pag_scales =  <span class="hljs-number">3.0</span>
guidance_scales = <span class="hljs-number">7.5</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
images = pipeline(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    strength=<span class="hljs-number">0.8</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){f(s.$$.fragment),u=o(),p=U("p"),p.textContent=y,d=o(),f(Z.$$.fragment),c=o(),M=U("p"),M.textContent=C,j=o(),f(I.$$.fragment),v=o(),G=U("p"),G.textContent=X,_=o(),f(B.$$.fragment)},l(l){g(s.$$.fragment,l),u=r(l),p=T(l,"P",{"data-svelte-h":!0}),$(p)!=="svelte-azr2az"&&(p.textContent=y),d=r(l),g(Z.$$.fragment,l),c=r(l),M=T(l,"P",{"data-svelte-h":!0}),$(M)!=="svelte-1e8wg3g"&&(M.textContent=C),j=r(l),g(I.$$.fragment,l),v=r(l),G=T(l,"P",{"data-svelte-h":!0}),$(G)!=="svelte-1yhhruz"&&(G.textContent=X),_=r(l),g(B.$$.fragment,l)},m(l,m){b(s,l,m),a(l,u,m),a(l,p,m),a(l,d,m),b(Z,l,m),a(l,c,m),a(l,M,m),a(l,j,m),b(I,l,m),a(l,v,m),a(l,G,m),a(l,_,m),b(B,l,m),V=!0},p:re,i(l){V||(h(s.$$.fragment,l),h(Z.$$.fragment,l),h(I.$$.fragment,l),h(B.$$.fragment,l),V=!0)},o(l){J(s.$$.fragment,l),J(Z.$$.fragment,l),J(I.$$.fragment,l),J(B.$$.fragment,l),V=!1},d(l){l&&(t(u),t(p),t(d),t(c),t(M),t(j),t(v),t(G),t(_)),w(s,l),w(Z,l),w(I,l),w(B,l)}}}function ll(x){let s,u,p,y,d,Z;return s=new _e({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[Ke]},$$scope:{ctx:x}}}),p=new _e({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[Oe]},$$scope:{ctx:x}}}),d=new _e({props:{id:"tasks",option:"Inpainting",$$slots:{default:[el]},$$scope:{ctx:x}}}),{c(){f(s.$$.fragment),u=o(),f(p.$$.fragment),y=o(),f(d.$$.fragment)},l(c){g(s.$$.fragment,c),u=r(c),g(p.$$.fragment,c),y=r(c),g(d.$$.fragment,c)},m(c,M){b(s,c,M),a(c,u,M),b(p,c,M),a(c,y,M),b(d,c,M),Z=!0},p(c,M){const C={};M&2&&(C.$$scope={dirty:M,ctx:c}),s.$set(C);const j={};M&2&&(j.$$scope={dirty:M,ctx:c}),p.$set(j);const I={};M&2&&(I.$$scope={dirty:M,ctx:c}),d.$set(I)},i(c){Z||(h(s.$$.fragment,c),h(p.$$.fragment,c),h(d.$$.fragment,c),Z=!0)},o(c){J(s.$$.fragment,c),J(p.$$.fragment,c),J(d.$$.fragment,c),Z=!1},d(c){c&&(t(u),t(y)),w(s,c),w(p,c),w(d,c)}}}function tl(x){let s,u="If you already have a controlnet pipeline and want to enable PAG, you can use the <code>from_pipe</code> API: <code>AutoPipelineForText2Image.from_pipe(pipeline_controlnet, enable_pag=True)</code>";return{c(){s=U("p"),s.innerHTML=u},l(p){s=T(p,"P",{"data-svelte-h":!0}),$(s)!=="svelte-2vpeo4"&&(s.innerHTML=u)},m(p,y){a(p,s,y)},p:re,d(p){p&&t(s)}}}function al(x){let s,u,p,y,d,Z,c,M='<a href="https://ku-cvlab.github.io/Perturbed-Attention-Guidance/" rel="nofollow">Perturbed-Attention Guidance (PAG)</a> is a new diffusion sampling guidance that improves sample quality across both unconditional and conditional settings, achieving this without requiring further training or the integration of external modules. PAG is designed to progressively enhance the structure of synthesized samples throughout the denoising process by considering the self-attention mechanisms’ ability to capture structural information. It involves generating intermediate samples with degraded structure by substituting selected self-attention maps in diffusion U-Net with an identity matrix, and guiding the denoising process away from these degraded samples.',C,j,I="This guide will show you how to use PAG for various tasks and use cases.",v,G,X,_,B='You can apply PAG to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks such as text-to-image, image-to-image, and inpainting. To enable PAG for a specific task, load the pipeline using the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> API with the <code>enable_pag=True</code> flag and the <code>pag_applied_layers</code> argument.',V,l,m,Y,A,F,E,R,z="To use PAG with ControlNet, first create a <code>controlnet</code>. Then, pass the <code>controlnet</code> and other PAG arguments to the <code>from_pretrained</code> method of the AutoPipeline for the specified task.",i,W,ce,Q,me,P,Ie="You can use the pipeline in the same way you normally use ControlNet pipelines, with the added option to specify a <code>pag_scale</code> parameter. Note that PAG works well for unconditional generation. In this example, we will generate an image without a prompt.",Me,L,de,N,Ce='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',ue,q,ye,D,Be='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is a popular model that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. You can enable PAG on a pipeline with IP-Adapter loaded.',fe,K,ge,O,Xe="PAG reduces artifacts and improves the overall compposition.",be,S,ve='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_5.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',he,ee,Je,le,we,te,Ve="The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. By default, it applies only to the mid blocks. Changing this setting will significantly impact the output. You can use the <code>set_pag_applied_layers</code> method to adjust the PAG layers after the pipeline is created, helping you find the optimal layers for your model.",Ue,ae,xe="As an example, here is the images generated with <code>pag_layers = [&quot;down.block_2&quot;]</code> and <code>pag_layers = [&quot;down.block_2&quot;, &quot;up.block_1.attentions_0&quot;]</code>",Te,se,Ze,H,Ye='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2_up1a0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2 + up.block1.attentions_0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2</figcaption></div>',je,ne,Ge,oe,We;return d=new ie({props:{title:"Perturbed-Attention Guidance",local:"perturbed-attention-guidance",headingTag:"h1"}}),G=new ie({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),l=new $e({props:{warning:!1,$$slots:{default:[qe]},$$scope:{ctx:x}}}),Y=new Le({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting"],$$slots:{default:[ll]},$$scope:{ctx:x}}}),F=new ie({props:{title:"PAG with ControlNet",local:"pag-with-controlnet",headingTag:"h2"}}),W=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBDb250cm9sTmV0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtY2Fubnktc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTIybWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, ControlNetModel
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=<span class="hljs-string">&quot;mid&quot;</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Q=new $e({props:{$$slots:{default:[tl]},$$scope:{ctx:x}}}),L=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFjYW5ueV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBhZ19jb250cm9sX2lucHV0LnBuZyUyMiUwQSklMEElMEFmb3IlMjBwYWdfc2NhbGUlMjBpbiUyMCU1QjAuMCUyQyUyMDMuMCU1RCUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDEpJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUyMCUyMCUyMCUyMGltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_control_input.png&quot;</span>
)

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
    images = pipeline(
        prompt=<span class="hljs-string">&quot;&quot;</span>,
        controlnet_conditioning_scale=controlnet_conditioning_scale,
        image=canny_image,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images
    images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new ie({props:{title:"PAG with IP-Adapter",local:"pag-with-ip-adapter",headingTag:"h2"}}),K=new k({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">import</span> torch

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    image_encoder=image_encoder,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.bin&quot;</span>)

pag_scales = <span class="hljs-number">5.0</span>
ip_adapter_scales = <span class="hljs-number">0.8</span>

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)

pipeline.set_ip_adapter_scale(ip_adapter_scale)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=<span class="hljs-number">3.0</span>,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]
`,wrap:!1}}),ee=new ie({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),le=new ie({props:{title:"pag_applied_layers",local:"pagappliedlayers",headingTag:"h3"}}),se=new k({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQXBpcGVsaW5lLnNldF9wYWdfYXBwbGllZF9sYXllcnMocGFnX2xheWVycyklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEZ3VpZGFuY2Vfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQ=",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>
pipeline.set_pag_applied_layers(pag_layers)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),ne=new Pe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/pag.md"}}),{c(){s=U("meta"),u=o(),p=U("p"),y=o(),f(d.$$.fragment),Z=o(),c=U("p"),c.innerHTML=M,C=o(),j=U("p"),j.textContent=I,v=o(),f(G.$$.fragment),X=o(),_=U("p"),_.innerHTML=B,V=o(),f(l.$$.fragment),m=o(),f(Y.$$.fragment),A=o(),f(F.$$.fragment),E=o(),R=U("p"),R.innerHTML=z,i=o(),f(W.$$.fragment),ce=o(),f(Q.$$.fragment),me=o(),P=U("p"),P.innerHTML=Ie,Me=o(),f(L.$$.fragment),de=o(),N=U("div"),N.innerHTML=Ce,ue=o(),f(q.$$.fragment),ye=o(),D=U("p"),D.innerHTML=Be,fe=o(),f(K.$$.fragment),ge=o(),O=U("p"),O.textContent=Xe,be=o(),S=U("div"),S.innerHTML=ve,he=o(),f(ee.$$.fragment),Je=o(),f(le.$$.fragment),we=o(),te=U("p"),te.innerHTML=Ve,Ue=o(),ae=U("p"),ae.innerHTML=xe,Te=o(),f(se.$$.fragment),Ze=o(),H=U("div"),H.innerHTML=Ye,je=o(),f(ne.$$.fragment),Ge=o(),oe=U("p"),this.h()},l(e){const n=He("svelte-u9bgzb",document.head);s=T(n,"META",{name:!0,content:!0}),n.forEach(t),u=r(e),p=T(e,"P",{}),Fe(p).forEach(t),y=r(e),g(d.$$.fragment,e),Z=r(e),c=T(e,"P",{"data-svelte-h":!0}),$(c)!=="svelte-1w1c4u2"&&(c.innerHTML=M),C=r(e),j=T(e,"P",{"data-svelte-h":!0}),$(j)!=="svelte-11cdpcr"&&(j.textContent=I),v=r(e),g(G.$$.fragment,e),X=r(e),_=T(e,"P",{"data-svelte-h":!0}),$(_)!=="svelte-dt4tyz"&&(_.innerHTML=B),V=r(e),g(l.$$.fragment,e),m=r(e),g(Y.$$.fragment,e),A=r(e),g(F.$$.fragment,e),E=r(e),R=T(e,"P",{"data-svelte-h":!0}),$(R)!=="svelte-4m1dma"&&(R.innerHTML=z),i=r(e),g(W.$$.fragment,e),ce=r(e),g(Q.$$.fragment,e),me=r(e),P=T(e,"P",{"data-svelte-h":!0}),$(P)!=="svelte-112ukzn"&&(P.innerHTML=Ie),Me=r(e),g(L.$$.fragment,e),de=r(e),N=T(e,"DIV",{class:!0,"data-svelte-h":!0}),$(N)!=="svelte-e2cxkg"&&(N.innerHTML=Ce),ue=r(e),g(q.$$.fragment,e),ye=r(e),D=T(e,"P",{"data-svelte-h":!0}),$(D)!=="svelte-rjcwxp"&&(D.innerHTML=Be),fe=r(e),g(K.$$.fragment,e),ge=r(e),O=T(e,"P",{"data-svelte-h":!0}),$(O)!=="svelte-1n1gw76"&&(O.textContent=Xe),be=r(e),S=T(e,"DIV",{class:!0,"data-svelte-h":!0}),$(S)!=="svelte-j0lguw"&&(S.innerHTML=ve),he=r(e),g(ee.$$.fragment,e),Je=r(e),g(le.$$.fragment,e),we=r(e),te=T(e,"P",{"data-svelte-h":!0}),$(te)!=="svelte-1th38n0"&&(te.innerHTML=Ve),Ue=r(e),ae=T(e,"P",{"data-svelte-h":!0}),$(ae)!=="svelte-1d06cik"&&(ae.innerHTML=xe),Te=r(e),g(se.$$.fragment,e),Ze=r(e),H=T(e,"DIV",{class:!0,"data-svelte-h":!0}),$(H)!=="svelte-1srsjub"&&(H.innerHTML=Ye),je=r(e),g(ne.$$.fragment,e),Ge=r(e),oe=T(e,"P",{}),Fe(oe).forEach(t),this.h()},h(){pe(s,"name","hf:doc:metadata"),pe(s,"content",sl),pe(N,"class","flex flex-row gap-4"),pe(S,"class","flex flex-row gap-4"),pe(H,"class","flex flex-row gap-4")},m(e,n){ze(document.head,s),a(e,u,n),a(e,p,n),a(e,y,n),b(d,e,n),a(e,Z,n),a(e,c,n),a(e,C,n),a(e,j,n),a(e,v,n),b(G,e,n),a(e,X,n),a(e,_,n),a(e,V,n),b(l,e,n),a(e,m,n),b(Y,e,n),a(e,A,n),b(F,e,n),a(e,E,n),a(e,R,n),a(e,i,n),b(W,e,n),a(e,ce,n),b(Q,e,n),a(e,me,n),a(e,P,n),a(e,Me,n),b(L,e,n),a(e,de,n),a(e,N,n),a(e,ue,n),b(q,e,n),a(e,ye,n),a(e,D,n),a(e,fe,n),b(K,e,n),a(e,ge,n),a(e,O,n),a(e,be,n),a(e,S,n),a(e,he,n),b(ee,e,n),a(e,Je,n),b(le,e,n),a(e,we,n),a(e,te,n),a(e,Ue,n),a(e,ae,n),a(e,Te,n),b(se,e,n),a(e,Ze,n),a(e,H,n),a(e,je,n),b(ne,e,n),a(e,Ge,n),a(e,oe,n),We=!0},p(e,[n]){const ke={};n&2&&(ke.$$scope={dirty:n,ctx:e}),l.$set(ke);const Re={};n&2&&(Re.$$scope={dirty:n,ctx:e}),Y.$set(Re);const Ae={};n&2&&(Ae.$$scope={dirty:n,ctx:e}),Q.$set(Ae)},i(e){We||(h(d.$$.fragment,e),h(G.$$.fragment,e),h(l.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(W.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),We=!0)},o(e){J(d.$$.fragment,e),J(G.$$.fragment,e),J(l.$$.fragment,e),J(Y.$$.fragment,e),J(F.$$.fragment,e),J(W.$$.fragment,e),J(Q.$$.fragment,e),J(L.$$.fragment,e),J(q.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(se.$$.fragment,e),J(ne.$$.fragment,e),We=!1},d(e){e&&(t(u),t(p),t(y),t(Z),t(c),t(C),t(j),t(v),t(X),t(_),t(V),t(m),t(A),t(E),t(R),t(i),t(ce),t(me),t(P),t(Me),t(de),t(N),t(ue),t(ye),t(D),t(fe),t(ge),t(O),t(be),t(S),t(he),t(Je),t(we),t(te),t(Ue),t(ae),t(Te),t(Ze),t(H),t(je),t(Ge),t(oe)),t(s),w(d,e),w(G,e),w(l,e),w(Y,e),w(F,e),w(W,e),w(Q,e),w(L,e),w(q,e),w(K,e),w(ee,e),w(le,e),w(se,e),w(ne,e)}}}const sl='{"title":"Perturbed-Attention Guidance","local":"perturbed-attention-guidance","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"PAG with ControlNet","local":"pag-with-controlnet","sections":[],"depth":2},{"title":"PAG with IP-Adapter","local":"pag-with-ip-adapter","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"pag_applied_layers","local":"pagappliedlayers","sections":[],"depth":3}],"depth":2}],"depth":1}';function nl(x){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends Ne{constructor(s){super(),Se(this,s,nl,al,Ee,{})}}export{Ml as component};
