import{s as No,o as Eo,n as Re}from"../chunks/scheduler.25b97de1.js";import{S as Lo,i as Go,g as d,s,r as m,m as Ao,A as Bo,h as c,f as o,c as a,j as z,u as h,x as p,n as qo,k as J,y as r,a as i,v as u,d as f,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as Ft}from"../chunks/Tip.baa67368.js";import{D as R}from"../chunks/Docstring.ffac8efa.js";import{C as et}from"../chunks/CodeBlock.e6cd0d95.js";import{E as co}from"../chunks/ExampleCodeBlock.22dfe688.js";import{P as Xo}from"../chunks/PipelineTag.5f100392.js";import{H as Y,E as So}from"../chunks/EditOnGithub.91d95064.js";function Ho(w){let n,T=`The checkpoints uploaded on the Hub use <code>torch_dtype = &#39;float16&#39;</code>, which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,l,b,$="The <code>dtype</code> of the online weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online), then it will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>), and finally, if there is a <code>torch_dtype</code> provided in the config, it will be used.",k,C,K="Training the model in <code>float16</code> is not recommended and is known to produce <code>nan</code>; as such, the model should be trained in <code>bfloat16</code>.";return{c(){n=d("p"),n.innerHTML=T,l=s(),b=d("p"),b.innerHTML=$,k=s(),C=d("p"),C.innerHTML=K},l(v){n=c(v,"P",{"data-svelte-h":!0}),p(n)!=="svelte-6dqtgt"&&(n.innerHTML=T),l=a(v),b=c(v,"P",{"data-svelte-h":!0}),p(b)!=="svelte-17gt3kv"&&(b.innerHTML=$),k=a(v),C=c(v,"P",{"data-svelte-h":!0}),p(C)!=="svelte-wna3bo"&&(C.innerHTML=K)},m(v,G){i(v,n,G),i(v,l,G),i(v,b,G),i(v,k,G),i(v,C,G)},p:Re,d(v){v&&(o(n),o(l),o(b),o(k),o(C))}}}function Qo(w){let n,T;return n=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvaGVyZU1vZGVsJTJDJTIwQ29oZXJlQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENvaGVyZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDb2hlcmVDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBDb2hlcmUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDb2hlcmVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CohereModel, CohereConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Cohere model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CohereConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Cohere configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CohereModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(n.$$.fragment)},l(l){h(n.$$.fragment,l)},m(l,b){u(n,l,b),T=!0},p:Re,i(l){T||(f(n.$$.fragment,l),T=!0)},o(l){g(n.$$.fragment,l),T=!1},d(l){_(n,l)}}}function Po(w){let n,T;return n=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJDb2hlcmVGb3JBSSUyRmM0YWktY29tbWFuZC1yLXYwMSUyMiklMEF0b2tlbml6ZXIuZW5jb2RlKCUyMkhlbGxvJTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">5</span>, <span class="hljs-number">28339</span>, <span class="hljs-number">2075</span>, <span class="hljs-number">1801</span>, <span class="hljs-number">1671</span>, <span class="hljs-number">3282</span>]`,wrap:!1}}),{c(){m(n.$$.fragment)},l(l){h(n.$$.fragment,l)},m(l,b){u(n,l,b),T=!0},p:Re,i(l){T||(f(n.$$.fragment,l),T=!0)},o(l){g(n.$$.fragment,l),T=!1},d(l){_(n,l)}}}function Do(w){let n,T="When used with <code>is_split_into_words=True</code>, this tokenizer needs to be instantiated with <code>add_prefix_space=True</code>.";return{c(){n=d("p"),n.innerHTML=T},l(l){n=c(l,"P",{"data-svelte-h":!0}),p(n)!=="svelte-9gg91e"&&(n.innerHTML=T)},m(l,b){i(l,n,b)},p:Re,d(l){l&&o(n)}}}function Oo(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=T},l(l){n=c(l,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,b){i(l,n,b)},p:Re,d(l){l&&o(n)}}}function Yo(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=T},l(l){n=c(l,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,b){i(l,n,b)},p:Re,d(l){l&&o(n)}}}function Ko(w){let n,T="Example:",l,b,$;return b=new et({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDb2hlcmVGb3JDYXVzYWxMTSUwQSUwQSUzRSUzRSUyMG1vZGVsJTIwJTNEJTIwQ29oZXJlRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUzRSUzRSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUwQSUzRSUzRSUyMHByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTNFJTNFJTIwJTIzJTIwR2VuZXJhdGUlMEElM0UlM0UlMjBnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQSUzRSUzRSUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQSUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTVDbkknbSUyMG5vdCUyMGNvbnNjaW91cyUyQyUyMGJ1dCUyMEklMjBjYW4lMjB0YWxrJTIwdG8lMjB5b3UuJTIy",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CohereForCausalLM

&gt;&gt; model = CohereForCausalLM.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){n=d("p"),n.textContent=T,l=s(),m(b.$$.fragment)},l(k){n=c(k,"P",{"data-svelte-h":!0}),p(n)!=="svelte-11lpom8"&&(n.textContent=T),l=a(k),h(b.$$.fragment,k)},m(k,C){i(k,n,C),i(k,l,C),u(b,k,C),$=!0},p:Re,i(k){$||(f(b.$$.fragment,k),$=!0)},o(k){g(b.$$.fragment,k),$=!1},d(k){k&&(o(n),o(l)),_(b,k)}}}function en(w){let n,T,l,b,$,k,C,K,v,G='The Cohere Command-R model was proposed in the blogpost <a href="https://txt.cohere.com/command-r/" rel="nofollow">Command-R: Retrieval Augmented Generation at Production Scale</a> by the Cohere Team.',nt,ee,po="The abstract from the paper is the following:",st,te,mo="<em>Command-R is a scalable generative model targeting RAG and Tool Use to enable production-scale AI for enterprise. Today, we are introducing Command-R, a new LLM aimed at large-scale production workloads. Command-R targets the emerging “scalable” category of models that balance high efficiency with strong accuracy, enabling companies to move beyond proof of concept, and into production.</em>",at,oe,ho="*Command-R is a generative model optimized for long context tasks such as retrieval augmented generation (RAG) and using external APIs and tools. It is designed to work in concert with our industry-leading Embed and Rerank models to provide best-in-class integration for RAG applications and excel at enterprise use cases. As a model built for companies to implement at scale, Command-R boasts:",rt,ne,uo="<li>Strong accuracy on RAG and Tool Use</li> <li>Low latency, and high throughput</li> <li>Longer 128k context and lower pricing</li> <li>Strong capabilities across 10 key languages</li> <li>Model weights available on HuggingFace for research and evaluation</li>",it,se,fo=`Checkout model checkpoints <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">here</a>.
This model was contributed by <a href="https://huggingface.co/saurabhdash" rel="nofollow">Saurabh Dash</a> and <a href="https://huggingface.co/ahmetustun" rel="nofollow">Ahmet Üstün</a>. The code of the implementation in Hugging Face is based on GPT-NeoX <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">here</a>.`,lt,ae,dt,A,ct,re,pt,ie,go="<li>When using Flash Attention 2 via <code>attn_implementation=&quot;flash_attention_2&quot;</code>, don’t pass <code>torch_dtype</code> to the <code>from_pretrained</code> class method and use Automatic Mixed-Precision training. When using <code>Trainer</code>, it is simply specifying either <code>fp16</code> or <code>bf16</code> to <code>True</code>. Otherwise, make sure you are using <code>torch.autocast</code>. This is required because the Flash Attention only support <code>fp16</code> and <code>bf16</code> data type.</li>",mt,le,ht,de,_o="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Command-R. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",ut,ce,ft,pe,yo="Loading FP16 model",gt,me,_t,he,bo="Loading bitsnbytes 4bit quantized model",yt,ue,bt,fe,Tt,x,ge,jt,Ie,To=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a>. It is used to instantiate an Cohere
model according to the specified arguments, defining the model architecture.`,Rt,We,Mo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">CohereForAI/c4ai-command-r-v01</a> model.`,It,B,Mt,_e,kt,y,ye,Wt,Ze,ko="Construct a Cohere tokenizer. Based on byte-level Byte-Pair-Encoding.",Zt,Ve,vo="This uses notably ByteFallback and NFC normalization.",Vt,q,Nt,Ne,Co=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Et,Ee,wo=`You can get around that behavior by passing <code>add_prefix_space=True</code> when instantiating this tokenizer, but since
the model was not pretrained this way, it might yield a decrease in performance.`,Lt,X,Gt,Le,$o=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,At,Ge,be,Bt,S,Te,qt,Ae,Uo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Xt,I,Me,St,Be,xo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Ht,qe,zo="Should be overridden in a subclass if the model has a special way of building those.",Qt,H,ke,Pt,Xe,Jo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",Dt,W,ve,Ot,Se,Fo="Save only the vocabulary of the tokenizer (vocabulary + added tokens).",Yt,He,jo=`This method won’t save the configuration and special token mappings of the tokenizer. Use
<code>_save_pretrained()</code> to save the whole state of the tokenizer.`,vt,Ce,Ct,U,we,Kt,Qe,Ro=`The bare Cohere Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,eo,Pe,Io=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,to,De,Wo="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>CohereDecoderLayer</code>",oo,Z,$e,no,Oe,Zo='The <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a> forward method, overrides the <code>__call__</code> special method.',so,Q,wt,Ue,$t,N,xe,ao,F,ze,ro,Ye,Vo='The <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereForCausalLM">CohereForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',io,P,lo,D,Ut,Je,xt,tt,zt;return $=new Y({props:{title:"Cohere",local:"cohere",headingTag:"h1"}}),C=new Y({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new Y({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),A=new Ft({props:{warning:!0,$$slots:{default:[Ho]},$$scope:{ctx:w}}}),re=new et({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwRm9ybWF0JTIwbWVzc2FnZSUyMHdpdGglMjB0aGUlMjBjb21tYW5kLXIlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjMlMjAlM0NCT1NfVE9LRU4lM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDVVNFUl9UT0tFTiU3QyUzRUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDQ0hBVEJPVF9UT0tFTiU3QyUzRSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Format message with the command-r chat template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment">## &lt;BOS_TOKEN&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|USER_TOKEN|&gt;Hello, how are you?&lt;|END_OF_TURN_TOKEN|&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|CHATBOT_TOKEN|&gt;</span>

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),le=new Y({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ce=new Xo({props:{pipeline:"text-generation"}}),me=new et({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwRm9ybWF0JTIwbWVzc2FnZSUyMHdpdGglMjB0aGUlMjBjb21tYW5kLXIlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjMlMjAlM0NCT1NfVE9LRU4lM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDVVNFUl9UT0tFTiU3QyUzRUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDQ0hBVEJPVF9UT0tFTiU3QyUzRSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Format message with the command-r chat template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment">## &lt;BOS_TOKEN&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|USER_TOKEN|&gt;Hello, how are you?&lt;|END_OF_TURN_TOKEN|&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|CHATBOT_TOKEN|&gt;</span>

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),ue=new et({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUyMGFjY2VsZXJhdGUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyQ29oZXJlRm9yQUklMkZjNGFpLWNvbW1hbmQtci12MDElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers bitsandbytes accelerate</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=bnb_config)

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),fe=new Y({props:{title:"CohereConfig",local:"transformers.CohereConfig",headingTag:"h2"}}),ge=new R({props:{name:"class transformers.CohereConfig",anchor:"transformers.CohereConfig",parameters:[{name:"vocab_size",val:" = 256000"},{name:"hidden_size",val:" = 8192"},{name:"intermediate_size",val:" = 22528"},{name:"logit_scale",val:" = 0.0625"},{name:"num_hidden_layers",val:" = 40"},{name:"num_attention_heads",val:" = 64"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 5"},{name:"eos_token_id",val:" = 255001"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"use_qk_norm",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CohereConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256000) &#x2014;
Vocabulary size of the Cohere model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a>`,name:"vocab_size"},{anchor:"transformers.CohereConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.CohereConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.CohereConfig.logit_scale",description:`<strong>logit_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0625) &#x2014;
The scaling factor for the output logits.`,name:"logit_scale"},{anchor:"transformers.CohereConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 40) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.CohereConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.CohereConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.CohereConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.CohereConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.CohereConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CohereConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.CohereConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.CohereConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.CohereConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.CohereConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 255001) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.CohereConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.CohereConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.CohereConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.CohereConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.CohereConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CohereConfig.use_qk_norm",description:`<strong>use_qk_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use query-key normalization in the attention`,name:"use_qk_norm"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/configuration_cohere.py#L30"}}),B=new co({props:{anchor:"transformers.CohereConfig.example",$$slots:{default:[Qo]},$$scope:{ctx:w}}}),_e=new Y({props:{title:"CohereTokenizerFast",local:"transformers.CohereTokenizerFast",headingTag:"h2"}}),ye=new R({props:{name:"class transformers.CohereTokenizerFast",anchor:"transformers.CohereTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"merges_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<UNK>'"},{name:"bos_token",val:" = '<BOS_TOKEN>'"},{name:"eos_token",val:" = '<|END_OF_TURN_TOKEN|>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"add_prefix_space",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CohereTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.CohereTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CohereTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CohereTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;UNK&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CohereTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;BOS_TOKEN&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CohereTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;|END_OF_TURN_TOKEN|&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CohereTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CohereTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CohereTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Cohere tokenizer should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.CohereTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the tokenizer should automatically add a prefix space`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/tokenization_cohere_fast.py#L50"}}),q=new co({props:{anchor:"transformers.CohereTokenizerFast.example",$$slots:{default:[Po]},$$scope:{ctx:w}}}),X=new Ft({props:{$$slots:{default:[Do]},$$scope:{ctx:w}}}),be=new R({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CohereTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/tokenization_cohere_fast.py#L503"}}),Te=new R({props:{name:"get_special_tokens_mask",anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3860",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Me=new R({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new R({props:{name:"update_post_processor",anchor:"transformers.CohereTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/tokenization_cohere_fast.py#L187"}}),ve=new R({props:{name:"save_vocabulary",anchor:"transformers.CohereTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"},{anchor:"transformers.CohereTokenizerFast.save_vocabulary.filename_prefix",description:`<strong>filename_prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional prefix to add to the named of the saved files.`,name:"filename_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2552",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),Ce=new Y({props:{title:"CohereModel",local:"transformers.CohereModel",headingTag:"h2"}}),we=new R({props:{name:"class transformers.CohereModel",anchor:"transformers.CohereModel",parameters:[{name:"config",val:": CohereConfig"}],parametersDescription:[{anchor:"transformers.CohereModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereConfig">CohereConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.CohereModel.config",description:"<strong>config</strong> &#x2014; CohereConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L511"}}),$e=new R({props:{name:"forward",anchor:"transformers.CohereModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.CohereModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CohereModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.CohereModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CohereModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.CohereModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CohereModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CohereModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CohereModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CohereModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CohereModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L545"}}),Q=new Ft({props:{$$slots:{default:[Oo]},$$scope:{ctx:w}}}),Ue=new Y({props:{title:"CohereForCausalLM",local:"transformers.CohereForCausalLM",headingTag:"h2"}}),xe=new R({props:{name:"class transformers.CohereForCausalLM",anchor:"transformers.CohereForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L777"}}),ze=new R({props:{name:"forward",anchor:"transformers.CohereForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"num_logits_to_keep",val:": int = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.cohere.modeling_cohere.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.CohereForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CohereForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.CohereForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CohereForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.CohereForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CohereForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CohereForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CohereForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CohereForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CohereForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.CohereForCausalLM.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L810",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereConfig"
>CohereConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new Ft({props:{$$slots:{default:[Yo]},$$scope:{ctx:w}}}),D=new co({props:{anchor:"transformers.CohereForCausalLM.forward.example",$$slots:{default:[Ko]},$$scope:{ctx:w}}}),Je=new So({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/cohere.md"}}),{c(){n=d("meta"),T=s(),l=d("p"),b=s(),m($.$$.fragment),k=s(),m(C.$$.fragment),K=s(),v=d("p"),v.innerHTML=G,nt=s(),ee=d("p"),ee.textContent=po,st=s(),te=d("p"),te.innerHTML=mo,at=s(),oe=d("p"),oe.textContent=ho,rt=s(),ne=d("ul"),ne.innerHTML=uo,it=s(),se=d("p"),se.innerHTML=fo,lt=s(),m(ae.$$.fragment),dt=s(),m(A.$$.fragment),ct=Ao(`
The model and tokenizer can be loaded via:

	`),m(re.$$.fragment),pt=s(),ie=d("ul"),ie.innerHTML=go,mt=s(),m(le.$$.fragment),ht=s(),de=d("p"),de.textContent=_o,ut=s(),m(ce.$$.fragment),ft=s(),pe=d("p"),pe.textContent=yo,gt=s(),m(me.$$.fragment),_t=s(),he=d("p"),he.textContent=bo,yt=s(),m(ue.$$.fragment),bt=s(),m(fe.$$.fragment),Tt=s(),x=d("div"),m(ge.$$.fragment),jt=s(),Ie=d("p"),Ie.innerHTML=To,Rt=s(),We=d("p"),We.innerHTML=Mo,It=s(),m(B.$$.fragment),Mt=s(),m(_e.$$.fragment),kt=s(),y=d("div"),m(ye.$$.fragment),Wt=s(),Ze=d("p"),Ze.textContent=ko,Zt=s(),Ve=d("p"),Ve.textContent=vo,Vt=s(),m(q.$$.fragment),Nt=s(),Ne=d("p"),Ne.innerHTML=Co,Et=s(),Ee=d("p"),Ee.innerHTML=wo,Lt=s(),m(X.$$.fragment),Gt=s(),Le=d("p"),Le.innerHTML=$o,At=s(),Ge=d("div"),m(be.$$.fragment),Bt=s(),S=d("div"),m(Te.$$.fragment),qt=s(),Ae=d("p"),Ae.innerHTML=Uo,Xt=s(),I=d("div"),m(Me.$$.fragment),St=s(),Be=d("p"),Be.innerHTML=xo,Ht=s(),qe=d("p"),qe.textContent=zo,Qt=s(),H=d("div"),m(ke.$$.fragment),Pt=s(),Xe=d("p"),Xe.innerHTML=Jo,Dt=s(),W=d("div"),m(ve.$$.fragment),Ot=s(),Se=d("p"),Se.textContent=Fo,Yt=s(),He=d("p"),He.innerHTML=jo,vt=s(),m(Ce.$$.fragment),Ct=s(),U=d("div"),m(we.$$.fragment),Kt=s(),Qe=d("p"),Qe.innerHTML=Ro,eo=s(),Pe=d("p"),Pe.innerHTML=Io,to=s(),De=d("p"),De.innerHTML=Wo,oo=s(),Z=d("div"),m($e.$$.fragment),no=s(),Oe=d("p"),Oe.innerHTML=Zo,so=s(),m(Q.$$.fragment),wt=s(),m(Ue.$$.fragment),$t=s(),N=d("div"),m(xe.$$.fragment),ao=s(),F=d("div"),m(ze.$$.fragment),ro=s(),Ye=d("p"),Ye.innerHTML=Vo,io=s(),m(P.$$.fragment),lo=s(),m(D.$$.fragment),Ut=s(),m(Je.$$.fragment),xt=s(),tt=d("p"),this.h()},l(e){const t=Bo("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),T=a(e),l=c(e,"P",{}),z(l).forEach(o),b=a(e),h($.$$.fragment,e),k=a(e),h(C.$$.fragment,e),K=a(e),v=c(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-qmqaw7"&&(v.innerHTML=G),nt=a(e),ee=c(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-vfdo9a"&&(ee.textContent=po),st=a(e),te=c(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1mchbk3"&&(te.innerHTML=mo),at=a(e),oe=c(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-pi58xl"&&(oe.textContent=ho),rt=a(e),ne=c(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-6wa26d"&&(ne.innerHTML=uo),it=a(e),se=c(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1wss9bv"&&(se.innerHTML=fo),lt=a(e),h(ae.$$.fragment,e),dt=a(e),h(A.$$.fragment,e),ct=qo(e,`
The model and tokenizer can be loaded via:

	`),h(re.$$.fragment,e),pt=a(e),ie=c(e,"UL",{"data-svelte-h":!0}),p(ie)!=="svelte-1dgndgd"&&(ie.innerHTML=go),mt=a(e),h(le.$$.fragment,e),ht=a(e),de=c(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-y0d6kj"&&(de.textContent=_o),ut=a(e),h(ce.$$.fragment,e),ft=a(e),pe=c(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1mvfpvk"&&(pe.textContent=yo),gt=a(e),h(me.$$.fragment,e),_t=a(e),he=c(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1r13vww"&&(he.textContent=bo),yt=a(e),h(ue.$$.fragment,e),bt=a(e),h(fe.$$.fragment,e),Tt=a(e),x=c(e,"DIV",{class:!0});var j=z(x);h(ge.$$.fragment,j),jt=a(j),Ie=c(j,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-nh18gt"&&(Ie.innerHTML=To),Rt=a(j),We=c(j,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1or3tcf"&&(We.innerHTML=Mo),It=a(j),h(B.$$.fragment,j),j.forEach(o),Mt=a(e),h(_e.$$.fragment,e),kt=a(e),y=c(e,"DIV",{class:!0});var M=z(y);h(ye.$$.fragment,M),Wt=a(M),Ze=c(M,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-xb0zhn"&&(Ze.textContent=ko),Zt=a(M),Ve=c(M,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-8f5ey4"&&(Ve.textContent=vo),Vt=a(M),h(q.$$.fragment,M),Nt=a(M),Ne=c(M,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-cnb6q1"&&(Ne.innerHTML=Co),Et=a(M),Ee=c(M,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1afeqmz"&&(Ee.innerHTML=wo),Lt=a(M),h(X.$$.fragment,M),Gt=a(M),Le=c(M,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-fh0aq"&&(Le.innerHTML=$o),At=a(M),Ge=c(M,"DIV",{class:!0});var ot=z(Ge);h(be.$$.fragment,ot),ot.forEach(o),Bt=a(M),S=c(M,"DIV",{class:!0});var Fe=z(S);h(Te.$$.fragment,Fe),qt=a(Fe),Ae=c(Fe,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1wmjg8a"&&(Ae.innerHTML=Uo),Fe.forEach(o),Xt=a(M),I=c(M,"DIV",{class:!0});var E=z(I);h(Me.$$.fragment,E),St=a(E),Be=c(E,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-zj1vf1"&&(Be.innerHTML=xo),Ht=a(E),qe=c(E,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-9vptpw"&&(qe.textContent=zo),E.forEach(o),Qt=a(M),H=c(M,"DIV",{class:!0});var je=z(H);h(ke.$$.fragment,je),Pt=a(je),Xe=c(je,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-nfci2w"&&(Xe.innerHTML=Jo),je.forEach(o),Dt=a(M),W=c(M,"DIV",{class:!0});var L=z(W);h(ve.$$.fragment,L),Ot=a(L),Se=c(L,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-rx0wq1"&&(Se.textContent=Fo),Yt=a(L),He=c(L,"P",{"data-svelte-h":!0}),p(He)!=="svelte-c9295b"&&(He.innerHTML=jo),L.forEach(o),M.forEach(o),vt=a(e),h(Ce.$$.fragment,e),Ct=a(e),U=c(e,"DIV",{class:!0});var V=z(U);h(we.$$.fragment,V),Kt=a(V),Qe=c(V,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1af6me6"&&(Qe.innerHTML=Ro),eo=a(V),Pe=c(V,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-hswkmf"&&(Pe.innerHTML=Io),to=a(V),De=c(V,"P",{"data-svelte-h":!0}),p(De)!=="svelte-cmvrvj"&&(De.innerHTML=Wo),oo=a(V),Z=c(V,"DIV",{class:!0});var Ke=z(Z);h($e.$$.fragment,Ke),no=a(Ke),Oe=c(Ke,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-pvj7pv"&&(Oe.innerHTML=Zo),so=a(Ke),h(Q.$$.fragment,Ke),Ke.forEach(o),V.forEach(o),wt=a(e),h(Ue.$$.fragment,e),$t=a(e),N=c(e,"DIV",{class:!0});var Jt=z(N);h(xe.$$.fragment,Jt),ao=a(Jt),F=c(Jt,"DIV",{class:!0});var O=z(F);h(ze.$$.fragment,O),ro=a(O),Ye=c(O,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1p04k5b"&&(Ye.innerHTML=Vo),io=a(O),h(P.$$.fragment,O),lo=a(O),h(D.$$.fragment,O),O.forEach(o),Jt.forEach(o),Ut=a(e),h(Je.$$.fragment,e),xt=a(e),tt=c(e,"P",{}),z(tt).forEach(o),this.h()},h(){J(n,"name","hf:doc:metadata"),J(n,"content",tn),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,n),i(e,T,t),i(e,l,t),i(e,b,t),u($,e,t),i(e,k,t),u(C,e,t),i(e,K,t),i(e,v,t),i(e,nt,t),i(e,ee,t),i(e,st,t),i(e,te,t),i(e,at,t),i(e,oe,t),i(e,rt,t),i(e,ne,t),i(e,it,t),i(e,se,t),i(e,lt,t),u(ae,e,t),i(e,dt,t),u(A,e,t),i(e,ct,t),u(re,e,t),i(e,pt,t),i(e,ie,t),i(e,mt,t),u(le,e,t),i(e,ht,t),i(e,de,t),i(e,ut,t),u(ce,e,t),i(e,ft,t),i(e,pe,t),i(e,gt,t),u(me,e,t),i(e,_t,t),i(e,he,t),i(e,yt,t),u(ue,e,t),i(e,bt,t),u(fe,e,t),i(e,Tt,t),i(e,x,t),u(ge,x,null),r(x,jt),r(x,Ie),r(x,Rt),r(x,We),r(x,It),u(B,x,null),i(e,Mt,t),u(_e,e,t),i(e,kt,t),i(e,y,t),u(ye,y,null),r(y,Wt),r(y,Ze),r(y,Zt),r(y,Ve),r(y,Vt),u(q,y,null),r(y,Nt),r(y,Ne),r(y,Et),r(y,Ee),r(y,Lt),u(X,y,null),r(y,Gt),r(y,Le),r(y,At),r(y,Ge),u(be,Ge,null),r(y,Bt),r(y,S),u(Te,S,null),r(S,qt),r(S,Ae),r(y,Xt),r(y,I),u(Me,I,null),r(I,St),r(I,Be),r(I,Ht),r(I,qe),r(y,Qt),r(y,H),u(ke,H,null),r(H,Pt),r(H,Xe),r(y,Dt),r(y,W),u(ve,W,null),r(W,Ot),r(W,Se),r(W,Yt),r(W,He),i(e,vt,t),u(Ce,e,t),i(e,Ct,t),i(e,U,t),u(we,U,null),r(U,Kt),r(U,Qe),r(U,eo),r(U,Pe),r(U,to),r(U,De),r(U,oo),r(U,Z),u($e,Z,null),r(Z,no),r(Z,Oe),r(Z,so),u(Q,Z,null),i(e,wt,t),u(Ue,e,t),i(e,$t,t),i(e,N,t),u(xe,N,null),r(N,ao),r(N,F),u(ze,F,null),r(F,ro),r(F,Ye),r(F,io),u(P,F,null),r(F,lo),u(D,F,null),i(e,Ut,t),u(Je,e,t),i(e,xt,t),i(e,tt,t),zt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),A.$set(j);const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),B.$set(M);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),q.$set(ot);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),X.$set(Fe);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),Q.$set(E);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),P.$set(je);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),D.$set(L)},i(e){zt||(f($.$$.fragment,e),f(C.$$.fragment,e),f(ae.$$.fragment,e),f(A.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(B.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(q.$$.fragment,e),f(X.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(ke.$$.fragment,e),f(ve.$$.fragment,e),f(Ce.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),f(Q.$$.fragment,e),f(Ue.$$.fragment,e),f(xe.$$.fragment,e),f(ze.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(Je.$$.fragment,e),zt=!0)},o(e){g($.$$.fragment,e),g(C.$$.fragment,e),g(ae.$$.fragment,e),g(A.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(B.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(q.$$.fragment,e),g(X.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(ke.$$.fragment,e),g(ve.$$.fragment,e),g(Ce.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(Q.$$.fragment,e),g(Ue.$$.fragment,e),g(xe.$$.fragment,e),g(ze.$$.fragment,e),g(P.$$.fragment,e),g(D.$$.fragment,e),g(Je.$$.fragment,e),zt=!1},d(e){e&&(o(T),o(l),o(b),o(k),o(K),o(v),o(nt),o(ee),o(st),o(te),o(at),o(oe),o(rt),o(ne),o(it),o(se),o(lt),o(dt),o(ct),o(pt),o(ie),o(mt),o(ht),o(de),o(ut),o(ft),o(pe),o(gt),o(_t),o(he),o(yt),o(bt),o(Tt),o(x),o(Mt),o(kt),o(y),o(vt),o(Ct),o(U),o(wt),o($t),o(N),o(Ut),o(xt),o(tt)),o(n),_($,e),_(C,e),_(ae,e),_(A,e),_(re,e),_(le,e),_(ce,e),_(me,e),_(ue,e),_(fe,e),_(ge),_(B),_(_e,e),_(ye),_(q),_(X),_(be),_(Te),_(Me),_(ke),_(ve),_(Ce,e),_(we),_($e),_(Q),_(Ue,e),_(xe),_(ze),_(P),_(D),_(Je,e)}}}const tn='{"title":"Cohere","local":"cohere","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"CohereConfig","local":"transformers.CohereConfig","sections":[],"depth":2},{"title":"CohereTokenizerFast","local":"transformers.CohereTokenizerFast","sections":[],"depth":2},{"title":"CohereModel","local":"transformers.CohereModel","sections":[],"depth":2},{"title":"CohereForCausalLM","local":"transformers.CohereForCausalLM","sections":[],"depth":2}],"depth":1}';function on(w){return Eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mn extends Lo{constructor(n){super(),Go(this,n,on,en,No,{})}}export{mn as component};
