import{s as Dp,o as Pp,n as R}from"../chunks/scheduler.25b97de1.js";import{S as Kp,i as Op,g as o,s as a,r as M,A as tM,h as i,f as l,c as n,j as Fp,u as r,x as p,k as Lp,y as eM,a as s,v as y,d as c,t as u,w as m,m as lM,n as sM}from"../chunks/index.d9030fc9.js";import{T as v}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{H as j,E as aM}from"../chunks/EditOnGithub.91d95064.js";function nM(b){let d,U=`The default behaviour of <code>TextGenerationPipeline</code> is to set <code>add_generation_prompt=True</code> so that it starts a new
message. However, if the final message in the input chat has the “assistant” role, it will assume that this message is
a prefill and switch to <code>continue_final_message=True</code> instead, because most models do not support multiple
consecutive assistant messages. You can override this behaviour by explicitly passing the <code>continue_final_message</code>
argument when calling the pipeline.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-95bbxf"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:R,d(h){h&&l(d)}}}function oM(b){let d,U=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,h,T,C=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){d=o("p"),d.innerHTML=U,h=a(),T=o("p"),T.innerHTML=C},l(I){d=i(I,"P",{"data-svelte-h":!0}),p(d)!=="svelte-148xjo3"&&(d.innerHTML=U),h=n(I),T=i(I,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1hgzema"&&(T.innerHTML=C)},m(I,g){s(I,d,g),s(I,h,g),s(I,T,g)},p:R,d(I){I&&(l(d),l(h),l(T))}}}function iM(b){let d,U=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1wfdwuk"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:R,d(h){h&&l(d)}}}function pM(b){let d,U=`If you’re familiar with the OpenAI API, you should pay attention to an important difference here - the <code>tool_call</code> is
a dict, but in the OpenAI API it’s a JSON string. Passing a string may cause errors or strange model behaviour!`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fq11ea"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:R,d(h){h&&l(d)}}}function MM(b){let d,U=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,h,T,C,I,g="and",G,f,$;return T=new J({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),f=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){d=o("p"),d.innerHTML=U,h=a(),M(T.$$.fragment),C=a(),I=o("p"),I.textContent=g,G=a(),M(f.$$.fragment)},l(w){d=i(w,"P",{"data-svelte-h":!0}),p(d)!=="svelte-70hqps"&&(d.innerHTML=U),h=n(w),r(T.$$.fragment,w),C=n(w),I=i(w,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1qlona5"&&(I.textContent=g),G=n(w),r(f.$$.fragment,w)},m(w,x){s(w,d,x),s(w,h,x),y(T,w,x),s(w,C,x),s(w,I,x),s(w,G,x),y(f,w,x),$=!0},p:R,i(w){$||(c(T.$$.fragment,w),c(f.$$.fragment,w),$=!0)},o(w){u(T.$$.fragment,w),u(f.$$.fragment,w),$=!1},d(w){w&&(l(d),l(h),l(C),l(I),l(G)),m(T,w),m(f,w)}}}function rM(b){let d,U="The <code>documents</code> input for retrieval-augmented generation is not widely supported, and many models have chat templates which simply ignore this input.",h,T,C="To verify if a model supports the <code>documents</code> input, you can read its model card, or <code>print(tokenizer.chat_template)</code> to see if the <code>documents</code> key is used anywhere.",I,g,G='One model class that does support it, though, is Cohere’s <a href="https://huggingface.co/CohereForAI/c4ai-command-r-08-2024" rel="nofollow">Command-R</a> and <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R+</a>, through their <code>rag</code> chat template. You can see additional examples of grounded generation using this feature in their model cards.';return{c(){d=o("p"),d.innerHTML=U,h=a(),T=o("p"),T.innerHTML=C,I=a(),g=o("p"),g.innerHTML=G},l(f){d=i(f,"P",{"data-svelte-h":!0}),p(d)!=="svelte-bl710l"&&(d.innerHTML=U),h=n(f),T=i(f,"P",{"data-svelte-h":!0}),p(T)!=="svelte-qpz2lz"&&(T.innerHTML=C),I=n(f),g=i(f,"P",{"data-svelte-h":!0}),p(g)!=="svelte-kg7zp3"&&(g.innerHTML=G)},m(f,$){s(f,d,$),s(f,h,$),s(f,T,$),s(f,I,$),s(f,g,$)},p:R,d(f){f&&(l(d),l(h),l(T),l(I),l(g))}}}function yM(b){let d;return{c(){d=lM(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(U){d=sM(U,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(U,h){s(U,d,h)},d(U){U&&l(d)}}}function cM(b){let d,U=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-qy60pj"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:R,d(h){h&&l(d)}}}function uM(b){let d,U=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-cvlh0x"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:R,d(h){h&&l(d)}}}function mM(b){let d,U,h,T,C,I,g,G,f,$=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,w,x,zo=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer for text-only LLMs or processor for multimodal LLMs. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,Ms,_,Eo="Let’s make this concrete with a quick example using the <code>mistralai/Mistral-7B-Instruct-v0.1</code> model:",rs,S,ys,z,Xo=`Notice how the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!), and the entire chat is condensed into a single string.
If we use <code>tokenize=True</code>, which is the default setting, that string will also be tokenized for us.`,cs,E,Ho="Now, try the same code, but swap in the <code>HuggingFaceH4/zephyr-7b-beta</code> model instead, and you should get:",us,X,ms,H,Yo=`Both Zephyr and Mistral-Instruct were fine-tuned from the same base model, <code>Mistral-7B-v0.1</code>. However, they were trained
with totally different chat formats. Without chat templates, you would have to write manual formatting code for each
model, and it’s very easy to make minor errors that hurt performance! Chat templates handle the details of formatting
for you, allowing you to write universal code that works for any model.`,ds,Y,hs,F,Fo=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> or <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.apply_chat_template">apply_chat_template()</a> method
depending on what type of model you are using. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,Js,L,Ts,D,Lo="Here’s an example of preparing input for <code>model.generate()</code>, using <code>Zephyr</code> again:",Us,P,js,K,Do="This will yield a string in the input format that Zephyr expects.",ws,O,fs,tt,Po="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",Is,et,gs,lt,Ko="This will yield:",bs,st,Cs,at,xs,nt,Oo=`For multimodal LLMs such as <a href="https://huggingface.co/llava-hf" rel="nofollow">LLaVA</a> the prompts can be formatted in a similar way. The only difference is you need to pass input images/videos as well along with the text. Each <code>&quot;content&quot;</code>
has to be a list containing either a text or an image/video.`,$s,ot,ti="Here’s an example of preparing input for using <code>LLaVA</code> model:",Gs,it,vs,pt,ei=`This yields a string in LLaVAs expected input format with many <code>&lt;image&gt;</code> tokens at the end.
The <code>&lt;image&gt;</code> tokens are placeholders and each one will be replaced by image embeddings when the mode is run in the forward call. The <code>processed_chat</code> can be further passed into <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to generate text.`,Bs,Mt,Ns,rt,li="Arr, ‘twas easy after all!",Zs,yt,As,ct,si=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Qs,ut,ks,mt,qs,dt,ai=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,Ws,ht,Vs,Jt,ni=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Rs,Tt,_s,Ut,oi="Here’s what this will look like without a generation prompt, for a model that uses standard “ChatML” formatting:",Ss,jt,zs,wt,ii="And here’s what it looks like <strong>with</strong> a generation prompt:",Es,ft,Xs,It,pi=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Hs,gt,Mi=`Not all models require generation prompts. Some models, like LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Ys,bt,Fs,Ct,ri=`When passing a list of messages to <code>apply_chat_template</code> or <code>TextGenerationPipeline</code>, you can choose
to format the chat so the model will continue the final message in the chat instead of starting a new one. This is done
by removing any end-of-sequence tokens that indicate the end of the final message, so that the model will simply
extend the final message when it begins to generate text. This is useful for “prefilling” the model’s response.`,Ls,xt,yi="Here’s an example:",Ds,$t,Ps,Gt,ci=`The model will generate text that continues the JSON string, rather than starting a new message. This approach
can be very useful for improving the accuracy of the model’s instruction-following when you know how you want
it to start its replies.`,Ks,vt,ui=`Because <code>add_generation_prompt</code> adds the tokens that start a new message, and <code>continue_final_message</code> removes any
end-of-message tokens from the final message, it does not make sense to use them together. As a result, you’ll
get an error if you try!`,Os,B,ta,Bt,ea,Nt,mi=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,la,Zt,sa,At,di="And we get:",aa,Qt,na,kt,hi="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",oa,N,ia,qt,pa,Wt,Ji=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,Ma,Vt,Ti=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,ra,Rt,ya,_t,Ui=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,ca,St,ua,zt,ji=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,ma,Et,wi=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,da,Xt,ha,Ht,fi=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,Ja,Yt,Ii="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",Ta,Ft,Ua,Lt,gi=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,ja,Dt,bi="First, let’s load our model and tokenizer:",wa,Pt,fa,Kt,Ci="Next, let’s define a list of tools:",Ia,Ot,ga,te,xi="Now, let’s set up a conversation for our bot:",ba,ee,Ca,le,$i="Now, let’s apply the chat template and generate a response:",xa,se,$a,ae,Gi="And we get:",Ga,ne,va,oe,vi=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,Ba,Z,Na,ie,Bi="Next, let’s append the model’s tool call to the conversation.",Za,pe,Aa,A,Qa,Me,Ni=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,ka,re,qa,Q,Wa,ye,Zi="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Va,ce,Ra,ue,Ai="And we get:",_a,me,Sa,de,Qi=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,za,he,Ea,Je,ki=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,Xa,Te,qi=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,Ha,Ue,Ya,je,Wi="This will yield:",Fa,we,La,fe,Vi=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,Da,Ie,Ri="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",Pa,ge,Ka,be,Oa,Ce,_i=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,tn,xe,Si="Here’s an example of a RAG template in action:",en,$e,ln,k,sn,Ge,an,ve,zi=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at a <code>Zephyr</code> chat template, though note this
one is a little simplified from the actual one!`,nn,Be,on,Ne,Ei=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,pn,Ze,Mn,Ae,Xi="Effectively, the template does three things:",rn,Qe,Hi=`<li>For each message, print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code>, like <code>&lt;|user|&gt;</code> or <code>&lt;|assistant|&gt;</code>.</li> <li>Next, print the content of the message, followed by the end-of-sequence token.</li> <li>Finally, if <code>add_generation_prompt</code> is set, print the assistant token, so that the model knows to start generating
an assistant response.</li>`,yn,ke,Yi=`This is a pretty simple template but Jinja gives you a lot of flexibility to do more complex things! Let’s see a Jinja
template that can format inputs similarly to the way LLaMA formats them (note that the real LLaMA template includes
handling for default system messages and slightly different system message handling in general - don’t use this one
in your actual code!)`,cn,qe,un,We,Fi=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens like
<code>[INST]</code> and <code>[/INST]</code> based on the role of each message. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,mn,Ve,dn,Re,hn,_e,Li=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Jn,Se,Tn,ze,Di=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,Un,Ee,jn,Xe,Pi=`The method <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,wn,q,fn,He,In,Ye,Ki=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,gn,Fe,Oi=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,bn,Le,tp=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,Cn,De,xn,Pe,ep=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,$n,Ke,lp=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,Gn,Oe,vn,tl,sp=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Bn,el,Nn,ll,ap=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Zn,sl,An,al,np=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,Qn,nl,kn,ol,op=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,qn,il,ip=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Wn,pl,pp=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Vn,Ml,Rn,W,_n,rl,Mp=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,Sn,yl,rp="You can also use the following tips to write clean, efficient Jinja templates:",zn,cl,En,ul,yp=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,Xn,ml,Hn,dl,cp="rather than like this:",Yn,hl,Fn,Jl,up=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,Ln,Tl,Dn,Ul,mp=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,Pn,jl,dp="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",Kn,V,On,wl,to,fl,hp="There is also a short list of callable functions available to you inside your templates. These are:",eo,Il,Jp=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,lo,gl,so,bl,Tp=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,ao,Cl,Up=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,no,xl,jp=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,oo,$l,io,Gl,wp=`We mentioned above that <code>add_generation_prompt</code> is a special variable that will be accessible inside your template,
and is controlled by the user setting the <code>add_generation_prompt</code> flag. If your model expects a header for
assistant messages, then your template must support adding the header when <code>add_generation_prompt</code> is set.`,po,vl,fp="Here is an example of a template that formats messages ChatML-style, with generation prompt support:",Mo,Bl,ro,Nl,Ip=`The exact content of the assistant header will depend on your specific model, but it should always be <strong>the string
that represents the start of an assistant message</strong>, so that if the user applies your template with
<code>add_generation_prompt=True</code> and then generates text, the model will write an assistant response. Also note that some
models do not need a generation prompt, because assistant messages always begin immediately after user messages.
This is particularly common for LLaMA and Mistral models, where assistant messages begin immediately after the <code>[/INST]</code>
token that ends user messages. In these cases, the template can ignore the <code>add_generation_prompt</code> flag.`,yo,Zl,gp=`Generation prompts are important! If your model requires a generation prompt but it is not set in the template, then
model generations will likely be severely degraded, or the model may display unusual behaviour like continuing
the final user message!`,co,Al,uo,Ql,bp=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,mo,kl,ho,ql,Cp="Or load the edited template back into the tokenizer:",Jo,Wl,To,Vl,xp=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,Uo,Rl,jo,_l,$p=`Although chat templates do not enforce a specific API for tools (or for anything, really), we recommend
template authors try to stick to a standard API where possible. The whole point of chat templates is to allow code
to be transferable across models, so deviating from the standard tools API means users will have to write
custom code to use tools with your model. Sometimes it’s unavoidable, but often with clever templating you can
make the standard API work!`,wo,Sl,Gp="Below, we’ll list the elements of the standard API, and give tips on writing templates that will work well with it.",fo,zl,Io,El,vp=`Your template should expect that the variable <code>tools</code> will either be null (if no tools are passed), or is a list
of JSON schema dicts. Our chat template methods allow users to pass tools as either JSON schema or Python functions, but when
functions are passed, we automatically generate JSON schema and pass that to your template. As a result, the
<code>tools</code> variable that your template receives will always be a list of JSON schema. Here is
a sample tool JSON schema:`,go,Xl,bo,Hl,Bp=`And here is some example code for handling tools in your chat template. Remember, this is just an example for a
specific format - your model will probably need different formatting!`,Co,Yl,xo,Fl,Np=`The specific tokens and tool descriptions your template renders should of course be chosen to match the ones your model
was trained with. There is no requirement that your <strong>model</strong> understands JSON schema input, only that your template can translate
JSON schema into your model’s format. For example, <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R</a>
was trained with tools defined using Python function headers, but the Command-R tool template accepts JSON schema,
converts types internally and renders the input tools as Python headers. You can do a lot with templates!`,$o,Ll,Go,Dl,Zp=`Tool calls, if present, will be a list attached to a message with the “assistant” role. Note that <code>tool_calls</code> is
always a list, even though most tool-calling models only support single tool calls at a time, which means
the list will usually only have a single element. Here is a sample message dict containing a tool call:`,vo,Pl,Bo,Kl,Ap="And a common pattern for handling them would be something like this:",No,Ol,Zo,ts,Qp="Again, you should render the tool call with the formatting and special tokens that your model expects.",Ao,es,Qo,ls,kp=`Tool responses have a simple format: They are a message dict with the “tool” role, a “name” key giving the name
of the called function, and a “content” key containing the result of the tool call. Here is a sample tool response:`,ko,ss,qo,as,qp=`You don’t need to use all of the keys in the tool response. For example, if your model doesn’t expect the function
name to be included in the tool response, then rendering it can be as simple as:`,Wo,ns,Vo,os,Wp=`Again, remember that the actual formatting and special tokens are model-specific - you should take a lot of care
to ensure that tokens, whitespace and everything else exactly match the format your model was trained with!`,Ro,is,_o,ps,So;return C=new j({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),g=new j({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),X=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQUknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTNDJTJGcyUzRQ==",highlighted:`&lt;|user|&gt;
Hello, how are you?&lt;/s&gt;
&lt;|assistant|&gt;
I&#x27;m doing great. How can I help you today?&lt;/s&gt;
&lt;|user|&gt;
I&#x27;d like to show off how chat templating works!&lt;/s&gt;`,wrap:!1}}),Y=new j({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),L=new j({props:{title:"Usage with text-only LLMs",local:"usage-with-text-only-llms",headingTag:"h2"}}),P=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),O=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),et=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),st=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),at=new j({props:{title:"Usage with multimodal LLMs",local:"usage-with-multimodal-llms",headingTag:"h2"}}),it=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUyMCUyMCUyMyUyMFlvdSUyMG1heSUyMHdhbnQlMjB0byUyMHVzZSUyMGJmbG9hdDE2JTIwYW5kJTJGb3IlMjBtb3ZlJTIwdG8lMjBHUFUlMjBoZXJlJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBmcmllbmRseSUyMGNoYXRib3QlMjB3aG8lMjBhbHdheXMlMjByZXNwb25kcyUyMGluJTIwdGhlJTIwc3R5bGUlMjBvZiUyMGElMjBwaXJhdGUlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGFyZSUyMHRoZXNlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBcHJvY2Vzc2VkX2NoYXQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNEVHJ1ZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJvY2Vzc2VkX2NoYXQlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIlM0ElMkMlMjAlM0EzMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

model_id = <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>
processor = AutoProcessor.from_pretrained(model_id)

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>}],
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: [
          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What are these?&quot;</span>},
        ],
    },
]

processed_chat = processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(processor.batch_decode(processed_chat[<span class="hljs-string">&quot;input_ids&quot;</span>][:, :<span class="hljs-number">30</span>]))`,wrap:!1}}),Mt=new J({props:{code:"JyUzQyU3Q2ltX3N0YXJ0JTdDJTNFc3lzdGVtJTIwJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUyMCUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0Un",highlighted:`&#x27;&lt;|im_start|&gt;system 
You are a friendly chatbot who always responds in the style of a pirate&lt;|im_end|&gt;&lt;|im_start|&gt;user &lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&#x27;`,wrap:!1}}),yt=new j({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),ut=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),mt=new J({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),ht=new j({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),Tt=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),jt=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ft=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),bt=new j({props:{title:"What does “continue_final_message” do?",local:"what-does-continuefinalmessage-do",headingTag:"h2"}}),$t=new J({props:{code:"Y2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJyU3QiUyMm5hbWUlMjIlM0ElMjAlMjInJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwY29udGludWVfZmluYWxfbWVzc2FnZSUzRFRydWUpJTBBbW9kZWwuZ2VuZXJhdGUoKipmb3JtYXR0ZWRfY2hhdCk=",highlighted:`chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

formatted_chat = tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, continue_final_message=<span class="hljs-literal">True</span>)
model.generate(**formatted_chat)`,wrap:!1}}),B=new v({props:{$$slots:{default:[nM]},$$scope:{ctx:b}}}),Bt=new j({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),Zt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),Qt=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),N=new v({props:{$$slots:{default:[oM]},$$scope:{ctx:b}}}),qt=new j({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),Rt=new j({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),St=new J({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),Xt=new j({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Ft=new j({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),Pt=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Ot=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),ee=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),se=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),ne=new J({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),Z=new v({props:{$$slots:{default:[iM]},$$scope:{ctx:b}}}),pe=new J({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),A=new v({props:{warning:!0,$$slots:{default:[pM]},$$scope:{ctx:b}}}),re=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),Q=new v({props:{$$slots:{default:[MM]},$$scope:{ctx:b}}}),ce=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),me=new J({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),he=new j({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),Ue=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),we=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ge=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),be=new j({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),$e=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-comment"># Load the model and tokenizer</span>
model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01-4bit&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
device = model.device <span class="hljs-comment"># Get the device the model is loaded on</span>

<span class="hljs-comment"># Define conversation input</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What has Man always dreamed of?&quot;</span>}
]

<span class="hljs-comment"># Define documents for retrieval-based generation</span>
documents = [
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>, 
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
    },
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
    }
]

<span class="hljs-comment"># Tokenize conversation and documents using a RAG template, returning PyTorch tensors.</span>
input_ids = tokenizer.apply_chat_template(
    conversation=conversation,
    documents=documents,
    chat_template=<span class="hljs-string">&quot;rag&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate a response </span>
gen_tokens = model.generate(
    input_ids,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.3</span>,
    )

<span class="hljs-comment"># Decode and print the generated text along with generation prompt</span>
gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),k=new v({props:{$$slots:{default:[rM]},$$scope:{ctx:b}}}),Ge=new j({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),Be=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiUyNS0lMjBpZiUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
{%- endfor %}
{%- if add_generation_prompt %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|assistant|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endif %}</span>`,wrap:!1}}),Ze=new J({props:{code:"Zm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJyUzQyU3QyU3Qm1lc3NhZ2UlNUIlMjJyb2xlJTIyJTVEJTdEJTdDJTNFJyklMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuKSUwQWlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJyUzQyU3Q2Fzc2lzdGFudCU3QyUzRScp",highlighted:`<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;&lt;|<span class="hljs-subst">{message[<span class="hljs-string">&quot;role&quot;</span>]}</span>|&gt;&#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>] + eos_token)
<span class="hljs-keyword">if</span> add_generation_prompt:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;&lt;|assistant|&gt;&#x27;</span>)`,wrap:!1}}),qe=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Ve=new j({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),Re=new j({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),Se=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Ee=new J({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),q=new v({props:{$$slots:{default:[yM]},$$scope:{ctx:b}}}),He=new j({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),De=new j({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),Oe=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),el=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),sl=new J({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),nl=new j({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),Ml=new j({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),W=new v({props:{$$slots:{default:[cM]},$$scope:{ctx:b}}}),cl=new j({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),ml=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),hl=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Tl=new j({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),V=new v({props:{$$slots:{default:[uM]},$$scope:{ctx:b}}}),wl=new j({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),gl=new j({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),$l=new j({props:{title:"Writing generation prompts",local:"writing-generation-prompts",headingTag:"h3"}}),Bl=new J({props:{code:"JTdCJTdCLSUyMGJvc190b2tlbiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`{{- bos_token }}
{%- for message in messages %}
    {{- &#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27; }}
{%- endfor %}
{%- if add_generation_prompt %}
    {{- &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}
{%- endif %}`,wrap:!1}}),Al=new j({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),kl=new J({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),Wl=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),Rl=new j({props:{title:"Writing templates for tools",local:"writing-templates-for-tools",headingTag:"h3"}}),zl=new j({props:{title:"Tool definitions",local:"tool-definitions",headingTag:"h4"}}),Xl=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Yl=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQ3Rvb2wlM0UnJTIwJTJCJTIwdG9vbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwYXJndW1lbnQlMjBpbiUyMHRvb2wlNUInZnVuY3Rpb24nJTVEJTVCJ3BhcmFtZXRlcnMnJTVEJTVCJ3Byb3BlcnRpZXMnJTVEJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMGFyZ3VtZW50JTIwJTJCJTIwJyUzQSUyMCclMjAlMkIlMjB0b29sJTVCJ2Z1bmN0aW9uJyU1RCU1QidwYXJhbWV0ZXJzJyU1RCU1Qidwcm9wZXJ0aWVzJyU1RCU1QmFyZ3VtZW50JTVEJTVCJ2Rlc2NyaXB0aW9uJyU1RCUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyU1Q24lM0MlMkZ0b29sJTNFJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if tools %}
    {%- for tool in tools %}
        {{- &#x27;&lt;tool&gt;&#x27; + tool[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; }}
        {%- for argument in tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;] %}
            {{- argument + &#x27;: &#x27; + tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;][argument][&#x27;description&#x27;] + &#x27;\\n&#x27; }}
        {%- endfor %}
        {{- &#x27;\\n&lt;/tool&gt;&#x27; }}
    {%- endif %}
{%- endif %}`,wrap:!1}}),Ll=new j({props:{title:"Tool calls",local:"tool-calls",headingTag:"h4"}}),Pl=new J({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMnRvb2xfY2FsbHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJtdWx0aXBseSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYiUyMiUzQSUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tool_calls&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;arguments&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">6</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ol=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwYW5kJTIwJ3Rvb2xfY2FsbHMnJTIwaW4lMjBtZXNzYWdlJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGZvciUyMHRvb2xfY2FsbCUyMGluJTIwbWVzc2FnZSU1Qid0b29sX2NhbGxzJyU1RCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDdG9vbF9jYWxsJTNFJyUyMCUyQiUyMHRvb2xfY2FsbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlMkIlMjB0b29sX2NhbGwlNUInZnVuY3Rpb24nJTVEJTVCJ2FyZ3VtZW50cyclNUQlN0N0b2pzb24lMjAlMkIlMjAnJTVDbiUzQyUyRnRvb2xfY2FsbCUzRSclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;assistant&#x27; and &#x27;tool_calls&#x27; in message %}
    {%- for tool_call in message[&#x27;tool_calls&#x27;] %}
            {{- &#x27;&lt;tool_call&gt;&#x27; + tool_call[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; + tool_call[&#x27;function&#x27;][&#x27;arguments&#x27;]|tojson + &#x27;\\n&lt;/tool_call&gt;&#x27; }}
        {%- endif %}
    {%- endfor %}
{%- endif %}`,wrap:!1}}),es=new j({props:{title:"Tool responses",local:"tool-responses",headingTag:"h4"}}),ss=new J({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnRvb2wlMjIlMkMlMEElMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMzAlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tool&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;30&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ns=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd0b29sJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAlMjIlM0N0b29sX3Jlc3VsdCUzRSUyMiUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAlMjIlM0MlMkZ0b29sX3Jlc3VsdCUzRSUyMiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;tool&#x27; %}
    {{- &quot;&lt;tool_result&gt;&quot; + message[&#x27;content&#x27;] + &quot;&lt;/tool_result&gt;&quot; }}
{%- endif %}`,wrap:!1}}),is=new aM({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){d=o("meta"),U=a(),h=o("p"),T=a(),M(C.$$.fragment),I=a(),M(g.$$.fragment),G=a(),f=o("p"),f.innerHTML=$,w=a(),x=o("p"),x.innerHTML=zo,Ms=a(),_=o("p"),_.innerHTML=Eo,rs=a(),M(S.$$.fragment),ys=a(),z=o("p"),z.innerHTML=Xo,cs=a(),E=o("p"),E.innerHTML=Ho,us=a(),M(X.$$.fragment),ms=a(),H=o("p"),H.innerHTML=Yo,ds=a(),M(Y.$$.fragment),hs=a(),F=o("p"),F.innerHTML=Fo,Js=a(),M(L.$$.fragment),Ts=a(),D=o("p"),D.innerHTML=Lo,Us=a(),M(P.$$.fragment),js=a(),K=o("p"),K.textContent=Do,ws=a(),M(O.$$.fragment),fs=a(),tt=o("p"),tt.textContent=Po,Is=a(),M(et.$$.fragment),gs=a(),lt=o("p"),lt.textContent=Ko,bs=a(),M(st.$$.fragment),Cs=a(),M(at.$$.fragment),xs=a(),nt=o("p"),nt.innerHTML=Oo,$s=a(),ot=o("p"),ot.innerHTML=ti,Gs=a(),M(it.$$.fragment),vs=a(),pt=o("p"),pt.innerHTML=ei,Bs=a(),M(Mt.$$.fragment),Ns=a(),rt=o("p"),rt.textContent=li,Zs=a(),M(yt.$$.fragment),As=a(),ct=o("p"),ct.innerHTML=si,Qs=a(),M(ut.$$.fragment),ks=a(),M(mt.$$.fragment),qs=a(),dt=o("p"),dt.innerHTML=ai,Ws=a(),M(ht.$$.fragment),Vs=a(),Jt=o("p"),Jt.innerHTML=ni,Rs=a(),M(Tt.$$.fragment),_s=a(),Ut=o("p"),Ut.textContent=oi,Ss=a(),M(jt.$$.fragment),zs=a(),wt=o("p"),wt.innerHTML=ii,Es=a(),M(ft.$$.fragment),Xs=a(),It=o("p"),It.textContent=pi,Hs=a(),gt=o("p"),gt.innerHTML=Mi,Ys=a(),M(bt.$$.fragment),Fs=a(),Ct=o("p"),Ct.innerHTML=ri,Ls=a(),xt=o("p"),xt.textContent=yi,Ds=a(),M($t.$$.fragment),Ps=a(),Gt=o("p"),Gt.textContent=ci,Ks=a(),vt=o("p"),vt.innerHTML=ui,Os=a(),M(B.$$.fragment),ta=a(),M(Bt.$$.fragment),ea=a(),Nt=o("p"),Nt.innerHTML=mi,la=a(),M(Zt.$$.fragment),sa=a(),At=o("p"),At.textContent=di,aa=a(),M(Qt.$$.fragment),na=a(),kt=o("p"),kt.innerHTML=hi,oa=a(),M(N.$$.fragment),ia=a(),M(qt.$$.fragment),pa=a(),Wt=o("p"),Wt.innerHTML=Ji,Ma=a(),Vt=o("p"),Vt.textContent=Ti,ra=a(),M(Rt.$$.fragment),ya=a(),_t=o("p"),_t.innerHTML=Ui,ca=a(),M(St.$$.fragment),ua=a(),zt=o("p"),zt.textContent=ji,ma=a(),Et=o("ul"),Et.innerHTML=wi,da=a(),M(Xt.$$.fragment),ha=a(),Ht=o("p"),Ht.textContent=fi,Ja=a(),Yt=o("ol"),Yt.innerHTML=Ii,Ta=a(),M(Ft.$$.fragment),Ua=a(),Lt=o("p"),Lt.innerHTML=gi,ja=a(),Dt=o("p"),Dt.textContent=bi,wa=a(),M(Pt.$$.fragment),fa=a(),Kt=o("p"),Kt.textContent=Ci,Ia=a(),M(Ot.$$.fragment),ga=a(),te=o("p"),te.textContent=xi,ba=a(),M(ee.$$.fragment),Ca=a(),le=o("p"),le.textContent=$i,xa=a(),M(se.$$.fragment),$a=a(),ae=o("p"),ae.textContent=Gi,Ga=a(),M(ne.$$.fragment),va=a(),oe=o("p"),oe.textContent=vi,Ba=a(),M(Z.$$.fragment),Na=a(),ie=o("p"),ie.textContent=Bi,Za=a(),M(pe.$$.fragment),Aa=a(),M(A.$$.fragment),Qa=a(),Me=o("p"),Me.textContent=Ni,ka=a(),M(re.$$.fragment),qa=a(),M(Q.$$.fragment),Wa=a(),ye=o("p"),ye.textContent=Zi,Va=a(),M(ce.$$.fragment),Ra=a(),ue=o("p"),ue.textContent=Ai,_a=a(),M(me.$$.fragment),Sa=a(),de=o("p"),de.textContent=Qi,za=a(),M(he.$$.fragment),Ea=a(),Je=o("p"),Je.innerHTML=ki,Xa=a(),Te=o("p"),Te.textContent=qi,Ha=a(),M(Ue.$$.fragment),Ya=a(),je=o("p"),je.textContent=Wi,Fa=a(),M(we.$$.fragment),La=a(),fe=o("p"),fe.innerHTML=Vi,Da=a(),Ie=o("p"),Ie.innerHTML=Ri,Pa=a(),M(ge.$$.fragment),Ka=a(),M(be.$$.fragment),Oa=a(),Ce=o("p"),Ce.innerHTML=_i,tn=a(),xe=o("p"),xe.textContent=Si,en=a(),M($e.$$.fragment),ln=a(),M(k.$$.fragment),sn=a(),M(Ge.$$.fragment),an=a(),ve=o("p"),ve.innerHTML=zi,nn=a(),M(Be.$$.fragment),on=a(),Ne=o("p"),Ne.innerHTML=Ei,pn=a(),M(Ze.$$.fragment),Mn=a(),Ae=o("p"),Ae.textContent=Xi,rn=a(),Qe=o("ol"),Qe.innerHTML=Hi,yn=a(),ke=o("p"),ke.textContent=Yi,cn=a(),M(qe.$$.fragment),un=a(),We=o("p"),We.innerHTML=Fi,mn=a(),M(Ve.$$.fragment),dn=a(),M(Re.$$.fragment),hn=a(),_e=o("p"),_e.innerHTML=Li,Jn=a(),M(Se.$$.fragment),Tn=a(),ze=o("p"),ze.innerHTML=Di,Un=a(),M(Ee.$$.fragment),jn=a(),Xe=o("p"),Xe.innerHTML=Pi,wn=a(),M(q.$$.fragment),fn=a(),M(He.$$.fragment),In=a(),Ye=o("p"),Ye.innerHTML=Ki,gn=a(),Fe=o("p"),Fe.innerHTML=Oi,bn=a(),Le=o("p"),Le.textContent=tp,Cn=a(),M(De.$$.fragment),xn=a(),Pe=o("p"),Pe.textContent=ep,$n=a(),Ke=o("p"),Ke.innerHTML=lp,Gn=a(),M(Oe.$$.fragment),vn=a(),tl=o("p"),tl.innerHTML=sp,Bn=a(),M(el.$$.fragment),Nn=a(),ll=o("p"),ll.innerHTML=ap,Zn=a(),M(sl.$$.fragment),An=a(),al=o("p"),al.innerHTML=np,Qn=a(),M(nl.$$.fragment),kn=a(),ol=o("p"),ol.innerHTML=op,qn=a(),il=o("p"),il.innerHTML=ip,Wn=a(),pl=o("p"),pl.textContent=pp,Vn=a(),M(Ml.$$.fragment),Rn=a(),M(W.$$.fragment),_n=a(),rl=o("p"),rl.innerHTML=Mp,Sn=a(),yl=o("p"),yl.textContent=rp,zn=a(),M(cl.$$.fragment),En=a(),ul=o("p"),ul.textContent=yp,Xn=a(),M(ml.$$.fragment),Hn=a(),dl=o("p"),dl.textContent=cp,Yn=a(),M(hl.$$.fragment),Fn=a(),Jl=o("p"),Jl.innerHTML=up,Ln=a(),M(Tl.$$.fragment),Dn=a(),Ul=o("p"),Ul.innerHTML=mp,Pn=a(),jl=o("ul"),jl.innerHTML=dp,Kn=a(),M(V.$$.fragment),On=a(),M(wl.$$.fragment),to=a(),fl=o("p"),fl.textContent=hp,eo=a(),Il=o("ul"),Il.innerHTML=Jp,lo=a(),M(gl.$$.fragment),so=a(),bl=o("p"),bl.innerHTML=Tp,ao=a(),Cl=o("p"),Cl.textContent=Up,no=a(),xl=o("ul"),xl.innerHTML=jp,oo=a(),M($l.$$.fragment),io=a(),Gl=o("p"),Gl.innerHTML=wp,po=a(),vl=o("p"),vl.textContent=fp,Mo=a(),M(Bl.$$.fragment),ro=a(),Nl=o("p"),Nl.innerHTML=Ip,yo=a(),Zl=o("p"),Zl.textContent=gp,co=a(),M(Al.$$.fragment),uo=a(),Ql=o("p"),Ql.textContent=bp,mo=a(),M(kl.$$.fragment),ho=a(),ql=o("p"),ql.textContent=Cp,Jo=a(),M(Wl.$$.fragment),To=a(),Vl=o("p"),Vl.textContent=xp,Uo=a(),M(Rl.$$.fragment),jo=a(),_l=o("p"),_l.textContent=$p,wo=a(),Sl=o("p"),Sl.textContent=Gp,fo=a(),M(zl.$$.fragment),Io=a(),El=o("p"),El.innerHTML=vp,go=a(),M(Xl.$$.fragment),bo=a(),Hl=o("p"),Hl.textContent=Bp,Co=a(),M(Yl.$$.fragment),xo=a(),Fl=o("p"),Fl.innerHTML=Np,$o=a(),M(Ll.$$.fragment),Go=a(),Dl=o("p"),Dl.innerHTML=Zp,vo=a(),M(Pl.$$.fragment),Bo=a(),Kl=o("p"),Kl.textContent=Ap,No=a(),M(Ol.$$.fragment),Zo=a(),ts=o("p"),ts.textContent=Qp,Ao=a(),M(es.$$.fragment),Qo=a(),ls=o("p"),ls.textContent=kp,ko=a(),M(ss.$$.fragment),qo=a(),as=o("p"),as.textContent=qp,Wo=a(),M(ns.$$.fragment),Vo=a(),os=o("p"),os.textContent=Wp,Ro=a(),M(is.$$.fragment),_o=a(),ps=o("p"),this.h()},l(t){const e=tM("svelte-u9bgzb",document.head);d=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(t),h=i(t,"P",{}),Fp(h).forEach(l),T=n(t),r(C.$$.fragment,t),I=n(t),r(g.$$.fragment,t),G=n(t),f=i(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ydi30o"&&(f.innerHTML=$),w=n(t),x=i(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-11uv7hj"&&(x.innerHTML=zo),Ms=n(t),_=i(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-19ob0qf"&&(_.innerHTML=Eo),rs=n(t),r(S.$$.fragment,t),ys=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-gwj0xd"&&(z.innerHTML=Xo),cs=n(t),E=i(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-14wqu22"&&(E.innerHTML=Ho),us=n(t),r(X.$$.fragment,t),ms=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1010uaq"&&(H.innerHTML=Yo),ds=n(t),r(Y.$$.fragment,t),hs=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1tiyfu1"&&(F.innerHTML=Fo),Js=n(t),r(L.$$.fragment,t),Ts=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vun9x2"&&(D.innerHTML=Lo),Us=n(t),r(P.$$.fragment,t),js=n(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1vy7akj"&&(K.textContent=Do),ws=n(t),r(O.$$.fragment,t),fs=n(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-hj60o5"&&(tt.textContent=Po),Is=n(t),r(et.$$.fragment,t),gs=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1bfcqd3"&&(lt.textContent=Ko),bs=n(t),r(st.$$.fragment,t),Cs=n(t),r(at.$$.fragment,t),xs=n(t),nt=i(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1m6eey2"&&(nt.innerHTML=Oo),$s=n(t),ot=i(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-dcxo7r"&&(ot.innerHTML=ti),Gs=n(t),r(it.$$.fragment,t),vs=n(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-j2ygyn"&&(pt.innerHTML=ei),Bs=n(t),r(Mt.$$.fragment,t),Ns=n(t),rt=i(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-k9m2iy"&&(rt.textContent=li),Zs=n(t),r(yt.$$.fragment,t),As=n(t),ct=i(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-znnkjx"&&(ct.innerHTML=si),Qs=n(t),r(ut.$$.fragment,t),ks=n(t),r(mt.$$.fragment,t),qs=n(t),dt=i(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-5umvde"&&(dt.innerHTML=ai),Ws=n(t),r(ht.$$.fragment,t),Vs=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-rhnu79"&&(Jt.innerHTML=ni),Rs=n(t),r(Tt.$$.fragment,t),_s=n(t),Ut=i(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-jpbe39"&&(Ut.textContent=oi),Ss=n(t),r(jt.$$.fragment,t),zs=n(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-61bp3d"&&(wt.innerHTML=ii),Es=n(t),r(ft.$$.fragment,t),Xs=n(t),It=i(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-inq88f"&&(It.textContent=pi),Hs=n(t),gt=i(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-uz30n4"&&(gt.innerHTML=Mi),Ys=n(t),r(bt.$$.fragment,t),Fs=n(t),Ct=i(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-y1327w"&&(Ct.innerHTML=ri),Ls=n(t),xt=i(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-wwwyth"&&(xt.textContent=yi),Ds=n(t),r($t.$$.fragment,t),Ps=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-j6m3wj"&&(Gt.textContent=ci),Ks=n(t),vt=i(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-hfpwig"&&(vt.innerHTML=ui),Os=n(t),r(B.$$.fragment,t),ta=n(t),r(Bt.$$.fragment,t),ea=n(t),Nt=i(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-i3l9c1"&&(Nt.innerHTML=mi),la=n(t),r(Zt.$$.fragment,t),sa=n(t),At=i(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-13505nn"&&(At.textContent=di),aa=n(t),r(Qt.$$.fragment,t),na=n(t),kt=i(t,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-ziuqkt"&&(kt.innerHTML=hi),oa=n(t),r(N.$$.fragment,t),ia=n(t),r(qt.$$.fragment,t),pa=n(t),Wt=i(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-dd615e"&&(Wt.innerHTML=Ji),Ma=n(t),Vt=i(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-dcun4m"&&(Vt.textContent=Ti),ra=n(t),r(Rt.$$.fragment,t),ya=n(t),_t=i(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-6sd0wq"&&(_t.innerHTML=Ui),ca=n(t),r(St.$$.fragment,t),ua=n(t),zt=i(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-608o9m"&&(zt.textContent=ji),ma=n(t),Et=i(t,"UL",{"data-svelte-h":!0}),p(Et)!=="svelte-n1b3zm"&&(Et.innerHTML=wi),da=n(t),r(Xt.$$.fragment,t),ha=n(t),Ht=i(t,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-11962fa"&&(Ht.textContent=fi),Ja=n(t),Yt=i(t,"OL",{"data-svelte-h":!0}),p(Yt)!=="svelte-1vd84s7"&&(Yt.innerHTML=Ii),Ta=n(t),r(Ft.$$.fragment,t),Ua=n(t),Lt=i(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1oi0gsn"&&(Lt.innerHTML=gi),ja=n(t),Dt=i(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-o8n6v4"&&(Dt.textContent=bi),wa=n(t),r(Pt.$$.fragment,t),fa=n(t),Kt=i(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1q7358y"&&(Kt.textContent=Ci),Ia=n(t),r(Ot.$$.fragment,t),ga=n(t),te=i(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-11hfyaa"&&(te.textContent=xi),ba=n(t),r(ee.$$.fragment,t),Ca=n(t),le=i(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1usrd3e"&&(le.textContent=$i),xa=n(t),r(se.$$.fragment,t),$a=n(t),ae=i(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-13505nn"&&(ae.textContent=Gi),Ga=n(t),r(ne.$$.fragment,t),va=n(t),oe=i(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-nxltbo"&&(oe.textContent=vi),Ba=n(t),r(Z.$$.fragment,t),Na=n(t),ie=i(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-336ooj"&&(ie.textContent=Bi),Za=n(t),r(pe.$$.fragment,t),Aa=n(t),r(A.$$.fragment,t),Qa=n(t),Me=i(t,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1mv1vl9"&&(Me.textContent=Ni),ka=n(t),r(re.$$.fragment,t),qa=n(t),r(Q.$$.fragment,t),Wa=n(t),ye=i(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1qjybqz"&&(ye.textContent=Zi),Va=n(t),r(ce.$$.fragment,t),Ra=n(t),ue=i(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-13505nn"&&(ue.textContent=Ai),_a=n(t),r(me.$$.fragment,t),Sa=n(t),de=i(t,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1evxmus"&&(de.textContent=Qi),za=n(t),r(he.$$.fragment,t),Ea=n(t),Je=i(t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-pl4mbs"&&(Je.innerHTML=ki),Xa=n(t),Te=i(t,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-37xmdz"&&(Te.textContent=qi),Ha=n(t),r(Ue.$$.fragment,t),Ya=n(t),je=i(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1bfcqd3"&&(je.textContent=Wi),Fa=n(t),r(we.$$.fragment,t),La=n(t),fe=i(t,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-19t6fs5"&&(fe.innerHTML=Vi),Da=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1nlyrys"&&(Ie.innerHTML=Ri),Pa=n(t),r(ge.$$.fragment,t),Ka=n(t),r(be.$$.fragment,t),Oa=n(t),Ce=i(t,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1977j4z"&&(Ce.innerHTML=_i),tn=n(t),xe=i(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1xmnzcc"&&(xe.textContent=Si),en=n(t),r($e.$$.fragment,t),ln=n(t),r(k.$$.fragment,t),sn=n(t),r(Ge.$$.fragment,t),an=n(t),ve=i(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-lanz4l"&&(ve.innerHTML=zi),nn=n(t),r(Be.$$.fragment,t),on=n(t),Ne=i(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-zet1qo"&&(Ne.innerHTML=Ei),pn=n(t),r(Ze.$$.fragment,t),Mn=n(t),Ae=i(t,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-9bdwn1"&&(Ae.textContent=Xi),rn=n(t),Qe=i(t,"OL",{"data-svelte-h":!0}),p(Qe)!=="svelte-1ax9ke1"&&(Qe.innerHTML=Hi),yn=n(t),ke=i(t,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-4zn2hx"&&(ke.textContent=Yi),cn=n(t),r(qe.$$.fragment,t),un=n(t),We=i(t,"P",{"data-svelte-h":!0}),p(We)!=="svelte-prz4we"&&(We.innerHTML=Fi),mn=n(t),r(Ve.$$.fragment,t),dn=n(t),r(Re.$$.fragment,t),hn=n(t),_e=i(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1ubxgh9"&&(_e.innerHTML=Li),Jn=n(t),r(Se.$$.fragment,t),Tn=n(t),ze=i(t,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-t74z56"&&(ze.innerHTML=Di),Un=n(t),r(Ee.$$.fragment,t),jn=n(t),Xe=i(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-pl6d88"&&(Xe.innerHTML=Pi),wn=n(t),r(q.$$.fragment,t),fn=n(t),r(He.$$.fragment,t),In=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1d7cql4"&&(Ye.innerHTML=Ki),gn=n(t),Fe=i(t,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1u88h1j"&&(Fe.innerHTML=Oi),bn=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1g7ri12"&&(Le.textContent=tp),Cn=n(t),r(De.$$.fragment,t),xn=n(t),Pe=i(t,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-5u6sqi"&&(Pe.textContent=ep),$n=n(t),Ke=i(t,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-ffreiw"&&(Ke.innerHTML=lp),Gn=n(t),r(Oe.$$.fragment,t),vn=n(t),tl=i(t,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1cj1ql7"&&(tl.innerHTML=sp),Bn=n(t),r(el.$$.fragment,t),Nn=n(t),ll=i(t,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-soh9qu"&&(ll.innerHTML=ap),Zn=n(t),r(sl.$$.fragment,t),An=n(t),al=i(t,"P",{"data-svelte-h":!0}),p(al)!=="svelte-14p3dvw"&&(al.innerHTML=np),Qn=n(t),r(nl.$$.fragment,t),kn=n(t),ol=i(t,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-12av8vh"&&(ol.innerHTML=op),qn=n(t),il=i(t,"P",{"data-svelte-h":!0}),p(il)!=="svelte-kn2i6o"&&(il.innerHTML=ip),Wn=n(t),pl=i(t,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-197jyne"&&(pl.textContent=pp),Vn=n(t),r(Ml.$$.fragment,t),Rn=n(t),r(W.$$.fragment,t),_n=n(t),rl=i(t,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1eu5v04"&&(rl.innerHTML=Mp),Sn=n(t),yl=i(t,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-10wmjwo"&&(yl.textContent=rp),zn=n(t),r(cl.$$.fragment,t),En=n(t),ul=i(t,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1ttgeg7"&&(ul.textContent=yp),Xn=n(t),r(ml.$$.fragment,t),Hn=n(t),dl=i(t,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-qihux6"&&(dl.textContent=cp),Yn=n(t),r(hl.$$.fragment,t),Fn=n(t),Jl=i(t,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-pefrh0"&&(Jl.innerHTML=up),Ln=n(t),r(Tl.$$.fragment,t),Dn=n(t),Ul=i(t,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1s7e55r"&&(Ul.innerHTML=mp),Pn=n(t),jl=i(t,"UL",{"data-svelte-h":!0}),p(jl)!=="svelte-1rdzqgp"&&(jl.innerHTML=dp),Kn=n(t),r(V.$$.fragment,t),On=n(t),r(wl.$$.fragment,t),to=n(t),fl=i(t,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-w29vry"&&(fl.textContent=hp),eo=n(t),Il=i(t,"UL",{"data-svelte-h":!0}),p(Il)!=="svelte-1fmzhdy"&&(Il.innerHTML=Jp),lo=n(t),r(gl.$$.fragment,t),so=n(t),bl=i(t,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-jvvtjt"&&(bl.innerHTML=Tp),ao=n(t),Cl=i(t,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-f0ucf0"&&(Cl.textContent=Up),no=n(t),xl=i(t,"UL",{"data-svelte-h":!0}),p(xl)!=="svelte-doa6oc"&&(xl.innerHTML=jp),oo=n(t),r($l.$$.fragment,t),io=n(t),Gl=i(t,"P",{"data-svelte-h":!0}),p(Gl)!=="svelte-13g6lvo"&&(Gl.innerHTML=wp),po=n(t),vl=i(t,"P",{"data-svelte-h":!0}),p(vl)!=="svelte-i5qalm"&&(vl.textContent=fp),Mo=n(t),r(Bl.$$.fragment,t),ro=n(t),Nl=i(t,"P",{"data-svelte-h":!0}),p(Nl)!=="svelte-148o5ra"&&(Nl.innerHTML=Ip),yo=n(t),Zl=i(t,"P",{"data-svelte-h":!0}),p(Zl)!=="svelte-17es6d5"&&(Zl.textContent=gp),co=n(t),r(Al.$$.fragment,t),uo=n(t),Ql=i(t,"P",{"data-svelte-h":!0}),p(Ql)!=="svelte-180ap61"&&(Ql.textContent=bp),mo=n(t),r(kl.$$.fragment,t),ho=n(t),ql=i(t,"P",{"data-svelte-h":!0}),p(ql)!=="svelte-1bv602"&&(ql.textContent=Cp),Jo=n(t),r(Wl.$$.fragment,t),To=n(t),Vl=i(t,"P",{"data-svelte-h":!0}),p(Vl)!=="svelte-1mq7g8k"&&(Vl.textContent=xp),Uo=n(t),r(Rl.$$.fragment,t),jo=n(t),_l=i(t,"P",{"data-svelte-h":!0}),p(_l)!=="svelte-kt3iym"&&(_l.textContent=$p),wo=n(t),Sl=i(t,"P",{"data-svelte-h":!0}),p(Sl)!=="svelte-1nlwaki"&&(Sl.textContent=Gp),fo=n(t),r(zl.$$.fragment,t),Io=n(t),El=i(t,"P",{"data-svelte-h":!0}),p(El)!=="svelte-wrq3v1"&&(El.innerHTML=vp),go=n(t),r(Xl.$$.fragment,t),bo=n(t),Hl=i(t,"P",{"data-svelte-h":!0}),p(Hl)!=="svelte-1woymkp"&&(Hl.textContent=Bp),Co=n(t),r(Yl.$$.fragment,t),xo=n(t),Fl=i(t,"P",{"data-svelte-h":!0}),p(Fl)!=="svelte-1vngoc7"&&(Fl.innerHTML=Np),$o=n(t),r(Ll.$$.fragment,t),Go=n(t),Dl=i(t,"P",{"data-svelte-h":!0}),p(Dl)!=="svelte-1x6y95z"&&(Dl.innerHTML=Zp),vo=n(t),r(Pl.$$.fragment,t),Bo=n(t),Kl=i(t,"P",{"data-svelte-h":!0}),p(Kl)!=="svelte-my9opo"&&(Kl.textContent=Ap),No=n(t),r(Ol.$$.fragment,t),Zo=n(t),ts=i(t,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-hsoefm"&&(ts.textContent=Qp),Ao=n(t),r(es.$$.fragment,t),Qo=n(t),ls=i(t,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-1hx88do"&&(ls.textContent=kp),ko=n(t),r(ss.$$.fragment,t),qo=n(t),as=i(t,"P",{"data-svelte-h":!0}),p(as)!=="svelte-1okuuze"&&(as.textContent=qp),Wo=n(t),r(ns.$$.fragment,t),Vo=n(t),os=i(t,"P",{"data-svelte-h":!0}),p(os)!=="svelte-13n2q2c"&&(os.textContent=Wp),Ro=n(t),r(is.$$.fragment,t),_o=n(t),ps=i(t,"P",{}),Fp(ps).forEach(l),this.h()},h(){Lp(d,"name","hf:doc:metadata"),Lp(d,"content",dM)},m(t,e){eM(document.head,d),s(t,U,e),s(t,h,e),s(t,T,e),y(C,t,e),s(t,I,e),y(g,t,e),s(t,G,e),s(t,f,e),s(t,w,e),s(t,x,e),s(t,Ms,e),s(t,_,e),s(t,rs,e),y(S,t,e),s(t,ys,e),s(t,z,e),s(t,cs,e),s(t,E,e),s(t,us,e),y(X,t,e),s(t,ms,e),s(t,H,e),s(t,ds,e),y(Y,t,e),s(t,hs,e),s(t,F,e),s(t,Js,e),y(L,t,e),s(t,Ts,e),s(t,D,e),s(t,Us,e),y(P,t,e),s(t,js,e),s(t,K,e),s(t,ws,e),y(O,t,e),s(t,fs,e),s(t,tt,e),s(t,Is,e),y(et,t,e),s(t,gs,e),s(t,lt,e),s(t,bs,e),y(st,t,e),s(t,Cs,e),y(at,t,e),s(t,xs,e),s(t,nt,e),s(t,$s,e),s(t,ot,e),s(t,Gs,e),y(it,t,e),s(t,vs,e),s(t,pt,e),s(t,Bs,e),y(Mt,t,e),s(t,Ns,e),s(t,rt,e),s(t,Zs,e),y(yt,t,e),s(t,As,e),s(t,ct,e),s(t,Qs,e),y(ut,t,e),s(t,ks,e),y(mt,t,e),s(t,qs,e),s(t,dt,e),s(t,Ws,e),y(ht,t,e),s(t,Vs,e),s(t,Jt,e),s(t,Rs,e),y(Tt,t,e),s(t,_s,e),s(t,Ut,e),s(t,Ss,e),y(jt,t,e),s(t,zs,e),s(t,wt,e),s(t,Es,e),y(ft,t,e),s(t,Xs,e),s(t,It,e),s(t,Hs,e),s(t,gt,e),s(t,Ys,e),y(bt,t,e),s(t,Fs,e),s(t,Ct,e),s(t,Ls,e),s(t,xt,e),s(t,Ds,e),y($t,t,e),s(t,Ps,e),s(t,Gt,e),s(t,Ks,e),s(t,vt,e),s(t,Os,e),y(B,t,e),s(t,ta,e),y(Bt,t,e),s(t,ea,e),s(t,Nt,e),s(t,la,e),y(Zt,t,e),s(t,sa,e),s(t,At,e),s(t,aa,e),y(Qt,t,e),s(t,na,e),s(t,kt,e),s(t,oa,e),y(N,t,e),s(t,ia,e),y(qt,t,e),s(t,pa,e),s(t,Wt,e),s(t,Ma,e),s(t,Vt,e),s(t,ra,e),y(Rt,t,e),s(t,ya,e),s(t,_t,e),s(t,ca,e),y(St,t,e),s(t,ua,e),s(t,zt,e),s(t,ma,e),s(t,Et,e),s(t,da,e),y(Xt,t,e),s(t,ha,e),s(t,Ht,e),s(t,Ja,e),s(t,Yt,e),s(t,Ta,e),y(Ft,t,e),s(t,Ua,e),s(t,Lt,e),s(t,ja,e),s(t,Dt,e),s(t,wa,e),y(Pt,t,e),s(t,fa,e),s(t,Kt,e),s(t,Ia,e),y(Ot,t,e),s(t,ga,e),s(t,te,e),s(t,ba,e),y(ee,t,e),s(t,Ca,e),s(t,le,e),s(t,xa,e),y(se,t,e),s(t,$a,e),s(t,ae,e),s(t,Ga,e),y(ne,t,e),s(t,va,e),s(t,oe,e),s(t,Ba,e),y(Z,t,e),s(t,Na,e),s(t,ie,e),s(t,Za,e),y(pe,t,e),s(t,Aa,e),y(A,t,e),s(t,Qa,e),s(t,Me,e),s(t,ka,e),y(re,t,e),s(t,qa,e),y(Q,t,e),s(t,Wa,e),s(t,ye,e),s(t,Va,e),y(ce,t,e),s(t,Ra,e),s(t,ue,e),s(t,_a,e),y(me,t,e),s(t,Sa,e),s(t,de,e),s(t,za,e),y(he,t,e),s(t,Ea,e),s(t,Je,e),s(t,Xa,e),s(t,Te,e),s(t,Ha,e),y(Ue,t,e),s(t,Ya,e),s(t,je,e),s(t,Fa,e),y(we,t,e),s(t,La,e),s(t,fe,e),s(t,Da,e),s(t,Ie,e),s(t,Pa,e),y(ge,t,e),s(t,Ka,e),y(be,t,e),s(t,Oa,e),s(t,Ce,e),s(t,tn,e),s(t,xe,e),s(t,en,e),y($e,t,e),s(t,ln,e),y(k,t,e),s(t,sn,e),y(Ge,t,e),s(t,an,e),s(t,ve,e),s(t,nn,e),y(Be,t,e),s(t,on,e),s(t,Ne,e),s(t,pn,e),y(Ze,t,e),s(t,Mn,e),s(t,Ae,e),s(t,rn,e),s(t,Qe,e),s(t,yn,e),s(t,ke,e),s(t,cn,e),y(qe,t,e),s(t,un,e),s(t,We,e),s(t,mn,e),y(Ve,t,e),s(t,dn,e),y(Re,t,e),s(t,hn,e),s(t,_e,e),s(t,Jn,e),y(Se,t,e),s(t,Tn,e),s(t,ze,e),s(t,Un,e),y(Ee,t,e),s(t,jn,e),s(t,Xe,e),s(t,wn,e),y(q,t,e),s(t,fn,e),y(He,t,e),s(t,In,e),s(t,Ye,e),s(t,gn,e),s(t,Fe,e),s(t,bn,e),s(t,Le,e),s(t,Cn,e),y(De,t,e),s(t,xn,e),s(t,Pe,e),s(t,$n,e),s(t,Ke,e),s(t,Gn,e),y(Oe,t,e),s(t,vn,e),s(t,tl,e),s(t,Bn,e),y(el,t,e),s(t,Nn,e),s(t,ll,e),s(t,Zn,e),y(sl,t,e),s(t,An,e),s(t,al,e),s(t,Qn,e),y(nl,t,e),s(t,kn,e),s(t,ol,e),s(t,qn,e),s(t,il,e),s(t,Wn,e),s(t,pl,e),s(t,Vn,e),y(Ml,t,e),s(t,Rn,e),y(W,t,e),s(t,_n,e),s(t,rl,e),s(t,Sn,e),s(t,yl,e),s(t,zn,e),y(cl,t,e),s(t,En,e),s(t,ul,e),s(t,Xn,e),y(ml,t,e),s(t,Hn,e),s(t,dl,e),s(t,Yn,e),y(hl,t,e),s(t,Fn,e),s(t,Jl,e),s(t,Ln,e),y(Tl,t,e),s(t,Dn,e),s(t,Ul,e),s(t,Pn,e),s(t,jl,e),s(t,Kn,e),y(V,t,e),s(t,On,e),y(wl,t,e),s(t,to,e),s(t,fl,e),s(t,eo,e),s(t,Il,e),s(t,lo,e),y(gl,t,e),s(t,so,e),s(t,bl,e),s(t,ao,e),s(t,Cl,e),s(t,no,e),s(t,xl,e),s(t,oo,e),y($l,t,e),s(t,io,e),s(t,Gl,e),s(t,po,e),s(t,vl,e),s(t,Mo,e),y(Bl,t,e),s(t,ro,e),s(t,Nl,e),s(t,yo,e),s(t,Zl,e),s(t,co,e),y(Al,t,e),s(t,uo,e),s(t,Ql,e),s(t,mo,e),y(kl,t,e),s(t,ho,e),s(t,ql,e),s(t,Jo,e),y(Wl,t,e),s(t,To,e),s(t,Vl,e),s(t,Uo,e),y(Rl,t,e),s(t,jo,e),s(t,_l,e),s(t,wo,e),s(t,Sl,e),s(t,fo,e),y(zl,t,e),s(t,Io,e),s(t,El,e),s(t,go,e),y(Xl,t,e),s(t,bo,e),s(t,Hl,e),s(t,Co,e),y(Yl,t,e),s(t,xo,e),s(t,Fl,e),s(t,$o,e),y(Ll,t,e),s(t,Go,e),s(t,Dl,e),s(t,vo,e),y(Pl,t,e),s(t,Bo,e),s(t,Kl,e),s(t,No,e),y(Ol,t,e),s(t,Zo,e),s(t,ts,e),s(t,Ao,e),y(es,t,e),s(t,Qo,e),s(t,ls,e),s(t,ko,e),y(ss,t,e),s(t,qo,e),s(t,as,e),s(t,Wo,e),y(ns,t,e),s(t,Vo,e),s(t,os,e),s(t,Ro,e),y(is,t,e),s(t,_o,e),s(t,ps,e),So=!0},p(t,[e]){const Vp={};e&2&&(Vp.$$scope={dirty:e,ctx:t}),B.$set(Vp);const Rp={};e&2&&(Rp.$$scope={dirty:e,ctx:t}),N.$set(Rp);const _p={};e&2&&(_p.$$scope={dirty:e,ctx:t}),Z.$set(_p);const Sp={};e&2&&(Sp.$$scope={dirty:e,ctx:t}),A.$set(Sp);const zp={};e&2&&(zp.$$scope={dirty:e,ctx:t}),Q.$set(zp);const Ep={};e&2&&(Ep.$$scope={dirty:e,ctx:t}),k.$set(Ep);const Xp={};e&2&&(Xp.$$scope={dirty:e,ctx:t}),q.$set(Xp);const Hp={};e&2&&(Hp.$$scope={dirty:e,ctx:t}),W.$set(Hp);const Yp={};e&2&&(Yp.$$scope={dirty:e,ctx:t}),V.$set(Yp)},i(t){So||(c(C.$$.fragment,t),c(g.$$.fragment,t),c(S.$$.fragment,t),c(X.$$.fragment,t),c(Y.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(it.$$.fragment,t),c(Mt.$$.fragment,t),c(yt.$$.fragment,t),c(ut.$$.fragment,t),c(mt.$$.fragment,t),c(ht.$$.fragment,t),c(Tt.$$.fragment,t),c(jt.$$.fragment,t),c(ft.$$.fragment,t),c(bt.$$.fragment,t),c($t.$$.fragment,t),c(B.$$.fragment,t),c(Bt.$$.fragment,t),c(Zt.$$.fragment,t),c(Qt.$$.fragment,t),c(N.$$.fragment,t),c(qt.$$.fragment,t),c(Rt.$$.fragment,t),c(St.$$.fragment,t),c(Xt.$$.fragment,t),c(Ft.$$.fragment,t),c(Pt.$$.fragment,t),c(Ot.$$.fragment,t),c(ee.$$.fragment,t),c(se.$$.fragment,t),c(ne.$$.fragment,t),c(Z.$$.fragment,t),c(pe.$$.fragment,t),c(A.$$.fragment,t),c(re.$$.fragment,t),c(Q.$$.fragment,t),c(ce.$$.fragment,t),c(me.$$.fragment,t),c(he.$$.fragment,t),c(Ue.$$.fragment,t),c(we.$$.fragment,t),c(ge.$$.fragment,t),c(be.$$.fragment,t),c($e.$$.fragment,t),c(k.$$.fragment,t),c(Ge.$$.fragment,t),c(Be.$$.fragment,t),c(Ze.$$.fragment,t),c(qe.$$.fragment,t),c(Ve.$$.fragment,t),c(Re.$$.fragment,t),c(Se.$$.fragment,t),c(Ee.$$.fragment,t),c(q.$$.fragment,t),c(He.$$.fragment,t),c(De.$$.fragment,t),c(Oe.$$.fragment,t),c(el.$$.fragment,t),c(sl.$$.fragment,t),c(nl.$$.fragment,t),c(Ml.$$.fragment,t),c(W.$$.fragment,t),c(cl.$$.fragment,t),c(ml.$$.fragment,t),c(hl.$$.fragment,t),c(Tl.$$.fragment,t),c(V.$$.fragment,t),c(wl.$$.fragment,t),c(gl.$$.fragment,t),c($l.$$.fragment,t),c(Bl.$$.fragment,t),c(Al.$$.fragment,t),c(kl.$$.fragment,t),c(Wl.$$.fragment,t),c(Rl.$$.fragment,t),c(zl.$$.fragment,t),c(Xl.$$.fragment,t),c(Yl.$$.fragment,t),c(Ll.$$.fragment,t),c(Pl.$$.fragment,t),c(Ol.$$.fragment,t),c(es.$$.fragment,t),c(ss.$$.fragment,t),c(ns.$$.fragment,t),c(is.$$.fragment,t),So=!0)},o(t){u(C.$$.fragment,t),u(g.$$.fragment,t),u(S.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(at.$$.fragment,t),u(it.$$.fragment,t),u(Mt.$$.fragment,t),u(yt.$$.fragment,t),u(ut.$$.fragment,t),u(mt.$$.fragment,t),u(ht.$$.fragment,t),u(Tt.$$.fragment,t),u(jt.$$.fragment,t),u(ft.$$.fragment,t),u(bt.$$.fragment,t),u($t.$$.fragment,t),u(B.$$.fragment,t),u(Bt.$$.fragment,t),u(Zt.$$.fragment,t),u(Qt.$$.fragment,t),u(N.$$.fragment,t),u(qt.$$.fragment,t),u(Rt.$$.fragment,t),u(St.$$.fragment,t),u(Xt.$$.fragment,t),u(Ft.$$.fragment,t),u(Pt.$$.fragment,t),u(Ot.$$.fragment,t),u(ee.$$.fragment,t),u(se.$$.fragment,t),u(ne.$$.fragment,t),u(Z.$$.fragment,t),u(pe.$$.fragment,t),u(A.$$.fragment,t),u(re.$$.fragment,t),u(Q.$$.fragment,t),u(ce.$$.fragment,t),u(me.$$.fragment,t),u(he.$$.fragment,t),u(Ue.$$.fragment,t),u(we.$$.fragment,t),u(ge.$$.fragment,t),u(be.$$.fragment,t),u($e.$$.fragment,t),u(k.$$.fragment,t),u(Ge.$$.fragment,t),u(Be.$$.fragment,t),u(Ze.$$.fragment,t),u(qe.$$.fragment,t),u(Ve.$$.fragment,t),u(Re.$$.fragment,t),u(Se.$$.fragment,t),u(Ee.$$.fragment,t),u(q.$$.fragment,t),u(He.$$.fragment,t),u(De.$$.fragment,t),u(Oe.$$.fragment,t),u(el.$$.fragment,t),u(sl.$$.fragment,t),u(nl.$$.fragment,t),u(Ml.$$.fragment,t),u(W.$$.fragment,t),u(cl.$$.fragment,t),u(ml.$$.fragment,t),u(hl.$$.fragment,t),u(Tl.$$.fragment,t),u(V.$$.fragment,t),u(wl.$$.fragment,t),u(gl.$$.fragment,t),u($l.$$.fragment,t),u(Bl.$$.fragment,t),u(Al.$$.fragment,t),u(kl.$$.fragment,t),u(Wl.$$.fragment,t),u(Rl.$$.fragment,t),u(zl.$$.fragment,t),u(Xl.$$.fragment,t),u(Yl.$$.fragment,t),u(Ll.$$.fragment,t),u(Pl.$$.fragment,t),u(Ol.$$.fragment,t),u(es.$$.fragment,t),u(ss.$$.fragment,t),u(ns.$$.fragment,t),u(is.$$.fragment,t),So=!1},d(t){t&&(l(U),l(h),l(T),l(I),l(G),l(f),l(w),l(x),l(Ms),l(_),l(rs),l(ys),l(z),l(cs),l(E),l(us),l(ms),l(H),l(ds),l(hs),l(F),l(Js),l(Ts),l(D),l(Us),l(js),l(K),l(ws),l(fs),l(tt),l(Is),l(gs),l(lt),l(bs),l(Cs),l(xs),l(nt),l($s),l(ot),l(Gs),l(vs),l(pt),l(Bs),l(Ns),l(rt),l(Zs),l(As),l(ct),l(Qs),l(ks),l(qs),l(dt),l(Ws),l(Vs),l(Jt),l(Rs),l(_s),l(Ut),l(Ss),l(zs),l(wt),l(Es),l(Xs),l(It),l(Hs),l(gt),l(Ys),l(Fs),l(Ct),l(Ls),l(xt),l(Ds),l(Ps),l(Gt),l(Ks),l(vt),l(Os),l(ta),l(ea),l(Nt),l(la),l(sa),l(At),l(aa),l(na),l(kt),l(oa),l(ia),l(pa),l(Wt),l(Ma),l(Vt),l(ra),l(ya),l(_t),l(ca),l(ua),l(zt),l(ma),l(Et),l(da),l(ha),l(Ht),l(Ja),l(Yt),l(Ta),l(Ua),l(Lt),l(ja),l(Dt),l(wa),l(fa),l(Kt),l(Ia),l(ga),l(te),l(ba),l(Ca),l(le),l(xa),l($a),l(ae),l(Ga),l(va),l(oe),l(Ba),l(Na),l(ie),l(Za),l(Aa),l(Qa),l(Me),l(ka),l(qa),l(Wa),l(ye),l(Va),l(Ra),l(ue),l(_a),l(Sa),l(de),l(za),l(Ea),l(Je),l(Xa),l(Te),l(Ha),l(Ya),l(je),l(Fa),l(La),l(fe),l(Da),l(Ie),l(Pa),l(Ka),l(Oa),l(Ce),l(tn),l(xe),l(en),l(ln),l(sn),l(an),l(ve),l(nn),l(on),l(Ne),l(pn),l(Mn),l(Ae),l(rn),l(Qe),l(yn),l(ke),l(cn),l(un),l(We),l(mn),l(dn),l(hn),l(_e),l(Jn),l(Tn),l(ze),l(Un),l(jn),l(Xe),l(wn),l(fn),l(In),l(Ye),l(gn),l(Fe),l(bn),l(Le),l(Cn),l(xn),l(Pe),l($n),l(Ke),l(Gn),l(vn),l(tl),l(Bn),l(Nn),l(ll),l(Zn),l(An),l(al),l(Qn),l(kn),l(ol),l(qn),l(il),l(Wn),l(pl),l(Vn),l(Rn),l(_n),l(rl),l(Sn),l(yl),l(zn),l(En),l(ul),l(Xn),l(Hn),l(dl),l(Yn),l(Fn),l(Jl),l(Ln),l(Dn),l(Ul),l(Pn),l(jl),l(Kn),l(On),l(to),l(fl),l(eo),l(Il),l(lo),l(so),l(bl),l(ao),l(Cl),l(no),l(xl),l(oo),l(io),l(Gl),l(po),l(vl),l(Mo),l(ro),l(Nl),l(yo),l(Zl),l(co),l(uo),l(Ql),l(mo),l(ho),l(ql),l(Jo),l(To),l(Vl),l(Uo),l(jo),l(_l),l(wo),l(Sl),l(fo),l(Io),l(El),l(go),l(bo),l(Hl),l(Co),l(xo),l(Fl),l($o),l(Go),l(Dl),l(vo),l(Bo),l(Kl),l(No),l(Zo),l(ts),l(Ao),l(Qo),l(ls),l(ko),l(qo),l(as),l(Wo),l(Vo),l(os),l(Ro),l(_o),l(ps)),l(d),m(C,t),m(g,t),m(S,t),m(X,t),m(Y,t),m(L,t),m(P,t),m(O,t),m(et,t),m(st,t),m(at,t),m(it,t),m(Mt,t),m(yt,t),m(ut,t),m(mt,t),m(ht,t),m(Tt,t),m(jt,t),m(ft,t),m(bt,t),m($t,t),m(B,t),m(Bt,t),m(Zt,t),m(Qt,t),m(N,t),m(qt,t),m(Rt,t),m(St,t),m(Xt,t),m(Ft,t),m(Pt,t),m(Ot,t),m(ee,t),m(se,t),m(ne,t),m(Z,t),m(pe,t),m(A,t),m(re,t),m(Q,t),m(ce,t),m(me,t),m(he,t),m(Ue,t),m(we,t),m(ge,t),m(be,t),m($e,t),m(k,t),m(Ge,t),m(Be,t),m(Ze,t),m(qe,t),m(Ve,t),m(Re,t),m(Se,t),m(Ee,t),m(q,t),m(He,t),m(De,t),m(Oe,t),m(el,t),m(sl,t),m(nl,t),m(Ml,t),m(W,t),m(cl,t),m(ml,t),m(hl,t),m(Tl,t),m(V,t),m(wl,t),m(gl,t),m($l,t),m(Bl,t),m(Al,t),m(kl,t),m(Wl,t),m(Rl,t),m(zl,t),m(Xl,t),m(Yl,t),m(Ll,t),m(Pl,t),m(Ol,t),m(es,t),m(ss,t),m(ns,t),m(is,t)}}}const dM='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Usage with text-only LLMs","local":"usage-with-text-only-llms","sections":[],"depth":2},{"title":"Usage with multimodal LLMs","local":"usage-with-multimodal-llms","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"What does “continue_final_message” do?","local":"what-does-continuefinalmessage-do","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing generation prompts","local":"writing-generation-prompts","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3},{"title":"Writing templates for tools","local":"writing-templates-for-tools","sections":[{"title":"Tool definitions","local":"tool-definitions","sections":[],"depth":4},{"title":"Tool calls","local":"tool-calls","sections":[],"depth":4},{"title":"Tool responses","local":"tool-responses","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function hM(b){return Pp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fM extends Kp{constructor(d){super(),Op(this,d,hM,mM,Dp,{})}}export{fM as component};
