import{s as ko,o as xo,n as Me}from"../chunks/scheduler.25b97de1.js";import{S as $o,i as Co,g as h,s as a,r as m,A as zo,h as p,f as n,c as r,j as G,u as f,x as v,k as J,y as l,a as i,v as g,d as _,t as y,w as b}from"../chunks/index.d9030fc9.js";import{T as wo}from"../chunks/Tip.baa67368.js";import{D as de}from"../chunks/Docstring.ffac8efa.js";import{C as so}from"../chunks/CodeBlock.e6cd0d95.js";import{E as to}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as be,E as Fo}from"../chunks/EditOnGithub.91d95064.js";function qo(z){let t,M="Example:",d,c,u;return c=new so({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vb25zaGluZU1vZGVsJTJDJTIwTW9vbnNoaW5lQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1vb25zaGluZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb29uc2hpbmVDb25maWcoKS5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS10aW55JTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNb29uc2hpbmVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoonshineModel, MoonshineConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Moonshine style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoonshineConfig().from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=h("p"),t.textContent=M,d=a(),m(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=M),d=r(s),f(c.$$.fragment,s)},m(s,T){i(s,t,T),i(s,d,T),g(c,s,T),u=!0},p:Me,i(s){u||(_(c.$$.fragment,s),u=!0)},o(s){y(c.$$.fragment,s),u=!1},d(s){s&&(n(t),n(d)),b(c,s)}}}function Uo(z){let t,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=M},l(d){t=p(d,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=M)},m(d,c){i(d,t,c)},p:Me,d(d){d&&n(t)}}}function jo(z){let t,M="Example:",d,c,u;return c=new so({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBNb29uc2hpbmVNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQW1vZGVsJTIwJTNEJTIwTW9vbnNoaW5lTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtdGlueSUyMiklMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJVc2VmdWxTZW5zb3JzJTJGbW9vbnNoaW5lLXRpbnklMjIpJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMGlucHV0cy5pbnB1dF92YWx1ZXMlMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUIxJTJDJTIwMSU1RCU1RCklMjAqJTIwbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, MoonshineModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineModel.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = torch.tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]) * model.config.decoder_start_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = model(input_values, decoder_input_ids=decoder_input_ids).last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">288</span>]`,wrap:!1}}),{c(){t=h("p"),t.textContent=M,d=a(),m(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=M),d=r(s),f(c.$$.fragment,s)},m(s,T){i(s,t,T),i(s,d,T),g(c,s,T),u=!0},p:Me,i(s){u||(_(c.$$.fragment,s),u=!0)},o(s){y(c.$$.fragment,s),u=!1},d(s){s&&(n(t),n(d)),b(c,s)}}}function Go(z){let t,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=M},l(d){t=p(d,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=M)},m(d,c){i(d,t,c)},p:Me,d(d){d&&n(t)}}}function Jo(z){let t,M="Example:",d,c,u;return c=new so({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtdGlueSUyMiklMEFtb2RlbCUyMCUzRCUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS10aW55JTIyKSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwaW5wdXRzLmlucHV0X3ZhbHVlcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF92YWx1ZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXRyYW5zY3JpcHRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MoonshineForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_values, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
<span class="hljs-string">&#x27;Mr. Quilter is the apostle of the middle classes, and we are glad to welcome his gospel.&#x27;</span>`,wrap:!1}}),{c(){t=h("p"),t.textContent=M,d=a(),m(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=M),d=r(s),f(c.$$.fragment,s)},m(s,T){i(s,t,T),i(s,d,T),g(c,s,T),u=!0},p:Me,i(s){u||(_(c.$$.fragment,s),u=!0)},o(s){y(c.$$.fragment,s),u=!1},d(s){s&&(n(t),n(d)),b(c,s)}}}function Wo(z){let t,M,d,c,u,s,T,Te,V,ao='The Moonshine model was proposed in <a href="https://arxiv.org/abs/2410.15608" rel="nofollow">Moonshine: Speech Recognition for Live Transcription and Voice Commands</a> by Nat Jeffries, Evan King, Manjunath Kudlur, Guy Nicholson, James Wang, Pete Warden.',we,S,ro="The abstract from the paper is the following:",ke,E,io="<em>This paper introduces Moonshine, a family of speech recognition models optimized for live transcription and voice command processing. Moonshine is based on an encoder-decoder transformer architecture and employs Rotary Position Embedding (RoPE) instead of traditional absolute position embeddings. The model is trained on speech segments of various lengths, but without using zero-padding, leading to greater efficiency for the encoder during inference time. When benchmarked against OpenAI’s Whisper tiny-en, Moonshine Tiny demonstrates a 5x reduction in compute requirements for transcribing a 10-second speech segment while incurring no increase in word error rates across standard evaluation datasets. These results highlight Moonshine’s potential for real-time and resource-constrained applications.</em>",xe,H,co="Tips:",$e,X,lo="<li>Moonshine improves upon Whisper’s architecture:<ol><li>It uses SwiGLU activation instead of GELU in the decoder layers</li> <li>Most importantly, it replaces absolute position embeddings with Rotary Position Embeddings (RoPE). This allows Moonshine to handle audio inputs of any length, unlike Whisper which is restricted to fixed 30-second windows.</li></ol></li>",Ce,Q,ho=`This model was contributed by <a href="https://huggingface.co/eustlb" rel="nofollow">Eustache Le Bihan (eustlb)</a>.
The original code can be found <a href="https://github.com/usefulsensors/moonshine" rel="nofollow">here</a>.`,ze,A,Fe,O,po='<li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',qe,B,Ue,x,Y,Re,ce,uo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a>. It is used to instantiate a Moonshine
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Moonshine
<a href="https://huggingface.co/UsefulSensors/moonshine-tiny" rel="nofollow">UsefulSensors/moonshine-tiny</a>.`,Le,le,mo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pe,W,je,D,Ge,w,K,Ve,he,fo=`The bare Moonshine Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Se,pe,go=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ee,F,ee,He,ue,_o='The <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a> forward method, overrides the <code>__call__</code> special method.',Xe,I,Qe,Z,Ae,N,oe,Oe,me,yo=`Masks extracted features along time axis and/or along feature axis according to
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment</a>.`,Je,ne,We,k,te,Be,fe,bo=`The Moonshine Model with a language modeling head. Can be used for automatic speech recognition.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ye,ge,vo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,De,q,se,Ke,_e,Mo='The <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineForConditionalGeneration">MoonshineForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',eo,R,oo,L,no,ye,ae,Ie,re,Ze,ve,Ne;return u=new be({props:{title:"Moonshine",local:"moonshine",headingTag:"h1"}}),T=new be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new be({props:{title:"Resources",local:"resources",headingTag:"h2"}}),B=new be({props:{title:"MoonshineConfig",local:"transformers.MoonshineConfig",headingTag:"h2"}}),Y=new de({props:{name:"class transformers.MoonshineConfig",anchor:"transformers.MoonshineConfig",parameters:[{name:"vocab_size",val:" = 32768"},{name:"hidden_size",val:" = 288"},{name:"intermediate_size",val:" = 1152"},{name:"encoder_num_hidden_layers",val:" = 6"},{name:"decoder_num_hidden_layers",val:" = 6"},{name:"encoder_num_attention_heads",val:" = 8"},{name:"decoder_num_attention_heads",val:" = 8"},{name:"encoder_num_key_value_heads",val:" = None"},{name:"decoder_num_key_value_heads",val:" = None"},{name:"encoder_hidden_act",val:" = 'gelu'"},{name:"decoder_hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 512"},{name:"initializer_range",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 1"},{name:"use_cache",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"partial_rotary_factor",val:" = 0.9"},{name:"is_encoder_decoder",val:" = True"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoonshineConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
Vocabulary size of the Moonshine model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a>.`,name:"vocab_size"},{anchor:"transformers.MoonshineConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 288) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.MoonshineConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1152) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.MoonshineConfig.encoder_num_hidden_layers",description:`<strong>encoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"encoder_num_hidden_layers"},{anchor:"transformers.MoonshineConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.MoonshineConfig.encoder_num_attention_heads",description:`<strong>encoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_num_attention_heads"},{anchor:"transformers.MoonshineConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.MoonshineConfig.encoder_num_key_value_heads",description:`<strong>encoder_num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>encoder_num_key_value_heads=encoder_num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>encoder_num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"encoder_num_key_value_heads"},{anchor:"transformers.MoonshineConfig.decoder_num_key_value_heads",description:`<strong>decoder_num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>decoder_num_key_value_heads=decoder_num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>decoder_num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>decoder_num_attention_heads</code>.`,name:"decoder_num_key_value_heads"},{anchor:"transformers.MoonshineConfig.encoder_hidden_act",description:`<strong>encoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder.`,name:"encoder_hidden_act"},{anchor:"transformers.MoonshineConfig.decoder_hidden_act",description:`<strong>decoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"decoder_hidden_act"},{anchor:"transformers.MoonshineConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.MoonshineConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoonshineConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Corresponds to the &#x201D;&lt;|startoftranscript|&gt;&#x201D; token, which is automatically used when no <code>decoder_input_ids</code>
are provided to the <code>generate</code> function. It is used to guide the model\`s generation process depending on
the task.`,name:"decoder_start_token_id"},{anchor:"transformers.MoonshineConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.MoonshineConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MoonshineConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.MoonshineConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.MoonshineConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.MoonshineConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.MoonshineConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoonshineConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Denotes beginning of sequences token id.`,name:"bos_token_id"},{anchor:"transformers.MoonshineConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Denotes end of sequences token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/configuration_moonshine.py#L25"}}),W=new to({props:{anchor:"transformers.MoonshineConfig.example",$$slots:{default:[qo]},$$scope:{ctx:z}}}),D=new be({props:{title:"MoonshineModel",local:"transformers.MoonshineModel",headingTag:"h2"}}),K=new de({props:{name:"class transformers.MoonshineModel",anchor:"transformers.MoonshineModel",parameters:[{name:"config",val:": MoonshineConfig"}],parametersDescription:[{anchor:"transformers.MoonshineModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig">MoonshineConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1252"}}),ee=new de({props:{name:"forward",anchor:"transformers.MoonshineModel.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.EncoderDecoderCache, typing.Tuple[torch.FloatTensor], NoneType] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_position_ids",val:": typing.Optional[typing.Tuple[torch.LongTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoonshineModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) &#x2014;
Float values of the raw speech waveform. Raw speech waveform can be
obtained by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a
<code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into
<code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> should be used for padding
and conversion into a tensor of type <code>torch.FloatTensor</code>.`,name:"input_values"},{anchor:"transformers.MoonshineModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MoonshineModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"decoder_input_ids"},{anchor:"transformers.MoonshineModel.forward.attention_mask",description:"<strong>attention_mask</strong> (<code>torch.Tensor</code>)<code>, *optional*) -- Moonshine does not support masking of the </code>input_values`, this argument is preserved for compatibility,\nbut it is not used.",name:"attention_mask"},{anchor:"transformers.MoonshineModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_attention_mask"},{anchor:"transformers.MoonshineModel.forward.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"decoder_position_ids"},{anchor:"transformers.MoonshineModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>decoder_input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoonshineModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>decoder_input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MoonshineModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoonshineModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoonshineModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoonshineModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoonshineModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>decoder_position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1327",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig"
>MoonshineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new wo({props:{$$slots:{default:[Uo]},$$scope:{ctx:z}}}),Z=new to({props:{anchor:"transformers.MoonshineModel.forward.example",$$slots:{default:[jo]},$$scope:{ctx:z}}}),oe=new de({props:{name:"_mask_input_features",anchor:"transformers.MoonshineModel._mask_input_features",parameters:[{name:"input_features",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1284"}}),ne=new be({props:{title:"MoonshineForConditionalGeneration",local:"transformers.MoonshineForConditionalGeneration",headingTag:"h2"}}),te=new de({props:{name:"class transformers.MoonshineForConditionalGeneration",anchor:"transformers.MoonshineForConditionalGeneration",parameters:[{name:"config",val:": MoonshineConfig"}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig">MoonshineConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1433"}}),se=new de({props:{name:"forward",anchor:"transformers.MoonshineForConditionalGeneration.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.EncoderDecoderCache, typing.Tuple[torch.FloatTensor], NoneType] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_position_ids",val:": typing.Optional[typing.Tuple[torch.LongTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) &#x2014;
Float values of the raw speech waveform. Raw speech waveform can be
obtained by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a
<code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into
<code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> should be used for padding
and conversion into a tensor of type <code>torch.FloatTensor</code>.`,name:"input_values"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"decoder_input_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.attention_mask",description:"<strong>attention_mask</strong> (<code>torch.Tensor</code>)<code>, *optional*) -- Moonshine does not support masking of the </code>input_values`, this argument is preserved for compatibility,\nbut it is not used.",name:"attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"decoder_position_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>decoder_input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>decoder_input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>decoder_position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code>
or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored (masked), the loss is
only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig"
>MoonshineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new wo({props:{$$slots:{default:[Go]},$$scope:{ctx:z}}}),L=new to({props:{anchor:"transformers.MoonshineForConditionalGeneration.forward.example",$$slots:{default:[Jo]},$$scope:{ctx:z}}}),ae=new de({props:{name:"generate",anchor:"transformers.MoonshineForConditionalGeneration.generate",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1555"}}),re=new Fo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/moonshine.md"}}),{c(){t=h("meta"),M=a(),d=h("p"),c=a(),m(u.$$.fragment),s=a(),m(T.$$.fragment),Te=a(),V=h("p"),V.innerHTML=ao,we=a(),S=h("p"),S.textContent=ro,ke=a(),E=h("p"),E.innerHTML=io,xe=a(),H=h("p"),H.textContent=co,$e=a(),X=h("ul"),X.innerHTML=lo,Ce=a(),Q=h("p"),Q.innerHTML=ho,ze=a(),m(A.$$.fragment),Fe=a(),O=h("ul"),O.innerHTML=po,qe=a(),m(B.$$.fragment),Ue=a(),x=h("div"),m(Y.$$.fragment),Re=a(),ce=h("p"),ce.innerHTML=uo,Le=a(),le=h("p"),le.innerHTML=mo,Pe=a(),m(W.$$.fragment),je=a(),m(D.$$.fragment),Ge=a(),w=h("div"),m(K.$$.fragment),Ve=a(),he=h("p"),he.innerHTML=fo,Se=a(),pe=h("p"),pe.innerHTML=go,Ee=a(),F=h("div"),m(ee.$$.fragment),He=a(),ue=h("p"),ue.innerHTML=_o,Xe=a(),m(I.$$.fragment),Qe=a(),m(Z.$$.fragment),Ae=a(),N=h("div"),m(oe.$$.fragment),Oe=a(),me=h("p"),me.innerHTML=yo,Je=a(),m(ne.$$.fragment),We=a(),k=h("div"),m(te.$$.fragment),Be=a(),fe=h("p"),fe.innerHTML=bo,Ye=a(),ge=h("p"),ge.innerHTML=vo,De=a(),q=h("div"),m(se.$$.fragment),Ke=a(),_e=h("p"),_e.innerHTML=Mo,eo=a(),m(R.$$.fragment),oo=a(),m(L.$$.fragment),no=a(),ye=h("div"),m(ae.$$.fragment),Ie=a(),m(re.$$.fragment),Ze=a(),ve=h("p"),this.h()},l(e){const o=zo("svelte-u9bgzb",document.head);t=p(o,"META",{name:!0,content:!0}),o.forEach(n),M=r(e),d=p(e,"P",{}),G(d).forEach(n),c=r(e),f(u.$$.fragment,e),s=r(e),f(T.$$.fragment,e),Te=r(e),V=p(e,"P",{"data-svelte-h":!0}),v(V)!=="svelte-102gja4"&&(V.innerHTML=ao),we=r(e),S=p(e,"P",{"data-svelte-h":!0}),v(S)!=="svelte-vfdo9a"&&(S.textContent=ro),ke=r(e),E=p(e,"P",{"data-svelte-h":!0}),v(E)!=="svelte-hjmi0f"&&(E.innerHTML=io),xe=r(e),H=p(e,"P",{"data-svelte-h":!0}),v(H)!=="svelte-axv494"&&(H.textContent=co),$e=r(e),X=p(e,"UL",{"data-svelte-h":!0}),v(X)!=="svelte-701nga"&&(X.innerHTML=lo),Ce=r(e),Q=p(e,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-py8twc"&&(Q.innerHTML=ho),ze=r(e),f(A.$$.fragment,e),Fe=r(e),O=p(e,"UL",{"data-svelte-h":!0}),v(O)!=="svelte-c521vh"&&(O.innerHTML=po),qe=r(e),f(B.$$.fragment,e),Ue=r(e),x=p(e,"DIV",{class:!0});var U=G(x);f(Y.$$.fragment,U),Re=r(U),ce=p(U,"P",{"data-svelte-h":!0}),v(ce)!=="svelte-hx4u80"&&(ce.innerHTML=uo),Le=r(U),le=p(U,"P",{"data-svelte-h":!0}),v(le)!=="svelte-o55m63"&&(le.innerHTML=mo),Pe=r(U),f(W.$$.fragment,U),U.forEach(n),je=r(e),f(D.$$.fragment,e),Ge=r(e),w=p(e,"DIV",{class:!0});var $=G(w);f(K.$$.fragment,$),Ve=r($),he=p($,"P",{"data-svelte-h":!0}),v(he)!=="svelte-136j98c"&&(he.innerHTML=fo),Se=r($),pe=p($,"P",{"data-svelte-h":!0}),v(pe)!=="svelte-hswkmf"&&(pe.innerHTML=go),Ee=r($),F=p($,"DIV",{class:!0});var j=G(F);f(ee.$$.fragment,j),He=r(j),ue=p(j,"P",{"data-svelte-h":!0}),v(ue)!=="svelte-1vn92r5"&&(ue.innerHTML=_o),Xe=r(j),f(I.$$.fragment,j),Qe=r(j),f(Z.$$.fragment,j),j.forEach(n),Ae=r($),N=p($,"DIV",{class:!0});var ie=G(N);f(oe.$$.fragment,ie),Oe=r(ie),me=p(ie,"P",{"data-svelte-h":!0}),v(me)!=="svelte-1iyovru"&&(me.innerHTML=yo),ie.forEach(n),$.forEach(n),Je=r(e),f(ne.$$.fragment,e),We=r(e),k=p(e,"DIV",{class:!0});var C=G(k);f(te.$$.fragment,C),Be=r(C),fe=p(C,"P",{"data-svelte-h":!0}),v(fe)!=="svelte-aii2zx"&&(fe.innerHTML=bo),Ye=r(C),ge=p(C,"P",{"data-svelte-h":!0}),v(ge)!=="svelte-hswkmf"&&(ge.innerHTML=vo),De=r(C),q=p(C,"DIV",{class:!0});var P=G(q);f(se.$$.fragment,P),Ke=r(P),_e=p(P,"P",{"data-svelte-h":!0}),v(_e)!=="svelte-n5grur"&&(_e.innerHTML=Mo),eo=r(P),f(R.$$.fragment,P),oo=r(P),f(L.$$.fragment,P),P.forEach(n),no=r(C),ye=p(C,"DIV",{class:!0});var To=G(ye);f(ae.$$.fragment,To),To.forEach(n),C.forEach(n),Ie=r(e),f(re.$$.fragment,e),Ze=r(e),ve=p(e,"P",{}),G(ve).forEach(n),this.h()},h(){J(t,"name","hf:doc:metadata"),J(t,"content",Io),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,t),i(e,M,o),i(e,d,o),i(e,c,o),g(u,e,o),i(e,s,o),g(T,e,o),i(e,Te,o),i(e,V,o),i(e,we,o),i(e,S,o),i(e,ke,o),i(e,E,o),i(e,xe,o),i(e,H,o),i(e,$e,o),i(e,X,o),i(e,Ce,o),i(e,Q,o),i(e,ze,o),g(A,e,o),i(e,Fe,o),i(e,O,o),i(e,qe,o),g(B,e,o),i(e,Ue,o),i(e,x,o),g(Y,x,null),l(x,Re),l(x,ce),l(x,Le),l(x,le),l(x,Pe),g(W,x,null),i(e,je,o),g(D,e,o),i(e,Ge,o),i(e,w,o),g(K,w,null),l(w,Ve),l(w,he),l(w,Se),l(w,pe),l(w,Ee),l(w,F),g(ee,F,null),l(F,He),l(F,ue),l(F,Xe),g(I,F,null),l(F,Qe),g(Z,F,null),l(w,Ae),l(w,N),g(oe,N,null),l(N,Oe),l(N,me),i(e,Je,o),g(ne,e,o),i(e,We,o),i(e,k,o),g(te,k,null),l(k,Be),l(k,fe),l(k,Ye),l(k,ge),l(k,De),l(k,q),g(se,q,null),l(q,Ke),l(q,_e),l(q,eo),g(R,q,null),l(q,oo),g(L,q,null),l(k,no),l(k,ye),g(ae,ye,null),i(e,Ie,o),g(re,e,o),i(e,Ze,o),i(e,ve,o),Ne=!0},p(e,[o]){const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),W.$set(U);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),I.$set($);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),Z.$set(j);const ie={};o&2&&(ie.$$scope={dirty:o,ctx:e}),R.$set(ie);const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),L.$set(C)},i(e){Ne||(_(u.$$.fragment,e),_(T.$$.fragment,e),_(A.$$.fragment,e),_(B.$$.fragment,e),_(Y.$$.fragment,e),_(W.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(I.$$.fragment,e),_(Z.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(R.$$.fragment,e),_(L.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),Ne=!0)},o(e){y(u.$$.fragment,e),y(T.$$.fragment,e),y(A.$$.fragment,e),y(B.$$.fragment,e),y(Y.$$.fragment,e),y(W.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(I.$$.fragment,e),y(Z.$$.fragment,e),y(oe.$$.fragment,e),y(ne.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(R.$$.fragment,e),y(L.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),Ne=!1},d(e){e&&(n(M),n(d),n(c),n(s),n(Te),n(V),n(we),n(S),n(ke),n(E),n(xe),n(H),n($e),n(X),n(Ce),n(Q),n(ze),n(Fe),n(O),n(qe),n(Ue),n(x),n(je),n(Ge),n(w),n(Je),n(We),n(k),n(Ie),n(Ze),n(ve)),n(t),b(u,e),b(T,e),b(A,e),b(B,e),b(Y),b(W),b(D,e),b(K),b(ee),b(I),b(Z),b(oe),b(ne,e),b(te),b(se),b(R),b(L),b(ae),b(re,e)}}}const Io='{"title":"Moonshine","local":"moonshine","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MoonshineConfig","local":"transformers.MoonshineConfig","sections":[],"depth":2},{"title":"MoonshineModel","local":"transformers.MoonshineModel","sections":[],"depth":2},{"title":"MoonshineForConditionalGeneration","local":"transformers.MoonshineForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Zo(z){return xo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ho extends $o{constructor(t){super(),Co(this,t,Zo,Wo,ko,{})}}export{Ho as component};
