import{s as go,f as fo,o as uo,n as Se}from"../chunks/scheduler.25b97de1.js";import{S as _o,i as bo,g as m,s,r as f,A as yo,h as p,f as a,c as r,j as P,u,x as w,k as z,y as i,a as d,v as _,d as b,t as y,w as M}from"../chunks/index.d9030fc9.js";import{T as zt}from"../chunks/Tip.baa67368.js";import{D as H}from"../chunks/Docstring.ffac8efa.js";import{C as ht}from"../chunks/CodeBlock.e6cd0d95.js";import{F as Mo,M as ho}from"../chunks/Markdown.7217f838.js";import{E as wt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{P as To}from"../chunks/PipelineTag.5f100392.js";import{H as he,E as wo}from"../chunks/EditOnGithub.91d95064.js";function vo(j){let t,T="Example:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlaXRDb25maWclMkMlMjBCZWl0TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVpVCUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCZWl0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BeitConfig, BeitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BEiT beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BeitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function $o(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function xo(j){let t,T="Example:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">197</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Bo(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function jo(j){let t,T="Examples:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQobG93JTNEMCUyQyUyMGhpZ2glM0QyJTJDJTIwc2l6ZSUzRCgxJTJDJTIwbnVtX3BhdGNoZXMpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMkMlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMkMlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits = outputs.loss, outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">196</span>, <span class="hljs-number">8192</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Fo(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function Co(j){let t,T="Example:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Io(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function ko(j){let t,T="Examples:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBsb2dpdHMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fbGFiZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># logits are of shape (batch_size, num_labels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Jo(j){let t,T,o,l,v,n,x=`The bare Beit Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Oe,W,Ge,Ke,Y,gt='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a> forward method, overrides the <code>__call__</code> special method.',et,S,pt,ge,oe,qe,Ye,C,Q,Fe,_e,dt=`Beit Model transformer with a ‘language’ modeling head on top. BEiT does masked image modeling by predicting
visual tokens of a Vector-Quantize Variational Autoencoder (VQ-VAE), whereas other vision models like ViT and DeiT
predict RGB pixel values. As a result, this class is incompatible with <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForMaskedImageModeling">AutoModelForMaskedImageModeling</a>, so you
will need to use <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> directly if you wish to do masked image modeling with BEiT.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,be,L,ye,O,Ve,Ce='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',Me,F,ne,Ie,Te,ie,st,N,le,tt,D,ft=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,ot,A,ut=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,nt,U,ke,Je,E,ze='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',We,K,He,Ue,de,ae,we,R,Xe,fe,se,Ze="Beit Model transformer with a semantic segmentation head on top e.g. for ADE20k, CityScapes.",ve,I,Ne=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Pe,X,Le,Ee,$e,ct='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Re,ce,rt,ee,xe;return t=new he({props:{title:"BeitModel",local:"transformers.BeitModel",headingTag:"h2"}}),l=new H({props:{name:"class transformers.BeitModel",anchor:"transformers.BeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.BeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L826"}}),Ge=new H({props:{name:"forward",anchor:"transformers.BeitModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L857",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new zt({props:{$$slots:{default:[$o]},$$scope:{ctx:j}}}),ge=new wt({props:{anchor:"transformers.BeitModel.forward.example",$$slots:{default:[xo]},$$scope:{ctx:j}}}),qe=new he({props:{title:"BeitForMaskedImageModeling",local:"transformers.BeitForMaskedImageModeling",headingTag:"h2"}}),Q=new H({props:{name:"class transformers.BeitForMaskedImageModeling",anchor:"transformers.BeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L941"}}),ye=new H({props:{name:"forward",anchor:"transformers.BeitForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForMaskedImageModeling.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.BeitForMaskedImageModeling.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L962",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new zt({props:{$$slots:{default:[Bo]},$$scope:{ctx:j}}}),Ie=new wt({props:{anchor:"transformers.BeitForMaskedImageModeling.forward.example",$$slots:{default:[jo]},$$scope:{ctx:j}}}),ie=new he({props:{title:"BeitForImageClassification",local:"transformers.BeitForImageClassification",headingTag:"h2"}}),le=new H({props:{name:"class transformers.BeitForImageClassification",anchor:"transformers.BeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1043"}}),ke=new H({props:{name:"forward",anchor:"transformers.BeitForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1063",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new zt({props:{$$slots:{default:[Fo]},$$scope:{ctx:j}}}),Ue=new wt({props:{anchor:"transformers.BeitForImageClassification.forward.example",$$slots:{default:[Co]},$$scope:{ctx:j}}}),ae=new he({props:{title:"BeitForSemanticSegmentation",local:"transformers.BeitForSemanticSegmentation",headingTag:"h2"}}),Xe=new H({props:{name:"class transformers.BeitForSemanticSegmentation",anchor:"transformers.BeitForSemanticSegmentation",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1369"}}),Le=new H({props:{name:"forward",anchor:"transformers.BeitForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForSemanticSegmentation.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1427",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new zt({props:{$$slots:{default:[Io]},$$scope:{ctx:j}}}),ee=new wt({props:{anchor:"transformers.BeitForSemanticSegmentation.forward.example",$$slots:{default:[ko]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment),T=s(),o=m("div"),f(l.$$.fragment),v=s(),n=m("p"),n.innerHTML=x,Oe=s(),W=m("div"),f(Ge.$$.fragment),Ke=s(),Y=m("p"),Y.innerHTML=gt,et=s(),f(S.$$.fragment),pt=s(),f(ge.$$.fragment),oe=s(),f(qe.$$.fragment),Ye=s(),C=m("div"),f(Q.$$.fragment),Fe=s(),_e=m("p"),_e.innerHTML=dt,be=s(),L=m("div"),f(ye.$$.fragment),O=s(),Ve=m("p"),Ve.innerHTML=Ce,Me=s(),f(F.$$.fragment),ne=s(),f(Ie.$$.fragment),Te=s(),f(ie.$$.fragment),st=s(),N=m("div"),f(le.$$.fragment),tt=s(),D=m("p"),D.textContent=ft,ot=s(),A=m("p"),A.innerHTML=ut,nt=s(),U=m("div"),f(ke.$$.fragment),Je=s(),E=m("p"),E.innerHTML=ze,We=s(),f(K.$$.fragment),He=s(),f(Ue.$$.fragment),de=s(),f(ae.$$.fragment),we=s(),R=m("div"),f(Xe.$$.fragment),fe=s(),se=m("p"),se.textContent=Ze,ve=s(),I=m("p"),I.innerHTML=Ne,Pe=s(),X=m("div"),f(Le.$$.fragment),Ee=s(),$e=m("p"),$e.innerHTML=ct,Re=s(),f(ce.$$.fragment),rt=s(),f(ee.$$.fragment),this.h()},l(c){u(t.$$.fragment,c),T=r(c),o=p(c,"DIV",{class:!0});var $=P(o);u(l.$$.fragment,$),v=r($),n=p($,"P",{"data-svelte-h":!0}),w(n)!=="svelte-1wah8ut"&&(n.innerHTML=x),Oe=r($),W=p($,"DIV",{class:!0});var G=P(W);u(Ge.$$.fragment,G),Ke=r(G),Y=p(G,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-bro8jz"&&(Y.innerHTML=gt),et=r(G),u(S.$$.fragment,G),pt=r(G),u(ge.$$.fragment,G),G.forEach(a),$.forEach(a),oe=r(c),u(qe.$$.fragment,c),Ye=r(c),C=p(c,"DIV",{class:!0});var re=P(C);u(Q.$$.fragment,re),Fe=r(re),_e=p(re,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-uq2qy7"&&(_e.innerHTML=dt),be=r(re),L=p(re,"DIV",{class:!0});var me=P(L);u(ye.$$.fragment,me),O=r(me),Ve=p(me,"P",{"data-svelte-h":!0}),w(Ve)!=="svelte-wqewd3"&&(Ve.innerHTML=Ce),Me=r(me),u(F.$$.fragment,me),ne=r(me),u(Ie.$$.fragment,me),me.forEach(a),re.forEach(a),Te=r(c),u(ie.$$.fragment,c),st=r(c),N=p(c,"DIV",{class:!0});var k=P(N);u(le.$$.fragment,k),tt=r(k),D=p(k,"P",{"data-svelte-h":!0}),w(D)!=="svelte-83lcss"&&(D.textContent=ft),ot=r(k),A=p(k,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1gjh92c"&&(A.innerHTML=ut),nt=r(k),U=p(k,"DIV",{class:!0});var J=P(U);u(ke.$$.fragment,J),Je=r(J),E=p(J,"P",{"data-svelte-h":!0}),w(E)!=="svelte-x5dkzj"&&(E.innerHTML=ze),We=r(J),u(K.$$.fragment,J),He=r(J),u(Ue.$$.fragment,J),J.forEach(a),k.forEach(a),de=r(c),u(ae.$$.fragment,c),we=r(c),R=p(c,"DIV",{class:!0});var V=P(R);u(Xe.$$.fragment,V),fe=r(V),se=p(V,"P",{"data-svelte-h":!0}),w(se)!=="svelte-olwnwh"&&(se.textContent=Ze),ve=r(V),I=p(V,"P",{"data-svelte-h":!0}),w(I)!=="svelte-1gjh92c"&&(I.innerHTML=Ne),Pe=r(V),X=p(V,"DIV",{class:!0});var q=P(X);u(Le.$$.fragment,q),Ee=r(q),$e=p(q,"P",{"data-svelte-h":!0}),w($e)!=="svelte-1745vw3"&&($e.innerHTML=ct),Re=r(q),u(ce.$$.fragment,q),rt=r(q),u(ee.$$.fragment,q),q.forEach(a),V.forEach(a),this.h()},h(){z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(c,$){_(t,c,$),d(c,T,$),d(c,o,$),_(l,o,null),i(o,v),i(o,n),i(o,Oe),i(o,W),_(Ge,W,null),i(W,Ke),i(W,Y),i(W,et),_(S,W,null),i(W,pt),_(ge,W,null),d(c,oe,$),_(qe,c,$),d(c,Ye,$),d(c,C,$),_(Q,C,null),i(C,Fe),i(C,_e),i(C,be),i(C,L),_(ye,L,null),i(L,O),i(L,Ve),i(L,Me),_(F,L,null),i(L,ne),_(Ie,L,null),d(c,Te,$),_(ie,c,$),d(c,st,$),d(c,N,$),_(le,N,null),i(N,tt),i(N,D),i(N,ot),i(N,A),i(N,nt),i(N,U),_(ke,U,null),i(U,Je),i(U,E),i(U,We),_(K,U,null),i(U,He),_(Ue,U,null),d(c,de,$),_(ae,c,$),d(c,we,$),d(c,R,$),_(Xe,R,null),i(R,fe),i(R,se),i(R,ve),i(R,I),i(R,Pe),i(R,X),_(Le,X,null),i(X,Ee),i(X,$e),i(X,Re),_(ce,X,null),i(X,rt),_(ee,X,null),xe=!0},p(c,$){const G={};$&2&&(G.$$scope={dirty:$,ctx:c}),S.$set(G);const re={};$&2&&(re.$$scope={dirty:$,ctx:c}),ge.$set(re);const me={};$&2&&(me.$$scope={dirty:$,ctx:c}),F.$set(me);const k={};$&2&&(k.$$scope={dirty:$,ctx:c}),Ie.$set(k);const J={};$&2&&(J.$$scope={dirty:$,ctx:c}),K.$set(J);const V={};$&2&&(V.$$scope={dirty:$,ctx:c}),Ue.$set(V);const q={};$&2&&(q.$$scope={dirty:$,ctx:c}),ce.$set(q);const at={};$&2&&(at.$$scope={dirty:$,ctx:c}),ee.$set(at)},i(c){xe||(b(t.$$.fragment,c),b(l.$$.fragment,c),b(Ge.$$.fragment,c),b(S.$$.fragment,c),b(ge.$$.fragment,c),b(qe.$$.fragment,c),b(Q.$$.fragment,c),b(ye.$$.fragment,c),b(F.$$.fragment,c),b(Ie.$$.fragment,c),b(ie.$$.fragment,c),b(le.$$.fragment,c),b(ke.$$.fragment,c),b(K.$$.fragment,c),b(Ue.$$.fragment,c),b(ae.$$.fragment,c),b(Xe.$$.fragment,c),b(Le.$$.fragment,c),b(ce.$$.fragment,c),b(ee.$$.fragment,c),xe=!0)},o(c){y(t.$$.fragment,c),y(l.$$.fragment,c),y(Ge.$$.fragment,c),y(S.$$.fragment,c),y(ge.$$.fragment,c),y(qe.$$.fragment,c),y(Q.$$.fragment,c),y(ye.$$.fragment,c),y(F.$$.fragment,c),y(Ie.$$.fragment,c),y(ie.$$.fragment,c),y(le.$$.fragment,c),y(ke.$$.fragment,c),y(K.$$.fragment,c),y(Ue.$$.fragment,c),y(ae.$$.fragment,c),y(Xe.$$.fragment,c),y(Le.$$.fragment,c),y(ce.$$.fragment,c),y(ee.$$.fragment,c),xe=!1},d(c){c&&(a(T),a(o),a(oe),a(Ye),a(C),a(Te),a(st),a(N),a(de),a(we),a(R)),M(t,c),M(l),M(Ge),M(S),M(ge),M(qe,c),M(Q),M(ye),M(F),M(Ie),M(ie,c),M(le),M(ke),M(K),M(Ue),M(ae,c),M(Xe),M(Le),M(ce),M(ee)}}}function zo(j){let t,T;return t=new ho({props:{$$slots:{default:[Jo]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment)},l(o){u(t.$$.fragment,o)},m(o,l){_(t,o,l),T=!0},p(o,l){const v={};l&2&&(v.$$scope={dirty:l,ctx:o}),t.$set(v)},i(o){T||(b(t.$$.fragment,o),T=!0)},o(o){y(t.$$.fragment,o),T=!1},d(o){M(t,o)}}}function Wo(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function Uo(j){let t,T="Examples:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0TW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhCZWl0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Zo(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function No(j){let t,T="Examples:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Po(j){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,l){d(o,t,l)},p:Se,d(o){o&&a(t)}}}function Lo(j){let t,T="Example:",o,l,v;return l=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(l.$$.fragment,n)},m(n,x){d(n,t,x),d(n,o,x),_(l,n,x),v=!0},p:Se,i(n){v||(b(l.$$.fragment,n),v=!0)},o(n){y(l.$$.fragment,n),v=!1},d(n){n&&(a(t),a(o)),M(l,n)}}}function Eo(j){let t,T,o,l,v,n,x="The bare Beit Model transformer outputting raw hidden-states without any specific head on top.",Oe,W,Ge=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Ke,Y,gt=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,et,S,pt="Finally, this model supports inherent JAX features such as:",ge,oe,qe='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ye,C,Q,Fe,_e,dt="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",be,L,ye,O,Ve,Ce,Me,F,ne,Ie,Te,ie="Beit Model transformer with a ‘language’ modeling head on top (to predict visual tokens).",st,N,le=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,tt,D,ft=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,ot,A,ut="Finally, this model supports inherent JAX features such as:",nt,U,ke='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Je,E,ze,We,K,He="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Ue,de,ae,we,R=`bool_masked_pos (<code>numpy.ndarray</code> of shape <code>(batch_size, num_patches)</code>):
Boolean masked positions. Indicates which patches are masked (1) and which aren’t (0).`,Xe,fe,se,Ze,ve,I,Ne,Pe,X,Le=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,Ee,$e,ct=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Re,ce,rt=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,ee,xe,c="Finally, this model supports inherent JAX features such as:",$,G,re='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',me,k,J,V,q,at="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Wt,De,it,Ae,Be;return t=new he({props:{title:"FlaxBeitModel",local:"transformers.FlaxBeitModel",headingTag:"h2"}}),l=new H({props:{name:"class transformers.FlaxBeitModel",anchor:"transformers.FlaxBeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L741"}}),Q=new H({props:{name:"__call__",anchor:"transformers.FlaxBeitModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f1f5c01dc60> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new zt({props:{$$slots:{default:[Wo]},$$scope:{ctx:j}}}),O=new wt({props:{anchor:"transformers.FlaxBeitModel.__call__.example",$$slots:{default:[Uo]},$$scope:{ctx:j}}}),Ce=new he({props:{title:"FlaxBeitForMaskedImageModeling",local:"transformers.FlaxBeitForMaskedImageModeling",headingTag:"h2"}}),ne=new H({props:{name:"class transformers.FlaxBeitForMaskedImageModeling",anchor:"transformers.FlaxBeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForMaskedImageModeling.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L825"}}),ze=new H({props:{name:"__call__",anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f1f5c01dc60> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new zt({props:{$$slots:{default:[Zo]},$$scope:{ctx:j}}}),fe=new wt({props:{anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__.example",$$slots:{default:[No]},$$scope:{ctx:j}}}),Ze=new he({props:{title:"FlaxBeitForImageClassification",local:"transformers.FlaxBeitForImageClassification",headingTag:"h2"}}),Ne=new H({props:{name:"class transformers.FlaxBeitForImageClassification",anchor:"transformers.FlaxBeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L909"}}),J=new H({props:{name:"__call__",anchor:"transformers.FlaxBeitForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f1f5c01dc60> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new zt({props:{$$slots:{default:[Po]},$$scope:{ctx:j}}}),Ae=new wt({props:{anchor:"transformers.FlaxBeitForImageClassification.__call__.example",$$slots:{default:[Lo]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment),T=s(),o=m("div"),f(l.$$.fragment),v=s(),n=m("p"),n.textContent=x,Oe=s(),W=m("p"),W.innerHTML=Ge,Ke=s(),Y=m("p"),Y.innerHTML=gt,et=s(),S=m("p"),S.textContent=pt,ge=s(),oe=m("ul"),oe.innerHTML=qe,Ye=s(),C=m("div"),f(Q.$$.fragment),Fe=s(),_e=m("p"),_e.innerHTML=dt,be=s(),f(L.$$.fragment),ye=s(),f(O.$$.fragment),Ve=s(),f(Ce.$$.fragment),Me=s(),F=m("div"),f(ne.$$.fragment),Ie=s(),Te=m("p"),Te.textContent=ie,st=s(),N=m("p"),N.innerHTML=le,tt=s(),D=m("p"),D.innerHTML=ft,ot=s(),A=m("p"),A.textContent=ut,nt=s(),U=m("ul"),U.innerHTML=ke,Je=s(),E=m("div"),f(ze.$$.fragment),We=s(),K=m("p"),K.innerHTML=He,Ue=s(),f(de.$$.fragment),ae=s(),we=m("p"),we.innerHTML=R,Xe=s(),f(fe.$$.fragment),se=s(),f(Ze.$$.fragment),ve=s(),I=m("div"),f(Ne.$$.fragment),Pe=s(),X=m("p"),X.textContent=Le,Ee=s(),$e=m("p"),$e.innerHTML=ct,Re=s(),ce=m("p"),ce.innerHTML=rt,ee=s(),xe=m("p"),xe.textContent=c,$=s(),G=m("ul"),G.innerHTML=re,me=s(),k=m("div"),f(J.$$.fragment),V=s(),q=m("p"),q.innerHTML=at,Wt=s(),f(De.$$.fragment),it=s(),f(Ae.$$.fragment),this.h()},l(g){u(t.$$.fragment,g),T=r(g),o=p(g,"DIV",{class:!0});var B=P(o);u(l.$$.fragment,B),v=r(B),n=p(B,"P",{"data-svelte-h":!0}),w(n)!=="svelte-yakhoj"&&(n.textContent=x),Oe=r(B),W=p(B,"P",{"data-svelte-h":!0}),w(W)!=="svelte-3daxed"&&(W.innerHTML=Ge),Ke=r(B),Y=p(B,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-10nfsf3"&&(Y.innerHTML=gt),et=r(B),S=p(B,"P",{"data-svelte-h":!0}),w(S)!=="svelte-1pplc4a"&&(S.textContent=pt),ge=r(B),oe=p(B,"UL",{"data-svelte-h":!0}),w(oe)!=="svelte-1w7z84m"&&(oe.innerHTML=qe),Ye=r(B),C=p(B,"DIV",{class:!0});var pe=P(C);u(Q.$$.fragment,pe),Fe=r(pe),_e=p(pe,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-15yd1qb"&&(_e.innerHTML=dt),be=r(pe),u(L.$$.fragment,pe),ye=r(pe),u(O.$$.fragment,pe),pe.forEach(a),B.forEach(a),Ve=r(g),u(Ce.$$.fragment,g),Me=r(g),F=p(g,"DIV",{class:!0});var te=P(F);u(ne.$$.fragment,te),Ie=r(te),Te=p(te,"P",{"data-svelte-h":!0}),w(Te)!=="svelte-1xpbgj8"&&(Te.textContent=ie),st=r(te),N=p(te,"P",{"data-svelte-h":!0}),w(N)!=="svelte-3daxed"&&(N.innerHTML=le),tt=r(te),D=p(te,"P",{"data-svelte-h":!0}),w(D)!=="svelte-10nfsf3"&&(D.innerHTML=ft),ot=r(te),A=p(te,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1pplc4a"&&(A.textContent=ut),nt=r(te),U=p(te,"UL",{"data-svelte-h":!0}),w(U)!=="svelte-1w7z84m"&&(U.innerHTML=ke),Je=r(te),E=p(te,"DIV",{class:!0});var ue=P(E);u(ze.$$.fragment,ue),We=r(ue),K=p(ue,"P",{"data-svelte-h":!0}),w(K)!=="svelte-15yd1qb"&&(K.innerHTML=He),Ue=r(ue),u(de.$$.fragment,ue),ae=r(ue),we=p(ue,"P",{"data-svelte-h":!0}),w(we)!=="svelte-1rn5vq7"&&(we.innerHTML=R),Xe=r(ue),u(fe.$$.fragment,ue),ue.forEach(a),te.forEach(a),se=r(g),u(Ze.$$.fragment,g),ve=r(g),I=p(g,"DIV",{class:!0});var Z=P(I);u(Ne.$$.fragment,Z),Pe=r(Z),X=p(Z,"P",{"data-svelte-h":!0}),w(X)!=="svelte-83lcss"&&(X.textContent=Le),Ee=r(Z),$e=p(Z,"P",{"data-svelte-h":!0}),w($e)!=="svelte-3daxed"&&($e.innerHTML=ct),Re=r(Z),ce=p(Z,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-10nfsf3"&&(ce.innerHTML=rt),ee=r(Z),xe=p(Z,"P",{"data-svelte-h":!0}),w(xe)!=="svelte-1pplc4a"&&(xe.textContent=c),$=r(Z),G=p(Z,"UL",{"data-svelte-h":!0}),w(G)!=="svelte-1w7z84m"&&(G.innerHTML=re),me=r(Z),k=p(Z,"DIV",{class:!0});var je=P(k);u(J.$$.fragment,je),V=r(je),q=p(je,"P",{"data-svelte-h":!0}),w(q)!=="svelte-15yd1qb"&&(q.innerHTML=at),Wt=r(je),u(De.$$.fragment,je),it=r(je),u(Ae.$$.fragment,je),je.forEach(a),Z.forEach(a),this.h()},h(){z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(g,B){_(t,g,B),d(g,T,B),d(g,o,B),_(l,o,null),i(o,v),i(o,n),i(o,Oe),i(o,W),i(o,Ke),i(o,Y),i(o,et),i(o,S),i(o,ge),i(o,oe),i(o,Ye),i(o,C),_(Q,C,null),i(C,Fe),i(C,_e),i(C,be),_(L,C,null),i(C,ye),_(O,C,null),d(g,Ve,B),_(Ce,g,B),d(g,Me,B),d(g,F,B),_(ne,F,null),i(F,Ie),i(F,Te),i(F,st),i(F,N),i(F,tt),i(F,D),i(F,ot),i(F,A),i(F,nt),i(F,U),i(F,Je),i(F,E),_(ze,E,null),i(E,We),i(E,K),i(E,Ue),_(de,E,null),i(E,ae),i(E,we),i(E,Xe),_(fe,E,null),d(g,se,B),_(Ze,g,B),d(g,ve,B),d(g,I,B),_(Ne,I,null),i(I,Pe),i(I,X),i(I,Ee),i(I,$e),i(I,Re),i(I,ce),i(I,ee),i(I,xe),i(I,$),i(I,G),i(I,me),i(I,k),_(J,k,null),i(k,V),i(k,q),i(k,Wt),_(De,k,null),i(k,it),_(Ae,k,null),Be=!0},p(g,B){const pe={};B&2&&(pe.$$scope={dirty:B,ctx:g}),L.$set(pe);const te={};B&2&&(te.$$scope={dirty:B,ctx:g}),O.$set(te);const ue={};B&2&&(ue.$$scope={dirty:B,ctx:g}),de.$set(ue);const Z={};B&2&&(Z.$$scope={dirty:B,ctx:g}),fe.$set(Z);const je={};B&2&&(je.$$scope={dirty:B,ctx:g}),De.$set(je);const mt={};B&2&&(mt.$$scope={dirty:B,ctx:g}),Ae.$set(mt)},i(g){Be||(b(t.$$.fragment,g),b(l.$$.fragment,g),b(Q.$$.fragment,g),b(L.$$.fragment,g),b(O.$$.fragment,g),b(Ce.$$.fragment,g),b(ne.$$.fragment,g),b(ze.$$.fragment,g),b(de.$$.fragment,g),b(fe.$$.fragment,g),b(Ze.$$.fragment,g),b(Ne.$$.fragment,g),b(J.$$.fragment,g),b(De.$$.fragment,g),b(Ae.$$.fragment,g),Be=!0)},o(g){y(t.$$.fragment,g),y(l.$$.fragment,g),y(Q.$$.fragment,g),y(L.$$.fragment,g),y(O.$$.fragment,g),y(Ce.$$.fragment,g),y(ne.$$.fragment,g),y(ze.$$.fragment,g),y(de.$$.fragment,g),y(fe.$$.fragment,g),y(Ze.$$.fragment,g),y(Ne.$$.fragment,g),y(J.$$.fragment,g),y(De.$$.fragment,g),y(Ae.$$.fragment,g),Be=!1},d(g){g&&(a(T),a(o),a(Ve),a(Me),a(F),a(se),a(ve),a(I)),M(t,g),M(l),M(Q),M(L),M(O),M(Ce,g),M(ne),M(ze),M(de),M(fe),M(Ze,g),M(Ne),M(J),M(De),M(Ae)}}}function Ro(j){let t,T;return t=new ho({props:{$$slots:{default:[Eo]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment)},l(o){u(t.$$.fragment,o)},m(o,l){_(t,o,l),T=!0},p(o,l){const v={};l&2&&(v.$$scope={dirty:l,ctx:o}),t.$set(v)},i(o){T||(b(t.$$.fragment,o),T=!0)},o(o){y(t.$$.fragment,o),T=!1},d(o){M(t,o)}}}function So(j){let t,T,o,l,v,n,x,Oe,W,Ge=`The BEiT model was proposed in <a href="https://arxiv.org/abs/2106.08254" rel="nofollow">BEiT: BERT Pre-Training of Image Transformers</a> by
Hangbo Bao, Li Dong and Furu Wei. Inspired by BERT, BEiT is the first paper that makes self-supervised pre-training of
Vision Transformers (ViTs) outperform supervised pre-training. Rather than pre-training the model to predict the class
of an image (as done in the <a href="https://arxiv.org/abs/2010.11929" rel="nofollow">original ViT paper</a>), BEiT models are pre-trained to
predict visual tokens from the codebook of OpenAI’s <a href="https://arxiv.org/abs/2102.12092" rel="nofollow">DALL-E model</a> given masked
patches.`,Ke,Y,gt="The abstract from the paper is the following:",et,S,pt=`<em>We introduce a self-supervised vision representation model BEiT, which stands for Bidirectional Encoder representation
from Image Transformers. Following BERT developed in the natural language processing area, we propose a masked image
modeling task to pretrain vision Transformers. Specifically, each image has two views in our pre-training, i.e, image
patches (such as 16x16 pixels), and visual tokens (i.e., discrete tokens). We first “tokenize” the original image into
visual tokens. Then we randomly mask some image patches and fed them into the backbone Transformer. The pre-training
objective is to recover the original visual tokens based on the corrupted image patches. After pre-training BEiT, we
directly fine-tune the model parameters on downstream tasks by appending task layers upon the pretrained encoder.
Experimental results on image classification and semantic segmentation show that our model achieves competitive results
with previous pre-training methods. For example, base-size BEiT achieves 83.2% top-1 accuracy on ImageNet-1K,
significantly outperforming from-scratch DeiT training (81.8%) with the same setup. Moreover, large-size BEiT obtains
86.3% only using ImageNet-1K, even outperforming ViT-L with supervised pre-training on ImageNet-22K (85.2%).</em>`,ge,oe,qe=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The JAX/FLAX version of this model was
contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/beit" rel="nofollow">here</a>.`,Ye,C,Q,Fe,_e=`<li>BEiT models are regular Vision Transformers, but pre-trained in a self-supervised way rather than supervised. They
outperform both the <a href="vit">original model (ViT)</a> as well as <a href="deit">Data-efficient Image Transformers (DeiT)</a> when fine-tuned on ImageNet-1K and CIFAR-100. You can check out demo notebooks regarding inference as well as
fine-tuning on custom data <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/VisionTransformer" rel="nofollow">here</a> (you can just replace
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> by <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> by <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a>).</li> <li>There’s also a demo notebook available which showcases how to combine DALL-E’s image tokenizer with BEiT for
performing masked image modeling. You can find it <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/BEiT" rel="nofollow">here</a>.</li> <li>As the BEiT models expect each image to be of the same size (resolution), one can use
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> to resize (or rescale) and normalize images for the model.</li> <li>Both the patch resolution and image resolution used during pre-training or fine-tuning are reflected in the name of
each checkpoint. For example, <code>microsoft/beit-base-patch16-224</code> refers to a base-sized architecture with patch
resolution of 16x16 and fine-tuning resolution of 224x224. All checkpoints can be found on the <a href="https://huggingface.co/models?search=microsoft/beit" rel="nofollow">hub</a>.</li> <li>The available checkpoints are either (1) pre-trained on <a href="http://www.image-net.org/" rel="nofollow">ImageNet-22k</a> (a collection of
14 million images and 22k classes) only, (2) also fine-tuned on ImageNet-22k or (3) also fine-tuned on <a href="http://www.image-net.org/challenges/LSVRC/2012/" rel="nofollow">ImageNet-1k</a> (also referred to as ILSVRC 2012, a collection of 1.3 million
images and 1,000 classes).</li> <li>BEiT uses relative position embeddings, inspired by the T5 model. During pre-training, the authors shared the
relative position bias among the several self-attention layers. During fine-tuning, each layer’s relative position
bias is initialized with the shared relative position bias obtained after pre-training. Note that, if one wants to
pre-train a model from scratch, one needs to either set the <code>use_relative_position_bias</code> or the
<code>use_relative_position_bias</code> attribute of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> to <code>True</code> in order to add
position embeddings.</li>`,dt,be,L,ye,O,Ve='BEiT pre-training. Taken from the <a href="https://arxiv.org/abs/2106.08254">original paper.</a>',Ce,Me,F,ne,Ie=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Te,ie,st=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,N,le,tt,D,ft="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",ot,A,ut=`On a local benchmark (NVIDIA GeForce RTX 2060-8GB, PyTorch 2.5.1, OS Ubuntu 20.04) with <code>float16</code> and
<code>microsoft/beit-base-patch16-224</code> model, we saw the following improvements during training and inference:`,nt,U,ke,Je,E="<thead><tr><th>num_training_steps</th> <th>batch_size</th> <th>image_size</th> <th>is_cuda</th> <th>Time per batch (eager - s)</th> <th>Time per batch (sdpa - s)</th> <th>Speedup (%)</th> <th>Eager peak mem (MB)</th> <th>SDPA peak mem (MB)</th> <th>Mem saving (%)</th></tr></thead> <tbody><tr><td>50</td> <td>2</td> <td>(1048, 640)</td> <td>True</td> <td>0.984</td> <td>0.746</td> <td>31.975</td> <td>6738.915</td> <td>4319.886</td> <td>55.998</td></tr></tbody>",ze,We,K,He,Ue='<thead><tr><th align="right">Image batch size</th> <th align="right">Eager (s/iter)</th> <th align="left">Eager CI, %</th> <th align="right">Eager memory (MB)</th> <th align="right">SDPA (s/iter)</th> <th align="left">SDPA CI, %</th> <th align="right">SDPA memory (MB)</th> <th align="right">SDPA speedup</th> <th align="right">SDPA memory saved (%)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">0.012</td> <td align="left">±0.3%</td> <td align="right">3.76657e+08</td> <td align="right">0.011</td> <td align="left">±0.5%</td> <td align="right">3.75739e+08</td> <td align="right">1.05</td> <td align="right">0.244</td></tr> <tr><td align="right">4</td> <td align="right">0.013</td> <td align="left">±0.1%</td> <td align="right">4.03147e+08</td> <td align="right">0.011</td> <td align="left">±0.2%</td> <td align="right">3.90554e+08</td> <td align="right">1.178</td> <td align="right">3.225</td></tr> <tr><td align="right">16</td> <td align="right">0.045</td> <td align="left">±0.1%</td> <td align="right">4.96697e+08</td> <td align="right">0.035</td> <td align="left">±0.1%</td> <td align="right">4.51232e+08</td> <td align="right">1.304</td> <td align="right">10.076</td></tr> <tr><td align="right">32</td> <td align="right">0.088</td> <td align="left">±0.1%</td> <td align="right">6.24417e+08</td> <td align="right">0.066</td> <td align="left">±0.1%</td> <td align="right">5.33488e+08</td> <td align="right">1.325</td> <td align="right">17.044</td></tr></tbody>',de,ae,we,R,Xe="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with BEiT.",fe,se,Ze,ve,I='<li><a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Ne,Pe,X="<strong>Semantic segmentation</strong>",Le,Ee,$e='<li><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></li>',ct,Re,ce="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",rt,ee,xe,c,$,G,re,me='Class for outputs of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a>.',k,J,V,q,at,Wt='Class for outputs of <a href="/docs/transformers/main/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a>.',De,it,Ae,Be,g,B,pe,te=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a>. It is used to instantiate an BEiT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the BEiT
<a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k</a> architecture.`,ue,Z,je,mt,Vt,lt,vt,Kt,Ut,$t,eo,_t,xt,to,Zt,io='Converts the output of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Ht,Bt,Xt,Qe,jt,oo,Nt,lo="Constructs a BEiT image processor.",no,bt,Ft,ao,Pt,co="Preprocess an image or batch of images.",so,yt,Ct,ro,Lt,mo='Converts the output of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Gt,Mt,qt,It,Yt,St,Dt;return v=new he({props:{title:"BEiT",local:"beit",headingTag:"h1"}}),x=new he({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new he({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Me=new he({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),le=new ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBLi4u",highlighted:`from transformers import BeitForImageClassification
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">BeitForImageClassification</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),U=new he({props:{title:"Training",local:"training",headingTag:"h4"}}),We=new he({props:{title:"Inference",local:"inference",headingTag:"h4"}}),ae=new he({props:{title:"Resources",local:"resources",headingTag:"h2"}}),se=new To({props:{pipeline:"image-classification"}}),ee=new he({props:{title:"BEiT specific outputs",local:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",headingTag:"h2"}}),$=new H({props:{name:"class transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor, ...]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor, ...]] = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L64"}}),V=new H({props:{name:"class transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"pooler_output",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L44"}}),it=new he({props:{title:"BeitConfig",local:"transformers.BeitConfig",headingTag:"h2"}}),g=new H({props:{name:"class transformers.BeitConfig",anchor:"transformers.BeitConfig",parameters:[{name:"vocab_size",val:" = 8192"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"use_mask_token",val:" = False"},{name:"use_absolute_position_embeddings",val:" = False"},{name:"use_relative_position_bias",val:" = False"},{name:"use_shared_relative_position_bias",val:" = False"},{name:"layer_scale_init_value",val:" = 0.1"},{name:"drop_path_rate",val:" = 0.1"},{name:"use_mean_pooling",val:" = True"},{name:"pool_scales",val:" = [1, 2, 3, 6]"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"auxiliary_channels",val:" = 256"},{name:"auxiliary_num_convs",val:" = 1"},{name:"auxiliary_concat_input",val:" = False"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"add_fpn",val:" = False"},{name:"reshape_hidden_states",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Vocabulary size of the BEiT model. Defines the number of different image tokens that can be used during
pre-training.`,name:"vocab_size"},{anchor:"transformers.BeitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BeitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BeitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BeitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BeitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BeitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BeitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BeitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BeitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BeitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.BeitConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.BeitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.BeitConfig.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a mask token for masked image modeling.`,name:"use_mask_token"},{anchor:"transformers.BeitConfig.use_absolute_position_embeddings",description:`<strong>use_absolute_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use BERT-style absolute position embeddings.`,name:"use_absolute_position_embeddings"},{anchor:"transformers.BeitConfig.use_relative_position_bias",description:`<strong>use_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use T5-style relative position embeddings in the self-attention layers.`,name:"use_relative_position_bias"},{anchor:"transformers.BeitConfig.use_shared_relative_position_bias",description:`<strong>use_shared_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the same relative position embeddings across all self-attention layers of the Transformer.`,name:"use_shared_relative_position_bias"},{anchor:"transformers.BeitConfig.layer_scale_init_value",description:`<strong>layer_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Scale to use in the self-attention layers. 0.1 for base, 1e-5 for large. Set 0 to disable layer scale.`,name:"layer_scale_init_value"},{anchor:"transformers.BeitConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate per sample (when applied in the main path of residual layers).`,name:"drop_path_rate"},{anchor:"transformers.BeitConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states of the patches instead of using the final hidden state of the
CLS token, before applying the classification head.`,name:"use_mean_pooling"},{anchor:"transformers.BeitConfig.pool_scales",description:`<strong>pool_scales</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 3, 6]</code>) &#x2014;
Pooling scales used in Pooling Pyramid Module applied on the last feature map.`,name:"pool_scales"},{anchor:"transformers.BeitConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.BeitConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.BeitConfig.auxiliary_channels",description:`<strong>auxiliary_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels to use in the auxiliary head.`,name:"auxiliary_channels"},{anchor:"transformers.BeitConfig.auxiliary_num_convs",description:`<strong>auxiliary_num_convs</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of convolutional layers to use in the auxiliary head.`,name:"auxiliary_num_convs"},{anchor:"transformers.BeitConfig.auxiliary_concat_input",description:`<strong>auxiliary_concat_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the output of the auxiliary head with the input before the classification layer.`,name:"auxiliary_concat_input"},{anchor:"transformers.BeitConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"},{anchor:"transformers.BeitConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.BeitConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"},{anchor:"transformers.BeitConfig.add_fpn",description:`<strong>add_fpn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a FPN as part of the backbone. Only relevant for <code>BeitBackbone</code>.`,name:"add_fpn"},{anchor:"transformers.BeitConfig.reshape_hidden_states",description:`<strong>reshape_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to reshape the feature maps to 4D tensors of shape <code>(batch_size, hidden_size, height, width)</code> in
case the model is used as backbone. If <code>False</code>, the feature maps will be 3D tensors of shape <code>(batch_size, seq_len, hidden_size)</code>. Only relevant for <code>BeitBackbone</code>.`,name:"reshape_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/configuration_beit.py#L28"}}),Z=new wt({props:{anchor:"transformers.BeitConfig.example",$$slots:{default:[vo]},$$scope:{ctx:j}}}),mt=new he({props:{title:"BeitFeatureExtractor",local:"transformers.BeitFeatureExtractor",headingTag:"h2"}}),vt=new H({props:{name:"class transformers.BeitFeatureExtractor",anchor:"transformers.BeitFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/feature_extraction_beit.py#L26"}}),$t=new H({props:{name:"__call__",anchor:"transformers.BeitFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L309"}}),xt=new H({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),Bt=new he({props:{title:"BeitImageProcessor",local:"transformers.BeitImageProcessor",headingTag:"h2"}}),jt=new H({props:{name:"class transformers.BeitImageProcessor",anchor:"transformers.BeitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.BeitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by the <code>do_center_crop</code> parameter in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Desired output size when applying center-cropping. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.
Can be overridden by the <code>crop_size</code> parameter in the <code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
The mean to use if normalizing the image. This is a float or list of floats of length of the number of
channels of the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
The standard deviation to use if normalizing the image. This is a float or list of floats of length of the
number of channels of the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0 is
used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k). The
background label will be replaced by 255. Can be overridden by the <code>do_reduce_labels</code> parameter in the
<code>preprocess</code> method.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L57"}}),Ft=new H({props:{name:"preprocess",anchor:"transformers.BeitImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.BeitImageProcessor.preprocess.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
Segmentation maps to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"segmentation_maps"},{anchor:"transformers.BeitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.BeitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.preprocess.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_reduce_labels</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g.
ADE20k). The background label will be replaced by 255.`,name:"do_reduce_labels"},{anchor:"transformers.BeitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.BeitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.BeitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L314"}}),Ct=new H({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),Mt=new Mo({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[Ro],pytorch:[zo]},$$scope:{ctx:j}}}),It=new wo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/beit.md"}}),{c(){t=m("meta"),T=s(),o=m("p"),l=s(),f(v.$$.fragment),n=s(),f(x.$$.fragment),Oe=s(),W=m("p"),W.innerHTML=Ge,Ke=s(),Y=m("p"),Y.textContent=gt,et=s(),S=m("p"),S.innerHTML=pt,ge=s(),oe=m("p"),oe.innerHTML=qe,Ye=s(),f(C.$$.fragment),Q=s(),Fe=m("ul"),Fe.innerHTML=_e,dt=s(),be=m("img"),ye=s(),O=m("small"),O.innerHTML=Ve,Ce=s(),f(Me.$$.fragment),F=s(),ne=m("p"),ne.innerHTML=Ie,Te=s(),ie=m("p"),ie.innerHTML=st,N=s(),f(le.$$.fragment),tt=s(),D=m("p"),D.innerHTML=ft,ot=s(),A=m("p"),A.innerHTML=ut,nt=s(),f(U.$$.fragment),ke=s(),Je=m("table"),Je.innerHTML=E,ze=s(),f(We.$$.fragment),K=s(),He=m("table"),He.innerHTML=Ue,de=s(),f(ae.$$.fragment),we=s(),R=m("p"),R.textContent=Xe,fe=s(),f(se.$$.fragment),Ze=s(),ve=m("ul"),ve.innerHTML=I,Ne=s(),Pe=m("p"),Pe.innerHTML=X,Le=s(),Ee=m("ul"),Ee.innerHTML=$e,ct=s(),Re=m("p"),Re.textContent=ce,rt=s(),f(ee.$$.fragment),xe=s(),c=m("div"),f($.$$.fragment),G=s(),re=m("p"),re.innerHTML=me,k=s(),J=m("div"),f(V.$$.fragment),q=s(),at=m("p"),at.innerHTML=Wt,De=s(),f(it.$$.fragment),Ae=s(),Be=m("div"),f(g.$$.fragment),B=s(),pe=m("p"),pe.innerHTML=te,ue=s(),f(Z.$$.fragment),je=s(),f(mt.$$.fragment),Vt=s(),lt=m("div"),f(vt.$$.fragment),Kt=s(),Ut=m("div"),f($t.$$.fragment),eo=s(),_t=m("div"),f(xt.$$.fragment),to=s(),Zt=m("p"),Zt.innerHTML=io,Ht=s(),f(Bt.$$.fragment),Xt=s(),Qe=m("div"),f(jt.$$.fragment),oo=s(),Nt=m("p"),Nt.textContent=lo,no=s(),bt=m("div"),f(Ft.$$.fragment),ao=s(),Pt=m("p"),Pt.textContent=co,so=s(),yt=m("div"),f(Ct.$$.fragment),ro=s(),Lt=m("p"),Lt.innerHTML=mo,Gt=s(),f(Mt.$$.fragment),qt=s(),f(It.$$.fragment),Yt=s(),St=m("p"),this.h()},l(e){const h=yo("svelte-u9bgzb",document.head);t=p(h,"META",{name:!0,content:!0}),h.forEach(a),T=r(e),o=p(e,"P",{}),P(o).forEach(a),l=r(e),u(v.$$.fragment,e),n=r(e),u(x.$$.fragment,e),Oe=r(e),W=p(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-82fvis"&&(W.innerHTML=Ge),Ke=r(e),Y=p(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-vfdo9a"&&(Y.textContent=gt),et=r(e),S=p(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-s10fc1"&&(S.innerHTML=pt),ge=r(e),oe=p(e,"P",{"data-svelte-h":!0}),w(oe)!=="svelte-29336p"&&(oe.innerHTML=qe),Ye=r(e),u(C.$$.fragment,e),Q=r(e),Fe=p(e,"UL",{"data-svelte-h":!0}),w(Fe)!=="svelte-1ej7ct7"&&(Fe.innerHTML=_e),dt=r(e),be=p(e,"IMG",{src:!0,alt:!0,width:!0}),ye=r(e),O=p(e,"SMALL",{"data-svelte-h":!0}),w(O)!=="svelte-11iyjyp"&&(O.innerHTML=Ve),Ce=r(e),u(Me.$$.fragment,e),F=r(e),ne=p(e,"P",{"data-svelte-h":!0}),w(ne)!=="svelte-1cid2pe"&&(ne.innerHTML=Ie),Te=r(e),ie=p(e,"P",{"data-svelte-h":!0}),w(ie)!=="svelte-1x11lxg"&&(ie.innerHTML=st),N=r(e),u(le.$$.fragment,e),tt=r(e),D=p(e,"P",{"data-svelte-h":!0}),w(D)!=="svelte-djb2w0"&&(D.innerHTML=ft),ot=r(e),A=p(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-vyvhi1"&&(A.innerHTML=ut),nt=r(e),u(U.$$.fragment,e),ke=r(e),Je=p(e,"TABLE",{"data-svelte-h":!0}),w(Je)!=="svelte-1qjtd23"&&(Je.innerHTML=E),ze=r(e),u(We.$$.fragment,e),K=r(e),He=p(e,"TABLE",{"data-svelte-h":!0}),w(He)!=="svelte-18nua2y"&&(He.innerHTML=Ue),de=r(e),u(ae.$$.fragment,e),we=r(e),R=p(e,"P",{"data-svelte-h":!0}),w(R)!=="svelte-1bkfbxv"&&(R.textContent=Xe),fe=r(e),u(se.$$.fragment,e),Ze=r(e),ve=p(e,"UL",{"data-svelte-h":!0}),w(ve)!=="svelte-zkv0ml"&&(ve.innerHTML=I),Ne=r(e),Pe=p(e,"P",{"data-svelte-h":!0}),w(Pe)!=="svelte-1qspi63"&&(Pe.innerHTML=X),Le=r(e),Ee=p(e,"UL",{"data-svelte-h":!0}),w(Ee)!=="svelte-bnel3y"&&(Ee.innerHTML=$e),ct=r(e),Re=p(e,"P",{"data-svelte-h":!0}),w(Re)!=="svelte-1xesile"&&(Re.textContent=ce),rt=r(e),u(ee.$$.fragment,e),xe=r(e),c=p(e,"DIV",{class:!0});var kt=P(c);u($.$$.fragment,kt),G=r(kt),re=p(kt,"P",{"data-svelte-h":!0}),w(re)!=="svelte-148z2cd"&&(re.innerHTML=me),kt.forEach(a),k=r(e),J=p(e,"DIV",{class:!0});var Jt=P(J);u(V.$$.fragment,Jt),q=r(Jt),at=p(Jt,"P",{"data-svelte-h":!0}),w(at)!=="svelte-1x6ong1"&&(at.innerHTML=Wt),Jt.forEach(a),De=r(e),u(it.$$.fragment,e),Ae=r(e),Be=p(e,"DIV",{class:!0});var Et=P(Be);u(g.$$.fragment,Et),B=r(Et),pe=p(Et,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-xekuij"&&(pe.innerHTML=te),ue=r(Et),u(Z.$$.fragment,Et),Et.forEach(a),je=r(e),u(mt.$$.fragment,e),Vt=r(e),lt=p(e,"DIV",{class:!0});var Rt=P(lt);u(vt.$$.fragment,Rt),Kt=r(Rt),Ut=p(Rt,"DIV",{class:!0});var po=P(Ut);u($t.$$.fragment,po),po.forEach(a),eo=r(Rt),_t=p(Rt,"DIV",{class:!0});var At=P(_t);u(xt.$$.fragment,At),to=r(At),Zt=p(At,"P",{"data-svelte-h":!0}),w(Zt)!=="svelte-it6sc2"&&(Zt.innerHTML=io),At.forEach(a),Rt.forEach(a),Ht=r(e),u(Bt.$$.fragment,e),Xt=r(e),Qe=p(e,"DIV",{class:!0});var Tt=P(Qe);u(jt.$$.fragment,Tt),oo=r(Tt),Nt=p(Tt,"P",{"data-svelte-h":!0}),w(Nt)!=="svelte-ky7k50"&&(Nt.textContent=lo),no=r(Tt),bt=p(Tt,"DIV",{class:!0});var Qt=P(bt);u(Ft.$$.fragment,Qt),ao=r(Qt),Pt=p(Qt,"P",{"data-svelte-h":!0}),w(Pt)!=="svelte-1x3yxsa"&&(Pt.textContent=co),Qt.forEach(a),so=r(Tt),yt=p(Tt,"DIV",{class:!0});var Ot=P(yt);u(Ct.$$.fragment,Ot),ro=r(Ot),Lt=p(Ot,"P",{"data-svelte-h":!0}),w(Lt)!=="svelte-it6sc2"&&(Lt.innerHTML=mo),Ot.forEach(a),Tt.forEach(a),Gt=r(e),u(Mt.$$.fragment,e),qt=r(e),u(It.$$.fragment,e),Yt=r(e),St=p(e,"P",{}),P(St).forEach(a),this.h()},h(){z(t,"name","hf:doc:metadata"),z(t,"content",Vo),fo(be.src,L="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/beit_architecture.jpg")||z(be,"src",L),z(be,"alt","drawing"),z(be,"width","600"),z(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,h){i(document.head,t),d(e,T,h),d(e,o,h),d(e,l,h),_(v,e,h),d(e,n,h),_(x,e,h),d(e,Oe,h),d(e,W,h),d(e,Ke,h),d(e,Y,h),d(e,et,h),d(e,S,h),d(e,ge,h),d(e,oe,h),d(e,Ye,h),_(C,e,h),d(e,Q,h),d(e,Fe,h),d(e,dt,h),d(e,be,h),d(e,ye,h),d(e,O,h),d(e,Ce,h),_(Me,e,h),d(e,F,h),d(e,ne,h),d(e,Te,h),d(e,ie,h),d(e,N,h),_(le,e,h),d(e,tt,h),d(e,D,h),d(e,ot,h),d(e,A,h),d(e,nt,h),_(U,e,h),d(e,ke,h),d(e,Je,h),d(e,ze,h),_(We,e,h),d(e,K,h),d(e,He,h),d(e,de,h),_(ae,e,h),d(e,we,h),d(e,R,h),d(e,fe,h),_(se,e,h),d(e,Ze,h),d(e,ve,h),d(e,Ne,h),d(e,Pe,h),d(e,Le,h),d(e,Ee,h),d(e,ct,h),d(e,Re,h),d(e,rt,h),_(ee,e,h),d(e,xe,h),d(e,c,h),_($,c,null),i(c,G),i(c,re),d(e,k,h),d(e,J,h),_(V,J,null),i(J,q),i(J,at),d(e,De,h),_(it,e,h),d(e,Ae,h),d(e,Be,h),_(g,Be,null),i(Be,B),i(Be,pe),i(Be,ue),_(Z,Be,null),d(e,je,h),_(mt,e,h),d(e,Vt,h),d(e,lt,h),_(vt,lt,null),i(lt,Kt),i(lt,Ut),_($t,Ut,null),i(lt,eo),i(lt,_t),_(xt,_t,null),i(_t,to),i(_t,Zt),d(e,Ht,h),_(Bt,e,h),d(e,Xt,h),d(e,Qe,h),_(jt,Qe,null),i(Qe,oo),i(Qe,Nt),i(Qe,no),i(Qe,bt),_(Ft,bt,null),i(bt,ao),i(bt,Pt),i(Qe,so),i(Qe,yt),_(Ct,yt,null),i(yt,ro),i(yt,Lt),d(e,Gt,h),_(Mt,e,h),d(e,qt,h),_(It,e,h),d(e,Yt,h),d(e,St,h),Dt=!0},p(e,[h]){const kt={};h&2&&(kt.$$scope={dirty:h,ctx:e}),Z.$set(kt);const Jt={};h&2&&(Jt.$$scope={dirty:h,ctx:e}),Mt.$set(Jt)},i(e){Dt||(b(v.$$.fragment,e),b(x.$$.fragment,e),b(C.$$.fragment,e),b(Me.$$.fragment,e),b(le.$$.fragment,e),b(U.$$.fragment,e),b(We.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(ee.$$.fragment,e),b($.$$.fragment,e),b(V.$$.fragment,e),b(it.$$.fragment,e),b(g.$$.fragment,e),b(Z.$$.fragment,e),b(mt.$$.fragment,e),b(vt.$$.fragment,e),b($t.$$.fragment,e),b(xt.$$.fragment,e),b(Bt.$$.fragment,e),b(jt.$$.fragment,e),b(Ft.$$.fragment,e),b(Ct.$$.fragment,e),b(Mt.$$.fragment,e),b(It.$$.fragment,e),Dt=!0)},o(e){y(v.$$.fragment,e),y(x.$$.fragment,e),y(C.$$.fragment,e),y(Me.$$.fragment,e),y(le.$$.fragment,e),y(U.$$.fragment,e),y(We.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(ee.$$.fragment,e),y($.$$.fragment,e),y(V.$$.fragment,e),y(it.$$.fragment,e),y(g.$$.fragment,e),y(Z.$$.fragment,e),y(mt.$$.fragment,e),y(vt.$$.fragment,e),y($t.$$.fragment,e),y(xt.$$.fragment,e),y(Bt.$$.fragment,e),y(jt.$$.fragment,e),y(Ft.$$.fragment,e),y(Ct.$$.fragment,e),y(Mt.$$.fragment,e),y(It.$$.fragment,e),Dt=!1},d(e){e&&(a(T),a(o),a(l),a(n),a(Oe),a(W),a(Ke),a(Y),a(et),a(S),a(ge),a(oe),a(Ye),a(Q),a(Fe),a(dt),a(be),a(ye),a(O),a(Ce),a(F),a(ne),a(Te),a(ie),a(N),a(tt),a(D),a(ot),a(A),a(nt),a(ke),a(Je),a(ze),a(K),a(He),a(de),a(we),a(R),a(fe),a(Ze),a(ve),a(Ne),a(Pe),a(Le),a(Ee),a(ct),a(Re),a(rt),a(xe),a(c),a(k),a(J),a(De),a(Ae),a(Be),a(je),a(Vt),a(lt),a(Ht),a(Xt),a(Qe),a(Gt),a(qt),a(Yt),a(St)),a(t),M(v,e),M(x,e),M(C,e),M(Me,e),M(le,e),M(U,e),M(We,e),M(ae,e),M(se,e),M(ee,e),M($),M(V),M(it,e),M(g),M(Z),M(mt,e),M(vt),M($t),M(xt),M(Bt,e),M(jt),M(Ft),M(Ct),M(Mt,e),M(It,e)}}}const Vo='{"title":"BEiT","local":"beit","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[{"title":"Training","local":"training","sections":[],"depth":4},{"title":"Inference","local":"inference","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BEiT specific outputs","local":"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling","sections":[],"depth":2},{"title":"BeitConfig","local":"transformers.BeitConfig","sections":[],"depth":2},{"title":"BeitFeatureExtractor","local":"transformers.BeitFeatureExtractor","sections":[],"depth":2},{"title":"BeitImageProcessor","local":"transformers.BeitImageProcessor","sections":[],"depth":2},{"title":"BeitModel","local":"transformers.BeitModel","sections":[],"depth":2},{"title":"BeitForMaskedImageModeling","local":"transformers.BeitForMaskedImageModeling","sections":[],"depth":2},{"title":"BeitForImageClassification","local":"transformers.BeitForImageClassification","sections":[],"depth":2},{"title":"BeitForSemanticSegmentation","local":"transformers.BeitForSemanticSegmentation","sections":[],"depth":2},{"title":"FlaxBeitModel","local":"transformers.FlaxBeitModel","sections":[],"depth":2},{"title":"FlaxBeitForMaskedImageModeling","local":"transformers.FlaxBeitForMaskedImageModeling","sections":[],"depth":2},{"title":"FlaxBeitForImageClassification","local":"transformers.FlaxBeitForImageClassification","sections":[],"depth":2}],"depth":1}';function Ho(j){return uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends _o{constructor(t){super(),bo(this,t,Ho,So,go,{})}}export{en as component};
