import{s as Oi,o as Ri,n as Ei}from"../chunks/scheduler.6062bdaf.js";import{S as Zi,i as Wi,g as l,s as a,r as c,A as Di,h as s,f as i,c as o,j as Bi,u,x as r,k as Dt,y as Gi,a as n,v as m,d,t as f,w as h}from"../chunks/index.4bca734e.js";import{T as Fi}from"../chunks/Tip.b9ac1f03.js";import{C as Ue}from"../chunks/CodeBlock.fa01571c.js";import{H as b}from"../chunks/Heading.723dceba.js";function Ki(ke){let p,v=`Usually <code>round(a/S + Z)</code> corresponds to the smallest representable value in the considered data type, and <code>round(b/S + Z)</code>
to the biggest one. But this can vary, for instance when using a <em>symmetric quantization scheme</em> as you will see in the next
paragraph.`;return{c(){p=l("p"),p.innerHTML=v},l(g){p=s(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-d33l1n"&&(p.innerHTML=v)},m(g,w){n(g,p,w)},p:Ei,d(g){g&&i(p)}}}function Vi(ke){let p,v=`The section is not fundamental to understand the rest. It explains in brief how numbers are represented in computers.
Since quantization is about going from one representation to another, it can be useful to have some basics, but it is
definitely not mandatory.`;return{c(){p=l("p"),p.textContent=v},l(g){p=s(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-193nbxk"&&(p.textContent=v)},m(g,w){n(g,p,w)},p:Ei,d(g){g&&i(p)}}}function Xi(ke){let p,v,g,w,x,Ie,q,Gt=`Quantization is a technique to reduce the computational and memory costs of running inference by representing the
weights and activations with low-precision data types like 8-bit integer (<code>int8</code>) instead of the usual 32-bit floating
point (<code>float32</code>).`,Je,z,Kt=`Reducing the number of bits means the resulting model requires less memory storage, consumes less energy (in theory), and
operations like matrix multiplication can be performed much faster with integer arithmetic. It also allows to run models
on embedded devices, which sometimes only support integer data types.`,Se,C,Ae,L,Vt=`The basic idea behind quantization is quite easy: going from high-precision representation (usually the regular 32-bit
floating-point) for weights and activations to a lower precision data type. The most common lower precision data types
are:`,Qe,_,Xt="<li><code>float16</code>, accumulation data type <code>float16</code></li> <li><code>bfloat16</code>, accumulation data type <code>float32</code></li> <li><code>int16</code>, accumulation data type <code>int32</code></li> <li><code>int8</code>, accumulation data type <code>int32</code></li>",Ne,H,Yt=`The accumulation data type specifies the type of the result of accumulating (adding, multiplying, etc) values of the
data type in question. For example, let’s consider two <code>int8</code> values <code>A = 127</code>, <code>B = 127</code>, and let’s define <code>C</code> as the
sum of <code>A</code> and <code>B</code>:`,Be,j,Fe,k,ei=`Here the result is much bigger than the biggest representable value in <code>int8</code>, which is <code>127</code>. Hence the need for a larger
precision data type to avoid a huge precision loss that would make the whole quantization process useless.`,Ee,U,Oe,P,ti="The two most common quantization cases are <code>float32 -&gt; float16</code> and <code>float32 -&gt; int8</code>.",Re,I,Ze,J,ii=`Performing quantization to go from <code>float32</code> to <code>float16</code> is quite straightforward since both data types follow the same
representation scheme. The questions to ask yourself when quantizing an operation to <code>float16</code> are:`,We,S,ni=`<li>Does my operation have a <code>float16</code> implementation?</li> <li>Does my hardware suport <code>float16</code>? For instance, Intel CPUs <a href="https://scicomp.stackexchange.com/a/35193" rel="nofollow">have been supporting <code>float16</code> as a storage type, but
computation is done after converting to <code>float32</code></a>. Full support will come
in Cooper Lake and Sapphire Rapids.</li> <li>Is my operation sensitive to lower precision?
For instance the value of epsilon in <code>LayerNorm</code> is usually very small (~ <code>1e-12</code>), but the smallest representable value in
<code>float16</code> is ~ <code>6e-5</code>, this can cause <code>NaN</code> issues.  The same applies for big values.</li>`,De,A,Ge,Q,ai=`Performing quantization to go from <code>float32</code> to <code>int8</code> is more tricky. Only 256 values can be represented in <code>int8</code>,
while <code>float32</code> can represent a very wide range of values. The idea is to find the best way to project our range <code>[a, b]</code>
of <code>float32</code> values  to the <code>int8</code> space.`,Ke,N,oi=`Let’s consider a float <code>x</code> in <code>[a, b]</code>, then we can write the following quantization scheme, also called the <em>affine
quantization scheme</em>:`,Ve,B,Xe,F,li="where:",Ye,E,si=`<li><code>x_q</code> is the quantized <code>int8</code> value associated to <code>x</code></li> <li><code>S</code> and <code>Z</code> are the quantization parameters<ul><li><code>S</code> is the scale, and is a positive <code>float32</code></li> <li><code>Z</code> is called the zero-point, it is the <code>int8</code> value corresponding to the value <code>0</code> in the <code>float32</code> realm. This is
important to be able to represent exactly the value <code>0</code> because it is used everywhere throughout machine learning
models.</li></ul></li>`,et,O,ri="The quantized value <code>x_q</code> of <code>x</code> in <code>[a, b]</code> can be computed as follows:",tt,R,it,Z,pi=`And <code>float32</code> values outside of the <code>[a, b]</code> range are clipped to the closest representable value, so for any
floating-point number <code>x</code>:`,nt,W,at,$,ot,D,lt,G,ci="The equation above is called the <em>affine quantization sheme</em> because the mapping from <code>[a, b]</code> to <code>int8</code> is an affine one.",st,K,ui=`A common special case of this scheme is the <em>symmetric quantization scheme</em>, where we consider a symmetric range of float values <code>[-a, a]</code>.
In this case the integer space is usally <code>[-127, 127]</code>, meaning that the <code>-128</code> is opted out of the regular <code>[-128, 127]</code> signed <code>int8</code> range.
The reason being that having both ranges symmetric allows to have <code>Z = 0</code>. While one value out of the 256 representable
values is lost, it can provide a speedup since a lot of addition operations can be skipped.`,rt,V,mi=`<strong>Note</strong>: To learn how the quantization parameters <code>S</code> and <code>Z</code> are computed, you can read the
<a href="https://arxiv.org/abs/1712.05877" rel="nofollow">Quantization and Training of Neural Networks for Efficient Integer-Arithmetic-Only Inference</a>
paper, or <a href="https://leimao.github.io/article/Neural-Networks-Quantization" rel="nofollow">Lei Mao’s blog post</a> on the subject.`,pt,X,ct,Y,di="Depending on the accuracy / latency trade-off you are targetting you can play with the granularity of the quantization parameters:",ut,ee,fi=`<li>Quantization parameters can be computed on a <em>per-tensor</em> basis, meaning that one pair of <code>(S, Z)</code> will be used per
tensor.</li> <li>Quantization parameters can be computed on a <em>per-channel</em> basis, meaning that it is possible to store a pair of
<code>(S, Z)</code> per element along one of the dimensions of a tensor. For example for a tensor of shape <code>[N, C, H, W]</code>, having
<em>per-channel</em> quantization parameters for the second dimension would result in having <code>C</code> pairs of <code>(S, Z)</code>. While this
can give a better accuracy, it requires more memory.</li>`,mt,te,dt,ie,hi=`The section above described how quantization from <code>float32</code> to <code>int8</code> works, but one question
remains: how is the <code>[a, b]</code> range of <code>float32</code> values determined? That is where calibration comes in to play.`,ft,ne,gi=`Calibration is the step during quantization where the <code>float32</code> ranges are computed. For weights it is quite easy since
the actual range is known at <em>quantization-time</em>. But it is less clear for activations, and different approaches exist:`,ht,ae,bi=`<li>Post training <strong>dynamic quantization</strong>: the range for each activation is computed on the fly at <em>runtime</em>. While this
gives great results without too much work, it can be a bit slower than static quantization because of the overhead
introduced by computing the range each time.
It is also not an option on certain hardware.</li> <li>Post training <strong>static quantization</strong>: the range for each activation is computed in advance at <em>quantization-time</em>,
typically by passing representative data through the model and recording the activation values. In practice, the steps are:<ol><li>Observers are put on activations to record their values.</li> <li>A certain number of forward passes on a calibration dataset is done (around <code>200</code> examples is enough).</li> <li>The ranges for each computation are computed according to some <em>calibration technique</em>.</li></ol></li> <li><strong>Quantization aware training</strong>: the range for each activation is computed at <em>training-time</em>, following the same idea
than post training static quantization. But “fake quantize” operators are used instead of observers: they record
values just as observers do, but they also simulate the error induced by quantization to let the model adapt to it.</li>`,gt,oe,vi=`For both post training static quantization and quantization aware training, it is necessary to define calibration
techniques, the most common are:`,bt,le,wi=`<li>Min-max: the computed range is <code>[min observed value, max observed value]</code>, this works well with weights.</li> <li>Moving average min-max: the computed range is <code>[moving average min observed value, moving average max observed value]</code>,
this works well with activations.</li> <li>Histogram: records a histogram of values along with min and max values, then chooses according to some criterion:<ul><li>Entropy: the range is computed as the one minimizing the error between the full-precision and the quantized data.</li> <li>Mean Square Error: the range is computed as the one minimizing the mean square error between the full-precision and
the quantized data.</li> <li>Percentile: the range is computed using a given percentile value <code>p</code> on the observed values. The idea is to try to have
<code>p%</code> of the observed values in the computed range. While this is possible when doing affine quantization, it is not always
possible to exactly match that when doing symmetric quantization. You can check <a href="https://github.com/microsoft/onnxruntime/blob/2cb12caf9317f1ded37f6db125cb03ba99320c40/onnxruntime/python/tools/quantization/calibrate.py#L698" rel="nofollow">how it is done in ONNX
Runtime</a>
for more details.</li></ul></li>`,vt,se,wt,re,$i="To effectively quantize a model to <code>int8</code>, the steps to follow are:",$t,pe,Ti=`<li>Choose which operators to quantize. Good operators to quantize are the one dominating it terms of computation time,
for instance linear projections and matrix multiplications.</li> <li>Try post-training dynamic quantization, if it is fast enough stop here, otherwise continue to step 3.</li> <li>Try post-training static quantization which can be faster than dynamic quantization but often with a drop in terms of
accuracy. Apply observers to your models in places where you want to quantize.</li> <li>Choose a calibration technique and perform it.</li> <li>Convert the model to its quantized form: the observers are removed and the <code>float32</code> operators are converted to their <code>int8</code>
coutnerparts.</li> <li>Evaluate the quantized model: is the accuracy good enough? If yes, stop here, otherwise start again at step 3 but
with quantization aware training this time.</li>`,Tt,ce,yt,ue,yi="🤗 Optimum provides APIs to perform quantization using different tools for different targets:",Mt,me,Mi=`<li>The <code>optimum.onnxruntime</code> package allows to
<a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/quantization" rel="nofollow">quantize and run ONNX models</a> using the
ONNX Runtime tool.</li> <li>The <code>optimum.intel</code> package enables to <a href="https://huggingface.co/docs/optimum/intel/optimization_inc" rel="nofollow">quantize</a> 🤗 Transformers
models while respecting accuracy and latency constraints.</li> <li>The <code>optimum.fx</code> package provides wrappers around the
<a href="https://pytorch.org/docs/stable/quantization-support.html#torch-quantization-quantize-fx" rel="nofollow">PyTorch quantization functions</a>
to allow graph-mode quantization of 🤗 Transformers models in PyTorch. This is a lower-level API compared to the two
mentioned above, giving more flexibility, but requiring more work on your end.</li> <li>The <code>optimum.gptq</code> package allows to <a href="../llm_quantization/usage_guides/quantization">quantize and run LLM models</a> with GPTQ.</li>`,xt,de,qt,T,zt,fe,xi=`The most fundamental unit of representation for computers is the bit. Everything in computers is represented as a
sequence of bits, including numbers. But the representation varies whether the numbers in question are integers or
real numbers.`,Ct,he,Lt,ge,qi=`Integers are usually represented with the following bit lengths: <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>. When representing integers, two cases
are considered:`,_t,be,zi=`<li>Unsigned (positive) integers: they are simply represented as a sequence of bits. Each bit corresponds to a power
of two (from <code>0</code> to <code>n-1</code> where <code>n</code> is the bit-length), and the resulting number is the sum of those powers of two.</li>`,Ht,ve,Ci="Example: <code>19</code> is represented as an unsigned int8 as <code>00010011</code> because :",jt,we,kt,y,Li=`<li>Signed integers: it is less straightforward to represent signed integers, and multiple approachs exist, the most
common being the <em>two’s complement</em>. For more information, you can check the
<a href="https://en.wikipedia.org/wiki/Signed_number_representations" rel="nofollow">Wikipedia page</a> on the subject.</li>`,Ut,$e,Pt,Te,_i=`Real numbers are usually represented with the following bit lengths: <code>16</code>, <code>32</code>, <code>64</code>.
The two main ways of representing real numbers are:`,It,ye,Hi="<li>Fixed-point: there are fixed number of digits reserved for representing the integer part and the fractional part.</li> <li>Floating-point: the number of digits for representing the integer and the fractional parts can vary.</li>",Jt,Me,ji=`The floating-point representation can represent bigger ranges of values, and this is the one we will be focusing on
since it is the most commonly used. There are three components in the floating-point representation:`,St,xe,ki="<li>The sign bit: this is the bit specifying the sign of the number.</li> <li>The exponent part</li>",At,qe,Ui="<li>5 bits in <code>float16</code></li> <li>8 bits in <code>bfloat16</code></li> <li>8 bits in <code>float32</code></li> <li>11 bits in <code>float64</code></li>",Qt,M,Pi="<li>The mantissa</li>",Nt,ze,Ii="<li>11 bits in <code>float16</code> (10 explictly stored)</li> <li>8 bits in <code>bfloat16</code> (7 explicitly stored)</li> <li>24 bits in <code>float32</code> (23 explictly stored)</li> <li>53 bits in <code>float64</code> (52 explictly stored)</li>",Bt,Ce,Ji=`For more information on the bits allocation for each data type, check the nice illustration on the Wikipedia page about
the <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16 floating-point format</a>.`,Ft,Le,Si="For a real number <code>x</code> we have:",Et,_e,Ot,He,Rt,je,Ai=`<li>The
<a href="https://arxiv.org/abs/1712.05877" rel="nofollow">Quantization and Training of Neural Networks for Efficient Integer-Arithmetic-Only Inference</a> paper</li> <li>The <a href="https://iq.opengenus.org/basics-of-quantization-in-ml/" rel="nofollow">Basics of Quantization in Machine Learning (ML) for Beginners</a>
blog post</li> <li>The <a href="https://tivadardanka.com/blog/neural-networks-quantization" rel="nofollow">How to accelerate and compress neural networks with quantization</a>
blog post</li> <li>The Wikipedia pages on integers representation <a href="https://en.wikipedia.org/wiki/Integer_(computer_science)" rel="nofollow">here</a> and
<a href="https://en.wikipedia.org/wiki/Signed_number_representations" rel="nofollow">here</a></li> <li>The Wikipedia pages on<ul><li><a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16 floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">Half-precision floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">Single-precision floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Double-precision_floating-point_format" rel="nofollow">Double-precision floating-point format</a></li></ul></li>`,Zt,Pe,Wt;return x=new b({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),C=new b({props:{title:"Theory",local:"theory",headingTag:"h2"}}),j=new Ue({props:{code:"QyUyMCUzRCUyMEElMjAlMkIlMjBC",highlighted:'<span class="hljs-attr">C</span> = A + B',wrap:!1}}),U=new b({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),I=new b({props:{title:"Quantization to float16",local:"quantization-to-float16",headingTag:"h3"}}),A=new b({props:{title:"Quantization to int8",local:"quantization-to-int8",headingTag:"h3"}}),B=new Ue({props:{code:"eCUyMCUzRCUyMFMlMjAqJTIwKHhfcSUyMC0lMjBaKQ==",highlighted:'<span class="hljs-attribute">x</span> <span class="hljs-operator">=</span> S * (x_q - Z)',wrap:!1}}),R=new Ue({props:{code:"eF9xJTIwJTNEJTIwcm91bmQoeCUyRlMlMjAlMkIlMjBaKQ==",highlighted:'<span class="hljs-variable">x_q</span> = <span class="hljs-function"><span class="hljs-title"><span class="hljs-built_in">round</span></span>(<span class="hljs-variable">x</span>/<span class="hljs-variable">S</span> + <span class="hljs-variable">Z</span>)</span>',wrap:!1}}),W=new Ue({props:{code:"eF9xJTIwJTNEJTIwY2xpcChyb3VuZCh4JTJGUyUyMCUyQiUyMFopJTJDJTIwcm91bmQoYSUyRlMlMjAlMkIlMjBaKSUyQyUyMHJvdW5kKGIlMkZTJTIwJTJCJTIwWikpJTBB",highlighted:`x_q = <span class="hljs-built_in">clip</span>(<span class="hljs-built_in">round</span>(x/S + Z), <span class="hljs-built_in">round</span>(a/S + Z), <span class="hljs-built_in">round</span>(b/S + Z))
`,wrap:!1}}),$=new Fi({props:{$$slots:{default:[Ki]},$$scope:{ctx:ke}}}),D=new b({props:{title:"Symmetric and affine quantization schemes",local:"symmetric-and-affine-quantization-schemes",headingTag:"h3"}}),X=new b({props:{title:"Per-tensor and per-channel quantization",local:"per-tensor-and-per-channel-quantization",headingTag:"h3"}}),te=new b({props:{title:"Calibration",local:"calibration",headingTag:"h3"}}),se=new b({props:{title:"Pratical steps to follow to quantize a model to int8",local:"pratical-steps-to-follow-to-quantize-a-model-to-int8",headingTag:"h3"}}),ce=new b({props:{title:"Supported tools to perform quantization in 🤗 Optimum",local:"supported-tools-to-perform-quantization-in--optimum",headingTag:"h2"}}),de=new b({props:{title:"Going further: How do machines represent numbers?",local:"going-further-how-do-machines-represent-numbers",headingTag:"h2"}}),T=new Fi({props:{$$slots:{default:[Vi]},$$scope:{ctx:ke}}}),he=new b({props:{title:"Integer representation",local:"integer-representation",headingTag:"h4"}}),we=new Ue({props:{code:"MTklMjAlM0QlMjAwJTIweCUyMDIlNUU3JTIwJTJCJTIwMCUyMHglMjAyJTVFNiUyMCUyQiUyMDAlMjB4JTIwMiU1RTUlMjAlMkIlMjAxJTIweCUyMDIlNUU0JTIwJTJCJTIwMCUyMHglMjAyJTVFMyUyMCUyQiUyMDAlMjB4JTIwMiU1RTIlMjAlMkIlMjAxJTIweCUyMDIlNUUxJTIwJTJCJTIwMSUyMHglMjAyJTVFMA==",highlighted:'<span class="hljs-attribute">19</span> = <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">7</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">6</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">5</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">4</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">3</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">2</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">1</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">0</span>',wrap:!1}}),$e=new b({props:{title:"Real numbers representation",local:"real-numbers-representation",headingTag:"h4"}}),_e=new Ue({props:{code:"eCUyMCUzRCUyMHNpZ24lMjB4JTIwbWFudGlzc2ElMjB4JTIwKDIlNUVleHBvbmVudCk=",highlighted:'<span class="hljs-keyword">x</span> <span class="hljs-operator">=</span> sign <span class="hljs-keyword">x</span> mantissa <span class="hljs-keyword">x</span> (<span class="hljs-number">2</span>^exponent)',wrap:!1}}),He=new b({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){p=l("meta"),v=a(),g=l("p"),w=a(),c(x.$$.fragment),Ie=a(),q=l("p"),q.innerHTML=Gt,Je=a(),z=l("p"),z.textContent=Kt,Se=a(),c(C.$$.fragment),Ae=a(),L=l("p"),L.textContent=Vt,Qe=a(),_=l("ul"),_.innerHTML=Xt,Ne=a(),H=l("p"),H.innerHTML=Yt,Be=a(),c(j.$$.fragment),Fe=a(),k=l("p"),k.innerHTML=ei,Ee=a(),c(U.$$.fragment),Oe=a(),P=l("p"),P.innerHTML=ti,Re=a(),c(I.$$.fragment),Ze=a(),J=l("p"),J.innerHTML=ii,We=a(),S=l("ul"),S.innerHTML=ni,De=a(),c(A.$$.fragment),Ge=a(),Q=l("p"),Q.innerHTML=ai,Ke=a(),N=l("p"),N.innerHTML=oi,Ve=a(),c(B.$$.fragment),Xe=a(),F=l("p"),F.textContent=li,Ye=a(),E=l("ul"),E.innerHTML=si,et=a(),O=l("p"),O.innerHTML=ri,tt=a(),c(R.$$.fragment),it=a(),Z=l("p"),Z.innerHTML=pi,nt=a(),c(W.$$.fragment),at=a(),c($.$$.fragment),ot=a(),c(D.$$.fragment),lt=a(),G=l("p"),G.innerHTML=ci,st=a(),K=l("p"),K.innerHTML=ui,rt=a(),V=l("p"),V.innerHTML=mi,pt=a(),c(X.$$.fragment),ct=a(),Y=l("p"),Y.textContent=di,ut=a(),ee=l("ul"),ee.innerHTML=fi,mt=a(),c(te.$$.fragment),dt=a(),ie=l("p"),ie.innerHTML=hi,ft=a(),ne=l("p"),ne.innerHTML=gi,ht=a(),ae=l("ol"),ae.innerHTML=bi,gt=a(),oe=l("p"),oe.textContent=vi,bt=a(),le=l("ul"),le.innerHTML=wi,vt=a(),c(se.$$.fragment),wt=a(),re=l("p"),re.innerHTML=$i,$t=a(),pe=l("ol"),pe.innerHTML=Ti,Tt=a(),c(ce.$$.fragment),yt=a(),ue=l("p"),ue.textContent=yi,Mt=a(),me=l("ul"),me.innerHTML=Mi,xt=a(),c(de.$$.fragment),qt=a(),c(T.$$.fragment),zt=a(),fe=l("p"),fe.textContent=xi,Ct=a(),c(he.$$.fragment),Lt=a(),ge=l("p"),ge.innerHTML=qi,_t=a(),be=l("ol"),be.innerHTML=zi,Ht=a(),ve=l("p"),ve.innerHTML=Ci,jt=a(),c(we.$$.fragment),kt=a(),y=l("ol"),y.innerHTML=Li,Ut=a(),c($e.$$.fragment),Pt=a(),Te=l("p"),Te.innerHTML=_i,It=a(),ye=l("ol"),ye.innerHTML=Hi,Jt=a(),Me=l("p"),Me.textContent=ji,St=a(),xe=l("ol"),xe.innerHTML=ki,At=a(),qe=l("ul"),qe.innerHTML=Ui,Qt=a(),M=l("ol"),M.innerHTML=Pi,Nt=a(),ze=l("ul"),ze.innerHTML=Ii,Bt=a(),Ce=l("p"),Ce.innerHTML=Ji,Ft=a(),Le=l("p"),Le.innerHTML=Si,Et=a(),c(_e.$$.fragment),Ot=a(),c(He.$$.fragment),Rt=a(),je=l("ul"),je.innerHTML=Ai,Zt=a(),Pe=l("p"),this.h()},l(e){const t=Di("svelte-u9bgzb",document.head);p=s(t,"META",{name:!0,content:!0}),t.forEach(i),v=o(e),g=s(e,"P",{}),Bi(g).forEach(i),w=o(e),u(x.$$.fragment,e),Ie=o(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-p89nc2"&&(q.innerHTML=Gt),Je=o(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-525bhg"&&(z.textContent=Kt),Se=o(e),u(C.$$.fragment,e),Ae=o(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-b9e65e"&&(L.textContent=Vt),Qe=o(e),_=s(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1jnatgf"&&(_.innerHTML=Xt),Ne=o(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1vh20e4"&&(H.innerHTML=Yt),Be=o(e),u(j.$$.fragment,e),Fe=o(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-txsgkq"&&(k.innerHTML=ei),Ee=o(e),u(U.$$.fragment,e),Oe=o(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-jca8pk"&&(P.innerHTML=ti),Re=o(e),u(I.$$.fragment,e),Ze=o(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1vonttx"&&(J.innerHTML=ii),We=o(e),S=s(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-j3zm40"&&(S.innerHTML=ni),De=o(e),u(A.$$.fragment,e),Ge=o(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-w5smo0"&&(Q.innerHTML=ai),Ke=o(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1hvpx8c"&&(N.innerHTML=oi),Ve=o(e),u(B.$$.fragment,e),Xe=o(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-uc2av9"&&(F.textContent=li),Ye=o(e),E=s(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-55l006"&&(E.innerHTML=si),et=o(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-vbg2s5"&&(O.innerHTML=ri),tt=o(e),u(R.$$.fragment,e),it=o(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-174sqfa"&&(Z.innerHTML=pi),nt=o(e),u(W.$$.fragment,e),at=o(e),u($.$$.fragment,e),ot=o(e),u(D.$$.fragment,e),lt=o(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1erfvtl"&&(G.innerHTML=ci),st=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1m565uj"&&(K.innerHTML=ui),rt=o(e),V=s(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vjpm0g"&&(V.innerHTML=mi),pt=o(e),u(X.$$.fragment,e),ct=o(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-d46ged"&&(Y.textContent=di),ut=o(e),ee=s(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-1h6e562"&&(ee.innerHTML=fi),mt=o(e),u(te.$$.fragment,e),dt=o(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1fm4s9k"&&(ie.innerHTML=hi),ft=o(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9f9h6s"&&(ne.innerHTML=gi),ht=o(e),ae=s(e,"OL",{"data-svelte-h":!0}),r(ae)!=="svelte-1e9v2jr"&&(ae.innerHTML=bi),gt=o(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-bp3yi9"&&(oe.textContent=vi),bt=o(e),le=s(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-1y2stc2"&&(le.innerHTML=wi),vt=o(e),u(se.$$.fragment,e),wt=o(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-5xtk1x"&&(re.innerHTML=$i),$t=o(e),pe=s(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-ej0tmd"&&(pe.innerHTML=Ti),Tt=o(e),u(ce.$$.fragment,e),yt=o(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-3ofdc8"&&(ue.textContent=yi),Mt=o(e),me=s(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-163ivnk"&&(me.innerHTML=Mi),xt=o(e),u(de.$$.fragment,e),qt=o(e),u(T.$$.fragment,e),zt=o(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-h5k7ub"&&(fe.textContent=xi),Ct=o(e),u(he.$$.fragment,e),Lt=o(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-pndq9n"&&(ge.innerHTML=qi),_t=o(e),be=s(e,"OL",{"data-svelte-h":!0}),r(be)!=="svelte-s3ctan"&&(be.innerHTML=zi),Ht=o(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-73e7m1"&&(ve.innerHTML=Ci),jt=o(e),u(we.$$.fragment,e),kt=o(e),y=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1usbjfc"&&(y.innerHTML=Li),Ut=o(e),u($e.$$.fragment,e),Pt=o(e),Te=s(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1vnsbhs"&&(Te.innerHTML=_i),It=o(e),ye=s(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-acn83z"&&(ye.innerHTML=Hi),Jt=o(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-vm5l3c"&&(Me.textContent=ji),St=o(e),xe=s(e,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-1g2q9e4"&&(xe.innerHTML=ki),At=o(e),qe=s(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-18dzkd8"&&(qe.innerHTML=Ui),Qt=o(e),M=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(M)!=="svelte-48nw91"&&(M.innerHTML=Pi),Nt=o(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1gkiele"&&(ze.innerHTML=Ii),Bt=o(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1ugjpds"&&(Ce.innerHTML=Ji),Ft=o(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-9ui238"&&(Le.innerHTML=Si),Et=o(e),u(_e.$$.fragment,e),Ot=o(e),u(He.$$.fragment,e),Rt=o(e),je=s(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-ertv4x"&&(je.innerHTML=Ai),Zt=o(e),Pe=s(e,"P",{}),Bi(Pe).forEach(i),this.h()},h(){Dt(p,"name","hf:doc:metadata"),Dt(p,"content",Yi),Dt(y,"start","2"),Dt(M,"start","2")},m(e,t){Gi(document.head,p),n(e,v,t),n(e,g,t),n(e,w,t),m(x,e,t),n(e,Ie,t),n(e,q,t),n(e,Je,t),n(e,z,t),n(e,Se,t),m(C,e,t),n(e,Ae,t),n(e,L,t),n(e,Qe,t),n(e,_,t),n(e,Ne,t),n(e,H,t),n(e,Be,t),m(j,e,t),n(e,Fe,t),n(e,k,t),n(e,Ee,t),m(U,e,t),n(e,Oe,t),n(e,P,t),n(e,Re,t),m(I,e,t),n(e,Ze,t),n(e,J,t),n(e,We,t),n(e,S,t),n(e,De,t),m(A,e,t),n(e,Ge,t),n(e,Q,t),n(e,Ke,t),n(e,N,t),n(e,Ve,t),m(B,e,t),n(e,Xe,t),n(e,F,t),n(e,Ye,t),n(e,E,t),n(e,et,t),n(e,O,t),n(e,tt,t),m(R,e,t),n(e,it,t),n(e,Z,t),n(e,nt,t),m(W,e,t),n(e,at,t),m($,e,t),n(e,ot,t),m(D,e,t),n(e,lt,t),n(e,G,t),n(e,st,t),n(e,K,t),n(e,rt,t),n(e,V,t),n(e,pt,t),m(X,e,t),n(e,ct,t),n(e,Y,t),n(e,ut,t),n(e,ee,t),n(e,mt,t),m(te,e,t),n(e,dt,t),n(e,ie,t),n(e,ft,t),n(e,ne,t),n(e,ht,t),n(e,ae,t),n(e,gt,t),n(e,oe,t),n(e,bt,t),n(e,le,t),n(e,vt,t),m(se,e,t),n(e,wt,t),n(e,re,t),n(e,$t,t),n(e,pe,t),n(e,Tt,t),m(ce,e,t),n(e,yt,t),n(e,ue,t),n(e,Mt,t),n(e,me,t),n(e,xt,t),m(de,e,t),n(e,qt,t),m(T,e,t),n(e,zt,t),n(e,fe,t),n(e,Ct,t),m(he,e,t),n(e,Lt,t),n(e,ge,t),n(e,_t,t),n(e,be,t),n(e,Ht,t),n(e,ve,t),n(e,jt,t),m(we,e,t),n(e,kt,t),n(e,y,t),n(e,Ut,t),m($e,e,t),n(e,Pt,t),n(e,Te,t),n(e,It,t),n(e,ye,t),n(e,Jt,t),n(e,Me,t),n(e,St,t),n(e,xe,t),n(e,At,t),n(e,qe,t),n(e,Qt,t),n(e,M,t),n(e,Nt,t),n(e,ze,t),n(e,Bt,t),n(e,Ce,t),n(e,Ft,t),n(e,Le,t),n(e,Et,t),m(_e,e,t),n(e,Ot,t),m(He,e,t),n(e,Rt,t),n(e,je,t),n(e,Zt,t),n(e,Pe,t),Wt=!0},p(e,[t]){const Qi={};t&2&&(Qi.$$scope={dirty:t,ctx:e}),$.$set(Qi);const Ni={};t&2&&(Ni.$$scope={dirty:t,ctx:e}),T.$set(Ni)},i(e){Wt||(d(x.$$.fragment,e),d(C.$$.fragment,e),d(j.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(A.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d($.$$.fragment,e),d(D.$$.fragment,e),d(X.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(T.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d($e.$$.fragment,e),d(_e.$$.fragment,e),d(He.$$.fragment,e),Wt=!0)},o(e){f(x.$$.fragment,e),f(C.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),f(B.$$.fragment,e),f(R.$$.fragment,e),f(W.$$.fragment,e),f($.$$.fragment,e),f(D.$$.fragment,e),f(X.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(T.$$.fragment,e),f(he.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),f(_e.$$.fragment,e),f(He.$$.fragment,e),Wt=!1},d(e){e&&(i(v),i(g),i(w),i(Ie),i(q),i(Je),i(z),i(Se),i(Ae),i(L),i(Qe),i(_),i(Ne),i(H),i(Be),i(Fe),i(k),i(Ee),i(Oe),i(P),i(Re),i(Ze),i(J),i(We),i(S),i(De),i(Ge),i(Q),i(Ke),i(N),i(Ve),i(Xe),i(F),i(Ye),i(E),i(et),i(O),i(tt),i(it),i(Z),i(nt),i(at),i(ot),i(lt),i(G),i(st),i(K),i(rt),i(V),i(pt),i(ct),i(Y),i(ut),i(ee),i(mt),i(dt),i(ie),i(ft),i(ne),i(ht),i(ae),i(gt),i(oe),i(bt),i(le),i(vt),i(wt),i(re),i($t),i(pe),i(Tt),i(yt),i(ue),i(Mt),i(me),i(xt),i(qt),i(zt),i(fe),i(Ct),i(Lt),i(ge),i(_t),i(be),i(Ht),i(ve),i(jt),i(kt),i(y),i(Ut),i(Pt),i(Te),i(It),i(ye),i(Jt),i(Me),i(St),i(xe),i(At),i(qe),i(Qt),i(M),i(Nt),i(ze),i(Bt),i(Ce),i(Ft),i(Le),i(Et),i(Ot),i(Rt),i(je),i(Zt),i(Pe)),i(p),h(x,e),h(C,e),h(j,e),h(U,e),h(I,e),h(A,e),h(B,e),h(R,e),h(W,e),h($,e),h(D,e),h(X,e),h(te,e),h(se,e),h(ce,e),h(de,e),h(T,e),h(he,e),h(we,e),h($e,e),h(_e,e),h(He,e)}}}const Yi='{"title":"Quantization","local":"quantization","sections":[{"title":"Theory","local":"theory","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[{"title":"Quantization to float16","local":"quantization-to-float16","sections":[],"depth":3},{"title":"Quantization to int8","local":"quantization-to-int8","sections":[],"depth":3},{"title":"Symmetric and affine quantization schemes","local":"symmetric-and-affine-quantization-schemes","sections":[],"depth":3},{"title":"Per-tensor and per-channel quantization","local":"per-tensor-and-per-channel-quantization","sections":[],"depth":3},{"title":"Calibration","local":"calibration","sections":[],"depth":3},{"title":"Pratical steps to follow to quantize a model to int8","local":"pratical-steps-to-follow-to-quantize-a-model-to-int8","sections":[],"depth":3}],"depth":2},{"title":"Supported tools to perform quantization in 🤗 Optimum","local":"supported-tools-to-perform-quantization-in--optimum","sections":[],"depth":2},{"title":"Going further: How do machines represent numbers?","local":"going-further-how-do-machines-represent-numbers","sections":[{"title":"Integer representation","local":"integer-representation","sections":[],"depth":4},{"title":"Real numbers representation","local":"real-numbers-representation","sections":[],"depth":4}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function en(ke){return Ri(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sn extends Zi{constructor(p){super(),Wi(this,p,en,Xi,Oi,{})}}export{sn as component};
