import{S as ru,i as iu,s as lu,e as o,k as m,w as k,t as n,M as cu,c as a,d as t,m as g,a as r,x as j,h as s,b as u,G as e,g as x,y as w,q as $,o as L,B as T,v as du,L as De}from"../../chunks/vendor-hf-doc-builder.js";import{T as tt}from"../../chunks/Tip-hf-doc-builder.js";import{D as N}from"../../chunks/Docstring-hf-doc-builder.js";import{C as Ae}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as Ia}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as Fe}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function pu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import GenerationConfig

# Download configuration from huggingface.co and cache.
generation_config = GenerationConfig.from_pretrained("gpt2")

# E.g. config was saved using *save_pretrained('./test/saved_model/')*
generation_config.save_pretrained("./test/saved_model/")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/")

# You can also specify configuration names to your generation configuration file
generation_config.save_pretrained("./test/saved_model/", config_file_name="my_configuration.json")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/", "my_configuration.json")

# If you'd like to try a minor variation to an existing configuration, you can also pass generation
# arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored
generation_config, unused_kwargs = GenerationConfig.from_pretrained(
    "gpt2", top_k=1, foo=False, return_unused_kwargs=True
)
generation_config.top_k

unused_kwargs`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function mu(G){let c,_,p,d,f,i,h,E,y,b,M,O,F,ie,B,J,I;return{c(){c=o("p"),_=n("Most generation-controlling parameters are set in "),p=o("code"),d=n("generation_config"),f=n(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=o("code"),h=n("generation_config"),E=n(` by passing the corresponding
parameters to generate(), e.g. `),y=o("code"),b=n(".generate(inputs, num_beams=4, do_sample=True)"),M=n("."),O=m(),F=o("p"),ie=n("For an overview of generation strategies and code examples, check out the "),B=o("a"),J=n(`following
guide`),I=n("."),this.h()},l(C){c=a(C,"P",{});var q=r(c);_=s(q,"Most generation-controlling parameters are set in "),p=a(q,"CODE",{});var X=r(p);d=s(X,"generation_config"),X.forEach(t),f=s(q,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(q,"CODE",{});var ze=r(i);h=s(ze,"generation_config"),ze.forEach(t),E=s(q,` by passing the corresponding
parameters to generate(), e.g. `),y=a(q,"CODE",{});var Ne=r(y);b=s(Ne,".generate(inputs, num_beams=4, do_sample=True)"),Ne.forEach(t),M=s(q,"."),q.forEach(t),O=g(C),F=a(C,"P",{});var R=r(F);ie=s(R,"For an overview of generation strategies and code examples, check out the "),B=a(R,"A",{href:!0});var Ie=r(B);J=s(Ie,`following
guide`),Ie.forEach(t),I=s(R,"."),R.forEach(t),this.h()},h(){u(B,"href","../generation_strategies")},m(C,q){x(C,c,q),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E),e(c,y),e(y,b),e(c,M),x(C,O,q),x(C,F,q),e(F,ie),e(F,B),e(B,J),e(F,I)},d(C){C&&t(c),C&&t(O),C&&t(F)}}}function gu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import GPT2Tokenizer, AutoModelForCausalLM
import numpy as np

tokenizer = GPT2Tokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")
tokenizer.pad_token_id = tokenizer.eos_token_id
inputs = tokenizer(["Today is"], return_tensors="pt")

# Example 1: Print the scores for each token generated with Greedy Search
outputs = model.generate(**inputs, max_new_tokens=5, return_dict_in_generate=True, output_scores=True)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, normalize_logits=True
)
# input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for
# encoder-decoder models, like BART or T5.
input_length = 1 if model.config.is_encoder_decoder else inputs.input_ids.shape[1]
generated_tokens = outputs.sequences[:, input_length:]
for tok, score in zip(generated_tokens[0], transition_scores[0]):
    # | token | token string | logits | probability
    print(f"| {tok:5d} | {tokenizer.decode(tok):8s} | {score.numpy():.3f} | {np.exp(score.numpy()):.2%}")

# Example 2: Reconstruct the sequence scores from Beam Search
outputs = model.generate(
    **inputs,
    max_new_tokens=5,
    num_beams=4,
    num_return_sequences=4,
    return_dict_in_generate=True,
    output_scores=True,
)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=False
)
# If you sum the generated tokens' scores and apply the length penalty, you'll get the sequence scores.
# Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the
# use case, you might want to recompute it with \`normalize_logits=True\`.
output_length = input_length + np.sum(transition_scores.numpy() < 0, axis=1)
length_penalty = model.generation_config.length_penalty
reconstructed_scores = transition_scores.sum(axis=1) / (output_length**length_penalty)
print(np.allclose(outputs.sequences_scores, reconstructed_scores))`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function hu(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("greedy_search()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"greedy_search()"),M.forEach(t),f=s(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function uu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a PAD token
model.generation_config.pad_token_id = model.generation_config.eos_token_id

input_prompt = "It might be possible to"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(10, eos_token_id=model.generation_config.eos_token_id),
    ]
)
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

outputs = model.greedy_search(
    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.generation_config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;It might be possible to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">10</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.greedy_search(
<span class="hljs-meta">... </span>    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;It might be possible to get a better understanding of the nature of the problem, but it&#x27;s not&quot;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function fu(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("sample()"),f=n(` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"sample()"),M.forEach(t),f=s(b,` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function _u(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    StoppingCriteriaList,
    MaxLengthCriteria,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a EOS token
model.config.pad_token_id = model.config.eos_token_id
model.generation_config.pad_token_id = model.config.eos_token_id

input_prompt = "Today is a beautiful day, and"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(15, eos_token_id=model.generation_config.eos_token_id),
    ]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

torch.manual_seed(0)
outputs = model.sample(
    input_ids,
    logits_processor=logits_processor,
    logits_warper=logits_warper,
    stopping_criteria=stopping_criteria,
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;Today is a beautiful day, and&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">15</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.sample(
<span class="hljs-meta">... </span>    input_ids,
<span class="hljs-meta">... </span>    logits_processor=logits_processor,
<span class="hljs-meta">... </span>    logits_warper=logits_warper,
<span class="hljs-meta">... </span>    stopping_criteria=stopping_criteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today is a beautiful day, and we must do everything possible to make it a day of celebration.&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function bu(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("beam_search()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"beam_search()"),M.forEach(t),f=s(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function vu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function xu(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("beam_sample()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"beam_sample()"),M.forEach(t),f=s(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function yu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids

# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id)]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

outputs = model.beam_sample(
    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_sample(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function ku(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("contrastive_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"contrastive_search()"),M.forEach(t),f=s(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function ju(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("facebook/opt-125m")
model = AutoModelForCausalLM.from_pretrained("facebook/opt-125m")
# set pad_token_id to eos_token_id because OPT does not have a PAD token
model.config.pad_token_id = model.config.eos_token_id
input_prompt = "DeepMind Company is"
input_ids = tokenizer(input_prompt, return_tensors="pt")
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=64)])
outputs = model.contrastive_search(
    **input_ids, penalty_alpha=0.6, top_k=4, stopping_criteria=stopping_criteria
)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because OPT does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;DeepMind Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">64</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.contrastive_search(
<span class="hljs-meta">... </span>    **input_ids, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;DeepMind Company is a company that focuses on the development and commercialization of artificial intelligence (AI). DeepMind\u2019s mission is to help people understand and solve problems that are difficult to solve in the world today.\\n\\nIn this post, we talk about the benefits of deep learning in business and how it&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function wu(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("group_beam_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"group_beam_search()"),M.forEach(t),f=s(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function $u(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    HammingDiversityLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run diverse beam search using 6 beams
num_beams = 6
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
    num_beam_groups=3,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        HammingDiversityLogitsProcessor(5.5, num_beams=6, num_beam_groups=3),
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.group_beam_search(
    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    HammingDiversityLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run diverse beam search using 6 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        HammingDiversityLogitsProcessor(<span class="hljs-number">5.5</span>, num_beams=<span class="hljs-number">6</span>, num_beam_groups=<span class="hljs-number">3</span>),
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.group_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function Lu(G){let c,_,p,d,f,i,h,E;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("constrained_beam_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=s(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var M=r(p);d=s(M,"constrained_beam_search()"),M.forEach(t),f=s(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=s(O,`following
guide`),O.forEach(t),E=s(b,"."),b.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E)},d(y){y&&t(c)}}}function Tu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    ConstrainedBeamSearchScorer,
    PhrasalConstraint,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

constraint_str = "Sie"
constraint_token_ids = tokenizer.encode(constraint_str)[:-1]  # slice to remove eos token
constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


# instantiate beam scorer
beam_scorer = ConstrainedBeamSearchScorer(
    batch_size=1, num_beams=num_beams, device=model.device, constraints=constraints
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.constrained_beam_search(
    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    ConstrainedBeamSearchScorer,
<span class="hljs-meta">... </span>    PhrasalConstraint,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_str = <span class="hljs-string">&quot;Sie&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_token_ids = tokenizer.encode(constraint_str)[:-<span class="hljs-number">1</span>]  <span class="hljs-comment"># slice to remove eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = ConstrainedBeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>, num_beams=num_beams, device=model.device, constraints=constraints
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.constrained_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt sind Sie?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function Eu(G){let c,_,p,d,f,i,h,E,y,b,M,O,F,ie,B,J,I;return{c(){c=o("p"),_=n("Most generation-controlling parameters are set in "),p=o("code"),d=n("generation_config"),f=n(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=o("code"),h=n("generation_config"),E=n(` by passing the corresponding
parameters to generate, e.g. `),y=o("code"),b=n(".generate(inputs, num_beams=4, do_sample=True)"),M=n("."),O=m(),F=o("p"),ie=n("For an overview of generation strategies and code examples, check out the "),B=o("a"),J=n(`following
guide`),I=n("."),this.h()},l(C){c=a(C,"P",{});var q=r(c);_=s(q,"Most generation-controlling parameters are set in "),p=a(q,"CODE",{});var X=r(p);d=s(X,"generation_config"),X.forEach(t),f=s(q,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(q,"CODE",{});var ze=r(i);h=s(ze,"generation_config"),ze.forEach(t),E=s(q,` by passing the corresponding
parameters to generate, e.g. `),y=a(q,"CODE",{});var Ne=r(y);b=s(Ne,".generate(inputs, num_beams=4, do_sample=True)"),Ne.forEach(t),M=s(q,"."),q.forEach(t),O=g(C),F=a(C,"P",{});var R=r(F);ie=s(R,"For an overview of generation strategies and code examples, check out the "),B=a(R,"A",{href:!0});var Ie=r(B);J=s(Ie,`following
guide`),Ie.forEach(t),I=s(R,"."),R.forEach(t),this.h()},h(){u(B,"href","../generation_strategies")},m(C,q){x(C,c,q),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,E),e(c,y),e(y,b),e(c,M),x(C,O,q),x(C,F,q),e(F,ie),e(F,B),e(B,J),e(F,I)},d(C){C&&t(c),C&&t(O),C&&t(F)}}}function Gu(G){let c,_,p,d,f;return d=new Ae({props:{code:`from transformers import GPT2Tokenizer, TFAutoModelForCausalLM
import numpy as np

tokenizer = GPT2Tokenizer.from_pretrained("gpt2")
model = TFAutoModelForCausalLM.from_pretrained("gpt2")
tokenizer.pad_token_id = tokenizer.eos_token_id
inputs = tokenizer(["Today is"], return_tensors="tf")

# Example 1: Print the scores for each token generated with Greedy Search
outputs = model.generate(**inputs, max_new_tokens=5, return_dict_in_generate=True, output_scores=True)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, normalize_logits=True
)
# input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for
# encoder-decoder models, like BART or T5.
input_length = 1 if model.config.is_encoder_decoder else inputs.input_ids.shape[1]
generated_tokens = outputs.sequences[:, input_length:]
for tok, score in zip(generated_tokens[0], transition_scores[0]):
    # | token | token string | logits | probability
    print(f"| {tok:5d} | {tokenizer.decode(tok):8s} | {score.numpy():.3f} | {np.exp(score.numpy()):.2%}")

# Example 2: Reconstruct the sequence scores from Beam Search
outputs = model.generate(
    **inputs,
    max_new_tokens=5,
    num_beams=4,
    num_return_sequences=4,
    return_dict_in_generate=True,
    output_scores=True,
)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=False
)
# If you sum the generated tokens' scores and apply the length penalty, you'll get the sequence scores.
# Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the
# use case, you might want to recompute it with \`normalize_logits=True\`.
output_length = input_length + np.sum(transition_scores.numpy() < 0, axis=1)
length_penalty = model.generation_config.length_penalty
reconstructed_scores = np.sum(transition_scores, axis=1) / (output_length**length_penalty)
print(np.allclose(outputs.sequences_scores, reconstructed_scores))`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.413</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.009</span> | <span class="hljs-number">13.41</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,h){x(i,c,h),e(c,_),x(i,p,h),w(d,i,h),f=!0},p:De,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function Mu(G){let c,_,p,d,f,i,h,E,y,b,M,O,F,ie,B,J,I,C,q,X,ze,Ne,R,Ie,$r,Lr,Be,Tr,Xn,Er,Gr,Qn,Mr,Or,Cr,We,Sr,es,qr,Pr,ts,Fr,Dr,Ba,nt,Ar,ns,zr,Nr,Wa,st,Ir,ss,Br,Wr,Ua,Ue,ot,Bs,an,Ur,Ws,Rr,Ra,D,rn,Hr,ln,Vr,Us,Yr,Kr,Zr,A,le,Rs,Jr,Xr,os,Qr,ei,Hs,ti,ni,Vs,si,oi,ce,Ys,ai,ri,as,ii,li,Ks,ci,di,Zs,pi,mi,de,Js,gi,hi,rs,ui,fi,Xs,_i,bi,Qs,vi,xi,pe,eo,yi,ki,is,ji,wi,to,$i,Li,no,Ti,Ei,me,so,Gi,Mi,ls,Oi,Ci,oo,Si,qi,ao,Pi,Fi,ge,ro,Di,Ai,cs,zi,Ni,io,Ii,Bi,lo,Wi,Ui,he,co,Ri,Hi,ds,Vi,Yi,po,Ki,Zi,mo,Ji,Xi,ue,go,Qi,el,ho,tl,nl,uo,sl,ol,fo,al,rl,cn,il,ps,ll,cl,dl,Me,dn,pl,pn,ml,ms,gl,hl,ul,at,fl,rt,mn,_l,Z,bl,gs,vl,xl,hs,yl,kl,us,jl,wl,fs,$l,Ll,Tl,it,gn,El,Re,Gl,_o,Ml,Ol,_s,Cl,Sl,Ha,He,lt,bo,hn,ql,vo,Pl,Va,S,un,Fl,fn,Dl,bs,Al,zl,Nl,_n,Il,vs,Bl,Wl,Ul,W,fe,xo,Rl,Hl,xs,Vl,Yl,yo,Kl,Zl,ko,Jl,Xl,_e,jo,Ql,ec,ys,tc,nc,wo,sc,oc,$o,ac,rc,be,Lo,ic,lc,ks,cc,dc,To,pc,mc,Eo,gc,hc,ve,Go,uc,fc,js,_c,bc,Mo,vc,xc,Oo,yc,kc,xe,Co,jc,wc,ws,$c,Lc,So,Tc,Ec,qo,Gc,Mc,ye,Po,Oc,Cc,$s,Sc,qc,Fo,Pc,Fc,Do,Dc,Ac,ke,Ao,zc,Nc,Ls,Ic,Bc,zo,Wc,Uc,No,Rc,Hc,bn,Vc,Ts,Yc,Kc,Zc,Oe,vn,Jc,Io,Xc,Qc,ct,ed,Ce,xn,td,Bo,nd,sd,dt,od,Q,yn,ad,kn,rd,Wo,id,ld,cd,pt,dd,mt,pd,ee,jn,md,wn,gd,Uo,hd,ud,fd,gt,_d,ht,bd,te,$n,vd,Ln,xd,Ro,yd,kd,jd,ut,wd,ft,$d,ne,Tn,Ld,En,Td,Ho,Ed,Gd,Md,_t,Od,bt,Cd,se,Gn,Sd,Mn,qd,Vo,Pd,Fd,Dd,vt,Ad,xt,zd,oe,On,Nd,Cn,Id,Yo,Bd,Wd,Ud,yt,Rd,kt,Hd,ae,Sn,Vd,qn,Yd,Ko,Kd,Zd,Jd,jt,Xd,wt,Ya,Ve,$t,Zo,Pn,Qd,Jo,ep,Ka,z,Fn,tp,Dn,np,Es,sp,op,ap,An,rp,Gs,ip,lp,cp,je,we,Xo,dp,pp,Qo,mp,gp,ea,hp,up,ta,fp,_p,$e,na,bp,vp,sa,xp,yp,oa,kp,jp,aa,wp,$p,Le,ra,Lp,Tp,ia,Ep,Gp,la,Mp,Op,ca,Cp,Sp,Ye,da,qp,Pp,pa,Fp,Dp,ma,Ap,zp,zn,Np,Ms,Ip,Bp,Wp,Se,Nn,Up,ga,Rp,Hp,Lt,Vp,qe,In,Yp,ha,Kp,Zp,Tt,Za,Ke,Et,ua,Bn,Jp,fa,Xp,Ja,U,Wn,Qp,Un,em,Os,tm,nm,sm,Rn,om,Cs,am,rm,im,Ze,Te,_a,lm,cm,ba,dm,pm,va,mm,gm,xa,hm,um,Ee,ya,fm,_m,ka,bm,vm,ja,xm,ym,wa,km,jm,Ge,$a,wm,$m,La,Lm,Tm,Ta,Em,Gm,Ea,Mm,Om,Hn,Cm,Ss,Sm,qm,Pm,Gt,Vn,Fm,Ga,Dm,Xa;return i=new Ia({}),an=new Ia({}),rn=new N({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/configuration_utils.py#L38",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated. In order to get the token ids of the words that
should not appear in the generated text, use <code>tokenizer(bad_words, add_prefix_space=True, add_special_tokens=False).input_ids</code>.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"}]},{title:"Parameters that define the output variables of `generate`",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"}]},{title:"Wild card",parametersDescription:[]}]}}),dn=new N({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/configuration_utils.py#L375",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),at=new Fe({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[pu]},$$scope:{ctx:G}}}),mn=new N({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/configuration_utils.py#L667",returnDescription:`
<p>The configuration object instantiated from those parameters.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),gn=new N({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.29.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a> method.`,name:"push_to_hub"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/configuration_utils.py#L325"}}),hn=new Ia({}),un=new N({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L469"}}),vn=new N({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L1145",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),ct=new tt({props:{warning:!0,$$slots:{default:[mu]},$$scope:{ctx:G}}}),xn=new N({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[torch.Tensor]"},{name:"beam_indices",val:": typing.Optional[torch.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with
each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L975",returnDescription:`
<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>torch.Tensor</code></p>
`}}),dt=new Fe({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[gu]},$$scope:{ctx:G}}}),yn=new N({props:{name:"greedy_search",anchor:"transformers.GenerationMixin.greedy_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.greedy_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.greedy_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.greedy_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.greedy_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.greedy_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.greedy_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.greedy_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.greedy_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.greedy_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.greedy_search.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L2164",returnDescription:`
<p><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),pt=new tt({props:{warning:!0,$$slots:{default:[hu]},$$scope:{ctx:G}}}),mt=new Fe({props:{anchor:"transformers.GenerationMixin.greedy_search.example",$$slots:{default:[uu]},$$scope:{ctx:G}}}),jn=new N({props:{name:"sample",anchor:"transformers.GenerationMixin.sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.sample.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L2423",returnDescription:`
<p>A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> or <code>torch.LongTensor</code></p>
`}}),gt=new tt({props:{warning:!0,$$slots:{default:[fu]},$$scope:{ctx:G}}}),ht=new Fe({props:{anchor:"transformers.GenerationMixin.sample.example",$$slots:{default:[_u]},$$scope:{ctx:G}}}),$n=new N({props:{name:"beam_search",anchor:"transformers.GenerationMixin.beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L2705",returnDescription:`
<p><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ut=new tt({props:{warning:!0,$$slots:{default:[bu]},$$scope:{ctx:G}}}),ft=new Fe({props:{anchor:"transformers.GenerationMixin.beam_search.example",$$slots:{default:[vu]},$$scope:{ctx:G}}}),Tn=new N({props:{name:"beam_sample",anchor:"transformers.GenerationMixin.beam_sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_sample.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.beam_sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L3028",returnDescription:`
<p><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),_t=new tt({props:{warning:!0,$$slots:{default:[xu]},$$scope:{ctx:G}}}),bt=new Fe({props:{anchor:"transformers.GenerationMixin.beam_sample.example",$$slots:{default:[yu]},$$scope:{ctx:G}}}),Gn=new N({props:{name:"contrastive_search",anchor:"transformers.GenerationMixin.contrastive_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"top_k",val:": typing.Optional[int] = 1"},{name:"penalty_alpha",val:": typing.Optional[float] = 0"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.contrastive_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.contrastive_search.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the candidate set that is used to re-rank for contrastive search`,name:"top_k"},{anchor:"transformers.GenerationMixin.contrastive_search.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The degeneration penalty for contrastive search; activate when it is larger than 0`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.contrastive_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.contrastive_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.contrastive_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.contrastive_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.contrastive_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.contrastive_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.contrastive_search.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L1790",returnDescription:`
<p><code>ContrastiveSearchDecoderOnlyOutput</code>, <code>ContrastiveSearchEncoderDecoderOutput</code>
or <code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<code>ContrastiveSearchDecoderOnlyOutput</code> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <code>ContrastiveSearchEncoderDecoderOutput</code> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),vt=new tt({props:{warning:!0,$$slots:{default:[ku]},$$scope:{ctx:G}}}),xt=new Fe({props:{anchor:"transformers.GenerationMixin.contrastive_search.example",$$slots:{default:[ju]},$$scope:{ctx:G}}}),On=new N({props:{name:"group_beam_search",anchor:"transformers.GenerationMixin.group_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.group_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.group_beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.group_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.group_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.group_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.group_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.group_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.group_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.group_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.group_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)</p>
<p>model_kwargs &#x2014;
Additional model specific kwargs that will be forwarded to the <code>forward</code> function of the model. If
model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L3361",returnDescription:`
<p><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if
<code>model.config.is_encoder_decoder=False</code> and <code>return_dict_in_generate=True</code> or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if <code>model.config.is_encoder_decoder=True</code>.</p>
`}}),yt=new tt({props:{warning:!0,$$slots:{default:[wu]},$$scope:{ctx:G}}}),kt=new Fe({props:{anchor:"transformers.GenerationMixin.group_beam_search.example",$$slots:{default:[$u]},$$scope:{ctx:G}}}),Sn=new N({props:{name:"constrained_beam_search",anchor:"transformers.GenerationMixin.constrained_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"constrained_beam_scorer",val:": ConstrainedBeamSearchScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.constrained_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.constrained_beam_search.constrained_beam_scorer",description:`<strong>constrained_beam_scorer</strong> (<code>ConstrainedBeamSearchScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation, while satisfying a list of positive constraints. For more information, the
documentation of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.ConstrainedBeamSearchScorer">ConstrainedBeamSearchScorer</a> should be read.`,name:"constrained_beam_scorer"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.constrained_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.constrained_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.constrained_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.constrained_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.constrained_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/utils.py#L3741",returnDescription:`
<p><a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.29.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),jt=new tt({props:{warning:!0,$$slots:{default:[Lu]},$$scope:{ctx:G}}}),wt=new Fe({props:{anchor:"transformers.GenerationMixin.constrained_beam_search.example",$$slots:{default:[Tu]},$$scope:{ctx:G}}}),Pn=new Ia({}),Fn=new N({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/tf_utils.py#L444"}}),Nn=new N({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.tf_logits_process.TFLogitsProcessorList] = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"seed"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/tf_utils.py#L666",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchDecoderOnlyOutput</code>,</li>
<li><code>TFSampleDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSearchDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSampleDecoderOnlyOutput</code></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchEncoderDecoderOutput</code>,</li>
<li><code>TFSampleEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSearchEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSampleEncoderDecoderOutput</code></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),Lt=new tt({props:{warning:!0,$$slots:{default:[Eu]},$$scope:{ctx:G}}}),In=new N({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[tensorflow.python.framework.ops.Tensor]"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/tf_utils.py#L498",returnDescription:`
<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>tf.Tensor</code></p>
`}}),Tt=new Fe({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[Gu]},$$scope:{ctx:G}}}),Bn=new Ia({}),Wn=new N({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/flax_utils.py#L129"}}),Vn=new N({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": ndarray"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"prng_key",val:": typing.Optional[jax._src.numpy.ndarray.ndarray] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Union[typing.Dict[str, jax._src.numpy.ndarray.ndarray], NoneType] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.flax_logits_process.FlaxLogitsProcessorList] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"logits_processor"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/generation/flax_utils.py#L267",returnDescription:`
<p><a
  href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),{c(){c=o("meta"),_=m(),p=o("h1"),d=o("a"),f=o("span"),k(i.$$.fragment),h=m(),E=o("span"),y=n("Generation"),b=m(),M=o("p"),O=n("Each framework has a generate method for text generation implemented in their respective "),F=o("code"),ie=n("GenerationMixin"),B=n(" class:"),J=m(),I=o("ul"),C=o("li"),q=n("PyTorch "),X=o("a"),ze=n("generate()"),Ne=n(" is implemented in "),R=o("a"),Ie=n("GenerationMixin"),$r=n("."),Lr=m(),Be=o("li"),Tr=n("TensorFlow "),Xn=o("a"),Er=n("generate()"),Gr=n(" is implemented in "),Qn=o("a"),Mr=n("TFGenerationMixin"),Or=n("."),Cr=m(),We=o("li"),Sr=n("Flax/JAX "),es=o("a"),qr=n("generate()"),Pr=n(" is implemented in "),ts=o("a"),Fr=n("FlaxGenerationMixin"),Dr=n("."),Ba=m(),nt=o("p"),Ar=n("Regardless of your framework of choice, you can parameterize the generate method with a "),ns=o("a"),zr=n("GenerationConfig"),Nr=n(`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Wa=m(),st=o("p"),Ir=n(`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),ss=o("a"),Br=n("text generation strategies guide"),Wr=n(`. The guide also explains how to use related features,
like token streaming.`),Ua=m(),Ue=o("h2"),ot=o("a"),Bs=o("span"),k(an.$$.fragment),Ur=m(),Ws=o("span"),Rr=n("GenerationConfig"),Ra=m(),D=o("div"),k(rn.$$.fragment),Hr=m(),ln=o("p"),Vr=n("Class that holds a configuration for a generation task. A "),Us=o("code"),Yr=n("generate"),Kr=n(` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Zr=m(),A=o("ul"),le=o("li"),Rs=o("em"),Jr=n("greedy decoding"),Xr=n(" by calling "),os=o("a"),Qr=n("greedy_search()"),ei=n(" if "),Hs=o("code"),ti=n("num_beams=1"),ni=n(` and
`),Vs=o("code"),si=n("do_sample=False"),oi=m(),ce=o("li"),Ys=o("em"),ai=n("contrastive search"),ri=n(" by calling "),as=o("a"),ii=n("contrastive_search()"),li=n(" if "),Ks=o("code"),ci=n("penalty_alpha>0."),di=n(`
and `),Zs=o("code"),pi=n("top_k>1"),mi=m(),de=o("li"),Js=o("em"),gi=n("multinomial sampling"),hi=n(" by calling "),rs=o("a"),ui=n("sample()"),fi=n(" if "),Xs=o("code"),_i=n("num_beams=1"),bi=n(` and
`),Qs=o("code"),vi=n("do_sample=True"),xi=m(),pe=o("li"),eo=o("em"),yi=n("beam-search decoding"),ki=n(" by calling "),is=o("a"),ji=n("beam_search()"),wi=n(" if "),to=o("code"),$i=n("num_beams>1"),Li=n(` and
`),no=o("code"),Ti=n("do_sample=False"),Ei=m(),me=o("li"),so=o("em"),Gi=n("beam-search multinomial sampling"),Mi=n(" by calling "),ls=o("a"),Oi=n("beam_sample()"),Ci=n(` if
`),oo=o("code"),Si=n("num_beams>1"),qi=n(" and "),ao=o("code"),Pi=n("do_sample=True"),Fi=m(),ge=o("li"),ro=o("em"),Di=n("diverse beam-search decoding"),Ai=n(" by calling "),cs=o("a"),zi=n("group_beam_search()"),Ni=n(`, if
`),io=o("code"),Ii=n("num_beams>1"),Bi=n(" and "),lo=o("code"),Wi=n("num_beam_groups>1"),Ui=m(),he=o("li"),co=o("em"),Ri=n("constrained beam-search decoding"),Hi=n(" by calling "),ds=o("a"),Vi=n("constrained_beam_search()"),Yi=n(`, if
`),po=o("code"),Ki=n("constraints!=None"),Zi=n(" or "),mo=o("code"),Ji=n("force_words_ids!=None"),Xi=m(),ue=o("li"),go=o("em"),Qi=n("assisted decoding"),el=n(" by calling "),ho=o("code"),tl=n("assisted_decoding()"),nl=n(`, if
`),uo=o("code"),sl=n("assistant_model"),ol=n(" is passed to "),fo=o("code"),al=n(".generate()"),rl=m(),cn=o("p"),il=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018.generate()\u2018. To learn
more about decoding strategies refer to the `),ps=o("a"),ll=n("text generation strategies guide"),cl=n("."),dl=m(),Me=o("div"),k(dn.$$.fragment),pl=m(),pn=o("p"),ml=n("Instantiate a "),ms=o("a"),gl=n("GenerationConfig"),hl=n(" from a generation configuration file."),ul=m(),k(at.$$.fragment),fl=m(),rt=o("div"),k(mn.$$.fragment),_l=m(),Z=o("p"),bl=n("Instantiates a "),gs=o("a"),vl=n("GenerationConfig"),xl=n(" from a "),hs=o("a"),yl=n("PretrainedConfig"),kl=n(`. This function is useful to convert legacy
`),us=o("a"),jl=n("PretrainedConfig"),wl=n(" objects, which may contain generation parameters, into a stand-alone "),fs=o("a"),$l=n("GenerationConfig"),Ll=n("."),Tl=m(),it=o("div"),k(gn.$$.fragment),El=m(),Re=o("p"),Gl=n("Save a generation configuration object to the directory "),_o=o("code"),Ml=n("save_directory"),Ol=n(`, so that it can be re-loaded using the
`),_s=o("a"),Cl=n("from_pretrained()"),Sl=n(" class method."),Ha=m(),He=o("h2"),lt=o("a"),bo=o("span"),k(hn.$$.fragment),ql=m(),vo=o("span"),Pl=n("GenerationMixin"),Va=m(),S=o("div"),k(un.$$.fragment),Fl=m(),fn=o("p"),Dl=n("A class containing all functions for auto-regressive text generation, to be used as a mixin in "),bs=o("a"),Al=n("PreTrainedModel"),zl=n("."),Nl=m(),_n=o("p"),Il=n("The class exposes "),vs=o("a"),Bl=n("generate()"),Wl=n(", which can be used for:"),Ul=m(),W=o("ul"),fe=o("li"),xo=o("em"),Rl=n("greedy decoding"),Hl=n(" by calling "),xs=o("a"),Vl=n("greedy_search()"),Yl=n(" if "),yo=o("code"),Kl=n("num_beams=1"),Zl=n(` and
`),ko=o("code"),Jl=n("do_sample=False"),Xl=m(),_e=o("li"),jo=o("em"),Ql=n("contrastive search"),ec=n(" by calling "),ys=o("a"),tc=n("contrastive_search()"),nc=n(" if "),wo=o("code"),sc=n("penalty_alpha>0"),oc=n(` and
`),$o=o("code"),ac=n("top_k>1"),rc=m(),be=o("li"),Lo=o("em"),ic=n("multinomial sampling"),lc=n(" by calling "),ks=o("a"),cc=n("sample()"),dc=n(" if "),To=o("code"),pc=n("num_beams=1"),mc=n(` and
`),Eo=o("code"),gc=n("do_sample=True"),hc=m(),ve=o("li"),Go=o("em"),uc=n("beam-search decoding"),fc=n(" by calling "),js=o("a"),_c=n("beam_search()"),bc=n(" if "),Mo=o("code"),vc=n("num_beams>1"),xc=n(` and
`),Oo=o("code"),yc=n("do_sample=False"),kc=m(),xe=o("li"),Co=o("em"),jc=n("beam-search multinomial sampling"),wc=n(" by calling "),ws=o("a"),$c=n("beam_sample()"),Lc=n(" if "),So=o("code"),Tc=n("num_beams>1"),Ec=n(`
and `),qo=o("code"),Gc=n("do_sample=True"),Mc=m(),ye=o("li"),Po=o("em"),Oc=n("diverse beam-search decoding"),Cc=n(" by calling "),$s=o("a"),Sc=n("group_beam_search()"),qc=n(", if "),Fo=o("code"),Pc=n("num_beams>1"),Fc=n(`
and `),Do=o("code"),Dc=n("num_beam_groups>1"),Ac=m(),ke=o("li"),Ao=o("em"),zc=n("constrained beam-search decoding"),Nc=n(" by calling "),Ls=o("a"),Ic=n("constrained_beam_search()"),Bc=n(`, if
`),zo=o("code"),Wc=n("constraints!=None"),Uc=n(" or "),No=o("code"),Rc=n("force_words_ids!=None"),Hc=m(),bn=o("p"),Vc=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Ts=o("a"),Yc=n("text generation strategies guide"),Kc=n("."),Zc=m(),Oe=o("div"),k(vn.$$.fragment),Jc=m(),Io=o("p"),Xc=n("Generates sequences of token ids for models with a language modeling head."),Qc=m(),k(ct.$$.fragment),ed=m(),Ce=o("div"),k(xn.$$.fragment),td=m(),Bo=o("p"),nd=n(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),sd=m(),k(dt.$$.fragment),od=m(),Q=o("div"),k(yn.$$.fragment),ad=m(),kn=o("p"),rd=n("Generates sequences of token ids for models with a language modeling head using "),Wo=o("strong"),id=n("greedy decoding"),ld=n(` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),cd=m(),k(pt.$$.fragment),dd=m(),k(mt.$$.fragment),pd=m(),ee=o("div"),k(jn.$$.fragment),md=m(),wn=o("p"),gd=n("Generates sequences of token ids for models with a language modeling head using "),Uo=o("strong"),hd=n("multinomial sampling"),ud=n(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),fd=m(),k(gt.$$.fragment),_d=m(),k(ht.$$.fragment),bd=m(),te=o("div"),k($n.$$.fragment),vd=m(),Ln=o("p"),xd=n("Generates sequences of token ids for models with a language modeling head using "),Ro=o("strong"),yd=n("beam search decoding"),kd=n(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),jd=m(),k(ut.$$.fragment),wd=m(),k(ft.$$.fragment),$d=m(),ne=o("div"),k(Tn.$$.fragment),Ld=m(),En=o("p"),Td=n("Generates sequences of token ids for models with a language modeling head using "),Ho=o("strong"),Ed=n(`beam search multinomial
sampling`),Gd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Md=m(),k(_t.$$.fragment),Od=m(),k(bt.$$.fragment),Cd=m(),se=o("div"),k(Gn.$$.fragment),Sd=m(),Mn=o("p"),qd=n("Generates sequences of token ids for models with a language modeling head using "),Vo=o("strong"),Pd=n("contrastive search"),Fd=n(` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Dd=m(),k(vt.$$.fragment),Ad=m(),k(xt.$$.fragment),zd=m(),oe=o("div"),k(On.$$.fragment),Nd=m(),Cn=o("p"),Id=n("Generates sequences of token ids for models with a language modeling head using "),Yo=o("strong"),Bd=n(`diverse beam search
decoding`),Wd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Ud=m(),k(yt.$$.fragment),Rd=m(),k(kt.$$.fragment),Hd=m(),ae=o("div"),k(Sn.$$.fragment),Vd=m(),qn=o("p"),Yd=n("Generates sequences of token ids for models with a language modeling head using "),Ko=o("strong"),Kd=n(`constrained beam search
decoding`),Zd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Jd=m(),k(jt.$$.fragment),Xd=m(),k(wt.$$.fragment),Ya=m(),Ve=o("h2"),$t=o("a"),Zo=o("span"),k(Pn.$$.fragment),Qd=m(),Jo=o("span"),ep=n("TFGenerationMixin"),Ka=m(),z=o("div"),k(Fn.$$.fragment),tp=m(),Dn=o("p"),np=n("A class containing all of the functions supporting generation, to be used as a mixin in "),Es=o("a"),sp=n("TFPreTrainedModel"),op=n("."),ap=m(),An=o("p"),rp=n("The class exposes "),Gs=o("a"),ip=n("generate()"),lp=n(", which can be used for:"),cp=m(),je=o("ul"),we=o("li"),Xo=o("em"),dp=n("greedy decoding"),pp=n(" by calling "),Qo=o("code"),mp=n("greedy_search()"),gp=n(" if "),ea=o("code"),hp=n("num_beams=1"),up=n(` and
`),ta=o("code"),fp=n("do_sample=False"),_p=m(),$e=o("li"),na=o("em"),bp=n("contrastive search"),vp=n(" by calling "),sa=o("code"),xp=n("contrastive_search()"),yp=n(" if "),oa=o("code"),kp=n("penalty_alpha>0"),jp=n(` and
`),aa=o("code"),wp=n("top_k>1"),$p=m(),Le=o("li"),ra=o("em"),Lp=n("multinomial sampling"),Tp=n(" by calling "),ia=o("code"),Ep=n("sample()"),Gp=n(" if "),la=o("code"),Mp=n("num_beams=1"),Op=n(` and
`),ca=o("code"),Cp=n("do_sample=True"),Sp=m(),Ye=o("li"),da=o("em"),qp=n("beam-search decoding"),Pp=n(" by calling "),pa=o("code"),Fp=n("beam_search()"),Dp=n(" if "),ma=o("code"),Ap=n("num_beams>1"),zp=m(),zn=o("p"),Np=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Ms=o("a"),Ip=n("text generation strategies guide"),Bp=n("."),Wp=m(),Se=o("div"),k(Nn.$$.fragment),Up=m(),ga=o("p"),Rp=n("Generates sequences of token ids for models with a language modeling head."),Hp=m(),k(Lt.$$.fragment),Vp=m(),qe=o("div"),k(In.$$.fragment),Yp=m(),ha=o("p"),Kp=n(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Zp=m(),k(Tt.$$.fragment),Za=m(),Ke=o("h2"),Et=o("a"),ua=o("span"),k(Bn.$$.fragment),Jp=m(),fa=o("span"),Xp=n("FlaxGenerationMixin"),Ja=m(),U=o("div"),k(Wn.$$.fragment),Qp=m(),Un=o("p"),em=n(`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Os=o("a"),tm=n("FlaxPreTrainedModel"),nm=n("."),sm=m(),Rn=o("p"),om=n("The class exposes "),Cs=o("a"),am=n("generate()"),rm=n(", which can be used for:"),im=m(),Ze=o("ul"),Te=o("li"),_a=o("em"),lm=n("greedy decoding"),cm=n(" by calling "),ba=o("code"),dm=n("_greedy_search()"),pm=n(" if "),va=o("code"),mm=n("num_beams=1"),gm=n(` and
`),xa=o("code"),hm=n("do_sample=False"),um=m(),Ee=o("li"),ya=o("em"),fm=n("multinomial sampling"),_m=n(" by calling "),ka=o("code"),bm=n("_sample()"),vm=n(" if "),ja=o("code"),xm=n("num_beams=1"),ym=n(` and
`),wa=o("code"),km=n("do_sample=True"),jm=m(),Ge=o("li"),$a=o("em"),wm=n("beam-search decoding"),$m=n(" by calling "),La=o("code"),Lm=n("_beam_search()"),Tm=n(" if "),Ta=o("code"),Em=n("num_beams>1"),Gm=n(` and
`),Ea=o("code"),Mm=n("do_sample=False"),Om=m(),Hn=o("p"),Cm=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Ss=o("a"),Sm=n("text generation strategies guide"),qm=n("."),Pm=m(),Gt=o("div"),k(Vn.$$.fragment),Fm=m(),Ga=o("p"),Dm=n("Generates sequences of token ids for models with a language modeling head."),this.h()},l(l){const v=cu('[data-svelte="svelte-1phssyn"]',document.head);c=a(v,"META",{name:!0,content:!0}),v.forEach(t),_=g(l),p=a(l,"H1",{class:!0});var Yn=r(p);d=a(Yn,"A",{id:!0,class:!0,href:!0});var Ma=r(d);f=a(Ma,"SPAN",{});var Oa=r(f);j(i.$$.fragment,Oa),Oa.forEach(t),Ma.forEach(t),h=g(Yn),E=a(Yn,"SPAN",{});var Ca=r(E);y=s(Ca,"Generation"),Ca.forEach(t),Yn.forEach(t),b=g(l),M=a(l,"P",{});var Kn=r(M);O=s(Kn,"Each framework has a generate method for text generation implemented in their respective "),F=a(Kn,"CODE",{});var Sa=r(F);ie=s(Sa,"GenerationMixin"),Sa.forEach(t),B=s(Kn," class:"),Kn.forEach(t),J=g(l),I=a(l,"UL",{});var Je=r(I);C=a(Je,"LI",{});var Xe=r(C);q=s(Xe,"PyTorch "),X=a(Xe,"A",{href:!0});var qa=r(X);ze=s(qa,"generate()"),qa.forEach(t),Ne=s(Xe," is implemented in "),R=a(Xe,"A",{href:!0});var Pa=r(R);Ie=s(Pa,"GenerationMixin"),Pa.forEach(t),$r=s(Xe,"."),Xe.forEach(t),Lr=g(Je),Be=a(Je,"LI",{});var Qe=r(Be);Tr=s(Qe,"TensorFlow "),Xn=a(Qe,"A",{href:!0});var Fa=r(Xn);Er=s(Fa,"generate()"),Fa.forEach(t),Gr=s(Qe," is implemented in "),Qn=a(Qe,"A",{href:!0});var Da=r(Qn);Mr=s(Da,"TFGenerationMixin"),Da.forEach(t),Or=s(Qe,"."),Qe.forEach(t),Cr=g(Je),We=a(Je,"LI",{});var et=r(We);Sr=s(et,"Flax/JAX "),es=a(et,"A",{href:!0});var Aa=r(es);qr=s(Aa,"generate()"),Aa.forEach(t),Pr=s(et," is implemented in "),ts=a(et,"A",{href:!0});var za=r(ts);Fr=s(za,"FlaxGenerationMixin"),za.forEach(t),Dr=s(et,"."),et.forEach(t),Je.forEach(t),Ba=g(l),nt=a(l,"P",{});var Zn=r(nt);Ar=s(Zn,"Regardless of your framework of choice, you can parameterize the generate method with a "),ns=a(Zn,"A",{href:!0});var Na=r(ns);zr=s(Na,"GenerationConfig"),Na.forEach(t),Nr=s(Zn,`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Zn.forEach(t),Wa=g(l),st=a(l,"P",{});var Jn=r(st);Ir=s(Jn,`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),ss=a(Jn,"A",{href:!0});var Am=r(ss);Br=s(Am,"text generation strategies guide"),Am.forEach(t),Wr=s(Jn,`. The guide also explains how to use related features,
like token streaming.`),Jn.forEach(t),Ua=g(l),Ue=a(l,"H2",{class:!0});var Qa=r(Ue);ot=a(Qa,"A",{id:!0,class:!0,href:!0});var zm=r(ot);Bs=a(zm,"SPAN",{});var Nm=r(Bs);j(an.$$.fragment,Nm),Nm.forEach(t),zm.forEach(t),Ur=g(Qa),Ws=a(Qa,"SPAN",{});var Im=r(Ws);Rr=s(Im,"GenerationConfig"),Im.forEach(t),Qa.forEach(t),Ra=g(l),D=a(l,"DIV",{class:!0});var V=r(D);j(rn.$$.fragment,V),Hr=g(V),ln=a(V,"P",{});var er=r(ln);Vr=s(er,"Class that holds a configuration for a generation task. A "),Us=a(er,"CODE",{});var Bm=r(Us);Yr=s(Bm,"generate"),Bm.forEach(t),Kr=s(er,` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),er.forEach(t),Zr=g(V),A=a(V,"UL",{});var H=r(A);le=a(H,"LI",{});var Mt=r(le);Rs=a(Mt,"EM",{});var Wm=r(Rs);Jr=s(Wm,"greedy decoding"),Wm.forEach(t),Xr=s(Mt," by calling "),os=a(Mt,"A",{href:!0});var Um=r(os);Qr=s(Um,"greedy_search()"),Um.forEach(t),ei=s(Mt," if "),Hs=a(Mt,"CODE",{});var Rm=r(Hs);ti=s(Rm,"num_beams=1"),Rm.forEach(t),ni=s(Mt,` and
`),Vs=a(Mt,"CODE",{});var Hm=r(Vs);si=s(Hm,"do_sample=False"),Hm.forEach(t),Mt.forEach(t),oi=g(H),ce=a(H,"LI",{});var Ot=r(ce);Ys=a(Ot,"EM",{});var Vm=r(Ys);ai=s(Vm,"contrastive search"),Vm.forEach(t),ri=s(Ot," by calling "),as=a(Ot,"A",{href:!0});var Ym=r(as);ii=s(Ym,"contrastive_search()"),Ym.forEach(t),li=s(Ot," if "),Ks=a(Ot,"CODE",{});var Km=r(Ks);ci=s(Km,"penalty_alpha>0."),Km.forEach(t),di=s(Ot,`
and `),Zs=a(Ot,"CODE",{});var Zm=r(Zs);pi=s(Zm,"top_k>1"),Zm.forEach(t),Ot.forEach(t),mi=g(H),de=a(H,"LI",{});var Ct=r(de);Js=a(Ct,"EM",{});var Jm=r(Js);gi=s(Jm,"multinomial sampling"),Jm.forEach(t),hi=s(Ct," by calling "),rs=a(Ct,"A",{href:!0});var Xm=r(rs);ui=s(Xm,"sample()"),Xm.forEach(t),fi=s(Ct," if "),Xs=a(Ct,"CODE",{});var Qm=r(Xs);_i=s(Qm,"num_beams=1"),Qm.forEach(t),bi=s(Ct,` and
`),Qs=a(Ct,"CODE",{});var eg=r(Qs);vi=s(eg,"do_sample=True"),eg.forEach(t),Ct.forEach(t),xi=g(H),pe=a(H,"LI",{});var St=r(pe);eo=a(St,"EM",{});var tg=r(eo);yi=s(tg,"beam-search decoding"),tg.forEach(t),ki=s(St," by calling "),is=a(St,"A",{href:!0});var ng=r(is);ji=s(ng,"beam_search()"),ng.forEach(t),wi=s(St," if "),to=a(St,"CODE",{});var sg=r(to);$i=s(sg,"num_beams>1"),sg.forEach(t),Li=s(St,` and
`),no=a(St,"CODE",{});var og=r(no);Ti=s(og,"do_sample=False"),og.forEach(t),St.forEach(t),Ei=g(H),me=a(H,"LI",{});var qt=r(me);so=a(qt,"EM",{});var ag=r(so);Gi=s(ag,"beam-search multinomial sampling"),ag.forEach(t),Mi=s(qt," by calling "),ls=a(qt,"A",{href:!0});var rg=r(ls);Oi=s(rg,"beam_sample()"),rg.forEach(t),Ci=s(qt,` if
`),oo=a(qt,"CODE",{});var ig=r(oo);Si=s(ig,"num_beams>1"),ig.forEach(t),qi=s(qt," and "),ao=a(qt,"CODE",{});var lg=r(ao);Pi=s(lg,"do_sample=True"),lg.forEach(t),qt.forEach(t),Fi=g(H),ge=a(H,"LI",{});var Pt=r(ge);ro=a(Pt,"EM",{});var cg=r(ro);Di=s(cg,"diverse beam-search decoding"),cg.forEach(t),Ai=s(Pt," by calling "),cs=a(Pt,"A",{href:!0});var dg=r(cs);zi=s(dg,"group_beam_search()"),dg.forEach(t),Ni=s(Pt,`, if
`),io=a(Pt,"CODE",{});var pg=r(io);Ii=s(pg,"num_beams>1"),pg.forEach(t),Bi=s(Pt," and "),lo=a(Pt,"CODE",{});var mg=r(lo);Wi=s(mg,"num_beam_groups>1"),mg.forEach(t),Pt.forEach(t),Ui=g(H),he=a(H,"LI",{});var Ft=r(he);co=a(Ft,"EM",{});var gg=r(co);Ri=s(gg,"constrained beam-search decoding"),gg.forEach(t),Hi=s(Ft," by calling "),ds=a(Ft,"A",{href:!0});var hg=r(ds);Vi=s(hg,"constrained_beam_search()"),hg.forEach(t),Yi=s(Ft,`, if
`),po=a(Ft,"CODE",{});var ug=r(po);Ki=s(ug,"constraints!=None"),ug.forEach(t),Zi=s(Ft," or "),mo=a(Ft,"CODE",{});var fg=r(mo);Ji=s(fg,"force_words_ids!=None"),fg.forEach(t),Ft.forEach(t),Xi=g(H),ue=a(H,"LI",{});var Dt=r(ue);go=a(Dt,"EM",{});var _g=r(go);Qi=s(_g,"assisted decoding"),_g.forEach(t),el=s(Dt," by calling "),ho=a(Dt,"CODE",{});var bg=r(ho);tl=s(bg,"assisted_decoding()"),bg.forEach(t),nl=s(Dt,`, if
`),uo=a(Dt,"CODE",{});var vg=r(uo);sl=s(vg,"assistant_model"),vg.forEach(t),ol=s(Dt," is passed to "),fo=a(Dt,"CODE",{});var xg=r(fo);al=s(xg,".generate()"),xg.forEach(t),Dt.forEach(t),H.forEach(t),rl=g(V),cn=a(V,"P",{});var tr=r(cn);il=s(tr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018.generate()\u2018. To learn
more about decoding strategies refer to the `),ps=a(tr,"A",{href:!0});var yg=r(ps);ll=s(yg,"text generation strategies guide"),yg.forEach(t),cl=s(tr,"."),tr.forEach(t),dl=g(V),Me=a(V,"DIV",{class:!0});var qs=r(Me);j(dn.$$.fragment,qs),pl=g(qs),pn=a(qs,"P",{});var nr=r(pn);ml=s(nr,"Instantiate a "),ms=a(nr,"A",{href:!0});var kg=r(ms);gl=s(kg,"GenerationConfig"),kg.forEach(t),hl=s(nr," from a generation configuration file."),nr.forEach(t),ul=g(qs),j(at.$$.fragment,qs),qs.forEach(t),fl=g(V),rt=a(V,"DIV",{class:!0});var sr=r(rt);j(mn.$$.fragment,sr),_l=g(sr),Z=a(sr,"P",{});var Pe=r(Z);bl=s(Pe,"Instantiates a "),gs=a(Pe,"A",{href:!0});var jg=r(gs);vl=s(jg,"GenerationConfig"),jg.forEach(t),xl=s(Pe," from a "),hs=a(Pe,"A",{href:!0});var wg=r(hs);yl=s(wg,"PretrainedConfig"),wg.forEach(t),kl=s(Pe,`. This function is useful to convert legacy
`),us=a(Pe,"A",{href:!0});var $g=r(us);jl=s($g,"PretrainedConfig"),$g.forEach(t),wl=s(Pe," objects, which may contain generation parameters, into a stand-alone "),fs=a(Pe,"A",{href:!0});var Lg=r(fs);$l=s(Lg,"GenerationConfig"),Lg.forEach(t),Ll=s(Pe,"."),Pe.forEach(t),sr.forEach(t),Tl=g(V),it=a(V,"DIV",{class:!0});var or=r(it);j(gn.$$.fragment,or),El=g(or),Re=a(or,"P",{});var Ps=r(Re);Gl=s(Ps,"Save a generation configuration object to the directory "),_o=a(Ps,"CODE",{});var Tg=r(_o);Ml=s(Tg,"save_directory"),Tg.forEach(t),Ol=s(Ps,`, so that it can be re-loaded using the
`),_s=a(Ps,"A",{href:!0});var Eg=r(_s);Cl=s(Eg,"from_pretrained()"),Eg.forEach(t),Sl=s(Ps," class method."),Ps.forEach(t),or.forEach(t),V.forEach(t),Ha=g(l),He=a(l,"H2",{class:!0});var ar=r(He);lt=a(ar,"A",{id:!0,class:!0,href:!0});var Gg=r(lt);bo=a(Gg,"SPAN",{});var Mg=r(bo);j(hn.$$.fragment,Mg),Mg.forEach(t),Gg.forEach(t),ql=g(ar),vo=a(ar,"SPAN",{});var Og=r(vo);Pl=s(Og,"GenerationMixin"),Og.forEach(t),ar.forEach(t),Va=g(l),S=a(l,"DIV",{class:!0});var P=r(S);j(un.$$.fragment,P),Fl=g(P),fn=a(P,"P",{});var rr=r(fn);Dl=s(rr,"A class containing all functions for auto-regressive text generation, to be used as a mixin in "),bs=a(rr,"A",{href:!0});var Cg=r(bs);Al=s(Cg,"PreTrainedModel"),Cg.forEach(t),zl=s(rr,"."),rr.forEach(t),Nl=g(P),_n=a(P,"P",{});var ir=r(_n);Il=s(ir,"The class exposes "),vs=a(ir,"A",{href:!0});var Sg=r(vs);Bl=s(Sg,"generate()"),Sg.forEach(t),Wl=s(ir,", which can be used for:"),ir.forEach(t),Ul=g(P),W=a(P,"UL",{});var Y=r(W);fe=a(Y,"LI",{});var At=r(fe);xo=a(At,"EM",{});var qg=r(xo);Rl=s(qg,"greedy decoding"),qg.forEach(t),Hl=s(At," by calling "),xs=a(At,"A",{href:!0});var Pg=r(xs);Vl=s(Pg,"greedy_search()"),Pg.forEach(t),Yl=s(At," if "),yo=a(At,"CODE",{});var Fg=r(yo);Kl=s(Fg,"num_beams=1"),Fg.forEach(t),Zl=s(At,` and
`),ko=a(At,"CODE",{});var Dg=r(ko);Jl=s(Dg,"do_sample=False"),Dg.forEach(t),At.forEach(t),Xl=g(Y),_e=a(Y,"LI",{});var zt=r(_e);jo=a(zt,"EM",{});var Ag=r(jo);Ql=s(Ag,"contrastive search"),Ag.forEach(t),ec=s(zt," by calling "),ys=a(zt,"A",{href:!0});var zg=r(ys);tc=s(zg,"contrastive_search()"),zg.forEach(t),nc=s(zt," if "),wo=a(zt,"CODE",{});var Ng=r(wo);sc=s(Ng,"penalty_alpha>0"),Ng.forEach(t),oc=s(zt,` and
`),$o=a(zt,"CODE",{});var Ig=r($o);ac=s(Ig,"top_k>1"),Ig.forEach(t),zt.forEach(t),rc=g(Y),be=a(Y,"LI",{});var Nt=r(be);Lo=a(Nt,"EM",{});var Bg=r(Lo);ic=s(Bg,"multinomial sampling"),Bg.forEach(t),lc=s(Nt," by calling "),ks=a(Nt,"A",{href:!0});var Wg=r(ks);cc=s(Wg,"sample()"),Wg.forEach(t),dc=s(Nt," if "),To=a(Nt,"CODE",{});var Ug=r(To);pc=s(Ug,"num_beams=1"),Ug.forEach(t),mc=s(Nt,` and
`),Eo=a(Nt,"CODE",{});var Rg=r(Eo);gc=s(Rg,"do_sample=True"),Rg.forEach(t),Nt.forEach(t),hc=g(Y),ve=a(Y,"LI",{});var It=r(ve);Go=a(It,"EM",{});var Hg=r(Go);uc=s(Hg,"beam-search decoding"),Hg.forEach(t),fc=s(It," by calling "),js=a(It,"A",{href:!0});var Vg=r(js);_c=s(Vg,"beam_search()"),Vg.forEach(t),bc=s(It," if "),Mo=a(It,"CODE",{});var Yg=r(Mo);vc=s(Yg,"num_beams>1"),Yg.forEach(t),xc=s(It,` and
`),Oo=a(It,"CODE",{});var Kg=r(Oo);yc=s(Kg,"do_sample=False"),Kg.forEach(t),It.forEach(t),kc=g(Y),xe=a(Y,"LI",{});var Bt=r(xe);Co=a(Bt,"EM",{});var Zg=r(Co);jc=s(Zg,"beam-search multinomial sampling"),Zg.forEach(t),wc=s(Bt," by calling "),ws=a(Bt,"A",{href:!0});var Jg=r(ws);$c=s(Jg,"beam_sample()"),Jg.forEach(t),Lc=s(Bt," if "),So=a(Bt,"CODE",{});var Xg=r(So);Tc=s(Xg,"num_beams>1"),Xg.forEach(t),Ec=s(Bt,`
and `),qo=a(Bt,"CODE",{});var Qg=r(qo);Gc=s(Qg,"do_sample=True"),Qg.forEach(t),Bt.forEach(t),Mc=g(Y),ye=a(Y,"LI",{});var Wt=r(ye);Po=a(Wt,"EM",{});var eh=r(Po);Oc=s(eh,"diverse beam-search decoding"),eh.forEach(t),Cc=s(Wt," by calling "),$s=a(Wt,"A",{href:!0});var th=r($s);Sc=s(th,"group_beam_search()"),th.forEach(t),qc=s(Wt,", if "),Fo=a(Wt,"CODE",{});var nh=r(Fo);Pc=s(nh,"num_beams>1"),nh.forEach(t),Fc=s(Wt,`
and `),Do=a(Wt,"CODE",{});var sh=r(Do);Dc=s(sh,"num_beam_groups>1"),sh.forEach(t),Wt.forEach(t),Ac=g(Y),ke=a(Y,"LI",{});var Ut=r(ke);Ao=a(Ut,"EM",{});var oh=r(Ao);zc=s(oh,"constrained beam-search decoding"),oh.forEach(t),Nc=s(Ut," by calling "),Ls=a(Ut,"A",{href:!0});var ah=r(Ls);Ic=s(ah,"constrained_beam_search()"),ah.forEach(t),Bc=s(Ut,`, if
`),zo=a(Ut,"CODE",{});var rh=r(zo);Wc=s(rh,"constraints!=None"),rh.forEach(t),Uc=s(Ut," or "),No=a(Ut,"CODE",{});var ih=r(No);Rc=s(ih,"force_words_ids!=None"),ih.forEach(t),Ut.forEach(t),Y.forEach(t),Hc=g(P),bn=a(P,"P",{});var lr=r(bn);Vc=s(lr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Ts=a(lr,"A",{href:!0});var lh=r(Ts);Yc=s(lh,"text generation strategies guide"),lh.forEach(t),Kc=s(lr,"."),lr.forEach(t),Zc=g(P),Oe=a(P,"DIV",{class:!0});var Fs=r(Oe);j(vn.$$.fragment,Fs),Jc=g(Fs),Io=a(Fs,"P",{});var ch=r(Io);Xc=s(ch,"Generates sequences of token ids for models with a language modeling head."),ch.forEach(t),Qc=g(Fs),j(ct.$$.fragment,Fs),Fs.forEach(t),ed=g(P),Ce=a(P,"DIV",{class:!0});var Ds=r(Ce);j(xn.$$.fragment,Ds),td=g(Ds),Bo=a(Ds,"P",{});var dh=r(Bo);nd=s(dh,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),dh.forEach(t),sd=g(Ds),j(dt.$$.fragment,Ds),Ds.forEach(t),od=g(P),Q=a(P,"DIV",{class:!0});var Rt=r(Q);j(yn.$$.fragment,Rt),ad=g(Rt),kn=a(Rt,"P",{});var cr=r(kn);rd=s(cr,"Generates sequences of token ids for models with a language modeling head using "),Wo=a(cr,"STRONG",{});var ph=r(Wo);id=s(ph,"greedy decoding"),ph.forEach(t),ld=s(cr,` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),cr.forEach(t),cd=g(Rt),j(pt.$$.fragment,Rt),dd=g(Rt),j(mt.$$.fragment,Rt),Rt.forEach(t),pd=g(P),ee=a(P,"DIV",{class:!0});var Ht=r(ee);j(jn.$$.fragment,Ht),md=g(Ht),wn=a(Ht,"P",{});var dr=r(wn);gd=s(dr,"Generates sequences of token ids for models with a language modeling head using "),Uo=a(dr,"STRONG",{});var mh=r(Uo);hd=s(mh,"multinomial sampling"),mh.forEach(t),ud=s(dr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),dr.forEach(t),fd=g(Ht),j(gt.$$.fragment,Ht),_d=g(Ht),j(ht.$$.fragment,Ht),Ht.forEach(t),bd=g(P),te=a(P,"DIV",{class:!0});var Vt=r(te);j($n.$$.fragment,Vt),vd=g(Vt),Ln=a(Vt,"P",{});var pr=r(Ln);xd=s(pr,"Generates sequences of token ids for models with a language modeling head using "),Ro=a(pr,"STRONG",{});var gh=r(Ro);yd=s(gh,"beam search decoding"),gh.forEach(t),kd=s(pr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),pr.forEach(t),jd=g(Vt),j(ut.$$.fragment,Vt),wd=g(Vt),j(ft.$$.fragment,Vt),Vt.forEach(t),$d=g(P),ne=a(P,"DIV",{class:!0});var Yt=r(ne);j(Tn.$$.fragment,Yt),Ld=g(Yt),En=a(Yt,"P",{});var mr=r(En);Td=s(mr,"Generates sequences of token ids for models with a language modeling head using "),Ho=a(mr,"STRONG",{});var hh=r(Ho);Ed=s(hh,`beam search multinomial
sampling`),hh.forEach(t),Gd=s(mr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),mr.forEach(t),Md=g(Yt),j(_t.$$.fragment,Yt),Od=g(Yt),j(bt.$$.fragment,Yt),Yt.forEach(t),Cd=g(P),se=a(P,"DIV",{class:!0});var Kt=r(se);j(Gn.$$.fragment,Kt),Sd=g(Kt),Mn=a(Kt,"P",{});var gr=r(Mn);qd=s(gr,"Generates sequences of token ids for models with a language modeling head using "),Vo=a(gr,"STRONG",{});var uh=r(Vo);Pd=s(uh,"contrastive search"),uh.forEach(t),Fd=s(gr,` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),gr.forEach(t),Dd=g(Kt),j(vt.$$.fragment,Kt),Ad=g(Kt),j(xt.$$.fragment,Kt),Kt.forEach(t),zd=g(P),oe=a(P,"DIV",{class:!0});var Zt=r(oe);j(On.$$.fragment,Zt),Nd=g(Zt),Cn=a(Zt,"P",{});var hr=r(Cn);Id=s(hr,"Generates sequences of token ids for models with a language modeling head using "),Yo=a(hr,"STRONG",{});var fh=r(Yo);Bd=s(fh,`diverse beam search
decoding`),fh.forEach(t),Wd=s(hr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),hr.forEach(t),Ud=g(Zt),j(yt.$$.fragment,Zt),Rd=g(Zt),j(kt.$$.fragment,Zt),Zt.forEach(t),Hd=g(P),ae=a(P,"DIV",{class:!0});var Jt=r(ae);j(Sn.$$.fragment,Jt),Vd=g(Jt),qn=a(Jt,"P",{});var ur=r(qn);Yd=s(ur,"Generates sequences of token ids for models with a language modeling head using "),Ko=a(ur,"STRONG",{});var _h=r(Ko);Kd=s(_h,`constrained beam search
decoding`),_h.forEach(t),Zd=s(ur," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),ur.forEach(t),Jd=g(Jt),j(jt.$$.fragment,Jt),Xd=g(Jt),j(wt.$$.fragment,Jt),Jt.forEach(t),P.forEach(t),Ya=g(l),Ve=a(l,"H2",{class:!0});var fr=r(Ve);$t=a(fr,"A",{id:!0,class:!0,href:!0});var bh=r($t);Zo=a(bh,"SPAN",{});var vh=r(Zo);j(Pn.$$.fragment,vh),vh.forEach(t),bh.forEach(t),Qd=g(fr),Jo=a(fr,"SPAN",{});var xh=r(Jo);ep=s(xh,"TFGenerationMixin"),xh.forEach(t),fr.forEach(t),Ka=g(l),z=a(l,"DIV",{class:!0});var K=r(z);j(Fn.$$.fragment,K),tp=g(K),Dn=a(K,"P",{});var _r=r(Dn);np=s(_r,"A class containing all of the functions supporting generation, to be used as a mixin in "),Es=a(_r,"A",{href:!0});var yh=r(Es);sp=s(yh,"TFPreTrainedModel"),yh.forEach(t),op=s(_r,"."),_r.forEach(t),ap=g(K),An=a(K,"P",{});var br=r(An);rp=s(br,"The class exposes "),Gs=a(br,"A",{href:!0});var kh=r(Gs);ip=s(kh,"generate()"),kh.forEach(t),lp=s(br,", which can be used for:"),br.forEach(t),cp=g(K),je=a(K,"UL",{});var Xt=r(je);we=a(Xt,"LI",{});var Qt=r(we);Xo=a(Qt,"EM",{});var jh=r(Xo);dp=s(jh,"greedy decoding"),jh.forEach(t),pp=s(Qt," by calling "),Qo=a(Qt,"CODE",{});var wh=r(Qo);mp=s(wh,"greedy_search()"),wh.forEach(t),gp=s(Qt," if "),ea=a(Qt,"CODE",{});var $h=r(ea);hp=s($h,"num_beams=1"),$h.forEach(t),up=s(Qt,` and
`),ta=a(Qt,"CODE",{});var Lh=r(ta);fp=s(Lh,"do_sample=False"),Lh.forEach(t),Qt.forEach(t),_p=g(Xt),$e=a(Xt,"LI",{});var en=r($e);na=a(en,"EM",{});var Th=r(na);bp=s(Th,"contrastive search"),Th.forEach(t),vp=s(en," by calling "),sa=a(en,"CODE",{});var Eh=r(sa);xp=s(Eh,"contrastive_search()"),Eh.forEach(t),yp=s(en," if "),oa=a(en,"CODE",{});var Gh=r(oa);kp=s(Gh,"penalty_alpha>0"),Gh.forEach(t),jp=s(en,` and
`),aa=a(en,"CODE",{});var Mh=r(aa);wp=s(Mh,"top_k>1"),Mh.forEach(t),en.forEach(t),$p=g(Xt),Le=a(Xt,"LI",{});var tn=r(Le);ra=a(tn,"EM",{});var Oh=r(ra);Lp=s(Oh,"multinomial sampling"),Oh.forEach(t),Tp=s(tn," by calling "),ia=a(tn,"CODE",{});var Ch=r(ia);Ep=s(Ch,"sample()"),Ch.forEach(t),Gp=s(tn," if "),la=a(tn,"CODE",{});var Sh=r(la);Mp=s(Sh,"num_beams=1"),Sh.forEach(t),Op=s(tn,` and
`),ca=a(tn,"CODE",{});var qh=r(ca);Cp=s(qh,"do_sample=True"),qh.forEach(t),tn.forEach(t),Sp=g(Xt),Ye=a(Xt,"LI",{});var As=r(Ye);da=a(As,"EM",{});var Ph=r(da);qp=s(Ph,"beam-search decoding"),Ph.forEach(t),Pp=s(As," by calling "),pa=a(As,"CODE",{});var Fh=r(pa);Fp=s(Fh,"beam_search()"),Fh.forEach(t),Dp=s(As," if "),ma=a(As,"CODE",{});var Dh=r(ma);Ap=s(Dh,"num_beams>1"),Dh.forEach(t),As.forEach(t),Xt.forEach(t),zp=g(K),zn=a(K,"P",{});var vr=r(zn);Np=s(vr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Ms=a(vr,"A",{href:!0});var Ah=r(Ms);Ip=s(Ah,"text generation strategies guide"),Ah.forEach(t),Bp=s(vr,"."),vr.forEach(t),Wp=g(K),Se=a(K,"DIV",{class:!0});var zs=r(Se);j(Nn.$$.fragment,zs),Up=g(zs),ga=a(zs,"P",{});var zh=r(ga);Rp=s(zh,"Generates sequences of token ids for models with a language modeling head."),zh.forEach(t),Hp=g(zs),j(Lt.$$.fragment,zs),zs.forEach(t),Vp=g(K),qe=a(K,"DIV",{class:!0});var Ns=r(qe);j(In.$$.fragment,Ns),Yp=g(Ns),ha=a(Ns,"P",{});var Nh=r(ha);Kp=s(Nh,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Nh.forEach(t),Zp=g(Ns),j(Tt.$$.fragment,Ns),Ns.forEach(t),K.forEach(t),Za=g(l),Ke=a(l,"H2",{class:!0});var xr=r(Ke);Et=a(xr,"A",{id:!0,class:!0,href:!0});var Ih=r(Et);ua=a(Ih,"SPAN",{});var Bh=r(ua);j(Bn.$$.fragment,Bh),Bh.forEach(t),Ih.forEach(t),Jp=g(xr),fa=a(xr,"SPAN",{});var Wh=r(fa);Xp=s(Wh,"FlaxGenerationMixin"),Wh.forEach(t),xr.forEach(t),Ja=g(l),U=a(l,"DIV",{class:!0});var re=r(U);j(Wn.$$.fragment,re),Qp=g(re),Un=a(re,"P",{});var yr=r(Un);em=s(yr,`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Os=a(yr,"A",{href:!0});var Uh=r(Os);tm=s(Uh,"FlaxPreTrainedModel"),Uh.forEach(t),nm=s(yr,"."),yr.forEach(t),sm=g(re),Rn=a(re,"P",{});var kr=r(Rn);om=s(kr,"The class exposes "),Cs=a(kr,"A",{href:!0});var Rh=r(Cs);am=s(Rh,"generate()"),Rh.forEach(t),rm=s(kr,", which can be used for:"),kr.forEach(t),im=g(re),Ze=a(re,"UL",{});var Is=r(Ze);Te=a(Is,"LI",{});var nn=r(Te);_a=a(nn,"EM",{});var Hh=r(_a);lm=s(Hh,"greedy decoding"),Hh.forEach(t),cm=s(nn," by calling "),ba=a(nn,"CODE",{});var Vh=r(ba);dm=s(Vh,"_greedy_search()"),Vh.forEach(t),pm=s(nn," if "),va=a(nn,"CODE",{});var Yh=r(va);mm=s(Yh,"num_beams=1"),Yh.forEach(t),gm=s(nn,` and
`),xa=a(nn,"CODE",{});var Kh=r(xa);hm=s(Kh,"do_sample=False"),Kh.forEach(t),nn.forEach(t),um=g(Is),Ee=a(Is,"LI",{});var sn=r(Ee);ya=a(sn,"EM",{});var Zh=r(ya);fm=s(Zh,"multinomial sampling"),Zh.forEach(t),_m=s(sn," by calling "),ka=a(sn,"CODE",{});var Jh=r(ka);bm=s(Jh,"_sample()"),Jh.forEach(t),vm=s(sn," if "),ja=a(sn,"CODE",{});var Xh=r(ja);xm=s(Xh,"num_beams=1"),Xh.forEach(t),ym=s(sn,` and
`),wa=a(sn,"CODE",{});var Qh=r(wa);km=s(Qh,"do_sample=True"),Qh.forEach(t),sn.forEach(t),jm=g(Is),Ge=a(Is,"LI",{});var on=r(Ge);$a=a(on,"EM",{});var eu=r($a);wm=s(eu,"beam-search decoding"),eu.forEach(t),$m=s(on," by calling "),La=a(on,"CODE",{});var tu=r(La);Lm=s(tu,"_beam_search()"),tu.forEach(t),Tm=s(on," if "),Ta=a(on,"CODE",{});var nu=r(Ta);Em=s(nu,"num_beams>1"),nu.forEach(t),Gm=s(on,` and
`),Ea=a(on,"CODE",{});var su=r(Ea);Mm=s(su,"do_sample=False"),su.forEach(t),on.forEach(t),Is.forEach(t),Om=g(re),Hn=a(re,"P",{});var jr=r(Hn);Cm=s(jr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Ss=a(jr,"A",{href:!0});var ou=r(Ss);Sm=s(ou,"text generation strategies guide"),ou.forEach(t),qm=s(jr,"."),jr.forEach(t),Pm=g(re),Gt=a(re,"DIV",{class:!0});var wr=r(Gt);j(Vn.$$.fragment,wr),Fm=g(wr),Ga=a(wr,"P",{});var au=r(Ga);Dm=s(au,"Generates sequences of token ids for models with a language modeling head."),au.forEach(t),wr.forEach(t),re.forEach(t),this.h()},h(){u(c,"name","hf:doc:metadata"),u(c,"content",JSON.stringify(Ou)),u(d,"id","generation"),u(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(d,"href","#generation"),u(p,"class","relative group"),u(X,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),u(R,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin"),u(Xn,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),u(Qn,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.TFGenerationMixin"),u(es,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),u(ts,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin"),u(ns,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(ss,"href","../generation_strategies"),u(ot,"id","transformers.GenerationConfig"),u(ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ot,"href","#transformers.GenerationConfig"),u(Ue,"class","relative group"),u(os,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(as,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(rs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(is,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(ls,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(cs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(ds,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(ps,"href","../generation_strategies"),u(ms,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(gs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(hs,"href","/docs/transformers/v4.29.1/en/main_classes/configuration#transformers.PretrainedConfig"),u(us,"href","/docs/transformers/v4.29.1/en/main_classes/configuration#transformers.PretrainedConfig"),u(fs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(_s,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained"),u(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(lt,"id","transformers.GenerationMixin"),u(lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(lt,"href","#transformers.GenerationMixin"),u(He,"class","relative group"),u(bs,"href","/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel"),u(vs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),u(xs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(ys,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(ks,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(js,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(ws,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u($s,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(Ls,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(Ts,"href","../generation_strategies"),u(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($t,"id","transformers.TFGenerationMixin"),u($t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u($t,"href","#transformers.TFGenerationMixin"),u(Ve,"class","relative group"),u(Es,"href","/docs/transformers/v4.29.1/en/main_classes/model#transformers.TFPreTrainedModel"),u(Gs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),u(Ms,"href","../generation_strategies"),u(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Et,"id","transformers.FlaxGenerationMixin"),u(Et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Et,"href","#transformers.FlaxGenerationMixin"),u(Ke,"class","relative group"),u(Os,"href","/docs/transformers/v4.29.1/en/main_classes/model#transformers.FlaxPreTrainedModel"),u(Cs,"href","/docs/transformers/v4.29.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),u(Ss,"href","../generation_strategies"),u(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,v){e(document.head,c),x(l,_,v),x(l,p,v),e(p,d),e(d,f),w(i,f,null),e(p,h),e(p,E),e(E,y),x(l,b,v),x(l,M,v),e(M,O),e(M,F),e(F,ie),e(M,B),x(l,J,v),x(l,I,v),e(I,C),e(C,q),e(C,X),e(X,ze),e(C,Ne),e(C,R),e(R,Ie),e(C,$r),e(I,Lr),e(I,Be),e(Be,Tr),e(Be,Xn),e(Xn,Er),e(Be,Gr),e(Be,Qn),e(Qn,Mr),e(Be,Or),e(I,Cr),e(I,We),e(We,Sr),e(We,es),e(es,qr),e(We,Pr),e(We,ts),e(ts,Fr),e(We,Dr),x(l,Ba,v),x(l,nt,v),e(nt,Ar),e(nt,ns),e(ns,zr),e(nt,Nr),x(l,Wa,v),x(l,st,v),e(st,Ir),e(st,ss),e(ss,Br),e(st,Wr),x(l,Ua,v),x(l,Ue,v),e(Ue,ot),e(ot,Bs),w(an,Bs,null),e(Ue,Ur),e(Ue,Ws),e(Ws,Rr),x(l,Ra,v),x(l,D,v),w(rn,D,null),e(D,Hr),e(D,ln),e(ln,Vr),e(ln,Us),e(Us,Yr),e(ln,Kr),e(D,Zr),e(D,A),e(A,le),e(le,Rs),e(Rs,Jr),e(le,Xr),e(le,os),e(os,Qr),e(le,ei),e(le,Hs),e(Hs,ti),e(le,ni),e(le,Vs),e(Vs,si),e(A,oi),e(A,ce),e(ce,Ys),e(Ys,ai),e(ce,ri),e(ce,as),e(as,ii),e(ce,li),e(ce,Ks),e(Ks,ci),e(ce,di),e(ce,Zs),e(Zs,pi),e(A,mi),e(A,de),e(de,Js),e(Js,gi),e(de,hi),e(de,rs),e(rs,ui),e(de,fi),e(de,Xs),e(Xs,_i),e(de,bi),e(de,Qs),e(Qs,vi),e(A,xi),e(A,pe),e(pe,eo),e(eo,yi),e(pe,ki),e(pe,is),e(is,ji),e(pe,wi),e(pe,to),e(to,$i),e(pe,Li),e(pe,no),e(no,Ti),e(A,Ei),e(A,me),e(me,so),e(so,Gi),e(me,Mi),e(me,ls),e(ls,Oi),e(me,Ci),e(me,oo),e(oo,Si),e(me,qi),e(me,ao),e(ao,Pi),e(A,Fi),e(A,ge),e(ge,ro),e(ro,Di),e(ge,Ai),e(ge,cs),e(cs,zi),e(ge,Ni),e(ge,io),e(io,Ii),e(ge,Bi),e(ge,lo),e(lo,Wi),e(A,Ui),e(A,he),e(he,co),e(co,Ri),e(he,Hi),e(he,ds),e(ds,Vi),e(he,Yi),e(he,po),e(po,Ki),e(he,Zi),e(he,mo),e(mo,Ji),e(A,Xi),e(A,ue),e(ue,go),e(go,Qi),e(ue,el),e(ue,ho),e(ho,tl),e(ue,nl),e(ue,uo),e(uo,sl),e(ue,ol),e(ue,fo),e(fo,al),e(D,rl),e(D,cn),e(cn,il),e(cn,ps),e(ps,ll),e(cn,cl),e(D,dl),e(D,Me),w(dn,Me,null),e(Me,pl),e(Me,pn),e(pn,ml),e(pn,ms),e(ms,gl),e(pn,hl),e(Me,ul),w(at,Me,null),e(D,fl),e(D,rt),w(mn,rt,null),e(rt,_l),e(rt,Z),e(Z,bl),e(Z,gs),e(gs,vl),e(Z,xl),e(Z,hs),e(hs,yl),e(Z,kl),e(Z,us),e(us,jl),e(Z,wl),e(Z,fs),e(fs,$l),e(Z,Ll),e(D,Tl),e(D,it),w(gn,it,null),e(it,El),e(it,Re),e(Re,Gl),e(Re,_o),e(_o,Ml),e(Re,Ol),e(Re,_s),e(_s,Cl),e(Re,Sl),x(l,Ha,v),x(l,He,v),e(He,lt),e(lt,bo),w(hn,bo,null),e(He,ql),e(He,vo),e(vo,Pl),x(l,Va,v),x(l,S,v),w(un,S,null),e(S,Fl),e(S,fn),e(fn,Dl),e(fn,bs),e(bs,Al),e(fn,zl),e(S,Nl),e(S,_n),e(_n,Il),e(_n,vs),e(vs,Bl),e(_n,Wl),e(S,Ul),e(S,W),e(W,fe),e(fe,xo),e(xo,Rl),e(fe,Hl),e(fe,xs),e(xs,Vl),e(fe,Yl),e(fe,yo),e(yo,Kl),e(fe,Zl),e(fe,ko),e(ko,Jl),e(W,Xl),e(W,_e),e(_e,jo),e(jo,Ql),e(_e,ec),e(_e,ys),e(ys,tc),e(_e,nc),e(_e,wo),e(wo,sc),e(_e,oc),e(_e,$o),e($o,ac),e(W,rc),e(W,be),e(be,Lo),e(Lo,ic),e(be,lc),e(be,ks),e(ks,cc),e(be,dc),e(be,To),e(To,pc),e(be,mc),e(be,Eo),e(Eo,gc),e(W,hc),e(W,ve),e(ve,Go),e(Go,uc),e(ve,fc),e(ve,js),e(js,_c),e(ve,bc),e(ve,Mo),e(Mo,vc),e(ve,xc),e(ve,Oo),e(Oo,yc),e(W,kc),e(W,xe),e(xe,Co),e(Co,jc),e(xe,wc),e(xe,ws),e(ws,$c),e(xe,Lc),e(xe,So),e(So,Tc),e(xe,Ec),e(xe,qo),e(qo,Gc),e(W,Mc),e(W,ye),e(ye,Po),e(Po,Oc),e(ye,Cc),e(ye,$s),e($s,Sc),e(ye,qc),e(ye,Fo),e(Fo,Pc),e(ye,Fc),e(ye,Do),e(Do,Dc),e(W,Ac),e(W,ke),e(ke,Ao),e(Ao,zc),e(ke,Nc),e(ke,Ls),e(Ls,Ic),e(ke,Bc),e(ke,zo),e(zo,Wc),e(ke,Uc),e(ke,No),e(No,Rc),e(S,Hc),e(S,bn),e(bn,Vc),e(bn,Ts),e(Ts,Yc),e(bn,Kc),e(S,Zc),e(S,Oe),w(vn,Oe,null),e(Oe,Jc),e(Oe,Io),e(Io,Xc),e(Oe,Qc),w(ct,Oe,null),e(S,ed),e(S,Ce),w(xn,Ce,null),e(Ce,td),e(Ce,Bo),e(Bo,nd),e(Ce,sd),w(dt,Ce,null),e(S,od),e(S,Q),w(yn,Q,null),e(Q,ad),e(Q,kn),e(kn,rd),e(kn,Wo),e(Wo,id),e(kn,ld),e(Q,cd),w(pt,Q,null),e(Q,dd),w(mt,Q,null),e(S,pd),e(S,ee),w(jn,ee,null),e(ee,md),e(ee,wn),e(wn,gd),e(wn,Uo),e(Uo,hd),e(wn,ud),e(ee,fd),w(gt,ee,null),e(ee,_d),w(ht,ee,null),e(S,bd),e(S,te),w($n,te,null),e(te,vd),e(te,Ln),e(Ln,xd),e(Ln,Ro),e(Ro,yd),e(Ln,kd),e(te,jd),w(ut,te,null),e(te,wd),w(ft,te,null),e(S,$d),e(S,ne),w(Tn,ne,null),e(ne,Ld),e(ne,En),e(En,Td),e(En,Ho),e(Ho,Ed),e(En,Gd),e(ne,Md),w(_t,ne,null),e(ne,Od),w(bt,ne,null),e(S,Cd),e(S,se),w(Gn,se,null),e(se,Sd),e(se,Mn),e(Mn,qd),e(Mn,Vo),e(Vo,Pd),e(Mn,Fd),e(se,Dd),w(vt,se,null),e(se,Ad),w(xt,se,null),e(S,zd),e(S,oe),w(On,oe,null),e(oe,Nd),e(oe,Cn),e(Cn,Id),e(Cn,Yo),e(Yo,Bd),e(Cn,Wd),e(oe,Ud),w(yt,oe,null),e(oe,Rd),w(kt,oe,null),e(S,Hd),e(S,ae),w(Sn,ae,null),e(ae,Vd),e(ae,qn),e(qn,Yd),e(qn,Ko),e(Ko,Kd),e(qn,Zd),e(ae,Jd),w(jt,ae,null),e(ae,Xd),w(wt,ae,null),x(l,Ya,v),x(l,Ve,v),e(Ve,$t),e($t,Zo),w(Pn,Zo,null),e(Ve,Qd),e(Ve,Jo),e(Jo,ep),x(l,Ka,v),x(l,z,v),w(Fn,z,null),e(z,tp),e(z,Dn),e(Dn,np),e(Dn,Es),e(Es,sp),e(Dn,op),e(z,ap),e(z,An),e(An,rp),e(An,Gs),e(Gs,ip),e(An,lp),e(z,cp),e(z,je),e(je,we),e(we,Xo),e(Xo,dp),e(we,pp),e(we,Qo),e(Qo,mp),e(we,gp),e(we,ea),e(ea,hp),e(we,up),e(we,ta),e(ta,fp),e(je,_p),e(je,$e),e($e,na),e(na,bp),e($e,vp),e($e,sa),e(sa,xp),e($e,yp),e($e,oa),e(oa,kp),e($e,jp),e($e,aa),e(aa,wp),e(je,$p),e(je,Le),e(Le,ra),e(ra,Lp),e(Le,Tp),e(Le,ia),e(ia,Ep),e(Le,Gp),e(Le,la),e(la,Mp),e(Le,Op),e(Le,ca),e(ca,Cp),e(je,Sp),e(je,Ye),e(Ye,da),e(da,qp),e(Ye,Pp),e(Ye,pa),e(pa,Fp),e(Ye,Dp),e(Ye,ma),e(ma,Ap),e(z,zp),e(z,zn),e(zn,Np),e(zn,Ms),e(Ms,Ip),e(zn,Bp),e(z,Wp),e(z,Se),w(Nn,Se,null),e(Se,Up),e(Se,ga),e(ga,Rp),e(Se,Hp),w(Lt,Se,null),e(z,Vp),e(z,qe),w(In,qe,null),e(qe,Yp),e(qe,ha),e(ha,Kp),e(qe,Zp),w(Tt,qe,null),x(l,Za,v),x(l,Ke,v),e(Ke,Et),e(Et,ua),w(Bn,ua,null),e(Ke,Jp),e(Ke,fa),e(fa,Xp),x(l,Ja,v),x(l,U,v),w(Wn,U,null),e(U,Qp),e(U,Un),e(Un,em),e(Un,Os),e(Os,tm),e(Un,nm),e(U,sm),e(U,Rn),e(Rn,om),e(Rn,Cs),e(Cs,am),e(Rn,rm),e(U,im),e(U,Ze),e(Ze,Te),e(Te,_a),e(_a,lm),e(Te,cm),e(Te,ba),e(ba,dm),e(Te,pm),e(Te,va),e(va,mm),e(Te,gm),e(Te,xa),e(xa,hm),e(Ze,um),e(Ze,Ee),e(Ee,ya),e(ya,fm),e(Ee,_m),e(Ee,ka),e(ka,bm),e(Ee,vm),e(Ee,ja),e(ja,xm),e(Ee,ym),e(Ee,wa),e(wa,km),e(Ze,jm),e(Ze,Ge),e(Ge,$a),e($a,wm),e(Ge,$m),e(Ge,La),e(La,Lm),e(Ge,Tm),e(Ge,Ta),e(Ta,Em),e(Ge,Gm),e(Ge,Ea),e(Ea,Mm),e(U,Om),e(U,Hn),e(Hn,Cm),e(Hn,Ss),e(Ss,Sm),e(Hn,qm),e(U,Pm),e(U,Gt),w(Vn,Gt,null),e(Gt,Fm),e(Gt,Ga),e(Ga,Dm),Xa=!0},p(l,[v]){const Yn={};v&2&&(Yn.$$scope={dirty:v,ctx:l}),at.$set(Yn);const Ma={};v&2&&(Ma.$$scope={dirty:v,ctx:l}),ct.$set(Ma);const Oa={};v&2&&(Oa.$$scope={dirty:v,ctx:l}),dt.$set(Oa);const Ca={};v&2&&(Ca.$$scope={dirty:v,ctx:l}),pt.$set(Ca);const Kn={};v&2&&(Kn.$$scope={dirty:v,ctx:l}),mt.$set(Kn);const Sa={};v&2&&(Sa.$$scope={dirty:v,ctx:l}),gt.$set(Sa);const Je={};v&2&&(Je.$$scope={dirty:v,ctx:l}),ht.$set(Je);const Xe={};v&2&&(Xe.$$scope={dirty:v,ctx:l}),ut.$set(Xe);const qa={};v&2&&(qa.$$scope={dirty:v,ctx:l}),ft.$set(qa);const Pa={};v&2&&(Pa.$$scope={dirty:v,ctx:l}),_t.$set(Pa);const Qe={};v&2&&(Qe.$$scope={dirty:v,ctx:l}),bt.$set(Qe);const Fa={};v&2&&(Fa.$$scope={dirty:v,ctx:l}),vt.$set(Fa);const Da={};v&2&&(Da.$$scope={dirty:v,ctx:l}),xt.$set(Da);const et={};v&2&&(et.$$scope={dirty:v,ctx:l}),yt.$set(et);const Aa={};v&2&&(Aa.$$scope={dirty:v,ctx:l}),kt.$set(Aa);const za={};v&2&&(za.$$scope={dirty:v,ctx:l}),jt.$set(za);const Zn={};v&2&&(Zn.$$scope={dirty:v,ctx:l}),wt.$set(Zn);const Na={};v&2&&(Na.$$scope={dirty:v,ctx:l}),Lt.$set(Na);const Jn={};v&2&&(Jn.$$scope={dirty:v,ctx:l}),Tt.$set(Jn)},i(l){Xa||($(i.$$.fragment,l),$(an.$$.fragment,l),$(rn.$$.fragment,l),$(dn.$$.fragment,l),$(at.$$.fragment,l),$(mn.$$.fragment,l),$(gn.$$.fragment,l),$(hn.$$.fragment,l),$(un.$$.fragment,l),$(vn.$$.fragment,l),$(ct.$$.fragment,l),$(xn.$$.fragment,l),$(dt.$$.fragment,l),$(yn.$$.fragment,l),$(pt.$$.fragment,l),$(mt.$$.fragment,l),$(jn.$$.fragment,l),$(gt.$$.fragment,l),$(ht.$$.fragment,l),$($n.$$.fragment,l),$(ut.$$.fragment,l),$(ft.$$.fragment,l),$(Tn.$$.fragment,l),$(_t.$$.fragment,l),$(bt.$$.fragment,l),$(Gn.$$.fragment,l),$(vt.$$.fragment,l),$(xt.$$.fragment,l),$(On.$$.fragment,l),$(yt.$$.fragment,l),$(kt.$$.fragment,l),$(Sn.$$.fragment,l),$(jt.$$.fragment,l),$(wt.$$.fragment,l),$(Pn.$$.fragment,l),$(Fn.$$.fragment,l),$(Nn.$$.fragment,l),$(Lt.$$.fragment,l),$(In.$$.fragment,l),$(Tt.$$.fragment,l),$(Bn.$$.fragment,l),$(Wn.$$.fragment,l),$(Vn.$$.fragment,l),Xa=!0)},o(l){L(i.$$.fragment,l),L(an.$$.fragment,l),L(rn.$$.fragment,l),L(dn.$$.fragment,l),L(at.$$.fragment,l),L(mn.$$.fragment,l),L(gn.$$.fragment,l),L(hn.$$.fragment,l),L(un.$$.fragment,l),L(vn.$$.fragment,l),L(ct.$$.fragment,l),L(xn.$$.fragment,l),L(dt.$$.fragment,l),L(yn.$$.fragment,l),L(pt.$$.fragment,l),L(mt.$$.fragment,l),L(jn.$$.fragment,l),L(gt.$$.fragment,l),L(ht.$$.fragment,l),L($n.$$.fragment,l),L(ut.$$.fragment,l),L(ft.$$.fragment,l),L(Tn.$$.fragment,l),L(_t.$$.fragment,l),L(bt.$$.fragment,l),L(Gn.$$.fragment,l),L(vt.$$.fragment,l),L(xt.$$.fragment,l),L(On.$$.fragment,l),L(yt.$$.fragment,l),L(kt.$$.fragment,l),L(Sn.$$.fragment,l),L(jt.$$.fragment,l),L(wt.$$.fragment,l),L(Pn.$$.fragment,l),L(Fn.$$.fragment,l),L(Nn.$$.fragment,l),L(Lt.$$.fragment,l),L(In.$$.fragment,l),L(Tt.$$.fragment,l),L(Bn.$$.fragment,l),L(Wn.$$.fragment,l),L(Vn.$$.fragment,l),Xa=!1},d(l){t(c),l&&t(_),l&&t(p),T(i),l&&t(b),l&&t(M),l&&t(J),l&&t(I),l&&t(Ba),l&&t(nt),l&&t(Wa),l&&t(st),l&&t(Ua),l&&t(Ue),T(an),l&&t(Ra),l&&t(D),T(rn),T(dn),T(at),T(mn),T(gn),l&&t(Ha),l&&t(He),T(hn),l&&t(Va),l&&t(S),T(un),T(vn),T(ct),T(xn),T(dt),T(yn),T(pt),T(mt),T(jn),T(gt),T(ht),T($n),T(ut),T(ft),T(Tn),T(_t),T(bt),T(Gn),T(vt),T(xt),T(On),T(yt),T(kt),T(Sn),T(jt),T(wt),l&&t(Ya),l&&t(Ve),T(Pn),l&&t(Ka),l&&t(z),T(Fn),T(Nn),T(Lt),T(In),T(Tt),l&&t(Za),l&&t(Ke),T(Bn),l&&t(Ja),l&&t(U),T(Wn),T(Vn)}}}const Ou={local:"generation",sections:[{local:"transformers.GenerationConfig",title:"GenerationConfig"},{local:"transformers.GenerationMixin",title:"GenerationMixin"},{local:"transformers.TFGenerationMixin",title:"TFGenerationMixin"},{local:"transformers.FlaxGenerationMixin",title:"FlaxGenerationMixin"}],title:"Generation"};function Cu(G){return du(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zu extends ru{constructor(c){super();iu(this,c,Cu,Mu,lu,{})}}export{zu as default,Ou as metadata};
