import{s as Ai,o as Pi,n as bt}from"../chunks/scheduler.69131cc3.js";import{S as Bi,i as Fi,g as r,s as i,r as u,A as zi,h as s,f as a,c as n,j as Yi,u as d,x as o,k as Mt,y as Ri,a as l,v as h,d as f,t as m,w as y}from"../chunks/index.e1f30d73.js";import{T as vt}from"../chunks/Tip.22e79575.js";import{C as g}from"../chunks/CodeBlock.30cef355.js";import{H as b}from"../chunks/Heading.0aab6758.js";function Ni(v){let c,w=`You can fully deactivate the automatic device placement by passing along <code>device_placement=False</code> when
initializing the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>.
However, if you place your objects manually on the proper device, be careful to create your optimizer after putting your
model on <code>accelerator.device</code> or your training will fail on TPU.`;return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1wr7tno"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function Vi(v){let c,w=`The actual batch size for your training will be the number of devices used multiplied by the batch size you set in
your script. For instance, training on 4 GPUs with a batch size of 16 set when creating the training dataloader will
train at an actual batch size of 64 (4 * 16).
If you want the batch size remain the same regardless of how many GPUs the script is run on, you can use the
option <code>split_batches=True</code> when creating and initializing <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>.
Your training dataloader may change length when going through this method: if you run on X GPUs, it will have its
length divided by X (since your actual batch size will be multiplied by X), unless you set
<code>split_batches=True</code>.`;return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1niax0l"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function Qi(v){let c,w=`Similar to the training dataloader, passing your validation dataloader through
<a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> may change it: if you run on X GPUs, it will have its length divided by X
(since your actual batch size will be multiplied by X), unless you set <code>split_batches=True</code>.`;return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1vzktn4"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function Si(v){let c,w=`If for some reason you don’t wish to have this automatically done, <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a> can be used instead to gather
the data across all processes and this can manually be done instead.`;return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-vr4k64"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function Ei(v){let c,w=`The <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a> and <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> methods require the tensors to be all the same size on each process. If
you have tensors of different sizes on each process (for instance when dynamically padding to the maximum length in
a batch), you should use the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.pad_across_processes">pad_across_processes()</a> method to pad you tensor to the
biggest size across processes.`;return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-q9suf6"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function qi(v){let c,w=`Your <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object should only be defined inside the training function. This is because the
initialization should be done inside the launcher only.`;return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1bkuunh"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function Ki(v){let c,w='Every object passed to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> must have a <code>load_state_dict</code> and <code>state_dict</code> function to be stored';return{c(){c=r("p"),c.innerHTML=w},l(p){c=s(p,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1vby1cv"&&(c.innerHTML=w)},m(p,$){l(p,c,$)},p:bt,d(p){p&&a(c)}}}function Di(v){let c,w,p,$,G,Tt,Z,Ml=`This guide aims to help you get started with 🤗 Accelerate quickly. It covers the essential steps you need to take to
enable distributed training, as well as the adjustments that you need to make in some common scenarios.`,kt,W,Tl="To help you navigate, the guide is split into two sections:",xt,I,kl='<li><a href="#getting-started-with--accelerate">Getting Started with 🤗 Accelerate</a>: start here to learn how to modify your script to enable distributed training with 🤗 Accelerate</li> <li><a href="#common-adaptations-to-the-base-case">Common adaptations to the base case</a>: check out this section for common deviations from the baseline scenario and what adjustments may need to be made to support them.</li>',jt,L,Ct,X,Jt,Y,xl="To use 🤗 Accelerate in your own training script, you have to modify four things:",Ut,A,jl='<li>Import the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> main class and instantiate one in an <code>accelerator</code> object.</li>',Ht,P,Gt,B,Cl=`Add this at the beginning of your training script as it will initialize everything necessary for distributed training.
You don’t need to indicate the kind of environment you are in (a single machine with a GPU, a machine with several GPUs,
or several machines with multiple GPUs or a TPU), the library will detect this automatically.`,Zt,_,Jl="<li>Remove the <code>.to(device)</code> or <code>.cuda()</code> calls for your model and input data.</li>",Wt,F,Ul=`The <code>accelerator</code> object will handle placing these objects on the right device for you.
If you choose to leave those <code>.to(device)</code> calls, make sure to use the device provided by the <code>accelerator</code> object: <code>accelerator.device</code>.`,It,M,Lt,T,Hl=`<li>Pass all PyTorch objects relevant to training (optimizer, model, dataloader(s), learning rate scheduler) to the
<a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method as soon as these objects are created, before starting your actual
training loop:</li>`,Xt,z,Yt,R,Gl="<strong>Important notes</strong>:",At,N,Zl=`<li>You should always pass the the learning rate scheduler to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>, however if the scheduler should <em>not</em> be stepped at each optimization step, pass <code>step_with_optimizer=False</code> to the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> init.</li> <li>While you can send your dataloader to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> on its own (and there are cases for doing so, such as distributed inference), it’s best to send it to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> together with the model and optimizer.</li> <li>If you wish to run distributed evaluation, send your validation dataloader to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> as well. There are some nuances to distributed validation, check the <a href="#add-distributed-evaluation">Distributed evaluation</a> section of the guide.</li> <li>Any instruction using your training dataloader length (for instance if you want to log the number of total training
steps) should go after the call to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>.</li>`,Pt,V,Wl=`Passing <code>DataLoader</code> objects to the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method ensures that your dataloader will be sharded across
all GPUs/TPU cores available so that each one sees a different portion of the training dataset. In other words, if there are 8 processes and a dataset of 64 items, each process will see 8 of these items per iteration. Also, the random states
of all processes will be synchronized at the beginning of each iteration through your dataloader, to make sure the data
is shuffled the same way (if you decided to use <code>shuffle=True</code> or any kind of random sampler).`,Bt,k,Ft,x,Il="<li>Replace the <code>loss.backward()</code> line with <code>accelerator.backward(loss)</code>.</li>",zt,Q,Ll=`And you’re all set! With all these changes, your script will run on your local machine as well as on multiple GPUs or a
TPU! You can either use your favorite tool to launch the distributed training, or you can use the 🤗 Accelerate
launcher.`,Rt,S,Nt,E,Xl=`You can perform regular evaluation in your training script if you leave your validation dataloader out of the
<a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method. In this case, you will need to put the input data on the
<code>accelerator.device</code> manually.`,Vt,q,Yl=`To perform distributed evaluation, send along your validation dataloader to the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>
method:`,Qt,K,St,D,Al=`Same as with your training dataloader, each device will only see part of the evaluation data should you run your script
on multiple devices. This means you will need to group your predictions together which you can do with
the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method.`,Et,O,qt,j,Kt,ee,Pl=`Some data at the end of the dataset may be duplicated so the batch can be divided equally among all workers. As a result,
metrics should be calculated through the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method to automatically remove the duplicated
data while gathering and provide a more accurate metric.`,Dt,C,Ot,J,ea,te,ta,ae,Bl=`You can use the regular commands to launch your distributed training (like <code>torch.distributed.run</code> for
PyTorch) - they are fully compatible with 🤗 Accelerate.`,aa,le,Fl=`Alternatively, 🤗 Accelerate provides a CLI tool that unifies all launchers, so you only have to remember one command. \\
To use it, run a quick configuration setup first on your machine and answer the questions:`,la,ie,ia,ne,zl=`At the end of the setup, a <em>default_config.yaml</em> file will be saved in your cache folder for 🤗 Accelerate. That cache
folder is (with decreasing order of priority):`,na,re,Rl=`<li>The content of your environment variable <code>HF_HOME</code> suffixed with <em>accelerate</em>.</li> <li>If it does not exist, the content of your environment variable <code>XDG_CACHE_HOME</code> suffixed with
<em>huggingface/accelerate</em>.</li> <li>If this does not exist either, the folder <em>~/.cache/huggingface/accelerate</em>.</li>`,ra,se,Nl=`By specifying the <code>--config_file</code>  flag you can specify an alternative location of the configuration file.
Once the configuration setup is complete, you can test your setup by running:`,sa,oe,oa,ce,Vl=`This will launch a short script that will test the distributed environment. If it runs without issues, you are ready for
the next step!`,ca,pe,Ql="Note that if you specified a location for the config file in the previous step, you need to pass it here as well:",pa,ue,ua,de,Sl="Now that this is done, you can run your script with the following command:",da,he,ha,fe,El="If you stored the config file in a non-default location, you can indicate it to the launcher like this:",fa,me,ma,ye,ql=`You can override any of the arguments determined by your config file. To see the complete list of parameters that you
can pass in, run <code>accelerate launch -h</code>. (And further niche argument help by passing in partial commands, such as <code>accelerate launch --multi_gpu -h</code> for all <code>multi_gpu</code> args)`,ya,we,Kl='Check out the <a href="basic_tutorials/launch">Launch tutorial</a> for more information about launching your scripts.',wa,ge,ga,$e,Dl=`The previous section covers the minimal essential steps to move a training script into a distributed setup with 🤗 Accelerate.
Here we describe common modifications/deviations from the base case scenario and the adjustments you need to make to accommodate for them.`,$a,ve,va,be,Ol=`Accelerate has a <a href="/docs/accelerate/v0.27.1/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> to help you launch your training function from a
notebook. This launcher supports launching a training with TPUs on Colab or Kaggle, as well as training on several GPUs and machines
(if the machine on which you are running your notebook has them).`,ba,_e,ei=`Define a function responsible for your whole training and/or evaluation in a cell of the notebook, then execute a
cell with the following code:`,_a,Me,Ma,U,Ta,Te,ti='Check out the <a href="basic_tutorials/notebook">Notebook Launcher tutorial</a> for more information about training on TPUs.',ka,ke,xa,xe,ai=`If you want to launch your script on TPUs, there are a few caveats you should be aware of. Behind the scenes, the TPUs
will create a graph of all the operations happening in your training step (forward pass, backward pass and optimizer
step). This is why your first step of training will always be very long as building and compiling this graph for
optimizations takes some time.`,ja,je,li=`The good news is that this compilation will be cached so the second step and all the following will be much faster. The
bad news is that it only applies if all of your steps do exactly the same operations, which implies:`,Ca,Ce,ii="<li>having all tensors of the same length in all your batches</li> <li>having static code (i.e., not a for loop of length that could change from step to step)</li>",Ja,Je,ni=`Having any of the things above change between two steps will trigger a new compilation which will, once again, take a
lot of time. In practice, that means you must take special care to have all your tensors in your inputs of the same
shape (so no dynamic padding for instance if you are in an NLP problem) and should not use layers with for loops that
have different lengths depending on the inputs (such as an LSTM) or the training will be excruciatingly slow.`,Ua,Ue,ri=`To introduce special behavior in your script for TPUs you can check the <code>distributed_type</code> of your
<code>accelerator</code>:`,Ha,He,Ga,Ge,si=`The <a href="https://github.com/huggingface/accelerate/blob/main/examples/nlp_example.py" rel="nofollow">NLP example</a> shows an example in a
situation with dynamic padding.`,Za,Ze,oi=`One last thing to pay close attention to: if your model has tied weights (such as language models which tie the weights
of the embedding matrix with the weights of the decoder), moving this model to the TPU (either yourself or after you
passed your model to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>) will break the tying. You will need to retie the weights
after. You can find an example of this in the <a href="https://github.com/huggingface/transformers/blob/master/examples/pytorch/language-modeling/run_clm.py" rel="nofollow">run_clm_no_trainer</a> script in
the Transformers repository.`,Wa,We,ci='Check out the <a href="concept_guides/training_tpu">TPU tutorial</a> for more information about training on TPUs.',Ia,Ie,La,Le,pi=`Some of your instructions only need to run for one process on a given server: for instance a data download or a log
statement. To do this, wrap the statement in a test like this:`,Xa,Xe,Ya,Ye,ui=`Another example is progress bars: to avoid having multiple progress bars in your output, you should only display one on
the local main process:`,Aa,Ae,Pa,Pe,di=`The <em>local</em> means per machine: if you are running your training on two servers with several GPUs, the instruction will
be executed once on each of those servers. If you need to execute something only once for all processes (and not per
machine) for instance, uploading the final model to the 🤗 model hub, wrap it in a test like this:`,Ba,Be,Fa,Fe,hi=`For printing statements you only want executed once per machine, you can just replace the <code>print</code> function by
<code>accelerator.print</code>.`,za,ze,Ra,Re,fi=`When you run your usual script, instructions are executed in order. Using 🤗 Accelerate to deploy your script on several
GPUs at the same time introduces a complication: while each process executes all instructions in order, some may be
faster than others.`,Na,Ne,mi=`You might need to wait for all processes to have reached a certain point before executing a given instruction. For
instance, you shouldn’t save a model before making sure every process is done with training. To do this, add the
following line in your code:`,Va,Ve,Qa,Qe,yi=`This instruction will block all the processes that arrive first until all the other processes have reached that
point (if you run your script on just one GPU or CPU, this won’t do anything).`,Sa,Se,Ea,Ee,wi=`Saving the model you trained might need a bit of adjustment: first you should wait for all processes to reach that
point in the script as shown above, and then, you should unwrap your model before saving it. This is because when going
through the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method, your model may have been placed inside a bigger model,
which deals with the distributed training. This in turn means that saving your model state dictionary without taking
any precaution will take that potential extra layer into account, and you will end up with weights you can’t load back
in your base model. The <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method will help you to achieve that. It will unwrap your model and save
the model state dictionary.`,qa,qe,gi="Here is an example:",Ka,Ke,Da,De,$i='The <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method can also save a model into sharded checkpoints or with safetensors format:',Oa,Oe,el,et,vi=`If your script contains logic to load a checkpoint, we also recommend you load your weights in the unwrapped model
(this is only useful if you use the load function after making your model go through
<a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>). Here is an example:`,tl,tt,al,at,bi="Note that since all the model parameters are references to tensors, this will load your weights inside <code>model</code>.",ll,lt,_i=`If you want to load a sharded checkpoint or a checkpoint with safetensors format into the model with a specific <code>device</code>,
we recommend you to load it with <a href="/docs/accelerate/v0.27.1/en/package_reference/utilities#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> function. Here’s an example:`,il,it,nl,nt,rl,rt,Mi=`When training your model, you may want to save the current state of the model, optimizer, random generators, and potentially
learning rate schedulers to be restored in the <em>same script</em>.
You can use <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> respectively to do so.`,sl,st,Ti=`To further customize where and how states saved through <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> the <a href="/docs/accelerate/v0.27.1/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class can be used. For example
if <code>automatic_checkpoint_naming</code> is enabled each saved checkpoint will be located then at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.`,ol,ot,ki='If you have registered any other stateful items to be stored through <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> they will also be saved and/or loaded.',cl,H,pl,ct,ul,pt,xi=`If you are using gradient clipping in your script, you should replace the calls to
<code>torch.nn.utils.clip_grad_norm_</code> or <code>torch.nn.utils.clip_grad_value_</code> with <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a>
and <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> respectively.`,dl,ut,hl,dt,ji=`If you are running your training in Mixed Precision with 🤗 Accelerate, you will get the best result with your loss being
computed inside your model (like in Transformer models for instance). Every computation outside of the model will be
executed in full precision (which is generally what you want for loss computation, especially if it involves a
softmax). However, you might want to put your loss computation inside the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager:`,fl,ht,ml,ft,Ci=`Another caveat with Mixed Precision training is that the gradient will skip a few updates at the beginning and
sometimes during training: because of the dynamic loss scaling strategy, there are points during training where the
gradients have overflown, and the loss scaling factor is reduced to avoid this happening again at the next step.`,yl,mt,Ji=`This means that you may update your learning rate scheduler when there was no update, which is fine in general, but may
have an impact when you have very little training data, or if the first learning rate values of your scheduler are very
important. In this case, you can skip the learning rate scheduler updates when the optimizer step was not done like
this:`,wl,yt,gl,wt,$l,gt,Ui=`To perform gradient accumulation use <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> and specify a <code>gradient_accumulation_steps</code>.
This will also automatically ensure the gradients are synced or unsynced when on multi-device training, check if the step should
actually be performed, and auto-scale the loss:`,vl,$t,bl,_t,_l;return G=new b({props:{title:"Quick tour",local:"quick-tour",headingTag:"h1"}}),L=new b({props:{title:"Getting started with 🤗 Accelerate",local:"getting-started-with--accelerate",headingTag:"h2"}}),X=new b({props:{title:"Enable distributed training in your script",local:"enable-distributed-training-in-your-script",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),M=new vt({props:{warning:!0,$$slots:{default:[Ni]},$$scope:{ctx:v}}}),z=new g({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
    model, optimizer, train_dataloader, lr_scheduler
)`,wrap:!1}}),k=new vt({props:{$$slots:{default:[Vi]},$$scope:{ctx:v}}}),S=new b({props:{title:"Add distributed evaluation",local:"add-distributed-evaluation",headingTag:"h3"}}),K=new g({props:{code:"dmFsaWRhdGlvbl9kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSh2YWxpZGF0aW9uX2RhdGFsb2FkZXIp",highlighted:"validation_dataloader = accelerator.prepare(validation_dataloader)",wrap:!1}}),O=new g({props:{code:"Zm9yJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMGluJTIwdmFsaWRhdGlvbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2F0aGVyJTIwYWxsJTIwcHJlZGljdGlvbnMlMjBhbmQlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXJfZm9yX21ldHJpY3MoKHByZWRpY3Rpb25zJTJDJTIwdGFyZ2V0cykpJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXhhbXBsZSUyMG9mJTIwdXNlJTIwd2l0aCUyMGElMjAqRGF0YXNldHMuTWV0cmljKiUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2goYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMp",highlighted:`<span class="hljs-keyword">for</span> inputs, targets <span class="hljs-keyword">in</span> validation_dataloader:
    predictions = model(inputs)
    <span class="hljs-comment"># Gather all predictions and targets</span>
    all_predictions, all_targets = accelerator.gather_for_metrics((predictions, targets))
    <span class="hljs-comment"># Example of use with a *Datasets.Metric*</span>
    metric.add_batch(all_predictions, all_targets)`,wrap:!1}}),j=new vt({props:{warning:!0,$$slots:{default:[Qi]},$$scope:{ctx:v}}}),C=new vt({props:{$$slots:{default:[Si]},$$scope:{ctx:v}}}),J=new vt({props:{warning:!0,$$slots:{default:[Ei]},$$scope:{ctx:v}}}),te=new b({props:{title:"Launch your distributed script",local:"launch-your-distributed-script",headingTag:"h3"}}),ie=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),oe=new g({props:{code:"YWNjZWxlcmF0ZSUyMHRlc3Q=",highlighted:'accelerate <span class="hljs-built_in">test</span>',wrap:!1}}),ue=new g({props:{code:"YWNjZWxlcmF0ZSUyMHRlc3QlMjAtLWNvbmZpZ19maWxlJTIwcGF0aF90b19jb25maWcueWFtbA==",highlighted:'accelerate <span class="hljs-built_in">test</span> --config_file path_to_config.yaml',wrap:!1}}),he=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHBhdGhfdG9fc2NyaXB0LnB5JTIwLS1hcmdzX2Zvcl90aGVfc2NyaXB0",highlighted:"accelerate launch path_to_script.py --args_for_the_script",wrap:!1}}),me=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjBwYXRoX3RvX2NvbmZpZy55YW1sJTIwcGF0aF90b19zY3JpcHQucHklMjAtLWFyZ3NfZm9yX3RoZV9zY3JpcHQ=",highlighted:"accelerate launch --config_file path_to_config.yaml path_to_script.py --args_for_the_script",wrap:!1}}),ge=new b({props:{title:"Common modifications of the base case",local:"common-modifications-of-the-base-case",headingTag:"h2"}}),ve=new b({props:{title:"Launch distributed training from a notebook",local:"launch-distributed-training-from-a-notebook",headingTag:"h3"}}),Me=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),U=new vt({props:{warning:!0,$$slots:{default:[qi]},$$scope:{ctx:v}}}),ke=new b({props:{title:"Specifics of training on TPU",local:"specifics-of-training-on-tpu",headingTag:"h3"}}),He=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBEaXN0cmlidXRlZFR5cGUlMEElMEFpZiUyMGFjY2VsZXJhdG9yLmRpc3RyaWJ1dGVkX3R5cGUlMjAlM0QlM0QlMjBEaXN0cmlidXRlZFR5cGUuVFBVJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBvZiUyMHN0YXRpYyUyMHNoYXBlJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGdvJTIwY3JhenklMjBhbmQlMjBiZSUyMGR5bmFtaWM=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> DistributedType

<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.TPU:
    <span class="hljs-comment"># do something of static shape</span>
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># go crazy and be dynamic</span>`,wrap:!1}}),Ie=new b({props:{title:"Execute a statement only on one processes",local:"execute-a-statement-only-on-one-processes",headingTag:"h3"}}),Xe=new g({props:{code:"aWYlMjBhY2NlbGVyYXRvci5pc19sb2NhbF9tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBJcyUyMGV4ZWN1dGVkJTIwb25jZSUyMHBlciUyMHNlcnZlcg==",highlighted:`<span class="hljs-keyword">if</span> accelerator.is_local_main_process:
    <span class="hljs-comment"># Is executed once per server</span>`,wrap:!1}}),Ae=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKGFyZ3MubWF4X3RyYWluX3N0ZXBzKSUyQyUyMGRpc2FibGUlM0Rub3QlMjBhY2NlbGVyYXRvci5pc19sb2NhbF9tYWluX3Byb2Nlc3Mp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(args.max_train_steps), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)`,wrap:!1}}),Be=new g({props:{code:"aWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBJcyUyMGV4ZWN1dGVkJTIwb25jZSUyMG9ubHk=",highlighted:`<span class="hljs-keyword">if</span> accelerator.is_main_process:
    <span class="hljs-comment"># Is executed once only</span>`,wrap:!1}}),ze=new b({props:{title:"Defer execution on multiple GPUs",local:"defer-execution-on-multiple-gpus",headingTag:"h3"}}),Ve=new g({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKQ==",highlighted:'accelerator.wait<span class="hljs-constructor">_for_everyone()</span>',wrap:!1}}),Se=new b({props:{title:"Save/load a model in a distributed setup",local:"saveload-a-model-in-a-distributed-setup",headingTag:"h3"}}),Ke=new g({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait<span class="hljs-constructor">_for_everyone()</span>
accelerator.save<span class="hljs-constructor">_model(<span class="hljs-params">model</span>, <span class="hljs-params">save_directory</span>)</span>`,wrap:!1}}),Oe=new g({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),tt=new g({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),it=new g({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),nt=new b({props:{title:"Save/load entire states",local:"saveload-entire-states",headingTag:"h3"}}),H=new vt({props:{$$slots:{default:[Ki]},$$scope:{ctx:v}}}),ct=new b({props:{title:"Use gradient clipping",local:"use-gradient-clipping",headingTag:"h3"}}),ut=new b({props:{title:"Train with mixed precision",local:"train-with-mixed-precision",headingTag:"h3"}}),ht=new g({props:{code:"d2l0aCUyMGFjY2VsZXJhdG9yLmF1dG9jYXN0KCklM0ElMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwY29tcGxleF9sb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXQpJTNB",highlighted:`<span class="hljs-keyword">with</span> accelerator.autocast<span class="hljs-literal">()</span>:
    loss = complex<span class="hljs-constructor">_loss_function(<span class="hljs-params">outputs</span>, <span class="hljs-params">target</span>)</span>:`,wrap:!1}}),yt=new g({props:{code:"aWYlMjBub3QlMjBhY2NlbGVyYXRvci5vcHRpbWl6ZXJfc3RlcF93YXNfc2tpcHBlZCUzQSUwQSUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCk=",highlighted:`<span class="hljs-keyword">if</span> not accelerator<span class="hljs-selector-class">.optimizer_step_was_skipped</span>:
    lr_scheduler<span class="hljs-selector-class">.step</span>()`,wrap:!1}}),wt=new b({props:{title:"Use gradient accumulation",local:"use-gradient-accumulation",headingTag:"h3"}}),$t=new g({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQWZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

<span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, label <span class="hljs-keyword">in</span> training_dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        predictions = model(<span class="hljs-built_in">input</span>)
        loss = loss_function(predictions, label)
        accelerator.backward(loss)
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),{c(){c=r("meta"),w=i(),p=r("p"),$=i(),u(G.$$.fragment),Tt=i(),Z=r("p"),Z.textContent=Ml,kt=i(),W=r("p"),W.textContent=Tl,xt=i(),I=r("ul"),I.innerHTML=kl,jt=i(),u(L.$$.fragment),Ct=i(),u(X.$$.fragment),Jt=i(),Y=r("p"),Y.textContent=xl,Ut=i(),A=r("ol"),A.innerHTML=jl,Ht=i(),u(P.$$.fragment),Gt=i(),B=r("p"),B.textContent=Cl,Zt=i(),_=r("ol"),_.innerHTML=Jl,Wt=i(),F=r("p"),F.innerHTML=Ul,It=i(),u(M.$$.fragment),Lt=i(),T=r("ol"),T.innerHTML=Hl,Xt=i(),u(z.$$.fragment),Yt=i(),R=r("p"),R.innerHTML=Gl,At=i(),N=r("ul"),N.innerHTML=Zl,Pt=i(),V=r("p"),V.innerHTML=Wl,Bt=i(),u(k.$$.fragment),Ft=i(),x=r("ol"),x.innerHTML=Il,zt=i(),Q=r("p"),Q.textContent=Ll,Rt=i(),u(S.$$.fragment),Nt=i(),E=r("p"),E.innerHTML=Xl,Vt=i(),q=r("p"),q.innerHTML=Yl,Qt=i(),u(K.$$.fragment),St=i(),D=r("p"),D.innerHTML=Al,Et=i(),u(O.$$.fragment),qt=i(),u(j.$$.fragment),Kt=i(),ee=r("p"),ee.innerHTML=Pl,Dt=i(),u(C.$$.fragment),Ot=i(),u(J.$$.fragment),ea=i(),u(te.$$.fragment),ta=i(),ae=r("p"),ae.innerHTML=Bl,aa=i(),le=r("p"),le.textContent=Fl,la=i(),u(ie.$$.fragment),ia=i(),ne=r("p"),ne.innerHTML=zl,na=i(),re=r("ul"),re.innerHTML=Rl,ra=i(),se=r("p"),se.innerHTML=Nl,sa=i(),u(oe.$$.fragment),oa=i(),ce=r("p"),ce.textContent=Vl,ca=i(),pe=r("p"),pe.textContent=Ql,pa=i(),u(ue.$$.fragment),ua=i(),de=r("p"),de.textContent=Sl,da=i(),u(he.$$.fragment),ha=i(),fe=r("p"),fe.textContent=El,fa=i(),u(me.$$.fragment),ma=i(),ye=r("p"),ye.innerHTML=ql,ya=i(),we=r("p"),we.innerHTML=Kl,wa=i(),u(ge.$$.fragment),ga=i(),$e=r("p"),$e.textContent=Dl,$a=i(),u(ve.$$.fragment),va=i(),be=r("p"),be.innerHTML=Ol,ba=i(),_e=r("p"),_e.textContent=ei,_a=i(),u(Me.$$.fragment),Ma=i(),u(U.$$.fragment),Ta=i(),Te=r("p"),Te.innerHTML=ti,ka=i(),u(ke.$$.fragment),xa=i(),xe=r("p"),xe.textContent=ai,ja=i(),je=r("p"),je.textContent=li,Ca=i(),Ce=r("ul"),Ce.innerHTML=ii,Ja=i(),Je=r("p"),Je.textContent=ni,Ua=i(),Ue=r("p"),Ue.innerHTML=ri,Ha=i(),u(He.$$.fragment),Ga=i(),Ge=r("p"),Ge.innerHTML=si,Za=i(),Ze=r("p"),Ze.innerHTML=oi,Wa=i(),We=r("p"),We.innerHTML=ci,Ia=i(),u(Ie.$$.fragment),La=i(),Le=r("p"),Le.textContent=pi,Xa=i(),u(Xe.$$.fragment),Ya=i(),Ye=r("p"),Ye.textContent=ui,Aa=i(),u(Ae.$$.fragment),Pa=i(),Pe=r("p"),Pe.innerHTML=di,Ba=i(),u(Be.$$.fragment),Fa=i(),Fe=r("p"),Fe.innerHTML=hi,za=i(),u(ze.$$.fragment),Ra=i(),Re=r("p"),Re.textContent=fi,Na=i(),Ne=r("p"),Ne.textContent=mi,Va=i(),u(Ve.$$.fragment),Qa=i(),Qe=r("p"),Qe.textContent=yi,Sa=i(),u(Se.$$.fragment),Ea=i(),Ee=r("p"),Ee.innerHTML=wi,qa=i(),qe=r("p"),qe.textContent=gi,Ka=i(),u(Ke.$$.fragment),Da=i(),De=r("p"),De.innerHTML=$i,Oa=i(),u(Oe.$$.fragment),el=i(),et=r("p"),et.innerHTML=vi,tl=i(),u(tt.$$.fragment),al=i(),at=r("p"),at.innerHTML=bi,ll=i(),lt=r("p"),lt.innerHTML=_i,il=i(),u(it.$$.fragment),nl=i(),u(nt.$$.fragment),rl=i(),rt=r("p"),rt.innerHTML=Mi,sl=i(),st=r("p"),st.innerHTML=Ti,ol=i(),ot=r("p"),ot.innerHTML=ki,cl=i(),u(H.$$.fragment),pl=i(),u(ct.$$.fragment),ul=i(),pt=r("p"),pt.innerHTML=xi,dl=i(),u(ut.$$.fragment),hl=i(),dt=r("p"),dt.innerHTML=ji,fl=i(),u(ht.$$.fragment),ml=i(),ft=r("p"),ft.textContent=Ci,yl=i(),mt=r("p"),mt.textContent=Ji,wl=i(),u(yt.$$.fragment),gl=i(),u(wt.$$.fragment),$l=i(),gt=r("p"),gt.innerHTML=Ui,vl=i(),u($t.$$.fragment),bl=i(),_t=r("p"),this.h()},l(e){const t=zi("svelte-u9bgzb",document.head);c=s(t,"META",{name:!0,content:!0}),t.forEach(a),w=n(e),p=s(e,"P",{}),Yi(p).forEach(a),$=n(e),d(G.$$.fragment,e),Tt=n(e),Z=s(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-oc9w4c"&&(Z.textContent=Ml),kt=n(e),W=s(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1sg1hfv"&&(W.textContent=Tl),xt=n(e),I=s(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-z17he1"&&(I.innerHTML=kl),jt=n(e),d(L.$$.fragment,e),Ct=n(e),d(X.$$.fragment,e),Jt=n(e),Y=s(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-2h19j8"&&(Y.textContent=xl),Ut=n(e),A=s(e,"OL",{"data-svelte-h":!0}),o(A)!=="svelte-w44z1f"&&(A.innerHTML=jl),Ht=n(e),d(P.$$.fragment,e),Gt=n(e),B=s(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-nozefw"&&(B.textContent=Cl),Zt=n(e),_=s(e,"OL",{start:!0,"data-svelte-h":!0}),o(_)!=="svelte-1ftiz91"&&(_.innerHTML=Jl),Wt=n(e),F=s(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-16q8m2v"&&(F.innerHTML=Ul),It=n(e),d(M.$$.fragment,e),Lt=n(e),T=s(e,"OL",{start:!0,"data-svelte-h":!0}),o(T)!=="svelte-1yl79bt"&&(T.innerHTML=Hl),Xt=n(e),d(z.$$.fragment,e),Yt=n(e),R=s(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-zb4o2w"&&(R.innerHTML=Gl),At=n(e),N=s(e,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-1uacfa4"&&(N.innerHTML=Zl),Pt=n(e),V=s(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-laf7gh"&&(V.innerHTML=Wl),Bt=n(e),d(k.$$.fragment,e),Ft=n(e),x=s(e,"OL",{start:!0,"data-svelte-h":!0}),o(x)!=="svelte-uh7wta"&&(x.innerHTML=Il),zt=n(e),Q=s(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-igf2oo"&&(Q.textContent=Ll),Rt=n(e),d(S.$$.fragment,e),Nt=n(e),E=s(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-low9ab"&&(E.innerHTML=Xl),Vt=n(e),q=s(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-p76kdr"&&(q.innerHTML=Yl),Qt=n(e),d(K.$$.fragment,e),St=n(e),D=s(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-4ju6vc"&&(D.innerHTML=Al),Et=n(e),d(O.$$.fragment,e),qt=n(e),d(j.$$.fragment,e),Kt=n(e),ee=s(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1gqlp4r"&&(ee.innerHTML=Pl),Dt=n(e),d(C.$$.fragment,e),Ot=n(e),d(J.$$.fragment,e),ea=n(e),d(te.$$.fragment,e),ta=n(e),ae=s(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-tmtyy1"&&(ae.innerHTML=Bl),aa=n(e),le=s(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-2drm4e"&&(le.textContent=Fl),la=n(e),d(ie.$$.fragment,e),ia=n(e),ne=s(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1txoioi"&&(ne.innerHTML=zl),na=n(e),re=s(e,"UL",{"data-svelte-h":!0}),o(re)!=="svelte-hk4m7k"&&(re.innerHTML=Rl),ra=n(e),se=s(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-16l3mwt"&&(se.innerHTML=Nl),sa=n(e),d(oe.$$.fragment,e),oa=n(e),ce=s(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1o2a0hz"&&(ce.textContent=Vl),ca=n(e),pe=s(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1o7ixq"&&(pe.textContent=Ql),pa=n(e),d(ue.$$.fragment,e),ua=n(e),de=s(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-kxbaqm"&&(de.textContent=Sl),da=n(e),d(he.$$.fragment,e),ha=n(e),fe=s(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1nbx9yy"&&(fe.textContent=El),fa=n(e),d(me.$$.fragment,e),ma=n(e),ye=s(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-zvrh0"&&(ye.innerHTML=ql),ya=n(e),we=s(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-cj893u"&&(we.innerHTML=Kl),wa=n(e),d(ge.$$.fragment,e),ga=n(e),$e=s(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1dvct28"&&($e.textContent=Dl),$a=n(e),d(ve.$$.fragment,e),va=n(e),be=s(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1q06dq0"&&(be.innerHTML=Ol),ba=n(e),_e=s(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1wn7b8l"&&(_e.textContent=ei),_a=n(e),d(Me.$$.fragment,e),Ma=n(e),d(U.$$.fragment,e),Ta=n(e),Te=s(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1mfzcq9"&&(Te.innerHTML=ti),ka=n(e),d(ke.$$.fragment,e),xa=n(e),xe=s(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-h21474"&&(xe.textContent=ai),ja=n(e),je=s(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1rbvxgu"&&(je.textContent=li),Ca=n(e),Ce=s(e,"UL",{"data-svelte-h":!0}),o(Ce)!=="svelte-e058gf"&&(Ce.innerHTML=ii),Ja=n(e),Je=s(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-53sswp"&&(Je.textContent=ni),Ua=n(e),Ue=s(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-112h0ku"&&(Ue.innerHTML=ri),Ha=n(e),d(He.$$.fragment,e),Ga=n(e),Ge=s(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1e3m3tk"&&(Ge.innerHTML=si),Za=n(e),Ze=s(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1avgohl"&&(Ze.innerHTML=oi),Wa=n(e),We=s(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1um6ng8"&&(We.innerHTML=ci),Ia=n(e),d(Ie.$$.fragment,e),La=n(e),Le=s(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1n4l910"&&(Le.textContent=pi),Xa=n(e),d(Xe.$$.fragment,e),Ya=n(e),Ye=s(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-d3cka2"&&(Ye.textContent=ui),Aa=n(e),d(Ae.$$.fragment,e),Pa=n(e),Pe=s(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1ml4zpq"&&(Pe.innerHTML=di),Ba=n(e),d(Be.$$.fragment,e),Fa=n(e),Fe=s(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-vyt8ov"&&(Fe.innerHTML=hi),za=n(e),d(ze.$$.fragment,e),Ra=n(e),Re=s(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-ddezg0"&&(Re.textContent=fi),Na=n(e),Ne=s(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1jnuerz"&&(Ne.textContent=mi),Va=n(e),d(Ve.$$.fragment,e),Qa=n(e),Qe=s(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-19k5yf4"&&(Qe.textContent=yi),Sa=n(e),d(Se.$$.fragment,e),Ea=n(e),Ee=s(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1i9czz5"&&(Ee.innerHTML=wi),qa=n(e),qe=s(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1240csr"&&(qe.textContent=gi),Ka=n(e),d(Ke.$$.fragment,e),Da=n(e),De=s(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-r0d7es"&&(De.innerHTML=$i),Oa=n(e),d(Oe.$$.fragment,e),el=n(e),et=s(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-197gaxc"&&(et.innerHTML=vi),tl=n(e),d(tt.$$.fragment,e),al=n(e),at=s(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1ykt3mj"&&(at.innerHTML=bi),ll=n(e),lt=s(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1buhzoq"&&(lt.innerHTML=_i),il=n(e),d(it.$$.fragment,e),nl=n(e),d(nt.$$.fragment,e),rl=n(e),rt=s(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1agsig8"&&(rt.innerHTML=Mi),sl=n(e),st=s(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-122r2u4"&&(st.innerHTML=Ti),ol=n(e),ot=s(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-e9jzea"&&(ot.innerHTML=ki),cl=n(e),d(H.$$.fragment,e),pl=n(e),d(ct.$$.fragment,e),ul=n(e),pt=s(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1f9yb1i"&&(pt.innerHTML=xi),dl=n(e),d(ut.$$.fragment,e),hl=n(e),dt=s(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-9kf75j"&&(dt.innerHTML=ji),fl=n(e),d(ht.$$.fragment,e),ml=n(e),ft=s(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1h1yjak"&&(ft.textContent=Ci),yl=n(e),mt=s(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-sn60sz"&&(mt.textContent=Ji),wl=n(e),d(yt.$$.fragment,e),gl=n(e),d(wt.$$.fragment,e),$l=n(e),gt=s(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1i7ph64"&&(gt.innerHTML=Ui),vl=n(e),d($t.$$.fragment,e),bl=n(e),_t=s(e,"P",{}),Yi(_t).forEach(a),this.h()},h(){Mt(c,"name","hf:doc:metadata"),Mt(c,"content",Oi),Mt(_,"start","2"),Mt(T,"start","3"),Mt(x,"start","4")},m(e,t){Ri(document.head,c),l(e,w,t),l(e,p,t),l(e,$,t),h(G,e,t),l(e,Tt,t),l(e,Z,t),l(e,kt,t),l(e,W,t),l(e,xt,t),l(e,I,t),l(e,jt,t),h(L,e,t),l(e,Ct,t),h(X,e,t),l(e,Jt,t),l(e,Y,t),l(e,Ut,t),l(e,A,t),l(e,Ht,t),h(P,e,t),l(e,Gt,t),l(e,B,t),l(e,Zt,t),l(e,_,t),l(e,Wt,t),l(e,F,t),l(e,It,t),h(M,e,t),l(e,Lt,t),l(e,T,t),l(e,Xt,t),h(z,e,t),l(e,Yt,t),l(e,R,t),l(e,At,t),l(e,N,t),l(e,Pt,t),l(e,V,t),l(e,Bt,t),h(k,e,t),l(e,Ft,t),l(e,x,t),l(e,zt,t),l(e,Q,t),l(e,Rt,t),h(S,e,t),l(e,Nt,t),l(e,E,t),l(e,Vt,t),l(e,q,t),l(e,Qt,t),h(K,e,t),l(e,St,t),l(e,D,t),l(e,Et,t),h(O,e,t),l(e,qt,t),h(j,e,t),l(e,Kt,t),l(e,ee,t),l(e,Dt,t),h(C,e,t),l(e,Ot,t),h(J,e,t),l(e,ea,t),h(te,e,t),l(e,ta,t),l(e,ae,t),l(e,aa,t),l(e,le,t),l(e,la,t),h(ie,e,t),l(e,ia,t),l(e,ne,t),l(e,na,t),l(e,re,t),l(e,ra,t),l(e,se,t),l(e,sa,t),h(oe,e,t),l(e,oa,t),l(e,ce,t),l(e,ca,t),l(e,pe,t),l(e,pa,t),h(ue,e,t),l(e,ua,t),l(e,de,t),l(e,da,t),h(he,e,t),l(e,ha,t),l(e,fe,t),l(e,fa,t),h(me,e,t),l(e,ma,t),l(e,ye,t),l(e,ya,t),l(e,we,t),l(e,wa,t),h(ge,e,t),l(e,ga,t),l(e,$e,t),l(e,$a,t),h(ve,e,t),l(e,va,t),l(e,be,t),l(e,ba,t),l(e,_e,t),l(e,_a,t),h(Me,e,t),l(e,Ma,t),h(U,e,t),l(e,Ta,t),l(e,Te,t),l(e,ka,t),h(ke,e,t),l(e,xa,t),l(e,xe,t),l(e,ja,t),l(e,je,t),l(e,Ca,t),l(e,Ce,t),l(e,Ja,t),l(e,Je,t),l(e,Ua,t),l(e,Ue,t),l(e,Ha,t),h(He,e,t),l(e,Ga,t),l(e,Ge,t),l(e,Za,t),l(e,Ze,t),l(e,Wa,t),l(e,We,t),l(e,Ia,t),h(Ie,e,t),l(e,La,t),l(e,Le,t),l(e,Xa,t),h(Xe,e,t),l(e,Ya,t),l(e,Ye,t),l(e,Aa,t),h(Ae,e,t),l(e,Pa,t),l(e,Pe,t),l(e,Ba,t),h(Be,e,t),l(e,Fa,t),l(e,Fe,t),l(e,za,t),h(ze,e,t),l(e,Ra,t),l(e,Re,t),l(e,Na,t),l(e,Ne,t),l(e,Va,t),h(Ve,e,t),l(e,Qa,t),l(e,Qe,t),l(e,Sa,t),h(Se,e,t),l(e,Ea,t),l(e,Ee,t),l(e,qa,t),l(e,qe,t),l(e,Ka,t),h(Ke,e,t),l(e,Da,t),l(e,De,t),l(e,Oa,t),h(Oe,e,t),l(e,el,t),l(e,et,t),l(e,tl,t),h(tt,e,t),l(e,al,t),l(e,at,t),l(e,ll,t),l(e,lt,t),l(e,il,t),h(it,e,t),l(e,nl,t),h(nt,e,t),l(e,rl,t),l(e,rt,t),l(e,sl,t),l(e,st,t),l(e,ol,t),l(e,ot,t),l(e,cl,t),h(H,e,t),l(e,pl,t),h(ct,e,t),l(e,ul,t),l(e,pt,t),l(e,dl,t),h(ut,e,t),l(e,hl,t),l(e,dt,t),l(e,fl,t),h(ht,e,t),l(e,ml,t),l(e,ft,t),l(e,yl,t),l(e,mt,t),l(e,wl,t),h(yt,e,t),l(e,gl,t),h(wt,e,t),l(e,$l,t),l(e,gt,t),l(e,vl,t),h($t,e,t),l(e,bl,t),l(e,_t,t),_l=!0},p(e,[t]){const Hi={};t&2&&(Hi.$$scope={dirty:t,ctx:e}),M.$set(Hi);const Gi={};t&2&&(Gi.$$scope={dirty:t,ctx:e}),k.$set(Gi);const Zi={};t&2&&(Zi.$$scope={dirty:t,ctx:e}),j.$set(Zi);const Wi={};t&2&&(Wi.$$scope={dirty:t,ctx:e}),C.$set(Wi);const Ii={};t&2&&(Ii.$$scope={dirty:t,ctx:e}),J.$set(Ii);const Li={};t&2&&(Li.$$scope={dirty:t,ctx:e}),U.$set(Li);const Xi={};t&2&&(Xi.$$scope={dirty:t,ctx:e}),H.$set(Xi)},i(e){_l||(f(G.$$.fragment,e),f(L.$$.fragment,e),f(X.$$.fragment,e),f(P.$$.fragment,e),f(M.$$.fragment,e),f(z.$$.fragment,e),f(k.$$.fragment,e),f(S.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(j.$$.fragment,e),f(C.$$.fragment,e),f(J.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(ve.$$.fragment,e),f(Me.$$.fragment,e),f(U.$$.fragment,e),f(ke.$$.fragment,e),f(He.$$.fragment,e),f(Ie.$$.fragment,e),f(Xe.$$.fragment,e),f(Ae.$$.fragment,e),f(Be.$$.fragment,e),f(ze.$$.fragment,e),f(Ve.$$.fragment,e),f(Se.$$.fragment,e),f(Ke.$$.fragment,e),f(Oe.$$.fragment,e),f(tt.$$.fragment,e),f(it.$$.fragment,e),f(nt.$$.fragment,e),f(H.$$.fragment,e),f(ct.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(yt.$$.fragment,e),f(wt.$$.fragment,e),f($t.$$.fragment,e),_l=!0)},o(e){m(G.$$.fragment,e),m(L.$$.fragment,e),m(X.$$.fragment,e),m(P.$$.fragment,e),m(M.$$.fragment,e),m(z.$$.fragment,e),m(k.$$.fragment,e),m(S.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(J.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(Me.$$.fragment,e),m(U.$$.fragment,e),m(ke.$$.fragment,e),m(He.$$.fragment,e),m(Ie.$$.fragment,e),m(Xe.$$.fragment,e),m(Ae.$$.fragment,e),m(Be.$$.fragment,e),m(ze.$$.fragment,e),m(Ve.$$.fragment,e),m(Se.$$.fragment,e),m(Ke.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(nt.$$.fragment,e),m(H.$$.fragment,e),m(ct.$$.fragment,e),m(ut.$$.fragment,e),m(ht.$$.fragment,e),m(yt.$$.fragment,e),m(wt.$$.fragment,e),m($t.$$.fragment,e),_l=!1},d(e){e&&(a(w),a(p),a($),a(Tt),a(Z),a(kt),a(W),a(xt),a(I),a(jt),a(Ct),a(Jt),a(Y),a(Ut),a(A),a(Ht),a(Gt),a(B),a(Zt),a(_),a(Wt),a(F),a(It),a(Lt),a(T),a(Xt),a(Yt),a(R),a(At),a(N),a(Pt),a(V),a(Bt),a(Ft),a(x),a(zt),a(Q),a(Rt),a(Nt),a(E),a(Vt),a(q),a(Qt),a(St),a(D),a(Et),a(qt),a(Kt),a(ee),a(Dt),a(Ot),a(ea),a(ta),a(ae),a(aa),a(le),a(la),a(ia),a(ne),a(na),a(re),a(ra),a(se),a(sa),a(oa),a(ce),a(ca),a(pe),a(pa),a(ua),a(de),a(da),a(ha),a(fe),a(fa),a(ma),a(ye),a(ya),a(we),a(wa),a(ga),a($e),a($a),a(va),a(be),a(ba),a(_e),a(_a),a(Ma),a(Ta),a(Te),a(ka),a(xa),a(xe),a(ja),a(je),a(Ca),a(Ce),a(Ja),a(Je),a(Ua),a(Ue),a(Ha),a(Ga),a(Ge),a(Za),a(Ze),a(Wa),a(We),a(Ia),a(La),a(Le),a(Xa),a(Ya),a(Ye),a(Aa),a(Pa),a(Pe),a(Ba),a(Fa),a(Fe),a(za),a(Ra),a(Re),a(Na),a(Ne),a(Va),a(Qa),a(Qe),a(Sa),a(Ea),a(Ee),a(qa),a(qe),a(Ka),a(Da),a(De),a(Oa),a(el),a(et),a(tl),a(al),a(at),a(ll),a(lt),a(il),a(nl),a(rl),a(rt),a(sl),a(st),a(ol),a(ot),a(cl),a(pl),a(ul),a(pt),a(dl),a(hl),a(dt),a(fl),a(ml),a(ft),a(yl),a(mt),a(wl),a(gl),a($l),a(gt),a(vl),a(bl),a(_t)),a(c),y(G,e),y(L,e),y(X,e),y(P,e),y(M,e),y(z,e),y(k,e),y(S,e),y(K,e),y(O,e),y(j,e),y(C,e),y(J,e),y(te,e),y(ie,e),y(oe,e),y(ue,e),y(he,e),y(me,e),y(ge,e),y(ve,e),y(Me,e),y(U,e),y(ke,e),y(He,e),y(Ie,e),y(Xe,e),y(Ae,e),y(Be,e),y(ze,e),y(Ve,e),y(Se,e),y(Ke,e),y(Oe,e),y(tt,e),y(it,e),y(nt,e),y(H,e),y(ct,e),y(ut,e),y(ht,e),y(yt,e),y(wt,e),y($t,e)}}}const Oi='{"title":"Quick tour","local":"quick-tour","sections":[{"title":"Getting started with 🤗 Accelerate","local":"getting-started-with--accelerate","sections":[{"title":"Enable distributed training in your script","local":"enable-distributed-training-in-your-script","sections":[],"depth":3},{"title":"Add distributed evaluation","local":"add-distributed-evaluation","sections":[],"depth":3},{"title":"Launch your distributed script","local":"launch-your-distributed-script","sections":[],"depth":3}],"depth":2},{"title":"Common modifications of the base case","local":"common-modifications-of-the-base-case","sections":[{"title":"Launch distributed training from a notebook","local":"launch-distributed-training-from-a-notebook","sections":[],"depth":3},{"title":"Specifics of training on TPU","local":"specifics-of-training-on-tpu","sections":[],"depth":3},{"title":"Execute a statement only on one processes","local":"execute-a-statement-only-on-one-processes","sections":[],"depth":3},{"title":"Defer execution on multiple GPUs","local":"defer-execution-on-multiple-gpus","sections":[],"depth":3},{"title":"Save/load a model in a distributed setup","local":"saveload-a-model-in-a-distributed-setup","sections":[],"depth":3},{"title":"Save/load entire states","local":"saveload-entire-states","sections":[],"depth":3},{"title":"Use gradient clipping","local":"use-gradient-clipping","sections":[],"depth":3},{"title":"Train with mixed precision","local":"train-with-mixed-precision","sections":[],"depth":3},{"title":"Use gradient accumulation","local":"use-gradient-accumulation","sections":[],"depth":3}],"depth":2}],"depth":1}';function en(v){return Pi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sn extends Bi{constructor(c){super(),Fi(this,c,en,Di,Ai,{})}}export{sn as component};
