import{s as ge,n as ye,o as je}from"../chunks/scheduler.85c25b89.js";import{S as we,i as fe,g as a,s as o,u as c,A as Je,h as n,f as e,c as p,j as h,v as M,y as m,k as i,o as r,a as l,w as d,d as u,t as g,x as y}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function be(Yt){let j,ht,st,mt,w,v,lt,Z,Qt,q,Ht="NASNet",ct,$,zt="<strong>NASNet</strong> is a type of convolutional neural network discovered through neural architecture search. The building blocks consist of normal and reduction cells.",Mt,f,U,at,N,St,D,Ft="How do I use this model on an image?",dt,I,Pt="To load a pretrained model:",ut,E,gt,W,Lt="To load and preprocess the image:",yt,A,jt,_,qt="To get the model predictions:",wt,G,ft,B,Dt="To get the top-5 predictions class names:",Jt,Q,bt,S,Kt="Replace the model name with the variant you want to use, e.g. <code>nasnetalarge</code>. You can find the IDs in the model summaries at the top of this page.",Tt,X,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,J,C,nt,V,Xt,K,te="How do I finetune this model?",Ut,R,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,Y,kt,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xt,b,k,ot,z,Vt,O,le="How do I train this model?",Zt,F,ae='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,T,x,pt,P,Rt,tt,ne="Citation",Nt,L,It,it,Et;return Z=new rt({}),N=new rt({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ25hc25ldGFsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),A=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),Y=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbmFzbmV0YWxhcmdlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QnpvcGgyMDE4bGVhcm5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkxlYXJuaW5nJTIwVHJhbnNmZXJhYmxlJTIwQXJjaGl0ZWN0dXJlcyUyMGZvciUyMFNjYWxhYmxlJTIwSW1hZ2UlMjBSZWNvZ25pdGlvbiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkJhcnJldCUyMFpvcGglMjBhbmQlMjBWaWpheSUyMFZhc3VkZXZhbiUyMGFuZCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDcwMTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{zoph2018learning,
      title={Learning Transferable Architectures for <span class="hljs-keyword">Scalable </span>Image Recognition}, 
      author={<span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">07012</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){j=a("meta"),ht=o(),st=a("p"),mt=o(),w=a("h1"),v=a("a"),lt=a("span"),c(Z.$$.fragment),Qt=o(),q=a("span"),q.textContent=Ht,ct=o(),$=a("p"),$.innerHTML=zt,Mt=o(),f=a("h2"),U=a("a"),at=a("span"),c(N.$$.fragment),St=o(),D=a("span"),D.textContent=Ft,dt=o(),I=a("p"),I.textContent=Pt,ut=o(),c(E.$$.fragment),gt=o(),W=a("p"),W.textContent=Lt,yt=o(),c(A.$$.fragment),jt=o(),_=a("p"),_.textContent=qt,wt=o(),c(G.$$.fragment),ft=o(),B=a("p"),B.textContent=Dt,Jt=o(),c(Q.$$.fragment),bt=o(),S=a("p"),S.innerHTML=Kt,Tt=o(),X=a("p"),X.innerHTML=Ot,vt=o(),J=a("h2"),C=a("a"),nt=a("span"),c(V.$$.fragment),Xt=o(),K=a("span"),K.textContent=te,Ut=o(),R=a("p"),R.textContent=ee,Ct=o(),c(Y.$$.fragment),kt=o(),H=a("p"),H.innerHTML=se,xt=o(),b=a("h2"),k=a("a"),ot=a("span"),c(z.$$.fragment),Vt=o(),O=a("span"),O.textContent=le,Zt=o(),F=a("p"),F.innerHTML=ae,$t=o(),T=a("h2"),x=a("a"),pt=a("span"),c(P.$$.fragment),Rt=o(),tt=a("span"),tt.textContent=ne,Nt=o(),c(L.$$.fragment),It=o(),it=a("p"),this.h()},l(t){const s=Je("svelte-1phssyn",document.head);j=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),w=n(t,"H1",{class:!0});var Wt=h(w);v=n(Wt,"A",{id:!0,class:!0,href:!0});var oe=h(v);lt=n(oe,"SPAN",{});var pe=h(lt);M(Z.$$.fragment,pe),pe.forEach(e),oe.forEach(e),Qt=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-od229m"&&(q.textContent=Ht),Wt.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1u56z5m"&&($.innerHTML=zt),Mt=p(t),f=n(t,"H2",{class:!0});var At=h(f);U=n(At,"A",{id:!0,class:!0,href:!0});var ie=h(U);at=n(ie,"SPAN",{});var re=h(at);M(N.$$.fragment,re),re.forEach(e),ie.forEach(e),St=p(At),D=n(At,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=Ft),At.forEach(e),dt=p(t),I=n(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-18ywhxh"&&(I.textContent=Pt),ut=p(t),M(E.$$.fragment,t),gt=p(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Lt),yt=p(t),M(A.$$.fragment,t),jt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=qt),wt=p(t),M(G.$$.fragment,t),ft=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-19cnvx1"&&(B.textContent=Dt),Jt=p(t),M(Q.$$.fragment,t),bt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-qu63rt"&&(S.innerHTML=Kt),Tt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1wmi3ea"&&(X.innerHTML=Ot),vt=p(t),J=n(t,"H2",{class:!0});var _t=h(J);C=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);M(V.$$.fragment,me),me.forEach(e),he.forEach(e),Xt=p(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),Ut=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-9sr7nh"&&(R.textContent=ee),Ct=p(t),M(Y.$$.fragment,t),kt=p(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),xt=p(t),b=n(t,"H2",{class:!0});var Gt=h(b);k=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(k);ot=n(ce,"SPAN",{});var Me=h(ot);M(z.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Vt=p(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=le),Gt.forEach(e),Zt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=ae),$t=p(t),T=n(t,"H2",{class:!0});var Bt=h(T);x=n(Bt,"A",{id:!0,class:!0,href:!0});var de=h(x);pt=n(de,"SPAN",{});var ue=h(pt);M(P.$$.fragment,ue),ue.forEach(e),de.forEach(e),Rt=p(Bt),tt=n(Bt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Bt.forEach(e),Nt=p(t),M(L.$$.fragment,t),It=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(j,"name","hf:doc:metadata"),i(j,"content",JSON.stringify(Te)),i(v,"id","nasnet"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#nasnet"),i(w,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(f,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(J,"class","relative group"),i(k,"id","how-do-i-train-this-model"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#how-do-i-train-this-model"),i(b,"class","relative group"),i(x,"id","citation"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#citation"),i(T,"class","relative group")},m(t,s){r(document.head,j),l(t,ht,s),l(t,st,s),l(t,mt,s),l(t,w,s),r(w,v),r(v,lt),d(Z,lt,null),r(w,Qt),r(w,q),l(t,ct,s),l(t,$,s),l(t,Mt,s),l(t,f,s),r(f,U),r(U,at),d(N,at,null),r(f,St),r(f,D),l(t,dt,s),l(t,I,s),l(t,ut,s),d(E,t,s),l(t,gt,s),l(t,W,s),l(t,yt,s),d(A,t,s),l(t,jt,s),l(t,_,s),l(t,wt,s),d(G,t,s),l(t,ft,s),l(t,B,s),l(t,Jt,s),d(Q,t,s),l(t,bt,s),l(t,S,s),l(t,Tt,s),l(t,X,s),l(t,vt,s),l(t,J,s),r(J,C),r(C,nt),d(V,nt,null),r(J,Xt),r(J,K),l(t,Ut,s),l(t,R,s),l(t,Ct,s),d(Y,t,s),l(t,kt,s),l(t,H,s),l(t,xt,s),l(t,b,s),r(b,k),r(k,ot),d(z,ot,null),r(b,Vt),r(b,O),l(t,Zt,s),l(t,F,s),l(t,$t,s),l(t,T,s),r(T,x),r(x,pt),d(P,pt,null),r(T,Rt),r(T,tt),l(t,Nt,s),d(L,t,s),l(t,It,s),l(t,it,s),Et=!0},p:ye,i(t){Et||(u(Z.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),u(A.$$.fragment,t),u(G.$$.fragment,t),u(Q.$$.fragment,t),u(V.$$.fragment,t),u(Y.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Et=!0)},o(t){g(Z.$$.fragment,t),g(N.$$.fragment,t),g(E.$$.fragment,t),g(A.$$.fragment,t),g(G.$$.fragment,t),g(Q.$$.fragment,t),g(V.$$.fragment,t),g(Y.$$.fragment,t),g(z.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(st),e(mt),e(w),e(ct),e($),e(Mt),e(f),e(dt),e(I),e(ut),e(gt),e(W),e(yt),e(jt),e(_),e(wt),e(ft),e(B),e(Jt),e(bt),e(S),e(Tt),e(X),e(vt),e(J),e(Ut),e(R),e(Ct),e(kt),e(H),e(xt),e(b),e(Zt),e(F),e($t),e(T),e(Nt),e(It),e(it)),e(j),y(Z),y(N),y(E,t),y(A,t),y(G,t),y(Q,t),y(V),y(Y,t),y(z),y(P),y(L,t)}}}const Te={local:"nasnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"NASNet"};function ve(Yt){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends we{constructor(j){super(),fe(this,j,ve,be,ge,{})}}export{Ze as component};
