import{s as hn,o as un,n as Z}from"../chunks/scheduler.9bc65507.js";import{S as _n,i as bn,g as p,s as o,r as f,A as yn,h as m,f as a,c as r,j as C,u as h,x as g,k as F,y as d,a as c,v as u,d as _,t as b,w as y}from"../chunks/index.707bf1b6.js";import{T as _t}from"../chunks/Tip.c2ecdbf4.js";import{D as U}from"../chunks/Docstring.17db21ae.js";import{C as qe}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ye}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as wn}from"../chunks/PipelineTag.44585822.js";import{H as D}from"../chunks/Heading.342b1fa6.js";function Mn($){let t,w="Example:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlZ05ldENvbmZpZyUyQyUyMFJlZ05ldE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFJlZ05ldCUyMHJlZ25ldC15LTQwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFJlZ05ldENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHJlZ25ldC15LTQwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBSZWdOZXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RegNetConfig, RegNetModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a RegNet regnet-y-40 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = RegNetConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the regnet-y-40 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RegNetModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function Tn($){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,i){c(l,t,i)},p:Z,d(l){l&&a(t)}}}function $n($){let t,w="Example:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJlZ05ldE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlZ05ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, RegNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RegNetModel.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1088</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function vn($){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,i){c(l,t,i)},p:Z,d(l){l&&a(t)}}}function xn($){let t,w="Example:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJlZ05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQW1vZGVsJTIwJTNEJTIwUmVnTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZyZWduZXQteS0wNDAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, RegNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RegNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function jn($){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,i){c(l,t,i)},p:Z,d(l){l&&a(t)}}}function Nn($){let t,w="Example:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGUmVnTmV0TW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGUmVnTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFRegNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFRegNetModel.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1088</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function Cn($){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,i){c(l,t,i)},p:Z,d(l){l&&a(t)}}}function Fn($){let t,w="Example:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGUmVnTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZyZWduZXQteS0wNDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlJlZ05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFRegNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFRegNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function Rn($){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,i){c(l,t,i)},p:Z,d(l){l&&a(t)}}}function Jn($){let t,w="Examples:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhSZWdOZXRNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZyZWduZXQteS0wNDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4UmVnTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxRegNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxRegNetModel.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function Un($){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,i){c(l,t,i)},p:Z,d(l){l&&a(t)}}}function Zn($){let t,w="Example:",l,i,M;return i=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhSZWdOZXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhSZWdOZXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfY2xhc3NfaWR4JTIwJTNEJTIwamF4Lm51bXB5LmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBcHJpbnQoJTIyUHJlZGljdGVkJTIwY2xhc3MlM0ElMjIlMkMlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWR4Lml0ZW0oKSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxRegNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxRegNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = jax.numpy.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx.item()])`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=o(),f(i.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),h(i.$$.fragment,s)},m(s,T){c(s,t,T),c(s,l,T),u(i,s,T),M=!0},p:Z,i(s){M||(_(i.$$.fragment,s),M=!0)},o(s){b(i.$$.fragment,s),M=!1},d(s){s&&(a(t),a(l)),y(i,s)}}}function In($){let t,w,l,i,M,s,T,yt,fe,Ws='The RegNet model was proposed in <a href="https://arxiv.org/abs/2003.13678" rel="nofollow">Designing Network Design Spaces</a> by Ilija Radosavovic, Raj Prateek Kosaraju, Ross Girshick, Kaiming He, Piotr Dollár.',wt,he,ks="The authors design search spaces to perform Neural Architecture Search (NAS). They first start from a high dimensional search space and iteratively reduce the search space by empirically applying constraints based on the best-performing models sampled by the current search space.",Mt,ue,Gs="The abstract from the paper is the following:",Tt,_e,Bs="<em>In this work, we present a new network design paradigm. Our goal is to help advance the understanding of network design and discover design principles that generalize across settings. Instead of focusing on designing individual network instances, we design network design spaces that parametrize populations of networks. The overall process is analogous to classic manual design of networks, but elevated to the design space level. Using our methodology we explore the structure aspect of network design and arrive at a low-dimensional design space consisting of simple, regular networks that we call RegNet. The core insight of the RegNet parametrization is surprisingly simple: widths and depths of good networks can be explained by a quantized linear function. We analyze the RegNet design space and arrive at interesting findings that do not match the current practice of network design. The RegNet design space provides simple and fast networks that work well across a wide range of flop regimes. Under comparable training settings and flops, the RegNet models outperform the popular EfficientNet models while being up to 5x faster on GPUs.</em>",$t,be,zs="Tips:",vt,ye,Vs='<li>One can use <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images for the model.</li> <li>The huge 10B model from <a href="https://arxiv.org/abs/2103.01988" rel="nofollow">Self-supervised Pretraining of Visual Features in the Wild</a>, trained on one billion Instagram images, is available on the <a href="https://huggingface.co/facebook/regnet-y-10b-seer" rel="nofollow">hub</a></li>',xt,we,Hs=`This model was contributed by <a href="https://huggingface.co/Francesco" rel="nofollow">Francesco</a>. The TensorFlow version of the model
was contributed by <a href="https://huggingface.com/sayakpaul" rel="nofollow">sayakpaul</a> and <a href="https://huggingface.com/ariG23498" rel="nofollow">ariG23498</a>.
The original code can be found <a href="https://github.com/facebookresearch/pycls" rel="nofollow">here</a>.`,jt,Me,Nt,Te,Ps="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with RegNet.",Ct,$e,Ft,ve,Es='<li><a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Rt,xe,Ls="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Jt,je,Ut,R,Ne,qt,Qe,Xs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a>. It is used to instantiate a RegNet
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the RegNet
<a href="https://huggingface.co/facebook/regnet-y-040" rel="nofollow">facebook/regnet-y-040</a> architecture.`,Qt,Se,Ys=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,St,te,Zt,Ce,It,V,Fe,At,Ae,qs=`The bare RegNet model outputting raw features without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Dt,I,Re,Ot,De,Qs='The <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> forward method, overrides the <code>__call__</code> special method.',Kt,se,es,ne,Wt,Je,kt,J,Ue,ts,Oe,Ss=`RegNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,ss,Ke,As=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ns,W,Ze,as,et,Ds='The <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',os,ae,rs,oe,Gt,Ie,Bt,H,We,ls,tt,Os="The bare RegNet model outputting raw features without any specific head on top.",is,k,ke,ds,st,Ks='The <a href="/docs/transformers/main/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> forward method, overrides the <code>__call__</code> special method.',cs,re,ps,le,zt,Ge,Vt,P,Be,ms,nt,en=`RegNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,gs,G,ze,fs,at,tn='The <a href="/docs/transformers/main/en/model_doc/regnet#transformers.TFRegNetForImageClassification">TFRegNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',hs,ie,us,de,Ht,Ve,Pt,v,He,_s,ot,sn="The bare RegNet model outputting raw features without any specific head on top.",bs,rt,nn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,ys,lt,an=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,ws,it,on="Finally, this model supports inherent JAX features such as:",Ms,dt,rn='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ts,B,Pe,$s,ct,ln="The <code>FlaxRegNetPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",vs,ce,xs,pe,Et,Ee,Lt,x,Le,js,pt,dn=`RegNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,Ns,mt,cn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Cs,gt,pn=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Fs,ft,mn="Finally, this model supports inherent JAX features such as:",Rs,ht,gn='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Js,z,Xe,Us,ut,fn="The <code>FlaxRegNetPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Zs,me,Is,ge,Xt,bt,Yt;return M=new D({props:{title:"RegNet",local:"regnet",headingTag:"h1"}}),T=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Me=new D({props:{title:"Resources",local:"resources",headingTag:"h2"}}),$e=new wn({props:{pipeline:"image-classification"}}),je=new D({props:{title:"RegNetConfig",local:"transformers.RegNetConfig",headingTag:"h2"}}),Ne=new U({props:{name:"class transformers.RegNetConfig",anchor:"transformers.RegNetConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"embedding_size",val:" = 32"},{name:"hidden_sizes",val:" = [128, 192, 512, 1088]"},{name:"depths",val:" = [2, 6, 12, 2]"},{name:"groups_width",val:" = 64"},{name:"layer_type",val:" = 'y'"},{name:"hidden_act",val:" = 'relu'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RegNetConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.RegNetConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality (hidden size) for the embedding layer.`,name:"embedding_size"},{anchor:"transformers.RegNetConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 512, 1024, 2048]</code>) &#x2014;
Dimensionality (hidden size) at each stage.`,name:"hidden_sizes"},{anchor:"transformers.RegNetConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 4, 6, 3]</code>) &#x2014;
Depth (number of layers) for each stage.`,name:"depths"},{anchor:"transformers.RegNetConfig.layer_type",description:`<strong>layer_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;y&quot;</code>) &#x2014;
The layer to use, it can be either <code>&quot;x&quot; or </code>&#x201C;y&#x201D;<code>. An </code>x<code>layer is a ResNet&apos;s BottleNeck layer with</code>reduction<code>fixed to</code>1<code>. While a </code>y<code>layer is a</code>x\` but with squeeze and excitation. Please refer to the
paper for a detailed explanation of how these layers were constructed.`,name:"layer_type"},{anchor:"transformers.RegNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code>
are supported.`,name:"hidden_act"},{anchor:"transformers.RegNetConfig.downsample_in_first_stage",description:`<strong>downsample_in_first_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the first stage will downsample the inputs using a <code>stride</code> of 2.`,name:"downsample_in_first_stage"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/configuration_regnet.py#L28"}}),te=new Ye({props:{anchor:"transformers.RegNetConfig.example",$$slots:{default:[Mn]},$$scope:{ctx:$}}}),Ce=new D({props:{title:"RegNetModel",local:"transformers.RegNetModel",headingTag:"h2"}}),Fe=new U({props:{name:"class transformers.RegNetModel",anchor:"transformers.RegNetModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RegNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_regnet.py#L326"}}),Re=new U({props:{name:"forward",anchor:"transformers.RegNetModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RegNetModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.RegNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RegNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_regnet.py#L336",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new _t({props:{$$slots:{default:[Tn]},$$scope:{ctx:$}}}),ne=new Ye({props:{anchor:"transformers.RegNetModel.forward.example",$$slots:{default:[$n]},$$scope:{ctx:$}}}),Je=new D({props:{title:"RegNetForImageClassification",local:"transformers.RegNetForImageClassification",headingTag:"h2"}}),Ue=new U({props:{name:"class transformers.RegNetForImageClassification",anchor:"transformers.RegNetForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RegNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_regnet.py#L380"}}),Ze=new U({props:{name:"forward",anchor:"transformers.RegNetForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RegNetForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.RegNetForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RegNetForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.RegNetForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_regnet.py#L393",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new _t({props:{$$slots:{default:[vn]},$$scope:{ctx:$}}}),oe=new Ye({props:{anchor:"transformers.RegNetForImageClassification.forward.example",$$slots:{default:[xn]},$$scope:{ctx:$}}}),Ie=new D({props:{title:"TFRegNetModel",local:"transformers.TFRegNetModel",headingTag:"h2"}}),We=new U({props:{name:"class transformers.TFRegNetModel",anchor:"transformers.TFRegNetModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFRegNetModel.This",description:`<strong>This</strong> model is a Tensorflow &#x2014;
[tf.keras.layers.Layer](https &#x2014;//<a href="http://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">www.tensorflow.org/api_docs/python/tf/keras/layers/Layer</a>) sub-class. Use it as a`,name:"This"},{anchor:"transformers.TFRegNetModel.regular",description:`<strong>regular</strong> Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and &#x2014;
behavior. &#x2014;
config (<a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>): Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"regular"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_tf_regnet.py#L380"}}),ke=new U({props:{name:"call",anchor:"transformers.TFRegNetModel.call",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFRegNetModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>ConveNextImageProcessor.__call__</code> for details.`,name:"pixel_values"},{anchor:"transformers.TFRegNetModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFRegNetModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_tf_regnet.py#L385",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndNoAttention</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(tf.Tensor)</code></p>
`}}),re=new _t({props:{$$slots:{default:[jn]},$$scope:{ctx:$}}}),le=new Ye({props:{anchor:"transformers.TFRegNetModel.call.example",$$slots:{default:[Nn]},$$scope:{ctx:$}}}),Ge=new D({props:{title:"TFRegNetForImageClassification",local:"transformers.TFRegNetForImageClassification",headingTag:"h2"}}),Be=new U({props:{name:"class transformers.TFRegNetForImageClassification",anchor:"transformers.TFRegNetForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFRegNetForImageClassification.This",description:`<strong>This</strong> model is a Tensorflow &#x2014;
[tf.keras.layers.Layer](https &#x2014;//<a href="http://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">www.tensorflow.org/api_docs/python/tf/keras/layers/Layer</a>) sub-class. Use it as a`,name:"This"},{anchor:"transformers.TFRegNetForImageClassification.regular",description:`<strong>regular</strong> Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and &#x2014;
behavior. &#x2014;
config (<a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>): Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"regular"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_tf_regnet.py#L429"}}),ze=new U({props:{name:"call",anchor:"transformers.TFRegNetForImageClassification.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"labels",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFRegNetForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>ConveNextImageProcessor.__call__</code> for details.`,name:"pixel_values"},{anchor:"transformers.TFRegNetForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFRegNetForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFRegNetForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_tf_regnet.py#L440",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),ie=new _t({props:{$$slots:{default:[Cn]},$$scope:{ctx:$}}}),de=new Ye({props:{anchor:"transformers.TFRegNetForImageClassification.call.example",$$slots:{default:[Fn]},$$scope:{ctx:$}}}),Ve=new D({props:{title:"FlaxRegNetModel",local:"transformers.FlaxRegNetModel",headingTag:"h2"}}),He=new U({props:{name:"class transformers.FlaxRegNetModel",anchor:"transformers.FlaxRegNetModel",parameters:[{name:"config",val:": RegNetConfig"},{name:"input_shape",val:" = (1, 224, 224, 3)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxRegNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxRegNetModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_flax_regnet.py#L689"}}),Pe=new U({props:{name:"__call__",anchor:"transformers.FlaxRegNetModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"params",val:": dict = None"},{name:"train",val:": bool = False"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_flax_regnet.py#L596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.regnet.configuration_regnet.RegNetConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new _t({props:{$$slots:{default:[Rn]},$$scope:{ctx:$}}}),pe=new Ye({props:{anchor:"transformers.FlaxRegNetModel.__call__.example",$$slots:{default:[Jn]},$$scope:{ctx:$}}}),Ee=new D({props:{title:"FlaxRegNetForImageClassification",local:"transformers.FlaxRegNetForImageClassification",headingTag:"h2"}}),Le=new U({props:{name:"class transformers.FlaxRegNetForImageClassification",anchor:"transformers.FlaxRegNetForImageClassification",parameters:[{name:"config",val:": RegNetConfig"},{name:"input_shape",val:" = (1, 224, 224, 3)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxRegNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxRegNetForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_flax_regnet.py#L782"}}),Xe=new U({props:{name:"__call__",anchor:"transformers.FlaxRegNetForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"params",val:": dict = None"},{name:"train",val:": bool = False"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/regnet/modeling_flax_regnet.py#L596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_flax_outputs.FlaxImageClassifierOutputWithNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.regnet.configuration_regnet.RegNetConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when</li>
<li><strong><code>config.output_hidden_states=True</code>):</strong>
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings, if the model has an embedding layer, + one
for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_flax_outputs.FlaxImageClassifierOutputWithNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new _t({props:{$$slots:{default:[Un]},$$scope:{ctx:$}}}),ge=new Ye({props:{anchor:"transformers.FlaxRegNetForImageClassification.__call__.example",$$slots:{default:[Zn]},$$scope:{ctx:$}}}),{c(){t=p("meta"),w=o(),l=p("p"),i=o(),f(M.$$.fragment),s=o(),f(T.$$.fragment),yt=o(),fe=p("p"),fe.innerHTML=Ws,wt=o(),he=p("p"),he.textContent=ks,Mt=o(),ue=p("p"),ue.textContent=Gs,Tt=o(),_e=p("p"),_e.innerHTML=Bs,$t=o(),be=p("p"),be.textContent=zs,vt=o(),ye=p("ul"),ye.innerHTML=Vs,xt=o(),we=p("p"),we.innerHTML=Hs,jt=o(),f(Me.$$.fragment),Nt=o(),Te=p("p"),Te.textContent=Ps,Ct=o(),f($e.$$.fragment),Ft=o(),ve=p("ul"),ve.innerHTML=Es,Rt=o(),xe=p("p"),xe.textContent=Ls,Jt=o(),f(je.$$.fragment),Ut=o(),R=p("div"),f(Ne.$$.fragment),qt=o(),Qe=p("p"),Qe.innerHTML=Xs,Qt=o(),Se=p("p"),Se.innerHTML=Ys,St=o(),f(te.$$.fragment),Zt=o(),f(Ce.$$.fragment),It=o(),V=p("div"),f(Fe.$$.fragment),At=o(),Ae=p("p"),Ae.innerHTML=qs,Dt=o(),I=p("div"),f(Re.$$.fragment),Ot=o(),De=p("p"),De.innerHTML=Qs,Kt=o(),f(se.$$.fragment),es=o(),f(ne.$$.fragment),Wt=o(),f(Je.$$.fragment),kt=o(),J=p("div"),f(Ue.$$.fragment),ts=o(),Oe=p("p"),Oe.textContent=Ss,ss=o(),Ke=p("p"),Ke.innerHTML=As,ns=o(),W=p("div"),f(Ze.$$.fragment),as=o(),et=p("p"),et.innerHTML=Ds,os=o(),f(ae.$$.fragment),rs=o(),f(oe.$$.fragment),Gt=o(),f(Ie.$$.fragment),Bt=o(),H=p("div"),f(We.$$.fragment),ls=o(),tt=p("p"),tt.textContent=Os,is=o(),k=p("div"),f(ke.$$.fragment),ds=o(),st=p("p"),st.innerHTML=Ks,cs=o(),f(re.$$.fragment),ps=o(),f(le.$$.fragment),zt=o(),f(Ge.$$.fragment),Vt=o(),P=p("div"),f(Be.$$.fragment),ms=o(),nt=p("p"),nt.textContent=en,gs=o(),G=p("div"),f(ze.$$.fragment),fs=o(),at=p("p"),at.innerHTML=tn,hs=o(),f(ie.$$.fragment),us=o(),f(de.$$.fragment),Ht=o(),f(Ve.$$.fragment),Pt=o(),v=p("div"),f(He.$$.fragment),_s=o(),ot=p("p"),ot.textContent=sn,bs=o(),rt=p("p"),rt.innerHTML=nn,ys=o(),lt=p("p"),lt.innerHTML=an,ws=o(),it=p("p"),it.textContent=on,Ms=o(),dt=p("ul"),dt.innerHTML=rn,Ts=o(),B=p("div"),f(Pe.$$.fragment),$s=o(),ct=p("p"),ct.innerHTML=ln,vs=o(),f(ce.$$.fragment),xs=o(),f(pe.$$.fragment),Et=o(),f(Ee.$$.fragment),Lt=o(),x=p("div"),f(Le.$$.fragment),js=o(),pt=p("p"),pt.textContent=dn,Ns=o(),mt=p("p"),mt.innerHTML=cn,Cs=o(),gt=p("p"),gt.innerHTML=pn,Fs=o(),ft=p("p"),ft.textContent=mn,Rs=o(),ht=p("ul"),ht.innerHTML=gn,Js=o(),z=p("div"),f(Xe.$$.fragment),Us=o(),ut=p("p"),ut.innerHTML=fn,Zs=o(),f(me.$$.fragment),Is=o(),f(ge.$$.fragment),Xt=o(),bt=p("p"),this.h()},l(e){const n=yn("svelte-u9bgzb",document.head);t=m(n,"META",{name:!0,content:!0}),n.forEach(a),w=r(e),l=m(e,"P",{}),C(l).forEach(a),i=r(e),h(M.$$.fragment,e),s=r(e),h(T.$$.fragment,e),yt=r(e),fe=m(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-vy13p6"&&(fe.innerHTML=Ws),wt=r(e),he=m(e,"P",{"data-svelte-h":!0}),g(he)!=="svelte-1y5hyhh"&&(he.textContent=ks),Mt=r(e),ue=m(e,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-vfdo9a"&&(ue.textContent=Gs),Tt=r(e),_e=m(e,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-1judo2o"&&(_e.innerHTML=Bs),$t=r(e),be=m(e,"P",{"data-svelte-h":!0}),g(be)!=="svelte-axv494"&&(be.textContent=zs),vt=r(e),ye=m(e,"UL",{"data-svelte-h":!0}),g(ye)!=="svelte-f1bwc"&&(ye.innerHTML=Vs),xt=r(e),we=m(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-1x0i1j0"&&(we.innerHTML=Hs),jt=r(e),h(Me.$$.fragment,e),Nt=r(e),Te=m(e,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-15k7oqe"&&(Te.textContent=Ps),Ct=r(e),h($e.$$.fragment,e),Ft=r(e),ve=m(e,"UL",{"data-svelte-h":!0}),g(ve)!=="svelte-19u4l08"&&(ve.innerHTML=Es),Rt=r(e),xe=m(e,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-1xesile"&&(xe.textContent=Ls),Jt=r(e),h(je.$$.fragment,e),Ut=r(e),R=m(e,"DIV",{class:!0});var E=C(R);h(Ne.$$.fragment,E),qt=r(E),Qe=m(E,"P",{"data-svelte-h":!0}),g(Qe)!=="svelte-1qp6bqk"&&(Qe.innerHTML=Xs),Qt=r(E),Se=m(E,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-o55m63"&&(Se.innerHTML=Ys),St=r(E),h(te.$$.fragment,E),E.forEach(a),Zt=r(e),h(Ce.$$.fragment,e),It=r(e),V=m(e,"DIV",{class:!0});var O=C(V);h(Fe.$$.fragment,O),At=r(O),Ae=m(O,"P",{"data-svelte-h":!0}),g(Ae)!=="svelte-1ime5d7"&&(Ae.innerHTML=qs),Dt=r(O),I=m(O,"DIV",{class:!0});var L=C(I);h(Re.$$.fragment,L),Ot=r(L),De=m(L,"P",{"data-svelte-h":!0}),g(De)!=="svelte-7oyxd8"&&(De.innerHTML=Qs),Kt=r(L),h(se.$$.fragment,L),es=r(L),h(ne.$$.fragment,L),L.forEach(a),O.forEach(a),Wt=r(e),h(Je.$$.fragment,e),kt=r(e),J=m(e,"DIV",{class:!0});var X=C(J);h(Ue.$$.fragment,X),ts=r(X),Oe=m(X,"P",{"data-svelte-h":!0}),g(Oe)!=="svelte-ipsb0r"&&(Oe.textContent=Ss),ss=r(X),Ke=m(X,"P",{"data-svelte-h":!0}),g(Ke)!=="svelte-1gjh92c"&&(Ke.innerHTML=As),ns=r(X),W=m(X,"DIV",{class:!0});var Y=C(W);h(Ze.$$.fragment,Y),as=r(Y),et=m(Y,"P",{"data-svelte-h":!0}),g(et)!=="svelte-idxxuu"&&(et.innerHTML=Ds),os=r(Y),h(ae.$$.fragment,Y),rs=r(Y),h(oe.$$.fragment,Y),Y.forEach(a),X.forEach(a),Gt=r(e),h(Ie.$$.fragment,e),Bt=r(e),H=m(e,"DIV",{class:!0});var K=C(H);h(We.$$.fragment,K),ls=r(K),tt=m(K,"P",{"data-svelte-h":!0}),g(tt)!=="svelte-1lrc7eh"&&(tt.textContent=Os),is=r(K),k=m(K,"DIV",{class:!0});var q=C(k);h(ke.$$.fragment,q),ds=r(q),st=m(q,"P",{"data-svelte-h":!0}),g(st)!=="svelte-1imc2ag"&&(st.innerHTML=Ks),cs=r(q),h(re.$$.fragment,q),ps=r(q),h(le.$$.fragment,q),q.forEach(a),K.forEach(a),zt=r(e),h(Ge.$$.fragment,e),Vt=r(e),P=m(e,"DIV",{class:!0});var ee=C(P);h(Be.$$.fragment,ee),ms=r(ee),nt=m(ee,"P",{"data-svelte-h":!0}),g(nt)!=="svelte-ipsb0r"&&(nt.textContent=en),gs=r(ee),G=m(ee,"DIV",{class:!0});var Q=C(G);h(ze.$$.fragment,Q),fs=r(Q),at=m(Q,"P",{"data-svelte-h":!0}),g(at)!=="svelte-dozala"&&(at.innerHTML=tn),hs=r(Q),h(ie.$$.fragment,Q),us=r(Q),h(de.$$.fragment,Q),Q.forEach(a),ee.forEach(a),Ht=r(e),h(Ve.$$.fragment,e),Pt=r(e),v=m(e,"DIV",{class:!0});var j=C(v);h(He.$$.fragment,j),_s=r(j),ot=m(j,"P",{"data-svelte-h":!0}),g(ot)!=="svelte-1lrc7eh"&&(ot.textContent=sn),bs=r(j),rt=m(j,"P",{"data-svelte-h":!0}),g(rt)!=="svelte-3daxed"&&(rt.innerHTML=nn),ys=r(j),lt=m(j,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-9ybkh"&&(lt.innerHTML=an),ws=r(j),it=m(j,"P",{"data-svelte-h":!0}),g(it)!=="svelte-1pplc4a"&&(it.textContent=on),Ms=r(j),dt=m(j,"UL",{"data-svelte-h":!0}),g(dt)!=="svelte-1w7z84m"&&(dt.innerHTML=rn),Ts=r(j),B=m(j,"DIV",{class:!0});var S=C(B);h(Pe.$$.fragment,S),$s=r(S),ct=m(S,"P",{"data-svelte-h":!0}),g(ct)!=="svelte-1xwpegk"&&(ct.innerHTML=ln),vs=r(S),h(ce.$$.fragment,S),xs=r(S),h(pe.$$.fragment,S),S.forEach(a),j.forEach(a),Et=r(e),h(Ee.$$.fragment,e),Lt=r(e),x=m(e,"DIV",{class:!0});var N=C(x);h(Le.$$.fragment,N),js=r(N),pt=m(N,"P",{"data-svelte-h":!0}),g(pt)!=="svelte-ipsb0r"&&(pt.textContent=dn),Ns=r(N),mt=m(N,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-3daxed"&&(mt.innerHTML=cn),Cs=r(N),gt=m(N,"P",{"data-svelte-h":!0}),g(gt)!=="svelte-9ybkh"&&(gt.innerHTML=pn),Fs=r(N),ft=m(N,"P",{"data-svelte-h":!0}),g(ft)!=="svelte-1pplc4a"&&(ft.textContent=mn),Rs=r(N),ht=m(N,"UL",{"data-svelte-h":!0}),g(ht)!=="svelte-1w7z84m"&&(ht.innerHTML=gn),Js=r(N),z=m(N,"DIV",{class:!0});var A=C(z);h(Xe.$$.fragment,A),Us=r(A),ut=m(A,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-1xwpegk"&&(ut.innerHTML=fn),Zs=r(A),h(me.$$.fragment,A),Is=r(A),h(ge.$$.fragment,A),A.forEach(a),N.forEach(a),Xt=r(e),bt=m(e,"P",{}),C(bt).forEach(a),this.h()},h(){F(t,"name","hf:doc:metadata"),F(t,"content",Wn),F(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){d(document.head,t),c(e,w,n),c(e,l,n),c(e,i,n),u(M,e,n),c(e,s,n),u(T,e,n),c(e,yt,n),c(e,fe,n),c(e,wt,n),c(e,he,n),c(e,Mt,n),c(e,ue,n),c(e,Tt,n),c(e,_e,n),c(e,$t,n),c(e,be,n),c(e,vt,n),c(e,ye,n),c(e,xt,n),c(e,we,n),c(e,jt,n),u(Me,e,n),c(e,Nt,n),c(e,Te,n),c(e,Ct,n),u($e,e,n),c(e,Ft,n),c(e,ve,n),c(e,Rt,n),c(e,xe,n),c(e,Jt,n),u(je,e,n),c(e,Ut,n),c(e,R,n),u(Ne,R,null),d(R,qt),d(R,Qe),d(R,Qt),d(R,Se),d(R,St),u(te,R,null),c(e,Zt,n),u(Ce,e,n),c(e,It,n),c(e,V,n),u(Fe,V,null),d(V,At),d(V,Ae),d(V,Dt),d(V,I),u(Re,I,null),d(I,Ot),d(I,De),d(I,Kt),u(se,I,null),d(I,es),u(ne,I,null),c(e,Wt,n),u(Je,e,n),c(e,kt,n),c(e,J,n),u(Ue,J,null),d(J,ts),d(J,Oe),d(J,ss),d(J,Ke),d(J,ns),d(J,W),u(Ze,W,null),d(W,as),d(W,et),d(W,os),u(ae,W,null),d(W,rs),u(oe,W,null),c(e,Gt,n),u(Ie,e,n),c(e,Bt,n),c(e,H,n),u(We,H,null),d(H,ls),d(H,tt),d(H,is),d(H,k),u(ke,k,null),d(k,ds),d(k,st),d(k,cs),u(re,k,null),d(k,ps),u(le,k,null),c(e,zt,n),u(Ge,e,n),c(e,Vt,n),c(e,P,n),u(Be,P,null),d(P,ms),d(P,nt),d(P,gs),d(P,G),u(ze,G,null),d(G,fs),d(G,at),d(G,hs),u(ie,G,null),d(G,us),u(de,G,null),c(e,Ht,n),u(Ve,e,n),c(e,Pt,n),c(e,v,n),u(He,v,null),d(v,_s),d(v,ot),d(v,bs),d(v,rt),d(v,ys),d(v,lt),d(v,ws),d(v,it),d(v,Ms),d(v,dt),d(v,Ts),d(v,B),u(Pe,B,null),d(B,$s),d(B,ct),d(B,vs),u(ce,B,null),d(B,xs),u(pe,B,null),c(e,Et,n),u(Ee,e,n),c(e,Lt,n),c(e,x,n),u(Le,x,null),d(x,js),d(x,pt),d(x,Ns),d(x,mt),d(x,Cs),d(x,gt),d(x,Fs),d(x,ft),d(x,Rs),d(x,ht),d(x,Js),d(x,z),u(Xe,z,null),d(z,Us),d(z,ut),d(z,Zs),u(me,z,null),d(z,Is),u(ge,z,null),c(e,Xt,n),c(e,bt,n),Yt=!0},p(e,[n]){const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),te.$set(E);const O={};n&2&&(O.$$scope={dirty:n,ctx:e}),se.$set(O);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),ne.$set(L);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),ae.$set(X);const Y={};n&2&&(Y.$$scope={dirty:n,ctx:e}),oe.$set(Y);const K={};n&2&&(K.$$scope={dirty:n,ctx:e}),re.$set(K);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),le.$set(q);const ee={};n&2&&(ee.$$scope={dirty:n,ctx:e}),ie.$set(ee);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),de.$set(Q);const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),ce.$set(j);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),pe.$set(S);const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),me.$set(N);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),ge.$set(A)},i(e){Yt||(_(M.$$.fragment,e),_(T.$$.fragment,e),_(Me.$$.fragment,e),_($e.$$.fragment,e),_(je.$$.fragment,e),_(Ne.$$.fragment,e),_(te.$$.fragment,e),_(Ce.$$.fragment,e),_(Fe.$$.fragment,e),_(Re.$$.fragment,e),_(se.$$.fragment,e),_(ne.$$.fragment,e),_(Je.$$.fragment,e),_(Ue.$$.fragment,e),_(Ze.$$.fragment,e),_(ae.$$.fragment,e),_(oe.$$.fragment,e),_(Ie.$$.fragment,e),_(We.$$.fragment,e),_(ke.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(ze.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(Ve.$$.fragment,e),_(He.$$.fragment,e),_(Pe.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(Ee.$$.fragment,e),_(Le.$$.fragment,e),_(Xe.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),Yt=!0)},o(e){b(M.$$.fragment,e),b(T.$$.fragment,e),b(Me.$$.fragment,e),b($e.$$.fragment,e),b(je.$$.fragment,e),b(Ne.$$.fragment,e),b(te.$$.fragment,e),b(Ce.$$.fragment,e),b(Fe.$$.fragment,e),b(Re.$$.fragment,e),b(se.$$.fragment,e),b(ne.$$.fragment,e),b(Je.$$.fragment,e),b(Ue.$$.fragment,e),b(Ze.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(Ie.$$.fragment,e),b(We.$$.fragment,e),b(ke.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(Ge.$$.fragment,e),b(Be.$$.fragment,e),b(ze.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(Ve.$$.fragment,e),b(He.$$.fragment,e),b(Pe.$$.fragment,e),b(ce.$$.fragment,e),b(pe.$$.fragment,e),b(Ee.$$.fragment,e),b(Le.$$.fragment,e),b(Xe.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),Yt=!1},d(e){e&&(a(w),a(l),a(i),a(s),a(yt),a(fe),a(wt),a(he),a(Mt),a(ue),a(Tt),a(_e),a($t),a(be),a(vt),a(ye),a(xt),a(we),a(jt),a(Nt),a(Te),a(Ct),a(Ft),a(ve),a(Rt),a(xe),a(Jt),a(Ut),a(R),a(Zt),a(It),a(V),a(Wt),a(kt),a(J),a(Gt),a(Bt),a(H),a(zt),a(Vt),a(P),a(Ht),a(Pt),a(v),a(Et),a(Lt),a(x),a(Xt),a(bt)),a(t),y(M,e),y(T,e),y(Me,e),y($e,e),y(je,e),y(Ne),y(te),y(Ce,e),y(Fe),y(Re),y(se),y(ne),y(Je,e),y(Ue),y(Ze),y(ae),y(oe),y(Ie,e),y(We),y(ke),y(re),y(le),y(Ge,e),y(Be),y(ze),y(ie),y(de),y(Ve,e),y(He),y(Pe),y(ce),y(pe),y(Ee,e),y(Le),y(Xe),y(me),y(ge)}}}const Wn='{"title":"RegNet","local":"regnet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"RegNetConfig","local":"transformers.RegNetConfig","sections":[],"depth":2},{"title":"RegNetModel","local":"transformers.RegNetModel","sections":[],"depth":2},{"title":"RegNetForImageClassification","local":"transformers.RegNetForImageClassification","sections":[],"depth":2},{"title":"TFRegNetModel","local":"transformers.TFRegNetModel","sections":[],"depth":2},{"title":"TFRegNetForImageClassification","local":"transformers.TFRegNetForImageClassification","sections":[],"depth":2},{"title":"FlaxRegNetModel","local":"transformers.FlaxRegNetModel","sections":[],"depth":2},{"title":"FlaxRegNetForImageClassification","local":"transformers.FlaxRegNetForImageClassification","sections":[],"depth":2}],"depth":1}';function kn($){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends _n{constructor(t){super(),bn(this,t,kn,In,hn,{})}}export{Xn as component};
