import{s as jt,f as xt,o as $t,n as Te}from"../chunks/scheduler.9bc65507.js";import{S as Ut,i as Ct,g as d,s as r,r as u,A as Jt,h as m,f as o,c as l,j as se,u as g,x as p,k as I,y as f,a as s,v as b,d as _,t as T,w as y}from"../chunks/index.707bf1b6.js";import{T as vt}from"../chunks/Tip.c2ecdbf4.js";import{D as _e}from"../chunks/Docstring.17db21ae.js";import{C as nt}from"../chunks/CodeBlock.54a9f38d.js";import{E as ot}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as kt}from"../chunks/PipelineTag.44585822.js";import{H as ge}from"../chunks/Heading.342b1fa6.js";function Zt(C){let n,w="Examples:",i,c,h;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhYmxlVHJhbnNmb3JtZXJNb2RlbCUyQyUyMFRhYmxlVHJhbnNmb3JtZXJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVGFibGUlMjBUcmFuc2Zvcm1lciUyMG1pY3Jvc29mdCUyRnRhYmxlLXRyYW5zZm9ybWVyLWRldGVjdGlvbiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBUYWJsZVRyYW5zZm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbWljcm9zb2Z0JTJGdGFibGUtdHJhbnNmb3JtZXItZGV0ZWN0aW9uJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUYWJsZVRyYW5zZm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TableTransformerModel, TableTransformerConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Table Transformer microsoft/table-transformer-detection style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TableTransformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/table-transformer-detection style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,i=r(),u(c.$$.fragment)},l(a){n=m(a,"P",{"data-svelte-h":!0}),p(n)!=="svelte-kvfsh7"&&(n.textContent=w),i=l(a),g(c.$$.fragment,a)},m(a,M){s(a,n,M),s(a,i,M),b(c,a,M),h=!0},p:Te,i(a){h||(_(c.$$.fragment,a),h=!0)},o(a){T(c.$$.fragment,a),h=!1},d(a){a&&(o(n),o(i)),y(c,a)}}}function Wt(C){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=w},l(i){n=m(i,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(i,c){s(i,n,c)},p:Te,d(i){i&&o(n)}}}function Ft(C){let n,w="Examples:",i,c,h;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRhYmxlVHJhbnNmb3JtZXJNb2RlbCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmaWxlX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb19pZCUzRCUyMm5pZWxzciUyRmV4YW1wbGUtcGRmJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyZXhhbXBsZV9wZGYucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlX3BhdGgpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdGFibGUtdHJhbnNmb3JtZXItZGV0ZWN0aW9uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFibGVUcmFuc2Zvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ0YWJsZS10cmFuc2Zvcm1lci1kZXRlY3Rpb24lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBhcmUlMjB0aGUlMjBmaW5hbCUyMHF1ZXJ5JTIwZW1iZWRkaW5ncyUyMG9mJTIwdGhlJTIwVHJhbnNmb3JtZXIlMjBkZWNvZGVyJTBBJTIzJTIwdGhlc2UlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TableTransformerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;nielsr/example-pdf&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, filename=<span class="hljs-string">&quot;example_pdf.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(file_path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerModel.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">15</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,i=r(),u(c.$$.fragment)},l(a){n=m(a,"P",{"data-svelte-h":!0}),p(n)!=="svelte-kvfsh7"&&(n.textContent=w),i=l(a),g(c.$$.fragment,a)},m(a,M){s(a,n,M),s(a,i,M),b(c,a,M),h=!0},p:Te,i(a){h||(_(c.$$.fragment,a),h=!0)},o(a){T(c.$$.fragment,a),h=!1},d(a){a&&(o(n),o(i)),y(c,a)}}}function It(C){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=w},l(i){n=m(i,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(i,c){s(i,n,c)},p:Te,d(i){i&&o(n)}}}function zt(C){let n,w="Examples:",i,c,h;return c=new nt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TableTransformerForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;nielsr/example-pdf&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, filename=<span class="hljs-string">&quot;example_pdf.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(file_path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerForObjectDetection.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected table <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">202.1</span>, <span class="hljs-number">210.59</span>, <span class="hljs-number">1119.22</span>, <span class="hljs-number">385.09</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,i=r(),u(c.$$.fragment)},l(a){n=m(a,"P",{"data-svelte-h":!0}),p(n)!=="svelte-kvfsh7"&&(n.textContent=w),i=l(a),g(c.$$.fragment,a)},m(a,M){s(a,n,M),s(a,i,M),b(c,a,M),h=!0},p:Te,i(a){h||(_(c.$$.fragment,a),h=!0)},o(a){T(c.$$.fragment,a),h=!1},d(a){a&&(o(n),o(i)),y(c,a)}}}function Gt(C){let n,w,i,c,h,a,M,ye,V,at=`The Table Transformer model was proposed in <a href="https://arxiv.org/abs/2110.00061" rel="nofollow">PubTables-1M: Towards comprehensive table extraction from unstructured documents</a> by
Brandon Smock, Rohith Pesala, Robin Abraham. The authors introduce a new dataset, PubTables-1M, to benchmark progress in table extraction from unstructured documents,
as well as table structure recognition and functional analysis. The authors train 2 <a href="detr">DETR</a> models, one for table detection and one for table structure recognition, dubbed Table Transformers.`,we,H,st="The abstract from the paper is the following:",Me,P,rt=`<em>Recently, significant progress has been made applying machine learning to the problem of table structure inference and extraction from unstructured documents.
However, one of the greatest challenges remains the creation of datasets with complete, unambiguous ground truth at scale. To address this, we develop a new, more
comprehensive dataset for table extraction, called PubTables-1M. PubTables-1M contains nearly one million tables from scientific articles, supports multiple input
modalities, and contains detailed header and location information for table structures, making it useful for a wide variety of modeling approaches. It also addresses a significant
source of ground truth inconsistency observed in prior datasets called oversegmentation, using a novel canonicalization procedure. We demonstrate that these improvements lead to a
significant increase in training performance and a more reliable estimate of model performance at evaluation for table structure recognition. Further, we show that transformer-based
object detection models trained on PubTables-1M produce excellent results for all three tasks of detection, structure recognition, and functional analysis without the need for any
special customization for these tasks.</em>`,ve,X,lt="Tips:",je,D,it='<li>The authors released 2 models, one for <a href="https://huggingface.co/microsoft/table-transformer-detection" rel="nofollow">table detection</a> in documents, one for <a href="https://huggingface.co/microsoft/table-transformer-structure-recognition" rel="nofollow">table structure recognition</a> (the task of recognizing the individual rows, columns etc. in a table).</li> <li>One can use the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> API to prepare images and optional targets for the model. This will load a <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> behind the scenes.</li>',xe,z,ct,$e,Q,dt='Table detection and table structure recognition clarified. Taken from the <a href="https://arxiv.org/abs/2110.00061">original paper</a>.',Ue,E,mt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be
found <a href="https://github.com/microsoft/table-transformer" rel="nofollow">here</a>.`,Ce,O,Je,S,ke,L,ft='<li>A demo notebook for the Table Transformer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Table%20Transformer" rel="nofollow">here</a>.</li> <li>It turns out padding of images is quite important for detection. An interesting Github thread with replies from the authors can be found <a href="https://github.com/microsoft/table-transformer/issues/68" rel="nofollow">here</a>.</li>',Ze,Y,We,x,A,Be,re,pt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a>. It is used to
instantiate a Table Transformer model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Table Transformer
<a href="https://huggingface.co/microsoft/table-transformer-detection" rel="nofollow">microsoft/table-transformer-detection</a> architecture.`,Re,le,ht=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ve,G,Fe,K,Ie,v,ee,He,ie,ut=`The bare Table Transformer Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,Pe,ce,gt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xe,de,bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,De,J,te,Qe,me,_t='The <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> forward method, overrides the <code>__call__</code> special method.',Ee,q,Oe,N,ze,oe,Ge,j,ne,Se,fe,Tt=`Table Transformer Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,Le,pe,yt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ye,he,wt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ae,k,ae,Ke,ue,Mt='The <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerForObjectDetection">TableTransformerForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',et,B,tt,R,qe,be,Ne;return h=new ge({props:{title:"Table Transformer",local:"table-transformer",headingTag:"h1"}}),M=new ge({props:{title:"Overview",local:"overview",headingTag:"h2"}}),O=new ge({props:{title:"Resources",local:"resources",headingTag:"h2"}}),S=new kt({props:{pipeline:"object-detection"}}),Y=new ge({props:{title:"TableTransformerConfig",local:"transformers.TableTransformerConfig",headingTag:"h2"}}),A=new _e({props:{name:"class transformers.TableTransformerConfig",anchor:"transformers.TableTransformerConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 100"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TableTransformerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <code>AutoBackbone</code>
API.`,name:"use_timm_backbone"},{anchor:"transformers.TableTransformerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.TableTransformerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.TableTransformerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> can detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.TableTransformerConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.TableTransformerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.TableTransformerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.TableTransformerConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.TableTransformerConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.TableTransformerConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.TableTransformerConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.TableTransformerConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.TableTransformerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.TableTransformerConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.TableTransformerConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.TableTransformerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.TableTransformerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.TableTransformerConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.TableTransformerConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.TableTransformerConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.TableTransformerConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.TableTransformerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of convolutional backbone to use in case <code>use_timm_backbone</code> = <code>True</code>. Supports any convolutional
backbone from the timm package. For a list of all available models, see <a href="https://rwightman.github.io/pytorch-image-models/#load-a-pretrained-model" rel="nofollow">this
page</a>.`,name:"backbone"},{anchor:"transformers.TableTransformerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone. Only supported when <code>use_timm_backbone</code> = <code>True</code>.`,name:"use_pretrained_backbone"},{anchor:"transformers.TableTransformerConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.TableTransformerConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.TableTransformerConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.TableTransformerConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.TableTransformerConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/configuration_table_transformer.py#L36"}}),G=new ot({props:{anchor:"transformers.TableTransformerConfig.example",$$slots:{default:[Zt]},$$scope:{ctx:C}}}),K=new ge({props:{title:"TableTransformerModel",local:"transformers.TableTransformerModel",headingTag:"h2"}}),ee=new _e({props:{name:"class transformers.TableTransformerModel",anchor:"transformers.TableTransformerModel",parameters:[{name:"config",val:": TableTransformerConfig"}],parametersDescription:[{anchor:"transformers.TableTransformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1199"}}),te=new _e({props:{name:"forward",anchor:"transformers.TableTransformerModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TableTransformerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TableTransformerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.TableTransformerModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.TableTransformerModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TableTransformerModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.TableTransformerModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TableTransformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TableTransformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TableTransformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig"
>TableTransformerConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new vt({props:{$$slots:{default:[Wt]},$$scope:{ctx:C}}}),N=new ot({props:{anchor:"transformers.TableTransformerModel.forward.example",$$slots:{default:[Ft]},$$scope:{ctx:C}}}),oe=new ge({props:{title:"TableTransformerForObjectDetection",local:"transformers.TableTransformerForObjectDetection",headingTag:"h2"}}),ne=new _e({props:{name:"class transformers.TableTransformerForObjectDetection",anchor:"transformers.TableTransformerForObjectDetection",parameters:[{name:"config",val:": TableTransformerConfig"}],parametersDescription:[{anchor:"transformers.TableTransformerForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1368"}}),ae=new _e({props:{name:"forward",anchor:"transformers.TableTransformerForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TableTransformerForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TableTransformerForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.TableTransformerForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.TableTransformerForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TableTransformerForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.TableTransformerForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TableTransformerForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TableTransformerForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TableTransformerForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TableTransformerForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1395",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig"
>TableTransformerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~TableTransformerImageProcessor.post_process_object_detection</code> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new vt({props:{$$slots:{default:[It]},$$scope:{ctx:C}}}),R=new ot({props:{anchor:"transformers.TableTransformerForObjectDetection.forward.example",$$slots:{default:[zt]},$$scope:{ctx:C}}}),{c(){n=d("meta"),w=r(),i=d("p"),c=r(),u(h.$$.fragment),a=r(),u(M.$$.fragment),ye=r(),V=d("p"),V.innerHTML=at,we=r(),H=d("p"),H.textContent=st,Me=r(),P=d("p"),P.innerHTML=rt,ve=r(),X=d("p"),X.textContent=lt,je=r(),D=d("ul"),D.innerHTML=it,xe=r(),z=d("img"),$e=r(),Q=d("small"),Q.innerHTML=dt,Ue=r(),E=d("p"),E.innerHTML=mt,Ce=r(),u(O.$$.fragment),Je=r(),u(S.$$.fragment),ke=r(),L=d("ul"),L.innerHTML=ft,Ze=r(),u(Y.$$.fragment),We=r(),x=d("div"),u(A.$$.fragment),Be=r(),re=d("p"),re.innerHTML=pt,Re=r(),le=d("p"),le.innerHTML=ht,Ve=r(),u(G.$$.fragment),Fe=r(),u(K.$$.fragment),Ie=r(),v=d("div"),u(ee.$$.fragment),He=r(),ie=d("p"),ie.textContent=ut,Pe=r(),ce=d("p"),ce.innerHTML=gt,Xe=r(),de=d("p"),de.innerHTML=bt,De=r(),J=d("div"),u(te.$$.fragment),Qe=r(),me=d("p"),me.innerHTML=_t,Ee=r(),u(q.$$.fragment),Oe=r(),u(N.$$.fragment),ze=r(),u(oe.$$.fragment),Ge=r(),j=d("div"),u(ne.$$.fragment),Se=r(),fe=d("p"),fe.textContent=Tt,Le=r(),pe=d("p"),pe.innerHTML=yt,Ye=r(),he=d("p"),he.innerHTML=wt,Ae=r(),k=d("div"),u(ae.$$.fragment),Ke=r(),ue=d("p"),ue.innerHTML=Mt,et=r(),u(B.$$.fragment),tt=r(),u(R.$$.fragment),qe=r(),be=d("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(o),w=l(e),i=m(e,"P",{}),se(i).forEach(o),c=l(e),g(h.$$.fragment,e),a=l(e),g(M.$$.fragment,e),ye=l(e),V=m(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1eh4n85"&&(V.innerHTML=at),we=l(e),H=m(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-vfdo9a"&&(H.textContent=st),Me=l(e),P=m(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-15fvuyo"&&(P.innerHTML=rt),ve=l(e),X=m(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-axv494"&&(X.textContent=lt),je=l(e),D=m(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-e6phhg"&&(D.innerHTML=it),xe=l(e),z=m(e,"IMG",{src:!0,alt:!0,width:!0}),$e=l(e),Q=m(e,"SMALL",{"data-svelte-h":!0}),p(Q)!=="svelte-xusvwd"&&(Q.innerHTML=dt),Ue=l(e),E=m(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ynmngv"&&(E.innerHTML=mt),Ce=l(e),g(O.$$.fragment,e),Je=l(e),g(S.$$.fragment,e),ke=l(e),L=m(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-4dtp4u"&&(L.innerHTML=ft),Ze=l(e),g(Y.$$.fragment,e),We=l(e),x=m(e,"DIV",{class:!0});var Z=se(x);g(A.$$.fragment,Z),Be=l(Z),re=m(Z,"P",{"data-svelte-h":!0}),p(re)!=="svelte-u4joxt"&&(re.innerHTML=pt),Re=l(Z),le=m(Z,"P",{"data-svelte-h":!0}),p(le)!=="svelte-o55m63"&&(le.innerHTML=ht),Ve=l(Z),g(G.$$.fragment,Z),Z.forEach(o),Fe=l(e),g(K.$$.fragment,e),Ie=l(e),v=m(e,"DIV",{class:!0});var $=se(v);g(ee.$$.fragment,$),He=l($),ie=m($,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-q3yild"&&(ie.textContent=ut),Pe=l($),ce=m($,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-6pahdo"&&(ce.innerHTML=gt),Xe=l($),de=m($,"P",{"data-svelte-h":!0}),p(de)!=="svelte-hswkmf"&&(de.innerHTML=bt),De=l($),J=m($,"DIV",{class:!0});var W=se(J);g(te.$$.fragment,W),Qe=l(W),me=m(W,"P",{"data-svelte-h":!0}),p(me)!=="svelte-4zig1t"&&(me.innerHTML=_t),Ee=l(W),g(q.$$.fragment,W),Oe=l(W),g(N.$$.fragment,W),W.forEach(o),$.forEach(o),ze=l(e),g(oe.$$.fragment,e),Ge=l(e),j=m(e,"DIV",{class:!0});var U=se(j);g(ne.$$.fragment,U),Se=l(U),fe=m(U,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-14j6uvi"&&(fe.textContent=Tt),Le=l(U),pe=m(U,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-6pahdo"&&(pe.innerHTML=yt),Ye=l(U),he=m(U,"P",{"data-svelte-h":!0}),p(he)!=="svelte-hswkmf"&&(he.innerHTML=wt),Ae=l(U),k=m(U,"DIV",{class:!0});var F=se(k);g(ae.$$.fragment,F),Ke=l(F),ue=m(F,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-a1ddut"&&(ue.innerHTML=Mt),et=l(F),g(B.$$.fragment,F),tt=l(F),g(R.$$.fragment,F),F.forEach(o),U.forEach(o),qe=l(e),be=m(e,"P",{}),se(be).forEach(o),this.h()},h(){I(n,"name","hf:doc:metadata"),I(n,"content",qt),xt(z.src,ct="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/table_transformer_architecture.jpeg")||I(z,"src",ct),I(z,"alt","drawing"),I(z,"width","600"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){f(document.head,n),s(e,w,t),s(e,i,t),s(e,c,t),b(h,e,t),s(e,a,t),b(M,e,t),s(e,ye,t),s(e,V,t),s(e,we,t),s(e,H,t),s(e,Me,t),s(e,P,t),s(e,ve,t),s(e,X,t),s(e,je,t),s(e,D,t),s(e,xe,t),s(e,z,t),s(e,$e,t),s(e,Q,t),s(e,Ue,t),s(e,E,t),s(e,Ce,t),b(O,e,t),s(e,Je,t),b(S,e,t),s(e,ke,t),s(e,L,t),s(e,Ze,t),b(Y,e,t),s(e,We,t),s(e,x,t),b(A,x,null),f(x,Be),f(x,re),f(x,Re),f(x,le),f(x,Ve),b(G,x,null),s(e,Fe,t),b(K,e,t),s(e,Ie,t),s(e,v,t),b(ee,v,null),f(v,He),f(v,ie),f(v,Pe),f(v,ce),f(v,Xe),f(v,de),f(v,De),f(v,J),b(te,J,null),f(J,Qe),f(J,me),f(J,Ee),b(q,J,null),f(J,Oe),b(N,J,null),s(e,ze,t),b(oe,e,t),s(e,Ge,t),s(e,j,t),b(ne,j,null),f(j,Se),f(j,fe),f(j,Le),f(j,pe),f(j,Ye),f(j,he),f(j,Ae),f(j,k),b(ae,k,null),f(k,Ke),f(k,ue),f(k,et),b(B,k,null),f(k,tt),b(R,k,null),s(e,qe,t),s(e,be,t),Ne=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),G.$set(Z);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),q.$set($);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),N.$set(W);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),B.$set(U);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),R.$set(F)},i(e){Ne||(_(h.$$.fragment,e),_(M.$$.fragment,e),_(O.$$.fragment,e),_(S.$$.fragment,e),_(Y.$$.fragment,e),_(A.$$.fragment,e),_(G.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(q.$$.fragment,e),_(N.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(B.$$.fragment,e),_(R.$$.fragment,e),Ne=!0)},o(e){T(h.$$.fragment,e),T(M.$$.fragment,e),T(O.$$.fragment,e),T(S.$$.fragment,e),T(Y.$$.fragment,e),T(A.$$.fragment,e),T(G.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(q.$$.fragment,e),T(N.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(B.$$.fragment,e),T(R.$$.fragment,e),Ne=!1},d(e){e&&(o(w),o(i),o(c),o(a),o(ye),o(V),o(we),o(H),o(Me),o(P),o(ve),o(X),o(je),o(D),o(xe),o(z),o($e),o(Q),o(Ue),o(E),o(Ce),o(Je),o(ke),o(L),o(Ze),o(We),o(x),o(Fe),o(Ie),o(v),o(ze),o(Ge),o(j),o(qe),o(be)),o(n),y(h,e),y(M,e),y(O,e),y(S,e),y(Y,e),y(A),y(G),y(K,e),y(ee),y(te),y(q),y(N),y(oe,e),y(ne),y(ae),y(B),y(R)}}}const qt='{"title":"Table Transformer","local":"table-transformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"TableTransformerConfig","local":"transformers.TableTransformerConfig","sections":[],"depth":2},{"title":"TableTransformerModel","local":"transformers.TableTransformerModel","sections":[],"depth":2},{"title":"TableTransformerForObjectDetection","local":"transformers.TableTransformerForObjectDetection","sections":[],"depth":2}],"depth":1}';function Nt(C){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Ut{constructor(n){super(),Ct(this,n,Nt,Gt,jt,{})}}export{Et as component};
