import{s as Rr,f as u,n as Sr,o as Fr}from"../chunks/scheduler.37c15a92.js";import{S as Vr,i as Hr,g as M,s as n,r as o,A as Nr,h as i,f as t,c as a,j as xr,u as r,x as p,k as m,y as zr,a as s,v as y,d as J,t as w,w as T}from"../chunks/index.7cb9c9b8.js";import{C as j}from"../chunks/CodeBlock.a6d3f852.js";import{C as qr}from"../chunks/CourseFloatingBanner.36c274d0.js";import{H as U}from"../chunks/Heading.d3928e2a.js";function Lr(Mp){let c,_s,Ws,$s,Z,Qs,A,Xs,W,ip="Now that we studied the Q-Learning algorithm, let’s implement it from scratch and train our Q-Learning agent in two environments:",Es,k,pp='<li><a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">Frozen-Lake-v1  (non-slippery and slippery version)</a> ☃️ : where our agent will need to <strong>go from the starting state (S) to the goal state (G)</strong> by walking only on frozen tiles (F) and avoiding holes (H).</li> <li><a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">An autonomous taxi</a> 🚖 will need <strong>to learn to navigate</strong> a city to <strong>transport its passengers from point A to point B.</strong></li>',Ys,_,op,xs,$,rp='Thanks to a <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a>, you’ll be able to compare your results with other classmates and exchange the best practices to improve your agent’s scores. Who will win the challenge for Unit 2?',Rs,Q,yp='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained Taxi model to the Hub and <strong>get a result of &gt;= 4.5</strong>.',Ss,X,Jp='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Fs,E,wp='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',Vs,Y,Tp='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',Hs,x,mp="<strong>To start the hands-on click on the Open In Colab button</strong> 👇 :",Ns,R,jp='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit2/unit2.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',zs,S,Up="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",qs,F,up="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",Ls,V,Ds,H,cp,Ps,N,hp="In this notebook, <strong>you’ll code your first Reinforcement Learning agent from scratch</strong> to play FrozenLake ❄️ using Q-Learning, share it with the community, and experiment with different configurations.",Ks,z,dp="⬇️ Here is an example of what <strong>you will achieve in just a couple of minutes.</strong> ⬇️",Os,q,Ip,ln,L,en,D,bp='<li><a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">FrozenLake-v1</a></li> <li><a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">Taxi-v3</a></li>',tn,P,sn,K,fp='<li>Python and NumPy</li> <li><a href="https://gymnasium.farama.org/" rel="nofollow">Gymnasium</a></li>',nn,O,gp='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',an,ll,Mn,el,Cp="At the end of the notebook, you will:",pn,tl,Bp="<li>Be able to use <strong>Gymnasium</strong>, the environment library.</li> <li>Be able to code a Q-Learning agent from scratch.</li> <li>Be able to <strong>push your trained agent and the code to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",on,sl,rn,nl,vp,yn,al,Gp="In this free course, you will:",Jn,Ml,Zp="<li>📖 Study Deep Reinforcement Learning in <strong>theory and practice</strong>.</li> <li>🧑‍💻 Learn to <strong>use famous Deep RL libraries</strong> such as Stable Baselines3, RL Baselines3 Zoo, CleanRL and Sample Factory 2.0.</li> <li>🤖 Train <strong>agents in unique environments</strong></li>",wn,il,Ap='And more check 📚 the syllabus 👉 <a href="https://simoninithomas.github.io/deep-rl-course" rel="nofollow">https://simoninithomas.github.io/deep-rl-course</a>',Tn,pl,Wp='Don’t forget to <strong><a href="http://eepurl.com/ic5ZUD">sign up to the course</a></strong> (we are collecting your email to be able to <strong>send you the links when each Unit is published and give you information about the challenges and updates).</strong>',mn,ol,kp='The best way to keep in touch is to join our discord server to exchange with the community and with us 👉🏻 <a href="https://discord.gg/ydHrjt3WP5" rel="nofollow">https://discord.gg/ydHrjt3WP5</a>',jn,rl,Un,yl,_p="Before diving into the notebook, you need to:",un,Jl,$p='🔲 📚 <strong>Study <a href="https://huggingface.co/deep-rl-course/unit2/introduction" rel="nofollow">Q-Learning by reading Unit 2</a></strong>  🤗',cn,wl,hn,Tl,Qp="<em>Q-Learning</em> <strong>is the RL algorithm that</strong>:",dn,ml,Xp="<li><p>Trains <em>Q-Function</em>, an <strong>action-value function</strong> that is encoded, in internal memory, by a <em>Q-table</em> <strong>that contains all the state-action pair values.</strong></p></li> <li><p>Given a state and action, our Q-Function <strong>will search the Q-table for the corresponding value.</strong></p></li>",In,h,Ep,bn,jl,Yp=`<li><p>When the training is done, <strong>we have an optimal Q-Function, so an optimal Q-Table.</strong></p></li> <li><p>And if we <strong>have an optimal Q-function</strong>, we
have an optimal policy, since we <strong>know for each state, the best action to take.</strong></p></li>`,fn,d,xp,gn,Ul,Rp="But, in the beginning, our <strong>Q-Table is useless since it gives arbitrary value for each state-action pair (most of the time we initialize the Q-Table to 0 values)</strong>. But, as we’ll explore the environment and update our Q-Table it will give us better and better approximations",Cn,I,Sp,Bn,ul,Fp="This is the Q-Learning pseudocode:",vn,b,Vp,Gn,cl,Zn,hl,Hp='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained Taxi model to the Hub and <strong>get a result of &gt;= 4.5</strong>.',An,dl,Np='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Wn,Il,zp='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',kn,bl,_n,fl,qp="In the notebook, we’ll need to generate a replay video. To do so, with Colab, <strong>we need to have a virtual screen to render the environment</strong> (and thus record the frames).",$n,gl,Lp="Hence the following cell will install the libraries and create and run a virtual screen 🖥",Qn,Cl,Dp="We’ll install multiple ones:",Xn,Bl,Pp="<li><code>gymnasium</code>: Contains the FrozenLake-v1 ⛄ and Taxi-v3 🚕 environments.</li> <li><code>pygame</code>: Used for the FrozenLake-v1 and Taxi-v3 UI.</li> <li><code>numpy</code>: Used for handling our Q-table.</li>",En,vl,Kp="The Hugging Face Hub 🤗 works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations and other features that will allow you to easily collaborate with others.",Yn,Gl,Op='You can see here all the Deep RL models available (if they use Q Learning) here 👉 <a href="https://huggingface.co/models?other=q-learning" rel="nofollow">https://huggingface.co/models?other=q-learning</a>',xn,Zl,Rn,Al,Sn,Wl,lo="To make sure the new installed libraries are used, <strong>sometimes it’s required to restart the notebook runtime</strong>. The next cell will force the <strong>runtime to crash, so you’ll need to connect again and run the code starting from here</strong>. Thanks to this trick, <strong>we will be able to run our virtual screen.</strong>",Fn,kl,Vn,_l,Hn,$l,Nn,Ql,eo="In addition to the installed libraries, we also use:",zn,Xl,to="<li><code>random</code>: To generate random numbers (that will be useful for epsilon-greedy policy).</li> <li><code>imageio</code>: To generate a replay video.</li>",qn,El,Ln,Yl,so="We’re now ready to code our Q-Learning algorithm 🔥",Dn,xl,Pn,Rl,Kn,On,la,Sl,no="💡 A good habit when you start to use an environment is to check its documentation",ea,Fl,ao='👉 <a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">https://gymnasium.farama.org/environments/toy_text/frozen_lake/</a>',ta,sa,na,Vl,Mo="We’re going to train our Q-Learning agent <strong>to navigate from the starting state (S) to the goal state (G) by walking only on frozen tiles (F) and avoid holes (H)</strong>.",aa,Hl,io="We can have two sizes of environment:",Ma,Nl,po="<li><code>map_name=&quot;4x4&quot;</code>: a 4x4 grid version</li> <li><code>map_name=&quot;8x8&quot;</code>: a 8x8 grid version</li>",ia,zl,oo="The environment has two modes:",pa,ql,ro="<li><code>is_slippery=False</code>: The agent always moves <strong>in the intended direction</strong> due to the non-slippery nature of the frozen lake (deterministic).</li> <li><code>is_slippery=True</code>: The agent <strong>may not always move in the intended direction</strong> due to the slippery nature of the frozen lake (stochastic).</li>",oa,Ll,yo=`For now let’s keep it simple with the 4x4 map and non-slippery.
We add a parameter called <code>render_mode</code> that specifies how the environment should be visualised. In our case because we <strong>want to record a video of the environment at the end, we need to set render_mode to rgb_array</strong>.`,ra,Dl,Jo='As <a href="https://gymnasium.farama.org/api/env/#gymnasium.Env.render" rel="nofollow">explained in the documentation</a> “rgb_array”: Return a single frame representing the current state of the environment. A frame is a np.ndarray with shape (x, y, 3) representing RGB values for an x-by-y pixel image.',ya,Pl,Ja,Kl,wa,Ol,Ta,le,wo="You can create your own custom grid like this:",ma,ee,ja,te,To="but we’ll use the default environment for now.",Ua,se,ua,ne,ca,ae,mo="We see with <code>Observation Space Shape Discrete(16)</code> that the observation is an integer representing the <strong>agent’s current position as current_row * ncols + current_col (where both the row and col start at 0)</strong>.",ha,Me,jo="For example, the goal position in the 4x4 map can be calculated as follows: 3 * 4 + 3 = 15. The number of possible observations is dependent on the size of the map. <strong>For example, the 4x4 map has 16 possible observations.</strong>",da,ie,Uo="For instance, this is what state = 0 looks like:",Ia,pe,uo,ba,oe,fa,re,co="The action space (the set of possible actions the agent can take) is discrete with 4 actions available 🎮:",ga,ye,ho="<li>0: GO LEFT</li> <li>1: GO DOWN</li> <li>2: GO RIGHT</li> <li>3: GO UP</li>",Ca,Je,Io="Reward function 💰:",Ba,we,bo="<li>Reach goal: +1</li> <li>Reach hole: 0</li> <li>Reach frozen: 0</li>",va,Te,Ga,me,fo="(👀 Step 1 of the pseudocode)",Za,f,go,Aa,je,Co="It’s time to initialize our Q-table! To know how many rows (states) and columns (actions) to use, we need to know the action and observation space. We already know their values from before, but we’ll want to obtain them programmatically so that our algorithm generalizes for different environments. Gym provides us a way to do that: <code>env.action_space.n</code> and <code>env.observation_space.n</code>",Wa,Ue,ka,ue,_a,ce,$a,he,Qa,de,Xa,Ie,Ea,be,Ya,fe,xa,ge,Bo="Remember we have two policies since Q-Learning is an <strong>off-policy</strong> algorithm. This means we’re using a <strong>different policy for acting and updating the value function</strong>.",Ra,Ce,vo="<li>Epsilon-greedy policy (acting policy)</li> <li>Greedy-policy (updating policy)</li>",Sa,Be,Go="The greedy policy will also be the final policy we’ll have when the Q-learning agent completes training. The greedy policy is used to select an action using the Q-table.",Fa,g,Zo,Va,ve,Ha,Ge,Na,Ze,za,Ae,qa,We,Ao="Epsilon-greedy is the training policy that handles the exploration/exploitation trade-off.",La,ke,Wo="The idea with epsilon-greedy:",Da,_e,ko="<li><p>With <em>probability 1 - ɛ</em> : <strong>we do exploitation</strong> (i.e. our agent selects the action with the highest state-action pair value).</p></li> <li><p>With <em>probability ɛ</em>: we do <strong>exploration</strong> (trying a random action).</p></li>",Pa,$e,_o="As the training continues, we progressively <strong>reduce the epsilon value since we will need less and less exploration and more exploitation.</strong>",Ka,C,$o,Oa,Qe,lM,Xe,eM,Ee,tM,Ye,sM,xe,Qo="The exploration related hyperparamters are some of the most important ones.",nM,Re,Xo="<li>We need to make sure that our agent <strong>explores enough of the state space</strong> to learn a good value approximation. To do that, we need to have progressive decay of the epsilon.</li> <li>If you decrease epsilon too fast (too high decay_rate), <strong>you take the risk that your agent will be stuck</strong>, since your agent didn’t explore enough of the state space and hence can’t solve the problem.</li>",aM,Se,MM,Fe,iM,B,Eo,pM,Ve,Yo="The training loop goes like this:",oM,He,rM,Ne,yM,ze,JM,qe,wM,Le,TM,De,mM,Pe,jM,Ke,UM,Oe,uM,lt,xo="<li>We defined the evaluation method that we’re going to use to test our Q-Learning agent.</li>",cM,et,hM,tt,dM,st,Ro='<li>Usually, you should have a mean reward of 1.0</li> <li>The <strong>environment is relatively easy</strong> since the state space is really small (16). What you can try to do is <a href="https://www.gymlibrary.dev/environments/toy_text/frozen_lake/" rel="nofollow">to replace it with the slippery version</a>, which introduces stochasticity, making the environment more complex.</li>',IM,nt,bM,at,fM,Mt,So="Now that we saw good results after the training, <strong>we can publish our trained model to the Hub 🤗 with one line of code</strong>.",gM,it,Fo="Here’s an example of a Model Card:",CM,v,Vo,BM,pt,Ho="Under the hood, the Hub uses git-based repositories (don’t worry if you don’t know what git is), which means you can update the model with new versions as you experiment and improve your agent.",vM,ot,GM,rt,ZM,yt,AM,Jt,WM,wt,kM,Tt,No="By using <code>push_to_hub</code> <strong>you evaluate, record a replay, generate a model card of your agent and push it to the Hub</strong>.",_M,mt,zo="This way:",$M,jt,qo='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share an agent with the community that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',QM,Ut,Lo="To be able to share your model with the community there are three more steps to follow:",XM,ut,Do='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',EM,ct,Po="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",YM,ht,Ko='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',xM,dt,Oo,RM,It,SM,bt,lr="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code> (or <code>login</code>)",FM,ft,er="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>push_to_hub()</code> function",VM,gt,tr="<li>Let’s create <strong>the model dictionary that contains the hyperparameters and the Q_table</strong>.</li>",HM,Ct,NM,Bt,sr="Let’s fill the <code>push_to_hub</code> function:",zM,vt,nr=`<li><code>repo_id</code>: the name of the Hugging Face Hub Repository that will be created/updated <code>(repo_id = {username}/{repo_name})</code>
💡 A good <code>repo_id</code> is <code>{username}/q-{env_id}</code></li> <li><code>model</code>: our model dictionary containing the hyperparameters and the Qtable.</li> <li><code>env</code>: the environment.</li> <li><code>commit_message</code>: message of the commit</li>`,qM,Gt,LM,Zt,DM,At,ar=`Congrats 🥳 you’ve just implemented from scratch, trained, and uploaded your first Reinforcement Learning agent.
FrozenLake-v1 no_slippery is very simple environment, let’s try a harder one 🔥.`,PM,Wt,KM,kt,OM,li,ei,_t,Mr="💡 A good habit when you start to use an environment is to check its documentation",ti,$t,ir='👉 <a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">https://gymnasium.farama.org/environments/toy_text/taxi/</a>',si,ni,ai,Qt,pr="In <code>Taxi-v3</code> 🚕, there are four designated locations in the grid world indicated by R(ed), G(reen), Y(ellow), and B(lue).",Mi,Xt,or="When the episode starts, <strong>the taxi starts off at a random square</strong> and the passenger is at a random location. The taxi drives to the passenger’s location, <strong>picks up the passenger</strong>, drives to the passenger’s destination (another one of the four specified locations), and then <strong>drops off the passenger</strong>. Once the passenger is dropped off, the episode ends.",ii,Et,rr,pi,Yt,oi,xt,yr="There are <strong>500 discrete states since there are 25 taxi positions, 5 possible locations of the passenger</strong> (including the case when the passenger is in the taxi), and <strong>4 destination locations.</strong>",ri,Rt,yi,St,Ji,Ft,Jr="The action space (the set of possible actions the agent can take) is discrete with <strong>6 actions available 🎮</strong>:",wi,Vt,wr="<li>0: move south</li> <li>1: move north</li> <li>2: move east</li> <li>3: move west</li> <li>4: pickup passenger</li> <li>5: drop off passenger</li>",Ti,Ht,Tr="Reward function 💰:",mi,Nt,mr="<li>-1 per step unless other reward is triggered.</li> <li>+20 delivering passenger.</li> <li>-10 executing “pickup” and “drop-off” actions illegally.</li>",ji,zt,Ui,qt,ui,Lt,jr="⚠ DO NOT MODIFY EVAL_SEED: the eval_seed array <strong>allows us to evaluate your agent with the same taxi starting positions for every classmate</strong>",ci,Dt,hi,Pt,di,Kt,Ii,Ot,bi,ls,Ur="<li>We create a model dictionary that will contain all the training hyperparameters for reproducibility and the Q-Table.</li>",fi,es,gi,ts,Ci,ss,ur='Now that it’s on the Hub, you can compare the results of your Taxi-v3 with your classmates using the leaderboard 🏆 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a>',Bi,ns,cr,vi,as,Gi,Ms,hr="What’s amazing with Hugging Face Hub 🤗 is that you can easily load powerful models from the community.",Zi,is,dr="Loading a saved model from the Hub is really easy:",Ai,ps,Ir='<li>You go <a href="https://huggingface.co/models?other=q-learning" rel="nofollow">https://huggingface.co/models?other=q-learning</a> to see the list of all the q-learning saved models.</li> <li>You select one and copy its repo_id</li>',Wi,os,br,ki,G,fr="<li>Then we just need to use <code>load_from_hub</code> with:</li>",_i,rs,gr="<li>The repo_id</li> <li>The filename: the saved model inside the repo.</li>",$i,ys,Qi,Js,Xi,ws,Ei,Ts,Yi,ms,xi,js,Ri,Us,Cr="The best way to learn <strong>is to try things on your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. With 1,000,000 steps, we saw some great results!",Si,us,Br='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',Fi,cs,vr="Here are some ideas to climb up the leaderboard:",Vi,hs,Gr="<li>Train more steps</li> <li>Try different hyperparameters by looking at what your classmates have done.</li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li>",Hi,ds,Zr='Are walking on ice and driving taxis too boring to you? Try to <strong>change the environment</strong>, why not use FrozenLake-v1 slippery version? Check how they work <a href="https://gymnasium.farama.org/" rel="nofollow">using the gymnasium documentation</a> and have fun 🎉.',Ni,zi,qi,Is,Ar="Congrats 🥳, you’ve just implemented, trained, and uploaded your first Reinforcement Learning agent.",Li,bs,Wr="Understanding Q-Learning is an <strong>important step to understanding value-based methods.</strong>",Di,fs,kr="In the next Unit with Deep Q-Learning, we’ll see that while creating and updating a Q-table was a good strategy — <strong>however, it is not scalable.</strong>",Pi,gs,_r="For instance, imagine you create an agent that learns to play Doom.",Ki,Cs,$r,Oi,Bs,Qr="Doom is a large environment with a huge state space (millions of different states). Creating and updating a Q-table for that environment would not be efficient.",lp,vs,Xr="That’s why we’ll study Deep Q-Learning in the next unit, an algorithm <strong>where we use a neural network that approximates, given a state, the different Q-values for each action.</strong>",ep,Gs,Er,tp,Zs,Yr="See you in Unit 3! 🔥",sp,As,np,ks,ap;return Z=new U({props:{title:"Hands-on",local:"hands-on",headingTag:"h1"}}),A=new qr({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit2/unit2.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),V=new U({props:{title:"Unit 2: Q-Learning with FrozenLake-v1 ⛄ and Taxi-v3 🚕",local:"unit-2-q-learning-with-frozenlake-v1--and-taxi-v3-",headingTag:"h1"}}),L=new U({props:{title:"🎮 Environments:",local:"-environments",headingTag:"h3"}}),P=new U({props:{title:"📚 RL-Library:",local:"-rl-library",headingTag:"h3"}}),ll=new U({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),sl=new U({props:{title:"This notebook is from the Deep Reinforcement Learning Course",local:"this-notebook-is-from-the-deep-reinforcement-learning-course",headingTag:"h2"}}),rl=new U({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),wl=new U({props:{title:"A small recap of Q-Learning",local:"a-small-recap-of-q-learning",headingTag:"h2"}}),cl=new U({props:{title:"Let’s code our first Reinforcement Learning algorithm 🚀",local:"lets-code-our-first-reinforcement-learning-algorithm-",headingTag:"h1"}}),bl=new U({props:{title:"Install dependencies and create a virtual display 🔽",local:"install-dependencies-and-create-a-virtual-display-",headingTag:"h2"}}),Zl=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkZWVwLXJsLWNsYXNzJTJGbWFpbiUyRm5vdGVib29rcyUyRnVuaXQyJTJGcmVxdWlyZW1lbnRzLXVuaXQyLnR4dA==",highlighted:"pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit2/requirements-unit2.txt",wrap:!1}}),Al=new j({props:{code:"c3VkbyUyMGFwdC1nZXQlMjB1cGRhdGUlMEFzdWRvJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMHB5dGhvbjMtb3BlbmdsJTBBYXB0JTIwaW5zdGFsbCUyMGZmbXBlZyUyMHh2ZmIlMEFwaXAzJTIwaW5zdGFsbCUyMHB5dmlydHVhbGRpc3BsYXk=",highlighted:`sudo apt-get update
sudo apt-get install -y python3-opengl
apt install ffmpeg xvfb
pip3 install pyvirtualdisplay`,wrap:!1}}),kl=new j({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5raWxsKG9zLmdldHBpZCgpJTJDJTIwOSk=",highlighted:`<span class="hljs-keyword">import</span> os

os.kill(os.getpid(), <span class="hljs-number">9</span>)`,wrap:!1}}),_l=new j({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),$l=new U({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),El=new j({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3ltbmFzaXVtJTIwYXMlMjBneW0lMEFpbXBvcnQlMjByYW5kb20lMEFpbXBvcnQlMjBpbWFnZWlvJTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0cWRtJTBBJTBBaW1wb3J0JTIwcGlja2xlNSUyMGFzJTIwcGlja2xlJTBBZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRt",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">import</span> pickle5 <span class="hljs-keyword">as</span> pickle
<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),xl=new U({props:{title:"Part 1: Frozen Lake ⛄ (non slippery version)",local:"part-1-frozen-lake--non-slippery-version",headingTag:"h1"}}),Rl=new U({props:{title:"Create and understand FrozenLake environment ⛄ (( https://gymnasium.farama.org/environments/toy_text/frozen_lake/ )",local:"create-and-understand-frozenlake-environment---httpsgymnasiumfaramaorgenvironmentstoytextfrozenlake-",headingTag:"h2"}}),Pl=new j({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwRnJvemVuTGFrZS12MSUyMGVudmlyb25tZW50JTIwdXNpbmclMjA0eDQlMjBtYXAlMjBhbmQlMjBub24tc2xpcHBlcnklMjB2ZXJzaW9uJTIwYW5kJTIwcmVuZGVyX21vZGUlM0QlMjJyZ2JfYXJyYXklMjIlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSgpJTIwJTIwJTIzJTIwVE9ETyUyMHVzZSUyMHRoZSUyMGNvcnJlY3QlMjBwYXJhbWV0ZXJz",highlighted:`<span class="hljs-comment"># Create the FrozenLake-v1 environment using 4x4 map and non-slippery version and render_mode=&quot;rgb_array&quot;</span>
env = gym.make()  <span class="hljs-comment"># TODO use the correct parameters</span>`,wrap:!1}}),Kl=new U({props:{title:"Solution",local:"solution",headingTag:"h3"}}),Ol=new j({props:{code:"ZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyRnJvemVuTGFrZS12MSUyMiUyQyUyMG1hcF9uYW1lJTNEJTIyNHg0JTIyJTJDJTIwaXNfc2xpcHBlcnklM0RGYWxzZSUyQyUyMHJlbmRlcl9tb2RlJTNEJTIycmdiX2FycmF5JTIyKQ==",highlighted:'env = gym.make(<span class="hljs-string">&quot;FrozenLake-v1&quot;</span>, map_name=<span class="hljs-string">&quot;4x4&quot;</span>, is_slippery=<span class="hljs-literal">False</span>, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)',wrap:!1}}),ee=new j({props:{code:"ZGVzYyUzRCU1QiUyMlNGRkYlMjIlMkMlMjAlMjJGSEZIJTIyJTJDJTIwJTIyRkZGSCUyMiUyQyUyMCUyMkhGRkclMjIlNUQlMEFneW0ubWFrZSgnRnJvemVuTGFrZS12MSclMkMlMjBkZXNjJTNEZGVzYyUyQyUyMGlzX3NsaXBwZXJ5JTNEVHJ1ZSk=",highlighted:`desc=[<span class="hljs-string">&quot;SFFF&quot;</span>, <span class="hljs-string">&quot;FHFH&quot;</span>, <span class="hljs-string">&quot;FFFH&quot;</span>, <span class="hljs-string">&quot;HFFG&quot;</span>]
gym.make(<span class="hljs-string">&#x27;FrozenLake-v1&#x27;</span>, desc=desc, is_slippery=<span class="hljs-literal">True</span>)`,wrap:!1}}),se=new U({props:{title:"Let’s see what the Environment looks like:",local:"lets-see-what-the-environment-looks-like",headingTag:"h3"}}),ne=new j({props:{code:"JTIzJTIwV2UlMjBjcmVhdGUlMjBvdXIlMjBlbnZpcm9ubWVudCUyMHdpdGglMjBneW0ubWFrZSglMjIlM0NuYW1lX29mX3RoZV9lbnZpcm9ubWVudCUzRSUyMiktJTIwJTYwaXNfc2xpcHBlcnklM0RGYWxzZSU2MCUzQSUyMFRoZSUyMGFnZW50JTIwYWx3YXlzJTIwbW92ZXMlMjBpbiUyMHRoZSUyMGludGVuZGVkJTIwZGlyZWN0aW9uJTIwZHVlJTIwdG8lMjB0aGUlMjBub24tc2xpcHBlcnklMjBuYXR1cmUlMjBvZiUyMHRoZSUyMGZyb3plbiUyMGxha2UlMjAoZGV0ZXJtaW5pc3RpYykuJTBBcHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMk9ic2VydmF0aW9uJTIwU3BhY2UlMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2UpJTBBcHJpbnQoJTIyU2FtcGxlJTIwb2JzZXJ2YXRpb24lMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwR2V0JTIwYSUyMHJhbmRvbSUyMG9ic2VydmF0aW9u",highlighted:`<span class="hljs-comment"># We create our environment with gym.make(&quot;&lt;name_of_the_environment&gt;&quot;)- \`is_slippery=False\`: The agent always moves in the intended direction due to the non-slippery nature of the frozen lake (deterministic).</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Observation Space&quot;</span>, env.observation_space)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),oe=new j({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyQWN0aW9uJTIwU3BhY2UlMjBTaGFwZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2UubiklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Shape&quot;</span>, env.action_space.n)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),Te=new U({props:{title:"Create and Initialize the Q-table 🗄️",local:"create-and-initialize-the-q-table-",headingTag:"h2"}}),Ue=new j({props:{code:"c3RhdGVfc3BhY2UlMjAlM0QlMEFwcmludCglMjJUaGVyZSUyMGFyZSUyMCUyMiUyQyUyMHN0YXRlX3NwYWNlJTJDJTIwJTIyJTIwcG9zc2libGUlMjBzdGF0ZXMlMjIpJTBBJTBBYWN0aW9uX3NwYWNlJTIwJTNEJTBBcHJpbnQoJTIyVGhlcmUlMjBhcmUlMjAlMjIlMkMlMjBhY3Rpb25fc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMGFjdGlvbnMlMjIp",highlighted:`state_space =
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, state_space, <span class="hljs-string">&quot; possible states&quot;</span>)

action_space =
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, action_space, <span class="hljs-string">&quot; possible actions&quot;</span>)`,wrap:!1}}),ue=new j({props:{code:"JTIzJTIwTGV0J3MlMjBjcmVhdGUlMjBvdXIlMjBRdGFibGUlMjBvZiUyMHNpemUlMjAoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2UpJTIwYW5kJTIwaW5pdGlhbGl6ZWQlMjBlYWNoJTIwdmFsdWVzJTIwYXQlMjAwJTIwdXNpbmclMjBucC56ZXJvcy4lMjBucC56ZXJvcyUyMG5lZWRzJTIwYSUyMHR1cGxlJTIwKGElMkNiKSUwQWRlZiUyMGluaXRpYWxpemVfcV90YWJsZShzdGF0ZV9zcGFjZSUyQyUyMGFjdGlvbl9zcGFjZSklM0ElMEElMjAlMjBRdGFibGUlMjAlM0QlMEElMjAlMjByZXR1cm4lMjBRdGFibGU=",highlighted:`<span class="hljs-comment"># Let&#x27;s create our Qtable of size (state_space, action_space) and initialized each values at 0 using np.zeros. np.zeros needs a tuple (a,b)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">initialize_q_table</span>(<span class="hljs-params">state_space, action_space</span>):
  Qtable =
  <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),ce=new j({props:{code:"UXRhYmxlX2Zyb3plbmxha2UlMjAlM0QlMjBpbml0aWFsaXplX3FfdGFibGUoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2Up",highlighted:"Qtable_frozenlake = initialize_q_table(state_space, action_space)",wrap:!1}}),he=new U({props:{title:"Solution",local:"solution",headingTag:"h3"}}),de=new j({props:{code:"c3RhdGVfc3BhY2UlMjAlM0QlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2UubiUwQXByaW50KCUyMlRoZXJlJTIwYXJlJTIwJTIyJTJDJTIwc3RhdGVfc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMHN0YXRlcyUyMiklMEElMEFhY3Rpb25fc3BhY2UlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4lMEFwcmludCglMjJUaGVyZSUyMGFyZSUyMCUyMiUyQyUyMGFjdGlvbl9zcGFjZSUyQyUyMCUyMiUyMHBvc3NpYmxlJTIwYWN0aW9ucyUyMik=",highlighted:`state_space = env.observation_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, state_space, <span class="hljs-string">&quot; possible states&quot;</span>)

action_space = env.action_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, action_space, <span class="hljs-string">&quot; possible actions&quot;</span>)`,wrap:!1}}),Ie=new j({props:{code:"JTIzJTIwTGV0J3MlMjBjcmVhdGUlMjBvdXIlMjBRdGFibGUlMjBvZiUyMHNpemUlMjAoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2UpJTIwYW5kJTIwaW5pdGlhbGl6ZWQlMjBlYWNoJTIwdmFsdWVzJTIwYXQlMjAwJTIwdXNpbmclMjBucC56ZXJvcyUwQWRlZiUyMGluaXRpYWxpemVfcV90YWJsZShzdGF0ZV9zcGFjZSUyQyUyMGFjdGlvbl9zcGFjZSklM0ElMEElMjAlMjAlMjAlMjBRdGFibGUlMjAlM0QlMjBucC56ZXJvcygoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2UpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFF0YWJsZQ==",highlighted:`<span class="hljs-comment"># Let&#x27;s create our Qtable of size (state_space, action_space) and initialized each values at 0 using np.zeros</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">initialize_q_table</span>(<span class="hljs-params">state_space, action_space</span>):
    Qtable = np.zeros((state_space, action_space))
    <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),be=new j({props:{code:"UXRhYmxlX2Zyb3plbmxha2UlMjAlM0QlMjBpbml0aWFsaXplX3FfdGFibGUoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2Up",highlighted:"Qtable_frozenlake = initialize_q_table(state_space, action_space)",wrap:!1}}),fe=new U({props:{title:"Define the greedy policy 🤖",local:"define-the-greedy-policy-",headingTag:"h2"}}),ve=new j({props:{code:"ZGVmJTIwZ3JlZWR5X3BvbGljeShRdGFibGUlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjMlMjBFeHBsb2l0YXRpb24lM0ElMjB0YWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjBzdGF0ZSUyQyUyMGFjdGlvbiUyMHZhbHVlJTBBJTIwJTIwYWN0aW9uJTIwJTNEJTBBJTBBJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_policy</span>(<span class="hljs-params">Qtable, state</span>):
  <span class="hljs-comment"># Exploitation: take the action with the highest state, action value</span>
  action =

  <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ge=new U({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Ze=new j({props:{code:"ZGVmJTIwZ3JlZWR5X3BvbGljeShRdGFibGUlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBFeHBsb2l0YXRpb24lM0ElMjB0YWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjBzdGF0ZSUyQyUyMGFjdGlvbiUyMHZhbHVlJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwbnAuYXJnbWF4KFF0YWJsZSU1QnN0YXRlJTVEJTVCJTNBJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_policy</span>(<span class="hljs-params">Qtable, state</span>):
    <span class="hljs-comment"># Exploitation: take the action with the highest state, action value</span>
    action = np.argmax(Qtable[state][:])

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ae=new U({props:{title:"Define the epsilon-greedy policy 🤖",local:"define-the-epsilon-greedy-policy-",headingTag:"h2"}}),Qe=new j({props:{code:"ZGVmJTIwZXBzaWxvbl9ncmVlZHlfcG9saWN5KFF0YWJsZSUyQyUyMHN0YXRlJTJDJTIwZXBzaWxvbiklM0ElMEElMjAlMjAlMjMlMjBSYW5kb21seSUyMGdlbmVyYXRlJTIwYSUyMG51bWJlciUyMGJldHdlZW4lMjAwJTIwYW5kJTIwMSUwQSUyMCUyMHJhbmRvbV9udW0lMjAlM0QlMEElMjAlMjAlMjMlMjBpZiUyMHJhbmRvbV9udW0lMjAlM0UlMjBncmVhdGVyJTIwdGhhbiUyMGVwc2lsb24lMjAtLSUzRSUyMGV4cGxvaXRhdGlvbiUwQSUyMCUyMGlmJTIwcmFuZG9tX251bSUyMCUzRSUyMGVwc2lsb24lM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjB2YWx1ZSUyMGdpdmVuJTIwYSUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTIzJTIwbnAuYXJnbWF4JTIwY2FuJTIwYmUlMjB1c2VmdWwlMjBoZXJlJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTBBJTIwJTIwJTIzJTIwZWxzZSUyMC0tJTNFJTIwZXhwbG9yYXRpb24lMEElMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24lMEElMEElMjAlMjByZXR1cm4lMjBhY3Rpb24=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">epsilon_greedy_policy</span>(<span class="hljs-params">Qtable, state, epsilon</span>):
  <span class="hljs-comment"># Randomly generate a number between 0 and 1</span>
  random_num =
  <span class="hljs-comment"># if random_num &gt; greater than epsilon --&gt; exploitation</span>
  <span class="hljs-keyword">if</span> random_num &gt; epsilon:
    <span class="hljs-comment"># Take the action with the highest value given a state</span>
    <span class="hljs-comment"># np.argmax can be useful here</span>
    action =
  <span class="hljs-comment"># else --&gt; exploration</span>
  <span class="hljs-keyword">else</span>:
    action = <span class="hljs-comment"># Take a random action</span>

  <span class="hljs-keyword">return</span> action`,wrap:!1}}),Xe=new U({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Ee=new j({props:{code:"ZGVmJTIwZXBzaWxvbl9ncmVlZHlfcG9saWN5KFF0YWJsZSUyQyUyMHN0YXRlJTJDJTIwZXBzaWxvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSYW5kb21seSUyMGdlbmVyYXRlJTIwYSUyMG51bWJlciUyMGJldHdlZW4lMjAwJTIwYW5kJTIwMSUwQSUyMCUyMCUyMCUyMHJhbmRvbV9udW0lMjAlM0QlMjByYW5kb20udW5pZm9ybSgwJTJDJTIwMSklMEElMjAlMjAlMjAlMjAlMjMlMjBpZiUyMHJhbmRvbV9udW0lMjAlM0UlMjBncmVhdGVyJTIwdGhhbiUyMGVwc2lsb24lMjAtLSUzRSUyMGV4cGxvaXRhdGlvbiUwQSUyMCUyMCUyMCUyMGlmJTIwcmFuZG9tX251bSUyMCUzRSUyMGVwc2lsb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjB2YWx1ZSUyMGdpdmVuJTIwYSUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbnAuYXJnbWF4JTIwY2FuJTIwYmUlMjB1c2VmdWwlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwZ3JlZWR5X3BvbGljeShRdGFibGUlMkMlMjBzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjMlMjBlbHNlJTIwLS0lM0UlMjBleHBsb3JhdGlvbiUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLnNhbXBsZSgpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">epsilon_greedy_policy</span>(<span class="hljs-params">Qtable, state, epsilon</span>):
    <span class="hljs-comment"># Randomly generate a number between 0 and 1</span>
    random_num = random.uniform(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-comment"># if random_num &gt; greater than epsilon --&gt; exploitation</span>
    <span class="hljs-keyword">if</span> random_num &gt; epsilon:
        <span class="hljs-comment"># Take the action with the highest value given a state</span>
        <span class="hljs-comment"># np.argmax can be useful here</span>
        action = greedy_policy(Qtable, state)
    <span class="hljs-comment"># else --&gt; exploration</span>
    <span class="hljs-keyword">else</span>:
        action = env.action_space.sample()

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ye=new U({props:{title:"Define the hyperparameters ⚙️",local:"define-the-hyperparameters-",headingTag:"h2"}}),Se=new j({props:{code:"JTIzJTIwVHJhaW5pbmclMjBwYXJhbWV0ZXJzJTBBbl90cmFpbmluZ19lcGlzb2RlcyUyMCUzRCUyMDEwMDAwJTIwJTIwJTIzJTIwVG90YWwlMjB0cmFpbmluZyUyMGVwaXNvZGVzJTBBbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDAuNyUyMCUyMCUyMyUyMExlYXJuaW5nJTIwcmF0ZSUwQSUwQSUyMyUyMEV2YWx1YXRpb24lMjBwYXJhbWV0ZXJzJTBBbl9ldmFsX2VwaXNvZGVzJTIwJTNEJTIwMTAwJTIwJTIwJTIzJTIwVG90YWwlMjBudW1iZXIlMjBvZiUyMHRlc3QlMjBlcGlzb2RlcyUwQSUwQSUyMyUyMEVudmlyb25tZW50JTIwcGFyYW1ldGVycyUwQWVudl9pZCUyMCUzRCUyMCUyMkZyb3plbkxha2UtdjElMjIlMjAlMjAlMjMlMjBOYW1lJTIwb2YlMjB0aGUlMjBlbnZpcm9ubWVudCUwQW1heF9zdGVwcyUyMCUzRCUyMDk5JTIwJTIwJTIzJTIwTWF4JTIwc3RlcHMlMjBwZXIlMjBlcGlzb2RlJTBBZ2FtbWElMjAlM0QlMjAwLjk1JTIwJTIwJTIzJTIwRGlzY291bnRpbmclMjByYXRlJTBBZXZhbF9zZWVkJTIwJTNEJTIwJTVCJTVEJTIwJTIwJTIzJTIwVGhlJTIwZXZhbHVhdGlvbiUyMHNlZWQlMjBvZiUyMHRoZSUyMGVudmlyb25tZW50JTBBJTBBJTIzJTIwRXhwbG9yYXRpb24lMjBwYXJhbWV0ZXJzJTBBbWF4X2Vwc2lsb24lMjAlM0QlMjAxLjAlMjAlMjAlMjMlMjBFeHBsb3JhdGlvbiUyMHByb2JhYmlsaXR5JTIwYXQlMjBzdGFydCUwQW1pbl9lcHNpbG9uJTIwJTNEJTIwMC4wNSUyMCUyMCUyMyUyME1pbmltdW0lMjBleHBsb3JhdGlvbiUyMHByb2JhYmlsaXR5JTBBZGVjYXlfcmF0ZSUyMCUzRCUyMDAuMDAwNSUyMCUyMCUyMyUyMEV4cG9uZW50aWFsJTIwZGVjYXklMjByYXRlJTIwZm9yJTIwZXhwbG9yYXRpb24lMjBwcm9i",highlighted:`<span class="hljs-comment"># Training parameters</span>
n_training_episodes = <span class="hljs-number">10000</span>  <span class="hljs-comment"># Total training episodes</span>
learning_rate = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># Learning rate</span>

<span class="hljs-comment"># Evaluation parameters</span>
n_eval_episodes = <span class="hljs-number">100</span>  <span class="hljs-comment"># Total number of test episodes</span>

<span class="hljs-comment"># Environment parameters</span>
env_id = <span class="hljs-string">&quot;FrozenLake-v1&quot;</span>  <span class="hljs-comment"># Name of the environment</span>
max_steps = <span class="hljs-number">99</span>  <span class="hljs-comment"># Max steps per episode</span>
gamma = <span class="hljs-number">0.95</span>  <span class="hljs-comment"># Discounting rate</span>
eval_seed = []  <span class="hljs-comment"># The evaluation seed of the environment</span>

<span class="hljs-comment"># Exploration parameters</span>
max_epsilon = <span class="hljs-number">1.0</span>  <span class="hljs-comment"># Exploration probability at start</span>
min_epsilon = <span class="hljs-number">0.05</span>  <span class="hljs-comment"># Minimum exploration probability</span>
decay_rate = <span class="hljs-number">0.0005</span>  <span class="hljs-comment"># Exponential decay rate for exploration prob</span>`,wrap:!1}}),Fe=new U({props:{title:"Create the training loop method",local:"create-the-training-loop-method",headingTag:"h2"}}),He=new j({props:{code:"Rm9yJTIwZXBpc29kZSUyMGluJTIwdGhlJTIwdG90YWwlMjBvZiUyMHRyYWluaW5nJTIwZXBpc29kZXMlM0ElMEElMEFSZWR1Y2UlMjBlcHNpbG9uJTIwKHNpbmNlJTIwd2UlMjBuZWVkJTIwbGVzcyUyMGFuZCUyMGxlc3MlMjBleHBsb3JhdGlvbiklMEFSZXNldCUyMHRoZSUyMGVudmlyb25tZW50JTBBJTBBJTIwJTIwRm9yJTIwc3RlcCUyMGluJTIwbWF4JTIwdGltZXN0ZXBzJTNBJTBBJTIwJTIwJTIwJTIwQ2hvb3NlJTIwdGhlJTIwYWN0aW9uJTIwQXQlMjB1c2luZyUyMGVwc2lsb24lMjBncmVlZHklMjBwb2xpY3klMEElMjAlMjAlMjAlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGEpJTIwYW5kJTIwb2JzZXJ2ZSUyMHRoZSUyMG91dGNvbWUlMjBzdGF0ZShzJyklMjBhbmQlMjByZXdhcmQlMjAociklMEElMjAlMjAlMjAlMjBVcGRhdGUlMjB0aGUlMjBRLXZhbHVlJTIwUShzJTJDYSklMjB1c2luZyUyMEJlbGxtYW4lMjBlcXVhdGlvbiUyMFEocyUyQ2EpJTIwJTJCJTIwbHIlMjAlNUJSKHMlMkNhKSUyMCUyQiUyMGdhbW1hJTIwKiUyMG1heCUyMFEocyclMkNhJyklMjAtJTIwUShzJTJDYSklNUQlMEElMjAlMjAlMjAlMjBJZiUyMGRvbmUlMkMlMjBmaW5pc2glMjB0aGUlMjBlcGlzb2RlJTBBJTIwJTIwJTIwJTIwT3VyJTIwbmV4dCUyMHN0YXRlJTIwaXMlMjB0aGUlMjBuZXclMjBzdGF0ZQ==",highlighted:`For episode <span class="hljs-keyword">in</span> the total of training episodes:

Reduce epsilon (since we need less and less exploration)
Reset the environment

  For step <span class="hljs-keyword">in</span> <span class="hljs-keyword">max</span> timesteps:
    Choose the action At using epsilon greedy policy
    Take the action (a) and observe the outcome <span class="hljs-keyword">state</span>(s&#x27;) and reward (r)
    Update the Q-value Q(s,a) using Bellman equation Q(s,a) + lr [R(s,a) + gamma * <span class="hljs-keyword">max</span> Q(s&#x27;,a&#x27;) - Q(s,a)]
    If done, finish the episode
    Our next <span class="hljs-keyword">state</span> is the new <span class="hljs-keyword">state</span>`,wrap:!1}}),Ne=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train</span>(<span class="hljs-params">n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable</span>):
  <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(n_training_episodes)):
    <span class="hljs-comment"># Reduce epsilon (because we need less and less exploration)</span>
    epsilon = min_epsilon + (max_epsilon - min_epsilon)*np.exp(-decay_rate*episode)
    <span class="hljs-comment"># Reset the environment</span>
    state, info = env.reset()
    step = <span class="hljs-number">0</span>
    terminated = <span class="hljs-literal">False</span>
    truncated = <span class="hljs-literal">False</span>

    <span class="hljs-comment"># repeat</span>
    <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
      <span class="hljs-comment"># Choose the action At using epsilon greedy policy</span>
      action =

      <span class="hljs-comment"># Take action At and observe Rt+1 and St+1</span>
      <span class="hljs-comment"># Take the action (a) and observe the outcome state(s&#x27;) and reward (r)</span>
      new_state, reward, terminated, truncated, info =

      <span class="hljs-comment"># Update Q(s,a):= Q(s,a) + lr [R(s,a) + gamma * max Q(s&#x27;,a&#x27;) - Q(s,a)]</span>
      Qtable[state][action] =

      <span class="hljs-comment"># If terminated or truncated finish the episode</span>
      <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-keyword">break</span>

      <span class="hljs-comment"># Our next state is the new state</span>
      state = new_state
  <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),ze=new U({props:{title:"Solution",local:"solution",headingTag:"h4"}}),qe=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train</span>(<span class="hljs-params">n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable</span>):
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(n_training_episodes)):
        <span class="hljs-comment"># Reduce epsilon (because we need less and less exploration)</span>
        epsilon = min_epsilon + (max_epsilon - min_epsilon) * np.exp(-decay_rate * episode)
        <span class="hljs-comment"># Reset the environment</span>
        state, info = env.reset()
        step = <span class="hljs-number">0</span>
        terminated = <span class="hljs-literal">False</span>
        truncated = <span class="hljs-literal">False</span>

        <span class="hljs-comment"># repeat</span>
        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            <span class="hljs-comment"># Choose the action At using epsilon greedy policy</span>
            action = epsilon_greedy_policy(Qtable, state, epsilon)

            <span class="hljs-comment"># Take action At and observe Rt+1 and St+1</span>
            <span class="hljs-comment"># Take the action (a) and observe the outcome state(s&#x27;) and reward (r)</span>
            new_state, reward, terminated, truncated, info = env.step(action)

            <span class="hljs-comment"># Update Q(s,a):= Q(s,a) + lr [R(s,a) + gamma * max Q(s&#x27;,a&#x27;) - Q(s,a)]</span>
            Qtable[state][action] = Qtable[state][action] + learning_rate * (
                reward + gamma * np.<span class="hljs-built_in">max</span>(Qtable[new_state]) - Qtable[state][action]
            )

            <span class="hljs-comment"># If terminated or truncated finish the episode</span>
            <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
                <span class="hljs-keyword">break</span>

            <span class="hljs-comment"># Our next state is the new state</span>
            state = new_state
    <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),Le=new U({props:{title:"Train the Q-Learning agent 🏃",local:"train-the-q-learning-agent-",headingTag:"h2"}}),De=new j({props:{code:"UXRhYmxlX2Zyb3plbmxha2UlMjAlM0QlMjB0cmFpbihuX3RyYWluaW5nX2VwaXNvZGVzJTJDJTIwbWluX2Vwc2lsb24lMkMlMjBtYXhfZXBzaWxvbiUyQyUyMGRlY2F5X3JhdGUlMkMlMjBlbnYlMkMlMjBtYXhfc3RlcHMlMkMlMjBRdGFibGVfZnJvemVubGFrZSk=",highlighted:"Qtable_frozenlake = train(n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable_frozenlake)",wrap:!1}}),Pe=new U({props:{title:"Let’s see what our Q-Learning table looks like now 👀",local:"lets-see-what-our-q-learning-table-looks-like-now-",headingTag:"h2"}}),Ke=new j({props:{code:"UXRhYmxlX2Zyb3plbmxha2U=",highlighted:"Qtable_frozenlake",wrap:!1}}),Oe=new U({props:{title:"The evaluation method 📝",local:"the-evaluation-method-",headingTag:"h2"}}),et=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_agent</span>(<span class="hljs-params">env, max_steps, n_eval_episodes, Q, seed</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param Q: The Q-table
    :param seed: The evaluation seed array (for taxi-v3)
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(n_eval_episodes)):
        <span class="hljs-keyword">if</span> seed:
            state, info = env.reset(seed=seed[episode])
        <span class="hljs-keyword">else</span>:
            state, info = env.reset()
        step = <span class="hljs-number">0</span>
        truncated = <span class="hljs-literal">False</span>
        terminated = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
            action = greedy_policy(Q, state)
            new_state, reward, terminated, truncated, info = env.step(action)
            total_rewards_ep += reward

            <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward`,wrap:!1}}),tt=new U({props:{title:"Evaluate our Q-Learning agent 📈",local:"evaluate-our-q-learning-agent-",headingTag:"h2"}}),nt=new j({props:{code:"JTIzJTIwRXZhbHVhdGUlMjBvdXIlMjBBZ2VudCUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX2FnZW50KGVudiUyQyUyMG1heF9zdGVwcyUyQyUyMG5fZXZhbF9lcGlzb2RlcyUyQyUyMFF0YWJsZV9mcm96ZW5sYWtlJTJDJTIwZXZhbF9zZWVkKSUwQXByaW50KGYlMjJNZWFuX3Jld2FyZCUzRCU3Qm1lYW5fcmV3YXJkJTNBLjJmJTdEJTIwJTJCJTJGLSUyMCU3QnN0ZF9yZXdhcmQlM0EuMmYlN0QlMjIp",highlighted:`<span class="hljs-comment"># Evaluate our Agent</span>
mean_reward, std_reward = evaluate_agent(env, max_steps, n_eval_episodes, Qtable_frozenlake, eval_seed)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),at=new U({props:{title:"Publish our trained model to the Hub 🔥",local:"publish-our-trained-model-to-the-hub-",headingTag:"h2"}}),ot=new U({props:{title:"Do not modify this code",local:"do-not-modify-this-code",headingTag:"h4"}}),rt=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwc25hcHNob3RfZG93bmxvYWQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwbWV0YWRhdGFfZXZhbF9yZXN1bHQlMkMlMjBtZXRhZGF0YV9zYXZlJTBBJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, snapshot_download
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> json`,wrap:!1}}),yt=new j({props:{code:"ZGVmJTIwcmVjb3JkX3ZpZGVvKGVudiUyQyUyMFF0YWJsZSUyQyUyMG91dF9kaXJlY3RvcnklMkMlMjBmcHMlM0QxKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEdlbmVyYXRlJTIwYSUyMHJlcGxheSUyMHZpZGVvJTIwb2YlMjB0aGUlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZW52JTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjBRdGFibGUlM0ElMjBRdGFibGUlMjBvZiUyMG91ciUyMGFnZW50JTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjBvdXRfZGlyZWN0b3J5JTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjBmcHMlM0ElMjBob3clMjBtYW55JTIwZnJhbWUlMjBwZXIlMjBzZWNvbmRzJTIwKHdpdGglMjB0YXhpLXYzJTIwYW5kJTIwZnJvemVubGFrZS12MSUyMHdlJTIwdXNlJTIwMSklMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjB0ZXJtaW5hdGVkJTIwJTNEJTIwRmFsc2UlMEElMjAlMjAlMjAlMjB0cnVuY2F0ZWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMHN0YXRlJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5yZXNldChzZWVkJTNEcmFuZG9tLnJhbmRpbnQoMCUyQyUyMDUwMCkpJTBBJTIwJTIwJTIwJTIwaW1nJTIwJTNEJTIwZW52LnJlbmRlcigpJTBBJTIwJTIwJTIwJTIwaW1hZ2VzLmFwcGVuZChpbWcpJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBub3QlMjB0ZXJtaW5hdGVkJTIwb3IlMjB0cnVuY2F0ZWQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGluZGV4KSUyMHRoYXQlMjBoYXZlJTIwdGhlJTIwbWF4aW11bSUyMGV4cGVjdGVkJTIwZnV0dXJlJTIwcmV3YXJkJTIwZ2l2ZW4lMjB0aGF0JTIwc3RhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBucC5hcmdtYXgoUXRhYmxlJTVCc3RhdGUlNUQlNUIlM0ElNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMkMlMjByZXdhcmQlMkMlMjB0ZXJtaW5hdGVkJTJDJTIwdHJ1bmNhdGVkJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5zdGVwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMjAlMjAlMjMlMjBXZSUyMGRpcmVjdGx5JTIwcHV0JTIwbmV4dF9zdGF0ZSUyMCUzRCUyMHN0YXRlJTIwZm9yJTIwcmVjb3JkaW5nJTIwbG9naWMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWclMjAlM0QlMjBlbnYucmVuZGVyKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjBpbWFnZWlvLm1pbXNhdmUob3V0X2RpcmVjdG9yeSUyQyUyMCU1Qm5wLmFycmF5KGltZyklMjBmb3IlMjBpJTJDJTIwaW1nJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSU1RCUyQyUyMGZwcyUzRGZwcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, Qtable, out_directory, fps=<span class="hljs-number">1</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a replay video of the agent
    :param env
    :param Qtable: Qtable of our agent
    :param out_directory
    :param fps: how many frame per seconds (with taxi-v3 and frozenlake-v1 we use 1)
    &quot;&quot;&quot;</span>
    images = []
    terminated = <span class="hljs-literal">False</span>
    truncated = <span class="hljs-literal">False</span>
    state, info = env.reset(seed=random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">500</span>))
    img = env.render()
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action = np.argmax(Qtable[state][:])
        state, reward, terminated, truncated, info = env.step(
            action
        )  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render()
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)`,wrap:!1}}),Jt=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">repo_id, model, env, video_fps=<span class="hljs-number">1</span>, local_repo_path=<span class="hljs-string">&quot;hub&quot;</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate, Generate a video and Upload a model to Hugging Face Hub.
    This method does the complete pipeline:
    - It evaluates the model
    - It generates the model card
    - It generates a replay video of the agent
    - It pushes everything to the Hub

    :param repo_id: repo_id: id of the model repository from the Hugging Face Hub
    :param env
    :param video_fps: how many frame per seconds to record our video replay
    (with taxi-v3 and frozenlake-v1 we use 1)
    :param local_repo_path: where the local repository is
    &quot;&quot;&quot;</span>
    _, repo_name = repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)

    eval_env = env
    api = HfApi()

    <span class="hljs-comment"># Step 1: Create the repo</span>
    repo_url = api.create_repo(
        repo_id=repo_id,
        exist_ok=<span class="hljs-literal">True</span>,
    )

    <span class="hljs-comment"># Step 2: Download files</span>
    repo_local_path = Path(snapshot_download(repo_id=repo_id))

    <span class="hljs-comment"># Step 3: Save the model</span>
    <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>):
        model[<span class="hljs-string">&quot;map_name&quot;</span>] = env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>)
        <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;is_slippery&quot;</span>, <span class="hljs-string">&quot;&quot;</span>) == <span class="hljs-literal">False</span>:
            model[<span class="hljs-string">&quot;slippery&quot;</span>] = <span class="hljs-literal">False</span>

    <span class="hljs-comment"># Pickle the model</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>((repo_local_path) / <span class="hljs-string">&quot;q-learning.pkl&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        pickle.dump(model, f)

    <span class="hljs-comment"># Step 4: Evaluate the model and build JSON with evaluation metrics</span>
    mean_reward, std_reward = evaluate_agent(
        eval_env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>]
    )

    evaluate_data = {
        <span class="hljs-string">&quot;env_id&quot;</span>: model[<span class="hljs-string">&quot;env_id&quot;</span>],
        <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
        <span class="hljs-string">&quot;n_eval_episodes&quot;</span>: model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>],
        <span class="hljs-string">&quot;eval_datetime&quot;</span>: datetime.datetime.now().isoformat(),
    }

    <span class="hljs-comment"># Write a JSON file called &quot;results.json&quot; that will contain the</span>
    <span class="hljs-comment"># evaluation results</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(repo_local_path / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
        json.dump(evaluate_data, outfile)

    <span class="hljs-comment"># Step 5: Create the model card</span>
    env_name = model[<span class="hljs-string">&quot;env_id&quot;</span>]
    <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>):
        env_name += <span class="hljs-string">&quot;-&quot;</span> + env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>)

    <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;is_slippery&quot;</span>, <span class="hljs-string">&quot;&quot;</span>) == <span class="hljs-literal">False</span>:
        env_name += <span class="hljs-string">&quot;-&quot;</span> + <span class="hljs-string">&quot;no_slippery&quot;</span>

    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [env_name, <span class="hljs-string">&quot;q-learning&quot;</span>, <span class="hljs-string">&quot;reinforcement-learning&quot;</span>, <span class="hljs-string">&quot;custom-implementation&quot;</span>]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=repo_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_name,
        dataset_id=env_name,
    )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # **Q-Learning** Agent playing1 **<span class="hljs-subst">{env_id}</span>**
  This is a trained model of a **Q-Learning** agent playing **<span class="hljs-subst">{env_id}</span>** .

  ## Usage

  model = load_from_hub(repo_id=&quot;<span class="hljs-subst">{repo_id}</span>&quot;, filename=&quot;q-learning.pkl&quot;)

  # Don&#x27;t forget to check if you need to add additional attributes (is_slippery=False etc)
  env = gym.make(model[&quot;env_id&quot;])
  &quot;&quot;&quot;</span>

    evaluate_agent(env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>])

    readme_path = repo_local_path / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(readme_path.exists())
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
            readme = f.read()
    <span class="hljs-keyword">else</span>:
        readme = model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)

    <span class="hljs-comment"># Step 6: Record a video</span>
    video_path = repo_local_path / <span class="hljs-string">&quot;replay.mp4&quot;</span>
    record_video(env, model[<span class="hljs-string">&quot;qtable&quot;</span>], video_path, video_fps)

    <span class="hljs-comment"># Step 7. Push everything to the Hub</span>
    api.upload_folder(
        repo_id=repo_id,
        folder_path=repo_local_path,
        path_in_repo=<span class="hljs-string">&quot;.&quot;</span>,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Your model is pushed to the Hub. You can view your model here: &quot;</span>, repo_url)`,wrap:!1}}),wt=new U({props:{title:".",local:"",headingTag:"h3"}}),It=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ct=new j({props:{code:"bW9kZWwlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJtYXhfc3RlcHMlMjIlM0ElMjBtYXhfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwbl90cmFpbmluZ19lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbF9lcGlzb2RlcyUyMiUzQSUyMG5fZXZhbF9lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfc2VlZCUyMiUzQSUyMGV2YWxfc2VlZCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjBsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjBnYW1tYSUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9lcHNpbG9uJTIyJTNBJTIwbWF4X2Vwc2lsb24lMkMlMEElMjAlMjAlMjAlMjAlMjJtaW5fZXBzaWxvbiUyMiUzQSUyMG1pbl9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGVjYXlfcmF0ZSUyMiUzQSUyMGRlY2F5X3JhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjJxdGFibGUlMjIlM0ElMjBRdGFibGVfZnJvemVubGFrZSUyQyUwQSU3RA==",highlighted:`model = {
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;max_steps&quot;</span>: max_steps,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: n_training_episodes,
    <span class="hljs-string">&quot;n_eval_episodes&quot;</span>: n_eval_episodes,
    <span class="hljs-string">&quot;eval_seed&quot;</span>: eval_seed,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: learning_rate,
    <span class="hljs-string">&quot;gamma&quot;</span>: gamma,
    <span class="hljs-string">&quot;max_epsilon&quot;</span>: max_epsilon,
    <span class="hljs-string">&quot;min_epsilon&quot;</span>: min_epsilon,
    <span class="hljs-string">&quot;decay_rate&quot;</span>: decay_rate,
    <span class="hljs-string">&quot;qtable&quot;</span>: Qtable_frozenlake,
}`,wrap:!1}}),Gt=new j({props:{code:"bW9kZWw=",highlighted:"model",wrap:!1}}),Zt=new j({props:{code:"dXNlcm5hbWUlMjAlM0QlMjAlMjIlMjIlMjAlMjAlMjMlMjBGSUxMJTIwVEhJUyUwQXJlcG9fbmFtZSUyMCUzRCUyMCUyMnEtRnJvemVuTGFrZS12MS00eDQtbm9TbGlwcGVyeSUyMiUwQXB1c2hfdG9faHViKHJlcG9faWQlM0RmJTIyJTdCdXNlcm5hbWUlN0QlMkYlN0JyZXBvX25hbWUlN0QlMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZW52JTNEZW52KQ==",highlighted:`username = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># FILL THIS</span>
repo_name = <span class="hljs-string">&quot;q-FrozenLake-v1-4x4-noSlippery&quot;</span>
push_to_hub(repo_id=<span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{repo_name}</span>&quot;</span>, model=model, env=env)`,wrap:!1}}),Wt=new U({props:{title:"Part 2: Taxi-v3 🚖",local:"part-2-taxi-v3-",headingTag:"h1"}}),kt=new U({props:{title:"Create and understand Taxi-v3 🚕",local:"create-and-understand-taxi-v3-",headingTag:"h2"}}),Yt=new j({props:{code:"ZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyVGF4aS12MyUyMiUyQyUyMHJlbmRlcl9tb2RlJTNEJTIycmdiX2FycmF5JTIyKQ==",highlighted:'env = gym.make(<span class="hljs-string">&quot;Taxi-v3&quot;</span>, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)',wrap:!1}}),Rt=new j({props:{code:"c3RhdGVfc3BhY2UlMjAlM0QlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2UubiUwQXByaW50KCUyMlRoZXJlJTIwYXJlJTIwJTIyJTJDJTIwc3RhdGVfc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMHN0YXRlcyUyMik=",highlighted:`state_space = env.observation_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, state_space, <span class="hljs-string">&quot; possible states&quot;</span>)`,wrap:!1}}),St=new j({props:{code:"YWN0aW9uX3NwYWNlJTIwJTNEJTIwZW52LmFjdGlvbl9zcGFjZS5uJTBBcHJpbnQoJTIyVGhlcmUlMjBhcmUlMjAlMjIlMkMlMjBhY3Rpb25fc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMGFjdGlvbnMlMjIp",highlighted:`action_space = env.action_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, action_space, <span class="hljs-string">&quot; possible actions&quot;</span>)`,wrap:!1}}),zt=new j({props:{code:"JTIzJTIwQ3JlYXRlJTIwb3VyJTIwUSUyMHRhYmxlJTIwd2l0aCUyMHN0YXRlX3NpemUlMjByb3dzJTIwYW5kJTIwYWN0aW9uX3NpemUlMjBjb2x1bW5zJTIwKDUwMHg2KSUwQVF0YWJsZV90YXhpJTIwJTNEJTIwaW5pdGlhbGl6ZV9xX3RhYmxlKHN0YXRlX3NwYWNlJTJDJTIwYWN0aW9uX3NwYWNlKSUwQXByaW50KFF0YWJsZV90YXhpKSUwQXByaW50KCUyMlEtdGFibGUlMjBzaGFwZSUzQSUyMCUyMiUyQyUyMFF0YWJsZV90YXhpLnNoYXBlKQ==",highlighted:`<span class="hljs-comment"># Create our Q table with state_size rows and action_size columns (500x6)</span>
Qtable_taxi = initialize_q_table(state_space, action_space)
<span class="hljs-built_in">print</span>(Qtable_taxi)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Q-table shape: &quot;</span>, Qtable_taxi.shape)`,wrap:!1}}),qt=new U({props:{title:"Define the hyperparameters ⚙️",local:"define-the-hyperparameters-",headingTag:"h2"}}),Dt=new j({props:{code:"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",highlighted:`<span class="hljs-comment"># Training parameters</span>
n_training_episodes = <span class="hljs-number">25000</span>  <span class="hljs-comment"># Total training episodes</span>
learning_rate = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># Learning rate</span>

<span class="hljs-comment"># Evaluation parameters</span>
n_eval_episodes = <span class="hljs-number">100</span>  <span class="hljs-comment"># Total number of test episodes</span>

<span class="hljs-comment"># DO NOT MODIFY EVAL_SEED</span>
eval_seed = [
    <span class="hljs-number">16</span>,
    <span class="hljs-number">54</span>,
    <span class="hljs-number">165</span>,
    <span class="hljs-number">177</span>,
    <span class="hljs-number">191</span>,
    <span class="hljs-number">191</span>,
    <span class="hljs-number">120</span>,
    <span class="hljs-number">80</span>,
    <span class="hljs-number">149</span>,
    <span class="hljs-number">178</span>,
    <span class="hljs-number">48</span>,
    <span class="hljs-number">38</span>,
    <span class="hljs-number">6</span>,
    <span class="hljs-number">125</span>,
    <span class="hljs-number">174</span>,
    <span class="hljs-number">73</span>,
    <span class="hljs-number">50</span>,
    <span class="hljs-number">172</span>,
    <span class="hljs-number">100</span>,
    <span class="hljs-number">148</span>,
    <span class="hljs-number">146</span>,
    <span class="hljs-number">6</span>,
    <span class="hljs-number">25</span>,
    <span class="hljs-number">40</span>,
    <span class="hljs-number">68</span>,
    <span class="hljs-number">148</span>,
    <span class="hljs-number">49</span>,
    <span class="hljs-number">167</span>,
    <span class="hljs-number">9</span>,
    <span class="hljs-number">97</span>,
    <span class="hljs-number">164</span>,
    <span class="hljs-number">176</span>,
    <span class="hljs-number">61</span>,
    <span class="hljs-number">7</span>,
    <span class="hljs-number">54</span>,
    <span class="hljs-number">55</span>,
    <span class="hljs-number">161</span>,
    <span class="hljs-number">131</span>,
    <span class="hljs-number">184</span>,
    <span class="hljs-number">51</span>,
    <span class="hljs-number">170</span>,
    <span class="hljs-number">12</span>,
    <span class="hljs-number">120</span>,
    <span class="hljs-number">113</span>,
    <span class="hljs-number">95</span>,
    <span class="hljs-number">126</span>,
    <span class="hljs-number">51</span>,
    <span class="hljs-number">98</span>,
    <span class="hljs-number">36</span>,
    <span class="hljs-number">135</span>,
    <span class="hljs-number">54</span>,
    <span class="hljs-number">82</span>,
    <span class="hljs-number">45</span>,
    <span class="hljs-number">95</span>,
    <span class="hljs-number">89</span>,
    <span class="hljs-number">59</span>,
    <span class="hljs-number">95</span>,
    <span class="hljs-number">124</span>,
    <span class="hljs-number">9</span>,
    <span class="hljs-number">113</span>,
    <span class="hljs-number">58</span>,
    <span class="hljs-number">85</span>,
    <span class="hljs-number">51</span>,
    <span class="hljs-number">134</span>,
    <span class="hljs-number">121</span>,
    <span class="hljs-number">169</span>,
    <span class="hljs-number">105</span>,
    <span class="hljs-number">21</span>,
    <span class="hljs-number">30</span>,
    <span class="hljs-number">11</span>,
    <span class="hljs-number">50</span>,
    <span class="hljs-number">65</span>,
    <span class="hljs-number">12</span>,
    <span class="hljs-number">43</span>,
    <span class="hljs-number">82</span>,
    <span class="hljs-number">145</span>,
    <span class="hljs-number">152</span>,
    <span class="hljs-number">97</span>,
    <span class="hljs-number">106</span>,
    <span class="hljs-number">55</span>,
    <span class="hljs-number">31</span>,
    <span class="hljs-number">85</span>,
    <span class="hljs-number">38</span>,
    <span class="hljs-number">112</span>,
    <span class="hljs-number">102</span>,
    <span class="hljs-number">168</span>,
    <span class="hljs-number">123</span>,
    <span class="hljs-number">97</span>,
    <span class="hljs-number">21</span>,
    <span class="hljs-number">83</span>,
    <span class="hljs-number">158</span>,
    <span class="hljs-number">26</span>,
    <span class="hljs-number">80</span>,
    <span class="hljs-number">63</span>,
    <span class="hljs-number">5</span>,
    <span class="hljs-number">81</span>,
    <span class="hljs-number">32</span>,
    <span class="hljs-number">11</span>,
    <span class="hljs-number">28</span>,
    <span class="hljs-number">148</span>,
]  <span class="hljs-comment"># Evaluation seed, this ensures that all classmates agents are trained on the same taxi starting position</span>
<span class="hljs-comment"># Each seed has a specific starting state</span>

<span class="hljs-comment"># Environment parameters</span>
env_id = <span class="hljs-string">&quot;Taxi-v3&quot;</span>  <span class="hljs-comment"># Name of the environment</span>
max_steps = <span class="hljs-number">99</span>  <span class="hljs-comment"># Max steps per episode</span>
gamma = <span class="hljs-number">0.95</span>  <span class="hljs-comment"># Discounting rate</span>

<span class="hljs-comment"># Exploration parameters</span>
max_epsilon = <span class="hljs-number">1.0</span>  <span class="hljs-comment"># Exploration probability at start</span>
min_epsilon = <span class="hljs-number">0.05</span>  <span class="hljs-comment"># Minimum exploration probability</span>
decay_rate = <span class="hljs-number">0.005</span>  <span class="hljs-comment"># Exponential decay rate for exploration prob</span>`,wrap:!1}}),Pt=new U({props:{title:"Train our Q-Learning agent 🏃",local:"train-our-q-learning-agent-",headingTag:"h2"}}),Kt=new j({props:{code:"UXRhYmxlX3RheGklMjAlM0QlMjB0cmFpbihuX3RyYWluaW5nX2VwaXNvZGVzJTJDJTIwbWluX2Vwc2lsb24lMkMlMjBtYXhfZXBzaWxvbiUyQyUyMGRlY2F5X3JhdGUlMkMlMjBlbnYlMkMlMjBtYXhfc3RlcHMlMkMlMjBRdGFibGVfdGF4aSklMEFRdGFibGVfdGF4aQ==",highlighted:`Qtable_taxi = train(n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable_taxi)
Qtable_taxi`,wrap:!1}}),Ot=new U({props:{title:"Create a model dictionary 💾 and publish our trained model to the Hub 🔥",local:"create-a-model-dictionary--and-publish-our-trained-model-to-the-hub-",headingTag:"h2"}}),es=new j({props:{code:"bW9kZWwlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJtYXhfc3RlcHMlMjIlM0ElMjBtYXhfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwbl90cmFpbmluZ19lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbF9lcGlzb2RlcyUyMiUzQSUyMG5fZXZhbF9lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfc2VlZCUyMiUzQSUyMGV2YWxfc2VlZCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjBsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjBnYW1tYSUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9lcHNpbG9uJTIyJTNBJTIwbWF4X2Vwc2lsb24lMkMlMEElMjAlMjAlMjAlMjAlMjJtaW5fZXBzaWxvbiUyMiUzQSUyMG1pbl9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGVjYXlfcmF0ZSUyMiUzQSUyMGRlY2F5X3JhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjJxdGFibGUlMjIlM0ElMjBRdGFibGVfdGF4aSUyQyUwQSU3RA==",highlighted:`model = {
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;max_steps&quot;</span>: max_steps,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: n_training_episodes,
    <span class="hljs-string">&quot;n_eval_episodes&quot;</span>: n_eval_episodes,
    <span class="hljs-string">&quot;eval_seed&quot;</span>: eval_seed,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: learning_rate,
    <span class="hljs-string">&quot;gamma&quot;</span>: gamma,
    <span class="hljs-string">&quot;max_epsilon&quot;</span>: max_epsilon,
    <span class="hljs-string">&quot;min_epsilon&quot;</span>: min_epsilon,
    <span class="hljs-string">&quot;decay_rate&quot;</span>: decay_rate,
    <span class="hljs-string">&quot;qtable&quot;</span>: Qtable_taxi,
}`,wrap:!1}}),ts=new j({props:{code:"dXNlcm5hbWUlMjAlM0QlMjAlMjIlMjIlMjAlMjAlMjMlMjBGSUxMJTIwVEhJUyUwQXJlcG9fbmFtZSUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMEZJTEwlMjBUSElTJTBBcHVzaF90b19odWIocmVwb19pZCUzRGYlMjIlN0J1c2VybmFtZSU3RCUyRiU3QnJlcG9fbmFtZSU3RCUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBlbnYlM0RlbnYp",highlighted:`username = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># FILL THIS</span>
repo_name = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># FILL THIS</span>
push_to_hub(repo_id=<span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{repo_name}</span>&quot;</span>, model=model, env=env)`,wrap:!1}}),as=new U({props:{title:"Part 3: Load from Hub 🔽",local:"part-3-load-from-hub-",headingTag:"h1"}}),ys=new U({props:{title:"Do not modify this code",local:"do-not-modify-this-code",headingTag:"h4"}}),Js=new j({props:{code:"ZnJvbSUyMHVybGxpYi5lcnJvciUyMGltcG9ydCUyMEhUVFBFcnJvciUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEElMEElMEFkZWYlMjBsb2FkX2Zyb21faHViKHJlcG9faWQlM0ElMjBzdHIlMkMlMjBmaWxlbmFtZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwRG93bmxvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjByZXBvX2lkJTNBJTIwaWQlMjBvZiUyMHRoZSUyMG1vZGVsJTIwcmVwb3NpdG9yeSUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZmlsZW5hbWUlM0ElMjBuYW1lJTIwb2YlMjB0aGUlMjBtb2RlbCUyMHppcCUyMGZpbGUlMjBmcm9tJTIwdGhlJTIwcmVwb3NpdG9yeSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMHRoZSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1YiUyQyUyMGRvd25sb2FkJTIwYW5kJTIwY2FjaGUlMjB0aGUlMjBtb2RlbCUyMG9uJTIweW91ciUyMGxvY2FsJTIwZGlzayUwQSUyMCUyMCUyMCUyMHBpY2tsZV9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUpJTBBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4ocGlja2xlX21vZGVsJTJDJTIwJTIycmIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9tb2RlbF9maWxlJTIwJTNEJTIwcGlja2xlLmxvYWQoZiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkb3dubG9hZGVkX21vZGVsX2ZpbGU=",highlighted:`<span class="hljs-keyword">from</span> urllib.error <span class="hljs-keyword">import</span> HTTPError

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download


<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_from_hub</span>(<span class="hljs-params">repo_id: <span class="hljs-built_in">str</span>, filename: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Download a model from Hugging Face Hub.
    :param repo_id: id of the model repository from the Hugging Face Hub
    :param filename: name of the model zip file from the repository
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the model from the Hub, download and cache the model on your local disk</span>
    pickle_model = hf_hub_download(repo_id=repo_id, filename=filename)

    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(pickle_model, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
        downloaded_model_file = pickle.load(f)

    <span class="hljs-keyword">return</span> downloaded_model_file`,wrap:!1}}),ws=new U({props:{title:".",local:"",headingTag:"h3"}}),Ts=new j({props:{code:"bW9kZWwlMjAlM0QlMjBsb2FkX2Zyb21faHViKHJlcG9faWQlM0QlMjJUaG9tYXNTaW1vbmluaSUyRnEtVGF4aS12MyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycS1sZWFybmluZy5wa2wlMjIpJTIwJTIwJTIzJTIwVHJ5JTIwdG8lMjB1c2UlMjBhbm90aGVyJTIwbW9kZWwlMEElMEFwcmludChtb2RlbCklMEFlbnYlMjAlM0QlMjBneW0ubWFrZShtb2RlbCU1QiUyMmVudl9pZCUyMiU1RCklMEElMEFldmFsdWF0ZV9hZ2VudChlbnYlMkMlMjBtb2RlbCU1QiUyMm1heF9zdGVwcyUyMiU1RCUyQyUyMG1vZGVsJTVCJTIybl9ldmFsX2VwaXNvZGVzJTIyJTVEJTJDJTIwbW9kZWwlNUIlMjJxdGFibGUlMjIlNUQlMkMlMjBtb2RlbCU1QiUyMmV2YWxfc2VlZCUyMiU1RCk=",highlighted:`model = load_from_hub(repo_id=<span class="hljs-string">&quot;ThomasSimonini/q-Taxi-v3&quot;</span>, filename=<span class="hljs-string">&quot;q-learning.pkl&quot;</span>)  <span class="hljs-comment"># Try to use another model</span>

<span class="hljs-built_in">print</span>(model)
env = gym.make(model[<span class="hljs-string">&quot;env_id&quot;</span>])

evaluate_agent(env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>])`,wrap:!1}}),ms=new j({props:{code:"bW9kZWwlMjAlM0QlMjBsb2FkX2Zyb21faHViKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJUaG9tYXNTaW1vbmluaSUyRnEtRnJvemVuTGFrZS12MS1uby1zbGlwcGVyeSUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycS1sZWFybmluZy5wa2wlMjIlMEEpJTIwJTIwJTIzJTIwVHJ5JTIwdG8lMjB1c2UlMjBhbm90aGVyJTIwbW9kZWwlMEElMEFlbnYlMjAlM0QlMjBneW0ubWFrZShtb2RlbCU1QiUyMmVudl9pZCUyMiU1RCUyQyUyMGlzX3NsaXBwZXJ5JTNERmFsc2UpJTBBJTBBZXZhbHVhdGVfYWdlbnQoZW52JTJDJTIwbW9kZWwlNUIlMjJtYXhfc3RlcHMlMjIlNUQlMkMlMjBtb2RlbCU1QiUyMm5fZXZhbF9lcGlzb2RlcyUyMiU1RCUyQyUyMG1vZGVsJTVCJTIycXRhYmxlJTIyJTVEJTJDJTIwbW9kZWwlNUIlMjJldmFsX3NlZWQlMjIlNUQp",highlighted:`model = load_from_hub(
    repo_id=<span class="hljs-string">&quot;ThomasSimonini/q-FrozenLake-v1-no-slippery&quot;</span>, filename=<span class="hljs-string">&quot;q-learning.pkl&quot;</span>
)  <span class="hljs-comment"># Try to use another model</span>

env = gym.make(model[<span class="hljs-string">&quot;env_id&quot;</span>], is_slippery=<span class="hljs-literal">False</span>)

evaluate_agent(env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>])`,wrap:!1}}),js=new U({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),As=new U({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),{c(){c=M("meta"),_s=n(),Ws=M("p"),$s=n(),o(Z.$$.fragment),Qs=n(),o(A.$$.fragment),Xs=n(),W=M("p"),W.textContent=ip,Es=n(),k=M("ol"),k.innerHTML=pp,Ys=n(),_=M("img"),xs=n(),$=M("p"),$.innerHTML=rp,Rs=n(),Q=M("p"),Q.innerHTML=yp,Ss=n(),X=M("p"),X.innerHTML=Jp,Fs=n(),E=M("p"),E.innerHTML=wp,Vs=n(),Y=M("p"),Y.innerHTML=Tp,Hs=n(),x=M("p"),x.innerHTML=mp,Ns=n(),R=M("p"),R.innerHTML=jp,zs=n(),S=M("p"),S.innerHTML=Up,qs=n(),F=M("p"),F.innerHTML=up,Ls=n(),o(V.$$.fragment),Ds=n(),H=M("img"),Ps=n(),N=M("p"),N.innerHTML=hp,Ks=n(),z=M("p"),z.innerHTML=dp,Os=n(),q=M("img"),ln=n(),o(L.$$.fragment),en=n(),D=M("ul"),D.innerHTML=bp,tn=n(),o(P.$$.fragment),sn=n(),K=M("ul"),K.innerHTML=fp,nn=n(),O=M("p"),O.innerHTML=gp,an=n(),o(ll.$$.fragment),Mn=n(),el=M("p"),el.textContent=Cp,pn=n(),tl=M("ul"),tl.innerHTML=Bp,on=n(),o(sl.$$.fragment),rn=n(),nl=M("img"),yn=n(),al=M("p"),al.textContent=Gp,Jn=n(),Ml=M("ul"),Ml.innerHTML=Zp,wn=n(),il=M("p"),il.innerHTML=Ap,Tn=n(),pl=M("p"),pl.innerHTML=Wp,mn=n(),ol=M("p"),ol.innerHTML=kp,jn=n(),o(rl.$$.fragment),Un=n(),yl=M("p"),yl.textContent=_p,un=n(),Jl=M("p"),Jl.innerHTML=$p,cn=n(),o(wl.$$.fragment),hn=n(),Tl=M("p"),Tl.innerHTML=Qp,dn=n(),ml=M("ul"),ml.innerHTML=Xp,In=n(),h=M("img"),bn=n(),jl=M("ul"),jl.innerHTML=Yp,fn=n(),d=M("img"),gn=n(),Ul=M("p"),Ul.innerHTML=Rp,Cn=n(),I=M("img"),Bn=n(),ul=M("p"),ul.textContent=Fp,vn=n(),b=M("img"),Gn=n(),o(cl.$$.fragment),Zn=n(),hl=M("p"),hl.innerHTML=Hp,An=n(),dl=M("p"),dl.innerHTML=Np,Wn=n(),Il=M("p"),Il.innerHTML=zp,kn=n(),o(bl.$$.fragment),_n=n(),fl=M("p"),fl.innerHTML=qp,$n=n(),gl=M("p"),gl.textContent=Lp,Qn=n(),Cl=M("p"),Cl.textContent=Dp,Xn=n(),Bl=M("ul"),Bl.innerHTML=Pp,En=n(),vl=M("p"),vl.textContent=Kp,Yn=n(),Gl=M("p"),Gl.innerHTML=Op,xn=n(),o(Zl.$$.fragment),Rn=n(),o(Al.$$.fragment),Sn=n(),Wl=M("p"),Wl.innerHTML=lo,Fn=n(),o(kl.$$.fragment),Vn=n(),o(_l.$$.fragment),Hn=n(),o($l.$$.fragment),Nn=n(),Ql=M("p"),Ql.textContent=eo,zn=n(),Xl=M("ul"),Xl.innerHTML=to,qn=n(),o(El.$$.fragment),Ln=n(),Yl=M("p"),Yl.textContent=so,Dn=n(),o(xl.$$.fragment),Pn=n(),o(Rl.$$.fragment),Kn=n(),On=M("hr"),la=n(),Sl=M("p"),Sl.textContent=no,ea=n(),Fl=M("p"),Fl.innerHTML=ao,ta=n(),sa=M("hr"),na=n(),Vl=M("p"),Vl.innerHTML=Mo,aa=n(),Hl=M("p"),Hl.textContent=io,Ma=n(),Nl=M("ul"),Nl.innerHTML=po,ia=n(),zl=M("p"),zl.textContent=oo,pa=n(),ql=M("ul"),ql.innerHTML=ro,oa=n(),Ll=M("p"),Ll.innerHTML=yo,ra=n(),Dl=M("p"),Dl.innerHTML=Jo,ya=n(),o(Pl.$$.fragment),Ja=n(),o(Kl.$$.fragment),wa=n(),o(Ol.$$.fragment),Ta=n(),le=M("p"),le.textContent=wo,ma=n(),o(ee.$$.fragment),ja=n(),te=M("p"),te.textContent=To,Ua=n(),o(se.$$.fragment),ua=n(),o(ne.$$.fragment),ca=n(),ae=M("p"),ae.innerHTML=mo,ha=n(),Me=M("p"),Me.innerHTML=jo,da=n(),ie=M("p"),ie.textContent=Uo,Ia=n(),pe=M("img"),ba=n(),o(oe.$$.fragment),fa=n(),re=M("p"),re.textContent=co,ga=n(),ye=M("ul"),ye.innerHTML=ho,Ca=n(),Je=M("p"),Je.textContent=Io,Ba=n(),we=M("ul"),we.innerHTML=bo,va=n(),o(Te.$$.fragment),Ga=n(),me=M("p"),me.textContent=fo,Za=n(),f=M("img"),Aa=n(),je=M("p"),je.innerHTML=Co,Wa=n(),o(Ue.$$.fragment),ka=n(),o(ue.$$.fragment),_a=n(),o(ce.$$.fragment),$a=n(),o(he.$$.fragment),Qa=n(),o(de.$$.fragment),Xa=n(),o(Ie.$$.fragment),Ea=n(),o(be.$$.fragment),Ya=n(),o(fe.$$.fragment),xa=n(),ge=M("p"),ge.innerHTML=Bo,Ra=n(),Ce=M("ul"),Ce.innerHTML=vo,Sa=n(),Be=M("p"),Be.textContent=Go,Fa=n(),g=M("img"),Va=n(),o(ve.$$.fragment),Ha=n(),o(Ge.$$.fragment),Na=n(),o(Ze.$$.fragment),za=n(),o(Ae.$$.fragment),qa=n(),We=M("p"),We.textContent=Ao,La=n(),ke=M("p"),ke.textContent=Wo,Da=n(),_e=M("ul"),_e.innerHTML=ko,Pa=n(),$e=M("p"),$e.innerHTML=_o,Ka=n(),C=M("img"),Oa=n(),o(Qe.$$.fragment),lM=n(),o(Xe.$$.fragment),eM=n(),o(Ee.$$.fragment),tM=n(),o(Ye.$$.fragment),sM=n(),xe=M("p"),xe.textContent=Qo,nM=n(),Re=M("ul"),Re.innerHTML=Xo,aM=n(),o(Se.$$.fragment),MM=n(),o(Fe.$$.fragment),iM=n(),B=M("img"),pM=n(),Ve=M("p"),Ve.textContent=Yo,oM=n(),o(He.$$.fragment),rM=n(),o(Ne.$$.fragment),yM=n(),o(ze.$$.fragment),JM=n(),o(qe.$$.fragment),wM=n(),o(Le.$$.fragment),TM=n(),o(De.$$.fragment),mM=n(),o(Pe.$$.fragment),jM=n(),o(Ke.$$.fragment),UM=n(),o(Oe.$$.fragment),uM=n(),lt=M("ul"),lt.innerHTML=xo,cM=n(),o(et.$$.fragment),hM=n(),o(tt.$$.fragment),dM=n(),st=M("ul"),st.innerHTML=Ro,IM=n(),o(nt.$$.fragment),bM=n(),o(at.$$.fragment),fM=n(),Mt=M("p"),Mt.innerHTML=So,gM=n(),it=M("p"),it.textContent=Fo,CM=n(),v=M("img"),BM=n(),pt=M("p"),pt.textContent=Ho,vM=n(),o(ot.$$.fragment),GM=n(),o(rt.$$.fragment),ZM=n(),o(yt.$$.fragment),AM=n(),o(Jt.$$.fragment),WM=n(),o(wt.$$.fragment),kM=n(),Tt=M("p"),Tt.innerHTML=No,_M=n(),mt=M("p"),mt.textContent=zo,$M=n(),jt=M("ul"),jt.innerHTML=qo,QM=n(),Ut=M("p"),Ut.textContent=Lo,XM=n(),ut=M("p"),ut.innerHTML=Do,EM=n(),ct=M("p"),ct.textContent=Po,YM=n(),ht=M("ul"),ht.innerHTML=Ko,xM=n(),dt=M("img"),RM=n(),o(It.$$.fragment),SM=n(),bt=M("p"),bt.innerHTML=lr,FM=n(),ft=M("p"),ft.innerHTML=er,VM=n(),gt=M("ul"),gt.innerHTML=tr,HM=n(),o(Ct.$$.fragment),NM=n(),Bt=M("p"),Bt.innerHTML=sr,zM=n(),vt=M("ul"),vt.innerHTML=nr,qM=n(),o(Gt.$$.fragment),LM=n(),o(Zt.$$.fragment),DM=n(),At=M("p"),At.textContent=ar,PM=n(),o(Wt.$$.fragment),KM=n(),o(kt.$$.fragment),OM=n(),li=M("hr"),ei=n(),_t=M("p"),_t.textContent=Mr,ti=n(),$t=M("p"),$t.innerHTML=ir,si=n(),ni=M("hr"),ai=n(),Qt=M("p"),Qt.innerHTML=pr,Mi=n(),Xt=M("p"),Xt.innerHTML=or,ii=n(),Et=M("img"),pi=n(),o(Yt.$$.fragment),oi=n(),xt=M("p"),xt.innerHTML=yr,ri=n(),o(Rt.$$.fragment),yi=n(),o(St.$$.fragment),Ji=n(),Ft=M("p"),Ft.innerHTML=Jr,wi=n(),Vt=M("ul"),Vt.innerHTML=wr,Ti=n(),Ht=M("p"),Ht.textContent=Tr,mi=n(),Nt=M("ul"),Nt.innerHTML=mr,ji=n(),o(zt.$$.fragment),Ui=n(),o(qt.$$.fragment),ui=n(),Lt=M("p"),Lt.innerHTML=jr,ci=n(),o(Dt.$$.fragment),hi=n(),o(Pt.$$.fragment),di=n(),o(Kt.$$.fragment),Ii=n(),o(Ot.$$.fragment),bi=n(),ls=M("ul"),ls.innerHTML=Ur,fi=n(),o(es.$$.fragment),gi=n(),o(ts.$$.fragment),Ci=n(),ss=M("p"),ss.innerHTML=ur,Bi=n(),ns=M("img"),vi=n(),o(as.$$.fragment),Gi=n(),Ms=M("p"),Ms.textContent=hr,Zi=n(),is=M("p"),is.textContent=dr,Ai=n(),ps=M("ol"),ps.innerHTML=Ir,Wi=n(),os=M("img"),ki=n(),G=M("ol"),G.innerHTML=fr,_i=n(),rs=M("ul"),rs.innerHTML=gr,$i=n(),o(ys.$$.fragment),Qi=n(),o(Js.$$.fragment),Xi=n(),o(ws.$$.fragment),Ei=n(),o(Ts.$$.fragment),Yi=n(),o(ms.$$.fragment),xi=n(),o(js.$$.fragment),Ri=n(),Us=M("p"),Us.innerHTML=Cr,Si=n(),us=M("p"),us.innerHTML=Br,Fi=n(),cs=M("p"),cs.textContent=vr,Vi=n(),hs=M("ul"),hs.innerHTML=Gr,Hi=n(),ds=M("p"),ds.innerHTML=Zr,Ni=n(),zi=M("hr"),qi=n(),Is=M("p"),Is.textContent=Ar,Li=n(),bs=M("p"),bs.innerHTML=Wr,Di=n(),fs=M("p"),fs.innerHTML=kr,Pi=n(),gs=M("p"),gs.textContent=_r,Ki=n(),Cs=M("img"),Oi=n(),Bs=M("p"),Bs.textContent=Qr,lp=n(),vs=M("p"),vs.innerHTML=Xr,ep=n(),Gs=M("img"),tp=n(),Zs=M("p"),Zs.textContent=Yr,sp=n(),o(As.$$.fragment),np=n(),ks=M("p"),this.h()},l(l){const e=Nr("svelte-u9bgzb",document.head);c=i(e,"META",{name:!0,content:!0}),e.forEach(t),_s=a(l),Ws=i(l,"P",{}),xr(Ws).forEach(t),$s=a(l),r(Z.$$.fragment,l),Qs=a(l),r(A.$$.fragment,l),Xs=a(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1f5e3v9"&&(W.textContent=ip),Es=a(l),k=i(l,"OL",{"data-svelte-h":!0}),p(k)!=="svelte-191gi6t"&&(k.innerHTML=pp),Ys=a(l),_=i(l,"IMG",{src:!0,alt:!0}),xs=a(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-3cojf7"&&($.innerHTML=rp),Rs=a(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hl4dc4"&&(Q.innerHTML=yp),Ss=a(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-lt0dbq"&&(X.innerHTML=Jp),Fs=a(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1qkxyrx"&&(E.innerHTML=wp),Vs=a(l),Y=i(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-znarat"&&(Y.innerHTML=Tp),Hs=a(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-iw09i5"&&(x.innerHTML=mp),Ns=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1if5l3v"&&(R.innerHTML=jp),zs=a(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ecbzo8"&&(S.innerHTML=Up),qs=a(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-p9mrd0"&&(F.innerHTML=up),Ls=a(l),r(V.$$.fragment,l),Ds=a(l),H=i(l,"IMG",{src:!0,alt:!0}),Ps=a(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-vi2h6e"&&(N.innerHTML=hp),Ks=a(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-rjslfr"&&(z.innerHTML=dp),Os=a(l),q=i(l,"IMG",{src:!0,alt:!0}),ln=a(l),r(L.$$.fragment,l),en=a(l),D=i(l,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-1u1g1n7"&&(D.innerHTML=bp),tn=a(l),r(P.$$.fragment,l),sn=a(l),K=i(l,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-2cigth"&&(K.innerHTML=fp),nn=a(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-qqj2y4"&&(O.innerHTML=gp),an=a(l),r(ll.$$.fragment,l),Mn=a(l),el=i(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-nsjs09"&&(el.textContent=Cp),pn=a(l),tl=i(l,"UL",{"data-svelte-h":!0}),p(tl)!=="svelte-as9usj"&&(tl.innerHTML=Bp),on=a(l),r(sl.$$.fragment,l),rn=a(l),nl=i(l,"IMG",{src:!0,alt:!0}),yn=a(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-6wur6d"&&(al.textContent=Gp),Jn=a(l),Ml=i(l,"UL",{"data-svelte-h":!0}),p(Ml)!=="svelte-1aijka3"&&(Ml.innerHTML=Zp),wn=a(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-lpcvpy"&&(il.innerHTML=Ap),Tn=a(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-i91mrq"&&(pl.innerHTML=Wp),mn=a(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-15ow6yh"&&(ol.innerHTML=kp),jn=a(l),r(rl.$$.fragment,l),Un=a(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1v25wk6"&&(yl.textContent=_p),un=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-tnvrvw"&&(Jl.innerHTML=$p),cn=a(l),r(wl.$$.fragment,l),hn=a(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-35riax"&&(Tl.innerHTML=Qp),dn=a(l),ml=i(l,"UL",{"data-svelte-h":!0}),p(ml)!=="svelte-y53e1m"&&(ml.innerHTML=Xp),In=a(l),h=i(l,"IMG",{src:!0,alt:!0,width:!0}),bn=a(l),jl=i(l,"UL",{"data-svelte-h":!0}),p(jl)!=="svelte-ewg9tp"&&(jl.innerHTML=Yp),fn=a(l),d=i(l,"IMG",{src:!0,alt:!0,width:!0}),gn=a(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-ts6iuu"&&(Ul.innerHTML=Rp),Cn=a(l),I=i(l,"IMG",{src:!0,alt:!0,width:!0}),Bn=a(l),ul=i(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1v1evpe"&&(ul.textContent=Fp),vn=a(l),b=i(l,"IMG",{src:!0,alt:!0,width:!0}),Gn=a(l),r(cl.$$.fragment,l),Zn=a(l),hl=i(l,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-hl4dc4"&&(hl.innerHTML=Hp),An=a(l),dl=i(l,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-lt0dbq"&&(dl.innerHTML=Np),Wn=a(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-1qkxyrx"&&(Il.innerHTML=zp),kn=a(l),r(bl.$$.fragment,l),_n=a(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-1qz55yt"&&(fl.innerHTML=qp),$n=a(l),gl=i(l,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1edv84f"&&(gl.textContent=Lp),Qn=a(l),Cl=i(l,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-p5tnmj"&&(Cl.textContent=Dp),Xn=a(l),Bl=i(l,"UL",{"data-svelte-h":!0}),p(Bl)!=="svelte-1a6kaa0"&&(Bl.innerHTML=Pp),En=a(l),vl=i(l,"P",{"data-svelte-h":!0}),p(vl)!=="svelte-1ub567"&&(vl.textContent=Kp),Yn=a(l),Gl=i(l,"P",{"data-svelte-h":!0}),p(Gl)!=="svelte-z5knmu"&&(Gl.innerHTML=Op),xn=a(l),r(Zl.$$.fragment,l),Rn=a(l),r(Al.$$.fragment,l),Sn=a(l),Wl=i(l,"P",{"data-svelte-h":!0}),p(Wl)!=="svelte-bx852m"&&(Wl.innerHTML=lo),Fn=a(l),r(kl.$$.fragment,l),Vn=a(l),r(_l.$$.fragment,l),Hn=a(l),r($l.$$.fragment,l),Nn=a(l),Ql=i(l,"P",{"data-svelte-h":!0}),p(Ql)!=="svelte-15y0mfy"&&(Ql.textContent=eo),zn=a(l),Xl=i(l,"UL",{"data-svelte-h":!0}),p(Xl)!=="svelte-1diir2b"&&(Xl.innerHTML=to),qn=a(l),r(El.$$.fragment,l),Ln=a(l),Yl=i(l,"P",{"data-svelte-h":!0}),p(Yl)!=="svelte-10wfdos"&&(Yl.textContent=so),Dn=a(l),r(xl.$$.fragment,l),Pn=a(l),r(Rl.$$.fragment,l),Kn=a(l),On=i(l,"HR",{}),la=a(l),Sl=i(l,"P",{"data-svelte-h":!0}),p(Sl)!=="svelte-1y7jkk2"&&(Sl.textContent=no),ea=a(l),Fl=i(l,"P",{"data-svelte-h":!0}),p(Fl)!=="svelte-1g9dnfd"&&(Fl.innerHTML=ao),ta=a(l),sa=i(l,"HR",{}),na=a(l),Vl=i(l,"P",{"data-svelte-h":!0}),p(Vl)!=="svelte-1opykko"&&(Vl.innerHTML=Mo),aa=a(l),Hl=i(l,"P",{"data-svelte-h":!0}),p(Hl)!=="svelte-69seoq"&&(Hl.textContent=io),Ma=a(l),Nl=i(l,"UL",{"data-svelte-h":!0}),p(Nl)!=="svelte-1bqo6ps"&&(Nl.innerHTML=po),ia=a(l),zl=i(l,"P",{"data-svelte-h":!0}),p(zl)!=="svelte-ikftvi"&&(zl.textContent=oo),pa=a(l),ql=i(l,"UL",{"data-svelte-h":!0}),p(ql)!=="svelte-1xh74m5"&&(ql.innerHTML=ro),oa=a(l),Ll=i(l,"P",{"data-svelte-h":!0}),p(Ll)!=="svelte-28qiy3"&&(Ll.innerHTML=yo),ra=a(l),Dl=i(l,"P",{"data-svelte-h":!0}),p(Dl)!=="svelte-13axk10"&&(Dl.innerHTML=Jo),ya=a(l),r(Pl.$$.fragment,l),Ja=a(l),r(Kl.$$.fragment,l),wa=a(l),r(Ol.$$.fragment,l),Ta=a(l),le=i(l,"P",{"data-svelte-h":!0}),p(le)!=="svelte-tce60o"&&(le.textContent=wo),ma=a(l),r(ee.$$.fragment,l),ja=a(l),te=i(l,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1inu12x"&&(te.textContent=To),Ua=a(l),r(se.$$.fragment,l),ua=a(l),r(ne.$$.fragment,l),ca=a(l),ae=i(l,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1moftaa"&&(ae.innerHTML=mo),ha=a(l),Me=i(l,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-194e91w"&&(Me.innerHTML=jo),da=a(l),ie=i(l,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1rshm9z"&&(ie.textContent=Uo),Ia=a(l),pe=i(l,"IMG",{src:!0,alt:!0}),ba=a(l),r(oe.$$.fragment,l),fa=a(l),re=i(l,"P",{"data-svelte-h":!0}),p(re)!=="svelte-us31f2"&&(re.textContent=co),ga=a(l),ye=i(l,"UL",{"data-svelte-h":!0}),p(ye)!=="svelte-1i38xji"&&(ye.innerHTML=ho),Ca=a(l),Je=i(l,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1s6ywkk"&&(Je.textContent=Io),Ba=a(l),we=i(l,"UL",{"data-svelte-h":!0}),p(we)!=="svelte-fsx41z"&&(we.innerHTML=bo),va=a(l),r(Te.$$.fragment,l),Ga=a(l),me=i(l,"P",{"data-svelte-h":!0}),p(me)!=="svelte-ya8m6q"&&(me.textContent=fo),Za=a(l),f=i(l,"IMG",{src:!0,alt:!0,width:!0}),Aa=a(l),je=i(l,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1u12uzl"&&(je.innerHTML=Co),Wa=a(l),r(Ue.$$.fragment,l),ka=a(l),r(ue.$$.fragment,l),_a=a(l),r(ce.$$.fragment,l),$a=a(l),r(he.$$.fragment,l),Qa=a(l),r(de.$$.fragment,l),Xa=a(l),r(Ie.$$.fragment,l),Ea=a(l),r(be.$$.fragment,l),Ya=a(l),r(fe.$$.fragment,l),xa=a(l),ge=i(l,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-d4nx75"&&(ge.innerHTML=Bo),Ra=a(l),Ce=i(l,"UL",{"data-svelte-h":!0}),p(Ce)!=="svelte-1p5h2yo"&&(Ce.innerHTML=vo),Sa=a(l),Be=i(l,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-r5d24i"&&(Be.textContent=Go),Fa=a(l),g=i(l,"IMG",{src:!0,alt:!0,width:!0}),Va=a(l),r(ve.$$.fragment,l),Ha=a(l),r(Ge.$$.fragment,l),Na=a(l),r(Ze.$$.fragment,l),za=a(l),r(Ae.$$.fragment,l),qa=a(l),We=i(l,"P",{"data-svelte-h":!0}),p(We)!=="svelte-15kc6ix"&&(We.textContent=Ao),La=a(l),ke=i(l,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-12b3gcn"&&(ke.textContent=Wo),Da=a(l),_e=i(l,"UL",{"data-svelte-h":!0}),p(_e)!=="svelte-1capiq3"&&(_e.innerHTML=ko),Pa=a(l),$e=i(l,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1xegqik"&&($e.innerHTML=_o),Ka=a(l),C=i(l,"IMG",{src:!0,alt:!0,width:!0}),Oa=a(l),r(Qe.$$.fragment,l),lM=a(l),r(Xe.$$.fragment,l),eM=a(l),r(Ee.$$.fragment,l),tM=a(l),r(Ye.$$.fragment,l),sM=a(l),xe=i(l,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1vceqb8"&&(xe.textContent=Qo),nM=a(l),Re=i(l,"UL",{"data-svelte-h":!0}),p(Re)!=="svelte-1sx31jt"&&(Re.innerHTML=Xo),aM=a(l),r(Se.$$.fragment,l),MM=a(l),r(Fe.$$.fragment,l),iM=a(l),B=i(l,"IMG",{src:!0,alt:!0,width:!0}),pM=a(l),Ve=i(l,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-mo6epg"&&(Ve.textContent=Yo),oM=a(l),r(He.$$.fragment,l),rM=a(l),r(Ne.$$.fragment,l),yM=a(l),r(ze.$$.fragment,l),JM=a(l),r(qe.$$.fragment,l),wM=a(l),r(Le.$$.fragment,l),TM=a(l),r(De.$$.fragment,l),mM=a(l),r(Pe.$$.fragment,l),jM=a(l),r(Ke.$$.fragment,l),UM=a(l),r(Oe.$$.fragment,l),uM=a(l),lt=i(l,"UL",{"data-svelte-h":!0}),p(lt)!=="svelte-1hothf3"&&(lt.innerHTML=xo),cM=a(l),r(et.$$.fragment,l),hM=a(l),r(tt.$$.fragment,l),dM=a(l),st=i(l,"UL",{"data-svelte-h":!0}),p(st)!=="svelte-1snb10p"&&(st.innerHTML=Ro),IM=a(l),r(nt.$$.fragment,l),bM=a(l),r(at.$$.fragment,l),fM=a(l),Mt=i(l,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1djb4oi"&&(Mt.innerHTML=So),gM=a(l),it=i(l,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1ifum22"&&(it.textContent=Fo),CM=a(l),v=i(l,"IMG",{src:!0,alt:!0,width:!0}),BM=a(l),pt=i(l,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1pr3qlz"&&(pt.textContent=Ho),vM=a(l),r(ot.$$.fragment,l),GM=a(l),r(rt.$$.fragment,l),ZM=a(l),r(yt.$$.fragment,l),AM=a(l),r(Jt.$$.fragment,l),WM=a(l),r(wt.$$.fragment,l),kM=a(l),Tt=i(l,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-fovdf1"&&(Tt.innerHTML=No),_M=a(l),mt=i(l,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-vgzxi7"&&(mt.textContent=zo),$M=a(l),jt=i(l,"UL",{"data-svelte-h":!0}),p(jt)!=="svelte-bcjr5d"&&(jt.innerHTML=qo),QM=a(l),Ut=i(l,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-6k9qpu"&&(Ut.textContent=Lo),XM=a(l),ut=i(l,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-932u9c"&&(ut.innerHTML=Do),EM=a(l),ct=i(l,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1cn3tld"&&(ct.textContent=Po),YM=a(l),ht=i(l,"UL",{"data-svelte-h":!0}),p(ht)!=="svelte-19b5tev"&&(ht.innerHTML=Ko),xM=a(l),dt=i(l,"IMG",{src:!0,alt:!0}),RM=a(l),r(It.$$.fragment,l),SM=a(l),bt=i(l,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-49nrvg"&&(bt.innerHTML=lr),FM=a(l),ft=i(l,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-98z2qn"&&(ft.innerHTML=er),VM=a(l),gt=i(l,"UL",{"data-svelte-h":!0}),p(gt)!=="svelte-1hssbsu"&&(gt.innerHTML=tr),HM=a(l),r(Ct.$$.fragment,l),NM=a(l),Bt=i(l,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-ofvu76"&&(Bt.innerHTML=sr),zM=a(l),vt=i(l,"UL",{"data-svelte-h":!0}),p(vt)!=="svelte-1nfxrjn"&&(vt.innerHTML=nr),qM=a(l),r(Gt.$$.fragment,l),LM=a(l),r(Zt.$$.fragment,l),DM=a(l),At=i(l,"P",{"data-svelte-h":!0}),p(At)!=="svelte-1jklivl"&&(At.textContent=ar),PM=a(l),r(Wt.$$.fragment,l),KM=a(l),r(kt.$$.fragment,l),OM=a(l),li=i(l,"HR",{}),ei=a(l),_t=i(l,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1y7jkk2"&&(_t.textContent=Mr),ti=a(l),$t=i(l,"P",{"data-svelte-h":!0}),p($t)!=="svelte-1ip08fr"&&($t.innerHTML=ir),si=a(l),ni=i(l,"HR",{}),ai=a(l),Qt=i(l,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-1f0umdd"&&(Qt.innerHTML=pr),Mi=a(l),Xt=i(l,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-17rt1na"&&(Xt.innerHTML=or),ii=a(l),Et=i(l,"IMG",{src:!0,alt:!0}),pi=a(l),r(Yt.$$.fragment,l),oi=a(l),xt=i(l,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-lidq2q"&&(xt.innerHTML=yr),ri=a(l),r(Rt.$$.fragment,l),yi=a(l),r(St.$$.fragment,l),Ji=a(l),Ft=i(l,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-17m9qrz"&&(Ft.innerHTML=Jr),wi=a(l),Vt=i(l,"UL",{"data-svelte-h":!0}),p(Vt)!=="svelte-18vb0lv"&&(Vt.innerHTML=wr),Ti=a(l),Ht=i(l,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1s6ywkk"&&(Ht.textContent=Tr),mi=a(l),Nt=i(l,"UL",{"data-svelte-h":!0}),p(Nt)!=="svelte-lauea"&&(Nt.innerHTML=mr),ji=a(l),r(zt.$$.fragment,l),Ui=a(l),r(qt.$$.fragment,l),ui=a(l),Lt=i(l,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-w1y0j"&&(Lt.innerHTML=jr),ci=a(l),r(Dt.$$.fragment,l),hi=a(l),r(Pt.$$.fragment,l),di=a(l),r(Kt.$$.fragment,l),Ii=a(l),r(Ot.$$.fragment,l),bi=a(l),ls=i(l,"UL",{"data-svelte-h":!0}),p(ls)!=="svelte-1khpmsn"&&(ls.innerHTML=Ur),fi=a(l),r(es.$$.fragment,l),gi=a(l),r(ts.$$.fragment,l),Ci=a(l),ss=i(l,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-oh8wqa"&&(ss.innerHTML=ur),Bi=a(l),ns=i(l,"IMG",{src:!0,alt:!0}),vi=a(l),r(as.$$.fragment,l),Gi=a(l),Ms=i(l,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-iv76jo"&&(Ms.textContent=hr),Zi=a(l),is=i(l,"P",{"data-svelte-h":!0}),p(is)!=="svelte-hdbqg"&&(is.textContent=dr),Ai=a(l),ps=i(l,"OL",{"data-svelte-h":!0}),p(ps)!=="svelte-qkijdo"&&(ps.innerHTML=Ir),Wi=a(l),os=i(l,"IMG",{src:!0,alt:!0}),ki=a(l),G=i(l,"OL",{start:!0,"data-svelte-h":!0}),p(G)!=="svelte-1faxh4"&&(G.innerHTML=fr),_i=a(l),rs=i(l,"UL",{"data-svelte-h":!0}),p(rs)!=="svelte-29nsg7"&&(rs.innerHTML=gr),$i=a(l),r(ys.$$.fragment,l),Qi=a(l),r(Js.$$.fragment,l),Xi=a(l),r(ws.$$.fragment,l),Ei=a(l),r(Ts.$$.fragment,l),Yi=a(l),r(ms.$$.fragment,l),xi=a(l),r(js.$$.fragment,l),Ri=a(l),Us=i(l,"P",{"data-svelte-h":!0}),p(Us)!=="svelte-1nokp82"&&(Us.innerHTML=Cr),Si=a(l),us=i(l,"P",{"data-svelte-h":!0}),p(us)!=="svelte-131ixzr"&&(us.innerHTML=Br),Fi=a(l),cs=i(l,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-1uth36j"&&(cs.textContent=vr),Vi=a(l),hs=i(l,"UL",{"data-svelte-h":!0}),p(hs)!=="svelte-17mmf24"&&(hs.innerHTML=Gr),Hi=a(l),ds=i(l,"P",{"data-svelte-h":!0}),p(ds)!=="svelte-vf0l4f"&&(ds.innerHTML=Zr),Ni=a(l),zi=i(l,"HR",{}),qi=a(l),Is=i(l,"P",{"data-svelte-h":!0}),p(Is)!=="svelte-4y921w"&&(Is.textContent=Ar),Li=a(l),bs=i(l,"P",{"data-svelte-h":!0}),p(bs)!=="svelte-1xc37hs"&&(bs.innerHTML=Wr),Di=a(l),fs=i(l,"P",{"data-svelte-h":!0}),p(fs)!=="svelte-1m4pzec"&&(fs.innerHTML=kr),Pi=a(l),gs=i(l,"P",{"data-svelte-h":!0}),p(gs)!=="svelte-cgragb"&&(gs.textContent=_r),Ki=a(l),Cs=i(l,"IMG",{src:!0,alt:!0}),Oi=a(l),Bs=i(l,"P",{"data-svelte-h":!0}),p(Bs)!=="svelte-1oiipwt"&&(Bs.textContent=Qr),lp=a(l),vs=i(l,"P",{"data-svelte-h":!0}),p(vs)!=="svelte-11vrr72"&&(vs.innerHTML=Xr),ep=a(l),Gs=i(l,"IMG",{src:!0,alt:!0}),tp=a(l),Zs=i(l,"P",{"data-svelte-h":!0}),p(Zs)!=="svelte-so7imd"&&(Zs.textContent=Yr),sp=a(l),r(As.$$.fragment,l),np=a(l),ks=i(l,"P",{}),xr(ks).forEach(t),this.h()},h(){m(c,"name","hf:doc:metadata"),m(c,"content",Dr),u(_.src,op="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/envs.gif")||m(_,"src",op),m(_,"alt","Environments"),u(H.src,cp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/thumbnail.jpg")||m(H,"src",cp),m(H,"alt","Unit 2 Thumbnail"),u(q.src,Ip="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/envs.gif")||m(q,"src",Ip),m(q,"alt","Environments"),u(nl.src,vp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/deep-rl-course-illustration.jpg")||m(nl,"src",vp),m(nl,"alt","Deep RL Course illustration"),u(h.src,Ep="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-function-2.jpg")||m(h,"src",Ep),m(h,"alt","Q function"),m(h,"width","100%"),u(d.src,xp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/link-value-policy.jpg")||m(d,"src",xp),m(d,"alt","Link value policy"),m(d,"width","100%"),u(I.src,Sp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/q-learning.jpeg")||m(I,"src",Sp),m(I,"alt","q-learning.jpeg"),m(I,"width","100%"),u(b.src,Vp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||m(b,"src",Vp),m(b,"alt","Q-Learning"),m(b,"width","100%"),u(pe.src,uo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/frozenlake.png")||m(pe,"src",uo),m(pe,"alt","FrozenLake"),u(f.src,go="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||m(f,"src",go),m(f,"alt","Q-Learning"),m(f,"width","100%"),u(g.src,Zo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/off-on-4.jpg")||m(g,"src",Zo),m(g,"alt","Q-Learning"),m(g,"width","100%"),u(C.src,$o="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-4.jpg")||m(C,"src",$o),m(C,"alt","Q-Learning"),m(C,"width","100%"),u(B.src,Eo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||m(B,"src",Eo),m(B,"alt","Q-Learning"),m(B,"width","100%"),u(v.src,Vo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/modelcard.png")||m(v,"src",Vo),m(v,"alt","Model card"),m(v,"width","100%"),u(dt.src,Oo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||m(dt,"src",Oo),m(dt,"alt","Create HF Token"),u(Et.src,rr="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/taxi.png")||m(Et,"src",rr),m(Et,"alt","Taxi"),u(ns.src,cr="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/taxi-leaderboard.png")||m(ns,"src",cr),m(ns,"alt","Taxi Leaderboard"),u(os.src,br="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/copy-id.png")||m(os,"src",br),m(os,"alt","Copy id"),m(G,"start","3"),u(Cs.src,$r="https://vizdoom.cs.put.edu.pl/user/pages/01.tutorial/basic.png")||m(Cs,"src",$r),m(Cs,"alt","Doom"),u(Gs.src,Er="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/atari-envs.gif")||m(Gs,"src",Er),m(Gs,"alt","Environments")},m(l,e){zr(document.head,c),s(l,_s,e),s(l,Ws,e),s(l,$s,e),y(Z,l,e),s(l,Qs,e),y(A,l,e),s(l,Xs,e),s(l,W,e),s(l,Es,e),s(l,k,e),s(l,Ys,e),s(l,_,e),s(l,xs,e),s(l,$,e),s(l,Rs,e),s(l,Q,e),s(l,Ss,e),s(l,X,e),s(l,Fs,e),s(l,E,e),s(l,Vs,e),s(l,Y,e),s(l,Hs,e),s(l,x,e),s(l,Ns,e),s(l,R,e),s(l,zs,e),s(l,S,e),s(l,qs,e),s(l,F,e),s(l,Ls,e),y(V,l,e),s(l,Ds,e),s(l,H,e),s(l,Ps,e),s(l,N,e),s(l,Ks,e),s(l,z,e),s(l,Os,e),s(l,q,e),s(l,ln,e),y(L,l,e),s(l,en,e),s(l,D,e),s(l,tn,e),y(P,l,e),s(l,sn,e),s(l,K,e),s(l,nn,e),s(l,O,e),s(l,an,e),y(ll,l,e),s(l,Mn,e),s(l,el,e),s(l,pn,e),s(l,tl,e),s(l,on,e),y(sl,l,e),s(l,rn,e),s(l,nl,e),s(l,yn,e),s(l,al,e),s(l,Jn,e),s(l,Ml,e),s(l,wn,e),s(l,il,e),s(l,Tn,e),s(l,pl,e),s(l,mn,e),s(l,ol,e),s(l,jn,e),y(rl,l,e),s(l,Un,e),s(l,yl,e),s(l,un,e),s(l,Jl,e),s(l,cn,e),y(wl,l,e),s(l,hn,e),s(l,Tl,e),s(l,dn,e),s(l,ml,e),s(l,In,e),s(l,h,e),s(l,bn,e),s(l,jl,e),s(l,fn,e),s(l,d,e),s(l,gn,e),s(l,Ul,e),s(l,Cn,e),s(l,I,e),s(l,Bn,e),s(l,ul,e),s(l,vn,e),s(l,b,e),s(l,Gn,e),y(cl,l,e),s(l,Zn,e),s(l,hl,e),s(l,An,e),s(l,dl,e),s(l,Wn,e),s(l,Il,e),s(l,kn,e),y(bl,l,e),s(l,_n,e),s(l,fl,e),s(l,$n,e),s(l,gl,e),s(l,Qn,e),s(l,Cl,e),s(l,Xn,e),s(l,Bl,e),s(l,En,e),s(l,vl,e),s(l,Yn,e),s(l,Gl,e),s(l,xn,e),y(Zl,l,e),s(l,Rn,e),y(Al,l,e),s(l,Sn,e),s(l,Wl,e),s(l,Fn,e),y(kl,l,e),s(l,Vn,e),y(_l,l,e),s(l,Hn,e),y($l,l,e),s(l,Nn,e),s(l,Ql,e),s(l,zn,e),s(l,Xl,e),s(l,qn,e),y(El,l,e),s(l,Ln,e),s(l,Yl,e),s(l,Dn,e),y(xl,l,e),s(l,Pn,e),y(Rl,l,e),s(l,Kn,e),s(l,On,e),s(l,la,e),s(l,Sl,e),s(l,ea,e),s(l,Fl,e),s(l,ta,e),s(l,sa,e),s(l,na,e),s(l,Vl,e),s(l,aa,e),s(l,Hl,e),s(l,Ma,e),s(l,Nl,e),s(l,ia,e),s(l,zl,e),s(l,pa,e),s(l,ql,e),s(l,oa,e),s(l,Ll,e),s(l,ra,e),s(l,Dl,e),s(l,ya,e),y(Pl,l,e),s(l,Ja,e),y(Kl,l,e),s(l,wa,e),y(Ol,l,e),s(l,Ta,e),s(l,le,e),s(l,ma,e),y(ee,l,e),s(l,ja,e),s(l,te,e),s(l,Ua,e),y(se,l,e),s(l,ua,e),y(ne,l,e),s(l,ca,e),s(l,ae,e),s(l,ha,e),s(l,Me,e),s(l,da,e),s(l,ie,e),s(l,Ia,e),s(l,pe,e),s(l,ba,e),y(oe,l,e),s(l,fa,e),s(l,re,e),s(l,ga,e),s(l,ye,e),s(l,Ca,e),s(l,Je,e),s(l,Ba,e),s(l,we,e),s(l,va,e),y(Te,l,e),s(l,Ga,e),s(l,me,e),s(l,Za,e),s(l,f,e),s(l,Aa,e),s(l,je,e),s(l,Wa,e),y(Ue,l,e),s(l,ka,e),y(ue,l,e),s(l,_a,e),y(ce,l,e),s(l,$a,e),y(he,l,e),s(l,Qa,e),y(de,l,e),s(l,Xa,e),y(Ie,l,e),s(l,Ea,e),y(be,l,e),s(l,Ya,e),y(fe,l,e),s(l,xa,e),s(l,ge,e),s(l,Ra,e),s(l,Ce,e),s(l,Sa,e),s(l,Be,e),s(l,Fa,e),s(l,g,e),s(l,Va,e),y(ve,l,e),s(l,Ha,e),y(Ge,l,e),s(l,Na,e),y(Ze,l,e),s(l,za,e),y(Ae,l,e),s(l,qa,e),s(l,We,e),s(l,La,e),s(l,ke,e),s(l,Da,e),s(l,_e,e),s(l,Pa,e),s(l,$e,e),s(l,Ka,e),s(l,C,e),s(l,Oa,e),y(Qe,l,e),s(l,lM,e),y(Xe,l,e),s(l,eM,e),y(Ee,l,e),s(l,tM,e),y(Ye,l,e),s(l,sM,e),s(l,xe,e),s(l,nM,e),s(l,Re,e),s(l,aM,e),y(Se,l,e),s(l,MM,e),y(Fe,l,e),s(l,iM,e),s(l,B,e),s(l,pM,e),s(l,Ve,e),s(l,oM,e),y(He,l,e),s(l,rM,e),y(Ne,l,e),s(l,yM,e),y(ze,l,e),s(l,JM,e),y(qe,l,e),s(l,wM,e),y(Le,l,e),s(l,TM,e),y(De,l,e),s(l,mM,e),y(Pe,l,e),s(l,jM,e),y(Ke,l,e),s(l,UM,e),y(Oe,l,e),s(l,uM,e),s(l,lt,e),s(l,cM,e),y(et,l,e),s(l,hM,e),y(tt,l,e),s(l,dM,e),s(l,st,e),s(l,IM,e),y(nt,l,e),s(l,bM,e),y(at,l,e),s(l,fM,e),s(l,Mt,e),s(l,gM,e),s(l,it,e),s(l,CM,e),s(l,v,e),s(l,BM,e),s(l,pt,e),s(l,vM,e),y(ot,l,e),s(l,GM,e),y(rt,l,e),s(l,ZM,e),y(yt,l,e),s(l,AM,e),y(Jt,l,e),s(l,WM,e),y(wt,l,e),s(l,kM,e),s(l,Tt,e),s(l,_M,e),s(l,mt,e),s(l,$M,e),s(l,jt,e),s(l,QM,e),s(l,Ut,e),s(l,XM,e),s(l,ut,e),s(l,EM,e),s(l,ct,e),s(l,YM,e),s(l,ht,e),s(l,xM,e),s(l,dt,e),s(l,RM,e),y(It,l,e),s(l,SM,e),s(l,bt,e),s(l,FM,e),s(l,ft,e),s(l,VM,e),s(l,gt,e),s(l,HM,e),y(Ct,l,e),s(l,NM,e),s(l,Bt,e),s(l,zM,e),s(l,vt,e),s(l,qM,e),y(Gt,l,e),s(l,LM,e),y(Zt,l,e),s(l,DM,e),s(l,At,e),s(l,PM,e),y(Wt,l,e),s(l,KM,e),y(kt,l,e),s(l,OM,e),s(l,li,e),s(l,ei,e),s(l,_t,e),s(l,ti,e),s(l,$t,e),s(l,si,e),s(l,ni,e),s(l,ai,e),s(l,Qt,e),s(l,Mi,e),s(l,Xt,e),s(l,ii,e),s(l,Et,e),s(l,pi,e),y(Yt,l,e),s(l,oi,e),s(l,xt,e),s(l,ri,e),y(Rt,l,e),s(l,yi,e),y(St,l,e),s(l,Ji,e),s(l,Ft,e),s(l,wi,e),s(l,Vt,e),s(l,Ti,e),s(l,Ht,e),s(l,mi,e),s(l,Nt,e),s(l,ji,e),y(zt,l,e),s(l,Ui,e),y(qt,l,e),s(l,ui,e),s(l,Lt,e),s(l,ci,e),y(Dt,l,e),s(l,hi,e),y(Pt,l,e),s(l,di,e),y(Kt,l,e),s(l,Ii,e),y(Ot,l,e),s(l,bi,e),s(l,ls,e),s(l,fi,e),y(es,l,e),s(l,gi,e),y(ts,l,e),s(l,Ci,e),s(l,ss,e),s(l,Bi,e),s(l,ns,e),s(l,vi,e),y(as,l,e),s(l,Gi,e),s(l,Ms,e),s(l,Zi,e),s(l,is,e),s(l,Ai,e),s(l,ps,e),s(l,Wi,e),s(l,os,e),s(l,ki,e),s(l,G,e),s(l,_i,e),s(l,rs,e),s(l,$i,e),y(ys,l,e),s(l,Qi,e),y(Js,l,e),s(l,Xi,e),y(ws,l,e),s(l,Ei,e),y(Ts,l,e),s(l,Yi,e),y(ms,l,e),s(l,xi,e),y(js,l,e),s(l,Ri,e),s(l,Us,e),s(l,Si,e),s(l,us,e),s(l,Fi,e),s(l,cs,e),s(l,Vi,e),s(l,hs,e),s(l,Hi,e),s(l,ds,e),s(l,Ni,e),s(l,zi,e),s(l,qi,e),s(l,Is,e),s(l,Li,e),s(l,bs,e),s(l,Di,e),s(l,fs,e),s(l,Pi,e),s(l,gs,e),s(l,Ki,e),s(l,Cs,e),s(l,Oi,e),s(l,Bs,e),s(l,lp,e),s(l,vs,e),s(l,ep,e),s(l,Gs,e),s(l,tp,e),s(l,Zs,e),s(l,sp,e),y(As,l,e),s(l,np,e),s(l,ks,e),ap=!0},p:Sr,i(l){ap||(J(Z.$$.fragment,l),J(A.$$.fragment,l),J(V.$$.fragment,l),J(L.$$.fragment,l),J(P.$$.fragment,l),J(ll.$$.fragment,l),J(sl.$$.fragment,l),J(rl.$$.fragment,l),J(wl.$$.fragment,l),J(cl.$$.fragment,l),J(bl.$$.fragment,l),J(Zl.$$.fragment,l),J(Al.$$.fragment,l),J(kl.$$.fragment,l),J(_l.$$.fragment,l),J($l.$$.fragment,l),J(El.$$.fragment,l),J(xl.$$.fragment,l),J(Rl.$$.fragment,l),J(Pl.$$.fragment,l),J(Kl.$$.fragment,l),J(Ol.$$.fragment,l),J(ee.$$.fragment,l),J(se.$$.fragment,l),J(ne.$$.fragment,l),J(oe.$$.fragment,l),J(Te.$$.fragment,l),J(Ue.$$.fragment,l),J(ue.$$.fragment,l),J(ce.$$.fragment,l),J(he.$$.fragment,l),J(de.$$.fragment,l),J(Ie.$$.fragment,l),J(be.$$.fragment,l),J(fe.$$.fragment,l),J(ve.$$.fragment,l),J(Ge.$$.fragment,l),J(Ze.$$.fragment,l),J(Ae.$$.fragment,l),J(Qe.$$.fragment,l),J(Xe.$$.fragment,l),J(Ee.$$.fragment,l),J(Ye.$$.fragment,l),J(Se.$$.fragment,l),J(Fe.$$.fragment,l),J(He.$$.fragment,l),J(Ne.$$.fragment,l),J(ze.$$.fragment,l),J(qe.$$.fragment,l),J(Le.$$.fragment,l),J(De.$$.fragment,l),J(Pe.$$.fragment,l),J(Ke.$$.fragment,l),J(Oe.$$.fragment,l),J(et.$$.fragment,l),J(tt.$$.fragment,l),J(nt.$$.fragment,l),J(at.$$.fragment,l),J(ot.$$.fragment,l),J(rt.$$.fragment,l),J(yt.$$.fragment,l),J(Jt.$$.fragment,l),J(wt.$$.fragment,l),J(It.$$.fragment,l),J(Ct.$$.fragment,l),J(Gt.$$.fragment,l),J(Zt.$$.fragment,l),J(Wt.$$.fragment,l),J(kt.$$.fragment,l),J(Yt.$$.fragment,l),J(Rt.$$.fragment,l),J(St.$$.fragment,l),J(zt.$$.fragment,l),J(qt.$$.fragment,l),J(Dt.$$.fragment,l),J(Pt.$$.fragment,l),J(Kt.$$.fragment,l),J(Ot.$$.fragment,l),J(es.$$.fragment,l),J(ts.$$.fragment,l),J(as.$$.fragment,l),J(ys.$$.fragment,l),J(Js.$$.fragment,l),J(ws.$$.fragment,l),J(Ts.$$.fragment,l),J(ms.$$.fragment,l),J(js.$$.fragment,l),J(As.$$.fragment,l),ap=!0)},o(l){w(Z.$$.fragment,l),w(A.$$.fragment,l),w(V.$$.fragment,l),w(L.$$.fragment,l),w(P.$$.fragment,l),w(ll.$$.fragment,l),w(sl.$$.fragment,l),w(rl.$$.fragment,l),w(wl.$$.fragment,l),w(cl.$$.fragment,l),w(bl.$$.fragment,l),w(Zl.$$.fragment,l),w(Al.$$.fragment,l),w(kl.$$.fragment,l),w(_l.$$.fragment,l),w($l.$$.fragment,l),w(El.$$.fragment,l),w(xl.$$.fragment,l),w(Rl.$$.fragment,l),w(Pl.$$.fragment,l),w(Kl.$$.fragment,l),w(Ol.$$.fragment,l),w(ee.$$.fragment,l),w(se.$$.fragment,l),w(ne.$$.fragment,l),w(oe.$$.fragment,l),w(Te.$$.fragment,l),w(Ue.$$.fragment,l),w(ue.$$.fragment,l),w(ce.$$.fragment,l),w(he.$$.fragment,l),w(de.$$.fragment,l),w(Ie.$$.fragment,l),w(be.$$.fragment,l),w(fe.$$.fragment,l),w(ve.$$.fragment,l),w(Ge.$$.fragment,l),w(Ze.$$.fragment,l),w(Ae.$$.fragment,l),w(Qe.$$.fragment,l),w(Xe.$$.fragment,l),w(Ee.$$.fragment,l),w(Ye.$$.fragment,l),w(Se.$$.fragment,l),w(Fe.$$.fragment,l),w(He.$$.fragment,l),w(Ne.$$.fragment,l),w(ze.$$.fragment,l),w(qe.$$.fragment,l),w(Le.$$.fragment,l),w(De.$$.fragment,l),w(Pe.$$.fragment,l),w(Ke.$$.fragment,l),w(Oe.$$.fragment,l),w(et.$$.fragment,l),w(tt.$$.fragment,l),w(nt.$$.fragment,l),w(at.$$.fragment,l),w(ot.$$.fragment,l),w(rt.$$.fragment,l),w(yt.$$.fragment,l),w(Jt.$$.fragment,l),w(wt.$$.fragment,l),w(It.$$.fragment,l),w(Ct.$$.fragment,l),w(Gt.$$.fragment,l),w(Zt.$$.fragment,l),w(Wt.$$.fragment,l),w(kt.$$.fragment,l),w(Yt.$$.fragment,l),w(Rt.$$.fragment,l),w(St.$$.fragment,l),w(zt.$$.fragment,l),w(qt.$$.fragment,l),w(Dt.$$.fragment,l),w(Pt.$$.fragment,l),w(Kt.$$.fragment,l),w(Ot.$$.fragment,l),w(es.$$.fragment,l),w(ts.$$.fragment,l),w(as.$$.fragment,l),w(ys.$$.fragment,l),w(Js.$$.fragment,l),w(ws.$$.fragment,l),w(Ts.$$.fragment,l),w(ms.$$.fragment,l),w(js.$$.fragment,l),w(As.$$.fragment,l),ap=!1},d(l){l&&(t(_s),t(Ws),t($s),t(Qs),t(Xs),t(W),t(Es),t(k),t(Ys),t(_),t(xs),t($),t(Rs),t(Q),t(Ss),t(X),t(Fs),t(E),t(Vs),t(Y),t(Hs),t(x),t(Ns),t(R),t(zs),t(S),t(qs),t(F),t(Ls),t(Ds),t(H),t(Ps),t(N),t(Ks),t(z),t(Os),t(q),t(ln),t(en),t(D),t(tn),t(sn),t(K),t(nn),t(O),t(an),t(Mn),t(el),t(pn),t(tl),t(on),t(rn),t(nl),t(yn),t(al),t(Jn),t(Ml),t(wn),t(il),t(Tn),t(pl),t(mn),t(ol),t(jn),t(Un),t(yl),t(un),t(Jl),t(cn),t(hn),t(Tl),t(dn),t(ml),t(In),t(h),t(bn),t(jl),t(fn),t(d),t(gn),t(Ul),t(Cn),t(I),t(Bn),t(ul),t(vn),t(b),t(Gn),t(Zn),t(hl),t(An),t(dl),t(Wn),t(Il),t(kn),t(_n),t(fl),t($n),t(gl),t(Qn),t(Cl),t(Xn),t(Bl),t(En),t(vl),t(Yn),t(Gl),t(xn),t(Rn),t(Sn),t(Wl),t(Fn),t(Vn),t(Hn),t(Nn),t(Ql),t(zn),t(Xl),t(qn),t(Ln),t(Yl),t(Dn),t(Pn),t(Kn),t(On),t(la),t(Sl),t(ea),t(Fl),t(ta),t(sa),t(na),t(Vl),t(aa),t(Hl),t(Ma),t(Nl),t(ia),t(zl),t(pa),t(ql),t(oa),t(Ll),t(ra),t(Dl),t(ya),t(Ja),t(wa),t(Ta),t(le),t(ma),t(ja),t(te),t(Ua),t(ua),t(ca),t(ae),t(ha),t(Me),t(da),t(ie),t(Ia),t(pe),t(ba),t(fa),t(re),t(ga),t(ye),t(Ca),t(Je),t(Ba),t(we),t(va),t(Ga),t(me),t(Za),t(f),t(Aa),t(je),t(Wa),t(ka),t(_a),t($a),t(Qa),t(Xa),t(Ea),t(Ya),t(xa),t(ge),t(Ra),t(Ce),t(Sa),t(Be),t(Fa),t(g),t(Va),t(Ha),t(Na),t(za),t(qa),t(We),t(La),t(ke),t(Da),t(_e),t(Pa),t($e),t(Ka),t(C),t(Oa),t(lM),t(eM),t(tM),t(sM),t(xe),t(nM),t(Re),t(aM),t(MM),t(iM),t(B),t(pM),t(Ve),t(oM),t(rM),t(yM),t(JM),t(wM),t(TM),t(mM),t(jM),t(UM),t(uM),t(lt),t(cM),t(hM),t(dM),t(st),t(IM),t(bM),t(fM),t(Mt),t(gM),t(it),t(CM),t(v),t(BM),t(pt),t(vM),t(GM),t(ZM),t(AM),t(WM),t(kM),t(Tt),t(_M),t(mt),t($M),t(jt),t(QM),t(Ut),t(XM),t(ut),t(EM),t(ct),t(YM),t(ht),t(xM),t(dt),t(RM),t(SM),t(bt),t(FM),t(ft),t(VM),t(gt),t(HM),t(NM),t(Bt),t(zM),t(vt),t(qM),t(LM),t(DM),t(At),t(PM),t(KM),t(OM),t(li),t(ei),t(_t),t(ti),t($t),t(si),t(ni),t(ai),t(Qt),t(Mi),t(Xt),t(ii),t(Et),t(pi),t(oi),t(xt),t(ri),t(yi),t(Ji),t(Ft),t(wi),t(Vt),t(Ti),t(Ht),t(mi),t(Nt),t(ji),t(Ui),t(ui),t(Lt),t(ci),t(hi),t(di),t(Ii),t(bi),t(ls),t(fi),t(gi),t(Ci),t(ss),t(Bi),t(ns),t(vi),t(Gi),t(Ms),t(Zi),t(is),t(Ai),t(ps),t(Wi),t(os),t(ki),t(G),t(_i),t(rs),t($i),t(Qi),t(Xi),t(Ei),t(Yi),t(xi),t(Ri),t(Us),t(Si),t(us),t(Fi),t(cs),t(Vi),t(hs),t(Hi),t(ds),t(Ni),t(zi),t(qi),t(Is),t(Li),t(bs),t(Di),t(fs),t(Pi),t(gs),t(Ki),t(Cs),t(Oi),t(Bs),t(lp),t(vs),t(ep),t(Gs),t(tp),t(Zs),t(sp),t(np),t(ks)),t(c),T(Z,l),T(A,l),T(V,l),T(L,l),T(P,l),T(ll,l),T(sl,l),T(rl,l),T(wl,l),T(cl,l),T(bl,l),T(Zl,l),T(Al,l),T(kl,l),T(_l,l),T($l,l),T(El,l),T(xl,l),T(Rl,l),T(Pl,l),T(Kl,l),T(Ol,l),T(ee,l),T(se,l),T(ne,l),T(oe,l),T(Te,l),T(Ue,l),T(ue,l),T(ce,l),T(he,l),T(de,l),T(Ie,l),T(be,l),T(fe,l),T(ve,l),T(Ge,l),T(Ze,l),T(Ae,l),T(Qe,l),T(Xe,l),T(Ee,l),T(Ye,l),T(Se,l),T(Fe,l),T(He,l),T(Ne,l),T(ze,l),T(qe,l),T(Le,l),T(De,l),T(Pe,l),T(Ke,l),T(Oe,l),T(et,l),T(tt,l),T(nt,l),T(at,l),T(ot,l),T(rt,l),T(yt,l),T(Jt,l),T(wt,l),T(It,l),T(Ct,l),T(Gt,l),T(Zt,l),T(Wt,l),T(kt,l),T(Yt,l),T(Rt,l),T(St,l),T(zt,l),T(qt,l),T(Dt,l),T(Pt,l),T(Kt,l),T(Ot,l),T(es,l),T(ts,l),T(as,l),T(ys,l),T(Js,l),T(ws,l),T(Ts,l),T(ms,l),T(js,l),T(As,l)}}}const Dr='{"title":"Hands-on","local":"hands-on","sections":[],"depth":1}';function Pr(Mp){return Fr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sy extends Vr{constructor(c){super(),Hr(this,c,Pr,Lr,Rr,{})}}export{sy as component};
