import{s as On,o as Qn,n as P}from"../chunks/scheduler.182ea377.js";import{S as Kn,i as ea,g as s,s as n,r as m,A as oa,h as i,f as d,c as a,j as L,u as p,x,k as T,y as o,a as b,v as u,d as h,t as g,w as _}from"../chunks/index.abf12888.js";import{T as ht}from"../chunks/Tip.230e2334.js";import{D as k}from"../chunks/Docstring.93f6f462.js";import{C as vo}from"../chunks/CodeBlock.57fe6e13.js";import{E as bo}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Te}from"../chunks/Heading.16916d63.js";function ta(C){let r,y='🧪 The <code>LoaderMixins</code> are highly experimental and prone to future changes. To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with <code>huggingface-cli login</code>.';return{c(){r=s("p"),r.innerHTML=y},l(c){r=i(c,"P",{"data-svelte-h":!0}),x(r)!=="svelte-vucowe"&&(r.innerHTML=y)},m(c,l){b(c,r,l)},p:P,d(c){c&&d(r)}}}function ra(C){let r,y="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,l,v;return l=new vo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-1y13ww6"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function na(C){let r,y="locally:",c,l,v;return l=new vo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-4c75kq"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function aa(C){let r,y="This is an experimental API.";return{c(){r=s("p"),r.textContent=y},l(c){r=i(c,"P",{"data-svelte-h":!0}),x(r)!=="svelte-8w79b9"&&(r.textContent=y)},m(c,l){b(c,r,l)},p:P,d(c){c&&d(r)}}}function sa(C){let r,y="Example:",c,l,v;return l=new vo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMkNpcm9OMjAyMiUyRnRveS1mYWNlJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJ0b3lfZmFjZV9zZHhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIydG95JTIyKSUwQXBpcGVsaW5lLmdldF9hY3RpdmVfYWRhcHRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy&quot;</span>)
pipeline.get_active_adapters()`,wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-11lpom8"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function ia(C){let r,y="We support loading A1111 formatted LoRA checkpoints in a limited capacity.",c,l,v="This function is experimental and might change in the future.";return{c(){r=s("p"),r.textContent=y,c=n(),l=s("p"),l.textContent=v},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-15l1sdn"&&(r.textContent=y),c=a(t),l=i(t,"P",{"data-svelte-h":!0}),x(l)!=="svelte-3fufvn"&&(l.textContent=v)},m(t,w){b(t,r,w),b(t,c,w),b(t,l,w)},p:P,d(t){t&&(d(r),d(c),d(l))}}}function da(C){let r,y="This is an experimental API.";return{c(){r=s("p"),r.textContent=y},l(c){r=i(c,"P",{"data-svelte-h":!0}),x(r)!=="svelte-8w79b9"&&(r.textContent=y)},m(c,l){b(c,r,l)},p:P,d(c){c&&d(r)}}}function la(C){let r,y="Examples:",c,l,v;return l=new vo({props:{code:"JTIzJTIwQXNzdW1pbmclMjAlNjBwaXBlbGluZSU2MCUyMGlzJTIwYWxyZWFkeSUyMGxvYWRlZCUyMHdpdGglMjB0aGUlMjBMb1JBJTIwcGFyYW1ldGVycy4lMEFwaXBlbGluZS51bmxvYWRfbG9yYV93ZWlnaHRzKCklMEEuLi4=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming `pipeline` is already loaded with the LoRA parameters.</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.unload_lora_weights()\n<span class="hljs-meta">&gt;&gt;&gt; </span>...',wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-kvfsh7"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function ca(C){let r,y="Examples:",c,l,v;return l=new vo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-kvfsh7"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function fa(C){let r,y="Examples:",c,l,v;return l=new vo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGQ29udHJvbE5ldC12MS0xJTJGYmxvYiUyRm1haW4lMkZjb250cm9sX3YxMXBfc2QxNV9jYW5ueS5wdGglMjIlMjAlMjAlMjMlMjBjYW4lMjBhbHNvJTIwYmUlMjBhJTIwbG9jYWwlMjBwYXRoJTBBbW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9zaW5nbGVfZmlsZSh1cmwpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC5zYWZldGVuc29ycyUyMiUyMCUyMCUyMyUyMGNhbiUyMGFsc28lMjBiZSUyMGElMjBsb2NhbCUyMHBhdGglMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUodXJsJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel

url = <span class="hljs-string">&quot;https://huggingface.co/lllyasviel/ControlNet-v1-1/blob/main/control_v11p_sd15_canny.pth&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
model = ControlNetModel.from_single_file(url)

url = <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
pipe = StableDiffusionControlNetPipeline.from_single_file(url, controlnet=controlnet)`,wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-kvfsh7"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function ma(C){let r,y=`Make sure to pass both <code>image_size</code> and <code>scaling_factor</code> to <code>from_single_file()</code> if you want to load
a VAE that does accompany a stable diffusion model of v2 or higher or SDXL.`;return{c(){r=s("p"),r.innerHTML=y},l(c){r=i(c,"P",{"data-svelte-h":!0}),x(r)!=="svelte-1u4e4ei"&&(r.innerHTML=y)},m(c,l){b(c,r,l)},p:P,d(c){c&&d(r)}}}function pa(C){let r,y="Examples:",c,l,v;return l=new vo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzZC12YWUtZnQtbXNlLW9yaWdpbmFsJTJGYmxvYiUyRm1haW4lMkZ2YWUtZnQtbXNlLTg0MDAwMC1lbWEtcHJ1bmVkLnNhZmV0ZW5zb3JzJTIyJTIwJTIwJTIzJTIwY2FuJTIwYWxzbyUyMGJlJTIwbG9jYWwlMjBmaWxlJTBBbW9kZWwlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fc2luZ2xlX2ZpbGUodXJsKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

url = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sd-vae-ft-mse-original/blob/main/vae-ft-mse-840000-ema-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be local file</span>
model = AutoencoderKL.from_single_file(url)`,wrap:!1}}),{c(){r=s("p"),r.textContent=y,c=n(),m(l.$$.fragment)},l(t){r=i(t,"P",{"data-svelte-h":!0}),x(r)!=="svelte-kvfsh7"&&(r.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,r,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(r),d(c)),_(l,t)}}}function ua(C){let r,y,c,l,v,t,w,fn="Adapters (textual inversion, LoRA, hypernetworks) allow you to modify a diffusion model to generate images in a specific style without training or finetuning the entire model. The adapter weights are typically only a tiny fraction of the pretrained model’s which making them very portable. 🤗 Diffusers provides an easy-to-use <code>LoaderMixin</code> API to load adapter weights.",gt,K,_t,ke,xt,U,Ce,At,ee,Ue,Vt,yo,mn="Disables the active LoRA layers for the unet.",Ht,oe,Ie,zt,wo,pn="Enables the active LoRA layers for the unet.",Bt,te,Je,qt,$o,un=`Load pretrained attention processor layers into <a href="/docs/diffusers/v0.22.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>. Attention processor layers have to be
defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>attention_processor.py</code></a>
and be a <code>torch.nn.Module</code> class.`,Yt,re,Fe,Xt,Mo,hn=`Save an attention processor to a directory so that it can be reloaded using the
<a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs">load_attn_procs()</a> method.`,Ot,ne,Ne,Qt,Lo,gn="Sets the adapter layers for the unet.",bt,Ze,vt,W,De,Kt,To,_n="Load textual inversion tokens and embeddings to the tokenizer and text encoder.",er,I,We,or,ko,xn=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,tr,Co,bn="Example:",rr,ae,nr,Uo,vn=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,ar,se,sr,ie,Se,ir,Io,yn=`Processes prompts that include a special token corresponding to a multi-vector textual inversion embedding to
be replaced with multiple special tokens each corresponding to one of the vectors. If the prompt has no textual
inversion token or if the textual inversion token is a single vector, the input prompt is returned.`,yt,je,wt,R,Pe,dr,Jo,wn="This class overrides <code>LoraLoaderMixin</code> with LoRA loading/saving code that’s specific to SDXL",lr,J,Re,cr,Fo,$n=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,fr,No,Mn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",mr,Zo,Ln='See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',pr,Do,Tn=`See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,ur,Wo,kn=`See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,$t,Ge,Mt,$,Ee,hr,So,Cn=`Load LoRA layers into <a href="/docs/diffusers/v0.22.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow"><code>CLIPTextModel</code></a>.`,gr,de,Ae,_r,jo,Un="Disables the LoRA layers for the text encoder.",xr,le,Ve,br,Po,In="Enables the LoRA layers for the text encoder.",vr,A,He,yr,Ro,Jn="Fuses the LoRA parameters into the original parameters of the corresponding blocks.",wr,ce,$r,V,ze,Mr,Go,Fn="Gets the list of the current active adapters.",Lr,fe,Tr,me,Be,kr,Eo,Nn="Gets the current list of all available adapters in the pipeline.",Cr,pe,qe,Ur,Ao,Zn="This will load the LoRA layers specified in <code>state_dict</code> into <code>text_encoder</code>",Ir,ue,Ye,Jr,Vo,Dn="This will load the LoRA layers specified in <code>state_dict</code> into <code>unet</code>.",Fr,F,Xe,Nr,Ho,Wn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Zr,zo,Sn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Dr,Bo,jn='See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Wr,qo,Pn=`See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Sr,Yo,Rn=`See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,jr,H,Oe,Pr,Xo,Gn="Return state dict for lora weights and the network alphas.",Rr,he,Gr,ge,Qe,Er,Oo,En="Save the LoRA parameters corresponding to the UNet and text encoder.",Ar,_e,Ke,Vr,Qo,An="Sets the adapter layers for the text encoder.",Hr,xe,eo,zr,Ko,Vn=`Moves the LoRAs listed in <code>adapter_names</code> to a target device. Useful for offloading the LoRA to the CPU in case
you want to load multiple adapters and free some GPU memory.`,Br,z,oo,qr,et,Hn=`Reverses the effect of
<a href="https://huggingface.co/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.fuse_lora" rel="nofollow"><code>pipe.fuse_lora()</code></a>.`,Yr,be,Xr,B,to,Or,ot,zn="Unloads the LoRA parameters.",Qr,ve,Lt,ro,Tt,G,no,Kr,tt,Bn='Load model weights saved in the <code>.ckpt</code> format into a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',en,q,ao,on,rt,qn=`Instantiate a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,tn,ye,kt,so,Ct,X,io,rn,Y,lo,nn,nt,Yn=`Instantiate a <a href="/docs/diffusers/v0.22.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> from pretrained controlnet weights saved in the original <code>.ckpt</code> or
<code>.safetensors</code> format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,an,we,Ut,co,It,O,fo,sn,S,mo,dn,at,Xn=`Instantiate a <a href="/docs/diffusers/v0.22.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> from pretrained controlnet weights saved in the original <code>.ckpt</code> or
<code>.safetensors</code> format. The pipeline is format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by
default.`,ln,$e,cn,Me,Jt,ut,Ft;return v=new Te({props:{title:"Loaders",local:"loaders",headingTag:"h1"}}),K=new ht({props:{warning:!0,$$slots:{default:[ta]},$$scope:{ctx:C}}}),ke=new Te({props:{title:"UNet2DConditionLoadersMixin",local:"diffusers.loaders.UNet2DConditionLoadersMixin",headingTag:"h2"}}),Ce=new k({props:{name:"class diffusers.loaders.UNet2DConditionLoadersMixin",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L256"}}),Ue=new k({props:{name:"disable_lora",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L739"}}),Ie=new k({props:{name:"enable_lora",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.enable_lora",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L747"}}),Je=new k({props:{name:"load_attn_procs",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the model id (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a directory (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/v0.22.0/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L260"}}),Fe=new k({props:{name:"save_attn_procs",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save an attention processor to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L589"}}),Ne=new k({props:{name:"set_adapters",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"},{name:"weights",val:": typing.Union[typing.List[float], float, NoneType] = None"}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code> or <code>str</code>) &#x2014;
The names of the adapters to use.`,name:"adapter_names"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters.weights",description:`<strong>weights</strong> (<code>Union[List[float], float]</code>, <em>optional</em>) &#x2014;
The adapter(s) weights to use with the UNet. If <code>None</code>, the weights are set to <code>1.0</code> for all the
adapters.`,name:"weights"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L707"}}),Ze=new Te({props:{title:"TextualInversionLoaderMixin",local:"diffusers.loaders.TextualInversionLoaderMixin",headingTag:"h2"}}),De=new k({props:{name:"class diffusers.loaders.TextualInversionLoaderMixin",anchor:"diffusers.loaders.TextualInversionLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L831"}}),We=new k({props:{name:"load_textual_inversion",anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L984"}}),ae=new bo({props:{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.example",$$slots:{default:[ra]},$$scope:{ctx:C}}}),se=new bo({props:{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.example-2",$$slots:{default:[na]},$$scope:{ctx:C}}}),Se=new k({props:{name:"maybe_convert_prompt",anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"tokenizer",val:": PreTrainedTokenizer"}],parametersDescription:[{anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or list of <code>str</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The tokenizer responsible for encoding the prompt into input tokens.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted prompt</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or list of <code>str</code></p>
`}}),je=new Te({props:{title:"StableDiffusionXLLoraLoaderMixin",local:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",headingTag:"h2"}}),Pe=new k({props:{name:"class diffusers.loaders.StableDiffusionXLLoraLoaderMixin",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L3181"}}),Re=new k({props:{name:"load_lora_weights",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L3185"}}),Ge=new Te({props:{title:"LoraLoaderMixin",local:"diffusers.loaders.LoraLoaderMixin",headingTag:"h2"}}),Ee=new k({props:{name:"class diffusers.loaders.LoraLoaderMixin",anchor:"diffusers.loaders.LoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L1164"}}),Ae=new k({props:{name:"disable_lora_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.disable_lora_for_text_encoder",parameters:[{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.disable_lora_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to disable the LoRA layers for. If <code>None</code>, it will try to get the
<code>text_encoder</code> attribute.`,name:"text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2432"}}),Ve=new k({props:{name:"enable_lora_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.enable_lora_for_text_encoder",parameters:[{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.enable_lora_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to enable the LoRA layers for. If <code>None</code>, it will try to get the <code>text_encoder</code>
attribute.`,name:"text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2449"}}),He=new k({props:{name:"fuse_lora",anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora",parameters:[{name:"fuse_unet",val:": bool = True"},{name:"fuse_text_encoder",val:": bool = True"},{name:"lora_scale",val:": float = 1.0"},{name:"safe_fusing",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.fuse_unet",description:"<strong>fuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to fuse the UNet LoRA parameters.",name:"fuse_unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.fuse_text_encoder",description:`<strong>fuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to fuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"fuse_text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, defaults to 1.0) &#x2014;
Controls how much to influence the outputs with the LoRA parameters.`,name:"lora_scale"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.safe_fusing",description:`<strong>safe_fusing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to check fused weights for NaN values before fusing and if values are NaN not fusing them.`,name:"safe_fusing"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2259"}}),ce=new ht({props:{warning:!0,$$slots:{default:[aa]},$$scope:{ctx:C}}}),ze=new k({props:{name:"get_active_adapters",anchor:"diffusers.loaders.LoraLoaderMixin.get_active_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2505"}}),fe=new bo({props:{anchor:"diffusers.loaders.LoraLoaderMixin.get_active_adapters.example",$$slots:{default:[sa]},$$scope:{ctx:C}}}),Be=new k({props:{name:"get_list_adapters",anchor:"diffusers.loaders.LoraLoaderMixin.get_list_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2537"}}),qe=new k({props:{name:"load_lora_into_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"text_encoder",val:""},{name:"prefix",val:" = None"},{name:"lora_scale",val:" = 1.0"},{name:"low_cpu_mem_usage",val:" = None"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The key should be prefixed with an
additional <code>text_encoder</code> to distinguish between unet lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
See <code>LoRALinearLayer</code> for more details.`,name:"network_alphas"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The text encoder model to load the LoRA layers into.`,name:"text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.prefix",description:`<strong>prefix</strong> (<code>str</code>) &#x2014;
Expected prefix of the <code>text_encoder</code> in the <code>state_dict</code>.`,name:"prefix"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>) &#x2014;
How much to scale the output of the lora linear layer before it is added with the output of the regular
lora layer.`,name:"lora_scale"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L1659"}}),Ye=new k({props:{name:"load_lora_into_unet",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"unet",val:""},{name:"low_cpu_mem_usage",val:" = None"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
See <code>LoRALinearLayer</code> for more details.`,name:"network_alphas"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
The UNet model to load the LoRA layers into.`,name:"unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L1555"}}),Xe=new k({props:{name:"load_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/v0.22.0/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L1173"}}),Oe=new k({props:{name:"lora_state_dict",anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/v0.22.0/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L1228"}}),he=new ht({props:{warning:!0,$$slots:{default:[ia]},$$scope:{ctx:C}}}),Qe=new k({props:{name:"save_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L1964"}}),Ke=new k({props:{name:"set_adapters_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"text_encoder_weights",val:": typing.List[float] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code> or <code>str</code>) &#x2014;
The names of the adapters to use.`,name:"adapter_names"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to set the adapter layers for. If <code>None</code>, it will try to get the <code>text_encoder</code>
attribute.`,name:"text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder.text_encoder_weights",description:`<strong>text_encoder_weights</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
The weights to use for the text encoder. If <code>None</code>, the weights are set to <code>1.0</code> for all the adapters.`,name:"text_encoder_weights"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2390"}}),eo=new k({props:{name:"set_lora_device",anchor:"diffusers.loaders.LoraLoaderMixin.set_lora_device",parameters:[{name:"adapter_names",val:": typing.List[str]"},{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.set_lora_device.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code>) &#x2014;
List of adapters to send device to.`,name:"adapter_names"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_lora_device.device",description:`<strong>device</strong> (<code>Union[torch.device, str, int]</code>) &#x2014;
Device to send the adapters to. Can be either a torch device, a str or an integer.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2559"}}),oo=new k({props:{name:"unfuse_lora",anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora",parameters:[{name:"unfuse_unet",val:": bool = True"},{name:"unfuse_text_encoder",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora.unfuse_unet",description:"<strong>unfuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to unfuse the UNet LoRA parameters.",name:"unfuse_unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora.unfuse_text_encoder",description:`<strong>unfuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to unfuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"unfuse_text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2330"}}),be=new ht({props:{warning:!0,$$slots:{default:[da]},$$scope:{ctx:C}}}),to=new k({props:{name:"unload_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.unload_lora_weights",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2229"}}),ve=new bo({props:{anchor:"diffusers.loaders.LoraLoaderMixin.unload_lora_weights.example",$$slots:{default:[la]},$$scope:{ctx:C}}}),ro=new Te({props:{title:"FromSingleFileMixin",local:"diffusers.loaders.FromSingleFileMixin",headingTag:"h2"}}),no=new k({props:{name:"class diffusers.loaders.FromSingleFileMixin",anchor:"diffusers.loaders.FromSingleFileMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2599"}}),ao=new k({props:{name:"from_single_file",anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2610"}}),ye=new bo({props:{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.example",$$slots:{default:[ca]},$$scope:{ctx:C}}}),so=new Te({props:{title:"FromOriginalControlnetMixin",local:"diffusers.loaders.FromOriginalControlnetMixin",headingTag:"h2"}}),io=new k({props:{name:"class diffusers.loaders.FromOriginalControlnetMixin",anchor:"diffusers.loaders.FromOriginalControlnetMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L3038"}}),lo=new k({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L3039"}}),we=new bo({props:{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.example",$$slots:{default:[fa]},$$scope:{ctx:C}}}),co=new Te({props:{title:"FromOriginalVAEMixin",local:"diffusers.loaders.FromOriginalVAEMixin",headingTag:"h2"}}),fo=new k({props:{name:"class diffusers.loaders.FromOriginalVAEMixin",anchor:"diffusers.loaders.FromOriginalVAEMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2846"}}),mo=new k({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution
Image Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/loaders.py#L2847"}}),$e=new ht({props:{warning:!0,$$slots:{default:[ma]},$$scope:{ctx:C}}}),Me=new bo({props:{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.example",$$slots:{default:[pa]},$$scope:{ctx:C}}}),{c(){r=s("meta"),y=n(),c=s("p"),l=n(),m(v.$$.fragment),t=n(),w=s("p"),w.innerHTML=fn,gt=n(),m(K.$$.fragment),_t=n(),m(ke.$$.fragment),xt=n(),U=s("div"),m(Ce.$$.fragment),At=n(),ee=s("div"),m(Ue.$$.fragment),Vt=n(),yo=s("p"),yo.textContent=mn,Ht=n(),oe=s("div"),m(Ie.$$.fragment),zt=n(),wo=s("p"),wo.textContent=pn,Bt=n(),te=s("div"),m(Je.$$.fragment),qt=n(),$o=s("p"),$o.innerHTML=un,Yt=n(),re=s("div"),m(Fe.$$.fragment),Xt=n(),Mo=s("p"),Mo.innerHTML=hn,Ot=n(),ne=s("div"),m(Ne.$$.fragment),Qt=n(),Lo=s("p"),Lo.textContent=gn,bt=n(),m(Ze.$$.fragment),vt=n(),W=s("div"),m(De.$$.fragment),Kt=n(),To=s("p"),To.textContent=_n,er=n(),I=s("div"),m(We.$$.fragment),or=n(),ko=s("p"),ko.innerHTML=xn,tr=n(),Co=s("p"),Co.textContent=bn,rr=n(),m(ae.$$.fragment),nr=n(),Uo=s("p"),Uo.innerHTML=vn,ar=n(),m(se.$$.fragment),sr=n(),ie=s("div"),m(Se.$$.fragment),ir=n(),Io=s("p"),Io.textContent=yn,yt=n(),m(je.$$.fragment),wt=n(),R=s("div"),m(Pe.$$.fragment),dr=n(),Jo=s("p"),Jo.innerHTML=wn,lr=n(),J=s("div"),m(Re.$$.fragment),cr=n(),Fo=s("p"),Fo.innerHTML=$n,fr=n(),No=s("p"),No.innerHTML=Mn,mr=n(),Zo=s("p"),Zo.innerHTML=Ln,pr=n(),Do=s("p"),Do.innerHTML=Tn,ur=n(),Wo=s("p"),Wo.innerHTML=kn,$t=n(),m(Ge.$$.fragment),Mt=n(),$=s("div"),m(Ee.$$.fragment),hr=n(),So=s("p"),So.innerHTML=Cn,gr=n(),de=s("div"),m(Ae.$$.fragment),_r=n(),jo=s("p"),jo.textContent=Un,xr=n(),le=s("div"),m(Ve.$$.fragment),br=n(),Po=s("p"),Po.textContent=In,vr=n(),A=s("div"),m(He.$$.fragment),yr=n(),Ro=s("p"),Ro.textContent=Jn,wr=n(),m(ce.$$.fragment),$r=n(),V=s("div"),m(ze.$$.fragment),Mr=n(),Go=s("p"),Go.textContent=Fn,Lr=n(),m(fe.$$.fragment),Tr=n(),me=s("div"),m(Be.$$.fragment),kr=n(),Eo=s("p"),Eo.textContent=Nn,Cr=n(),pe=s("div"),m(qe.$$.fragment),Ur=n(),Ao=s("p"),Ao.innerHTML=Zn,Ir=n(),ue=s("div"),m(Ye.$$.fragment),Jr=n(),Vo=s("p"),Vo.innerHTML=Dn,Fr=n(),F=s("div"),m(Xe.$$.fragment),Nr=n(),Ho=s("p"),Ho.innerHTML=Wn,Zr=n(),zo=s("p"),zo.innerHTML=Sn,Dr=n(),Bo=s("p"),Bo.innerHTML=jn,Wr=n(),qo=s("p"),qo.innerHTML=Pn,Sr=n(),Yo=s("p"),Yo.innerHTML=Rn,jr=n(),H=s("div"),m(Oe.$$.fragment),Pr=n(),Xo=s("p"),Xo.textContent=Gn,Rr=n(),m(he.$$.fragment),Gr=n(),ge=s("div"),m(Qe.$$.fragment),Er=n(),Oo=s("p"),Oo.textContent=En,Ar=n(),_e=s("div"),m(Ke.$$.fragment),Vr=n(),Qo=s("p"),Qo.textContent=An,Hr=n(),xe=s("div"),m(eo.$$.fragment),zr=n(),Ko=s("p"),Ko.innerHTML=Vn,Br=n(),z=s("div"),m(oo.$$.fragment),qr=n(),et=s("p"),et.innerHTML=Hn,Yr=n(),m(be.$$.fragment),Xr=n(),B=s("div"),m(to.$$.fragment),Or=n(),ot=s("p"),ot.textContent=zn,Qr=n(),m(ve.$$.fragment),Lt=n(),m(ro.$$.fragment),Tt=n(),G=s("div"),m(no.$$.fragment),Kr=n(),tt=s("p"),tt.innerHTML=Bn,en=n(),q=s("div"),m(ao.$$.fragment),on=n(),rt=s("p"),rt.innerHTML=qn,tn=n(),m(ye.$$.fragment),kt=n(),m(so.$$.fragment),Ct=n(),X=s("div"),m(io.$$.fragment),rn=n(),Y=s("div"),m(lo.$$.fragment),nn=n(),nt=s("p"),nt.innerHTML=Yn,an=n(),m(we.$$.fragment),Ut=n(),m(co.$$.fragment),It=n(),O=s("div"),m(fo.$$.fragment),sn=n(),S=s("div"),m(mo.$$.fragment),dn=n(),at=s("p"),at.innerHTML=Xn,ln=n(),m($e.$$.fragment),cn=n(),m(Me.$$.fragment),Jt=n(),ut=s("p"),this.h()},l(e){const f=oa("svelte-u9bgzb",document.head);r=i(f,"META",{name:!0,content:!0}),f.forEach(d),y=a(e),c=i(e,"P",{}),L(c).forEach(d),l=a(e),p(v.$$.fragment,e),t=a(e),w=i(e,"P",{"data-svelte-h":!0}),x(w)!=="svelte-dvj0a"&&(w.innerHTML=fn),gt=a(e),p(K.$$.fragment,e),_t=a(e),p(ke.$$.fragment,e),xt=a(e),U=i(e,"DIV",{class:!0});var N=L(U);p(Ce.$$.fragment,N),At=a(N),ee=i(N,"DIV",{class:!0});var po=L(ee);p(Ue.$$.fragment,po),Vt=a(po),yo=i(po,"P",{"data-svelte-h":!0}),x(yo)!=="svelte-6zpqka"&&(yo.textContent=mn),po.forEach(d),Ht=a(N),oe=i(N,"DIV",{class:!0});var uo=L(oe);p(Ie.$$.fragment,uo),zt=a(uo),wo=i(uo,"P",{"data-svelte-h":!0}),x(wo)!=="svelte-1wwvhh7"&&(wo.textContent=pn),uo.forEach(d),Bt=a(N),te=i(N,"DIV",{class:!0});var ho=L(te);p(Je.$$.fragment,ho),qt=a(ho),$o=i(ho,"P",{"data-svelte-h":!0}),x($o)!=="svelte-1obcn07"&&($o.innerHTML=un),ho.forEach(d),Yt=a(N),re=i(N,"DIV",{class:!0});var go=L(re);p(Fe.$$.fragment,go),Xt=a(go),Mo=i(go,"P",{"data-svelte-h":!0}),x(Mo)!=="svelte-1jd716v"&&(Mo.innerHTML=hn),go.forEach(d),Ot=a(N),ne=i(N,"DIV",{class:!0});var _o=L(ne);p(Ne.$$.fragment,_o),Qt=a(_o),Lo=i(_o,"P",{"data-svelte-h":!0}),x(Lo)!=="svelte-1mxhf81"&&(Lo.textContent=gn),_o.forEach(d),N.forEach(d),bt=a(e),p(Ze.$$.fragment,e),vt=a(e),W=i(e,"DIV",{class:!0});var E=L(W);p(De.$$.fragment,E),Kt=a(E),To=i(E,"P",{"data-svelte-h":!0}),x(To)!=="svelte-100hk3u"&&(To.textContent=_n),er=a(E),I=i(E,"DIV",{class:!0});var Z=L(I);p(We.$$.fragment,Z),or=a(Z),ko=i(Z,"P",{"data-svelte-h":!0}),x(ko)!=="svelte-1xp53tt"&&(ko.innerHTML=xn),tr=a(Z),Co=i(Z,"P",{"data-svelte-h":!0}),x(Co)!=="svelte-11lpom8"&&(Co.textContent=bn),rr=a(Z),p(ae.$$.fragment,Z),nr=a(Z),Uo=i(Z,"P",{"data-svelte-h":!0}),x(Uo)!=="svelte-2gddoh"&&(Uo.innerHTML=vn),ar=a(Z),p(se.$$.fragment,Z),Z.forEach(d),sr=a(E),ie=i(E,"DIV",{class:!0});var xo=L(ie);p(Se.$$.fragment,xo),ir=a(xo),Io=i(xo,"P",{"data-svelte-h":!0}),x(Io)!=="svelte-gjjmbb"&&(Io.textContent=yn),xo.forEach(d),E.forEach(d),yt=a(e),p(je.$$.fragment,e),wt=a(e),R=i(e,"DIV",{class:!0});var Q=L(R);p(Pe.$$.fragment,Q),dr=a(Q),Jo=i(Q,"P",{"data-svelte-h":!0}),x(Jo)!=="svelte-1powver"&&(Jo.innerHTML=wn),lr=a(Q),J=i(Q,"DIV",{class:!0});var D=L(J);p(Re.$$.fragment,D),cr=a(D),Fo=i(D,"P",{"data-svelte-h":!0}),x(Fo)!=="svelte-vs7s0z"&&(Fo.innerHTML=$n),fr=a(D),No=i(D,"P",{"data-svelte-h":!0}),x(No)!=="svelte-15b960v"&&(No.innerHTML=Mn),mr=a(D),Zo=i(D,"P",{"data-svelte-h":!0}),x(Zo)!=="svelte-1hejxy6"&&(Zo.innerHTML=Ln),pr=a(D),Do=i(D,"P",{"data-svelte-h":!0}),x(Do)!=="svelte-u7vv45"&&(Do.innerHTML=Tn),ur=a(D),Wo=i(D,"P",{"data-svelte-h":!0}),x(Wo)!=="svelte-1tt9kbb"&&(Wo.innerHTML=kn),D.forEach(d),Q.forEach(d),$t=a(e),p(Ge.$$.fragment,e),Mt=a(e),$=i(e,"DIV",{class:!0});var M=L($);p(Ee.$$.fragment,M),hr=a(M),So=i(M,"P",{"data-svelte-h":!0}),x(So)!=="svelte-1icmo18"&&(So.innerHTML=Cn),gr=a(M),de=i(M,"DIV",{class:!0});var Nt=L(de);p(Ae.$$.fragment,Nt),_r=a(Nt),jo=i(Nt,"P",{"data-svelte-h":!0}),x(jo)!=="svelte-tbr0r9"&&(jo.textContent=Un),Nt.forEach(d),xr=a(M),le=i(M,"DIV",{class:!0});var Zt=L(le);p(Ve.$$.fragment,Zt),br=a(Zt),Po=i(Zt,"P",{"data-svelte-h":!0}),x(Po)!=="svelte-ujvdgi"&&(Po.textContent=In),Zt.forEach(d),vr=a(M),A=i(M,"DIV",{class:!0});var st=L(A);p(He.$$.fragment,st),yr=a(st),Ro=i(st,"P",{"data-svelte-h":!0}),x(Ro)!=="svelte-1nr2dy0"&&(Ro.textContent=Jn),wr=a(st),p(ce.$$.fragment,st),st.forEach(d),$r=a(M),V=i(M,"DIV",{class:!0});var it=L(V);p(ze.$$.fragment,it),Mr=a(it),Go=i(it,"P",{"data-svelte-h":!0}),x(Go)!=="svelte-h0os0v"&&(Go.textContent=Fn),Lr=a(it),p(fe.$$.fragment,it),it.forEach(d),Tr=a(M),me=i(M,"DIV",{class:!0});var Dt=L(me);p(Be.$$.fragment,Dt),kr=a(Dt),Eo=i(Dt,"P",{"data-svelte-h":!0}),x(Eo)!=="svelte-1825k9e"&&(Eo.textContent=Nn),Dt.forEach(d),Cr=a(M),pe=i(M,"DIV",{class:!0});var Wt=L(pe);p(qe.$$.fragment,Wt),Ur=a(Wt),Ao=i(Wt,"P",{"data-svelte-h":!0}),x(Ao)!=="svelte-1062ci4"&&(Ao.innerHTML=Zn),Wt.forEach(d),Ir=a(M),ue=i(M,"DIV",{class:!0});var St=L(ue);p(Ye.$$.fragment,St),Jr=a(St),Vo=i(St,"P",{"data-svelte-h":!0}),x(Vo)!=="svelte-u3q4so"&&(Vo.innerHTML=Dn),St.forEach(d),Fr=a(M),F=i(M,"DIV",{class:!0});var j=L(F);p(Xe.$$.fragment,j),Nr=a(j),Ho=i(j,"P",{"data-svelte-h":!0}),x(Ho)!=="svelte-vs7s0z"&&(Ho.innerHTML=Wn),Zr=a(j),zo=i(j,"P",{"data-svelte-h":!0}),x(zo)!=="svelte-15b960v"&&(zo.innerHTML=Sn),Dr=a(j),Bo=i(j,"P",{"data-svelte-h":!0}),x(Bo)!=="svelte-1hejxy6"&&(Bo.innerHTML=jn),Wr=a(j),qo=i(j,"P",{"data-svelte-h":!0}),x(qo)!=="svelte-u7vv45"&&(qo.innerHTML=Pn),Sr=a(j),Yo=i(j,"P",{"data-svelte-h":!0}),x(Yo)!=="svelte-1tt9kbb"&&(Yo.innerHTML=Rn),j.forEach(d),jr=a(M),H=i(M,"DIV",{class:!0});var dt=L(H);p(Oe.$$.fragment,dt),Pr=a(dt),Xo=i(dt,"P",{"data-svelte-h":!0}),x(Xo)!=="svelte-flusvq"&&(Xo.textContent=Gn),Rr=a(dt),p(he.$$.fragment,dt),dt.forEach(d),Gr=a(M),ge=i(M,"DIV",{class:!0});var jt=L(ge);p(Qe.$$.fragment,jt),Er=a(jt),Oo=i(jt,"P",{"data-svelte-h":!0}),x(Oo)!=="svelte-1ufq5ot"&&(Oo.textContent=En),jt.forEach(d),Ar=a(M),_e=i(M,"DIV",{class:!0});var Pt=L(_e);p(Ke.$$.fragment,Pt),Vr=a(Pt),Qo=i(Pt,"P",{"data-svelte-h":!0}),x(Qo)!=="svelte-kmejci"&&(Qo.textContent=An),Pt.forEach(d),Hr=a(M),xe=i(M,"DIV",{class:!0});var Rt=L(xe);p(eo.$$.fragment,Rt),zr=a(Rt),Ko=i(Rt,"P",{"data-svelte-h":!0}),x(Ko)!=="svelte-rvubqa"&&(Ko.innerHTML=Vn),Rt.forEach(d),Br=a(M),z=i(M,"DIV",{class:!0});var lt=L(z);p(oo.$$.fragment,lt),qr=a(lt),et=i(lt,"P",{"data-svelte-h":!0}),x(et)!=="svelte-56a0bo"&&(et.innerHTML=Hn),Yr=a(lt),p(be.$$.fragment,lt),lt.forEach(d),Xr=a(M),B=i(M,"DIV",{class:!0});var ct=L(B);p(to.$$.fragment,ct),Or=a(ct),ot=i(ct,"P",{"data-svelte-h":!0}),x(ot)!=="svelte-119cgd9"&&(ot.textContent=zn),Qr=a(ct),p(ve.$$.fragment,ct),ct.forEach(d),M.forEach(d),Lt=a(e),p(ro.$$.fragment,e),Tt=a(e),G=i(e,"DIV",{class:!0});var ft=L(G);p(no.$$.fragment,ft),Kr=a(ft),tt=i(ft,"P",{"data-svelte-h":!0}),x(tt)!=="svelte-p6b329"&&(tt.innerHTML=Bn),en=a(ft),q=i(ft,"DIV",{class:!0});var mt=L(q);p(ao.$$.fragment,mt),on=a(mt),rt=i(mt,"P",{"data-svelte-h":!0}),x(rt)!=="svelte-1fjfhq"&&(rt.innerHTML=qn),tn=a(mt),p(ye.$$.fragment,mt),mt.forEach(d),ft.forEach(d),kt=a(e),p(so.$$.fragment,e),Ct=a(e),X=i(e,"DIV",{class:!0});var Gt=L(X);p(io.$$.fragment,Gt),rn=a(Gt),Y=i(Gt,"DIV",{class:!0});var pt=L(Y);p(lo.$$.fragment,pt),nn=a(pt),nt=i(pt,"P",{"data-svelte-h":!0}),x(nt)!=="svelte-1yixtaf"&&(nt.innerHTML=Yn),an=a(pt),p(we.$$.fragment,pt),pt.forEach(d),Gt.forEach(d),Ut=a(e),p(co.$$.fragment,e),It=a(e),O=i(e,"DIV",{class:!0});var Et=L(O);p(fo.$$.fragment,Et),sn=a(Et),S=i(Et,"DIV",{class:!0});var Le=L(S);p(mo.$$.fragment,Le),dn=a(Le),at=i(Le,"P",{"data-svelte-h":!0}),x(at)!=="svelte-jdz623"&&(at.innerHTML=Xn),ln=a(Le),p($e.$$.fragment,Le),cn=a(Le),p(Me.$$.fragment,Le),Le.forEach(d),Et.forEach(d),Jt=a(e),ut=i(e,"P",{}),L(ut).forEach(d),this.h()},h(){T(r,"name","hf:doc:metadata"),T(r,"content",ha),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){o(document.head,r),b(e,y,f),b(e,c,f),b(e,l,f),u(v,e,f),b(e,t,f),b(e,w,f),b(e,gt,f),u(K,e,f),b(e,_t,f),u(ke,e,f),b(e,xt,f),b(e,U,f),u(Ce,U,null),o(U,At),o(U,ee),u(Ue,ee,null),o(ee,Vt),o(ee,yo),o(U,Ht),o(U,oe),u(Ie,oe,null),o(oe,zt),o(oe,wo),o(U,Bt),o(U,te),u(Je,te,null),o(te,qt),o(te,$o),o(U,Yt),o(U,re),u(Fe,re,null),o(re,Xt),o(re,Mo),o(U,Ot),o(U,ne),u(Ne,ne,null),o(ne,Qt),o(ne,Lo),b(e,bt,f),u(Ze,e,f),b(e,vt,f),b(e,W,f),u(De,W,null),o(W,Kt),o(W,To),o(W,er),o(W,I),u(We,I,null),o(I,or),o(I,ko),o(I,tr),o(I,Co),o(I,rr),u(ae,I,null),o(I,nr),o(I,Uo),o(I,ar),u(se,I,null),o(W,sr),o(W,ie),u(Se,ie,null),o(ie,ir),o(ie,Io),b(e,yt,f),u(je,e,f),b(e,wt,f),b(e,R,f),u(Pe,R,null),o(R,dr),o(R,Jo),o(R,lr),o(R,J),u(Re,J,null),o(J,cr),o(J,Fo),o(J,fr),o(J,No),o(J,mr),o(J,Zo),o(J,pr),o(J,Do),o(J,ur),o(J,Wo),b(e,$t,f),u(Ge,e,f),b(e,Mt,f),b(e,$,f),u(Ee,$,null),o($,hr),o($,So),o($,gr),o($,de),u(Ae,de,null),o(de,_r),o(de,jo),o($,xr),o($,le),u(Ve,le,null),o(le,br),o(le,Po),o($,vr),o($,A),u(He,A,null),o(A,yr),o(A,Ro),o(A,wr),u(ce,A,null),o($,$r),o($,V),u(ze,V,null),o(V,Mr),o(V,Go),o(V,Lr),u(fe,V,null),o($,Tr),o($,me),u(Be,me,null),o(me,kr),o(me,Eo),o($,Cr),o($,pe),u(qe,pe,null),o(pe,Ur),o(pe,Ao),o($,Ir),o($,ue),u(Ye,ue,null),o(ue,Jr),o(ue,Vo),o($,Fr),o($,F),u(Xe,F,null),o(F,Nr),o(F,Ho),o(F,Zr),o(F,zo),o(F,Dr),o(F,Bo),o(F,Wr),o(F,qo),o(F,Sr),o(F,Yo),o($,jr),o($,H),u(Oe,H,null),o(H,Pr),o(H,Xo),o(H,Rr),u(he,H,null),o($,Gr),o($,ge),u(Qe,ge,null),o(ge,Er),o(ge,Oo),o($,Ar),o($,_e),u(Ke,_e,null),o(_e,Vr),o(_e,Qo),o($,Hr),o($,xe),u(eo,xe,null),o(xe,zr),o(xe,Ko),o($,Br),o($,z),u(oo,z,null),o(z,qr),o(z,et),o(z,Yr),u(be,z,null),o($,Xr),o($,B),u(to,B,null),o(B,Or),o(B,ot),o(B,Qr),u(ve,B,null),b(e,Lt,f),u(ro,e,f),b(e,Tt,f),b(e,G,f),u(no,G,null),o(G,Kr),o(G,tt),o(G,en),o(G,q),u(ao,q,null),o(q,on),o(q,rt),o(q,tn),u(ye,q,null),b(e,kt,f),u(so,e,f),b(e,Ct,f),b(e,X,f),u(io,X,null),o(X,rn),o(X,Y),u(lo,Y,null),o(Y,nn),o(Y,nt),o(Y,an),u(we,Y,null),b(e,Ut,f),u(co,e,f),b(e,It,f),b(e,O,f),u(fo,O,null),o(O,sn),o(O,S),u(mo,S,null),o(S,dn),o(S,at),o(S,ln),u($e,S,null),o(S,cn),u(Me,S,null),b(e,Jt,f),b(e,ut,f),Ft=!0},p(e,[f]){const N={};f&2&&(N.$$scope={dirty:f,ctx:e}),K.$set(N);const po={};f&2&&(po.$$scope={dirty:f,ctx:e}),ae.$set(po);const uo={};f&2&&(uo.$$scope={dirty:f,ctx:e}),se.$set(uo);const ho={};f&2&&(ho.$$scope={dirty:f,ctx:e}),ce.$set(ho);const go={};f&2&&(go.$$scope={dirty:f,ctx:e}),fe.$set(go);const _o={};f&2&&(_o.$$scope={dirty:f,ctx:e}),he.$set(_o);const E={};f&2&&(E.$$scope={dirty:f,ctx:e}),be.$set(E);const Z={};f&2&&(Z.$$scope={dirty:f,ctx:e}),ve.$set(Z);const xo={};f&2&&(xo.$$scope={dirty:f,ctx:e}),ye.$set(xo);const Q={};f&2&&(Q.$$scope={dirty:f,ctx:e}),we.$set(Q);const D={};f&2&&(D.$$scope={dirty:f,ctx:e}),$e.$set(D);const M={};f&2&&(M.$$scope={dirty:f,ctx:e}),Me.$set(M)},i(e){Ft||(h(v.$$.fragment,e),h(K.$$.fragment,e),h(ke.$$.fragment,e),h(Ce.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Je.$$.fragment,e),h(Fe.$$.fragment,e),h(Ne.$$.fragment,e),h(Ze.$$.fragment,e),h(De.$$.fragment,e),h(We.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(Se.$$.fragment,e),h(je.$$.fragment,e),h(Pe.$$.fragment,e),h(Re.$$.fragment,e),h(Ge.$$.fragment,e),h(Ee.$$.fragment,e),h(Ae.$$.fragment,e),h(Ve.$$.fragment,e),h(He.$$.fragment,e),h(ce.$$.fragment,e),h(ze.$$.fragment,e),h(fe.$$.fragment,e),h(Be.$$.fragment,e),h(qe.$$.fragment,e),h(Ye.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(he.$$.fragment,e),h(Qe.$$.fragment,e),h(Ke.$$.fragment,e),h(eo.$$.fragment,e),h(oo.$$.fragment,e),h(be.$$.fragment,e),h(to.$$.fragment,e),h(ve.$$.fragment,e),h(ro.$$.fragment,e),h(no.$$.fragment,e),h(ao.$$.fragment,e),h(ye.$$.fragment,e),h(so.$$.fragment,e),h(io.$$.fragment,e),h(lo.$$.fragment,e),h(we.$$.fragment,e),h(co.$$.fragment,e),h(fo.$$.fragment,e),h(mo.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),Ft=!0)},o(e){g(v.$$.fragment,e),g(K.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(Je.$$.fragment,e),g(Fe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ze.$$.fragment,e),g(De.$$.fragment,e),g(We.$$.fragment,e),g(ae.$$.fragment,e),g(se.$$.fragment,e),g(Se.$$.fragment,e),g(je.$$.fragment,e),g(Pe.$$.fragment,e),g(Re.$$.fragment,e),g(Ge.$$.fragment,e),g(Ee.$$.fragment,e),g(Ae.$$.fragment,e),g(Ve.$$.fragment,e),g(He.$$.fragment,e),g(ce.$$.fragment,e),g(ze.$$.fragment,e),g(fe.$$.fragment,e),g(Be.$$.fragment,e),g(qe.$$.fragment,e),g(Ye.$$.fragment,e),g(Xe.$$.fragment,e),g(Oe.$$.fragment,e),g(he.$$.fragment,e),g(Qe.$$.fragment,e),g(Ke.$$.fragment,e),g(eo.$$.fragment,e),g(oo.$$.fragment,e),g(be.$$.fragment,e),g(to.$$.fragment,e),g(ve.$$.fragment,e),g(ro.$$.fragment,e),g(no.$$.fragment,e),g(ao.$$.fragment,e),g(ye.$$.fragment,e),g(so.$$.fragment,e),g(io.$$.fragment,e),g(lo.$$.fragment,e),g(we.$$.fragment,e),g(co.$$.fragment,e),g(fo.$$.fragment,e),g(mo.$$.fragment,e),g($e.$$.fragment,e),g(Me.$$.fragment,e),Ft=!1},d(e){e&&(d(y),d(c),d(l),d(t),d(w),d(gt),d(_t),d(xt),d(U),d(bt),d(vt),d(W),d(yt),d(wt),d(R),d($t),d(Mt),d($),d(Lt),d(Tt),d(G),d(kt),d(Ct),d(X),d(Ut),d(It),d(O),d(Jt),d(ut)),d(r),_(v,e),_(K,e),_(ke,e),_(Ce),_(Ue),_(Ie),_(Je),_(Fe),_(Ne),_(Ze,e),_(De),_(We),_(ae),_(se),_(Se),_(je,e),_(Pe),_(Re),_(Ge,e),_(Ee),_(Ae),_(Ve),_(He),_(ce),_(ze),_(fe),_(Be),_(qe),_(Ye),_(Xe),_(Oe),_(he),_(Qe),_(Ke),_(eo),_(oo),_(be),_(to),_(ve),_(ro,e),_(no),_(ao),_(ye),_(so,e),_(io),_(lo),_(we),_(co,e),_(fo),_(mo),_($e),_(Me)}}}const ha='{"title":"Loaders","local":"loaders","sections":[{"title":"UNet2DConditionLoadersMixin","local":"diffusers.loaders.UNet2DConditionLoadersMixin","sections":[],"depth":2},{"title":"TextualInversionLoaderMixin","local":"diffusers.loaders.TextualInversionLoaderMixin","sections":[],"depth":2},{"title":"StableDiffusionXLLoraLoaderMixin","local":"diffusers.loaders.StableDiffusionXLLoraLoaderMixin","sections":[],"depth":2},{"title":"LoraLoaderMixin","local":"diffusers.loaders.LoraLoaderMixin","sections":[],"depth":2},{"title":"FromSingleFileMixin","local":"diffusers.loaders.FromSingleFileMixin","sections":[],"depth":2},{"title":"FromOriginalControlnetMixin","local":"diffusers.loaders.FromOriginalControlnetMixin","sections":[],"depth":2},{"title":"FromOriginalVAEMixin","local":"diffusers.loaders.FromOriginalVAEMixin","sections":[],"depth":2}],"depth":1}';function ga(C){return Qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends Kn{constructor(r){super(),ea(this,r,ga,ua,On,{})}}export{Ma as component};
