import{s as Ee,o as ze,n as Qe}from"../chunks/scheduler.182ea377.js";import{S as Fe,i as De,g as a,s,r as c,A as Le,h as o,f as l,c as i,j as Ne,u,x as m,k as D,y as He,a as n,v as f,d as h,t as g,w as b,m as qe,n as Pe}from"../chunks/index.abf12888.js";import{T as Ke}from"../chunks/Tip.230e2334.js";import{C as H}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ae}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as q}from"../chunks/Heading.16916d63.js";function Oe(P){let d,r,Z='Additionally, we also use <a href="../../optimization/memory#model-offloading">model cpu offloading</a> to reduce the memory usage.';return{c(){d=qe("Since generating videos is more memory intensive we can use the `decode_chunk_size` argument to control how many frames are decoded at once. This will reduce the memory usage. It's recommended to tweak this value based on your GPU memory.\nSetting `decode_chunk_size=1` will decode one frame at a time and will use the least amount of memory but the video might have some flickering.\n"),r=a("p"),r.innerHTML=Z},l(p){d=Pe(p,"Since generating videos is more memory intensive we can use the `decode_chunk_size` argument to control how many frames are decoded at once. This will reduce the memory usage. It's recommended to tweak this value based on your GPU memory.\nSetting `decode_chunk_size=1` will decode one frame at a time and will use the least amount of memory but the video might have some flickering.\n"),r=o(p,"P",{"data-svelte-h":!0}),m(r)!=="svelte-dumqni"&&(r.innerHTML=Z)},m(p,w){n(p,d,w),n(p,r,w)},p:Qe,d(p){p&&(l(d),l(r))}}}function et(P){let d,r,Z,p,w,K,J,A,T,_e='<a href="https://static1.squarespace.com/static/6213c340453c3f502425776e/t/655ce779b9d47d342a93c890/1700587395994/stable_video_diffusion.pdf" rel="nofollow">Stable Video Diffusion</a> is a powerful image-to-video generation model that can generate high resolution (576x1024) 2-4 second videos conditioned on the input image.',O,_,ke="This guide will show you how to use SVD to short generate videos from images.",ee,k,We="Before you begin, make sure you have the following libraries installed:",te,W,le,$,ne,U,$e=`The are two variants of SVD. <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a>
and <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a>. The svd checkpoint is trained to generate 14 frames and the svd-xt checkpoint is further
finetuned to generate 25 frames.`,se,j,Ue="We will use the <code>svd-xt</code> checkpoint for this guide.",ie,V,ae,v,je='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket_generated.mp4" type="video/mp4"/>',oe,y,me,G,de,X,Ve="You can achieve a 20-25% speed-up at the expense of slightly increased memory by compiling the UNet as follows:",re,x,pe,C,ce,I,Ge="Video generation is very memory intensive as we have to essentially generate <code>num_frames</code> all at once. The mechanism is very comparable to text-to-image generation with a high batch size. To reduce the memory requirement you have multiple options. The following options trade inference speed against lower memory requirement:",ue,Y,Xe="<li>enable model offloading: Each component of the pipeline is offloaded to CPU once it’s not needed anymore.</li> <li>enable feed-forward chunking: The feed-forward layer runs in a loop instead of running with a single huge feed-forward batch size</li> <li>reduce <code>decode_chunk_size</code>: This means that the VAE decodes frames in chunks instead of decoding them all together. <strong>Note</strong>: In addition to leading to a small slowdown, this method also slightly leads to video quality deterioration</li>",fe,B,xe="You can enable them as follows:",he,S,ge,R,Ce="Including all these tricks should lower the memory requirement to less than 8GB VRAM.",be,N,we,E,Ie=`Along with conditioning image Stable Diffusion Video also allows providing micro-conditioning that allows more control over the generated video.
It accepts the following arguments:`,ve,z,Ye="<li><code>fps</code>: The frames per second of the generated video.</li> <li><code>motion_bucket_id</code>: The motion bucket id to use for the generated video. This can be used to control the motion of the generated video. Increasing the motion bucket id will increase the motion of the generated video.</li> <li><code>noise_aug_strength</code>: The amount of noise added to the conditioning image. The higher the values the less the video will resemble the conditioning image. Increasing this value will also increase the motion of the generated video.</li>",Me,Q,Be="Here is an example of using micro-conditioning to generate a video with more motion.",Ze,F,ye,M,Se='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket_generated_motion.mp4" type="video/mp4"/>',Je,L,Te;return w=new q({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),J=new Ae({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"}]}}),W=new H({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMA==",highlighted:"!pip install -q -U diffusers transformers accelerate ",wrap:!1}}),$=new q({props:{title:"Image to Video Generation",local:"image-to-video-generation",headingTag:"h2"}}),V=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png?download=true&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),y=new Ke({props:{$$slots:{default:[Oe]},$$scope:{ctx:P}}}),G=new q({props:{title:"Torch.compile",local:"torchcompile",headingTag:"h3"}}),x=new H({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),C=new q({props:{title:"Low-memory",local:"low-memory",headingTag:"h3"}}),S=new H({props:{code:"LXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQnBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkJwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQmZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">-pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">-frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),N=new q({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h3"}}),F=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png?download=true&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),{c(){d=a("meta"),r=s(),Z=a("p"),p=s(),c(w.$$.fragment),K=s(),c(J.$$.fragment),A=s(),T=a("p"),T.innerHTML=_e,O=s(),_=a("p"),_.textContent=ke,ee=s(),k=a("p"),k.textContent=We,te=s(),c(W.$$.fragment),le=s(),c($.$$.fragment),ne=s(),U=a("p"),U.innerHTML=$e,se=s(),j=a("p"),j.innerHTML=Ue,ie=s(),c(V.$$.fragment),ae=s(),v=a("video"),v.innerHTML=je,oe=s(),c(y.$$.fragment),me=s(),c(G.$$.fragment),de=s(),X=a("p"),X.textContent=Ve,re=s(),c(x.$$.fragment),pe=s(),c(C.$$.fragment),ce=s(),I=a("p"),I.innerHTML=Ge,ue=s(),Y=a("ul"),Y.innerHTML=Xe,fe=s(),B=a("p"),B.textContent=xe,he=s(),c(S.$$.fragment),ge=s(),R=a("p"),R.textContent=Ce,be=s(),c(N.$$.fragment),we=s(),E=a("p"),E.textContent=Ie,ve=s(),z=a("ul"),z.innerHTML=Ye,Me=s(),Q=a("p"),Q.textContent=Be,Ze=s(),c(F.$$.fragment),ye=s(),M=a("video"),M.innerHTML=Se,Je=s(),L=a("p"),this.h()},l(e){const t=Le("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),r=i(e),Z=o(e,"P",{}),Ne(Z).forEach(l),p=i(e),u(w.$$.fragment,e),K=i(e),u(J.$$.fragment,e),A=i(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1vbef9r"&&(T.innerHTML=_e),O=i(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-xwqusf"&&(_.textContent=ke),ee=i(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-cwruts"&&(k.textContent=We),te=i(e),u(W.$$.fragment,e),le=i(e),u($.$$.fragment,e),ne=i(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-d5kpr9"&&(U.innerHTML=$e),se=i(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-ovrr6i"&&(j.innerHTML=Ue),ie=i(e),u(V.$$.fragment,e),ae=i(e),v=o(e,"VIDEO",{width:!0,height:!0,"data-svelte-h":!0}),m(v)!=="svelte-xmq04e"&&(v.innerHTML=je),oe=i(e),u(y.$$.fragment,e),me=i(e),u(G.$$.fragment,e),de=i(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1avdrs5"&&(X.textContent=Ve),re=i(e),u(x.$$.fragment,e),pe=i(e),u(C.$$.fragment,e),ce=i(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-19vtt0c"&&(I.innerHTML=Ge),ue=i(e),Y=o(e,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-71ertv"&&(Y.innerHTML=Xe),fe=i(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-xt0ph2"&&(B.textContent=xe),he=i(e),u(S.$$.fragment,e),ge=i(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-yldnwm"&&(R.textContent=Ce),be=i(e),u(N.$$.fragment,e),we=i(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-zhhgyp"&&(E.textContent=Ie),ve=i(e),z=o(e,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-1tco7lo"&&(z.innerHTML=Ye),Me=i(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1vov4p7"&&(Q.textContent=Be),Ze=i(e),u(F.$$.fragment,e),ye=i(e),M=o(e,"VIDEO",{width:!0,height:!0,"data-svelte-h":!0}),m(M)!=="svelte-yn9ivh"&&(M.innerHTML=Se),Je=i(e),L=o(e,"P",{}),Ne(L).forEach(l),this.h()},h(){D(d,"name","hf:doc:metadata"),D(d,"content",tt),D(v,"width","1024"),D(v,"height","576"),v.controls="",D(M,"width","1024"),D(M,"height","576"),M.controls=""},m(e,t){He(document.head,d),n(e,r,t),n(e,Z,t),n(e,p,t),f(w,e,t),n(e,K,t),f(J,e,t),n(e,A,t),n(e,T,t),n(e,O,t),n(e,_,t),n(e,ee,t),n(e,k,t),n(e,te,t),f(W,e,t),n(e,le,t),f($,e,t),n(e,ne,t),n(e,U,t),n(e,se,t),n(e,j,t),n(e,ie,t),f(V,e,t),n(e,ae,t),n(e,v,t),n(e,oe,t),f(y,e,t),n(e,me,t),f(G,e,t),n(e,de,t),n(e,X,t),n(e,re,t),f(x,e,t),n(e,pe,t),f(C,e,t),n(e,ce,t),n(e,I,t),n(e,ue,t),n(e,Y,t),n(e,fe,t),n(e,B,t),n(e,he,t),f(S,e,t),n(e,ge,t),n(e,R,t),n(e,be,t),f(N,e,t),n(e,we,t),n(e,E,t),n(e,ve,t),n(e,z,t),n(e,Me,t),n(e,Q,t),n(e,Ze,t),f(F,e,t),n(e,ye,t),n(e,M,t),n(e,Je,t),n(e,L,t),Te=!0},p(e,[t]){const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),y.$set(Re)},i(e){Te||(h(w.$$.fragment,e),h(J.$$.fragment,e),h(W.$$.fragment,e),h($.$$.fragment,e),h(V.$$.fragment,e),h(y.$$.fragment,e),h(G.$$.fragment,e),h(x.$$.fragment,e),h(C.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),Te=!0)},o(e){g(w.$$.fragment,e),g(J.$$.fragment,e),g(W.$$.fragment,e),g($.$$.fragment,e),g(V.$$.fragment,e),g(y.$$.fragment,e),g(G.$$.fragment,e),g(x.$$.fragment,e),g(C.$$.fragment,e),g(S.$$.fragment,e),g(N.$$.fragment,e),g(F.$$.fragment,e),Te=!1},d(e){e&&(l(r),l(Z),l(p),l(K),l(A),l(T),l(O),l(_),l(ee),l(k),l(te),l(le),l(ne),l(U),l(se),l(j),l(ie),l(ae),l(v),l(oe),l(me),l(de),l(X),l(re),l(pe),l(ce),l(I),l(ue),l(Y),l(fe),l(B),l(he),l(ge),l(R),l(be),l(we),l(E),l(ve),l(z),l(Me),l(Q),l(Ze),l(ye),l(M),l(Je),l(L)),l(d),b(w,e),b(J,e),b(W,e),b($,e),b(V,e),b(y,e),b(G,e),b(x,e),b(C,e),b(S,e),b(N,e),b(F,e)}}}const tt='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"Image to Video Generation","local":"image-to-video-generation","sections":[{"title":"Torch.compile","local":"torchcompile","sections":[],"depth":3},{"title":"Low-memory","local":"low-memory","sections":[],"depth":3},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":3}],"depth":2}],"depth":1}';function lt(P){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends Fe{constructor(d){super(),De(this,d,lt,et,Ee,{})}}export{dt as component};
