import{S as U_,i as V_,s as K_,e as s,k as p,w as x,t,M as Z_,c as a,d as o,m,a as r,x as k,h as n,b as _,G as e,g as v,y,q as j,o as w,B as L,v as J_,L as K}from"../../chunks/vendor-hf-doc-builder.js";import{T as tu}from"../../chunks/Tip-hf-doc-builder.js";import{D as P}from"../../chunks/Docstring-hf-doc-builder.js";import{C as Z}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as or}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as V}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function X_($){let d,f,u,c,h;return{c(){d=s("p"),f=t(`A generation configuration file can be loaded and saved to disk. Loading and using a generation configuration file
does `),u=s("strong"),c=t("not"),h=t(" change a model configuration or weights. It only affects the model\u2019s behavior at generation time.")},l(i){d=a(i,"P",{});var g=r(d);f=n(g,`A generation configuration file can be loaded and saved to disk. Loading and using a generation configuration file
does `),u=a(g,"STRONG",{});var D=r(u);c=n(D,"not"),D.forEach(o),h=n(g," change a model configuration or weights. It only affects the model\u2019s behavior at generation time."),g.forEach(o)},m(i,g){v(i,d,g),e(d,f),e(d,u),e(u,c),e(d,h)},d(i){i&&o(d)}}}function Y_($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import GenerationConfig

# Download configuration from huggingface.co and cache.
generation_config = GenerationConfig.from_pretrained("gpt2")

# E.g. config was saved using *save_pretrained('./test/saved_model/')*
generation_config.save_pretrained("./test/saved_model/")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/")

# You can also specify configuration names to your generation configuration file
generation_config.save_pretrained("./test/saved_model/", config_file_name="my_configuration.json")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/", "my_configuration.json")

# If you'd like to try a minor variation to an existing configuration, you can also pass generation
# arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored
generation_config, unused_kwargs = GenerationConfig.from_pretrained(
    "gpt2", top_k=1, foo=False, return_unused_kwargs=True
)
generation_config.top_k

unused_kwargs`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function Q_($){let d,f,u,c,h,i,g,D,S,J,A;return{c(){d=s("p"),f=t("Apart from "),u=s("code"),c=t("inputs"),h=t(`, all the arguments below will default to the value of the attribute of the same name as
defined in the model\u2019s config (`),i=s("code"),g=t("config.json"),D=t(`) which in turn defaults to the
`),S=s("a"),J=t("PretrainedConfig"),A=t(" of the model."),this.h()},l(N){d=a(N,"P",{});var T=r(d);f=n(T,"Apart from "),u=a(T,"CODE",{});var We=r(u);c=n(We,"inputs"),We.forEach(o),h=n(T,`, all the arguments below will default to the value of the attribute of the same name as
defined in the model\u2019s config (`),i=a(T,"CODE",{});var Be=r(i);g=n(Be,"config.json"),Be.forEach(o),D=n(T,`) which in turn defaults to the
`),S=a(T,"A",{href:!0});var Ee=r(S);J=n(Ee,"PretrainedConfig"),Ee.forEach(o),A=n(T," of the model."),T.forEach(o),this.h()},h(){_(S,"href","/docs/transformers/v4.25.1/en/main_classes/configuration#transformers.PretrainedConfig")},m(N,T){v(N,d,T),e(d,f),e(d,u),e(u,c),e(d,h),e(d,i),e(i,g),e(d,D),e(d,S),e(S,J),e(d,A)},d(N){N&&o(d)}}}function ef($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

prompt = "Today I believe we can finally"
input_ids = tokenizer(prompt, return_tensors="pt").input_ids

# generate up to 30 tokens
outputs = model.generate(input_ids, do_sample=False, max_length=30)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today I believe we can finally&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate up to 30 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today I believe we can finally get to the point where we can make a difference in the lives of the people of the United States of America.\\n&#x27;</span>]`}}),{c(){d=s("p"),f=t("Greedy Decoding:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Greedy Decoding:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function tf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import AutoTokenizer, AutoModelForCausalLM
import torch

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

prompt = "Today I believe we can finally"
input_ids = tokenizer(prompt, return_tensors="pt").input_ids

# sample up to 30 tokens
torch.manual_seed(0)
outputs = model.generate(input_ids, do_sample=True, max_length=30)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today I believe we can finally&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample up to 30 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids, do_sample=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today I believe we can finally get rid of discrimination,&quot; said Rep. Mark Pocan (D-Wis.).\\n\\n&quot;Just look at the&#x27;</span>]`}}),{c(){d=s("p"),f=t("Multinomial Sampling:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Multinomial Sampling:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function nf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import AutoTokenizer, AutoModelForSeq2SeqLM

tokenizer = AutoTokenizer.from_pretrained("Helsinki-NLP/opus-mt-en-de")
model = AutoModelForSeq2SeqLM.from_pretrained("Helsinki-NLP/opus-mt-en-de")

sentence = "Paris is one of the densest populated areas in Europe."
input_ids = tokenizer(sentence, return_tensors="pt").input_ids

outputs = model.generate(input_ids, num_beams=5)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sentence = <span class="hljs-string">&quot;Paris is one of the densest populated areas in Europe.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(sentence, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids, num_beams=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Paris ist eines der dichtesten besiedelten Gebiete Europas.&#x27;</span>]`}}),{c(){d=s("p"),f=t("Beam-search decoding:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Beam-search decoding:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function of($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a PAD token
model.config.pad_token_id = model.config.eos_token_id

input_prompt = "It might be possible to"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(10, eos_token_id=model.config.eos_token_id),
    ]
)
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

outputs = model.greedy_search(
    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;It might be possible to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">10</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.greedy_search(
<span class="hljs-meta">... </span>    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;It might be possible to get a better understanding of the nature of the problem, but it&#x27;s not&quot;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function sf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    StoppingCriteriaList,
    MaxLengthCriteria,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a EOS token
model.config.pad_token_id = model.config.eos_token_id

input_prompt = "Today is a beautiful day, and"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(15, eos_token_id=model.config.eos_token_id),
    ]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

torch.manual_seed(0)
outputs = model.sample(
    input_ids,
    logits_processor=logits_processor,
    logits_warper=logits_warper,
    stopping_criteria=stopping_criteria,
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;Today is a beautiful day, and&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">15</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.sample(
<span class="hljs-meta">... </span>    input_ids,
<span class="hljs-meta">... </span>    logits_processor=logits_processor,
<span class="hljs-meta">... </span>    logits_warper=logits_warper,
<span class="hljs-meta">... </span>    stopping_criteria=stopping_criteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today is a beautiful day, and a wonderful day.\\n\\nI was lucky enough to meet the&#x27;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function af($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function rf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids

# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id)]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

outputs = model.beam_sample(
    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_sample(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function lf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("facebook/opt-125m")
model = AutoModelForCausalLM.from_pretrained("facebook/opt-125m")
# set pad_token_id to eos_token_id because OPT does not have a PAD token
model.config.pad_token_id = model.config.eos_token_id
input_prompt = "DeepMind Company is"
input_ids = tokenizer(input_prompt, return_tensors="pt")
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=64)])
outputs = model.contrastive_search(
    **input_ids, penalty_alpha=0.6, top_k=4, stopping_criteria=stopping_criteria
)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because OPT does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;DeepMind Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">64</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.contrastive_search(
<span class="hljs-meta">... </span>    **input_ids, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;DeepMind Company is a company that focuses on the development and commercialization of artificial intelligence (AI). DeepMind\u2019s mission is to help people understand and solve problems that are difficult to solve in the world today.\\n\\nIn this post, we talk about the benefits of deep learning in business and how it&#x27;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function df($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    HammingDiversityLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run diverse beam search using 6 beams
num_beams = 6
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
    num_beam_groups=3,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        HammingDiversityLogitsProcessor(5.5, num_beams=6, num_beam_groups=3),
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.group_beam_search(
    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    HammingDiversityLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run diverse beam search using 6 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        HammingDiversityLogitsProcessor(<span class="hljs-number">5.5</span>, num_beams=<span class="hljs-number">6</span>, num_beam_groups=<span class="hljs-number">3</span>),
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.group_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function cf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    ConstrainedBeamSearchScorer,
    PhrasalConstraint,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

constraint_str = "Sie"
constraint_token_ids = tokenizer.encode(constraint_str)[:-1]  # slice to remove eos token
constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


# instantiate beam scorer
beam_scorer = ConstrainedBeamSearchScorer(
    batch_size=1, num_beams=num_beams, device=model.device, constraints=constraints
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.constrained_beam_search(
    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    ConstrainedBeamSearchScorer,
<span class="hljs-meta">... </span>    PhrasalConstraint,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_str = <span class="hljs-string">&quot;Sie&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_token_ids = tokenizer.encode(constraint_str)[:-<span class="hljs-number">1</span>]  <span class="hljs-comment"># slice to remove eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = ConstrainedBeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>, num_beams=num_beams, device=model.device, constraints=constraints
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.constrained_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt sind Sie?&#x27;</span>]`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function pf($){let d,f,u,c,h;return c=new Z({props:{code:`tokenizer = AutoTokenizer.from_pretrained("distilgpt2")  # Initialize tokenizer
model = TFAutoModelWithLMHead.from_pretrained(
    "distilgpt2"
)  # Download model and configuration from huggingface.co and cache.
outputs = model.generate(max_length=40)  # do greedy decoding
print(f"Generated: {tokenizer.decode(outputs[0], skip_special_tokens=True)}")

tokenizer = AutoTokenizer.from_pretrained("openai-gpt")  # Initialize tokenizer
model = TFAutoModelWithLMHead.from_pretrained(
    "openai-gpt"
)  # Download model and configuration from huggingface.co and cache.
input_context = "The dog"
input_ids = tokenizer.encode(input_context, return_tensors="tf")  # encode input context
outputs = model.generate(
    input_ids=input_ids, num_beams=5, num_return_sequences=3, temperature=1.5
)  # generate 3 independent sequences using beam search decoding (5 beams) with sampling from initial context 'The dog'
for i in range(3):  #  3 output sequences were generated
    print(f"Generated {i}: {tokenizer.decode(outputs[i], skip_special_tokens=True)}")

tokenizer = AutoTokenizer.from_pretrained("distilgpt2")  # Initialize tokenizer
model = TFAutoModelWithLMHead.from_pretrained(
    "distilgpt2"
)  # Download model and configuration from huggingface.co and cache.
input_context = "The dog"
input_ids = tokenizer.encode(input_context, return_tensors="tf")  # encode input context
outputs = model.generate(
    input_ids=input_ids, max_length=40, temperature=0.7, num_return_sequences=3, do_sample=True
)  # generate 3 candidates using sampling
for i in range(3):  #  3 output sequences were generated
    print(f"Generated {i}: {tokenizer.decode(outputs[i], skip_special_tokens=True)}")

tokenizer = AutoTokenizer.from_pretrained("ctrl")  # Initialize tokenizer
model = TFAutoModelWithLMHead.from_pretrained(
    "ctrl"
)  # Download model and configuration from huggingface.co and cache.
input_context = "Legal My neighbor is"  # "Legal" is one of the control codes for ctrl
input_ids = tokenizer.encode(input_context, return_tensors="tf")  # encode input context
outputs = model.generate(
    input_ids=input_ids, max_length=50, temperature=0.7, repetition_penalty=1.2
)  # generate sequences
print(f"Generated: {tokenizer.decode(outputs[0], skip_special_tokens=True)}")

tokenizer = AutoTokenizer.from_pretrained("gpt2")  # Initialize tokenizer
model = TFAutoModelWithLMHead.from_pretrained(
    "gpt2"
)  # Download model and configuration from huggingface.co and cache.
input_context = "My cute dog"
bad_words_ids = [
    tokenizer.encode(bad_word, add_prefix_space=True) for bad_word in ["idiot", "stupid", "shut up"]
]
input_ids = tokenizer.encode(input_context, return_tensors="tf")  # encode input context
outputs = model.generate(
    input_ids=input_ids, max_length=100, do_sample=True, bad_words_ids=bad_words_ids
)  # generate sequences without allowing bad_words to be generated`,highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)  <span class="hljs-comment"># Initialize tokenizer</span>
model = TFAutoModelWithLMHead.from_pretrained(
    <span class="hljs-string">&quot;distilgpt2&quot;</span>
)  <span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
outputs = model.generate(max_length=<span class="hljs-number">40</span>)  <span class="hljs-comment"># do greedy decoding</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated: <span class="hljs-subst">{tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)}</span>&quot;</span>)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)  <span class="hljs-comment"># Initialize tokenizer</span>
model = TFAutoModelWithLMHead.from_pretrained(
    <span class="hljs-string">&quot;openai-gpt&quot;</span>
)  <span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
input_context = <span class="hljs-string">&quot;The dog&quot;</span>
input_ids = tokenizer.encode(input_context, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)  <span class="hljs-comment"># encode input context</span>
outputs = model.generate(
    input_ids=input_ids, num_beams=<span class="hljs-number">5</span>, num_return_sequences=<span class="hljs-number">3</span>, temperature=<span class="hljs-number">1.5</span>
)  <span class="hljs-comment"># generate 3 independent sequences using beam search decoding (5 beams) with sampling from initial context &#x27;The dog&#x27;</span>
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):  <span class="hljs-comment">#  3 output sequences were generated</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{tokenizer.decode(outputs[i], skip_special_tokens=<span class="hljs-literal">True</span>)}</span>&quot;</span>)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)  <span class="hljs-comment"># Initialize tokenizer</span>
model = TFAutoModelWithLMHead.from_pretrained(
    <span class="hljs-string">&quot;distilgpt2&quot;</span>
)  <span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
input_context = <span class="hljs-string">&quot;The dog&quot;</span>
input_ids = tokenizer.encode(input_context, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)  <span class="hljs-comment"># encode input context</span>
outputs = model.generate(
    input_ids=input_ids, max_length=<span class="hljs-number">40</span>, temperature=<span class="hljs-number">0.7</span>, num_return_sequences=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>
)  <span class="hljs-comment"># generate 3 candidates using sampling</span>
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):  <span class="hljs-comment">#  3 output sequences were generated</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{tokenizer.decode(outputs[i], skip_special_tokens=<span class="hljs-literal">True</span>)}</span>&quot;</span>)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ctrl&quot;</span>)  <span class="hljs-comment"># Initialize tokenizer</span>
model = TFAutoModelWithLMHead.from_pretrained(
    <span class="hljs-string">&quot;ctrl&quot;</span>
)  <span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
input_context = <span class="hljs-string">&quot;Legal My neighbor is&quot;</span>  <span class="hljs-comment"># &quot;Legal&quot; is one of the control codes for ctrl</span>
input_ids = tokenizer.encode(input_context, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)  <span class="hljs-comment"># encode input context</span>
outputs = model.generate(
    input_ids=input_ids, max_length=<span class="hljs-number">50</span>, temperature=<span class="hljs-number">0.7</span>, repetition_penalty=<span class="hljs-number">1.2</span>
)  <span class="hljs-comment"># generate sequences</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated: <span class="hljs-subst">{tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)}</span>&quot;</span>)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)  <span class="hljs-comment"># Initialize tokenizer</span>
model = TFAutoModelWithLMHead.from_pretrained(
    <span class="hljs-string">&quot;gpt2&quot;</span>
)  <span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
input_context = <span class="hljs-string">&quot;My cute dog&quot;</span>
bad_words_ids = [
    tokenizer.encode(bad_word, add_prefix_space=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> bad_word <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;idiot&quot;</span>, <span class="hljs-string">&quot;stupid&quot;</span>, <span class="hljs-string">&quot;shut up&quot;</span>]
]
input_ids = tokenizer.encode(input_context, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)  <span class="hljs-comment"># encode input context</span>
outputs = model.generate(
    input_ids=input_ids, max_length=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">True</span>, bad_words_ids=bad_words_ids
)  <span class="hljs-comment"># generate sequences without allowing bad_words to be generated</span>`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function mf($){let d,f,u,c,h,i,g,D,S,J,A;return{c(){d=s("p"),f=t("Apart from "),u=s("code"),c=t("inputs"),h=t(`, all the arguments below will default to the value of the attribute of the same name as
defined in the model\u2019s config (`),i=s("code"),g=t("config.json"),D=t(`) which in turn defaults to the
`),S=s("a"),J=t("PretrainedConfig"),A=t(" of the model."),this.h()},l(N){d=a(N,"P",{});var T=r(d);f=n(T,"Apart from "),u=a(T,"CODE",{});var We=r(u);c=n(We,"inputs"),We.forEach(o),h=n(T,`, all the arguments below will default to the value of the attribute of the same name as
defined in the model\u2019s config (`),i=a(T,"CODE",{});var Be=r(i);g=n(Be,"config.json"),Be.forEach(o),D=n(T,`) which in turn defaults to the
`),S=a(T,"A",{href:!0});var Ee=r(S);J=n(Ee,"PretrainedConfig"),Ee.forEach(o),A=n(T," of the model."),T.forEach(o),this.h()},h(){_(S,"href","/docs/transformers/v4.25.1/en/main_classes/configuration#transformers.PretrainedConfig")},m(N,T){v(N,d,T),e(d,f),e(d,u),e(u,c),e(d,h),e(d,i),e(i,g),e(d,D),e(d,S),e(S,J),e(d,A)},d(N){N&&o(d)}}}function gf($){let d,f,u,c,h;return c=new Z({props:{code:`from transformers import AutoTokenizer, FlaxAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained("distilgpt2")
model = FlaxAutoModelForCausalLM.from_pretrained("distilgpt2")
input_context = "The dog"
# encode input context
input_ids = tokenizer(input_context, return_tensors="np").input_ids
# generate candidates using sampling
outputs = model.generate(input_ids=input_ids, max_length=20, top_k=30, do_sample=True)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_context = <span class="hljs-string">&quot;The dog&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encode input context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_context, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate candidates using sampling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, max_length=<span class="hljs-number">20</span>, top_k=<span class="hljs-number">30</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)`}}),{c(){d=s("p"),f=t("Examples:"),u=p(),x(c.$$.fragment)},l(i){d=a(i,"P",{});var g=r(d);f=n(g,"Examples:"),g.forEach(o),u=m(i),k(c.$$.fragment,i)},m(i,g){v(i,d,g),e(d,f),v(i,u,g),y(c,i,g),h=!0},p:K,i(i){h||(j(c.$$.fragment,i),h=!0)},o(i){w(c.$$.fragment,i),h=!1},d(i){i&&o(d),i&&o(u),L(c,i)}}}function uf($){let d,f,u,c,h,i,g,D,S,J,A,N,T,We,Be,Ee,Ge,He,Dr,Vn,Ar,zr,Kn,Pr,Nr,Ir,Re,Wr,Zn,Br,Hr,Jn,Rr,Ur,Vr,Ue,Kr,Xn,Zr,Jr,Yn,Xr,Yr,sr,Ve,Tt,Co,nn,Qr,Fo,ei,ar,I,on,ti,Do,ni,oi,Et,si,Oe,sn,ai,an,ri,Qn,ii,li,di,Gt,ci,Ot,rn,pi,Ke,mi,Ao,gi,ui,eo,hi,_i,rr,Ze,qt,zo,ln,fi,Po,bi,ir,M,dn,vi,cn,xi,to,ki,yi,ji,pn,wi,no,Li,$i,Mi,C,X,No,Ti,Ei,oo,Gi,Oi,Io,qi,Si,Wo,Ci,Fi,Di,ye,Bo,Ai,zi,so,Pi,Ni,Ho,Ii,Wi,Ro,Bi,Hi,Y,Uo,Ri,Ui,ao,Vi,Ki,Vo,Zi,Ji,Ko,Xi,Yi,Qi,Q,Zo,el,tl,ro,nl,ol,Jo,sl,al,Xo,rl,il,ll,ee,Yo,dl,cl,io,pl,ml,Qo,gl,ul,es,hl,_l,fl,te,ts,bl,vl,lo,xl,kl,ns,yl,jl,os,wl,Ll,$l,ne,ss,Ml,Tl,co,El,Gl,as,Ol,ql,rs,Sl,Cl,Fl,G,mn,Dl,is,Al,zl,F,oe,ls,Pl,Nl,po,Il,Wl,ds,Bl,Hl,cs,Rl,Ul,Vl,je,ps,Kl,Zl,mo,Jl,Xl,ms,Yl,Ql,gs,ed,td,se,us,nd,od,go,sd,ad,hs,rd,id,_s,ld,dd,cd,ae,fs,pd,md,uo,gd,ud,bs,hd,_d,vs,fd,bd,vd,re,xs,xd,kd,ho,yd,jd,ks,wd,Ld,ys,$d,Md,Td,ie,js,Ed,Gd,_o,Od,qd,ws,Sd,Cd,Ls,Fd,Dd,Ad,le,$s,zd,Pd,fo,Nd,Id,Ms,Wd,Bd,Ts,Hd,Rd,Ud,St,Vd,gn,Kd,un,Zd,Jd,Xd,Es,Yd,Qd,Ct,ec,Ft,tc,Dt,nc,qe,hn,oc,_n,sc,Gs,ac,rc,ic,At,lc,Se,fn,dc,bn,cc,Os,pc,mc,gc,zt,uc,Ce,vn,hc,xn,_c,qs,fc,bc,vc,Pt,xc,Fe,kn,kc,yn,yc,Ss,jc,wc,Lc,Nt,$c,De,jn,Mc,wn,Tc,Cs,Ec,Gc,Oc,It,qc,Ae,Ln,Sc,$n,Cc,Fs,Fc,Dc,Ac,Wt,zc,ze,Mn,Pc,Tn,Nc,Ds,Ic,Wc,Bc,Bt,lr,Je,Ht,As,En,Hc,zs,Rc,dr,W,Gn,Uc,On,Vc,bo,Kc,Zc,Jc,qn,Xc,vo,Yc,Qc,ep,we,de,Ps,tp,np,Ns,op,sp,Is,ap,rp,Ws,ip,lp,dp,Le,Bs,cp,pp,Hs,mp,gp,Rs,up,hp,Us,_p,fp,ce,Vs,bp,vp,Ks,xp,kp,Zs,yp,jp,Js,wp,Lp,$p,pe,Xs,Mp,Tp,Ys,Ep,Gp,Qs,Op,qp,ea,Sp,Cp,Fp,O,Sn,Dp,ta,Ap,zp,$e,me,na,Pp,Np,oa,Ip,Wp,sa,Bp,Hp,aa,Rp,Up,Vp,Me,ra,Kp,Zp,ia,Jp,Xp,la,Yp,Qp,da,em,tm,ge,ca,nm,om,pa,sm,am,ma,rm,im,ga,lm,dm,cm,ue,ua,pm,mm,ha,gm,um,_a,hm,_m,fa,fm,bm,vm,Cn,xm,Fn,km,ym,jm,Te,wm,ba,Lm,$m,va,Mm,Tm,xo,Em,Gm,Om,Dn,qm,An,Sm,Cm,Fm,Rt,cr,Xe,Ut,xa,zn,Dm,ka,Am,pr,B,Pn,zm,Nn,Pm,ko,Nm,Im,Wm,In,Bm,yo,Hm,Rm,Um,Ye,he,ya,Vm,Km,ja,Zm,Jm,wa,Xm,Ym,La,Qm,eg,tg,_e,$a,ng,og,Ma,sg,ag,Ta,rg,ig,Ea,lg,dg,cg,fe,Ga,pg,mg,Oa,gg,ug,qa,hg,_g,Sa,fg,bg,vg,z,Wn,xg,Ca,kg,yg,Qe,be,Fa,jg,wg,Da,Lg,$g,Aa,Mg,Tg,za,Eg,Gg,Og,ve,Pa,qg,Sg,Na,Cg,Fg,Ia,Dg,Ag,Wa,zg,Pg,Ng,xe,Ba,Ig,Wg,Ha,Bg,Hg,Ra,Rg,Ug,Ua,Vg,Kg,Zg,Vt,Jg,Bn,Xg,Hn,Yg,Qg,eu,Kt,mr;return i=new or({}),nn=new or({}),on=new P({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/configuration_utils.py#L37",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. In general, prefer the use of <code>max_new_tokens</code>, which ignores the number of tokens in the
prompt.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated.`,name:"min_length"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to stop the beam search when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The amount of probability mass from the original distribution to be considered in typical decoding. If set
to 1.0 it takes no effect. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated. In order to get the token ids of the words that
should not appear in the generated text, use <code>tokenizer(bad_words, add_prefix_space=True, add_special_tokens=False).input_ids</code>.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be supressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be supressed at the begining of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"}]},{title:"Parameters that define the output variables of `generate`",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"}]},{title:"Wild card",parametersDescription:[]}]}}),Et=new tu({props:{$$slots:{default:[X_]},$$scope:{ctx:$}}}),sn=new P({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/configuration_utils.py#L289",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),Gt=new V({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[Y_]},$$scope:{ctx:$}}}),rn=new P({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.25.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"push_to_hub"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/configuration_utils.py#L243"}}),ln=new or({}),dn=new P({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L460"}}),mn=new P({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Optional[bool] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"bad_words_ids",val:": typing.Optional[typing.Iterable[int]] = None"},{name:"force_words_ids",val:": typing.Union[typing.Iterable[int], typing.Iterable[typing.Iterable[int]], NoneType] = None"},{name:"bos_token_id",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"length_penalty",val:": typing.Optional[float] = None"},{name:"no_repeat_ngram_size",val:": typing.Optional[int] = None"},{name:"encoder_no_repeat_ngram_size",val:": typing.Optional[int] = None"},{name:"num_return_sequences",val:": typing.Optional[int] = None"},{name:"max_time",val:": typing.Optional[float] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"decoder_start_token_id",val:": typing.Optional[int] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"diversity_penalty",val:": typing.Optional[float] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"renormalize_logits",val:": typing.Optional[bool] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"constraints",val:": typing.Optional[typing.List[transformers.generation.beam_constraints.Constraint]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"forced_bos_token_id",val:": typing.Optional[int] = None"},{name:"forced_eos_token_id",val:": typing.Optional[int] = None"},{name:"remove_invalid_values",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"exponential_decay_length_penalty",val:": typing.Union[typing.Tuple[int, float], NoneType] = None"},{name:"suppress_tokens",val:": typing.Optional[typing.List[int]] = None"},{name:"begin_suppress_tokens",val:": typing.Optional[typing.List[int]] = None"},{name:"forced_decoder_ids",val:": typing.Optional[typing.List[typing.List[int]]] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.max_length</code>) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. In general, prefer the use of <code>max_new_tokens</code>, which ignores the number of tokens in
the prompt.`,name:"max_length"},{anchor:"transformers.GenerationMixin.generate.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationMixin.generate.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.min_length</code> or 10 if the config does not set any value) &#x2014;
The minimum length of the sequence to be generated.`,name:"min_length"},{anchor:"transformers.GenerationMixin.generate.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.do_sample</code> or <code>False</code> if the config does not set any value) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationMixin.generate.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to stop the beam search when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.GenerationMixin.generate.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.num_beams</code> or 1 if the config does not set any value) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationMixin.generate.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.temperature</code> or 1.0 if the config does not set any value) &#x2014;
The value used to module the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationMixin.generate.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.penalty_alpha</code> or None if the config does not set any value) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.generate.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.top_k</code> or 50 if the config does not set any value) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationMixin.generate.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.top_p</code> or 1.0 if the config does not set any value) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationMixin.generate.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.typical_p</code> or 1.0 if the config does not set any value) &#x2014;
The amount of probability mass from the original distribution to be considered in typical decoding. If
set to 1.0 it takes no effect. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationMixin.generate.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.repetition_penalty</code> or 1.0 if the config does not set any value) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationMixin.generate.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.pad_token_id</code>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.generate.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.bos_token_id</code>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationMixin.generate.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.eos_token_id</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.generate.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.length_penalty</code> or 1.0 if the config does not set any value) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent
to the sequence length, which in turn is used to divide the score of the sequence. Since the score is
the log likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences,
while <code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationMixin.generate.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.no_repeat_ngram_size</code> or 0 if the config does not set any value) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationMixin.generate.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.encoder_no_repeat_ngram_size</code> or 0 if the config does not set any value) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationMixin.generate.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>, defaults to <code>model.config.bad_words_ids</code>) &#x2014;
List of token ids that are not allowed to be generated. In order to get the token ids of the words that
should not appear in the generated text, use <code>tokenizer(bad_words, add_prefix_space=True, add_special_tokens=False).input_ids</code>.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationMixin.generate.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple
list of words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>,
this triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>,
where one can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationMixin.generate.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to <code>model.config.num_return_sequences</code> or 1 if the config does not set any value) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationMixin.generate.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still
finish the current pass after allocated time has been passed.`,name:"max_time(float,"},{anchor:"transformers.GenerationMixin.generate.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values are in <code>[0, 1]</code>, 1 for tokens
that are not masked, and 0 for masked tokens. If not provided, will default to a tensor the same shape
as <code>input_ids</code> that masks the pad token. <a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GenerationMixin.generate.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"},{anchor:"transformers.GenerationMixin.generate.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"},{anchor:"transformers.GenerationMixin.generate.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.num_beam_groups</code> or 1 if the config does not set any value) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of
beams. <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationMixin.generate.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to <code>model.config.diversity_penalty</code> or 0.0 if the config does not set any value) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group
at a particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is
enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and a
model&#x2019;s config. If a logit processor is passed that is already created with the arguments or a model&#x2019;s
config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the
custom ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the
score logits are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
model&#x2019;s config. If a stopping criteria is passed that is already created with the arguments or a
model&#x2019;s config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use
of certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationMixin.generate.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.output_attentions</code> or <code>False</code> if the config does not set any value) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.generate.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.output_hidden_states</code> or <code>False</code> if the config does not set any value) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.generate.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.output_scores</code> or <code>False</code> if the config does not set any value) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.generate.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.return_dict_in_generate</code> or <code>False</code> if the config does not set any value) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.generate.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful
for multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be
the target language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationMixin.generate.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationMixin.generate.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to
crash. Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>, defaults to <code>model.config.exponential_decay_length_penalty</code>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates
where penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationMixin.generate.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>, defaults to <code>model.config.suppress_tokens</code>) &#x2014;
A list of tokens that will be supressed at generation. The <code>SupressTokens</code> logit processor will set
their log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationMixin.generate.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>, defaults to <code>model.config.begin_suppress_tokens</code>) &#x2014;
A list of tokens that will be supressed at the begining of the generation. The <code>SupressBeginTokens</code>
logit processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationMixin.generate.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_decoder_ids</code>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that
will be forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always
be a token of index 123.
model<em>kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If the model
is an encoder-decoder model, encoder specific kwargs should not be prefixed and decoder specific kwargs
should be prefixed with *decoder</em>*.`,name:"forced_decoder_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L998",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),St=new tu({props:{warning:!0,$$slots:{default:[Q_]},$$scope:{ctx:$}}}),Ct=new V({props:{anchor:"transformers.GenerationMixin.generate.example",$$slots:{default:[ef]},$$scope:{ctx:$}}}),Ft=new V({props:{anchor:"transformers.GenerationMixin.generate.example-2",$$slots:{default:[tf]},$$scope:{ctx:$}}}),Dt=new V({props:{anchor:"transformers.GenerationMixin.generate.example-3",$$slots:{default:[nf]},$$scope:{ctx:$}}}),hn=new P({props:{name:"greedy_search",anchor:"transformers.GenerationMixin.greedy_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.greedy_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.greedy_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.greedy_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.greedy_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.greedy_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.greedy_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.greedy_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.greedy_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.greedy_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L2137",returnDescription:`
<p><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),At=new V({props:{anchor:"transformers.GenerationMixin.greedy_search.example",$$slots:{default:[of]},$$scope:{ctx:$}}}),fn=new P({props:{name:"sample",anchor:"transformers.GenerationMixin.sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L2365",returnDescription:`
<p>A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> or <code>torch.LongTensor</code></p>
`}}),zt=new V({props:{anchor:"transformers.GenerationMixin.sample.example",$$slots:{default:[sf]},$$scope:{ctx:$}}}),vn=new P({props:{name:"beam_search",anchor:"transformers.GenerationMixin.beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L2616",returnDescription:`
<p><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Pt=new V({props:{anchor:"transformers.GenerationMixin.beam_search.example",$$slots:{default:[af]},$$scope:{ctx:$}}}),kn=new P({props:{name:"beam_sample",anchor:"transformers.GenerationMixin.beam_sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_sample.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.beam_sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L2925",returnDescription:`
<p><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Nt=new V({props:{anchor:"transformers.GenerationMixin.beam_sample.example",$$slots:{default:[rf]},$$scope:{ctx:$}}}),jn=new P({props:{name:"contrastive_search",anchor:"transformers.GenerationMixin.contrastive_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"top_k",val:": typing.Optional[int] = 1"},{name:"penalty_alpha",val:": typing.Optional[float] = 0"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.contrastive_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.contrastive_search.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the candidate set that is used to re-rank for contrastive search`,name:"top_k"},{anchor:"transformers.GenerationMixin.contrastive_search.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The degeneration penalty for contrastive search; activate when it is larger than 0`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.contrastive_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.contrastive_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.contrastive_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.contrastive_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.contrastive_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.contrastive_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L1795",returnDescription:`
<p><code>ContrastiveSearchDecoderOnlyOutput</code>, <code>ContrastiveSearchEncoderDecoderOutput</code>
or <code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<code>ContrastiveSearchDecoderOnlyOutput</code> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <code>ContrastiveSearchEncoderDecoderOutput</code> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),It=new V({props:{anchor:"transformers.GenerationMixin.contrastive_search.example",$$slots:{default:[lf]},$$scope:{ctx:$}}}),Ln=new P({props:{name:"group_beam_search",anchor:"transformers.GenerationMixin.group_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.group_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.group_beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.group_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.group_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.group_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.group_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.group_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.group_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.group_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.group_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)</p>
<p>model_kwargs &#x2014;
Additional model specific kwargs that will be forwarded to the <code>forward</code> function of the model. If
model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L3241",returnDescription:`
<p><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if
<code>model.config.is_encoder_decoder=False</code> and <code>return_dict_in_generate=True</code> or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if <code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Wt=new V({props:{anchor:"transformers.GenerationMixin.group_beam_search.example",$$slots:{default:[df]},$$scope:{ctx:$}}}),Mn=new P({props:{name:"constrained_beam_search",anchor:"transformers.GenerationMixin.constrained_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"constrained_beam_scorer",val:": ConstrainedBeamSearchScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.constrained_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.constrained_beam_search.constrained_beam_scorer",description:`<strong>constrained_beam_scorer</strong> (<code>ConstrainedBeamSearchScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation, while satisfying a list of positive constraints. For more information, the
documentation of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.ConstrainedBeamSearchScorer">ConstrainedBeamSearchScorer</a> should be read.`,name:"constrained_beam_scorer"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.constrained_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.constrained_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.constrained_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.constrained_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.constrained_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/utils.py#L3603",returnDescription:`
<p><a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.25.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Bt=new V({props:{anchor:"transformers.GenerationMixin.constrained_beam_search.example",$$slots:{default:[cf]},$$scope:{ctx:$}}}),En=new or({}),Gn=new P({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/tf_utils.py#L427"}}),Sn=new P({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"input_ids",val:" = None"},{name:"max_length",val:" = None"},{name:"max_new_tokens",val:" = None"},{name:"min_length",val:" = None"},{name:"do_sample",val:" = None"},{name:"early_stopping",val:" = None"},{name:"num_beams",val:" = None"},{name:"temperature",val:" = None"},{name:"penalty_alpha",val:" = None"},{name:"top_k",val:" = None"},{name:"top_p",val:" = None"},{name:"repetition_penalty",val:" = None"},{name:"bad_words_ids",val:" = None"},{name:"bos_token_id",val:" = None"},{name:"pad_token_id",val:" = None"},{name:"eos_token_id",val:" = None"},{name:"length_penalty",val:" = None"},{name:"no_repeat_ngram_size",val:" = None"},{name:"num_return_sequences",val:" = None"},{name:"attention_mask",val:" = None"},{name:"decoder_start_token_id",val:" = None"},{name:"use_cache",val:" = None"},{name:"output_scores",val:" = None"},{name:"output_attentions",val:" = None"},{name:"output_hidden_states",val:" = None"},{name:"return_dict_in_generate",val:" = None"},{name:"forced_bos_token_id",val:" = None"},{name:"forced_eos_token_id",val:" = None"},{name:"suppress_tokens",val:": typing.Optional[typing.List[int]] = None"},{name:"begin_suppress_tokens",val:": typing.Optional[typing.List[int]] = None"},{name:"forced_decoder_ids",val:": typing.Optional[typing.List[typing.List[int]]] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.input_ids",description:"<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, `(batch_size, sequence_length, &#x2014;",name:"input_ids"},{anchor:"transformers.TFGenerationMixin.generate.feature_dim)`",description:`<strong>feature_dim)\`</strong> or <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"feature_dim)`"},{anchor:"transformers.TFGenerationMixin.generate.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.max_length</code>) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. In general, prefer the use of <code>max_new_tokens</code>, which ignores the number of tokens in
the prompt.`,name:"max_length"},{anchor:"transformers.TFGenerationMixin.generate.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.TFGenerationMixin.generate.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The minimum length of the sequence to be generated.`,name:"min_length"},{anchor:"transformers.TFGenerationMixin.generate.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.TFGenerationMixin.generate.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to stop the beam search when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.TFGenerationMixin.generate.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.TFGenerationMixin.generate.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities.`,name:"temperature"},{anchor:"transformers.TFGenerationMixin.generate.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.TFGenerationMixin.generate.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFGenerationMixin.generate.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the most probable tokens with probabilities that add up to <code>top_p</code> or higher
are kept for generation.`,name:"top_p"},{anchor:"transformers.TFGenerationMixin.generate.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.TFGenerationMixin.generate.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.TFGenerationMixin.generate.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.TFGenerationMixin.generate.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.TFGenerationMixin.generate.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent
to the sequence length, which in turn is used to divide the score of the sequence. Since the score is
the log likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences,
while <code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.TFGenerationMixin.generate.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.TFGenerationMixin.generate.bad_words_ids(List[int],",description:`<strong>bad_words_ids(<code>List[int]</code>,</strong> <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated. In order to get the tokens of the words that
should not appear in the generated text, use <code>tokenizer.encode(bad_word, add_prefix_space=True)</code>.`,name:"bad_words_ids(List[int],"},{anchor:"transformers.TFGenerationMixin.generate.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.TFGenerationMixin.generate.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of <code>dtype=tf.int32</code> and shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values are in <code>[0, 1]</code>, 1 for tokens
that are not masked, and 0 for masked tokens.</p>
<p>If not provided, will default to a tensor the same shape as <code>input_ids</code> that masks the pad token.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFGenerationMixin.generate.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"},{anchor:"transformers.TFGenerationMixin.generate.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"},{anchor:"transformers.TFGenerationMixin.generate.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.TFGenerationMixin.generate.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.TFGenerationMixin.generate.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.TFGenerationMixin.generate.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.TFGenerationMixin.generate.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful
for multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be
the target language token.`,name:"forced_bos_token_id"},{anchor:"transformers.TFGenerationMixin.generate.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"forced_eos_token_id"},{anchor:"transformers.TFGenerationMixin.generate.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>, defaults to <code>model.config.suppress_tokens</code>) &#x2014;
A list of tokens that will be supressed at generation. The <code>SupressTokens</code> logit processor will set
their log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.TFGenerationMixin.generate.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>, defaults to <code>model.config.begin_suppress_tokens</code>) &#x2014;
A list of tokens that will be supressed at the begining of the generation. The <code>SupressBeginTokens</code>
logit processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.TFGenerationMixin.generate.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_decoder_ids</code>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that
will be forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always
be a token of index 123.
model_specific_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model.`,name:"forced_decoder_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/tf_utils.py#L462",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchDecoderOnlyOutput</code>,</li>
<li><code>TFSampleDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSearchDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSampleDecoderOnlyOutput</code></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchEncoderDecoderOutput</code>,</li>
<li><code>TFSampleEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSearchEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSampleEncoderDecoderOutput</code></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),Rt=new V({props:{anchor:"transformers.TFGenerationMixin.generate.example",$$slots:{default:[pf]},$$scope:{ctx:$}}}),zn=new or({}),Pn=new P({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/flax_utils.py#L125"}}),Wn=new P({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": ndarray"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"bos_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Optional[int] = None"},{name:"decoder_start_token_id",val:": typing.Optional[int] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"prng_key",val:": typing.Optional[jax._src.numpy.ndarray.ndarray] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"no_repeat_ngram_size",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"forced_bos_token_id",val:": typing.Optional[int] = None"},{name:"forced_eos_token_id",val:": typing.Optional[int] = None"},{name:"length_penalty",val:": typing.Optional[float] = None"},{name:"early_stopping",val:": typing.Optional[bool] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Union[typing.Dict[str, jax._src.numpy.ndarray.ndarray], NoneType] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.max_length</code>) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. In general, prefer the use of <code>max_new_tokens</code>, which ignores the number of tokens in
the prompt.`,name:"max_length"},{anchor:"transformers.FlaxGenerationMixin.generate.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.FlaxGenerationMixin.generate.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.FlaxGenerationMixin.generate.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities.`,name:"temperature"},{anchor:"transformers.FlaxGenerationMixin.generate.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxGenerationMixin.generate.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the most probable tokens with probabilities that add up to <code>top_p</code> or higher
are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxGenerationMixin.generate.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.FlaxGenerationMixin.generate.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.FlaxGenerationMixin.generate.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.FlaxGenerationMixin.generate.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.FlaxGenerationMixin.generate.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.
model<em>kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If the model
is an encoder-decoder model, encoder specific kwargs should not be prefixed and decoder specific kwargs
should be prefixed with *decoder</em>*. Also accepts <code>encoder_outputs</code> to skip encoder part.`,name:"params"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/generation/flax_utils.py#L211",returnDescription:`
<p><a
  href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),Vt=new tu({props:{warning:!0,$$slots:{default:[mf]},$$scope:{ctx:$}}}),Kt=new V({props:{anchor:"transformers.FlaxGenerationMixin.generate.example",$$slots:{default:[gf]},$$scope:{ctx:$}}}),{c(){d=s("meta"),f=p(),u=s("h1"),c=s("a"),h=s("span"),x(i.$$.fragment),g=p(),D=s("span"),S=t("Generation"),J=p(),A=s("p"),N=t("Each framework has a generate method for auto-regressive text generation implemented in their respective "),T=s("code"),We=t("GenerationMixin"),Be=t(" class:"),Ee=p(),Ge=s("ul"),He=s("li"),Dr=t("PyTorch "),Vn=s("a"),Ar=t("generate()"),zr=t(" is implemented in "),Kn=s("a"),Pr=t("GenerationMixin"),Nr=t("."),Ir=p(),Re=s("li"),Wr=t("TensorFlow "),Zn=s("a"),Br=t("generate()"),Hr=t(" is implemented in "),Jn=s("a"),Rr=t("TFGenerationMixin"),Ur=t("."),Vr=p(),Ue=s("li"),Kr=t("Flax/JAX "),Xn=s("a"),Zr=t("generate()"),Jr=t(" is implemented in "),Yn=s("a"),Xr=t("FlaxGenerationMixin"),Yr=t("."),sr=p(),Ve=s("h2"),Tt=s("a"),Co=s("span"),x(nn.$$.fragment),Qr=p(),Fo=s("span"),ei=t("GenerationConfig"),ar=p(),I=s("div"),x(on.$$.fragment),ti=p(),Do=s("p"),ni=t("Class that holds a configuration for a generation task."),oi=p(),x(Et.$$.fragment),si=p(),Oe=s("div"),x(sn.$$.fragment),ai=p(),an=s("p"),ri=t("Instantiate a "),Qn=s("a"),ii=t("GenerationConfig"),li=t(" from a generation configuration file."),di=p(),x(Gt.$$.fragment),ci=p(),Ot=s("div"),x(rn.$$.fragment),pi=p(),Ke=s("p"),mi=t("Save a generation configuration object to the directory "),Ao=s("code"),gi=t("save_directory"),ui=t(`, so that it can be re-loaded using the
`),eo=s("a"),hi=t("from_pretrained()"),_i=t(" class method."),rr=p(),Ze=s("h2"),qt=s("a"),zo=s("span"),x(ln.$$.fragment),fi=p(),Po=s("span"),bi=t("GenerationMixin"),ir=p(),M=s("div"),x(dn.$$.fragment),vi=p(),cn=s("p"),xi=t("A class containing all functions for auto-regressive text generation, to be used as a mixin in "),to=s("a"),ki=t("PreTrainedModel"),yi=t("."),ji=p(),pn=s("p"),wi=t("The class exposes "),no=s("a"),Li=t("generate()"),$i=t(", which can be used for:"),Mi=p(),C=s("ul"),X=s("li"),No=s("em"),Ti=t("greedy decoding"),Ei=t(" by calling "),oo=s("a"),Gi=t("greedy_search()"),Oi=t(" if "),Io=s("code"),qi=t("num_beams=1"),Si=t(` and
`),Wo=s("code"),Ci=t("do_sample=False"),Fi=t("."),Di=p(),ye=s("li"),Bo=s("em"),Ai=t("contrastive search"),zi=t(" by calling "),so=s("a"),Pi=t("contrastive_search()"),Ni=t(" if "),Ho=s("code"),Ii=t("penalty_alpha>0"),Wi=t(` and
`),Ro=s("code"),Bi=t("top_k>1"),Hi=p(),Y=s("li"),Uo=s("em"),Ri=t("multinomial sampling"),Ui=t(" by calling "),ao=s("a"),Vi=t("sample()"),Ki=t(" if "),Vo=s("code"),Zi=t("num_beams=1"),Ji=t(` and
`),Ko=s("code"),Xi=t("do_sample=True"),Yi=t("."),Qi=p(),Q=s("li"),Zo=s("em"),el=t("beam-search decoding"),tl=t(" by calling "),ro=s("a"),nl=t("beam_search()"),ol=t(" if "),Jo=s("code"),sl=t("num_beams>1"),al=t(` and
`),Xo=s("code"),rl=t("do_sample=False"),il=t("."),ll=p(),ee=s("li"),Yo=s("em"),dl=t("beam-search multinomial sampling"),cl=t(" by calling "),io=s("a"),pl=t("beam_sample()"),ml=t(" if "),Qo=s("code"),gl=t("num_beams>1"),ul=t(`
and `),es=s("code"),hl=t("do_sample=True"),_l=t("."),fl=p(),te=s("li"),ts=s("em"),bl=t("diverse beam-search decoding"),vl=t(" by calling "),lo=s("a"),xl=t("group_beam_search()"),kl=t(", if "),ns=s("code"),yl=t("num_beams>1"),jl=t(`
and `),os=s("code"),wl=t("num_beam_groups>1"),Ll=t("."),$l=p(),ne=s("li"),ss=s("em"),Ml=t("constrained beam-search decoding"),Tl=t(" by calling "),co=s("a"),El=t("constrained_beam_search()"),Gl=t(`, if
`),as=s("code"),Ol=t("constraints!=None"),ql=t(" or "),rs=s("code"),Sl=t("force_words_ids!=None"),Cl=t("."),Fl=p(),G=s("div"),x(mn.$$.fragment),Dl=p(),is=s("p"),Al=t(`Generates sequences of token ids for models with a language modeling head. The method supports the following
generation methods for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),zl=p(),F=s("ul"),oe=s("li"),ls=s("em"),Pl=t("greedy decoding"),Nl=t(" by calling "),po=s("a"),Il=t("greedy_search()"),Wl=t(" if "),ds=s("code"),Bl=t("num_beams=1"),Hl=t(` and
`),cs=s("code"),Rl=t("do_sample=False"),Ul=t("."),Vl=p(),je=s("li"),ps=s("em"),Kl=t("contrastive search"),Zl=t(" by calling "),mo=s("a"),Jl=t("contrastive_search()"),Xl=t(" if "),ms=s("code"),Yl=t("penalty_alpha>0."),Ql=t(`
and `),gs=s("code"),ed=t("top_k>1"),td=p(),se=s("li"),us=s("em"),nd=t("multinomial sampling"),od=t(" by calling "),go=s("a"),sd=t("sample()"),ad=t(" if "),hs=s("code"),rd=t("num_beams=1"),id=t(` and
`),_s=s("code"),ld=t("do_sample=True"),dd=t("."),cd=p(),ae=s("li"),fs=s("em"),pd=t("beam-search decoding"),md=t(" by calling "),uo=s("a"),gd=t("beam_search()"),ud=t(" if "),bs=s("code"),hd=t("num_beams>1"),_d=t(` and
`),vs=s("code"),fd=t("do_sample=False"),bd=t("."),vd=p(),re=s("li"),xs=s("em"),xd=t("beam-search multinomial sampling"),kd=t(" by calling "),ho=s("a"),yd=t("beam_sample()"),jd=t(` if
`),ks=s("code"),wd=t("num_beams>1"),Ld=t(" and "),ys=s("code"),$d=t("do_sample=True"),Md=t("."),Td=p(),ie=s("li"),js=s("em"),Ed=t("diverse beam-search decoding"),Gd=t(" by calling "),_o=s("a"),Od=t("group_beam_search()"),qd=t(`, if
`),ws=s("code"),Sd=t("num_beams>1"),Cd=t(" and "),Ls=s("code"),Fd=t("num_beam_groups>1"),Dd=t("."),Ad=p(),le=s("li"),$s=s("em"),zd=t("constrained beam-search decoding"),Pd=t(" by calling "),fo=s("a"),Nd=t("constrained_beam_search()"),Id=t(`, if
`),Ms=s("code"),Wd=t("constraints!=None"),Bd=t(" or "),Ts=s("code"),Hd=t("force_words_ids!=None"),Rd=t("."),Ud=p(),x(St.$$.fragment),Vd=p(),gn=s("p"),Kd=t("Most of these parameters are explained in more detail in "),un=s("a"),Zd=t(`this blog
post`),Jd=t("."),Xd=p(),Es=s("p"),Yd=t("Examples:"),Qd=p(),x(Ct.$$.fragment),ec=p(),x(Ft.$$.fragment),tc=p(),x(Dt.$$.fragment),nc=p(),qe=s("div"),x(hn.$$.fragment),oc=p(),_n=s("p"),sc=t("Generates sequences of token ids for models with a language modeling head using "),Gs=s("strong"),ac=t("greedy decoding"),rc=t(` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),ic=p(),x(At.$$.fragment),lc=p(),Se=s("div"),x(fn.$$.fragment),dc=p(),bn=s("p"),cc=t("Generates sequences of token ids for models with a language modeling head using "),Os=s("strong"),pc=t("multinomial sampling"),mc=t(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),gc=p(),x(zt.$$.fragment),uc=p(),Ce=s("div"),x(vn.$$.fragment),hc=p(),xn=s("p"),_c=t("Generates sequences of token ids for models with a language modeling head using "),qs=s("strong"),fc=t("beam search decoding"),bc=t(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),vc=p(),x(Pt.$$.fragment),xc=p(),Fe=s("div"),x(kn.$$.fragment),kc=p(),yn=s("p"),yc=t("Generates sequences of token ids for models with a language modeling head using "),Ss=s("strong"),jc=t(`beam search multinomial
sampling`),wc=t(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Lc=p(),x(Nt.$$.fragment),$c=p(),De=s("div"),x(jn.$$.fragment),Mc=p(),wn=s("p"),Tc=t("Generates sequences of token ids for models with a language modeling head using "),Cs=s("strong"),Ec=t("contrastive search"),Gc=t(` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Oc=p(),x(It.$$.fragment),qc=p(),Ae=s("div"),x(Ln.$$.fragment),Sc=p(),$n=s("p"),Cc=t("Generates sequences of token ids for models with a language modeling head using "),Fs=s("strong"),Fc=t(`diverse beam search
decoding`),Dc=t(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Ac=p(),x(Wt.$$.fragment),zc=p(),ze=s("div"),x(Mn.$$.fragment),Pc=p(),Tn=s("p"),Nc=t("Generates sequences of token ids for models with a language modeling head using "),Ds=s("strong"),Ic=t(`constrained beam search
decoding`),Wc=t(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Bc=p(),x(Bt.$$.fragment),lr=p(),Je=s("h2"),Ht=s("a"),As=s("span"),x(En.$$.fragment),Hc=p(),zs=s("span"),Rc=t("TFGenerationMixin"),dr=p(),W=s("div"),x(Gn.$$.fragment),Uc=p(),On=s("p"),Vc=t("A class containing all of the functions supporting generation, to be used as a mixin in "),bo=s("a"),Kc=t("TFPreTrainedModel"),Zc=t("."),Jc=p(),qn=s("p"),Xc=t("The class exposes "),vo=s("a"),Yc=t("generate()"),Qc=t(", which can be used for:"),ep=p(),we=s("ul"),de=s("li"),Ps=s("em"),tp=t("greedy decoding"),np=t(" by calling "),Ns=s("code"),op=t("greedy_search()"),sp=t(" if "),Is=s("code"),ap=t("num_beams=1"),rp=t(` and
`),Ws=s("code"),ip=t("do_sample=False"),lp=t("."),dp=p(),Le=s("li"),Bs=s("em"),cp=t("contrastive search"),pp=t(" by calling "),Hs=s("code"),mp=t("contrastive_search()"),gp=t(" if "),Rs=s("code"),up=t("penalty_alpha>0"),hp=t(` and
`),Us=s("code"),_p=t("top_k>1"),fp=p(),ce=s("li"),Vs=s("em"),bp=t("multinomial sampling"),vp=t(" by calling "),Ks=s("code"),xp=t("sample()"),kp=t(" if "),Zs=s("code"),yp=t("num_beams=1"),jp=t(` and
`),Js=s("code"),wp=t("do_sample=True"),Lp=t("."),$p=p(),pe=s("li"),Xs=s("em"),Mp=t("beam-search decoding"),Tp=t(" by calling "),Ys=s("code"),Ep=t("beam_search()"),Gp=t(" if "),Qs=s("code"),Op=t("num_beams>1"),qp=t(` and
`),ea=s("code"),Sp=t("do_sample=False"),Cp=t("."),Fp=p(),O=s("div"),x(Sn.$$.fragment),Dp=p(),ta=s("p"),Ap=t(`Generates sequences of token ids for models with a language modeling head. The method supports the following
generation methods for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),zp=p(),$e=s("ul"),me=s("li"),na=s("em"),Pp=t("greedy decoding"),Np=t(" by calling "),oa=s("code"),Ip=t("greedy_search()"),Wp=t(" if "),sa=s("code"),Bp=t("num_beams=1"),Hp=t(` and
`),aa=s("code"),Rp=t("do_sample=False"),Up=t("."),Vp=p(),Me=s("li"),ra=s("em"),Kp=t("contrastive search"),Zp=t(" by calling "),ia=s("code"),Jp=t("contrastive_search()"),Xp=t(" if "),la=s("code"),Yp=t("penalty_alpha>0"),Qp=t(`
and `),da=s("code"),em=t("top_k>1"),tm=p(),ge=s("li"),ca=s("em"),nm=t("multinomial sampling"),om=t(" by calling "),pa=s("code"),sm=t("sample()"),am=t(" if "),ma=s("code"),rm=t("num_beams=1"),im=t(` and
`),ga=s("code"),lm=t("do_sample=True"),dm=t("."),cm=p(),ue=s("li"),ua=s("em"),pm=t("beam-search decoding"),mm=t(" by calling "),ha=s("code"),gm=t("beam_search()"),um=t(" if "),_a=s("code"),hm=t("num_beams>1"),_m=t(` and
`),fa=s("code"),fm=t("do_sample=False"),bm=t("."),vm=p(),Cn=s("p"),xm=t("Adapted in part from "),Fn=s("a"),km=t(`Facebook\u2019s XLM beam search
code`),ym=t("."),jm=p(),Te=s("p"),wm=t("Apart from "),ba=s("code"),Lm=t("input_ids"),$m=t(" and "),va=s("code"),Mm=t("attention_mask"),Tm=t(`, all the arguments below will default to the value of the attribute
of the same name inside the `),xo=s("a"),Em=t("PretrainedConfig"),Gm=t(` of the model. The default values indicated are the default
values of those config.`),Om=p(),Dn=s("p"),qm=t("Most of these parameters are explained in more detail in "),An=s("a"),Sm=t(`this blog
post`),Cm=t("."),Fm=p(),x(Rt.$$.fragment),cr=p(),Xe=s("h2"),Ut=s("a"),xa=s("span"),x(zn.$$.fragment),Dm=p(),ka=s("span"),Am=t("FlaxGenerationMixin"),pr=p(),B=s("div"),x(Pn.$$.fragment),zm=p(),Nn=s("p"),Pm=t(`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),ko=s("a"),Nm=t("FlaxPreTrainedModel"),Im=t("."),Wm=p(),In=s("p"),Bm=t("The class exposes "),yo=s("a"),Hm=t("generate()"),Rm=t(", which can be used for:"),Um=p(),Ye=s("ul"),he=s("li"),ya=s("em"),Vm=t("greedy decoding"),Km=t(" by calling "),ja=s("code"),Zm=t("_greedy_search()"),Jm=t(" if "),wa=s("code"),Xm=t("num_beams=1"),Ym=t(` and
`),La=s("code"),Qm=t("do_sample=False"),eg=t("."),tg=p(),_e=s("li"),$a=s("em"),ng=t("multinomial sampling"),og=t(" by calling "),Ma=s("code"),sg=t("_sample()"),ag=t(" if "),Ta=s("code"),rg=t("num_beams=1"),ig=t(` and
`),Ea=s("code"),lg=t("do_sample=True"),dg=t("."),cg=p(),fe=s("li"),Ga=s("em"),pg=t("beam-search decoding"),mg=t(" by calling "),Oa=s("code"),gg=t("_beam_search()"),ug=t(" if "),qa=s("code"),hg=t("num_beams>1"),_g=t(` and
`),Sa=s("code"),fg=t("do_sample=False"),bg=t("."),vg=p(),z=s("div"),x(Wn.$$.fragment),xg=p(),Ca=s("p"),kg=t(`Generates sequences of token ids for models with a language modeling head. The method supports the following
generation methods for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),yg=p(),Qe=s("ul"),be=s("li"),Fa=s("em"),jg=t("greedy decoding"),wg=t(" by calling "),Da=s("code"),Lg=t("_greedy_search()"),$g=t(" if "),Aa=s("code"),Mg=t("num_beams=1"),Tg=t(` and
`),za=s("code"),Eg=t("do_sample=False"),Gg=t("."),Og=p(),ve=s("li"),Pa=s("em"),qg=t("multinomial sampling"),Sg=t(" by calling "),Na=s("code"),Cg=t("_sample()"),Fg=t(" if "),Ia=s("code"),Dg=t("num_beams=1"),Ag=t(` and
`),Wa=s("code"),zg=t("do_sample=True"),Pg=t("."),Ng=p(),xe=s("li"),Ba=s("em"),Ig=t("beam-search decoding"),Wg=t(" by calling "),Ha=s("code"),Bg=t("_beam_search()"),Hg=t(" if "),Ra=s("code"),Rg=t("num_beams>1"),Ug=t(` and
`),Ua=s("code"),Vg=t("do_sample=False"),Kg=t("."),Zg=p(),x(Vt.$$.fragment),Jg=p(),Bn=s("p"),Xg=t("Most of these parameters are explained in more detail in "),Hn=s("a"),Yg=t(`this blog
post`),Qg=t("."),eu=p(),x(Kt.$$.fragment),this.h()},l(l){const b=Z_('[data-svelte="svelte-1phssyn"]',document.head);d=a(b,"META",{name:!0,content:!0}),b.forEach(o),f=m(l),u=a(l,"H1",{class:!0});var Rn=r(u);c=a(Rn,"A",{id:!0,class:!0,href:!0});var Va=r(c);h=a(Va,"SPAN",{});var Ka=r(h);k(i.$$.fragment,Ka),Ka.forEach(o),Va.forEach(o),g=m(Rn),D=a(Rn,"SPAN",{});var Za=r(D);S=n(Za,"Generation"),Za.forEach(o),Rn.forEach(o),J=m(l),A=a(l,"P",{});var Un=r(A);N=n(Un,"Each framework has a generate method for auto-regressive text generation implemented in their respective "),T=a(Un,"CODE",{});var Ja=r(T);We=n(Ja,"GenerationMixin"),Ja.forEach(o),Be=n(Un," class:"),Un.forEach(o),Ee=m(l),Ge=a(l,"UL",{});var et=r(Ge);He=a(et,"LI",{});var tt=r(He);Dr=n(tt,"PyTorch "),Vn=a(tt,"A",{href:!0});var Xa=r(Vn);Ar=n(Xa,"generate()"),Xa.forEach(o),zr=n(tt," is implemented in "),Kn=a(tt,"A",{href:!0});var Ya=r(Kn);Pr=n(Ya,"GenerationMixin"),Ya.forEach(o),Nr=n(tt,"."),tt.forEach(o),Ir=m(et),Re=a(et,"LI",{});var nt=r(Re);Wr=n(nt,"TensorFlow "),Zn=a(nt,"A",{href:!0});var Qa=r(Zn);Br=n(Qa,"generate()"),Qa.forEach(o),Hr=n(nt," is implemented in "),Jn=a(nt,"A",{href:!0});var er=r(Jn);Rr=n(er,"TFGenerationMixin"),er.forEach(o),Ur=n(nt,"."),nt.forEach(o),Vr=m(et),Ue=a(et,"LI",{});var ot=r(Ue);Kr=n(ot,"Flax/JAX "),Xn=a(ot,"A",{href:!0});var tr=r(Xn);Zr=n(tr,"generate()"),tr.forEach(o),Jr=n(ot," is implemented in "),Yn=a(ot,"A",{href:!0});var nr=r(Yn);Xr=n(nr,"FlaxGenerationMixin"),nr.forEach(o),Yr=n(ot,"."),ot.forEach(o),et.forEach(o),sr=m(l),Ve=a(l,"H2",{class:!0});var gr=r(Ve);Tt=a(gr,"A",{id:!0,class:!0,href:!0});var nu=r(Tt);Co=a(nu,"SPAN",{});var ou=r(Co);k(nn.$$.fragment,ou),ou.forEach(o),nu.forEach(o),Qr=m(gr),Fo=a(gr,"SPAN",{});var su=r(Fo);ei=n(su,"GenerationConfig"),su.forEach(o),gr.forEach(o),ar=m(l),I=a(l,"DIV",{class:!0});var Pe=r(I);k(on.$$.fragment,Pe),ti=m(Pe),Do=a(Pe,"P",{});var au=r(Do);ni=n(au,"Class that holds a configuration for a generation task."),au.forEach(o),oi=m(Pe),k(Et.$$.fragment,Pe),si=m(Pe),Oe=a(Pe,"DIV",{class:!0});var jo=r(Oe);k(sn.$$.fragment,jo),ai=m(jo),an=a(jo,"P",{});var ur=r(an);ri=n(ur,"Instantiate a "),Qn=a(ur,"A",{href:!0});var ru=r(Qn);ii=n(ru,"GenerationConfig"),ru.forEach(o),li=n(ur," from a generation configuration file."),ur.forEach(o),di=m(jo),k(Gt.$$.fragment,jo),jo.forEach(o),ci=m(Pe),Ot=a(Pe,"DIV",{class:!0});var hr=r(Ot);k(rn.$$.fragment,hr),pi=m(hr),Ke=a(hr,"P",{});var wo=r(Ke);mi=n(wo,"Save a generation configuration object to the directory "),Ao=a(wo,"CODE",{});var iu=r(Ao);gi=n(iu,"save_directory"),iu.forEach(o),ui=n(wo,`, so that it can be re-loaded using the
`),eo=a(wo,"A",{href:!0});var lu=r(eo);hi=n(lu,"from_pretrained()"),lu.forEach(o),_i=n(wo," class method."),wo.forEach(o),hr.forEach(o),Pe.forEach(o),rr=m(l),Ze=a(l,"H2",{class:!0});var _r=r(Ze);qt=a(_r,"A",{id:!0,class:!0,href:!0});var du=r(qt);zo=a(du,"SPAN",{});var cu=r(zo);k(ln.$$.fragment,cu),cu.forEach(o),du.forEach(o),fi=m(_r),Po=a(_r,"SPAN",{});var pu=r(Po);bi=n(pu,"GenerationMixin"),pu.forEach(o),_r.forEach(o),ir=m(l),M=a(l,"DIV",{class:!0});var E=r(M);k(dn.$$.fragment,E),vi=m(E),cn=a(E,"P",{});var fr=r(cn);xi=n(fr,"A class containing all functions for auto-regressive text generation, to be used as a mixin in "),to=a(fr,"A",{href:!0});var mu=r(to);ki=n(mu,"PreTrainedModel"),mu.forEach(o),yi=n(fr,"."),fr.forEach(o),ji=m(E),pn=a(E,"P",{});var br=r(pn);wi=n(br,"The class exposes "),no=a(br,"A",{href:!0});var gu=r(no);Li=n(gu,"generate()"),gu.forEach(o),$i=n(br,", which can be used for:"),br.forEach(o),Mi=m(E),C=a(E,"UL",{});var H=r(C);X=a(H,"LI",{});var st=r(X);No=a(st,"EM",{});var uu=r(No);Ti=n(uu,"greedy decoding"),uu.forEach(o),Ei=n(st," by calling "),oo=a(st,"A",{href:!0});var hu=r(oo);Gi=n(hu,"greedy_search()"),hu.forEach(o),Oi=n(st," if "),Io=a(st,"CODE",{});var _u=r(Io);qi=n(_u,"num_beams=1"),_u.forEach(o),Si=n(st,` and
`),Wo=a(st,"CODE",{});var fu=r(Wo);Ci=n(fu,"do_sample=False"),fu.forEach(o),Fi=n(st,"."),st.forEach(o),Di=m(H),ye=a(H,"LI",{});var Zt=r(ye);Bo=a(Zt,"EM",{});var bu=r(Bo);Ai=n(bu,"contrastive search"),bu.forEach(o),zi=n(Zt," by calling "),so=a(Zt,"A",{href:!0});var vu=r(so);Pi=n(vu,"contrastive_search()"),vu.forEach(o),Ni=n(Zt," if "),Ho=a(Zt,"CODE",{});var xu=r(Ho);Ii=n(xu,"penalty_alpha>0"),xu.forEach(o),Wi=n(Zt,` and
`),Ro=a(Zt,"CODE",{});var ku=r(Ro);Bi=n(ku,"top_k>1"),ku.forEach(o),Zt.forEach(o),Hi=m(H),Y=a(H,"LI",{});var at=r(Y);Uo=a(at,"EM",{});var yu=r(Uo);Ri=n(yu,"multinomial sampling"),yu.forEach(o),Ui=n(at," by calling "),ao=a(at,"A",{href:!0});var ju=r(ao);Vi=n(ju,"sample()"),ju.forEach(o),Ki=n(at," if "),Vo=a(at,"CODE",{});var wu=r(Vo);Zi=n(wu,"num_beams=1"),wu.forEach(o),Ji=n(at,` and
`),Ko=a(at,"CODE",{});var Lu=r(Ko);Xi=n(Lu,"do_sample=True"),Lu.forEach(o),Yi=n(at,"."),at.forEach(o),Qi=m(H),Q=a(H,"LI",{});var rt=r(Q);Zo=a(rt,"EM",{});var $u=r(Zo);el=n($u,"beam-search decoding"),$u.forEach(o),tl=n(rt," by calling "),ro=a(rt,"A",{href:!0});var Mu=r(ro);nl=n(Mu,"beam_search()"),Mu.forEach(o),ol=n(rt," if "),Jo=a(rt,"CODE",{});var Tu=r(Jo);sl=n(Tu,"num_beams>1"),Tu.forEach(o),al=n(rt,` and
`),Xo=a(rt,"CODE",{});var Eu=r(Xo);rl=n(Eu,"do_sample=False"),Eu.forEach(o),il=n(rt,"."),rt.forEach(o),ll=m(H),ee=a(H,"LI",{});var it=r(ee);Yo=a(it,"EM",{});var Gu=r(Yo);dl=n(Gu,"beam-search multinomial sampling"),Gu.forEach(o),cl=n(it," by calling "),io=a(it,"A",{href:!0});var Ou=r(io);pl=n(Ou,"beam_sample()"),Ou.forEach(o),ml=n(it," if "),Qo=a(it,"CODE",{});var qu=r(Qo);gl=n(qu,"num_beams>1"),qu.forEach(o),ul=n(it,`
and `),es=a(it,"CODE",{});var Su=r(es);hl=n(Su,"do_sample=True"),Su.forEach(o),_l=n(it,"."),it.forEach(o),fl=m(H),te=a(H,"LI",{});var lt=r(te);ts=a(lt,"EM",{});var Cu=r(ts);bl=n(Cu,"diverse beam-search decoding"),Cu.forEach(o),vl=n(lt," by calling "),lo=a(lt,"A",{href:!0});var Fu=r(lo);xl=n(Fu,"group_beam_search()"),Fu.forEach(o),kl=n(lt,", if "),ns=a(lt,"CODE",{});var Du=r(ns);yl=n(Du,"num_beams>1"),Du.forEach(o),jl=n(lt,`
and `),os=a(lt,"CODE",{});var Au=r(os);wl=n(Au,"num_beam_groups>1"),Au.forEach(o),Ll=n(lt,"."),lt.forEach(o),$l=m(H),ne=a(H,"LI",{});var dt=r(ne);ss=a(dt,"EM",{});var zu=r(ss);Ml=n(zu,"constrained beam-search decoding"),zu.forEach(o),Tl=n(dt," by calling "),co=a(dt,"A",{href:!0});var Pu=r(co);El=n(Pu,"constrained_beam_search()"),Pu.forEach(o),Gl=n(dt,`, if
`),as=a(dt,"CODE",{});var Nu=r(as);Ol=n(Nu,"constraints!=None"),Nu.forEach(o),ql=n(dt," or "),rs=a(dt,"CODE",{});var Iu=r(rs);Sl=n(Iu,"force_words_ids!=None"),Iu.forEach(o),Cl=n(dt,"."),dt.forEach(o),H.forEach(o),Fl=m(E),G=a(E,"DIV",{class:!0});var q=r(G);k(mn.$$.fragment,q),Dl=m(q),is=a(q,"P",{});var Wu=r(is);Al=n(Wu,`Generates sequences of token ids for models with a language modeling head. The method supports the following
generation methods for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Wu.forEach(o),zl=m(q),F=a(q,"UL",{});var R=r(F);oe=a(R,"LI",{});var ct=r(oe);ls=a(ct,"EM",{});var Bu=r(ls);Pl=n(Bu,"greedy decoding"),Bu.forEach(o),Nl=n(ct," by calling "),po=a(ct,"A",{href:!0});var Hu=r(po);Il=n(Hu,"greedy_search()"),Hu.forEach(o),Wl=n(ct," if "),ds=a(ct,"CODE",{});var Ru=r(ds);Bl=n(Ru,"num_beams=1"),Ru.forEach(o),Hl=n(ct,` and
`),cs=a(ct,"CODE",{});var Uu=r(cs);Rl=n(Uu,"do_sample=False"),Uu.forEach(o),Ul=n(ct,"."),ct.forEach(o),Vl=m(R),je=a(R,"LI",{});var Jt=r(je);ps=a(Jt,"EM",{});var Vu=r(ps);Kl=n(Vu,"contrastive search"),Vu.forEach(o),Zl=n(Jt," by calling "),mo=a(Jt,"A",{href:!0});var Ku=r(mo);Jl=n(Ku,"contrastive_search()"),Ku.forEach(o),Xl=n(Jt," if "),ms=a(Jt,"CODE",{});var Zu=r(ms);Yl=n(Zu,"penalty_alpha>0."),Zu.forEach(o),Ql=n(Jt,`
and `),gs=a(Jt,"CODE",{});var Ju=r(gs);ed=n(Ju,"top_k>1"),Ju.forEach(o),Jt.forEach(o),td=m(R),se=a(R,"LI",{});var pt=r(se);us=a(pt,"EM",{});var Xu=r(us);nd=n(Xu,"multinomial sampling"),Xu.forEach(o),od=n(pt," by calling "),go=a(pt,"A",{href:!0});var Yu=r(go);sd=n(Yu,"sample()"),Yu.forEach(o),ad=n(pt," if "),hs=a(pt,"CODE",{});var Qu=r(hs);rd=n(Qu,"num_beams=1"),Qu.forEach(o),id=n(pt,` and
`),_s=a(pt,"CODE",{});var eh=r(_s);ld=n(eh,"do_sample=True"),eh.forEach(o),dd=n(pt,"."),pt.forEach(o),cd=m(R),ae=a(R,"LI",{});var mt=r(ae);fs=a(mt,"EM",{});var th=r(fs);pd=n(th,"beam-search decoding"),th.forEach(o),md=n(mt," by calling "),uo=a(mt,"A",{href:!0});var nh=r(uo);gd=n(nh,"beam_search()"),nh.forEach(o),ud=n(mt," if "),bs=a(mt,"CODE",{});var oh=r(bs);hd=n(oh,"num_beams>1"),oh.forEach(o),_d=n(mt,` and
`),vs=a(mt,"CODE",{});var sh=r(vs);fd=n(sh,"do_sample=False"),sh.forEach(o),bd=n(mt,"."),mt.forEach(o),vd=m(R),re=a(R,"LI",{});var gt=r(re);xs=a(gt,"EM",{});var ah=r(xs);xd=n(ah,"beam-search multinomial sampling"),ah.forEach(o),kd=n(gt," by calling "),ho=a(gt,"A",{href:!0});var rh=r(ho);yd=n(rh,"beam_sample()"),rh.forEach(o),jd=n(gt,` if
`),ks=a(gt,"CODE",{});var ih=r(ks);wd=n(ih,"num_beams>1"),ih.forEach(o),Ld=n(gt," and "),ys=a(gt,"CODE",{});var lh=r(ys);$d=n(lh,"do_sample=True"),lh.forEach(o),Md=n(gt,"."),gt.forEach(o),Td=m(R),ie=a(R,"LI",{});var ut=r(ie);js=a(ut,"EM",{});var dh=r(js);Ed=n(dh,"diverse beam-search decoding"),dh.forEach(o),Gd=n(ut," by calling "),_o=a(ut,"A",{href:!0});var ch=r(_o);Od=n(ch,"group_beam_search()"),ch.forEach(o),qd=n(ut,`, if
`),ws=a(ut,"CODE",{});var ph=r(ws);Sd=n(ph,"num_beams>1"),ph.forEach(o),Cd=n(ut," and "),Ls=a(ut,"CODE",{});var mh=r(Ls);Fd=n(mh,"num_beam_groups>1"),mh.forEach(o),Dd=n(ut,"."),ut.forEach(o),Ad=m(R),le=a(R,"LI",{});var ht=r(le);$s=a(ht,"EM",{});var gh=r($s);zd=n(gh,"constrained beam-search decoding"),gh.forEach(o),Pd=n(ht," by calling "),fo=a(ht,"A",{href:!0});var uh=r(fo);Nd=n(uh,"constrained_beam_search()"),uh.forEach(o),Id=n(ht,`, if
`),Ms=a(ht,"CODE",{});var hh=r(Ms);Wd=n(hh,"constraints!=None"),hh.forEach(o),Bd=n(ht," or "),Ts=a(ht,"CODE",{});var _h=r(Ts);Hd=n(_h,"force_words_ids!=None"),_h.forEach(o),Rd=n(ht,"."),ht.forEach(o),R.forEach(o),Ud=m(q),k(St.$$.fragment,q),Vd=m(q),gn=a(q,"P",{});var vr=r(gn);Kd=n(vr,"Most of these parameters are explained in more detail in "),un=a(vr,"A",{href:!0,rel:!0});var fh=r(un);Zd=n(fh,`this blog
post`),fh.forEach(o),Jd=n(vr,"."),vr.forEach(o),Xd=m(q),Es=a(q,"P",{});var bh=r(Es);Yd=n(bh,"Examples:"),bh.forEach(o),Qd=m(q),k(Ct.$$.fragment,q),ec=m(q),k(Ft.$$.fragment,q),tc=m(q),k(Dt.$$.fragment,q),q.forEach(o),nc=m(E),qe=a(E,"DIV",{class:!0});var Lo=r(qe);k(hn.$$.fragment,Lo),oc=m(Lo),_n=a(Lo,"P",{});var xr=r(_n);sc=n(xr,"Generates sequences of token ids for models with a language modeling head using "),Gs=a(xr,"STRONG",{});var vh=r(Gs);ac=n(vh,"greedy decoding"),vh.forEach(o),rc=n(xr,` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),xr.forEach(o),ic=m(Lo),k(At.$$.fragment,Lo),Lo.forEach(o),lc=m(E),Se=a(E,"DIV",{class:!0});var $o=r(Se);k(fn.$$.fragment,$o),dc=m($o),bn=a($o,"P",{});var kr=r(bn);cc=n(kr,"Generates sequences of token ids for models with a language modeling head using "),Os=a(kr,"STRONG",{});var xh=r(Os);pc=n(xh,"multinomial sampling"),xh.forEach(o),mc=n(kr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),kr.forEach(o),gc=m($o),k(zt.$$.fragment,$o),$o.forEach(o),uc=m(E),Ce=a(E,"DIV",{class:!0});var Mo=r(Ce);k(vn.$$.fragment,Mo),hc=m(Mo),xn=a(Mo,"P",{});var yr=r(xn);_c=n(yr,"Generates sequences of token ids for models with a language modeling head using "),qs=a(yr,"STRONG",{});var kh=r(qs);fc=n(kh,"beam search decoding"),kh.forEach(o),bc=n(yr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),yr.forEach(o),vc=m(Mo),k(Pt.$$.fragment,Mo),Mo.forEach(o),xc=m(E),Fe=a(E,"DIV",{class:!0});var To=r(Fe);k(kn.$$.fragment,To),kc=m(To),yn=a(To,"P",{});var jr=r(yn);yc=n(jr,"Generates sequences of token ids for models with a language modeling head using "),Ss=a(jr,"STRONG",{});var yh=r(Ss);jc=n(yh,`beam search multinomial
sampling`),yh.forEach(o),wc=n(jr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),jr.forEach(o),Lc=m(To),k(Nt.$$.fragment,To),To.forEach(o),$c=m(E),De=a(E,"DIV",{class:!0});var Eo=r(De);k(jn.$$.fragment,Eo),Mc=m(Eo),wn=a(Eo,"P",{});var wr=r(wn);Tc=n(wr,"Generates sequences of token ids for models with a language modeling head using "),Cs=a(wr,"STRONG",{});var jh=r(Cs);Ec=n(jh,"contrastive search"),jh.forEach(o),Gc=n(wr,` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),wr.forEach(o),Oc=m(Eo),k(It.$$.fragment,Eo),Eo.forEach(o),qc=m(E),Ae=a(E,"DIV",{class:!0});var Go=r(Ae);k(Ln.$$.fragment,Go),Sc=m(Go),$n=a(Go,"P",{});var Lr=r($n);Cc=n(Lr,"Generates sequences of token ids for models with a language modeling head using "),Fs=a(Lr,"STRONG",{});var wh=r(Fs);Fc=n(wh,`diverse beam search
decoding`),wh.forEach(o),Dc=n(Lr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Lr.forEach(o),Ac=m(Go),k(Wt.$$.fragment,Go),Go.forEach(o),zc=m(E),ze=a(E,"DIV",{class:!0});var Oo=r(ze);k(Mn.$$.fragment,Oo),Pc=m(Oo),Tn=a(Oo,"P",{});var $r=r(Tn);Nc=n($r,"Generates sequences of token ids for models with a language modeling head using "),Ds=a($r,"STRONG",{});var Lh=r(Ds);Ic=n(Lh,`constrained beam search
decoding`),Lh.forEach(o),Wc=n($r," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),$r.forEach(o),Bc=m(Oo),k(Bt.$$.fragment,Oo),Oo.forEach(o),E.forEach(o),lr=m(l),Je=a(l,"H2",{class:!0});var Mr=r(Je);Ht=a(Mr,"A",{id:!0,class:!0,href:!0});var $h=r(Ht);As=a($h,"SPAN",{});var Mh=r(As);k(En.$$.fragment,Mh),Mh.forEach(o),$h.forEach(o),Hc=m(Mr),zs=a(Mr,"SPAN",{});var Th=r(zs);Rc=n(Th,"TFGenerationMixin"),Th.forEach(o),Mr.forEach(o),dr=m(l),W=a(l,"DIV",{class:!0});var Ne=r(W);k(Gn.$$.fragment,Ne),Uc=m(Ne),On=a(Ne,"P",{});var Tr=r(On);Vc=n(Tr,"A class containing all of the functions supporting generation, to be used as a mixin in "),bo=a(Tr,"A",{href:!0});var Eh=r(bo);Kc=n(Eh,"TFPreTrainedModel"),Eh.forEach(o),Zc=n(Tr,"."),Tr.forEach(o),Jc=m(Ne),qn=a(Ne,"P",{});var Er=r(qn);Xc=n(Er,"The class exposes "),vo=a(Er,"A",{href:!0});var Gh=r(vo);Yc=n(Gh,"generate()"),Gh.forEach(o),Qc=n(Er,", which can be used for:"),Er.forEach(o),ep=m(Ne),we=a(Ne,"UL",{});var Xt=r(we);de=a(Xt,"LI",{});var _t=r(de);Ps=a(_t,"EM",{});var Oh=r(Ps);tp=n(Oh,"greedy decoding"),Oh.forEach(o),np=n(_t," by calling "),Ns=a(_t,"CODE",{});var qh=r(Ns);op=n(qh,"greedy_search()"),qh.forEach(o),sp=n(_t," if "),Is=a(_t,"CODE",{});var Sh=r(Is);ap=n(Sh,"num_beams=1"),Sh.forEach(o),rp=n(_t,` and
`),Ws=a(_t,"CODE",{});var Ch=r(Ws);ip=n(Ch,"do_sample=False"),Ch.forEach(o),lp=n(_t,"."),_t.forEach(o),dp=m(Xt),Le=a(Xt,"LI",{});var Yt=r(Le);Bs=a(Yt,"EM",{});var Fh=r(Bs);cp=n(Fh,"contrastive search"),Fh.forEach(o),pp=n(Yt," by calling "),Hs=a(Yt,"CODE",{});var Dh=r(Hs);mp=n(Dh,"contrastive_search()"),Dh.forEach(o),gp=n(Yt," if "),Rs=a(Yt,"CODE",{});var Ah=r(Rs);up=n(Ah,"penalty_alpha>0"),Ah.forEach(o),hp=n(Yt,` and
`),Us=a(Yt,"CODE",{});var zh=r(Us);_p=n(zh,"top_k>1"),zh.forEach(o),Yt.forEach(o),fp=m(Xt),ce=a(Xt,"LI",{});var ft=r(ce);Vs=a(ft,"EM",{});var Ph=r(Vs);bp=n(Ph,"multinomial sampling"),Ph.forEach(o),vp=n(ft," by calling "),Ks=a(ft,"CODE",{});var Nh=r(Ks);xp=n(Nh,"sample()"),Nh.forEach(o),kp=n(ft," if "),Zs=a(ft,"CODE",{});var Ih=r(Zs);yp=n(Ih,"num_beams=1"),Ih.forEach(o),jp=n(ft,` and
`),Js=a(ft,"CODE",{});var Wh=r(Js);wp=n(Wh,"do_sample=True"),Wh.forEach(o),Lp=n(ft,"."),ft.forEach(o),$p=m(Xt),pe=a(Xt,"LI",{});var bt=r(pe);Xs=a(bt,"EM",{});var Bh=r(Xs);Mp=n(Bh,"beam-search decoding"),Bh.forEach(o),Tp=n(bt," by calling "),Ys=a(bt,"CODE",{});var Hh=r(Ys);Ep=n(Hh,"beam_search()"),Hh.forEach(o),Gp=n(bt," if "),Qs=a(bt,"CODE",{});var Rh=r(Qs);Op=n(Rh,"num_beams>1"),Rh.forEach(o),qp=n(bt,` and
`),ea=a(bt,"CODE",{});var Uh=r(ea);Sp=n(Uh,"do_sample=False"),Uh.forEach(o),Cp=n(bt,"."),bt.forEach(o),Xt.forEach(o),Fp=m(Ne),O=a(Ne,"DIV",{class:!0});var U=r(O);k(Sn.$$.fragment,U),Dp=m(U),ta=a(U,"P",{});var Vh=r(ta);Ap=n(Vh,`Generates sequences of token ids for models with a language modeling head. The method supports the following
generation methods for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Vh.forEach(o),zp=m(U),$e=a(U,"UL",{});var Qt=r($e);me=a(Qt,"LI",{});var vt=r(me);na=a(vt,"EM",{});var Kh=r(na);Pp=n(Kh,"greedy decoding"),Kh.forEach(o),Np=n(vt," by calling "),oa=a(vt,"CODE",{});var Zh=r(oa);Ip=n(Zh,"greedy_search()"),Zh.forEach(o),Wp=n(vt," if "),sa=a(vt,"CODE",{});var Jh=r(sa);Bp=n(Jh,"num_beams=1"),Jh.forEach(o),Hp=n(vt,` and
`),aa=a(vt,"CODE",{});var Xh=r(aa);Rp=n(Xh,"do_sample=False"),Xh.forEach(o),Up=n(vt,"."),vt.forEach(o),Vp=m(Qt),Me=a(Qt,"LI",{});var en=r(Me);ra=a(en,"EM",{});var Yh=r(ra);Kp=n(Yh,"contrastive search"),Yh.forEach(o),Zp=n(en," by calling "),ia=a(en,"CODE",{});var Qh=r(ia);Jp=n(Qh,"contrastive_search()"),Qh.forEach(o),Xp=n(en," if "),la=a(en,"CODE",{});var e_=r(la);Yp=n(e_,"penalty_alpha>0"),e_.forEach(o),Qp=n(en,`
and `),da=a(en,"CODE",{});var t_=r(da);em=n(t_,"top_k>1"),t_.forEach(o),en.forEach(o),tm=m(Qt),ge=a(Qt,"LI",{});var xt=r(ge);ca=a(xt,"EM",{});var n_=r(ca);nm=n(n_,"multinomial sampling"),n_.forEach(o),om=n(xt," by calling "),pa=a(xt,"CODE",{});var o_=r(pa);sm=n(o_,"sample()"),o_.forEach(o),am=n(xt," if "),ma=a(xt,"CODE",{});var s_=r(ma);rm=n(s_,"num_beams=1"),s_.forEach(o),im=n(xt,` and
`),ga=a(xt,"CODE",{});var a_=r(ga);lm=n(a_,"do_sample=True"),a_.forEach(o),dm=n(xt,"."),xt.forEach(o),cm=m(Qt),ue=a(Qt,"LI",{});var kt=r(ue);ua=a(kt,"EM",{});var r_=r(ua);pm=n(r_,"beam-search decoding"),r_.forEach(o),mm=n(kt," by calling "),ha=a(kt,"CODE",{});var i_=r(ha);gm=n(i_,"beam_search()"),i_.forEach(o),um=n(kt," if "),_a=a(kt,"CODE",{});var l_=r(_a);hm=n(l_,"num_beams>1"),l_.forEach(o),_m=n(kt,` and
`),fa=a(kt,"CODE",{});var d_=r(fa);fm=n(d_,"do_sample=False"),d_.forEach(o),bm=n(kt,"."),kt.forEach(o),Qt.forEach(o),vm=m(U),Cn=a(U,"P",{});var Gr=r(Cn);xm=n(Gr,"Adapted in part from "),Fn=a(Gr,"A",{href:!0,rel:!0});var c_=r(Fn);km=n(c_,`Facebook\u2019s XLM beam search
code`),c_.forEach(o),ym=n(Gr,"."),Gr.forEach(o),jm=m(U),Te=a(U,"P",{});var tn=r(Te);wm=n(tn,"Apart from "),ba=a(tn,"CODE",{});var p_=r(ba);Lm=n(p_,"input_ids"),p_.forEach(o),$m=n(tn," and "),va=a(tn,"CODE",{});var m_=r(va);Mm=n(m_,"attention_mask"),m_.forEach(o),Tm=n(tn,`, all the arguments below will default to the value of the attribute
of the same name inside the `),xo=a(tn,"A",{href:!0});var g_=r(xo);Em=n(g_,"PretrainedConfig"),g_.forEach(o),Gm=n(tn,` of the model. The default values indicated are the default
values of those config.`),tn.forEach(o),Om=m(U),Dn=a(U,"P",{});var Or=r(Dn);qm=n(Or,"Most of these parameters are explained in more detail in "),An=a(Or,"A",{href:!0,rel:!0});var u_=r(An);Sm=n(u_,`this blog
post`),u_.forEach(o),Cm=n(Or,"."),Or.forEach(o),Fm=m(U),k(Rt.$$.fragment,U),U.forEach(o),Ne.forEach(o),cr=m(l),Xe=a(l,"H2",{class:!0});var qr=r(Xe);Ut=a(qr,"A",{id:!0,class:!0,href:!0});var h_=r(Ut);xa=a(h_,"SPAN",{});var __=r(xa);k(zn.$$.fragment,__),__.forEach(o),h_.forEach(o),Dm=m(qr),ka=a(qr,"SPAN",{});var f_=r(ka);Am=n(f_,"FlaxGenerationMixin"),f_.forEach(o),qr.forEach(o),pr=m(l),B=a(l,"DIV",{class:!0});var Ie=r(B);k(Pn.$$.fragment,Ie),zm=m(Ie),Nn=a(Ie,"P",{});var Sr=r(Nn);Pm=n(Sr,`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),ko=a(Sr,"A",{href:!0});var b_=r(ko);Nm=n(b_,"FlaxPreTrainedModel"),b_.forEach(o),Im=n(Sr,"."),Sr.forEach(o),Wm=m(Ie),In=a(Ie,"P",{});var Cr=r(In);Bm=n(Cr,"The class exposes "),yo=a(Cr,"A",{href:!0});var v_=r(yo);Hm=n(v_,"generate()"),v_.forEach(o),Rm=n(Cr,", which can be used for:"),Cr.forEach(o),Um=m(Ie),Ye=a(Ie,"UL",{});var qo=r(Ye);he=a(qo,"LI",{});var yt=r(he);ya=a(yt,"EM",{});var x_=r(ya);Vm=n(x_,"greedy decoding"),x_.forEach(o),Km=n(yt," by calling "),ja=a(yt,"CODE",{});var k_=r(ja);Zm=n(k_,"_greedy_search()"),k_.forEach(o),Jm=n(yt," if "),wa=a(yt,"CODE",{});var y_=r(wa);Xm=n(y_,"num_beams=1"),y_.forEach(o),Ym=n(yt,` and
`),La=a(yt,"CODE",{});var j_=r(La);Qm=n(j_,"do_sample=False"),j_.forEach(o),eg=n(yt,"."),yt.forEach(o),tg=m(qo),_e=a(qo,"LI",{});var jt=r(_e);$a=a(jt,"EM",{});var w_=r($a);ng=n(w_,"multinomial sampling"),w_.forEach(o),og=n(jt," by calling "),Ma=a(jt,"CODE",{});var L_=r(Ma);sg=n(L_,"_sample()"),L_.forEach(o),ag=n(jt," if "),Ta=a(jt,"CODE",{});var $_=r(Ta);rg=n($_,"num_beams=1"),$_.forEach(o),ig=n(jt,` and
`),Ea=a(jt,"CODE",{});var M_=r(Ea);lg=n(M_,"do_sample=True"),M_.forEach(o),dg=n(jt,"."),jt.forEach(o),cg=m(qo),fe=a(qo,"LI",{});var wt=r(fe);Ga=a(wt,"EM",{});var T_=r(Ga);pg=n(T_,"beam-search decoding"),T_.forEach(o),mg=n(wt," by calling "),Oa=a(wt,"CODE",{});var E_=r(Oa);gg=n(E_,"_beam_search()"),E_.forEach(o),ug=n(wt," if "),qa=a(wt,"CODE",{});var G_=r(qa);hg=n(G_,"num_beams>1"),G_.forEach(o),_g=n(wt,` and
`),Sa=a(wt,"CODE",{});var O_=r(Sa);fg=n(O_,"do_sample=False"),O_.forEach(o),bg=n(wt,"."),wt.forEach(o),qo.forEach(o),vg=m(Ie),z=a(Ie,"DIV",{class:!0});var ke=r(z);k(Wn.$$.fragment,ke),xg=m(ke),Ca=a(ke,"P",{});var q_=r(Ca);kg=n(q_,`Generates sequences of token ids for models with a language modeling head. The method supports the following
generation methods for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),q_.forEach(o),yg=m(ke),Qe=a(ke,"UL",{});var So=r(Qe);be=a(So,"LI",{});var Lt=r(be);Fa=a(Lt,"EM",{});var S_=r(Fa);jg=n(S_,"greedy decoding"),S_.forEach(o),wg=n(Lt," by calling "),Da=a(Lt,"CODE",{});var C_=r(Da);Lg=n(C_,"_greedy_search()"),C_.forEach(o),$g=n(Lt," if "),Aa=a(Lt,"CODE",{});var F_=r(Aa);Mg=n(F_,"num_beams=1"),F_.forEach(o),Tg=n(Lt,` and
`),za=a(Lt,"CODE",{});var D_=r(za);Eg=n(D_,"do_sample=False"),D_.forEach(o),Gg=n(Lt,"."),Lt.forEach(o),Og=m(So),ve=a(So,"LI",{});var $t=r(ve);Pa=a($t,"EM",{});var A_=r(Pa);qg=n(A_,"multinomial sampling"),A_.forEach(o),Sg=n($t," by calling "),Na=a($t,"CODE",{});var z_=r(Na);Cg=n(z_,"_sample()"),z_.forEach(o),Fg=n($t," if "),Ia=a($t,"CODE",{});var P_=r(Ia);Dg=n(P_,"num_beams=1"),P_.forEach(o),Ag=n($t,` and
`),Wa=a($t,"CODE",{});var N_=r(Wa);zg=n(N_,"do_sample=True"),N_.forEach(o),Pg=n($t,"."),$t.forEach(o),Ng=m(So),xe=a(So,"LI",{});var Mt=r(xe);Ba=a(Mt,"EM",{});var I_=r(Ba);Ig=n(I_,"beam-search decoding"),I_.forEach(o),Wg=n(Mt," by calling "),Ha=a(Mt,"CODE",{});var W_=r(Ha);Bg=n(W_,"_beam_search()"),W_.forEach(o),Hg=n(Mt," if "),Ra=a(Mt,"CODE",{});var B_=r(Ra);Rg=n(B_,"num_beams>1"),B_.forEach(o),Ug=n(Mt,` and
`),Ua=a(Mt,"CODE",{});var H_=r(Ua);Vg=n(H_,"do_sample=False"),H_.forEach(o),Kg=n(Mt,"."),Mt.forEach(o),So.forEach(o),Zg=m(ke),k(Vt.$$.fragment,ke),Jg=m(ke),Bn=a(ke,"P",{});var Fr=r(Bn);Xg=n(Fr,"Most of these parameters are explained in more detail in "),Hn=a(Fr,"A",{href:!0,rel:!0});var R_=r(Hn);Yg=n(R_,`this blog
post`),R_.forEach(o),Qg=n(Fr,"."),Fr.forEach(o),eu=m(ke),k(Kt.$$.fragment,ke),ke.forEach(o),Ie.forEach(o),this.h()},h(){_(d,"name","hf:doc:metadata"),_(d,"content",JSON.stringify(hf)),_(c,"id","generation"),_(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),_(c,"href","#generation"),_(u,"class","relative group"),_(Vn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),_(Kn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin"),_(Zn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),_(Jn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.TFGenerationMixin"),_(Xn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),_(Yn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin"),_(Tt,"id","transformers.GenerationConfig"),_(Tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),_(Tt,"href","#transformers.GenerationConfig"),_(Ve,"class","relative group"),_(Qn,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationConfig"),_(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(eo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained"),_(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(qt,"id","transformers.GenerationMixin"),_(qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),_(qt,"href","#transformers.GenerationMixin"),_(Ze,"class","relative group"),_(to,"href","/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel"),_(no,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),_(oo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),_(so,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),_(ao,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),_(ro,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),_(io,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),_(lo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),_(co,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),_(po,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),_(mo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),_(go,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),_(uo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),_(ho,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),_(_o,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),_(fo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),_(un,"href","https://huggingface.co/blog/how-to-generate"),_(un,"rel","nofollow"),_(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ht,"id","transformers.TFGenerationMixin"),_(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),_(Ht,"href","#transformers.TFGenerationMixin"),_(Je,"class","relative group"),_(bo,"href","/docs/transformers/v4.25.1/en/main_classes/model#transformers.TFPreTrainedModel"),_(vo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),_(Fn,"href","https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529"),_(Fn,"rel","nofollow"),_(xo,"href","/docs/transformers/v4.25.1/en/main_classes/configuration#transformers.PretrainedConfig"),_(An,"href","https://huggingface.co/blog/how-to-generate"),_(An,"rel","nofollow"),_(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ut,"id","transformers.FlaxGenerationMixin"),_(Ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),_(Ut,"href","#transformers.FlaxGenerationMixin"),_(Xe,"class","relative group"),_(ko,"href","/docs/transformers/v4.25.1/en/main_classes/model#transformers.FlaxPreTrainedModel"),_(yo,"href","/docs/transformers/v4.25.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),_(Hn,"href","https://huggingface.co/blog/how-to-generate"),_(Hn,"rel","nofollow"),_(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,b){e(document.head,d),v(l,f,b),v(l,u,b),e(u,c),e(c,h),y(i,h,null),e(u,g),e(u,D),e(D,S),v(l,J,b),v(l,A,b),e(A,N),e(A,T),e(T,We),e(A,Be),v(l,Ee,b),v(l,Ge,b),e(Ge,He),e(He,Dr),e(He,Vn),e(Vn,Ar),e(He,zr),e(He,Kn),e(Kn,Pr),e(He,Nr),e(Ge,Ir),e(Ge,Re),e(Re,Wr),e(Re,Zn),e(Zn,Br),e(Re,Hr),e(Re,Jn),e(Jn,Rr),e(Re,Ur),e(Ge,Vr),e(Ge,Ue),e(Ue,Kr),e(Ue,Xn),e(Xn,Zr),e(Ue,Jr),e(Ue,Yn),e(Yn,Xr),e(Ue,Yr),v(l,sr,b),v(l,Ve,b),e(Ve,Tt),e(Tt,Co),y(nn,Co,null),e(Ve,Qr),e(Ve,Fo),e(Fo,ei),v(l,ar,b),v(l,I,b),y(on,I,null),e(I,ti),e(I,Do),e(Do,ni),e(I,oi),y(Et,I,null),e(I,si),e(I,Oe),y(sn,Oe,null),e(Oe,ai),e(Oe,an),e(an,ri),e(an,Qn),e(Qn,ii),e(an,li),e(Oe,di),y(Gt,Oe,null),e(I,ci),e(I,Ot),y(rn,Ot,null),e(Ot,pi),e(Ot,Ke),e(Ke,mi),e(Ke,Ao),e(Ao,gi),e(Ke,ui),e(Ke,eo),e(eo,hi),e(Ke,_i),v(l,rr,b),v(l,Ze,b),e(Ze,qt),e(qt,zo),y(ln,zo,null),e(Ze,fi),e(Ze,Po),e(Po,bi),v(l,ir,b),v(l,M,b),y(dn,M,null),e(M,vi),e(M,cn),e(cn,xi),e(cn,to),e(to,ki),e(cn,yi),e(M,ji),e(M,pn),e(pn,wi),e(pn,no),e(no,Li),e(pn,$i),e(M,Mi),e(M,C),e(C,X),e(X,No),e(No,Ti),e(X,Ei),e(X,oo),e(oo,Gi),e(X,Oi),e(X,Io),e(Io,qi),e(X,Si),e(X,Wo),e(Wo,Ci),e(X,Fi),e(C,Di),e(C,ye),e(ye,Bo),e(Bo,Ai),e(ye,zi),e(ye,so),e(so,Pi),e(ye,Ni),e(ye,Ho),e(Ho,Ii),e(ye,Wi),e(ye,Ro),e(Ro,Bi),e(C,Hi),e(C,Y),e(Y,Uo),e(Uo,Ri),e(Y,Ui),e(Y,ao),e(ao,Vi),e(Y,Ki),e(Y,Vo),e(Vo,Zi),e(Y,Ji),e(Y,Ko),e(Ko,Xi),e(Y,Yi),e(C,Qi),e(C,Q),e(Q,Zo),e(Zo,el),e(Q,tl),e(Q,ro),e(ro,nl),e(Q,ol),e(Q,Jo),e(Jo,sl),e(Q,al),e(Q,Xo),e(Xo,rl),e(Q,il),e(C,ll),e(C,ee),e(ee,Yo),e(Yo,dl),e(ee,cl),e(ee,io),e(io,pl),e(ee,ml),e(ee,Qo),e(Qo,gl),e(ee,ul),e(ee,es),e(es,hl),e(ee,_l),e(C,fl),e(C,te),e(te,ts),e(ts,bl),e(te,vl),e(te,lo),e(lo,xl),e(te,kl),e(te,ns),e(ns,yl),e(te,jl),e(te,os),e(os,wl),e(te,Ll),e(C,$l),e(C,ne),e(ne,ss),e(ss,Ml),e(ne,Tl),e(ne,co),e(co,El),e(ne,Gl),e(ne,as),e(as,Ol),e(ne,ql),e(ne,rs),e(rs,Sl),e(ne,Cl),e(M,Fl),e(M,G),y(mn,G,null),e(G,Dl),e(G,is),e(is,Al),e(G,zl),e(G,F),e(F,oe),e(oe,ls),e(ls,Pl),e(oe,Nl),e(oe,po),e(po,Il),e(oe,Wl),e(oe,ds),e(ds,Bl),e(oe,Hl),e(oe,cs),e(cs,Rl),e(oe,Ul),e(F,Vl),e(F,je),e(je,ps),e(ps,Kl),e(je,Zl),e(je,mo),e(mo,Jl),e(je,Xl),e(je,ms),e(ms,Yl),e(je,Ql),e(je,gs),e(gs,ed),e(F,td),e(F,se),e(se,us),e(us,nd),e(se,od),e(se,go),e(go,sd),e(se,ad),e(se,hs),e(hs,rd),e(se,id),e(se,_s),e(_s,ld),e(se,dd),e(F,cd),e(F,ae),e(ae,fs),e(fs,pd),e(ae,md),e(ae,uo),e(uo,gd),e(ae,ud),e(ae,bs),e(bs,hd),e(ae,_d),e(ae,vs),e(vs,fd),e(ae,bd),e(F,vd),e(F,re),e(re,xs),e(xs,xd),e(re,kd),e(re,ho),e(ho,yd),e(re,jd),e(re,ks),e(ks,wd),e(re,Ld),e(re,ys),e(ys,$d),e(re,Md),e(F,Td),e(F,ie),e(ie,js),e(js,Ed),e(ie,Gd),e(ie,_o),e(_o,Od),e(ie,qd),e(ie,ws),e(ws,Sd),e(ie,Cd),e(ie,Ls),e(Ls,Fd),e(ie,Dd),e(F,Ad),e(F,le),e(le,$s),e($s,zd),e(le,Pd),e(le,fo),e(fo,Nd),e(le,Id),e(le,Ms),e(Ms,Wd),e(le,Bd),e(le,Ts),e(Ts,Hd),e(le,Rd),e(G,Ud),y(St,G,null),e(G,Vd),e(G,gn),e(gn,Kd),e(gn,un),e(un,Zd),e(gn,Jd),e(G,Xd),e(G,Es),e(Es,Yd),e(G,Qd),y(Ct,G,null),e(G,ec),y(Ft,G,null),e(G,tc),y(Dt,G,null),e(M,nc),e(M,qe),y(hn,qe,null),e(qe,oc),e(qe,_n),e(_n,sc),e(_n,Gs),e(Gs,ac),e(_n,rc),e(qe,ic),y(At,qe,null),e(M,lc),e(M,Se),y(fn,Se,null),e(Se,dc),e(Se,bn),e(bn,cc),e(bn,Os),e(Os,pc),e(bn,mc),e(Se,gc),y(zt,Se,null),e(M,uc),e(M,Ce),y(vn,Ce,null),e(Ce,hc),e(Ce,xn),e(xn,_c),e(xn,qs),e(qs,fc),e(xn,bc),e(Ce,vc),y(Pt,Ce,null),e(M,xc),e(M,Fe),y(kn,Fe,null),e(Fe,kc),e(Fe,yn),e(yn,yc),e(yn,Ss),e(Ss,jc),e(yn,wc),e(Fe,Lc),y(Nt,Fe,null),e(M,$c),e(M,De),y(jn,De,null),e(De,Mc),e(De,wn),e(wn,Tc),e(wn,Cs),e(Cs,Ec),e(wn,Gc),e(De,Oc),y(It,De,null),e(M,qc),e(M,Ae),y(Ln,Ae,null),e(Ae,Sc),e(Ae,$n),e($n,Cc),e($n,Fs),e(Fs,Fc),e($n,Dc),e(Ae,Ac),y(Wt,Ae,null),e(M,zc),e(M,ze),y(Mn,ze,null),e(ze,Pc),e(ze,Tn),e(Tn,Nc),e(Tn,Ds),e(Ds,Ic),e(Tn,Wc),e(ze,Bc),y(Bt,ze,null),v(l,lr,b),v(l,Je,b),e(Je,Ht),e(Ht,As),y(En,As,null),e(Je,Hc),e(Je,zs),e(zs,Rc),v(l,dr,b),v(l,W,b),y(Gn,W,null),e(W,Uc),e(W,On),e(On,Vc),e(On,bo),e(bo,Kc),e(On,Zc),e(W,Jc),e(W,qn),e(qn,Xc),e(qn,vo),e(vo,Yc),e(qn,Qc),e(W,ep),e(W,we),e(we,de),e(de,Ps),e(Ps,tp),e(de,np),e(de,Ns),e(Ns,op),e(de,sp),e(de,Is),e(Is,ap),e(de,rp),e(de,Ws),e(Ws,ip),e(de,lp),e(we,dp),e(we,Le),e(Le,Bs),e(Bs,cp),e(Le,pp),e(Le,Hs),e(Hs,mp),e(Le,gp),e(Le,Rs),e(Rs,up),e(Le,hp),e(Le,Us),e(Us,_p),e(we,fp),e(we,ce),e(ce,Vs),e(Vs,bp),e(ce,vp),e(ce,Ks),e(Ks,xp),e(ce,kp),e(ce,Zs),e(Zs,yp),e(ce,jp),e(ce,Js),e(Js,wp),e(ce,Lp),e(we,$p),e(we,pe),e(pe,Xs),e(Xs,Mp),e(pe,Tp),e(pe,Ys),e(Ys,Ep),e(pe,Gp),e(pe,Qs),e(Qs,Op),e(pe,qp),e(pe,ea),e(ea,Sp),e(pe,Cp),e(W,Fp),e(W,O),y(Sn,O,null),e(O,Dp),e(O,ta),e(ta,Ap),e(O,zp),e(O,$e),e($e,me),e(me,na),e(na,Pp),e(me,Np),e(me,oa),e(oa,Ip),e(me,Wp),e(me,sa),e(sa,Bp),e(me,Hp),e(me,aa),e(aa,Rp),e(me,Up),e($e,Vp),e($e,Me),e(Me,ra),e(ra,Kp),e(Me,Zp),e(Me,ia),e(ia,Jp),e(Me,Xp),e(Me,la),e(la,Yp),e(Me,Qp),e(Me,da),e(da,em),e($e,tm),e($e,ge),e(ge,ca),e(ca,nm),e(ge,om),e(ge,pa),e(pa,sm),e(ge,am),e(ge,ma),e(ma,rm),e(ge,im),e(ge,ga),e(ga,lm),e(ge,dm),e($e,cm),e($e,ue),e(ue,ua),e(ua,pm),e(ue,mm),e(ue,ha),e(ha,gm),e(ue,um),e(ue,_a),e(_a,hm),e(ue,_m),e(ue,fa),e(fa,fm),e(ue,bm),e(O,vm),e(O,Cn),e(Cn,xm),e(Cn,Fn),e(Fn,km),e(Cn,ym),e(O,jm),e(O,Te),e(Te,wm),e(Te,ba),e(ba,Lm),e(Te,$m),e(Te,va),e(va,Mm),e(Te,Tm),e(Te,xo),e(xo,Em),e(Te,Gm),e(O,Om),e(O,Dn),e(Dn,qm),e(Dn,An),e(An,Sm),e(Dn,Cm),e(O,Fm),y(Rt,O,null),v(l,cr,b),v(l,Xe,b),e(Xe,Ut),e(Ut,xa),y(zn,xa,null),e(Xe,Dm),e(Xe,ka),e(ka,Am),v(l,pr,b),v(l,B,b),y(Pn,B,null),e(B,zm),e(B,Nn),e(Nn,Pm),e(Nn,ko),e(ko,Nm),e(Nn,Im),e(B,Wm),e(B,In),e(In,Bm),e(In,yo),e(yo,Hm),e(In,Rm),e(B,Um),e(B,Ye),e(Ye,he),e(he,ya),e(ya,Vm),e(he,Km),e(he,ja),e(ja,Zm),e(he,Jm),e(he,wa),e(wa,Xm),e(he,Ym),e(he,La),e(La,Qm),e(he,eg),e(Ye,tg),e(Ye,_e),e(_e,$a),e($a,ng),e(_e,og),e(_e,Ma),e(Ma,sg),e(_e,ag),e(_e,Ta),e(Ta,rg),e(_e,ig),e(_e,Ea),e(Ea,lg),e(_e,dg),e(Ye,cg),e(Ye,fe),e(fe,Ga),e(Ga,pg),e(fe,mg),e(fe,Oa),e(Oa,gg),e(fe,ug),e(fe,qa),e(qa,hg),e(fe,_g),e(fe,Sa),e(Sa,fg),e(fe,bg),e(B,vg),e(B,z),y(Wn,z,null),e(z,xg),e(z,Ca),e(Ca,kg),e(z,yg),e(z,Qe),e(Qe,be),e(be,Fa),e(Fa,jg),e(be,wg),e(be,Da),e(Da,Lg),e(be,$g),e(be,Aa),e(Aa,Mg),e(be,Tg),e(be,za),e(za,Eg),e(be,Gg),e(Qe,Og),e(Qe,ve),e(ve,Pa),e(Pa,qg),e(ve,Sg),e(ve,Na),e(Na,Cg),e(ve,Fg),e(ve,Ia),e(Ia,Dg),e(ve,Ag),e(ve,Wa),e(Wa,zg),e(ve,Pg),e(Qe,Ng),e(Qe,xe),e(xe,Ba),e(Ba,Ig),e(xe,Wg),e(xe,Ha),e(Ha,Bg),e(xe,Hg),e(xe,Ra),e(Ra,Rg),e(xe,Ug),e(xe,Ua),e(Ua,Vg),e(xe,Kg),e(z,Zg),y(Vt,z,null),e(z,Jg),e(z,Bn),e(Bn,Xg),e(Bn,Hn),e(Hn,Yg),e(Bn,Qg),e(z,eu),y(Kt,z,null),mr=!0},p(l,[b]){const Rn={};b&2&&(Rn.$$scope={dirty:b,ctx:l}),Et.$set(Rn);const Va={};b&2&&(Va.$$scope={dirty:b,ctx:l}),Gt.$set(Va);const Ka={};b&2&&(Ka.$$scope={dirty:b,ctx:l}),St.$set(Ka);const Za={};b&2&&(Za.$$scope={dirty:b,ctx:l}),Ct.$set(Za);const Un={};b&2&&(Un.$$scope={dirty:b,ctx:l}),Ft.$set(Un);const Ja={};b&2&&(Ja.$$scope={dirty:b,ctx:l}),Dt.$set(Ja);const et={};b&2&&(et.$$scope={dirty:b,ctx:l}),At.$set(et);const tt={};b&2&&(tt.$$scope={dirty:b,ctx:l}),zt.$set(tt);const Xa={};b&2&&(Xa.$$scope={dirty:b,ctx:l}),Pt.$set(Xa);const Ya={};b&2&&(Ya.$$scope={dirty:b,ctx:l}),Nt.$set(Ya);const nt={};b&2&&(nt.$$scope={dirty:b,ctx:l}),It.$set(nt);const Qa={};b&2&&(Qa.$$scope={dirty:b,ctx:l}),Wt.$set(Qa);const er={};b&2&&(er.$$scope={dirty:b,ctx:l}),Bt.$set(er);const ot={};b&2&&(ot.$$scope={dirty:b,ctx:l}),Rt.$set(ot);const tr={};b&2&&(tr.$$scope={dirty:b,ctx:l}),Vt.$set(tr);const nr={};b&2&&(nr.$$scope={dirty:b,ctx:l}),Kt.$set(nr)},i(l){mr||(j(i.$$.fragment,l),j(nn.$$.fragment,l),j(on.$$.fragment,l),j(Et.$$.fragment,l),j(sn.$$.fragment,l),j(Gt.$$.fragment,l),j(rn.$$.fragment,l),j(ln.$$.fragment,l),j(dn.$$.fragment,l),j(mn.$$.fragment,l),j(St.$$.fragment,l),j(Ct.$$.fragment,l),j(Ft.$$.fragment,l),j(Dt.$$.fragment,l),j(hn.$$.fragment,l),j(At.$$.fragment,l),j(fn.$$.fragment,l),j(zt.$$.fragment,l),j(vn.$$.fragment,l),j(Pt.$$.fragment,l),j(kn.$$.fragment,l),j(Nt.$$.fragment,l),j(jn.$$.fragment,l),j(It.$$.fragment,l),j(Ln.$$.fragment,l),j(Wt.$$.fragment,l),j(Mn.$$.fragment,l),j(Bt.$$.fragment,l),j(En.$$.fragment,l),j(Gn.$$.fragment,l),j(Sn.$$.fragment,l),j(Rt.$$.fragment,l),j(zn.$$.fragment,l),j(Pn.$$.fragment,l),j(Wn.$$.fragment,l),j(Vt.$$.fragment,l),j(Kt.$$.fragment,l),mr=!0)},o(l){w(i.$$.fragment,l),w(nn.$$.fragment,l),w(on.$$.fragment,l),w(Et.$$.fragment,l),w(sn.$$.fragment,l),w(Gt.$$.fragment,l),w(rn.$$.fragment,l),w(ln.$$.fragment,l),w(dn.$$.fragment,l),w(mn.$$.fragment,l),w(St.$$.fragment,l),w(Ct.$$.fragment,l),w(Ft.$$.fragment,l),w(Dt.$$.fragment,l),w(hn.$$.fragment,l),w(At.$$.fragment,l),w(fn.$$.fragment,l),w(zt.$$.fragment,l),w(vn.$$.fragment,l),w(Pt.$$.fragment,l),w(kn.$$.fragment,l),w(Nt.$$.fragment,l),w(jn.$$.fragment,l),w(It.$$.fragment,l),w(Ln.$$.fragment,l),w(Wt.$$.fragment,l),w(Mn.$$.fragment,l),w(Bt.$$.fragment,l),w(En.$$.fragment,l),w(Gn.$$.fragment,l),w(Sn.$$.fragment,l),w(Rt.$$.fragment,l),w(zn.$$.fragment,l),w(Pn.$$.fragment,l),w(Wn.$$.fragment,l),w(Vt.$$.fragment,l),w(Kt.$$.fragment,l),mr=!1},d(l){o(d),l&&o(f),l&&o(u),L(i),l&&o(J),l&&o(A),l&&o(Ee),l&&o(Ge),l&&o(sr),l&&o(Ve),L(nn),l&&o(ar),l&&o(I),L(on),L(Et),L(sn),L(Gt),L(rn),l&&o(rr),l&&o(Ze),L(ln),l&&o(ir),l&&o(M),L(dn),L(mn),L(St),L(Ct),L(Ft),L(Dt),L(hn),L(At),L(fn),L(zt),L(vn),L(Pt),L(kn),L(Nt),L(jn),L(It),L(Ln),L(Wt),L(Mn),L(Bt),l&&o(lr),l&&o(Je),L(En),l&&o(dr),l&&o(W),L(Gn),L(Sn),L(Rt),l&&o(cr),l&&o(Xe),L(zn),l&&o(pr),l&&o(B),L(Pn),L(Wn),L(Vt),L(Kt)}}}const hf={local:"generation",sections:[{local:"transformers.GenerationConfig",title:"GenerationConfig"},{local:"transformers.GenerationMixin",title:"GenerationMixin"},{local:"transformers.TFGenerationMixin",title:"TFGenerationMixin"},{local:"transformers.FlaxGenerationMixin",title:"FlaxGenerationMixin"}],title:"Generation"};function _f($){return J_(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jf extends U_{constructor(d){super();V_(this,d,_f,uf,K_,{})}}export{jf as default,hf as metadata};
