import{s as ht,o as _t,n as Le}from"../chunks/scheduler.8c3d61f6.js";import{S as bt,i as yt,g as d,s as i,r as g,A as Tt,h as p,f as n,c as a,j as w,u,x as M,k as J,y as t,a as c,v as f,d as h,t as _,w as b}from"../chunks/index.da70eac4.js";import{T as Mt}from"../chunks/Tip.1d9b8c37.js";import{D as j}from"../chunks/Docstring.dcbc19b1.js";import{C as De}from"../chunks/CodeBlock.a9c4becf.js";import{E as Qe}from"../chunks/ExampleCodeBlock.da4c0768.js";import{H as we,E as vt}from"../chunks/getInferenceSnippets.86beaec3.js";function wt(U){let s,v='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){s=d("p"),s.innerHTML=v},l(m){s=p(m,"P",{"data-svelte-h":!0}),M(s)!=="svelte-1qn15hi"&&(s.innerHTML=v)},m(m,l){c(m,s,l)},p:Le,d(m){m&&n(s)}}}function Jt(U){let s,v="Examples:",m,l,y;return l=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29zbW9zVGV4dFRvV29ybGRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm52aWRpYSUyRkNvc21vcy0xLjAtRGlmZnVzaW9uLTdCLVRleHQyV29ybGQlMjIlMEFwaXBlJTIwJTNEJTIwQ29zbW9zVGV4dFRvV29ybGRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc2xlZWslMkMlMjBodW1hbm9pZCUyMHJvYm90JTIwc3RhbmRzJTIwaW4lMjBhJTIwdmFzdCUyMHdhcmVob3VzZSUyMGZpbGxlZCUyMHdpdGglMjBuZWF0bHklMjBzdGFja2VkJTIwY2FyZGJvYXJkJTIwYm94ZXMlMjBvbiUyMGluZHVzdHJpYWwlMjBzaGVsdmVzLiUyMFRoZSUyMHJvYm90J3MlMjBtZXRhbGxpYyUyMGJvZHklMjBnbGVhbXMlMjB1bmRlciUyMHRoZSUyMGJyaWdodCUyQyUyMGV2ZW4lMjBsaWdodGluZyUyQyUyMGhpZ2hsaWdodGluZyUyMGl0cyUyMGZ1dHVyaXN0aWMlMjBkZXNpZ24lMjBhbmQlMjBpbnRyaWNhdGUlMjBqb2ludHMuJTIwQSUyMGdsb3dpbmclMjBibHVlJTIwbGlnaHQlMjBlbWFuYXRlcyUyMGZyb20lMjBpdHMlMjBjaGVzdCUyQyUyMGFkZGluZyUyMGElMjB0b3VjaCUyMG9mJTIwYWR2YW5jZWQlMjB0ZWNobm9sb2d5LiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGRvbWluYXRlZCUyMGJ5JTIwcm93cyUyMG9mJTIwYm94ZXMlMkMlMjBzdWdnZXN0aW5nJTIwYSUyMGhpZ2hseSUyMG9yZ2FuaXplZCUyMHN0b3JhZ2UlMjBzeXN0ZW0uJTIwVGhlJTIwZmxvb3IlMjBpcyUyMGxpbmVkJTIwd2l0aCUyMHdvb2RlbiUyMHBhbGxldHMlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBpbmR1c3RyaWFsJTIwc2V0dGluZy4lMjBUaGUlMjBjYW1lcmElMjByZW1haW5zJTIwc3RhdGljJTJDJTIwY2FwdHVyaW5nJTIwdGhlJTIwcm9ib3QncyUyMHBvaXNlZCUyMHN0YW5jZSUyMGFtaWRzdCUyMHRoZSUyMG9yZGVybHklMjBlbnZpcm9ubWVudCUyQyUyMHdpdGglMjBhJTIwc2hhbGxvdyUyMGRlcHRoJTIwb2YlMjBmaWVsZCUyMHRoYXQlMjBrZWVwcyUyMHRoZSUyMGZvY3VzJTIwb24lMjB0aGUlMjByb2JvdCUyMHdoaWxlJTIwc3VidGx5JTIwYmx1cnJpbmclMjB0aGUlMjBiYWNrZ3JvdW5kJTIwZm9yJTIwYSUyMGNpbmVtYXRpYyUyMGVmZmVjdC4lMjIlMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMzAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CosmosTextToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-1.0-Diffusion-7B-Text2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CosmosTextToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A sleek, humanoid robot stands in a vast warehouse filled with neatly stacked cardboard boxes on industrial shelves. The robot&#x27;s metallic body gleams under the bright, even lighting, highlighting its futuristic design and intricate joints. A glowing blue light emanates from its chest, adding a touch of advanced technology. The background is dominated by rows of boxes, suggesting a highly organized storage system. The floor is lined with wooden pallets, enhancing the industrial setting. The camera remains static, capturing the robot&#x27;s poised stance amidst the orderly environment, with a shallow depth of field that keeps the focus on the robot while subtly blurring the background for a cinematic effect.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){s=d("p"),s.textContent=v,m=i(),g(l.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),M(s)!=="svelte-kvfsh7"&&(s.textContent=v),m=a(o),u(l.$$.fragment,o)},m(o,T){c(o,s,T),c(o,m,T),f(l,o,T),y=!0},p:Le,i(o){y||(h(l.$$.fragment,o),y=!0)},o(o){_(l.$$.fragment,o),y=!1},d(o){o&&(n(s),n(m)),b(l,o)}}}function xt(U){let s,v="Image conditioning:",m,l,y;return l=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybnZpZGlhJTJGQ29zbW9zLTEuMC1EaWZmdXNpb24tN0ItVmlkZW8yV29ybGQlMjIlMEFwaXBlJTIwJTNEJTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVGhlJTIwdmlkZW8lMjBkZXBpY3RzJTIwYSUyMGxvbmclMkMlMjBzdHJhaWdodCUyMGhpZ2h3YXklMjBzdHJldGNoaW5nJTIwaW50byUyMHRoZSUyMGRpc3RhbmNlJTJDJTIwZmxhbmtlZCUyMGJ5JTIwbWV0YWwlMjBndWFyZHJhaWxzLiUyMFRoZSUyMHJvYWQlMjBpcyUyMGRpdmlkZWQlMjBpbnRvJTIwbXVsdGlwbGUlMjBsYW5lcyUyQyUyMHdpdGglMjBhJTIwZmV3JTIwdmVoaWNsZXMlMjB2aXNpYmxlJTIwaW4lMjB0aGUlMjBmYXIlMjBkaXN0YW5jZS4lMjBUaGUlMjBzdXJyb3VuZGluZyUyMGxhbmRzY2FwZSUyMGZlYXR1cmVzJTIwZHJ5JTJDJTIwZ3Jhc3N5JTIwZmllbGRzJTIwb24lMjBvbmUlMjBzaWRlJTIwYW5kJTIwcm9sbGluZyUyMGhpbGxzJTIwb24lMjB0aGUlMjBvdGhlci4lMjBUaGUlMjBza3klMjBpcyUyMG1vc3RseSUyMGNsZWFyJTIwd2l0aCUyMGElMjBmZXclMjBzY2F0dGVyZWQlMjBjbG91ZHMlMkMlMjBzdWdnZXN0aW5nJTIwYSUyMGJyaWdodCUyQyUyMHN1bm55JTIwZGF5LiUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb3Ntb3MlMkZjb3Ntb3MtdmlkZW8yd29ybGQtaW5wdXQuanBnJTIyJTBBKSUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZShpbWFnZSUzRGltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CosmosVideoToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-1.0-Diffusion-7B-Video2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CosmosVideoToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video depicts a long, straight highway stretching into the distance, flanked by metal guardrails. The road is divided into multiple lanes, with a few vehicles visible in the far distance. The surrounding landscape features dry, grassy fields on one side and rolling hills on the other. The sky is mostly clear with a few scattered clouds, suggesting a bright, sunny day.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(image=image, prompt=prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){s=d("p"),s.textContent=v,m=i(),g(l.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),M(s)!=="svelte-187s8ri"&&(s.textContent=v),m=a(o),u(l.$$.fragment,o)},m(o,T){c(o,s,T),c(o,m,T),f(l,o,T),y=!0},p:Le,i(o){y||(h(l.$$.fragment,o),y=!0)},o(o){_(l.$$.fragment,o),y=!1},d(o){o&&(n(s),n(m)),b(l,o)}}}function Ct(U){let s,v="Video conditioning:",m,l,y;return l=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybnZpZGlhJTJGQ29zbW9zLTEuMC1EaWZmdXNpb24tN0ItVmlkZW8yV29ybGQlMjIlMEFwaXBlJTIwJTNEJTIwQ29zbW9zVmlkZW9Ub1dvcmxkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUaGUlMjB2aWRlbyUyMGRlcGljdHMlMjBhJTIwd2luZGluZyUyMG1vdW50YWluJTIwcm9hZCUyMGNvdmVyZWQlMjBpbiUyMHNub3clMkMlMjB3aXRoJTIwYSUyMHNpbmdsZSUyMHZlaGljbGUlMjB0cmF2ZWxpbmclMjBhbG9uZyUyMGl0LiUyMFRoZSUyMHJvYWQlMjBpcyUyMGZsYW5rZWQlMjBieSUyMHN0ZWVwJTJDJTIwcm9ja3klMjBjbGlmZnMlMjBhbmQlMjBzcGFyc2UlMjB2ZWdldGF0aW9uLiUyMFRoZSUyMGxhbmRzY2FwZSUyMGlzJTIwY2hhcmFjdGVyaXplZCUyMGJ5JTIwcnVnZ2VkJTIwdGVycmFpbiUyMGFuZCUyMGElMjByaXZlciUyMHZpc2libGUlMjBpbiUyMHRoZSUyMGRpc3RhbmNlLiUyMFRoZSUyMHNjZW5lJTIwY2FwdHVyZXMlMjB0aGUlMjBzb2xpdHVkZSUyMGFuZCUyMGJlYXV0eSUyMG9mJTIwYSUyMHdpbnRlciUyMGRyaXZlJTIwdGhyb3VnaCUyMGElMjBtb3VudGFpbm91cyUyMHJlZ2lvbi4lMjIlMEF2aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29zbW9zJTJGY29zbW9zLXZpZGVvMndvcmxkLWlucHV0LXZpZC5tcDQlMjIlMEEpJTVCJTBBJTIwJTIwJTIwJTIwJTNBMjElMEElNUQlMjAlMjAlMjMlMjBUaGlzJTIwZXhhbXBsZSUyMHVzZXMlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAyMSUyMGZyYW1lcyUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZSh2aWRlbyUzRHZpZGVvJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CosmosVideoToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-1.0-Diffusion-7B-Video2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CosmosVideoToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video depicts a winding mountain road covered in snow, with a single vehicle traveling along it. The road is flanked by steep, rocky cliffs and sparse vegetation. The landscape is characterized by rugged terrain and a river visible in the distance. The scene captures the solitude and beauty of a winter drive through a mountainous region.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input-vid.mp4&quot;</span>
<span class="hljs-meta">... </span>)[
<span class="hljs-meta">... </span>    :<span class="hljs-number">21</span>
<span class="hljs-meta">... </span>]  <span class="hljs-comment"># This example uses only the first 21 frames</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(video=video, prompt=prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){s=d("p"),s.textContent=v,m=i(),g(l.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),M(s)!=="svelte-8d7hws"&&(s.textContent=v),m=a(o),u(l.$$.fragment,o)},m(o,T){c(o,s,T),c(o,m,T),f(l,o,T),y=!0},p:Le,i(o){y||(h(l.$$.fragment,o),y=!0)},o(o){_(l.$$.fragment,o),y=!1},d(o){o&&(n(s),n(m)),b(l,o)}}}function It(U){let s,v="Examples:",m,l,y;return l=new De({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> Cosmos2TextToImagePipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available checkpoints: nvidia/Cosmos-Predict2-2B-Text2Image, nvidia/Cosmos-Predict2-14B-Text2Image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-Predict2-2B-Text2Image&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = Cosmos2TextToImagePipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A close-up shot captures a vibrant yellow scrubber vigorously working on a grimy plate, its bristles moving in circular motions to lift stubborn grease and food residue. The dish, once covered in remnants of a hearty meal, gradually reveals its original glossy surface. Suds form and bubble around the scrubber, creating a satisfying visual of cleanliness in progress. The sound of scrubbing fills the air, accompanied by the gentle clinking of the dish against the sink. As the scrubber continues its task, the dish transforms, gleaming under the bright kitchen lights, symbolizing the triumph of cleanliness over mess.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;The video captures a series of frames showing ugly scenes, static with no motion, motion blur, over-saturation, shaky footage, low resolution, grainy texture, pixelated images, poorly lit areas, underexposed and overexposed scenes, poor color balance, washed out colors, choppy sequences, jerky movements, low frame rate, artifacting, color banding, unnatural transitions, outdated special effects, fake elements, unconvincing visuals, poorly edited content, jump cuts, visual noise, and flickering. Overall, the video is of poor quality.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, negative_prompt=negative_prompt, generator=torch.Generator().manual_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>output.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){s=d("p"),s.textContent=v,m=i(),g(l.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),M(s)!=="svelte-kvfsh7"&&(s.textContent=v),m=a(o),u(l.$$.fragment,o)},m(o,T){c(o,s,T),c(o,m,T),f(l,o,T),y=!0},p:Le,i(o){y||(h(l.$$.fragment,o),y=!0)},o(o){_(l.$$.fragment,o),y=!1},d(o){o&&(n(s),n(m)),b(l,o)}}}function Wt(U){let s,v="Examples:",m,l,y;return l=new De({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> Cosmos2VideoToWorldPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available checkpoints: nvidia/Cosmos-Predict2-2B-Video2World, nvidia/Cosmos-Predict2-14B-Video2World</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;nvidia/Cosmos-Predict2-2B-Video2World&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = Cosmos2VideoToWorldPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A close-up shot captures a vibrant yellow scrubber vigorously working on a grimy plate, its bristles moving in circular motions to lift stubborn grease and food residue. The dish, once covered in remnants of a hearty meal, gradually reveals its original glossy surface. Suds form and bubble around the scrubber, creating a satisfying visual of cleanliness in progress. The sound of scrubbing fills the air, accompanied by the gentle clinking of the dish against the sink. As the scrubber continues its task, the dish transforms, gleaming under the bright kitchen lights, symbolizing the triumph of cleanliness over mess.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;The video captures a series of frames showing ugly scenes, static with no motion, motion blur, over-saturation, shaky footage, low resolution, grainy texture, pixelated images, poorly lit areas, underexposed and overexposed scenes, poor color balance, washed out colors, choppy sequences, jerky movements, low frame rate, artifacting, color banding, unnatural transitions, outdated special effects, fake elements, unconvincing visuals, poorly edited content, jump cuts, visual noise, and flickering. Overall, the video is of poor quality.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/yellow-scrubber.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image, prompt=prompt, negative_prompt=negative_prompt, generator=torch.Generator().manual_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){s=d("p"),s.textContent=v,m=i(),g(l.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),M(s)!=="svelte-kvfsh7"&&(s.textContent=v),m=a(o),u(l.$$.fragment,o)},m(o,T){c(o,s,T),c(o,m,T),f(l,o,T),y=!0},p:Le,i(o){y||(h(l.$$.fragment,o),y=!0)},o(o){_(l.$$.fragment,o),y=!1},d(o){o&&(n(s),n(m)),b(l,o)}}}function Ut(U){let s,v,m,l,y,o,T,So='<a href="https://huggingface.co/papers/2501.03575" rel="nofollow">Cosmos World Foundation Model Platform for Physical AI</a> by NVIDIA.',Se,K,qo='<em>Physical AI needs to be trained digitally first. It needs a digital twin of itself, the policy model, and a digital twin of the world, the world model. In this paper, we present the Cosmos World Foundation Model Platform to help developers build customized world models for their Physical AI setups. We position a world foundation model as a general-purpose world model that can be fine-tuned into customized world models for downstream applications. Our platform covers a video curation pipeline, pre-trained world foundation models, examples of post-training of pre-trained world foundation models, and video tokenizers. To help Physical AI builders solve the most critical problems of our society, we make our platform open-source and our models open-weight with permissive licenses available via <a href="https://github.com/NVIDIA/Cosmos" rel="nofollow">https://github.com/NVIDIA/Cosmos</a>.</em>',qe,R,Ae,ee,Oe,x,oe,_o,Je,Ao='Pipeline for text-to-world generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict1" rel="nofollow">Cosmos Predict1</a>.',bo,xe,Oo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,yo,P,te,To,Ce,Ko="The call function to the pipeline for generation.",Mo,F,vo,L,ne,wo,Ie,et="Encodes the prompt into text encoder hidden states.",Ke,se,eo,C,ie,Jo,We,ot=`Pipeline for image-to-world and video-to-world generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict1" rel="nofollow">Cosmos
Predict-1</a>.`,xo,Ue,tt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Co,Z,ae,Io,Ze,nt="The call function to the pipeline for generation.",Wo,je,st="Examples:",Uo,E,Zo,Q,jo,D,re,Go,Ge,it="Encodes the prompt into text encoder hidden states.",oo,le,to,I,de,ko,ke,at='Pipeline for text-to-image generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict2" rel="nofollow">Cosmos Predict2</a>.',Vo,Ve,rt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Po,B,pe,Bo,Pe,lt="The call function to the pipeline for generation.",$o,S,No,q,ce,zo,Be,dt="Encodes the prompt into text encoder hidden states.",no,me,so,W,ge,Xo,$e,pt='Pipeline for video-to-world generation using <a href="https://github.com/nvidia-cosmos/cosmos-predict2" rel="nofollow">Cosmos Predict2</a>.',Ho,Ne,ct=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Yo,$,ue,Ro,ze,mt="The call function to the pipeline for generation.",Fo,A,Lo,O,fe,Eo,Xe,gt="Encodes the prompt into text encoder hidden states.",io,he,ao,X,_e,Qo,He,ut="Output class for Cosmos any-to-world/video pipelines.",ro,be,lo,H,ye,Do,Ye,ft="Output class for Cosmos any-to-image pipelines.",po,Te,co,Ee,mo;return y=new we({props:{title:"Cosmos",local:"cosmos",headingTag:"h1"}}),R=new Mt({props:{$$slots:{default:[wt]},$$scope:{ctx:U}}}),ee=new we({props:{title:"CosmosTextToWorldPipeline",local:"diffusers.CosmosTextToWorldPipeline",headingTag:"h2"}}),oe=new j({props:{name:"class diffusers.CosmosTextToWorldPipeline",anchor:"diffusers.CosmosTextToWorldPipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLCosmos"},{name:"scheduler",val:": EDMEulerScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.CosmosTextToWorldPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CosmosTextToWorldPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CosmosTextToWorldPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.CosmosTextToWorldPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.CosmosTextToWorldPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_cosmos#diffusers.AutoencoderKLCosmos">AutoencoderKLCosmos</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_text2world.py#L132"}}),te=new j({props:{name:"__call__",anchor:"diffusers.CosmosTextToWorldPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 704"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 121"},{name:"num_inference_steps",val:": int = 36"},{name:"guidance_scale",val:": float = 7.0"},{name:"fps",val:": int = 30"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>121</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>36</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
The frames per second of the generated video.`,name:"fps"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_text2world.py#L393",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosPipelineOutput</code> or <code>tuple</code></p>
`}}),F=new Qe({props:{anchor:"diffusers.CosmosTextToWorldPipeline.__call__.example",$$slots:{default:[Jt]},$$scope:{ctx:U}}}),ne=new j({props:{name:"encode_prompt",anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CosmosTextToWorldPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_text2world.py#L231"}}),se=new we({props:{title:"CosmosVideoToWorldPipeline",local:"diffusers.CosmosVideoToWorldPipeline",headingTag:"h2"}}),ie=new j({props:{name:"class diffusers.CosmosVideoToWorldPipeline",anchor:"diffusers.CosmosVideoToWorldPipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLCosmos"},{name:"scheduler",val:": EDMEulerScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.CosmosVideoToWorldPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CosmosVideoToWorldPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CosmosVideoToWorldPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.CosmosVideoToWorldPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.CosmosVideoToWorldPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_cosmos#diffusers.AutoencoderKLCosmos">AutoencoderKLCosmos</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_video2world.py#L175"}}),ae=new j({props:{name:"__call__",anchor:"diffusers.CosmosVideoToWorldPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"video",val:": typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 704"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 121"},{name:"num_inference_steps",val:": int = 36"},{name:"guidance_scale",val:": float = 7.0"},{name:"input_frames_guidance",val:": bool = False"},{name:"augment_sigma",val:": float = 0.001"},{name:"fps",val:": int = 30"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>121</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>36</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
The frames per second of the generated video.`,name:"fps"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_video2world.py#L505",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosPipelineOutput</code> or <code>tuple</code></p>
`}}),E=new Qe({props:{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.example",$$slots:{default:[xt]},$$scope:{ctx:U}}}),Q=new Qe({props:{anchor:"diffusers.CosmosVideoToWorldPipeline.__call__.example-2",$$slots:{default:[Ct]},$$scope:{ctx:U}}}),re=new j({props:{name:"encode_prompt",anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CosmosVideoToWorldPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos_video2world.py#L277"}}),le=new we({props:{title:"Cosmos2TextToImagePipeline",local:"diffusers.Cosmos2TextToImagePipeline",headingTag:"h2"}}),de=new j({props:{name:"class diffusers.Cosmos2TextToImagePipeline",anchor:"diffusers.Cosmos2TextToImagePipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2TextToImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.Cosmos2TextToImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.Cosmos2TextToImagePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.Cosmos2TextToImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.Cosmos2TextToImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_text2image.py#L135"}}),pe=new j({props:{name:"__call__",anchor:"diffusers.Cosmos2TextToImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 768"},{name:"width",val:": int = 1360"},{name:"num_inference_steps",val:": int = 35"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>768</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1360</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>35</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_text2image.py#L409",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosImagePipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosImagePipelineOutput</code> or <code>tuple</code></p>
`}}),S=new Qe({props:{anchor:"diffusers.Cosmos2TextToImagePipeline.__call__.example",$$slots:{default:[It]},$$scope:{ctx:U}}}),ce=new j({props:{name:"encode_prompt",anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_images_per_prompt"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.Cosmos2TextToImagePipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_text2image.py#L246"}}),me=new we({props:{title:"Cosmos2VideoToWorldPipeline",local:"diffusers.Cosmos2VideoToWorldPipeline",headingTag:"h2"}}),ge=new j({props:{name:"class diffusers.Cosmos2VideoToWorldPipeline",anchor:"diffusers.Cosmos2VideoToWorldPipeline",parameters:[{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": CosmosTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"safety_checker",val:": CosmosSafetyChecker = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2VideoToWorldPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Cosmos uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/google-t5/t5-11b" rel="nofollow">t5-11b</a> variant.`,name:"text_encoder"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cosmos_transformer3d#diffusers.CosmosTransformer3DModel">CosmosTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_video2world.py#L154"}}),ue=new j({props:{name:"__call__",anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"video",val:": typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 704"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 93"},{name:"num_inference_steps",val:": int = 35"},{name:"guidance_scale",val:": float = 7.0"},{name:"fps",val:": int = 16"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"sigma_conditioning",val:": float = 0.0001"}],parametersDescription:[{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The image to be used as a conditioning input for the video generation.`,name:"image"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The video to be used as a conditioning input for the video generation.`,name:"video"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>93</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>35</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>7.0</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, defaults to <code>16</code>) &#x2014;
The frames per second of the generated video.`,name:"fps"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>CosmosPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The maximum number of tokens in the prompt. If the prompt exceeds this length, it will be truncated. If
the prompt is shorter than this length, it will be padded.`,name:"max_sequence_length"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.sigma_conditioning",description:`<strong>sigma_conditioning</strong> (<code>float</code>, defaults to <code>0.0001</code>) &#x2014;
The sigma value used for scaling conditioning latents. Ideally, it should not be changed or should be
set to a small value close to zero.`,name:"sigma_conditioning"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_video2world.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>CosmosPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~CosmosPipelineOutput</code> or <code>tuple</code></p>
`}}),A=new Qe({props:{anchor:"diffusers.Cosmos2VideoToWorldPipeline.__call__.example",$$slots:{default:[Wt]},$$scope:{ctx:U}}}),fe=new j({props:{name:"encode_prompt",anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.Cosmos2VideoToWorldPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_cosmos2_video2world.py#L265"}}),he=new we({props:{title:"CosmosPipelineOutput",local:"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput",headingTag:"h2"}}),_e=new j({props:{name:"class diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput",anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_output.py#L14"}}),be=new we({props:{title:"CosmosImagePipelineOutput",local:"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput",headingTag:"h2"}}),ye=new j({props:{name:"class diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput",anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cosmos/pipeline_output.py#L29"}}),Te=new vt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cosmos.md"}}),{c(){s=d("meta"),v=i(),m=d("p"),l=i(),g(y.$$.fragment),o=i(),T=d("p"),T.innerHTML=So,Se=i(),K=d("p"),K.innerHTML=qo,qe=i(),g(R.$$.fragment),Ae=i(),g(ee.$$.fragment),Oe=i(),x=d("div"),g(oe.$$.fragment),_o=i(),Je=d("p"),Je.innerHTML=Ao,bo=i(),xe=d("p"),xe.innerHTML=Oo,yo=i(),P=d("div"),g(te.$$.fragment),To=i(),Ce=d("p"),Ce.textContent=Ko,Mo=i(),g(F.$$.fragment),vo=i(),L=d("div"),g(ne.$$.fragment),wo=i(),Ie=d("p"),Ie.textContent=et,Ke=i(),g(se.$$.fragment),eo=i(),C=d("div"),g(ie.$$.fragment),Jo=i(),We=d("p"),We.innerHTML=ot,xo=i(),Ue=d("p"),Ue.innerHTML=tt,Co=i(),Z=d("div"),g(ae.$$.fragment),Io=i(),Ze=d("p"),Ze.textContent=nt,Wo=i(),je=d("p"),je.textContent=st,Uo=i(),g(E.$$.fragment),Zo=i(),g(Q.$$.fragment),jo=i(),D=d("div"),g(re.$$.fragment),Go=i(),Ge=d("p"),Ge.textContent=it,oo=i(),g(le.$$.fragment),to=i(),I=d("div"),g(de.$$.fragment),ko=i(),ke=d("p"),ke.innerHTML=at,Vo=i(),Ve=d("p"),Ve.innerHTML=rt,Po=i(),B=d("div"),g(pe.$$.fragment),Bo=i(),Pe=d("p"),Pe.textContent=lt,$o=i(),g(S.$$.fragment),No=i(),q=d("div"),g(ce.$$.fragment),zo=i(),Be=d("p"),Be.textContent=dt,no=i(),g(me.$$.fragment),so=i(),W=d("div"),g(ge.$$.fragment),Xo=i(),$e=d("p"),$e.innerHTML=pt,Ho=i(),Ne=d("p"),Ne.innerHTML=ct,Yo=i(),$=d("div"),g(ue.$$.fragment),Ro=i(),ze=d("p"),ze.textContent=mt,Fo=i(),g(A.$$.fragment),Lo=i(),O=d("div"),g(fe.$$.fragment),Eo=i(),Xe=d("p"),Xe.textContent=gt,io=i(),g(he.$$.fragment),ao=i(),X=d("div"),g(_e.$$.fragment),Qo=i(),He=d("p"),He.textContent=ut,ro=i(),g(be.$$.fragment),lo=i(),H=d("div"),g(ye.$$.fragment),Do=i(),Ye=d("p"),Ye.textContent=ft,po=i(),g(Te.$$.fragment),co=i(),Ee=d("p"),this.h()},l(e){const r=Tt("svelte-u9bgzb",document.head);s=p(r,"META",{name:!0,content:!0}),r.forEach(n),v=a(e),m=p(e,"P",{}),w(m).forEach(n),l=a(e),u(y.$$.fragment,e),o=a(e),T=p(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1vce33m"&&(T.innerHTML=So),Se=a(e),K=p(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-191cpbh"&&(K.innerHTML=qo),qe=a(e),u(R.$$.fragment,e),Ae=a(e),u(ee.$$.fragment,e),Oe=a(e),x=p(e,"DIV",{class:!0});var G=w(x);u(oe.$$.fragment,G),_o=a(G),Je=p(G,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-fc8im0"&&(Je.innerHTML=Ao),bo=a(G),xe=p(G,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-496sm0"&&(xe.innerHTML=Oo),yo=a(G),P=p(G,"DIV",{class:!0});var Y=w(P);u(te.$$.fragment,Y),To=a(Y),Ce=p(Y,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-50j04k"&&(Ce.textContent=Ko),Mo=a(Y),u(F.$$.fragment,Y),Y.forEach(n),vo=a(G),L=p(G,"DIV",{class:!0});var Me=w(L);u(ne.$$.fragment,Me),wo=a(Me),Ie=p(Me,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-16q0ax1"&&(Ie.textContent=et),Me.forEach(n),G.forEach(n),Ke=a(e),u(se.$$.fragment,e),eo=a(e),C=p(e,"DIV",{class:!0});var k=w(C);u(ie.$$.fragment,k),Jo=a(k),We=p(k,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1la8oug"&&(We.innerHTML=ot),xo=a(k),Ue=p(k,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-496sm0"&&(Ue.innerHTML=tt),Co=a(k),Z=p(k,"DIV",{class:!0});var V=w(Z);u(ae.$$.fragment,V),Io=a(V),Ze=p(V,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-50j04k"&&(Ze.textContent=nt),Wo=a(V),je=p(V,"P",{"data-svelte-h":!0}),M(je)!=="svelte-kvfsh7"&&(je.textContent=st),Uo=a(V),u(E.$$.fragment,V),Zo=a(V),u(Q.$$.fragment,V),V.forEach(n),jo=a(k),D=p(k,"DIV",{class:!0});var ve=w(D);u(re.$$.fragment,ve),Go=a(ve),Ge=p(ve,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-16q0ax1"&&(Ge.textContent=it),ve.forEach(n),k.forEach(n),oo=a(e),u(le.$$.fragment,e),to=a(e),I=p(e,"DIV",{class:!0});var N=w(I);u(de.$$.fragment,N),ko=a(N),ke=p(N,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-zibt59"&&(ke.innerHTML=at),Vo=a(N),Ve=p(N,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-496sm0"&&(Ve.innerHTML=rt),Po=a(N),B=p(N,"DIV",{class:!0});var Re=w(B);u(pe.$$.fragment,Re),Bo=a(Re),Pe=p(Re,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-50j04k"&&(Pe.textContent=lt),$o=a(Re),u(S.$$.fragment,Re),Re.forEach(n),No=a(N),q=p(N,"DIV",{class:!0});var go=w(q);u(ce.$$.fragment,go),zo=a(go),Be=p(go,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-16q0ax1"&&(Be.textContent=dt),go.forEach(n),N.forEach(n),no=a(e),u(me.$$.fragment,e),so=a(e),W=p(e,"DIV",{class:!0});var z=w(W);u(ge.$$.fragment,z),Xo=a(z),$e=p(z,"P",{"data-svelte-h":!0}),M($e)!=="svelte-zw12d0"&&($e.innerHTML=pt),Ho=a(z),Ne=p(z,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-496sm0"&&(Ne.innerHTML=ct),Yo=a(z),$=p(z,"DIV",{class:!0});var Fe=w($);u(ue.$$.fragment,Fe),Ro=a(Fe),ze=p(Fe,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-50j04k"&&(ze.textContent=mt),Fo=a(Fe),u(A.$$.fragment,Fe),Fe.forEach(n),Lo=a(z),O=p(z,"DIV",{class:!0});var uo=w(O);u(fe.$$.fragment,uo),Eo=a(uo),Xe=p(uo,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-16q0ax1"&&(Xe.textContent=gt),uo.forEach(n),z.forEach(n),io=a(e),u(he.$$.fragment,e),ao=a(e),X=p(e,"DIV",{class:!0});var fo=w(X);u(_e.$$.fragment,fo),Qo=a(fo),He=p(fo,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1da849m"&&(He.textContent=ut),fo.forEach(n),ro=a(e),u(be.$$.fragment,e),lo=a(e),H=p(e,"DIV",{class:!0});var ho=w(H);u(ye.$$.fragment,ho),Do=a(ho),Ye=p(ho,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-duwse9"&&(Ye.textContent=ft),ho.forEach(n),po=a(e),u(Te.$$.fragment,e),co=a(e),Ee=p(e,"P",{}),w(Ee).forEach(n),this.h()},h(){J(s,"name","hf:doc:metadata"),J(s,"content",Zt),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,s),c(e,v,r),c(e,m,r),c(e,l,r),f(y,e,r),c(e,o,r),c(e,T,r),c(e,Se,r),c(e,K,r),c(e,qe,r),f(R,e,r),c(e,Ae,r),f(ee,e,r),c(e,Oe,r),c(e,x,r),f(oe,x,null),t(x,_o),t(x,Je),t(x,bo),t(x,xe),t(x,yo),t(x,P),f(te,P,null),t(P,To),t(P,Ce),t(P,Mo),f(F,P,null),t(x,vo),t(x,L),f(ne,L,null),t(L,wo),t(L,Ie),c(e,Ke,r),f(se,e,r),c(e,eo,r),c(e,C,r),f(ie,C,null),t(C,Jo),t(C,We),t(C,xo),t(C,Ue),t(C,Co),t(C,Z),f(ae,Z,null),t(Z,Io),t(Z,Ze),t(Z,Wo),t(Z,je),t(Z,Uo),f(E,Z,null),t(Z,Zo),f(Q,Z,null),t(C,jo),t(C,D),f(re,D,null),t(D,Go),t(D,Ge),c(e,oo,r),f(le,e,r),c(e,to,r),c(e,I,r),f(de,I,null),t(I,ko),t(I,ke),t(I,Vo),t(I,Ve),t(I,Po),t(I,B),f(pe,B,null),t(B,Bo),t(B,Pe),t(B,$o),f(S,B,null),t(I,No),t(I,q),f(ce,q,null),t(q,zo),t(q,Be),c(e,no,r),f(me,e,r),c(e,so,r),c(e,W,r),f(ge,W,null),t(W,Xo),t(W,$e),t(W,Ho),t(W,Ne),t(W,Yo),t(W,$),f(ue,$,null),t($,Ro),t($,ze),t($,Fo),f(A,$,null),t(W,Lo),t(W,O),f(fe,O,null),t(O,Eo),t(O,Xe),c(e,io,r),f(he,e,r),c(e,ao,r),c(e,X,r),f(_e,X,null),t(X,Qo),t(X,He),c(e,ro,r),f(be,e,r),c(e,lo,r),c(e,H,r),f(ye,H,null),t(H,Do),t(H,Ye),c(e,po,r),f(Te,e,r),c(e,co,r),c(e,Ee,r),mo=!0},p(e,[r]){const G={};r&2&&(G.$$scope={dirty:r,ctx:e}),R.$set(G);const Y={};r&2&&(Y.$$scope={dirty:r,ctx:e}),F.$set(Y);const Me={};r&2&&(Me.$$scope={dirty:r,ctx:e}),E.$set(Me);const k={};r&2&&(k.$$scope={dirty:r,ctx:e}),Q.$set(k);const V={};r&2&&(V.$$scope={dirty:r,ctx:e}),S.$set(V);const ve={};r&2&&(ve.$$scope={dirty:r,ctx:e}),A.$set(ve)},i(e){mo||(h(y.$$.fragment,e),h(R.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(te.$$.fragment,e),h(F.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(S.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(A.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),mo=!0)},o(e){_(y.$$.fragment,e),_(R.$$.fragment,e),_(ee.$$.fragment,e),_(oe.$$.fragment,e),_(te.$$.fragment,e),_(F.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(ae.$$.fragment,e),_(E.$$.fragment,e),_(Q.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(S.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(A.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),mo=!1},d(e){e&&(n(v),n(m),n(l),n(o),n(T),n(Se),n(K),n(qe),n(Ae),n(Oe),n(x),n(Ke),n(eo),n(C),n(oo),n(to),n(I),n(no),n(so),n(W),n(io),n(ao),n(X),n(ro),n(lo),n(H),n(po),n(co),n(Ee)),n(s),b(y,e),b(R,e),b(ee,e),b(oe),b(te),b(F),b(ne),b(se,e),b(ie),b(ae),b(E),b(Q),b(re),b(le,e),b(de),b(pe),b(S),b(ce),b(me,e),b(ge),b(ue),b(A),b(fe),b(he,e),b(_e),b(be,e),b(ye),b(Te,e)}}}const Zt='{"title":"Cosmos","local":"cosmos","sections":[{"title":"CosmosTextToWorldPipeline","local":"diffusers.CosmosTextToWorldPipeline","sections":[],"depth":2},{"title":"CosmosVideoToWorldPipeline","local":"diffusers.CosmosVideoToWorldPipeline","sections":[],"depth":2},{"title":"Cosmos2TextToImagePipeline","local":"diffusers.Cosmos2TextToImagePipeline","sections":[],"depth":2},{"title":"Cosmos2VideoToWorldPipeline","local":"diffusers.Cosmos2VideoToWorldPipeline","sections":[],"depth":2},{"title":"CosmosPipelineOutput","local":"diffusers.pipelines.cosmos.pipeline_output.CosmosPipelineOutput","sections":[],"depth":2},{"title":"CosmosImagePipelineOutput","local":"diffusers.pipelines.cosmos.pipeline_output.CosmosImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function jt(U){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends bt{constructor(s){super(),yt(this,s,jt,Ut,ht,{})}}export{zt as component};
