import{s as Ul,o as jl,n as wl}from"../chunks/scheduler.8c3d61f6.js";import{S as Zl,i as Gl,g as y,s as m,r as b,A as gl,h as d,f as t,c,j as bl,u as h,x as f,k as hl,y as Bl,a,v as T,d as w,t as U,w as j}from"../chunks/index.da70eac4.js";import{C as sl}from"../chunks/CodeBlock.a9c4becf.js";import{H as ol,E as Il}from"../chunks/getInferenceSnippets.86beaec3.js";import{H as Wl,a as Tl}from"../chunks/HfOption.6ab18950.js";function _l(G){let s,u='<a href="./memory#model-offloading">Model CPU offloading</a> moves an individual pipeline component, like the transformer model, to the GPU when it is needed for computation. Otherwise, it is offloaded to the CPU.',p,i,n;return i=new sl({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXRvcmNoLl9keW5hbW8uY29uZmlnLmNhY2hlX3NpemVfbGltaXQlMjAlM0QlMjAxMDAwJTBBdG9yY2guX2R5bmFtby5jb25maWcuY2FwdHVyZV9keW5hbWljX291dHB1dF9zaGFwZV9vcHMlMjAlM0QlMjBUcnVlJTBBJTBBJTIzJTIwcXVhbnRpemUlMEFwaXBlbGluZV9xdWFudF9jb25maWclMjAlM0QlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBxdWFudF9iYWNrZW5kJTNEJTIyYml0c2FuZGJ5dGVzXzRiaXQlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudF9rd2FyZ3MlM0QlN0IlMjJsb2FkX2luXzRiaXQlMjIlM0ElMjBUcnVlJTJDJTIwJTIyYm5iXzRiaXRfcXVhbnRfdHlwZSUyMiUzQSUyMCUyMm5mNCUyMiUyQyUyMCUyMmJuYl80Yml0X2NvbXB1dGVfZHR5cGUlMjIlM0ElMjB0b3JjaC5iZmxvYXQxNiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXBvbmVudHNfdG9fcXVhbnRpemUlM0QlNUIlMjJ0cmFuc2Zvcm1lciUyMiUyQyUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTVEJTJDJTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMG1vZGVsJTIwQ1BVJTIwb2ZmbG9hZGluZyUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwY29tcGlsZSUwQXBpcGVsaW5lLnRyYW5zZm9ybWVyLmNvbXBpbGUoKSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIyJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

torch._dynamo.config.cache_size_limit = <span class="hljs-number">1000</span>
torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># model CPU offloading</span>
pipeline.enable_model_cpu_offload()

<span class="hljs-comment"># compile</span>
pipeline.transformer.<span class="hljs-built_in">compile</span>()
pipeline(
    <span class="hljs-string">&quot;cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=y("p"),s.innerHTML=u,p=m(),b(i.$$.fragment)},l(o){s=d(o,"P",{"data-svelte-h":!0}),f(s)!=="svelte-2htktv"&&(s.innerHTML=u),p=c(o),h(i.$$.fragment,o)},m(o,r){a(o,s,r),a(o,p,r),T(i,o,r),n=!0},p:wl,i(o){n||(w(i.$$.fragment,o),n=!0)},o(o){U(i.$$.fragment,o),n=!1},d(o){o&&(t(s),t(p)),j(i,o)}}}function vl(G){let s,u='<a href="./memory#group-offloading">Group offloading</a> moves the internal layers of an individual pipeline component, like the transformer model, to the GPU for computation and offloads it when it’s not required. At the same time, it uses the <a href="./memory#cuda-stream">CUDA stream</a> feature to prefetch the next layer for execution.',p,i,n="By overlapping computation and data transfer, it is faster than model CPU offloading while also saving memory.",o,r,Z;return r=new sl({props:{code:"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",highlighted:`<span class="hljs-comment"># pip install ftfy</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UMT5EncoderModel

torch._dynamo.config.cache_size_limit = <span class="hljs-number">1000</span>
torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder&quot;</span>],
)

text_encoder = UMT5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># group offloading</span>
onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

pipeline.transformer.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)
pipeline.vae.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)
apply_group_offloading(
    pipeline.text_encoder,
    onload_device=onload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># compile</span>
pipeline.transformer.<span class="hljs-built_in">compile</span>()

prompt = <span class="hljs-string">&quot;&quot;&quot;
The camera rushes from far to near in a low-angle shot, 
revealing a white ferret on a log. It plays, leaps into the water, and emerges, as the camera zooms in 
for a close-up. Water splashes berry bushes nearby, while moss, snow, and leaves blanket the ground. 
Birch trees and a light blue sky frame the scene, with ferns in the foreground. Side lighting casts dynamic 
shadows and warm highlights. Medium composition, front view, low angle, with depth of field.
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;&quot;
Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, 
low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, 
misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards
&quot;&quot;&quot;</span>

output = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_frames=<span class="hljs-number">81</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){s=y("p"),s.innerHTML=u,p=m(),i=y("p"),i.textContent=n,o=m(),b(r.$$.fragment)},l(M){s=d(M,"P",{"data-svelte-h":!0}),f(s)!=="svelte-h38yli"&&(s.innerHTML=u),p=c(M),i=d(M,"P",{"data-svelte-h":!0}),f(i)!=="svelte-1f0mtjr"&&(i.textContent=n),o=c(M),h(r.$$.fragment,M)},m(M,J){a(M,s,J),a(M,p,J),a(M,i,J),a(M,o,J),T(r,M,J),Z=!0},p:wl,i(M){Z||(w(r.$$.fragment,M),Z=!0)},o(M){U(r.$$.fragment,M),Z=!1},d(M){M&&(t(s),t(p),t(i),t(o)),j(r,M)}}}function Xl(G){let s,u,p,i;return s=new Tl({props:{id:"offloading",option:"model CPU offloading",$$slots:{default:[_l]},$$scope:{ctx:G}}}),p=new Tl({props:{id:"offloading",option:"group offloading",$$slots:{default:[vl]},$$scope:{ctx:G}}}),{c(){b(s.$$.fragment),u=m(),b(p.$$.fragment)},l(n){h(s.$$.fragment,n),u=c(n),h(p.$$.fragment,n)},m(n,o){T(s,n,o),a(n,u,o),T(p,n,o),i=!0},p(n,o){const r={};o&2&&(r.$$scope={dirty:o,ctx:n}),s.$set(r);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:n}),p.$set(Z)},i(n){i||(w(s.$$.fragment,n),w(p.$$.fragment,n),i=!0)},o(n){U(s.$$.fragment,n),U(p.$$.fragment,n),i=!1},d(n){n&&t(u),j(s,n),j(p,n)}}}function Vl(G){let s,u,p,i,n,o,r,Z='Optimizing models often involves trade-offs between <a href="./fp16">inference speed</a> and <a href="./memory">memory-usage</a>. For instance, while <a href="./cache">caching</a> can boost inference speed, it also increases memory consumption since it needs to store the outputs of intermediate attention layers. A more balanced optimization strategy combines quantizing a model, <a href="./fp16#torchcompile">torch.compile</a> and various <a href="./memory#offloading">offloading methods</a>.',M,J,il='For image generation, combining quantization and <a href="./memory#model-offloading">model offloading</a> can often give the best trade-off between quality, speed, and memory. Group offloading is not as effective for image generation because it is usually not possible to <em>fully</em> overlap data transfer if the compute kernel finishes faster. This results in some communication overhead between the CPU and GPU.',E,B,pl='For video generation, combining quantization and <a href="./memory#group-offloading">group-offloading</a> tends to be better because video models are more compute-bound.',N,I,ml="The table below provides a comparison of optimization strategy combinations and their impact on latency and memory-usage for Flux.",$,W,cl="<thead><tr><th>combination</th> <th>latency (s)</th> <th>memory-usage (GB)</th></tr></thead> <tbody><tr><td>quantization</td> <td>32.602</td> <td>14.9453</td></tr> <tr><td>quantization, torch.compile</td> <td>25.847</td> <td>14.9448</td></tr> <tr><td>quantization, torch.compile, model CPU offloading</td> <td>32.312</td> <td>12.2369</td></tr></tbody>",H,_,Ml='These results are benchmarked on Flux with a RTX 4090. The transformer and text_encoder components are quantized. Refer to the <a href="https://gist.github.com/sayakpaul/0db9d8eeeb3d2a0e5ed7cf0d9ca19b7d" benchmarking="" script<="" a="">if you&#39;re interested in evaluating your own model.</a>',x,v,rl='This guide will show you how to compile and offload a quantized model with <a href="../quantization/bitsandbytes#torchcompile">bitsandbytes</a>. Make sure you are using <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch nightly</a> and the latest version of bitsandbytes.',S,X,A,V,L,C,yl='Start by <a href="../quantization/overview">quantizing</a> a model to reduce the memory required for storage and <a href="./fp16#torchcompile">compiling</a> it to accelerate inference.',D,Y,dl='Configure the <a href="https://docs.pytorch.org/docs/stable/torch.compiler_dynamo_overview.html" rel="nofollow">Dynamo</a> <code>capture_dynamic_output_shape_ops = True</code> to handle dynamic outputs when compiling bitsandbytes models.',P,R,K,k,O,q,ul="In addition to quantization and torch.compile, try offloading if you need to reduce memory-usage further. Offloading moves various layers or model components from the CPU to the GPU as needed for computations.",ll,Q,fl='Configure the <a href="https://docs.pytorch.org/docs/stable/torch.compiler_dynamo_overview.html" rel="nofollow">Dynamo</a> <code>cache_size_limit</code> during offloading to avoid excessive recompilation and set <code>capture_dynamic_output_shape_ops = True</code> to handle dynamic outputs when compiling bitsandbytes models.',el,g,tl,F,al,z,nl;return n=new ol({props:{title:"Compile and offloading quantized models",local:"compile-and-offloading-quantized-models",headingTag:"h1"}}),X=new sl({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),V=new ol({props:{title:"Quantization and torch.compile",local:"quantization-and-torchcompile",headingTag:"h2"}}),R=new sl({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXRvcmNoLl9keW5hbW8uY29uZmlnLmNhcHR1cmVfZHluYW1pY19vdXRwdXRfc2hhcGVfb3BzJTIwJTNEJTIwVHJ1ZSUwQSUwQSUyMyUyMHF1YW50aXplJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfYmFja2VuZCUzRCUyMmJpdHNhbmRieXRlc180Yml0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRfa3dhcmdzJTNEJTdCJTIybG9hZF9pbl80Yml0JTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMmJuYl80Yml0X3F1YW50X3R5cGUlMjIlM0ElMjAlMjJuZjQlMjIlMkMlMjAlMjJibmJfNGJpdF9jb21wdXRlX2R0eXBlJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlN0QlMkMlMEElMjAlMjAlMjAlMjBjb21wb25lbnRzX3RvX3F1YW50aXplJTNEJTVCJTIydHJhbnNmb3JtZXIlMjIlMkMlMjAlMjJ0ZXh0X2VuY29kZXJfMiUyMiU1RCUyQyUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBjb21waWxlJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIuY29tcGlsZShtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlbGluZSglMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQSUyMCUyMCUyMCUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># compile</span>
pipeline.transformer.to(memory_format=torch.channels_last)
pipeline.transformer.<span class="hljs-built_in">compile</span>(mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipeline(<span class="hljs-string">&quot;&quot;&quot;
    cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
    highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),k=new ol({props:{title:"Quantization, torch.compile, and offloading",local:"quantization-torchcompile-and-offloading",headingTag:"h2"}}),g=new Wl({props:{id:"offloading",options:["model CPU offloading","group offloading"],$$slots:{default:[Xl]},$$scope:{ctx:G}}}),F=new Il({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/speed-memory-optims.md"}}),{c(){s=y("meta"),u=m(),p=y("p"),i=m(),b(n.$$.fragment),o=m(),r=y("p"),r.innerHTML=Z,M=m(),J=y("p"),J.innerHTML=il,E=m(),B=y("p"),B.innerHTML=pl,N=m(),I=y("p"),I.textContent=ml,$=m(),W=y("table"),W.innerHTML=cl,H=m(),_=y("small"),_.innerHTML=Ml,x=m(),v=y("p"),v.innerHTML=rl,S=m(),b(X.$$.fragment),A=m(),b(V.$$.fragment),L=m(),C=y("p"),C.innerHTML=yl,D=m(),Y=y("p"),Y.innerHTML=dl,P=m(),b(R.$$.fragment),K=m(),b(k.$$.fragment),O=m(),q=y("p"),q.textContent=ul,ll=m(),Q=y("p"),Q.innerHTML=fl,el=m(),b(g.$$.fragment),tl=m(),b(F.$$.fragment),al=m(),z=y("p"),this.h()},l(l){const e=gl("svelte-u9bgzb",document.head);s=d(e,"META",{name:!0,content:!0}),e.forEach(t),u=c(l),p=d(l,"P",{}),bl(p).forEach(t),i=c(l),h(n.$$.fragment,l),o=c(l),r=d(l,"P",{"data-svelte-h":!0}),f(r)!=="svelte-xssjno"&&(r.innerHTML=Z),M=c(l),J=d(l,"P",{"data-svelte-h":!0}),f(J)!=="svelte-1k9tg08"&&(J.innerHTML=il),E=c(l),B=d(l,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1gtsmte"&&(B.innerHTML=pl),N=c(l),I=d(l,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1hx16oz"&&(I.textContent=ml),$=c(l),W=d(l,"TABLE",{"data-svelte-h":!0}),f(W)!=="svelte-4braeo"&&(W.innerHTML=cl),H=c(l),_=d(l,"SMALL",{"data-svelte-h":!0}),f(_)!=="svelte-1ams1gg"&&(_.innerHTML=Ml),x=c(l),v=d(l,"P",{"data-svelte-h":!0}),f(v)!=="svelte-97u2df"&&(v.innerHTML=rl),S=c(l),h(X.$$.fragment,l),A=c(l),h(V.$$.fragment,l),L=c(l),C=d(l,"P",{"data-svelte-h":!0}),f(C)!=="svelte-1blxhao"&&(C.innerHTML=yl),D=c(l),Y=d(l,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-xwvm0e"&&(Y.innerHTML=dl),P=c(l),h(R.$$.fragment,l),K=c(l),h(k.$$.fragment,l),O=c(l),q=d(l,"P",{"data-svelte-h":!0}),f(q)!=="svelte-2st498"&&(q.textContent=ul),ll=c(l),Q=d(l,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-136cwt1"&&(Q.innerHTML=fl),el=c(l),h(g.$$.fragment,l),tl=c(l),h(F.$$.fragment,l),al=c(l),z=d(l,"P",{}),bl(z).forEach(t),this.h()},h(){hl(s,"name","hf:doc:metadata"),hl(s,"content",Cl)},m(l,e){Bl(document.head,s),a(l,u,e),a(l,p,e),a(l,i,e),T(n,l,e),a(l,o,e),a(l,r,e),a(l,M,e),a(l,J,e),a(l,E,e),a(l,B,e),a(l,N,e),a(l,I,e),a(l,$,e),a(l,W,e),a(l,H,e),a(l,_,e),a(l,x,e),a(l,v,e),a(l,S,e),T(X,l,e),a(l,A,e),T(V,l,e),a(l,L,e),a(l,C,e),a(l,D,e),a(l,Y,e),a(l,P,e),T(R,l,e),a(l,K,e),T(k,l,e),a(l,O,e),a(l,q,e),a(l,ll,e),a(l,Q,e),a(l,el,e),T(g,l,e),a(l,tl,e),T(F,l,e),a(l,al,e),a(l,z,e),nl=!0},p(l,[e]){const Jl={};e&2&&(Jl.$$scope={dirty:e,ctx:l}),g.$set(Jl)},i(l){nl||(w(n.$$.fragment,l),w(X.$$.fragment,l),w(V.$$.fragment,l),w(R.$$.fragment,l),w(k.$$.fragment,l),w(g.$$.fragment,l),w(F.$$.fragment,l),nl=!0)},o(l){U(n.$$.fragment,l),U(X.$$.fragment,l),U(V.$$.fragment,l),U(R.$$.fragment,l),U(k.$$.fragment,l),U(g.$$.fragment,l),U(F.$$.fragment,l),nl=!1},d(l){l&&(t(u),t(p),t(i),t(o),t(r),t(M),t(J),t(E),t(B),t(N),t(I),t($),t(W),t(H),t(_),t(x),t(v),t(S),t(A),t(L),t(C),t(D),t(Y),t(P),t(K),t(O),t(q),t(ll),t(Q),t(el),t(tl),t(al),t(z)),t(s),j(n,l),j(X,l),j(V,l),j(R,l),j(k,l),j(g,l),j(F,l)}}}const Cl='{"title":"Compile and offloading quantized models","local":"compile-and-offloading-quantized-models","sections":[{"title":"Quantization and torch.compile","local":"quantization-and-torchcompile","sections":[],"depth":2},{"title":"Quantization, torch.compile, and offloading","local":"quantization-torchcompile-and-offloading","sections":[],"depth":2}],"depth":1}';function Yl(G){return jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends Zl{constructor(s){super(),Gl(this,s,Yl,Vl,Ul,{})}}export{zl as component};
